package gov.va.cpss.cobol;

import java.beans.PropertyEditorSupport;

import org.apache.log4j.Logger;

/**
 * Custom property editor used by BeanWrapperFieldSetMapper to construct Cobol number
 * formated Money object during batch processing processing of FixedLengthTokenizer of
 * FlatFileItemReader.
 * 
 * @author DNS  
 */
public class MoneyEditor extends PropertyEditorSupport {

    private final Logger moneyLogger;

    public MoneyEditor() {
        moneyLogger = Logger.getLogger(this.getClass().getCanonicalName());
    }

    @Override
    public void setAsText(String text) {
        try {
            setValue(new Money(text));
        } catch (NumberFormatException e) {
            moneyLogger.error("Caught exception: " + e.getMessage());
            throw (e);
        }
    }
}
