package gov.va.med.pharmacy.persistence.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;

import gov.va.med.pharmacy.persistence.dao.PharmacyDao;
import gov.va.med.pharmacy.persistence.managepharmacy.ManagePharmacyFilter;
import gov.va.med.pharmacy.persistence.model.PharmacyEntity;
import gov.va.med.pharmacy.persistence.service.PharmacyService;

@Service("pharmacyService")
@Transactional
public class PharmacyServiceImpl implements PharmacyService {

	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(PharmacyServiceImpl.class);

	@Autowired
	private PharmacyDao pharmacyDao;

	@Override
	public List<PharmacyEntity> find(ManagePharmacyFilter managePharmacyFilter) throws Exception {

		List<PharmacyEntity> pharmacies = new ArrayList<PharmacyEntity>();


		try {

			pharmacies = pharmacyDao.find(managePharmacyFilter);
			
		

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return pharmacies;
	}

	@Override
	public PharmacyEntity findByNCPDPId(String NCPDPId) {

		PharmacyEntity pharmacyEntity = new PharmacyEntity();

		try {

			pharmacyEntity = pharmacyDao.findByNCPDPId(NCPDPId);			

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return pharmacyEntity;
	}

	@Override
	public void savePharmacyInfo(PharmacyEntity pharmacy) throws HibernateException {

		try {
			pharmacyDao.save(pharmacy);

		} catch (HibernateException e) {

			throw new HibernateException(e);
		}

		LOG.info("saved pharmacy information.");
	}

	@Override
	public PharmacyEntity findById(Long pharmacyId) throws Exception {

		PharmacyEntity pharmacyEntity = new PharmacyEntity();

		try {
			
			pharmacyEntity = pharmacyDao.findById(pharmacyId);
 
			 // filteredPharmacyEntity = filterPharmacyEntityForXSS(filteredPharmacyEntity, pharmacy);

		} catch (Exception e) {

			throw new Exception(e);
		}

		return pharmacyEntity;

	}

	@Override
	public void updatePharmacyInfo(PharmacyEntity pharmacy) throws HibernateException {
		try {
			pharmacyDao.updatePharmacyInfo(pharmacy);

		} catch (HibernateException e) {

			throw new HibernateException(e);
		}

		LOG.info("updated pharmacy information.");
	}

	@Override
	public List<PharmacyEntity> getAllStations() {

		return pharmacyDao.getAllStations();
	}

	@Override
	public List<PharmacyEntity> queryForExport(ManagePharmacyFilter managePharmacyFilter, List<String> userStationIds) {

		return pharmacyDao.queryForExport(managePharmacyFilter, userStationIds);
	}

	@Override
	public List<PharmacyEntity> getStationIdsByVisn(String visn) {

		return pharmacyDao.getPharmacyStationIdsByVisn(visn);
	}

	@Override
	public List<PharmacyEntity> getSelectedStationIdsByVisn(String visn, List<String> userStationIds) {

		return pharmacyDao.getSelectedStationIdsByVisn(visn, userStationIds);
	}

	@Override
	public List<PharmacyEntity> findSelectedPharmacies(ManagePharmacyFilter managePharmacyFilter, List<String> userStationIds) {

		return pharmacyDao.findSelectedPharmacies(managePharmacyFilter, userStationIds);
	}

	
}
