package gov.va.med.pharmacy.web.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import gov.va.med.pharmacy.utility.ESAPIValidationType;
import gov.va.med.pharmacy.utility.ESAPIValidator;
import gov.va.med.pharmacy.web.Constants;
@Controller
public class LogoutController {

    @RequestMapping(value = "/logout")
    public ModelAndView logout(HttpServletRequest request) {

        HttpSession session = request.getSession(false);
        
        String logoutURL=  ESAPIValidator.validateStringInput((String) session.getAttribute(Constants.SSOI_LANDING_URL), ESAPIValidationType.IAM_LOGOUT_URL);
        
        session.removeAttribute(Constants.SESSION_USER);
        
        session.invalidate();
       
        String logoutMessage;
        

        logoutMessage = "You have been logged out of the Inbound eRx application.";
        
       
        
        if(logoutURL!=null){
        	
        	return new ModelAndView("redirect:"+logoutURL);
        }
        else{
        	
        	 return new ModelAndView("logout", "logoutMessage", logoutMessage);
        }
        
       
    }
    
   
   
}
