dojo.require("dojo.hash");
dojo.require("dijit.registry")


var clearClicked = false;

dojo.ready(function() {

	
	require(["dojo/on", "dojo/domReady!"], function(on) {
	    on(document, "keyup", function(event) {
	        if (event.keyCode == '13'){	
	        	
	        	
                event.preventDefault(); 
		        
                return pharmacyManagementActions(null);
	        }
	        else{
	        	
	        	clearClicked = false;
	        }
	    });
	});

			
});	

function getPharmacyGrid() {
	var formId = "pharmacyFilterForm";
	var formObject = dojo.formToObject(formId);
	
	dojo.style(dojo.byId('pharmMgmtRecNumberTitle'), "display", "block");
	dojo.style(dojo.byId('pharmMgmtRecNumber'), "display", "block");
	
	var dataSourceURL = "/inbound/inb-erx/managePharm/getPharmacyList?json=" + dojo.toJson(formObject);
	
	try {
		 
		dojo.xhrGet({
	        url: dataSourceURL,
	        handleAs: "json", 
	        load: function(data, ioArgs) {
	        	pharmacyDataGridInit("inb-erx","pharmacyList",  data);	           
	        },
	        error: function(error) {
	            console.log("loading of pharmacy data failed. Exception...", error);
	        }
	    });		
		
		dojo.style(dojo.byId('pharmacyListDummy'), "display", "none");
		dojo.style(dojo.byId('pharmacyList'), "display", "block");
		
		
	} catch (err) {
		alert(err.message);
	}
	
}


function buildVisnSelectDataSource(dataSourceURL, query) {
	try {
		var dataSource = new dojox.data.JsonQueryRestStore({
			target : dataSourceURL,
			idAttribute : "id"
		});		
		return dataSource;
	} catch (err) {
		alert(err.message);
	}
}

function getPharmVisnSelect(servlet, parentContainer, dataSourceURL) {
	try {
		var selectData = buildVisnSelectDataSource("/inbound/" + servlet + "/" + dataSourceURL);
			
		var selectId = parentContainer + 'Select';
		
		var select = dijit.byId(selectId);

		// If the select already exists, just clear any selected rows and
		// replace the store.
		if (select != null) {
			if (select.selection != null) {
				select.selection.clear();
			}
			select.setStore(selectData);
				
		} else {
			// select does not exist.
			select = new dijit.form.Select({
				id : selectId,
				name: "visn",
				style: "width:40px;",
				sortByLabel : false,
				onFetchError : gridFetchError
			}, "pharmacyFilterFormVisnSelect");
		
			select.setStore(selectData);
			
			select.on('change', function(evt) {		
				getPharmStationIdSelect();
				    });
						
			select.startup();
			
		}
	} catch (err) {
		var txt = "An error occured while building the selectList.  The error is: "
				+ err.message + ".";
		alert(txt);
	}

}



function pharmManagementSearch() {
	
	getPharmacyGrid();
	
	 
}

function clearPharmSearch() {
	
	var pharmVisnBox = dijit.byId("pharmacyFilterFormSelect");
	
	pharmVisnBox.reset();
	
	pharmVisnBox.set("value", 'All');
	
	dojo.style(dojo.byId('pharmacyList'), "display", "none");
	dojo.style(dojo.byId('pharmacyListDummy'), "display", "block");
	dojo.style(dojo.byId('pharmMgmtRecNumberTitle'), "display", "none");
	dojo.style(dojo.byId('pharmMgmtRecNumber'), "display", "none");
	
	if (dojo.byId('pharmacyManagementSuccessMessages') != null){
		 
		dojo.byId('pharmacyManagementSuccessMessages').innerHTML ="";
	}
	
	
	
	dojo.byId('ncpdpId').value="";
	dojo.byId('pharmacyName').value="";
	
	 
}

function exportPharmSearchResults() {
	
	var formId = "pharmacyFilterForm";
	var formObject = dojo.formToObject(formId);
	
	var getCSVUrl ="/inbound/inb-erx/managePharm/getPharmacyListCSV?json=" + dojo.toJson(formObject);
	location.href= getCSVUrl;
	 
}

function getPharmStationIdSelect() {
	
	var formId = "pharmacyFilterForm";
	
	// do a  null check to avoid js error.
	if(dojo.byId(formId)!=null){
		
		var formObject = dojo.formToObject(formId);
		
		var pharmVisnBox = dijit.byId("pharmacyFilterFormVisnSelect");
	
		var visn ="";
		
		visn = formObject.visn
		
		
		if(visn ===""){
			visn="All";
		}
		
		pharmManagementtSelectInit("inb-erx","pharmacyFilterForm", "managePharm/getStationIdsForSelect?visn=" + visn);
		
	}
	
}


function pharmacyManagementActions(buttonId) {

	if(buttonId==null && clearClicked == false){
		
		pharmManagementSearch();
		
		return false;
	}
	
	else if(buttonId == "pharmSearchClearButton"){
		
	 clearPharmSearch();
	 
	 clearClicked = true;
	 
	 return false;
	 
	}
	
	else if(buttonId == "pharmManagementExportButton"){
		exportPharmSearchResults();
		
		clearClicked = false;
		
		return false;
	}
	
	else if( buttonId =="newPharmAddButton"){
		
		document.pharmacyFilterForm.submit();
		
		clearClicked = false;
		
		return true;
	}
	
    else if( buttonId =="pharmSearchButton"){
		
    	pharmManagementSearch();
		
		clearClicked = false;
		
		return true; 
	}
	
	else{

		// default action
		
		return false;
	}
}	



