DROP TABLE ERX.PHARMACY CASCADE CONSTRAINTS ;

CREATE TABLE ERX.PHARMACY
  (
    PHARMACY_ID                  NUMBER NOT NULL ,
    VA_STATION_ID                VARCHAR2 (10) NOT NULL ,
    VISN						 NUMBER NOT NULL,
    DIVISION_NAME				 VARCHAR2 (35) NOT NULL,    
    NCPDP_ID                     VARCHAR2(7) NOT NULL ,
    NPI                          NUMBER ,       
    STORE_NAME                   VARCHAR2 (35) NOT NULL ,    
    PHARMACIST_LAST_NAME         VARCHAR2 (35) ,
    PHARMACIST_FIRST_NAME        VARCHAR2 (35) ,
    PHARMACIST_MIDDLE_NAME       VARCHAR2 (35) ,
    PHARMACIST_SUFFIX            VARCHAR2 (35) ,
    PHARMACIST_PREFIX            VARCHAR2 (35) ,    
    PHARMACY_ADDRESS_LINE_1      VARCHAR2 (35) NOT NULL ,
    PHARMACY_ADDRESS_LINE_2      VARCHAR2 (35) ,
    PHARMACY_CITY                VARCHAR2 (35) NOT NULL ,
    PHARMACY_STATE               VARCHAR2 (2) NOT NULL ,
    PHARMACY_ZIPCODE             VARCHAR2 (10) NOT NULL ,    
    CROSS_STREET                 VARCHAR2 (35) ,    
    PHARMACY_PHONE_NUMBER        VARCHAR2 (25) NOT NULL ,
    PHARMACY_FAX_NUMBER        	 VARCHAR2 (25) NOT NULL ,
    INBOUND_ERX_ENABLED          NUMBER NOT NULL,
    EANDE_CHECK				     VARCHAR2(1 BYTE) DEFAULT 'Y' NOT NULL,
	CONSTRAINT check_inbound_erx_enabled CHECK (inbound_erx_enabled IN (0, 1))	,	
	CONSTRAINT check_EANDE_CHECK CHECK (EANDE_CHECK IN ('Y', 'N'))	,
    UPDATED_DATE                 DATE ,
    CREATED_DATE                 DATE ,
    CREATED_BY                   VARCHAR2(20) ,
    UPDATED_BY                   VARCHAR2(20)
  )
  LOGGING ;
COMMENT ON COLUMN ERX.PHARMACY.VA_STATION_ID
IS
  'VA STATION ID' ;
CREATE UNIQUE INDEX ERX.PHARMACY_PK ON ERX.PHARMACY
  (
    PHARMACY_ID ASC
  )
  LOGGING ;
  
  CREATE UNIQUE INDEX ERX.NCPDP_ID_UK ON ERX.PHARMACY
  (
    NCPDP_ID ASC
  )
  LOGGING ;
  
   CREATE UNIQUE INDEX ERX.NPI_UK ON ERX.PHARMACY
  (
    NPI ASC
  )
  LOGGING ;
  
   CREATE UNIQUE INDEX ERX.DIVISION_NAME_UK ON ERX.PHARMACY
  (
    DIVISION_NAME ASC
  )
  LOGGING ;
  
   CREATE UNIQUE INDEX ERX.VA_STATION_ID_UK ON ERX.PHARMACY
  (
    VA_STATION_ID ASC
  )
  LOGGING ;
