CREATE OR REPLACE FORCE VIEW "ERX"."INBOUND_NCPDP_MSG_DEIDENT_VW" ("INBOUND_NCPDP_MSG_ID", "RX_MESSAGEID", "REL_TO_MESSAGE_ID", "MESSAGE_TYPE", "MESSAGE_STATUS", "MESSAGE_STATUS_DETAILS", "PATIENT_CHK_STATUS", "MVI_RUN_COUNT", "MVI_MATCH_ERROR", "EE_RUN_COUNT", "EE_MATCH_ERROR", "PROVIDER_CHK_STATUS", "PROVIDER_CHK_RUN_COUNT", "PROVIDER_MATCH_ERROR", "DRUG_CHK_STATUS", "DRUG_CHK_RUN_COUNT", "DRUG_MATCH_ERROR", "RECEIVED_DATE", "PHARMACY_NAME", "PHARMACY_ADDR_1", "PHARMACY_ADDR_2", "PHARMACY_CITY", "PHARMACY_STATE", "PHARMACY_ZIP", "PHARMACY_NCPDPID1", "PHARMACY_NCPDPID2", "PRESCRIBER_CITY", "PRESCRIBER_STATE", "PRESCRIBER_ZIP", "PATIENT_CITY", "PATIENT_STATE", "PATIENT_ZIP", "RX_DRUG_PRESCRIBED", "RX_DRUG_PRESCRIBED_QUALIFIER", "RX_DRUG_PRESCRIBED_NDC", "RX_QUANTITY", "RX_DAYS_SUPPLY", "RX_DATE_WRITTEN", "RX_POTENCY_UNIT_CODE", "RX_DRUG_FORM", "RX_DRUG_STRENGTH", "RX_REFILLS", "RX_SIG", "RX_DISPENSE_NOTES", "RX_COMMENTS", "RES_TYPE", "REQ_REFNO", "RES_APRV_REASON_CD", "RES_APRV_REFNO", "RES_APRV_NOTE", "RES_APRV_W_CHNG_REASON_CD", "RES_APRV_W_CHNG_REFNO", "RES_APRV_W_CHNG_NOTE", "RES_DENIAL_REASON_CD", "RES_DENIAL_REFNO", "RES_DENIAL_REASON", "RES_DENIAL_NRX_REASON_CD", "RES_DENIAL_NRX_REFNO", "RES_DENIAL_NRX_REASON", "ESV_DESCRIPTION_CODE", "ESV_CODE", "ESV_DESCRIPTION", "RX_REFERENCE_NUMBER", "PRESCRIBER_ORDER_NUMBER", "CHANGEOF_PRESCR_STAT_FLG") AS 
  select t.inbound_ncpdp_msg_id inbound_ncpdp_msg_id,
t.message_id rx_messageId,
t.rel_to_message_id,
t.message_type,
t.message_status,
t.message_status_details,
t.patient_chk_status,
(nvl(extractValue(xmltype(nvl(t.patient_match_details,'<mvi/>')), '//mvi/runCount'),0)) mvi_run_count,
extractValue(xmltype(nvl(t.patient_match_details,'<mvi/>')), '//mvi/errorMessage') mvi_match_error,
(nvl(extractValue(xmltype(nvl(t.patient_match_details,'<eande/>')), '//eande/runCount'),0)) ee_run_count,
extractValue(xmltype(nvl(t.patient_match_details,'<eande/>')), '//eande/errorMessage') ee_match_error,
t.provider_chk_status,
(nvl(extractValue(xmltype(nvl(t.provider_match_details,'<providerCheck/>')), '/providerCheck/runCount'),0)) provider_chk_run_count,
extractValue(xmltype(nvl(t.patient_match_details,'<providerCheck/>')), '//providerCheck/errorMessage') provider_match_error,
t.drug_chk_status,
(nvl(extractValue(xmltype(nvl(t.drug_match_details,'<drugCheck/>')), '/drugCheck/runCount'),0)) drug_chk_run_count,
extractValue(xmltype(nvl(t.patient_match_details,'<drugCheck/>')), '//drugCheck/errorMessage') drug_match_error,
t.received_date,
x.pharmacy_name,
x.pharmacy_addr_1,
x.pharmacy_addr_2,
x.pharmacy_city,
x.pharmacy_state,
x.pharmacy_zip,
x.pharmacy_ncpdpid1,
x.pharmacy_ncpdpid2, 
--x.prescriber_First_Name,
--x.prescriber_Mid_Name,
--x.prescriber_Last_Name,
--x.prescriber_addr_1,
--x.prescriber_addr_2,
x.prescriber_city,
x.prescriber_state,
x.prescriber_zip,
--x.npi1 prescriber_NPI,
--x.npi2 clinic_id,
--x.prescriber_DEA,
--x.prescriber_State_Lic,
--x.prescriber_agent_first_name,
--x.prescriber_agent_last_name,
--x.patient_First_Name,
--x.patient_Mid_Name,
--x.patient_Last_Name,
--x.patient_addr_1,
--x.patient_addr_2,
x.patient_city,
x.patient_state,
x.patient_zip,
--x.patient_dob,
--x.patient_ssn,  
--x.patient_gender,
x.rx_Drug_Prescribed,
x.rx_Drug_Prescribed_Qualifier,
x.rx_Drug_Prescribed_Ndc,
x.rx_Quantity,
x.rx_Days_Supply,
x.rx_Date_Written,
x.rx_Potency_Unit_Code,
x.rx_Drug_Form,
x.rx_Drug_Strength,
x.rx_Refills,
x.rx_Sig, 
decode(x.rx_Dispense_Notes,'0','0 = No Product Selection Indicated','1','1 = Substitution Not Allowed by Prescriber','2','2 = Substitution Allowed-Patient Requested Product Dispensed','3','3 = Substitution Allowed-Pharmacist Selected Product Dispensed','4','4 = Substitution Allowed-Generic Drug Not in Stock','5','5 = Substitution Allowed-Brand Drug Dispensed as a Generic','6','6 = Override','7','7 = Substitution Not Allowed-Brand Mandated by Law','8','8 = Substitution Allowed-Generic Drug Not Available in Marketplace','9','9 = Substitution Allowed By Prescriber but Plan Requests Brand - Patient''s Plan Requested Brand Product To Be Dispensed') rx_Dispense_Notes,
x.rx_Comments,
x.res_type,  
x.req_refno, 
x.res_aprv_reason_cd,  
x.res_aprv_refno,  
x.res_aprv_note,  
x.res_aprv_w_chng_reason_cd,  
x.res_aprv_w_chng_refno,  
x.res_aprv_w_chng_note,  
x.res_denial_reason_cd, 
x.res_denial_refno,  
x.res_denial_reason,  
x.res_denial_nrx_reason_cd,  
x.res_denial_nrx_refno,  
x.res_denial_nrx_reason, 
x.esv_description_code, 
x.esv_code, 
x.esv_description, 
x.rx_reference_number, 
x.prescriber_order_number, 
decode(x.changeof_prescr_stat_flg,'C', 'C - Cancel', 'D', 'D - Discontinue',x.changeof_prescr_stat_flg) changeof_prescr_stat_flg
from inbound_ncpdp_msg t, xmltable(xmlnamespaces('http://www.ncpdp.org/schema/SCRIPT' as "ns"), '/ns:Message'
passing t.message
columns 
message_id varchar2(35) path '//ns:Header/ns:MessageID',
rel_to_message_id varchar2(35) path '//ns:Header/ns:RelatesToMessageID',
message_type varchar2(35) path 'name(/ns:Body/*[1])',
pharmacy_name varchar2(35) path '//ns:Pharmacy/ns:StoreName',
pharmacy_addr_1 varchar2(35) path '//ns:Pharmacy/ns:Address/ns:AddressLine1',
pharmacy_addr_2 varchar2(35) path '//ns:Pharmacy/ns:Address/ns:AddressLine2',
pharmacy_city varchar2(35) path '//ns:Pharmacy/ns:Address/ns:City',
pharmacy_state varchar2(2) path '//ns:Pharmacy/ns:Address/ns:State',
pharmacy_zip varchar2(14) path '//ns:Pharmacy/ns:Address/ns:ZipCode',
pharmacy_ncpdpid1 varchar2(35) path '//ns:Pharmacy/ns:Identification/ns:NCPDPID',
pharmacy_ncpdpid2 varchar2(35) path '//ns:Header/ns:To',
npi1 varchar2(35) path '//ns:Prescriber/ns:Identification/ns:NPI',
npi2 varchar2(35) path '//ns:Header/ns:From',
--prescriber_First_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:FirstName',
--prescriber_Mid_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:MiddleName',
--prescriber_Last_Name varchar2(35) path '//ns:Prescriber/ns:Name/ns:LastName',
--prescriber_addr_1 varchar2(35) path '//ns:Prescriber/ns:Address/ns:AddressLine1',
--prescriber_addr_2 varchar2(35) path '//ns:Prescriber/ns:Address/ns:AddressLine2',
prescriber_city varchar2(35) path '//ns:Prescriber/ns:Address/ns:City',
prescriber_state varchar2(2) path '//ns:Prescriber/ns:Address/ns:State',
prescriber_zip varchar2(14) path '//ns:Prescriber/ns:Address/ns:ZipCode',
--prescriber_agent_last_name varchar2(35) path '//ns:Prescriber/ns:PrescriberAgent/ns:LastName',
--prescriber_agent_first_name varchar2(35) path '//ns:Prescriber/ns:PrescriberAgent/ns:FirstName',
--prescriber_DEA varchar2(35) path '//ns:Prescriber/ns:Identification/ns:DEANumber',
--prescriber_State_Lic varchar2(35) path '//ns:Prescriber/ns:Identification/ns:StateLicenseNumber',
--patient_First_Name varchar2(35) path '//ns:Patient/ns:Name/ns:FirstName',
--patient_Mid_Name varchar2(35) path '//ns:Patient/ns:Name/ns:MiddleName',
--patient_Last_Name varchar2(35) path '//ns:Patient/ns:Name/ns:LastName',
--patient_addr_1 varchar2(35) path '//ns:Patient/ns:Address/ns:AddressLine1',
--patient_addr_2 varchar2(35) path '//ns:Patient/ns:Address/ns:AddressLine2',
patient_city varchar2(35) path '//ns:Patient/ns:Address/ns:City',
patient_state varchar2(2) path '//ns:Patient/ns:Address/ns:State',
patient_zip varchar2(14) path '//ns:Patient/ns:Address/ns:ZipCode',
--patient_dob varchar2(30) path '//ns:Patient/ns:DateOfBirth/ns:Date',
--patient_ssn varchar2(11) path '//ns:Patient/ns:Identification/ns:SocialSecurity', 
--patient_gender varchar2(1) path '//ns:Patient/ns:Gender',
rx_Drug_Prescribed varchar2(105) path '//ns:MedicationPrescribed/ns:DrugDescription',
rx_Drug_Prescribed_Ndc varchar2(30) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:ProductCode',
rx_Drug_Prescribed_Qualifier varchar2(2) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:ProductCodeQualifier',  
rx_Quantity varchar2(30) path '//ns:MedicationPrescribed/ns:Quantity/ns:Value',
rx_Days_Supply varchar2(30) path '//ns:MedicationPrescribed/ns:DaysSupply',
rx_Date_Written varchar2(30) path '//ns:MedicationPrescribed/ns:WrittenDate',
rx_Potency_Unit_Code varchar2(30) path '//ns:MedicationPrescribed/ns:Quantity/ns:PotencyUnitCode',
rx_Drug_Form varchar2(30) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:FormCode',
rx_Drug_Strength varchar2(70) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:Strength',
rx_Drug_Strength_Code varchar2(30) path '//ns:MedicationPrescribed/ns:DrugCoded/ns:StrengthCode',  
rx_Refills varchar2(2) path '//ns:MedicationPrescribed/ns:Refills/ns:Value',
rx_Sig varchar2(140) path '//ns:MedicationPrescribed/ns:Directions',
rx_Dispense_Notes varchar2(35) path '//ns:MedicationPrescribed/ns:Substitutions',
rx_Comments varchar2(210) path '//ns:MedicationPrescribed/ns:Note',
res_type varchar2(70) path 'name(/ns:Body/*/ns:Response/*[1])',  
req_refno varchar2(70) path '//ns:Request/ns:Request/ns:ReferenceNumber', 
res_aprv_reason_cd varchar2(70) path '//ns:Response/ns:Approved/ns:ApprovalReasonCode[1]', 
res_aprv_refno varchar2(70) path '//ns:Response/ns:Approved/ns:ReferenceNumber', 
res_aprv_note varchar2(70) path '//ns:Response/ns:Approved/ns:Note', 
res_aprv_w_chng_reason_cd varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:DenialReasonCode[1]', 
res_aprv_w_chng_refno varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:ReferenceNumber', 
res_aprv_w_chng_note varchar2(70) path '//ns:Response/ns:ApprovedWithChanges/ns:Note', 
res_denial_reason_cd varchar2(70) path '//ns:Response/ns:Denied/ns:DenialReasonCode[1]', 
res_denial_refno varchar2(70) path '//ns:Response/ns:Denied/ns:ReferenceNumber', 
res_denial_reason varchar2(70) path '//ns:Response/ns:Denied/ns:DenialReason', 
res_denial_nrx_reason_cd varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:DenialReasonCode[1]', 
res_denial_nrx_refno varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:ReferenceNumber', 
res_denial_nrx_reason varchar2(70) path '//ns:Response/ns:DeniedNewPrescriptionToFollow/ns:DenialReason' ,
esv_description_code varchar2(70) path '//ns:DescriptionCode[1]', 
esv_code varchar2(70) path '//ns:Code', 
esv_description varchar2(70) path '//ns:Description', 
rx_reference_number varchar2(35) path '//ns:Header/ns:RxReferenceNumber',
prescriber_order_number varchar2(35) path '//ns:Header/ns:PrescriberOrderNumber',  
changeof_prescr_stat_flg varchar2(35) path '//ns:Request/ns:ChangeofPrescriptionStatusFlag'  
) x;
