dojo.require("dojo.hash");
dojo.require("dijit.registry")

dojo.addOnLoad(function() {
	dojo.style(dojo.byId('summaryReport'), "display", "none");
    dojo.style(dojo.byId('summaryReportFilter'), "display", "none");
    

});


dojo.ready(function() {
	var selectBox = dojo.byId("reportSelection");
	var selected = null;
	
	dojo.connect(selectBox, "onchange", null, function(event) {
		selected = getSelected(selectBox);
		
		if (selected == "SUMMRPT") {

			getSummaryReport();
			getStationIdSelect();
			toggleDivs(selected);
		}
		else if (selected == "AUTOCHECKRPT") {

			getAutoCheckReport();
			getStationIdSelect();
			toggleDivs(selected);
		}
		else if (selected == "REJECTRESNRPT") {

			getRejectReasonsReport();
			getStationIdSelect();
			toggleDivs(selected);
		}
		else if (selected == "ERXSUMMRPT") {

			getErxSummaryReport();
			getStationIdSelect();
			toggleDivs(selected);
		}
		else{
			toggleDivs(selected);
		}
		
	});
	
	
});	




// drop down selection.
function getSelected(selectBox) {
	var selectedIndex = selectBox.options.selectedIndex;
	var selected = selectBox.options[selectedIndex].value;
	return selected;
}



function getSummaryReport() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	// limit To/From future dates.
	var startDate = dijit.byId('dateFrom');
	var endDate = dijit.byId('dateTo');
	
	if(startDate!=null)
	{	
		
	  startDate.constraints.max = new Date();
	}
	
	if(endDate!=null)
	{	
		
		endDate.constraints.max = new Date();
	}
	
	var selectBox = dojo.byId("reportSelection");

	selected = getSelected(selectBox);
		
		if (selected == "SUMMRPT") {
			summaryReportDataGridInit("inb-erx","summaryReport", "summaryReport/getSummary?json=" + dojo.toJson(formObject) );
			buildSummaryReportTotalsGrid("summaryReportTotals");
			dojo.byId("reportRunDateTime").innerHTML = "Report as of:  " + getCurrentDateTimeForDisplay();
		}
		if (selected == "AUTOCHECKRPT") {
			autoCheckReportDataGridInit("inb-erx","summaryReport", "autoCheckReport/getReport?json=" + dojo.toJson(formObject) );
			buildAutoCheckReportTotalsGrid("summaryReportTotals");
			dojo.byId("reportRunDateTime").innerHTML = "Report as of:  " + getCurrentDateTimeForDisplay();
		}
		if (selected == "REJECTRESNRPT") {
			rejectReasonsReportDataGridInit("inb-erx","summaryReport", "rejectReasonsReport/getReport?json=" + dojo.toJson(formObject) );
			buildRejectReasonsReportTotalsGrid("summaryReportTotals");
			dojo.byId("reportRunDateTime").innerHTML = "Report as of:  " + getCurrentDateTimeForDisplay();
		}
		if (selected == "ERXSUMMRPT") {
			erxSummaryReportDataGridInit("inb-erx","summaryReport", "erxSummaryReport/getReport?json=" + dojo.toJson(formObject) );
			buildErxSummaryReportTotalsGrid("summaryReportTotals");
			dojo.byId("reportRunDateTime").innerHTML = "Report as of:  " + getCurrentDateTimeForDisplay();
		}
		
		
}

function getStationIdSelect(visn) {
	
	var formId = "summaryReportForm";
	
	// do a  null check to avoid js error.
	if(dojo.byId(formId)!=null){
		
		var formObject = dojo.formToObject(formId);
		var visn = formObject.visn
		
		summaryReportSelectInit("inb-erx","summaryReportForm", "summaryReport/getStationIdSelect?visn=" + visn);
		
	}
	
}

function getVisnSelect() {
	
	visnSelectInit("inb-erx","summaryReportForm", "summaryReport/getVisnSelect");
	
}

	 

function toggleDivs(selected){
  if( selected == "SUMMRPT"){
	  dojo.style(dojo.byId('summaryReportFilter'), "display", "block");
      dojo.style(dojo.byId('summaryReport'), "display", "block"); 
      dojo.style(dojo.byId('summaryReportTotals'), "display", "block");
      dojo.style(dojo.byId('summaryReportGrid'), "display", "block");
      if (dojo.byId('summaryReportGrid2') != null){
      dojo.style(dojo.byId('summaryReportGrid2'), "display", "none");
      }
      if (dojo.byId('summaryReportGrid3') != null){
          dojo.style(dojo.byId('summaryReportGrid3'), "display", "none");
          }
      if (dojo.byId('summaryReportGrid4') != null){
          dojo.style(dojo.byId('summaryReportGrid4'), "display", "none");
          }
  } else if ( selected == "AUTOCHECKRPT") {
      dojo.style(dojo.byId('summaryReportFilter'), "display", "block");
      dojo.style(dojo.byId('summaryReport'), "display", "block");
      dojo.style(dojo.byId('summaryReportTotals'), "display", "block");
      if (dojo.byId('summaryReportGrid') != null){
          dojo.style(dojo.byId('summaryReportGrid'), "display", "none");
          }
      if (dojo.byId('summaryReportGrid3') != null){
          dojo.style(dojo.byId('summaryReportGrid3'), "display", "none");
          }
      if (dojo.byId('summaryReportGrid4') != null){
          dojo.style(dojo.byId('summaryReportGrid4'), "display", "none");
          }
      dojo.style(dojo.byId('summaryReportGrid2'), "display", "block");
  } else if ( selected == "REJECTRESNRPT") {
      dojo.style(dojo.byId('summaryReportFilter'), "display", "block");
      dojo.style(dojo.byId('summaryReport'), "display", "block");
      dojo.style(dojo.byId('summaryReportTotals'), "display", "block");
      if (dojo.byId('summaryReportGrid') != null){
          dojo.style(dojo.byId('summaryReportGrid'), "display", "none");
          }
      if (dojo.byId('summaryReportGrid2') != null){
          dojo.style(dojo.byId('summaryReportGrid2'), "display", "none");
          }
      if (dojo.byId('summaryReportGrid4') != null){
          dojo.style(dojo.byId('summaryReportGrid4'), "display", "none");
          }
      dojo.style(dojo.byId('summaryReportGrid3'), "display", "block");
  } else if ( selected == "ERXSUMMRPT") {
      dojo.style(dojo.byId('summaryReportFilter'), "display", "block");
      dojo.style(dojo.byId('summaryReport'), "display", "block");
      dojo.style(dojo.byId('summaryReportTotals'), "display", "block");
      if (dojo.byId('summaryReportGrid') != null){
          dojo.style(dojo.byId('summaryReportGrid'), "display", "none");
          }
      if (dojo.byId('summaryReportGrid2') != null){
          dojo.style(dojo.byId('summaryReportGrid2'), "display", "none");
          }
      if (dojo.byId('summaryReportGrid3') != null){
          dojo.style(dojo.byId('summaryReportGrid3'), "display", "none");
          }
      dojo.style(dojo.byId('summaryReportGrid4'), "display", "block");
  } else {
      dojo.style(dojo.byId('summaryReportFilter'), "display", "none");
      dojo.style(dojo.byId('summaryReport'), "display", "none");
      dojo.style(dojo.byId('summaryReportTotals'), "display", "none");
  }
}


function getCurrentDateTimeForDisplay(){
	var d = new Date(),
    minutes = d.getMinutes().toString().length == 1 ? '0'+d.getMinutes() : d.getMinutes(),
    hours = d.getHours().toString().length == 1 ? '0'+d.getHours() : d.getHours(),
    //ampm = d.getHours() >= 12 ? 'pm' : 'am',
    months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],
    days = ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'];
    return days[d.getDay()]+' '+months[d.getMonth()]+' '+d.getDate()+' '+d.getFullYear()+' '+hours+':'+minutes;
}


function getReportCSV(){
	
	var selectBox = dojo.byId("reportSelection");
    selected = getSelected(selectBox);
		
		if (selected == "SUMMRPT") {	
			getSummaryReportCSV();			
		}
		if (selected == "AUTOCHECKRPT") {
			getAutoCheckReportCSV();
		}
		if (selected == "REJECTRESNRPT") {
			getRejectReasonsReportCSV();
		}
		if (selected == "ERXSUMMRPT") {
			getErxSummaryReportCSV();
		}
	
}

function getSummaryReportCSV() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	var getCSVUrl ="/inbound/inb-erx/summaryReport/getSummaryReportCSV?json=" + dojo.toJson(formObject);
	location.href= getCSVUrl;	
}

function getAutoCheckReportCSV() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	var getCSVUrl ="/inbound/inb-erx/autoCheckReport/getReportCSV?json=" + dojo.toJson(formObject);
	location.href= getCSVUrl;	
}

function getRejectReasonsReportCSV() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	var getCSVUrl ="/inbound/inb-erx/rejectReasonsReport/getReportCSV?json=" + dojo.toJson(formObject);
	location.href= getCSVUrl;	
}

function getErxSummaryReportCSV() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	var getCSVUrl ="/inbound/inb-erx/erxSummaryReport/getReportCSV?json=" + dojo.toJson(formObject);
	location.href= getCSVUrl;	
}


function csvResponse(){
	
	 return;
}



function clearSearch() {
	
	 var reportVisnBox = dijit.byId("summaryReportFormVisnSelect");
	 reportVisnBox.reset();
	 reportVisnBox.set("value", 'All');
	 
	 
	 var reportStationId = dijit.byId("summaryReportFormSelect");
	 reportStationId.reset();
	 reportStationId.set("value", 'All');
	 
	
	 var startDate = dijit.byId('dateFrom');
	 
	 var endDate = dijit.byId('dateTo');
	 
	 
		
	 if(startDate!=null)
	 {	
	 	
	  startDate.reset();	
	 
	  startDate.constraints.max = new Date();
	 }
	
	 if(endDate!=null)
	 {	
		
	   endDate.reset();
		
	   endDate.constraints.max = new Date();
	}
	 
	 // reset Totals
	 
	 var newStore = new  dojo.data.ItemFileReadStore({data: {  identifier: "",  items: []}}); // clears the Grid
	 
	 if (dojo.byId('summaryReportGrid') != null){
		 var reportGrid = dijit.byId('summaryReportGrid'); 
			
		 reportGrid.set("noDataMessage","")
		 
		 reportGrid.selection.clear();
		 reportGrid.setStore(newStore);
		 reportGrid.startup();
		 resetReportTotalsGrid("summaryReportTotals");
			
	 }
	 
	 if (dojo.byId('summaryReportGrid2') != null){
		 var reportGrid = dijit.byId('summaryReportGrid2'); 
			
		 reportGrid.set("noDataMessage","")
		 
		 reportGrid.selection.clear();
		 reportGrid.setStore(newStore);
		 reportGrid.startup();
		 resetReportTotalsGrid("summaryReportTotals");
	 }
	 
	 if (dojo.byId('summaryReportGrid3') != null){
		 var reportGrid = dijit.byId('summaryReportGrid3'); 
			
		 reportGrid.set("noDataMessage","")
		 
		 reportGrid.selection.clear();
		 reportGrid.setStore(newStore);
		 reportGrid.startup();
		 resetReportTotalsGrid("summaryReportTotals");

	 }
	 
	 if (dojo.byId('summaryReportGrid4') != null){
		 var reportGrid = dijit.byId('summaryReportGrid4'); 
			
		 reportGrid.set("noDataMessage","")
		 
		 reportGrid.selection.clear();
		 reportGrid.setStore(newStore);
		 reportGrid.startup();
		 resetReportTotalsGrid("summaryReportTotals");

	 }
	 	 
	 dojo.byId("reportRunDateTime").innerHTML = "";
	 
}

function getRejectReasonsReport() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	// limit To/From future dates.
	var startDate = dijit.byId('dateFrom');
	var endDate = dijit.byId('dateTo');
	
	if(startDate!=null)
	{	
		
	  startDate.constraints.max = new Date();
	}
	
	if(endDate!=null)
	{	
		
		endDate.constraints.max = new Date();
	}
	
	rejectReasonsReportDataGridInit("inb-erx","summaryReport", "rejectReasonsReport/getReport?json=" + dojo.toJson(formObject) );
	buildRejectReasonsReportTotalsGrid("summaryReportTotals");
	dojo.byId("reportRunDateTime").innerHTML = "Report as of:  " + getCurrentDateTimeForDisplay();
	
		
}

function getAutoCheckReport() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	// limit To/From future dates.
	var startDate = dijit.byId('dateFrom');
	var endDate = dijit.byId('dateTo');
	
	if(startDate!=null)
	{	
		
	  startDate.constraints.max = new Date();
	}
	
	if(endDate!=null)
	{	
		
		endDate.constraints.max = new Date();
	}
	
	autoCheckReportDataGridInit("inb-erx","summaryReport", "autoCheckReport/getReport?json=" + dojo.toJson(formObject) );
	buildAutoCheckReportTotalsGrid("summaryReportTotals");
	dojo.byId("reportRunDateTime").innerHTML = "Report as of:  " + getCurrentDateTimeForDisplay();
	
		
}

function getErxSummaryReport() {
	var formId = "summaryReportForm";
	var formObject = dojo.formToObject(formId);
	
	// limit To/From future dates.
	var startDate = dijit.byId('dateFrom');
	var endDate = dijit.byId('dateTo');
	
	if(startDate!=null)
	{	
		
	  startDate.constraints.max = new Date();
	}
	
	if(endDate!=null)
	{	
		
		endDate.constraints.max = new Date();
	}
	
	erxSummaryReportDataGridInit("inb-erx","summaryReport", "erxSummaryReport/getReport?json=" + dojo.toJson(formObject) );
	buildErxSummaryReportTotalsGrid("summaryReportTotals");
	dojo.byId("reportRunDateTime").innerHTML = "Report as of:  " + getCurrentDateTimeForDisplay();
	
		
}
