package gov.va.med.pharmacy.web.reports;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.json.JsonSanitizer;

import gov.va.med.pharmacy.persistence.model.ErxSummaryReportVw;
import gov.va.med.pharmacy.persistence.report.StationIdSelectModel;
import gov.va.med.pharmacy.persistence.report.SummaryReportFilter;
import gov.va.med.pharmacy.persistence.report.VisnSelectModel;
import gov.va.med.pharmacy.persistence.service.ErxSummaryReportService;
import gov.va.med.pharmacy.persistence.service.TrackMessageService;
import gov.va.med.pharmacy.web.csv.CSVSupportBean;
import gov.va.med.pharmacy.web.csv.CSVView;
import net.rossillo.spring.web.mvc.CacheControl;
import net.rossillo.spring.web.mvc.CachePolicy;

@CacheControl
@Controller
@RequestMapping(value = "/erxSummaryReport")
public class ErxSummaryReportController {
	
	
	private static final String[] ERX_SUMMARY_REPORT_HEADER = { "VISN", "VA Station ID",	"NCPDP ID", "Pharmacy Name", "Address", "#New Rx", 
			                                               "#Refill Request", "#Refill Response", "#Rx Change Request","#Rx Change Response","#Rx Cancel Request",
			                                               "#Cancel Rx Response","#RxFill"};
	

	@Autowired
	private ErxSummaryReportService erxSummaryReportService;
	
	@Autowired
	private TrackMessageService trackMessageService;

	@RequestMapping(value = "/getReport", method = RequestMethod.GET)
	@CacheControl(policy = {CachePolicy.NO_CACHE})
	@ResponseBody
	public List<ErxSummaryReportVw> getSummaryReport(HttpServletRequest request, @RequestParam("json") String json)
			throws JsonParseException, JsonMappingException, IOException {

		List<ErxSummaryReportVw> erxSummaryReportVwList = new ArrayList<ErxSummaryReportVw>();

		String jsonString = JsonSanitizer.sanitize(json); // Sanitize the JSON coming from client
		
		//System.out.println("json is:" + jsonString);
		
		ObjectMapper jsonMapper = new ObjectMapper();
		
		SummaryReportFilter summaryReportFilter = jsonMapper.readValue(jsonString, SummaryReportFilter.class);

		erxSummaryReportVwList.addAll(erxSummaryReportService.find(summaryReportFilter));
		return erxSummaryReportVwList;
	}

	@RequestMapping(value = "/getStationIdSelect", method = RequestMethod.GET, produces = "application/json")
	@CacheControl(policy = {CachePolicy.NO_CACHE})
	@ResponseBody
	public List<StationIdSelectModel> getStationIdSelect(HttpServletRequest request, @RequestParam("visn") String visn)
			throws JsonParseException, JsonMappingException, IOException {

		List<StationIdSelectModel> stationIdSelectModelList = new ArrayList<StationIdSelectModel>();

		List<ErxSummaryReportVw> summaryReportVwList = new ArrayList<ErxSummaryReportVw>();
	
		if (visn.equalsIgnoreCase("/")) {
			visn = "";
		}

		//System.out.println("visn is:  " + visn);

		summaryReportVwList.addAll(erxSummaryReportService.find(visn));

		int i = 0;
		while (i < summaryReportVwList.size()) {
			StationIdSelectModel stationIdSelectModel = new StationIdSelectModel();
			
			//System.out.println("station id:  " + summaryReportVwList.get(i).getPharmacyVaStationId());
			
			stationIdSelectModel.setId(summaryReportVwList.get(i).getPharmacyVaStationId());
			stationIdSelectModel.setLabel(summaryReportVwList.get(i).getPharmacyVaStationId());
			stationIdSelectModelList.add(i, stationIdSelectModel);
			i++;
		}
		
		//System.out.println("list index: " + i);
		
		StationIdSelectModel stationIdSelectModel = new StationIdSelectModel();
		stationIdSelectModel.setId("All");
		stationIdSelectModel.setLabel(" All ");
		stationIdSelectModelList.add(i, stationIdSelectModel);

		return stationIdSelectModelList;
	}

	@RequestMapping(value = "/getReportCSV", method = {RequestMethod.GET, RequestMethod.POST})
	public void csvExport(HttpServletRequest request, @RequestParam("json") String json,HttpServletResponse response) 
			throws JsonParseException, JsonMappingException, IOException{
		
		try {
			String jsonString = JsonSanitizer.sanitize(json);
			
			String csvFileName = "SummaryReport.csv";
			
			String responseHeaderKey = "Content-Disposition";
			
			String responseHeaderValue = String.format("attachment; filename=\"%s\"",   csvFileName);
			
			ObjectMapper jsonMapper = new ObjectMapper();
			
			SummaryReportFilter summaryReportFilter = jsonMapper.readValue(jsonString, SummaryReportFilter.class);
			
			List<ErxSummaryReportVw> erxSummaryReportVwList = erxSummaryReportService.queryForExport(summaryReportFilter);
			
			String[][] csvData = null;
			
			if(null!= erxSummaryReportVwList && erxSummaryReportVwList.size()>0){
				
				csvData = populateDataRows(erxSummaryReportVwList,	ERX_SUMMARY_REPORT_HEADER);		
				
				
			}
			else{
				
				List<ErxSummaryReportVw> summaryReportVwEmptyList = new ArrayList<ErxSummaryReportVw>();
				
				ErxSummaryReportVw  emptyBean = new ErxSummaryReportVw();
				summaryReportVwEmptyList.add(emptyBean);				
				
				csvData = populateDataRows(summaryReportVwEmptyList,	ERX_SUMMARY_REPORT_HEADER);
				
			}
			
			response.setContentType("text/csv");
			
			response.setHeader(responseHeaderKey, responseHeaderValue);
			
			CSVSupportBean csvSupportBean = new CSVSupportBean();
			
			csvSupportBean.setHeaderRow(ERX_SUMMARY_REPORT_HEADER);

			csvSupportBean.setDataRows(csvData);
			
			Map<String,Object> csvModel = csvSupportBean.createModel();
			
			CSVView view = new CSVView();
			
			String data = view.getStringRepresentation(csvModel);
			
			response.getOutputStream().print(data);
			
			response.getOutputStream().flush();
			
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	@RequestMapping(value = "/getVisnSelect", method = RequestMethod.GET, produces = "application/json")
	@CacheControl(policy = {CachePolicy.NO_CACHE})
	@ResponseBody
	public List<VisnSelectModel> getVisnSelect(HttpServletRequest request)
			throws JsonParseException, JsonMappingException, IOException {
		

		List<VisnSelectModel> visnSelectModelList = new ArrayList<VisnSelectModel>();
		
		VisnSelectModel visnSelectModel = new VisnSelectModel();
		visnSelectModel.setId("");
		visnSelectModel.setLabel("All");
		visnSelectModelList.add(visnSelectModel);

		visnSelectModelList.addAll(trackMessageService.getVisns());
		
		return visnSelectModelList;
	}
	
	
	private String[][] populateDataRows(List<ErxSummaryReportVw> rows, String[] headers) {
		// + 1 for the totals as the last row
		String[][] dataRows = new String[rows.size()+1][headers.length];
		for (int i = 0; i < rows.size(); i++) {
			
			String[] row = ((ErxSummaryReportVw) rows.get(i)).getStringArray();
						
			for (int j = 0; j < headers.length; j++) {
				
				dataRows[i][j] = row[j];
				
			}
		}
		
		return dataRows;
		
	}
}
