package gov.va.med.pharmacy.web.administration.managepharmacy;

import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotBlank;

import gov.va.med.pharmacy.web.util.BlankOrLength;
import gov.va.med.pharmacy.web.util.BlankOrPattern;


public class PharmacyForm {

	
	@NotBlank(message = "Pharmacy Name (Published) is required.")
	private String storeName;
	
	// adding character length check to be safe for visn. Number between 0 and 99.
	@NotBlank(message = "VISN is required.")
	@BlankOrPattern(regexp = "^[0-9]{1,2}$",message="VISN should be a number.")
	private String visn;
	
	@NotBlank(message="VA Station ID is required.")
	@BlankOrPattern(regexp = "^(?=.*\\d)[A-Z\\d]*$",message="VA Station ID should be either numeric or upper case alphanumeric.")
	private String vaStationId;
	

	@NotBlank(message="Pharmacy Name (Internal) is required.")
	private String divisionName;
	
	@NotBlank(message = "Pharmacy Address Line 1 is required.")
	private String pharmacyAddressLine1;
	private String pharmacyAddressLine2;
	
	@NotBlank(message = "Pharmacy City is required.")
	@BlankOrPattern(regexp = "^[a-zA-Z]+(?:[\\s-][a-zA-Z]+)*$",message="Pharmacy City should be only alphabetical letters.")
	private String pharmacyCity;
	
	@NotBlank(message = "Pharmacy State is required.")
	private String pharmacyState;
	
	@NotBlank(message = "Pharmacy Zip Code is required.")
	@BlankOrPattern(regexp = "^[0-9]{5}(?:-[0-9]{4})?$",message="Pharmacy Zip Code should be either five digits only or in XXXXX-XXXX format.")
	private String pharmacyZipcode;
	
	@NotBlank(message = "Pharmacy Phone Number (TE) is required.")
	@BlankOrPattern(regexp = "(^[2-9]\\d{2}-\\d{3}-\\d{4})|(\\d{3}-\\d{3}-\\d{4}\\s(x)\\d{3,5})$",message="Pharmacy Phone Number should be entered either in XXX-XXX-XXXX format or with extension in XXX-XXX-XXXX xXXXXX format.")
	private String pharmacyPhoneNumber;
	
	@NotBlank(message = "Pharmacy Fax Number (FX) is required.")
	@BlankOrPattern(regexp = "(^[2-9]\\d{2}-\\d{3}-\\d{4})|(\\d{3}-\\d{3}-\\d{4}\\s(x)\\d{3,5})$",message="Pharmacy Fax Number should be entered either in XXX-XXX-XXXX format or with extension in XXX-XXX-XXXX xXXXXX format.")
	private String pharmacyFaxNumber;
	
	@NotBlank(message="NCPDP ID is required.")	
	@BlankOrPattern(regexp = "^[0-9]*$",message="NCPDP ID should be a number.")
	@BlankOrLength(min=7, message="NCPDP ID  should be 7 digits.")
	private String ncpdpId;
	
	@Email
	private String email;	
	
	@NotBlank(message="NPI is required.")	
	@BlankOrPattern(regexp = "^[0-9]*$",message="NPI should be a number.")
	@BlankOrLength(min=10, message="NPI should be 10 digits.")
	private String npi;
	
	@NotBlank(message = "Service Level is required.")
	private String serviceLevel;
	
	@NotBlank(message = "Specialty ID is required.")
	private String specialtyId;
	

	//@NotBlank(message="Active Start Time is required.")
	private String activeStartTime;
		
	//@NotBlank(message="Active End Time is required.")
	private String activeEndTime;
		
	private String pharmacyId;
	private String createdBy;
	private String updatedBy;
	private String vistaLookupId;
	private String fileId;
	private String stateLicenseNumber;
	private String medicareNumber;
	private String medicaidNumber;
	private String ppoNumber;
	private String payerId;
	private String binLocationNumber;
	private String deaNumber;
	private String hin;
	private String secondaryCoverage;
	private String naicCode;
	private String promotionNumber;
	private String storeNumber;
	private String pharmacistLastName;
	private String pharmacistFirstName;
	private String pharmacistMiddleName;
	private String pharmacistSuffix;
	private String pharmacistPrefix;
	private String pharmacistAgentLastName;
	private String pharmacistAgentFirstName;
	private String pharmacistAgentMiddleName;
	private String pharmacistAgentSuffix;
	private String pharmacistAgentPrefix;		
	private String twentyFourHourFlag;
	private String crossStreet;	
	private String inboundErxEnabled;
	private String updatedDate;
	private String createdDate;	
	private String pharmacyEnabledDisabled;
	
	
	
	public String getStoreName() {
		return storeName;
	}

	public void setStoreName(String storeName) {
		this.storeName = storeName;
	}

	public String getVisn() {
		return visn;
	}

	public void setVisn(String visn) {
		this.visn = visn;
	}

	public String getVaStationId() {
		return vaStationId;
	}

	public void setVaStationId(String vaStationId) {
		this.vaStationId = vaStationId;
	}

	public String getDivisionName() {
		return divisionName;
	}

	public void setDivisionName(String divisionName) {
		this.divisionName = divisionName;
	}

	public String getPharmacyAddressLine1() {
		return pharmacyAddressLine1;
	}

	public void setPharmacyAddressLine1(String pharmacyAddressLine1) {
		this.pharmacyAddressLine1 = pharmacyAddressLine1;
	}

	public String getPharmacyAddressLine2() {
		return pharmacyAddressLine2;
	}

	public void setPharmacyAddressLine2(String pharmacyAddressLine2) {
		this.pharmacyAddressLine2 = pharmacyAddressLine2;
	}

	public String getPharmacyCity() {
		return pharmacyCity;
	}

	public void setPharmacyCity(String pharmacyCity) {
		this.pharmacyCity = pharmacyCity;
	}

	public String getPharmacyState() {
		return pharmacyState;
	}

	public void setPharmacyState(String pharmacyState) {
		this.pharmacyState = pharmacyState;
	}

	public String getPharmacyZipcode() {
		return pharmacyZipcode;
	}

	public void setPharmacyZipcode(String pharmacyZipcode) {
		this.pharmacyZipcode = pharmacyZipcode;
	}

	public String getPharmacyPhoneNumber() {
		return pharmacyPhoneNumber;
	}

	public void setPharmacyPhoneNumber(String pharmacyPhoneNumber) {
		this.pharmacyPhoneNumber = pharmacyPhoneNumber;
	}

	public String getPharmacyFaxNumber() {
		return pharmacyFaxNumber;
	}

	public void setPharmacyFaxNumber(String pharmacyFaxNumber) {
		this.pharmacyFaxNumber = pharmacyFaxNumber;
	}

	public String getNcpdpId() {
		return ncpdpId;
	}

	public void setNcpdpId(String ncpdpId) {
		this.ncpdpId = ncpdpId;
	}
	
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getNpi() {
		return npi;
	}

	public void setNpi(String npi) {
		this.npi = npi;
	}

	public String getServiceLevel() {
		return serviceLevel;
	}

	public void setServiceLevel(String serviceLevel) {
		this.serviceLevel = serviceLevel;
	}

	public String getSpecialtyId() {
		return specialtyId;
	}

	public void setSpecialtyId(String specialtyId) {
		this.specialtyId = specialtyId;
	}


	public String getActiveStartTime() {
		return activeStartTime;
	}

	public void setActiveStartTime(String activeStartTime) {
		this.activeStartTime = activeStartTime;
	}

	public String getActiveEndTime() {
		return activeEndTime;
	}

	public void setActiveEndTime(String activeEndTime) {
		this.activeEndTime = activeEndTime;
	}

	public String getPharmacyId() {
		return pharmacyId;
	}

	public void setPharmacyId(String pharmacyId) {
		this.pharmacyId = pharmacyId;
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public String getUpdatedBy() {
		return updatedBy;
	}

	public void setUpdatedBy(String updatedBy) {
		this.updatedBy = updatedBy;
	}

	public String getVistaLookupId() {
		return vistaLookupId;
	}

	public void setVistaLookupId(String vistaLookupId) {
		this.vistaLookupId = vistaLookupId;
	}

	public String getFileId() {
		return fileId;
	}

	public void setFileId(String fileId) {
		this.fileId = fileId;
	}

	public String getStateLicenseNumber() {
		return stateLicenseNumber;
	}

	public void setStateLicenseNumber(String stateLicenseNumber) {
		this.stateLicenseNumber = stateLicenseNumber;
	}

	public String getMedicareNumber() {
		return medicareNumber;
	}

	public void setMedicareNumber(String medicareNumber) {
		this.medicareNumber = medicareNumber;
	}

	public String getMedicaidNumber() {
		return medicaidNumber;
	}

	public void setMedicaidNumber(String medicaidNumber) {
		this.medicaidNumber = medicaidNumber;
	}

	public String getPpoNumber() {
		return ppoNumber;
	}

	public void setPpoNumber(String ppoNumber) {
		this.ppoNumber = ppoNumber;
	}

	public String getPayerId() {
		return payerId;
	}

	public void setPayerId(String payerId) {
		this.payerId = payerId;
	}

	public String getBinLocationNumber() {
		return binLocationNumber;
	}

	public void setBinLocationNumber(String binLocationNumber) {
		this.binLocationNumber = binLocationNumber;
	}

	public String getDeaNumber() {
		return deaNumber;
	}

	public void setDeaNumber(String deaNumber) {
		this.deaNumber = deaNumber;
	}

	public String getHin() {
		return hin;
	}

	public void setHin(String hin) {
		this.hin = hin;
	}

	public String getSecondaryCoverage() {
		return secondaryCoverage;
	}

	public void setSecondaryCoverage(String secondaryCoverage) {
		this.secondaryCoverage = secondaryCoverage;
	}

	public String getNaicCode() {
		return naicCode;
	}

	public void setNaicCode(String naicCode) {
		this.naicCode = naicCode;
	}

	public String getPromotionNumber() {
		return promotionNumber;
	}

	public void setPromotionNumber(String promotionNumber) {
		this.promotionNumber = promotionNumber;
	}

	public String getStoreNumber() {
		return storeNumber;
	}

	public void setStoreNumber(String storeNumber) {
		this.storeNumber = storeNumber;
	}

	public String getPharmacistLastName() {
		return pharmacistLastName;
	}

	public void setPharmacistLastName(String pharmacistLastName) {
		this.pharmacistLastName = pharmacistLastName;
	}

	public String getPharmacistFirstName() {
		return pharmacistFirstName;
	}

	public void setPharmacistFirstName(String pharmacistFirstName) {
		this.pharmacistFirstName = pharmacistFirstName;
	}

	public String getPharmacistMiddleName() {
		return pharmacistMiddleName;
	}

	public void setPharmacistMiddleName(String pharmacistMiddleName) {
		this.pharmacistMiddleName = pharmacistMiddleName;
	}

	public String getPharmacistSuffix() {
		return pharmacistSuffix;
	}

	public void setPharmacistSuffix(String pharmacistSuffix) {
		this.pharmacistSuffix = pharmacistSuffix;
	}

	public String getPharmacistPrefix() {
		return pharmacistPrefix;
	}

	public void setPharmacistPrefix(String pharmacistPrefix) {
		this.pharmacistPrefix = pharmacistPrefix;
	}

	public String getPharmacistAgentLastName() {
		return pharmacistAgentLastName;
	}

	public void setPharmacistAgentLastName(String pharmacistAgentLastName) {
		this.pharmacistAgentLastName = pharmacistAgentLastName;
	}

	public String getPharmacistAgentFirstName() {
		return pharmacistAgentFirstName;
	}

	public void setPharmacistAgentFirstName(String pharmacistAgentFirstName) {
		this.pharmacistAgentFirstName = pharmacistAgentFirstName;
	}

	public String getPharmacistAgentMiddleName() {
		return pharmacistAgentMiddleName;
	}

	public void setPharmacistAgentMiddleName(String pharmacistAgentMiddleName) {
		this.pharmacistAgentMiddleName = pharmacistAgentMiddleName;
	}

	public String getPharmacistAgentSuffix() {
		return pharmacistAgentSuffix;
	}

	public void setPharmacistAgentSuffix(String pharmacistAgentSuffix) {
		this.pharmacistAgentSuffix = pharmacistAgentSuffix;
	}

	public String getPharmacistAgentPrefix() {
		return pharmacistAgentPrefix;
	}

	public void setPharmacistAgentPrefix(String pharmacistAgentPrefix) {
		this.pharmacistAgentPrefix = pharmacistAgentPrefix;
	}

	public String getTwentyFourHourFlag() {
		return twentyFourHourFlag;
	}

	public void setTwentyFourHourFlag(String twentyFourHourFlag) {
		this.twentyFourHourFlag = twentyFourHourFlag;
	}

	public String getCrossStreet() {
		return crossStreet;
	}

	public void setCrossStreet(String crossStreet) {
		this.crossStreet = crossStreet;
	}

	public String getInboundErxEnabled() {
		return inboundErxEnabled;
	}

	public void setInboundErxEnabled(String inboundErxEnabled) {
		this.inboundErxEnabled = inboundErxEnabled;
	}

	public String getUpdatedDate() {
		return updatedDate;
	}

	public void setUpdatedDate(String updatedDate) {
		this.updatedDate = updatedDate;
	}

	public String getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(String createdDate) {
		this.createdDate = createdDate;
	}

	public String getPharmacyEnabledDisabled() {
		return pharmacyEnabledDisabled;
	}

	public void setPharmacyEnabledDisabled(String pharmacyEnabledDisabled) {
		this.pharmacyEnabledDisabled = pharmacyEnabledDisabled;
	}
	
	
	
	
	
	
}
