package gov.va.med.pharmacy.persistence.service.impl;

import java.util.List;

import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.persistence.dao.PharmacyDao;
import gov.va.med.pharmacy.persistence.managepharmacy.ManagePharmacyFilter;
import gov.va.med.pharmacy.persistence.model.PharmacyEntity;
import gov.va.med.pharmacy.persistence.service.PharmacyService;


@Service("pharmacyService")
@Transactional
public class PharmacyServiceImpl implements PharmacyService {

	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(PharmacyServiceImpl.class);

	@Autowired
	private PharmacyDao pharmacyDao;

	@Override
	public List<PharmacyEntity> find(ManagePharmacyFilter managePharmacyFilter) {

		return pharmacyDao.find(managePharmacyFilter);
	}

	@Override
	public PharmacyEntity findByNCPDPId(String NCPDPId) {

		return pharmacyDao.findByNCPDPId(NCPDPId);
	}

	@Override
	public void savePharmacyInfo(PharmacyEntity pharmacy) throws HibernateException {

	try {
			pharmacyDao.save(pharmacy);

		} catch (HibernateException e) {

			throw new HibernateException(e);
		}
          
	  LOG.info("saved pharmacy information.");
	}

	@Override
	public PharmacyEntity findById(Long pharmacyId) throws Exception {
		
	  try {
			return pharmacyDao.findById(pharmacyId);
			
		} catch (Exception e) {
			
			throw new Exception(e);
		}
		
	}

	@Override
	public void updatePharmacyInfo(PharmacyEntity pharmacy) throws HibernateException {
	try {
			pharmacyDao.updatePharmacyInfo(pharmacy);

		} catch (HibernateException e) {

			throw new HibernateException(e);
		}
          
	  LOG.info("updated pharmacy information.");
	}
		
	

}
