package gov.va.med.pharmacy.persistence.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.persistence.dao.OutboundNcpdpMsgDao;
import gov.va.med.pharmacy.persistence.model.OutboundNcpdpMsgEntity;
import gov.va.med.pharmacy.persistence.service.OutboundNcpdpMsgService;

@Service("outboundNcpdpMsgService")
@Transactional
public class OutboundNcpdpMsgServiceImpl implements OutboundNcpdpMsgService {

	private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(OutboundNcpdpMsgServiceImpl.class);
	
	
	@Autowired
    private OutboundNcpdpMsgDao outboundNcpdpMsgDao;
	
		

	@Override
	public void saveOutboundMsg(OutboundNcpdpMsgEntity outboundMsg) throws Exception {
		try 
		{
			outboundNcpdpMsgDao.save(outboundMsg);
		} 
		catch (Exception e) {
			
			//System.out.print("error saving outbound message." + e.getMessage());
			throw new Exception (e);
		}
		
		LOG.info("saved incoming JMS message.");
		
	}



	@Override
	public OutboundNcpdpMsgEntity findById(long id) {
		
		LOG.info("getting outbound message by id.");
		
		return outboundNcpdpMsgDao.findById(id);
	}

}
