/****** Object:  StoredProcedure [MSSR].[GetMedicationsUsedBySurveyAndPatientICN]    Script Date: 7/7/2017 9:22:00 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		Michael G
-- Create date: 06/14/2017
-- Description:	Get List of Med used based on ICN
-- =============================================
CREATE PROCEDURE [MSSR].[GetMedicationsUsedBySurveyAndPatientICN]
	-- Add the parameters for the stored procedure here
	@patient_ICN varchar(50), 
	@SURVEYS_ID int
	
AS
BEGIN
	
	SET NOCOUNT ON;
   
	SELECT 
		sr.SURVEYS_ID, 
		sr.patient_ICN, 
		md.MEDICATION AS MedicationName, 
		pm.PAST_USE AS PastUse, 
		pm.MEDICATION_USED, 
		pm.CURRENT_THERAPY ,
		PAST_USE_DISPENSING_PHARMACY, 
		CURRENT_THERAPY_DISPENSING_PHARMACY, 
		md.HEALTH_FACTOR,
		md.ID,
		pm.ID as PATIENT_MED_ID,
		CASE 
			 WHEN pm.PAST_USE = 1 AND PAST_USE_DISPENSING_PHARMACY = 1 THEN 'VA Pharmacy'
			 WHEN pm.PAST_USE = 1 AND PAST_USE_DISPENSING_PHARMACY = 2 THEN 'Non-VA Pharmacy'
			 WHEN pm.CURRENT_THERAPY = 1 AND CURRENT_THERAPY_DISPENSING_PHARMACY = 1 THEN 'VA Pharmacy'
			 WHEN pm.CURRENT_THERAPY = 1 AND CURRENT_THERAPY_DISPENSING_PHARMACY = 2 THEN 'Non-VA Pharmacy'
			 ELSE 'Unknown'
		END  DispensingPharmacy,
		CASE
			WHEN pm.PAST_USE = 1 THEN 'Not Current'
			WHEN pm.CURRENT_THERAPY = 1 THEN 'Current'
			ELSE 'Unknown'
		END PastUseCurrentUse
	FROM dbo.surveys sr 
		INNER JOIN MSSR.MSSR_PATIENT_MEDICATION pm ON sr.SURVEYS_ID = pm.SURVEY_ID
		INNER JOIN mssr.MSSR_MEDICATION md ON pm.MEDICATION_ID = md.ID
		WHERE  sr.SURVEY_STATUS = 'completed' AND sr.SURVEYS_ID = @SURVEYS_ID AND sr.patient_ICN = @patient_ICN --AND MEDICATION_USED = 2
END


GO


