/****** Object:  StoredProcedure [MSSR].[GetListOfSurveysByPatientICN2]    Script Date: 7/7/2017 9:01:50 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		Michael G
-- Create date: 06/12/2017
-- Description:	Get List of Surveys by Patient ICN
-- Use: MSAT Edit page.  
-- =============================================
CREATE PROCEDURE [MSSR].[GetListOfSurveysByPatientICN2]
	@PatientICN varchar(50)
	
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

DECLARE @listOfHFCondensedID TABLE(
hf_condensed_id INT 
);
INSERT INTO @listOfHFCondensedID
	SELECT HF_Condensed_ID
	FROM  MSSR.MSSR_HF_Condensed 
	WHERE AssessmentType IS NOT NULL
	GROUP BY AssessmentDateTime, PatientICN, AssessmentType,HF_Condensed_ID


SELECT DISTINCT STD_SURVEY_TYPE_ID,
				SURVEYS_ID,
				PATIENT_ID,
				SURVEY_DATE,
				SURVEY_STATUS, 
				srvys.CREATEDBY, 
				srvys.UPDATEDBY,
				patient_ICN, 
				Sta3n, 
				AssessmentType, 
				AssessmentDateTime, 
				--MSDiagnosis, 
				--DiagnosisYear, 
				--SymptomYear,
				PatientName,
				usr.FULL_NAME,
				VISTANAME				
					
	FROM 
		(
			(SELECT STD_SURVEY_TYPE_ID, 
					SURVEYS_ID, 
					PATIENT_ID, 
					SURVEY_DATE, 
					SURVEY_STATUS, 
					Sr.CREATEDBY, 
					Sr.UPDATEDBY,
					patient_ICN,
					VISTANAME	
			FROM dbo.SURVEYS Sr INNER JOIN STD_INSTITUTION I ON I.ID=Sr.STD_INSTITUTION_id
			WHERE STD_SURVEY_TYPE_ID = 30 AND SURVEY_STATUS = 'completed' AND Sr.PATIENT_ICN=@PatientICN) srvys
				LEFT JOIN MSSR.MSSR_PATIENT_DEMS pdm ON srvys.patient_ICN = RTRIM(CONVERT(VARCHAR(50),pdm.PatientICN)))
				LEFT JOIN(SELECT PatientICN, Sta3n, AssessmentType, AssessmentDateTime, MSDiagnosis, DiagnosisYear, SymptomYear
				FROM  MSSR.MSSR_HF_Condensed WHERE HF_Condensed_ID IN(SELECT hf_condensed_id FROM @listOfHFCondensedID )) hfc 
				ON srvys.patient_ICN = RTRIM(CONVERT(VARCHAR(50),hfc.PatientICN)) 
				LEFT JOIN dbo.USERS usr ON srvys.CREATEDBY = usr.USERNAME
END


GO


