--INSTALL

IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[DVEIR].[VIEW_CPT_CODES]'))
DROP VIEW [DVEIR].[VIEW_CPT_CODES]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [DVEIR].[VIEW_CPT_CODES] WITH SCHEMABINDING AS
SELECT
	[cpt_code_id]
	,[code]
	,[code_description]
	,[CREATEDBY]
	,[UPDATEDBY]
	,[CREATED]
	,[UPDATED]
	,[ROW_VERSION]
	,[DVEIR_FLAG]
	,[EFR_FLAG]
	,[TBI_FLAG]
FROM [dbo].[STD_CPT_Code]
WHERE [code] IN ('65091','65093','65101','65103','65105','65125','65130','65135','65140','65150','65155','65175','65205'
,'65210','65220','65222','65235','65260','65265','65270','65272','65273','65275','65280','65285','65286'
,'65290','65400','65710','65730','65750','65755','65756','65770','65780','65781','65782','65815','65900'
,'65920','65930','66170','66172','66180','66185','66250','66635','66680','66682','66710','66711','66720','66761'
,'66762','66821','66825','66830','66840','66850','66852','66920','66930','66940','66982','66983','66984','66985'
,'66999','67005','67010','67028','67031','67036','67039','67041','67042','67101','67105','67107','67108','67110'
,'67112','67113','67141','67145','67299','67311','67312','67314','67316','67318','67320','67331','67332','67334'
,'67335','67340','67343','67345','67399','67400','67405','67413','67414','67430','67440','67445','67450','67505'
,'67550','67560','67599','67715','67875','67880','67882','67903','67904','67911','67930','67935','67938','67950'
,'67961','67966','67971','67973','67974','67975','67999','68320','68325','68326','68328','68330','68335','68340'
,'68360','68362','68399','68420','68700','68705','68720','68745','68750','68760','68761','68770','68801','68810'
,'68811','68815','68816','68840','68899')



GO

IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[DVEIR].[VIEW_ICD_CODES]'))
DROP VIEW [DVEIR].[VIEW_ICD_CODES]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [DVEIR].[VIEW_ICD_CODES] WITH SCHEMABINDING AS
SELECT
	[icd_code_id]
	,[code]
	,[code_description]
	,[codeset]
	,[CREATEDBY]
	,[UPDATEDBY]
	,[CREATED]
	,[UPDATED]
	,[ROW_VERSION]
	,[DVEIR_FLAG]
	,[EFR_FLAG]
	,[TBI_FLAG]
FROM dbo.STD_ICD_CODE
WHERE [code] IN ('310.2', '339.20', '339.21', '339.22', '348.1', '352.9', '360.00', '360.01', '360.02', '360.03', '360.04', 
  '360.11', '360.23', '360.24', '360.30', '360.33', '360.41', '360.42', '360.44', '360.50', '360.51', '360.52', 
  '360.53', '360.54', '360.55', '360.59', '360.60', '360.61', '360.62', '360.63', '360.64', '360.65', '360.69', 
  '361.00', '361.01', '361.02', '361.03', '361.04', '361.05', '361.06', '361.07', '361.30', '361.31', 
  '361.32', '361.33', '361.81', '361.89', '361.9', '362.54', '362.56', '362.9', '363.30', '363.32', '363.35', 
  '363.63', '364.00', '364.04', '364.10', '364.23', '364.3', '364.41', '364.42', '364.51', '364.52', '364.70', 
  '364.71', '364.72', '364.73', '364.74', '364.75', '364.76', '364.77', '365.04', '365.15', '365.31', '365.32', 
  '365.60', '365.61', '365.62', '365.65', '365.9', '366.20', '366.21', '366.22', '366.23', '366.3', '366.46', '366.50', 
  '366.9', '367.20', '367.31', '367.32', '367.51', '367.52', '368.10', '368.11', '368.12', '368.13', '368.14', '368.15', 
  '368.16', '368.2', '368.30', '368.31', '368.32', '368.33', '368.34', '368.40', '368.41', '368.42', '368.43', '368.44', 
  '368.45', '368.46', '368.47 ', '368.51', '368.52', '368.53', '368.54', '368.55', '368.59', '368.60', '368.62', 
  '368.69', '368.8', '368.9', '369.00', '369.01 ', '369.02', '369.03', '369.04', '369.05', '369.06', '369.07', '369.08', 
  '369.10', '369.11', '369.12', '369.13', '369.14', '369.15', '369.16', '369.17', '369.18', '369.20', '369.21', '369.22', 
  '369.23', '369.24', '369.25', '369.3', '369.4', '369.60', '369.61', '369.62', '369.63', '369.64', '369.65', '369.66', 
  '369.67', '369.68', '369.69', '369.70', '369.71', '369.72', '369.73', '369.74', '369.75', '369.76', '369.8', '369.9', 
  '370.00', '370.60', '370.62', '371.00', '371.01', '371.02', '371.03', '371.04', '371.05', '371.20', '371.42', '371.43', 
  '372.40', '372.41', '372.42', '372.43', '372.44', '372.45', '372.63', '372.64', '374.00', '374.10', '374.20', '374.30', 
  '376.40', '376.47', '376.50', '376.52', '376.6', '377.10', '378.00', '378.10', '378.50', '378.51', '378.52', '378.53', 
  '378.54', '378.60', '378.81', '378.83', '379.23', '379.31', '379.32', '379.33', '379.34', '379.50', '388.11', '388.12', 
  '800.0', '800.1', '800.2', '800.3', '800.4', '800.5', '800.6', '800.7', '800.8', '800.9', '801.0', '801.1', 
  '801.2', '801.3', '801.4', '801.5', '801.6', '801.7', '801.8', '801.9', '802.6', '802.7', '802.8', '803.0', '803.1', 
  '803.2', '803.3', '803.4', '803.5', '803.6', '803.7', '803.8', '803.9', '804.0', '804.1', '804.2', '804.3', '804.4', 
  '804.5', '804.6', '804.7', '804.8', '804.9', '850.0', '850.11', '850.12', '850.2', '850.3', '850.4', '850.5', 
  '85.9', '851.0', '851.1', '851.2', '851.3', '851.4', '851.5', '851.6', '851.7', '851.8', '851.9', '852.0', 
  '852.1', '852.2', '852.3', '852.4', '852.5', '853.0', '853.1', '854.0', '854.1', '870.0 ', '870.1 ', '870.2 ', 
  '870.3 ', '870.4 ', '870.8 ', '870.9 ', '871.0 ', '871.1 ', '871.2 ', '871.3 ', '871.4 ', '871.5 ', '871.6 ', '871.7 ', '871.9 ', 
  '905.0 ', '906.0 ', '906.2 ', '906.3 ', '907.0 ', '907.1 ', '918.0 ', '918.1 ', '918.2 ', '918.9 ', '921.0 ', '921.1 ', '921.2 ', 
  '921.3 ', '921.9 ', '930.0', '930.1', '930.2', '930.8', '930.9', '940.0', '940.1', '940.2', '940.3', '940.4', '940.5', '940.9', 
  '941.02', '941.12', '941.22', '941.32', '941.42', '941.52', '950.0 ', '950.1 ', '950.2 ', '950.3 ', '950.9 ', '959.01', '959.09', 
  'V15.59')


GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prcDVEIRUniquePatientReport]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[prcDVEIRUniquePatientReport]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE Proc [dbo].[prcDVEIRUniquePatientReport]
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	--SET FMTONLY ON;
	
		--Total unique DVEIR patients
		select 
			1 as rOrder
			,NULL as code
			,'Total number of unique patients with at least a single encounter based on the original DVEIR type CPT/ICD9 and ICD10 codes.' as code_description
			,COUNT(distinct r.PATIENT_ID) as cnt
		from dbo.REFERRAL r 
			inner join DVEIR.ER_ENCOUNTER e on e.REFERRAL_ID = r.REFERRAL_ID
			left outer join DVEIR.ER_DIAG_DTL dd on dd.ER_ENCOUNTER_ID = e.ER_ENCOUNTER_ID 
			left outer join DVEIR.VIEW_ICD_CODES vwi on vwi.icd_code_id = dd.icd_code_id
			left outer join DVEIR.ER_PROCEDURE_DTL pd on pd.ER_ENCOUNTER_ID = e.ER_ENCOUNTER_ID
			left outer join DVEIR.VIEW_CPT_CODES vwc on vwc.cpt_code_id = pd.CPT_CODE_ID
		where
			vwi.icd_code_id is not null or vwc.cpt_code_id is not null
				
	union all

		--Total DVEIR encounters
		select 
			2 as rOrder
			,NULL as code
			,'Total number of encounters based on the original DVEIR type CPT/ICD9 and ICD10 codes for DVEIR patients.' as code_description
			,COUNT(distinct e.ER_ENCOUNTER_ID) as cnt 
		from DVEIR.ER_ENCOUNTER e 
			left outer join DVEIR.ER_DIAG_DTL dd on dd.ER_ENCOUNTER_ID = e.ER_ENCOUNTER_ID 
			left outer join DVEIR.VIEW_ICD_CODES vwi on vwi.icd_code_id = dd.icd_code_id
			left outer join DVEIR.ER_PROCEDURE_DTL pd on pd.ER_ENCOUNTER_ID = e.ER_ENCOUNTER_ID
			left outer join DVEIR.VIEW_CPT_CODES vwc on vwc.cpt_code_id = pd.CPT_CODE_ID
		where
			vwi.icd_code_id is not null or vwc.cpt_code_id is not null

	union all

		--ICD (Diagnosis)
		select 
			3 as rOrder
			,vw.code as code
			,vw.code_description as code_description
			,COUNT(distinct r.PATIENT_ID) as cnt
		from DVEIR.VIEW_ICD_CODES vw 
			left join DVEIR.ER_DIAG_DTL d on d.ICD_CODE_ID = vw.icd_code_id
			join DVEIR.ER_ENCOUNTER e on e.ER_ENCOUNTER_ID = d.ER_ENCOUNTER_ID
			join dbo.REFERRAL r on r.REFERRAL_ID = e.REFERRAL_ID
		group by vw.code,vw.code_description

	union all

		--CPT
		select 
			4 as rOrder
			,vw.code as code
			,vw.code_description as code_description
			,COUNT(distinct r.PATIENT_ID) as cnt
		from DVEIR.VIEW_CPT_CODES vw
			left join DVEIR.ER_PROCEDURE_DTL d on d.CPT_CODE_ID = vw.cpt_code_id
			join DVEIR.ER_ENCOUNTER e on e.ER_ENCOUNTER_ID = d.ER_ENCOUNTER_ID
			join dbo.REFERRAL r on r.REFERRAL_ID = e.REFERRAL_ID
		group by vw.code,vw.code_description

	--union all

		----ICD (Procedure)
		--select 
		--	5 as rOrder
		--	,code
		--	,code_description
		--	,SUM(cnt)
		--from 
		--(
		--	select 
		--		p.CODE as code
		--		,(select top 1 p2.DESCRIPTION_TEXT from DVEIR.ER_PROCEDURE_DTL p2 where p2.CODE=p.code and p2.DESCRIPTION_TEXT IS NOT NULL) as code_description
		--		,COUNT(p.ER_PROCEDURE_DTL_ID) as cnt
		--	from DVEIR.ER_PROCEDURE_DTL p 
		--	where p.ICD9_FLAG=1
		--	group by p.CODE
		--) as t group by code,code_description

	order by rOrder,cnt desc,code

END




GO

IF NOT EXISTS(SELECT * FROM dbo.STD_APPPAGE WHERE CODE = 'UNIQUE_PATIENT_REPORT')
BEGIN
	INSERT INTO dbo.STD_APPPAGE (CODE,NAME,DESCRIPTION_TEXT,SORT_ORDER,INACTIVE_FLAG,INACTIVE_DATE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
	VALUES ('UNIQUE_PATIENT_REPORT','UNIQUE_PATIENT_REPORT','UNIQUE PATIENT REPORT',1,0,NULL,'vhaispblanct','vhaispblanct',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
END
GO

IF NOT EXISTS(SELECT * FROM dbo.ROLE_PERMISSIONS rp inner join dbo.STD_ROLE sr ON sr.ID = rp.STD_ROLE_ID AND sr.CODE = 'DVEIR ADMINISTRATOR' inner join dbo.STD_APPPAGE sa on sa.ID = rp.STD_APPPAGE_ID AND sa.CODE = 'UNIQUE_PATIENT_REPORT')
BEGIN
	INSERT INTO dbo.ROLE_PERMISSIONS (STD_ROLE_ID,STD_APPPAGE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,INSERT_FLAG,UPDATE_FLAG,DELETE_FLAG)
	SELECT
	(SELECT [ID] FROM dbo.STD_ROLE WHERE CODE = 'DVEIR ADMINISTRATOR')
	,(SELECT [ID] FROM dbo.STD_APPPAGE WHERE CODE = 'UNIQUE_PATIENT_REPORT')
	,'vhaispblanct','vhaispblanct',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,1,0;
END
GO

IF NOT EXISTS(SELECT * FROM dbo.ROLE_PERMISSIONS rp inner join dbo.STD_ROLE sr ON sr.ID = rp.STD_ROLE_ID AND sr.CODE = 'DVEIR MEDICAL PROFESSIONAL' inner join dbo.STD_APPPAGE sa on sa.ID = rp.STD_APPPAGE_ID AND sa.CODE = 'UNIQUE_PATIENT_REPORT')
BEGIN
	INSERT INTO dbo.ROLE_PERMISSIONS (STD_ROLE_ID,STD_APPPAGE_ID,CREATEDBY,UPDATEDBY,CREATED,UPDATED,INSERT_FLAG,UPDATE_FLAG,DELETE_FLAG)
	SELECT
	(SELECT [ID] FROM dbo.STD_ROLE WHERE CODE = 'DVEIR MEDICAL PROFESSIONAL')
	,(SELECT [ID] FROM dbo.STD_APPPAGE WHERE CODE = 'UNIQUE_PATIENT_REPORT')
	,'vhaispblanct','vhaispblanct',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,0,1,0;
END
GO
