
/****** Object:  StoredProcedure [dbo].[EFRDataExportBioQuestionnaire]    Script Date: 09/09/2013 14:54:50 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EFRDataExportBioQuestionnaire]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EFRDataExportBioQuestionnaire]
GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportBioQuestionnaire]    Script Date: 09/09/2013 14:54:50 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [dbo].[EFRDataExportBioQuestionnaire]
	/*
	(
	@parameter1 int = 5,
	@parameter2 datatype OUTPUT
	)
	*/
AS
	/* SET NOCOUNT ON */
SELECT     
					WC.REFERRAL_ID, P.SSN, P.PATIENT_ICN, P.LAST_NAME, P.FIRST_NAME, P.MIDDLE_NAME, 
					W.WKF_CASE_ID AS WORKFLOW_ID, 
					K.WKF_CASE_ACTIVITY_ID AS QUESTIONNAIRE_ID,

					K.VAMC_Name AS QUESTIONNAIRE_VAMC_NAME, 
					QUESTIONNAIRE_VAMC_NUMBER=case when PATINDEX('%(%',K.VAMC_Name)>0 and PATINDEX('%)%',K.VAMC_Name)>3 then SUBSTRING(K.VAMC_Name,PATINDEX('%(%',K.VAMC_Name)+1,(PATINDEX('%)%',K.VAMC_Name)-2))
												 else ''
											 end,
					K.VAMC_Street_Address1, 
					K.VAMC_Street_Address2, 
					K.VAMC_Street_Address3, 
					K.VAMC_City, 
					K.VAMC_State, 
					K.VAMC_PostalCiode AS VAMC_PostalCode, 
					K.VAMC_ZipPlus4, 
					K.VAMC_Country, CONVERT(varchar, 
					K.Form_Complete_Date, 101) AS Form_Complete_Date, CONVERT(int,
					--[dbo].[GetEFRBranchOfService] (BRANCH_OF_SERVICE_ARMY, BRANCH_OF_SERVICE_NAVY, BRANCH_OF_SERVICE_MARINES, BRANCH_OF_SERVICE_AIRFORCE, BRANCH_OF_SERVICE_NATIONALGUARD, BRANCH_OF_SERVICE_RESERVE) AS Branch_Of_Service, 
					IsNull(K.BRANCH_OF_SERVICE_ARMY,0)) as Army, CONVERT(int,
					IsNull(K.BRANCH_OF_SERVICE_NAVY,0)) as Navy, CONVERT(int,
					IsNull(K.BRANCH_OF_SERVICE_MARINES,0)) as 'Marine Corps', CONVERT(int,
					IsNull(K.BRANCH_OF_SERVICE_AIRFORCE,0)) as 'Air Force', CONVERT(int,
					IsNull(K.BRANCH_OF_SERVICE_NATIONALGUARD,0)) as 'National Guard', CONVERT(int,
					IsNull(K.BRANCH_OF_SERVICE_RESERVE,0)) as Reserve,
					[dbo].[GetEFRInjuryLocation] (INJURY_GEOGRAPHICAL_LOCATION_AFGHANISTAN, INJURY_GEOGRAPHICAL_LOCATION_IRAQ, INJURY_GEOGRAPHICAL_LOCATION_OTHER_LOCATION) AS Injury_Geographical_Location, 
					K.Injury_Geographical_Location_other, 
					K.Injury_City AS Injury_City_Iraq, 
					K.Injury_Month, 
					K.Injury_Day, 
					K.Injury_Year, 
					K.Who_Referred_You, 
					K.Who_Referred_You_Other, 
					K.Bullet_Injury_Ind, 
					K.Blast_Explosion_Ind, 
					K.Distance_from_Explosion_Meter, 
					K.Injured_on_Vehicle_Ind, 
					K.Injured_by_OtherSource_Desc, CONVERT(int, 
					K.Injured_by_IED_FLAG) AS Injured_by_IED_FLAG, CONVERT(int, 
					K.Injured_by_RPG_FLAG) AS Injured_by_RPG_FLAG, CONVERT(int, 
					K.Injured_by_LandMine_FLAG) AS Injured_by_LandMine_FLAG, CONVERT(int, 
					K.Injured_by_Grenade_FLAG) AS Injured_by_Grenade_FLAG, CONVERT(int, 
					K.Injured_by_EnemyFire_FLAG) AS Injured_by_EnemyFire_FLAG, CONVERT(int, 
					K.Injured_by_FriendlyFire_FLAG) AS Injured_by_FriendlyFire_FLAG, CONVERT(int, 
					K.Injured_by_UnknownSource_FLAG) AS Injured_by_UnknownSource_FLAG, 
					CONVERT(int, K.Injured_by_OtherSource_FLAG) AS Injured_by_OtherSource_FLAG,
					CONVERT(int, K.Injury_Back_Head) AS Injury_Back_Head, CONVERT(int, 
					K.Injury_Back_Neck) AS Injury_Back_Neck, CONVERT(int, 
					K.Injury_Upper_Back) AS Injury_Upper_Back, CONVERT(int, 
					K.Injury_Lower_Back) AS Injury_Lower_Back, CONVERT(int, 
					K.Injury_Buttocks) AS Injury_Buttocks, CONVERT(int, 
					K.Injury_Front_Head) AS Injury_Front_Head, CONVERT(int, 
					K.Injury_Front_Neck) AS Injury_Front_Neck, CONVERT(int, 
					K.Injury_Chest) AS Injury_Chest, CONVERT(int, 
					K.Injury_Abdomen) AS Injury_Abdomen, CONVERT(int, 
					K.Injury_Groin_Pelvis) AS Injury_Groin_Pelvis, CONVERT(int, 
					K.Injury_Left_Shoulder) AS Injury_Left_Shoulder, CONVERT(int, 
					K.Injury_Left_Upper_Arm) AS Injury_Left_Upper_Arm, CONVERT(int, 
					K.Injury_Left_Lower_Arm) AS Injury_Left_Lower_Arm, CONVERT(int, 
					K.Injury_Left_Hand_Wrist_Fingers) AS Injury_Left_Hand_Wrist_Fingers, 
					CONVERT(int, K.Injury_Left_Upper_Leg_Thigh) AS Injury_Left_Upper_Leg_Thigh, 
					CONVERT(int, K.Injury_Left_Knee) AS Injury_Left_Knee, CONVERT(int, 
					K.Injury_Left_Lower_Leg) AS Injury_Left_Lower_Leg, CONVERT(int, 
					K.Injury_Left_Ankle) AS Injury_Left_Ankle, CONVERT(int, 
					K.Injury_Left_Foot_Toes) AS Injury_Left_Foot_Toes, CONVERT(int, 
					K.Injury_Right_Shoulder) AS Injury_Right_Shoulder, CONVERT(int, 
					K.Injury_Right_Upper_Arm) AS Injury_Right_Upper_Arm, CONVERT(int, 
					K.Injury_Right_Lower_Arm) AS Injury_Right_Lower_Arm, CONVERT(int, 
					K.Injury_Right_Hand_Wrist_Fingers) AS Injury_Right_Hand_Wrist_Fingers, 
					CONVERT(int, K.Injury_Right_Upper_Leg_Thigh) 
					AS Injury_Right_Upper_Leg_Thigh, CONVERT(int, K.Injury_Right_Knee) 
					AS Injury_Right_Knee, CONVERT(int, K.Injury_Right_Lower_Leg) 
					AS Injury_Right_Lower_Leg, CONVERT(int, K.Injury_Right_Ankle) 
					AS Injury_Right_Ankle, CONVERT(int, K.Injury_Right_Foot_Toes) 
					AS Injury_Right_Foot_Toes, K.Shrapnel_Frag_Bullet_Surgery_Ind, 
					K.Send_to_Lab_Analysis_Ind, 
					K.Fragment_Remains_inPatient_Ind, CONVERT(int, 
					K.Remain_in_Back_Head) AS Remain_in_Back_Head, CONVERT(int, 
					K.Remain_in_Back_Neck) AS Remain_in_Back_Neck, CONVERT(int, 
					K.Remain_in_Upper_Back) AS Remain_in_Upper_Back, CONVERT(int, 
					K.Remain_in_Lower_Back) AS Remain_in_Lower_Back, CONVERT(int, 
					K.Remain_in_Buttocks) AS Remain_in_Buttocks, CONVERT(int, 
					K.Remain_in_Front_Head) AS Remain_in_Front_Head, CONVERT(int, 
					K.Remain_in_Front_Neck) AS Remain_in_Front_Neck, CONVERT(int, 
					K.Remain_in_Chest) AS Remain_in_Chest, CONVERT(int, 
					K.Remain_in_Abdomen) AS Remain_in_Abdomen, CONVERT(int, 
					K.Remain_in_Groin_Pelvis) AS Remain_in_Groin_Pelvis, CONVERT(int, 
					K.Remain_in_Left_Shoulder) AS Remain_in_Left_Shoulder, CONVERT(int, 
					K.Remain_in_Left_Upper_Arm) AS Remain_in_Left_Upper_Arm, CONVERT(int, 
					K.Remain_in_Left_Lower_Arm) AS Remain_in_Left_Lower_Arm, CONVERT(int, 
					K.Remain_in_Left_Hand_Wrist_Fingers) AS Remain_in_Left_Hand_Wrist_Fingers, 
					CONVERT(int, K.Remain_in_Left_Upper_Leg_Thigh) 
					AS Remain_in_Left_Upper_Leg_Thigh, CONVERT(int, K.Remain_in_Left_Knee) 
					AS Remain_in_Left_Knee, CONVERT(int, K.Remain_in_Left_Lower_Leg) 
					AS Remain_in_Left_Lower_Leg, CONVERT(int, K.Remain_in_Left_Ankle) 
					AS Remain_in_Left_Ankle, CONVERT(int, K.Remain_in_Left_Foot_Toes) 
					AS Remain_in_Left_Foot_Toes, CONVERT(int, K.Remain_in_Right_Shoulder) 
					AS Remain_in_Right_Shoulder, CONVERT(int, K.Remain_in_Right_Upper_Arm) 
					AS Remain_in_Right_Upper_Arm, CONVERT(int, K.Remain_in_Right_Lower_Arm) 
					AS Remain_in_Right_Lower_Arm, CONVERT(int, 
					K.Remain_in_Right_Hand_Wrist_Fingers) 
					AS Remain_in_Right_Hand_Wrist_Fingers, CONVERT(int, 
					K.Remain_in_Right_Upper_Leg_Thigh) AS Remain_in_Right_Upper_Leg_Thigh, 
					CONVERT(int, K.Remain_in_Right_Knee) AS Remain_in_Right_Knee, 
					CONVERT(int, K.Remain_in_Right_Lower_Leg) AS Remain_in_Right_Lower_Leg, 
					CONVERT(int, K.Remain_in_Right_Ankle) AS Remain_in_Right_Ankle, 
					CONVERT(int, K.Remain_in_Right_Foot_Toes) AS Remain_in_Right_Foot_Toes, 
					CONVERT(int, K.TREATLOCAT_FIELD) AS TREATLOCAT_FIELD, CONVERT(int, 
					K.TREATLOCAT_SUPPORTHOSP) AS TREATLOCAT_SUPPORTHOSP, CONVERT(int, 
					K.TREATLOCAT_GERMANY) AS TREATLOCAT_GERMANY, CONVERT(int, 
					K.TREATLOCAT_FACILITY) AS TREATLOCAT_US_FACILITY, CONVERT(int, 
					K.TREATLOCAT_MEDCENTER) AS TREATLOCAT_MEDCENTER, 
					K.TREATLOCAT_FIELD_Where, 
					K.TREATLOCAT_SUPPORTHOSP_Where, 
					K.TREATLOCAT_FACILITY_Where AS TREATLOCAT_US_FACILITY_WHERE, 
					K.TREATLOCAT_MEDCENTER_Where, 
					K.Other_Foreign_Material_Ind, 
					K.Other_Foreign_Material_Desc, 
					K.Other_Foreign_Material_DescLoca, 
					K.Shrapnel_In_Body_Ind, 
					K.Shrapnel_In_Body_Desc, 
					K.Shrapnel_In_Body_DescLoca, 
					K.Urine_Collection_Ind, CONVERT(varchar, K.Date_Urine_Collected, 101) AS Date_Urine_Collected, CONVERT(int,
					IsNull(K.PAST_YEAR_WELDING_FLAG,0)) AS PAST_YEAR_WELDING, CONVERT(int,
					IsNull(K.PAST_YEAR_SOLDERING_FLAG,0)) AS PAST_YEAR_SOLDERING, CONVERT(int,
					IsNull(K.PAST_YEAR_SMELTING_FLAG,0)) AS PAST_YEAR_SMELTING, CONVERT(int,
					IsNull(K.PAST_YEAR_MINING_FLAG,0)) AS PAST_YEAR_MINING, CONVERT(int,
					IsNull(K.PAST_YEAR_DEMOLITION_FLAG,0)) AS PAST_YEAR_DEMOLITION, CONVERT(int,
					IsNull(K.PAST_YEAR_SAND_BLASTING_FLAG,0)) AS PAST_YEAR_SAND_BLASTING, CONVERT(int,
					IsNull(K.PAST_YEAR_MACHINING_FLAG,0)) AS PAST_YEAR_MACHINING, CONVERT(int,
					IsNull(K.PAST_YEAR_OTHER_MANUFACTURING_FLAG,0)) AS PAST_YEAR_OTHER_MANUFACTURING, CONVERT(int,
					IsNull(K.PAST_YEAR_FIRING_RANGE_USE_FLAG,0)) AS PAST_YEAR_FIRING_RANGE_USE, CONVERT(int,
					IsNull(K.PAST_YEAR_MAKING_BULLETS_FLAG,0)) AS PAST_YEAR_MAKING_BULLETS, CONVERT(int,
					IsNull(K.PAST_YEAR_LEAD_PAINT_FLAG,0)) AS PAST_YEAR_LEAD_PAINT, CONVERT(int,
					IsNull(K.PAST_YEAR_ANTI_FOULANT_FLAG,0)) AS PAST_YEAR_ANTI_FOULANT, CONVERT(int,
					IsNull(K.PAST_YEAR_WOOD_PRESERVATIVES_FLAG,0)) AS PAST_YEAR_WOOD_PRESERVATIVES, CONVERT(int,
					IsNull(K.PAST_YEAR_FISHING_WEIGHTS_FLAG,0)) AS PAST_YEAR_FISHING_WEIGHTS, CONVERT(int,
					IsNull(K.PAST_YEAR_STAINED_GLASS_FLAG,0)) AS PAST_YEAR_STAINED_GLASS, CONVERT(int,
					IsNull(K.PAST_YEAR_JEWELRY_OR_ART_METALS_FLAG,0)) AS PAST_YEAR_JEWELRY_OR_ART_METALS, CONVERT(int,
					IsNull(K.PAST_YEAR_NOT_WORKED_IN_OCCUPATION_HOBBY_FLAG,0)) AS PAST_YEAR_NOT_WORKED_IN_OCCUPATION_HOBBY, 
					--CONVERT(int, K.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG) AS PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE,					
					CASE WHEN K.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG=0 THEN 'N'
					     WHEN K.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG=1 THEN 'Y'
					     WHEN K.PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE_FLAG is NULL THEN 'R'
					END AS PAST_YEAR_IN_OCCUPATION_WITH_EXPOSURE,
					K.PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESC AS PAST_YEAR_OCCUPATION_WITH_EXPOSURE_DESCRIPTION, 
					--CONVERT(int, K.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG) AS PAST_YEAR_IN_HOBBY_WITH_EXPOSURE,					
					CASE WHEN K.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG=0 THEN 'N'
					     WHEN K.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG=1 THEN 'Y'
					     WHEN K.PAST_YEAR_IN_HOBBY_WITH_EXPOSURE_FLAG is NULL THEN 'R'
					END AS PAST_YEAR_IN_HOBBY_WITH_EXPOSURE,
					K.PAST_YEAR_HOBBY_WITH_EXPOSURE_DESC AS PAST_YEAR_HOBBY_WITH_EXPOSURE_DESCRIPTION, CONVERT(int,
					IsNull(K.DEVICE_IMPLANTED_PACEMAKER_DEFIBRILLATOR_FLAG,0)) AS DEVICE_IMPLANTED_PACEMAKER_DEFIBRILLATOR, CONVERT(int,
					IsNull(K.DEVICE_IMPLANTED_STENTS_FLAG,0)) AS DEVICE_IMPLANTED_STENTS, CONVERT(int,
					IsNull(K.DEVICE_IMPLANTED_SURGICAL_CLIPS_FLAG,0)) AS DEVICE_IMPLANTED_SURGICAL_CLIPS, CONVERT(int,
					IsNull(K.DEVICE_IMPLANTED_METAL_PLATES_SCREWS_RODS_FLAG,0)) AS DEVICE_IMPLANTED_METAL_PLATES_SCREWS_RODS, CONVERT(int,
					IsNull(K.DEVICE_IMPLANTED_DENTAL_IMPLANTS_FLAG,0)) AS DEVICE_IMPLANTED_DENTAL_IMPLANTS, CONVERT(int,
					IsNull(K.DEVICE_IMPLANTED_HIP_KNEE_SHOULDER_REPL_FLAG,0)) AS DEVICE_IMPLANTED_HIP_KNEE_SHOULDER_REPL, CONVERT(int,
					IsNull(K.DEVICE_IMPLANTED_OTHER_MED_DEVICE_FLAG,0)) AS DEVICE_IMPLANTED_OTHER_MED_DEVICE,
					K.DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESC AS DEVICE_IMPLANTED_OTHER_MED_DEVICE_DESCRIPTION, CONVERT(int,
					IsNull(K.DEVICE_IMPLANTED_NONE_FLAG,0)) AS DEVICE_IMPLANTED_NONE,
					K.[DEVICE_IMPLANTED_LOCATION1],
					K.[DEVICE_IMPLANTED_YEAR1],
					K.[DEVICE_IMPLANTED_LOCATION2],
					K.[DEVICE_IMPLANTED_YEAR2],
					K.[DEVICE_IMPLANTED_LOCATION3],
					K.[DEVICE_IMPLANTED_YEAR3],
					K.[DEVICE_IMPLANTED_LOCATION4],
					K.[DEVICE_IMPLANTED_YEAR4], CONVERT(int,
					IsNull(K.HAVE_METAL_TEETH_BRACES_FLAG,0)) AS HAVE_METAL_TEETH_BRACES, CONVERT(int,
					IsNull(K.HAVE_PIERCINGS_FLAG,0)) AS HAVE_PIERCINGS, CONVERT(int,
					IsNull(K.HAVE_TATOOS_FLAG,0)) AS HAVE_TATOOS, CONVERT(int,
					IsNull(K.HAVE_NONE_ABOVE_FLAG,0)) AS HAVE_NONE_ABOVE, CONVERT(int,
					IsNull(K.ROUTINELY_USE_ZINC_SUNBLOCK_FLAG,0)) AS ROUTINELY_USE_ZINC_SUNBLOCK, CONVERT(int,
					IsNull(K.ROUTINELY_USE_DIETARY_SUPPLEMENTS_FLAG,0)) AS ROUTINELY_USE_DIETARY_SUPPLEMENTS, CONVERT(int,
					IsNull(K.ROUTINELY_USE_VITAMINS_FLAG,0)) AS ROUTINELY_USE_VITAMINS, CONVERT(int,
					IsNull(K.ROUTINELY_USE_AYURVEDIC_MEDS_FLAG,0)) AS ROUTINELY_USE_AYURVEDIC_MEDS, CONVERT(int,
					IsNull(K.ROUTINELY_USE_DENTURE_CREAM_FLAG,0)) AS ROUTINELY_USE_DENTURE_CREAM, CONVERT(int,
					IsNull(K.ROUTINELY_USE_NONE_ABOVE_FLAG,0)) AS ROUTINELY_USE_NONE_ABOVE, 
					--CONVERT(int, K.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG) AS PRIMARY_WATER_COMMUNITY_SYSTEM, 					
					CASE WHEN K.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG=0 THEN 'N'
					     WHEN K.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG=1 THEN 'Y'
					     WHEN K.PRIMARY_WATER_COMMUNITY_SYSTEM_FLAG is NULL THEN 'R'
					END AS PRIMARY_WATER_COMMUNITY_SYSTEM,
					--CONVERT(int, K.PRIMARY_WATER_PRIVATE_WELL_FLAG) AS PRIMARY_WATER_PRIVATE_WELL, 					
					CASE WHEN K.PRIMARY_WATER_PRIVATE_WELL_FLAG=0 THEN 'N'
					     WHEN K.PRIMARY_WATER_PRIVATE_WELL_FLAG=1 THEN 'Y'
					     WHEN K.PRIMARY_WATER_PRIVATE_WELL_FLAG is NULL THEN 'R'
					END AS PRIMARY_WATER_PRIVATE_WELL,
					--CONVERT(int, K.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG) AS CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES, 					
					CASE WHEN K.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG=0 THEN 'N'
					     WHEN K.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG=1 THEN 'Y'
					     WHEN K.CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES_FLAG is NULL THEN 'R'
					END AS CURRENTLY_SMOKE_CIGARETTES_CIGARS_PIPES,
					--CONVERT(int, K.CURRENTLY_CHEW_TOBACCO_FLAG) AS CURRENTLY_CHEW_TOBACCO, 
					CASE WHEN K.CURRENTLY_CHEW_TOBACCO_FLAG=0 THEN 'N'
					     WHEN K.CURRENTLY_CHEW_TOBACCO_FLAG=1 THEN 'Y'
					     WHEN K.CURRENTLY_CHEW_TOBACCO_FLAG is NULL THEN 'R'
					END AS [CURRENTLY_CHEW_TOBACCO],
					CONVERT(int,   
					K.FORM_2009_FLAG) as FORM_2009, CONVERT(int,
					K.FORM_2012_FLAG) as FORM_2012               
FROM         WKF_CASE_ACTIVITY W INNER JOIN
                      WKF_CASE WC ON W.WKF_CASE_ID = WC.WKF_CASE_ID INNER JOIN
                      EFR.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT  K ON 
                      W.WKF_CASE_ACTIVITY_ID = K.WKF_CASE_ACTIVITY_ID INNER
                       JOIN
                      PATIENT  P ON WC.PATIENT_ID = P.PATIENT_ID
WHERE     (w.STD_WKFACTIVITYSTS_ID = 2)


GO


begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('06'
           ,'07'
           ,'001'
           ,0
           ,'23360: Biomonitoring Export - synchronize displayed data with View for form version.'
		   ,'*** Rollback ***'
           ,'EFR'
           ,GETDATE())
end
GO