-- Rollback scripts 06.05.001.20708.sql
-- 20708: Add Missing / Incorrect Diagnosis Codes


---- Foreign in [DVEIR].[ER_DIAG_DTL]

IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = object_id(N'[DVEIR].[FK_ER_DIAG_DTL_ICD_CODE_ID]') AND parent_object_id = object_id(N'[DVEIR].[ER_DIAG_DTL]'))

ALTER TABLE [DVEIR].[ER_DIAG_DTL] 
DROP CONSTRAINT [FK_ER_DIAG_DTL_ICD_CODE_ID]
GO

IF  EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_DIAG_DTL' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_DIAG_DTL]
DROP COLUMN [ICD_CODE_ID]
END
GO


IF  EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_DIAG_DTL_H' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_DIAG_DTL_H]
DROP COLUMN [ICD_CODE_ID]
END
GO


---- Foreign in [DVEIR].[ER_DIAG_DTL_ETL]

IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = object_id(N'[DVEIR].[FK_ER_DIAG_DTL_ETL_ICD_CODE_ID]') AND parent_object_id = object_id(N'[DVEIR].[ER_DIAG_DTL_ETL]'))

ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL]  
DROP CONSTRAINT [FK_ER_DIAG_DTL_ETL_ICD_CODE_ID]
GO

IF  EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_DIAG_DTL_ETL' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL]
DROP COLUMN [ICD_CODE_ID]
END
GO



---- Foreign in [DVEIR].[ER_PROCEDURE_DTL]

IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = object_id(N'[DVEIR].[FK_ER_PROCEDURE_DTL_ICD_CODE_ID]') AND parent_object_id = object_id(N'[DVEIR].[ER_PROCEDURE_DTL]'))

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL]  
DROP CONSTRAINT [FK_ER_PROCEDURE_DTL_ICD_CODE_ID]
GO

IF  EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_PROCEDURE_DTL' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL]
DROP COLUMN [ICD_CODE_ID]
END
GO


IF  EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_PROCEDURE_DTL_H' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_H]
DROP COLUMN [ICD_CODE_ID] 
END
GO

-- Trigger for the history tables
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_DIAG_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DIAG_DTL_DEL_H]
GO

CREATE TRIGGER  [DVEIR].[TRG_ER_DIAG_DTL_DEL_H]
on  [DVEIR].[ER_DIAG_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
From Deleted
End

GO

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_DIAG_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DIAG_DTL_H]
GO

CREATE trigger [DVEIR].[TRG_ER_DIAG_DTL_H] on [DVEIR].[ER_DIAG_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
FROM INSERTED
End

GO
	
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
GO

CREATE TRIGGER  [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
on  [DVEIR].[ER_PROCEDURE_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
From Deleted
End

GO

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_H]
GO

CREATE trigger [DVEIR].[TRG_ER_PROCEDURE_DTL_H] on [DVEIR].[ER_PROCEDURE_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
FROM INSERTED
End

GO


begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('06'
           ,'05'
           ,'001'
           ,0
           ,'20708: Add Missing / Incorrect Diagnosis Codes'
		   ,'*** Rollback ****'
           ,'DVEIR'
           ,GETDATE())
end
GO
