-- 20710: Add Missing / Incorrect Procedure Codes


if not exists(Select * from sys.columns where name='DVEIR_FLAG' and object_id=object_id('STD_CPT_CODE'))
BEGIN
	alter table STD_CPT_CODE
	add [DVEIR_FLAG] [BIT] NOT NULL CONSTRAINT [DF_STD_CPT_CODE_DVEIR_FLAG] DEFAULT 0

	alter table STD_CPT_CODE
	add [EFR_FLAG] [BIT] NOT NULL CONSTRAINT [DF_STD_CPT_CODE_FER_FLAG] DEFAULT 0

	alter table STD_CPT_CODE
	add [TBI_FLAG] [BIT] NOT NULL CONSTRAINT [DF_STD_CPT_CODE_TBI_FLAG] DEFAULT 0

	alter table STD_CPT_CODE
	alter column [CODE] [varchar](50) NOT NULL 

	alter table STD_CPT_CODE
	alter column [CODE_DESCRIPTION] [varchar](MAX) NOT NULL

END
GO	

--- Foreign Key in [DVEIR].[ER_PROCEDURE_DTL]
IF  NOT EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_PROCEDURE_DTL' AND name = 'CPT_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL]
ADD [CPT_CODE_ID] INT NULL
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = object_id(N'[DVEIR].[FK_ER_PROCEDURE_DTL_CPT_CODE_ID]') AND parent_object_id = object_id(N'[DVEIR].[ER_PROCEDURE_DTL]'))

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL]  WITH CHECK ADD CONSTRAINT [FK_ER_PROCEDURE_DTL_CPT_CODE_ID] FOREIGN KEY([CPT_CODE_ID])
REFERENCES [dbo].[STD_CPT_CODE] ([CPT_CODE_ID])
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL] CHECK CONSTRAINT [FK_ER_PROCEDURE_DTL_CPT_CODE_ID]
GO

IF  NOT EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_PROCEDURE_DTL_H' AND name = 'CPT_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_H]
ADD [CPT_CODE_ID] INT NULL
END
GO

--- Foreign Key in [DVEIR].[ER_PROCEDURE_DTL_ETL]
IF  NOT EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_PROCEDURE_DTL_ETL' AND name = 'CPT_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL]
ADD [CPT_CODE_ID] INT NULL
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = object_id(N'[DVEIR].[FK_ER_PROCEDURE_DTL_ETL_CPT_CODE_ID]') AND parent_object_id = object_id(N'[DVEIR].[ER_PROCEDURE_DTL_ETL]'))

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL]  WITH CHECK ADD CONSTRAINT [FK_ER_PROCEDURE_DTL_ETL_CPT_CODE_ID] FOREIGN KEY([CPT_CODE_ID])
REFERENCES [dbo].[STD_CPT_CODE] ([CPT_CODE_ID])
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] CHECK CONSTRAINT [FK_ER_PROCEDURE_DTL_ETL_CPT_CODE_ID]
GO

--- Triggers
/****** Object:  Trigger [TRG_ER_PROCEDURE_DTL_DEL_H]    Script Date: 09/11/2013 10:48:06 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
GO


CREATE TRIGGER  [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
on  [DVEIR].[ER_PROCEDURE_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
, [ICD_CODE_ID]
, [CPT_CODE_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
, [ICD_CODE_ID]
, [CPT_CODE_ID]
From Deleted
End


GO


/****** Object:  Trigger [TRG_ER_PROCEDURE_DTL_H]    Script Date: 09/11/2013 10:49:37 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_H]
GO


CREATE trigger [DVEIR].[TRG_ER_PROCEDURE_DTL_H] on [DVEIR].[ER_PROCEDURE_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
, [ICD_CODE_ID]
, [CPT_CODE_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
, [ICD_CODE_ID]
, [CPT_CODE_ID]
FROM INSERTED
End


GO


-----------------------------------------------------------------------
-- Insert CPT code lookup data from CDW.dim_procedures table
-----------------------------------------------------------------------

DELETE FROM [dbo].[STD_CPT_Code]

SET IDENTITY_INSERT [dbo].[STD_CPT_Code] ON
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1001, N'0002F', N'TOBACCO USE, SMOKING, ASSESSED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1002, N'0006F', N'STATIN THERAPY, PRESCRIBED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1003, N'0006T', N'TRANSCATHETER PLACEMENT OF EXTRACRANIAL CEREBROVASCULAR ARTERY STENT(S), PERCUTANEOUS; EACH ADDITIONAL VESSEL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1004, N'0010F', N'ANGINAL SYMPTOMS AND LEVEL OF ACTIVITY, ASSESSED USING A STANDARDIZED INSTRUMENT (EG, CANADIAN CARDIOVASCULAR SOCIETY CLASSIFICATION-CCSC-SYSTEM, SEATTLE ANGINA QUESTIONNAIRE-SAQ)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1005, N'00120', N'ANESTHESIA FOR PROCEDURES ON EXTERNAL, MIDDLE, AND INNER EAR INCLUDING BIOPSY; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1006, N'00140', N'ANESTHESIA FOR PROCEDURES ON EYE; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1007, N'00144', N'ANESTHESIA FOR PROCEDURES ON EYE; CORNEAL TRANSPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1008, N'0014F', N'COMPREHENSIVE PREOPERATIVE ASSESSMENT PERFORMED FOR CATARACT SURGERY SURGERY PRIOR TO THE CATARACT SURGERY WITH INTRAOCULAR LENS PLACEMENT (MUST BE PERFORMED WITHIN 12 MONTHS PRIOR TO CATARACT SURGERY) (3325F) WITH INTRAOCULAR LENS (IOL) PLACEMENT (INCLUDES ASSESSMENT OF ALL OF THE FOLLOWING COMPONENTS) (EC): DILATED FUNDUS EVALUATION PERFORMED WITHIN 12 MONTHS PRIOR TO CATARACT SURGERY (2020F) PRE-SURGICAL (CATARACT) AXIAL LENGTH, CORNEAL POWER MEASUREMENT AND METHOD OF INTRAOCULAR LENS POWER CALCULATION DOCUMENTED (MUST BE PERFORMED WITHIN 12 MONTHS PRIOR TO SURGERY) (3073F) PREOPERATIVE ASSESSMENT OF FUNCTIONAL OR MEDICAL INDICATION(S) FOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1009, N'0014T', N'MENISCAL TRANSPLANTATION, MEDIAL OR LATERAL, KNEE (ANY METHOD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1010, N'0016T', N'DESTRUCTION OF LOCALIZED LESION OF CHOROID (EG, CHOROIDAL NEOVASCULARIZATION), TRANSPUPILLARY THERMOTHERAPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1011, N'00172', N'ANESTHESIA FOR INTRAORAL PROCEDURES, INCLUDING BIOPSY; REPAIR OF CLEFT PALATE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1012, N'0019T', N'EXTRACORPOREAL SHOCK WAVE INVOLVING MUSCULOSKELETAL SYSTEM, NOT OTHERWISE SPECIFIED, LOW ENERGY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1013, N'00214', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; BURR HOLES, INCLUDING VENTRICULOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1014, N'00218', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; PROCEDURES IN SITTING POSITION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1015, N'0001F', N'HEART FAILURE ASSESSED (INCLUDES ASSESSMENT OF ALL THE FOLLOWING COMPONENTS) (CAD): BLOOD PRESSURE MEASURED (2000F) LEVEL OF ACTIVITY ASSESSED (1003F) CLINICAL SYMPTOMS OF VOLUME OVERLOAD (EXCESS) ASSESSED (1004F) WEIGHT, RECORDED (2001F) CLINICAL SIGNS OF VOLUME OVERLOAD (EXCESS) ASSESSED (2002F) ASSESSED (2002F)1', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1016, N'0023T', N'INFECTIOUS AGENT DRUG SUSCEPTIBILITY PHENOTYPE PREDICTION USING GENOTYPIC COMPARISON TO KNOWN GENOTYPIC/PHENOTYPIC DATABASE, HIV 1', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1017, N'0026T', N'LIPOPROTEIN, DIRECT MEASUREMENT, INTERMEDIATE DENSITY LIPOPROTEINS (IDL) (REMNANT LIPOPROTEINS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1018, N'0001T', N'ENDOVASCULAR REPAIR OF INFRARENAL ABDOMINAL AORTIC ANEURYSM OR DISSECTION, MODULAR BIFURCATED PROSTHESIS (TWO DOCKING LIMBS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1019, N'0007F', N'BETA-BLOCKER THERAPY, PRESCRIBED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1020, N'0027T', N'ENDOSCOPIC LYSIS OF EPIDURAL ADHESIONS WITH DIRECT VISUALIZATION USING MECHANICAL MEANS (EG, SPINAL ENDOSCOPIC CATHETER SYSTEM) OR SOLUTION INJECTION (EG, NORMAL SALINE) INCLUDING RADIOLOGIC LOCALIZATION AND EPIDUROGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1021, N'0009T', N'ENDOMETRIAL CRYOABLATION WITH ULTRASONIC GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1022, N'00100', N'ANESTHESIA FOR PROCEDURES ON SALIVARY GLANDS, INCLUDING BIOPSY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1023, N'0007T', N'TRANSCATHETER PLACEMENT OF EXTRACRANIAL CEREBROVASCULAR ARTERY STENT(S), PERCUTANEOUS, RADIOLOGICAL SUPERVISION AND INTERPRETATION, EACH VESSEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1024, N'0028T', N'DUAL ENERGY X-RAY ABSORPTIOMETRY (DEXA) BODY COMPOSITION STUDY, ONE OR MORE SITES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1025, N'00300', N'ANESTHESIA FOR ALL PROCEDURES ON THE INTEGUMENTARY SYSTEM, MUSCLES AND NERVES OF HEAD, NECK, AND POSTERIOR TRUNK, NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1026, N'00103', N'ANESTHESIA FOR RECONSTRUCTIVE PROCEDURES OF EYELID (EG, BLEPHAROPLASTY, PTOSIS SURGERY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1027, N'0012F', N'COMMUNITY-ACQUIRED BACTERIAL PNEUMONIA ASSESSED (CAP1) INCLUDES ALL OF THE FOLLOWING COMPONENTS: CO-MORBID CONDITIONS ASSESSED (1026F1) VITAL SIGNS RECORDED (2010F1) VITAL SIGNS RECORDED (2010F1) MENTAL STATUS ASSESSED  (2014F1) HYDRATION STATUS ASSESSED (2018F1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1028, N'0034T', N'ENDOVASCULAR REPAIR OF DESCENDING THORACIC AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION; NOT INVOLVING COVERAGE OF LEFT SUBCLAVIAN ARTERY ORIGIN, INITIAL ENDOPROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1029, N'0008F', N'ACE INHIBITOR THERAPY, PRESCRIBED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1030, N'0009F', N'ANGINAL SYMPTOMS AND LEVEL OF ACTIVITY, ASSESSED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1031, N'00102', N'ANESTHESIA FOR PROCEDURES ON PLASTIC REPAIR OF CLEFT LIP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1032, N'0013T', N'ARTHROSCOPY, KNEE, SURGICAL, IMPLANTATION OF OSTEOCHONDRAL GRAFT(S) FOR TREATMENT OF ARTICULAR SURFACE DEFECT; ALLOGRAFTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1033, N'00148', N'ANESTHESIA FOR PROCEDURES ON EYE; OPHTHALMOSCOPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1034, N'00162', N'ANESTHESIA FOR PROCEDURES ON NOSE AND ACCESSORY SINUSES; RADICAL SURGERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1035, N'00170', N'ANESTHESIA FOR INTRAORAL PROCEDURES, INCLUDING BIOPSY; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1036, N'0002T', N'ENDOVASCULAR REPAIR OF INFRARENAL ABDOMINAL AORTIC ANEURYSM OR DISSECTION; AORTO-UNI-ILIAC OR AORTO-UNIFEMORAL PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1037, N'0003F', N'TOBACCO USE, NON-SMOKING, ASSESSED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1038, N'0010T', N'TUBERCULOSIS TEST, CELL MEDIATED IMMUNITY MEASUREMENT OF GAMMA INTERFERON ANTIGEN RESPONSE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1039, N'00126', N'ANESTHESIA FOR PROCEDURES ON EXTERNAL, MIDDLE, AND INNER EAR INCLUDING BIOPSY; TYMPANOTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1040, N'00174', N'ANESTHESIA FOR INTRAORAL PROCEDURES, INCLUDING BIOPSY; EXCISION OF RETROPHARYNGEAL TUMOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1041, N'0018T', N'DELIVERY OF HIGH POWER, FOCAL MAGNETIC PULSES FOR DIRECT STIMULATION TO CORTICAL NEURONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1042, N'00142', N'ANESTHESIA FOR PROCEDURES ON EYE; LENS SURGERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1043, N'00146', N'ANESTHESIA FOR PROCEDURES ON EYE; BIOPSY OF CONJUNCTIVA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1044, N'00147', N'ANESTHESIA FOR PROCEDURES ON EYE; IRIDECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1045, N'00160', N'ANESTHESIA FOR PROCEDURES ON NOSE AND ACCESSORY SINUSES; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1046, N'00164', N'ANESTHESIA FOR PROCEDURES ON NOSE AND ACCESSORY SINUSES; BIOPSY, SOFT TISSUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1047, N'0017T', N'DESTRUCTION OF MACULAR DRUSEN, PHOTOCOAGULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1048, N'00215', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; CRANIOPLASTY OR ELEVATION OF DEPRESSED SKULL FRACTURE, EXTRADURAL (SIMPLE OR COMPOUND)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1049, N'00222', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; ELECTROCOAGULATION OF INTRACRANIAL NERVE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1050, N'0030T', N'ANTIPROTHROMBIN (PHOSPHOLIPID COFACTOR) ANTIBODY, EACH IG CLASS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1051, N'00320', N'ANESTHESIA FOR ALL PROCEDURES ON ESOPHAGUS, THYROID, LARYNX, TRACHEA AND LYMPHATIC SYSTEM OF NECK; NOT OTHERWISE SPECIFIED, AGE 1 YEAR OR OLDER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1052, N'00322', N'ANESTHESIA FOR ALL PROCEDURES ON ESOPHAGUS, THYROID, LARYNX, TRACHEA AND LYMPHATIC SYSTEM OF NECK; NEEDLE BIOPSY OF THYROID', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1053, N'0032T', N'WITH DIRECTED SAMPLING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1054, N'0041T', N'URINALYSIS INFECTIOUS AGENT DETECTION, SEMI-QUANTITATIVE ANALYSIS OF VOLATILE COMPOUNDS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1055, N'00420', N'ANESTHESIA FOR PROCEDURES ON POSTERIOR INTEGUMENTARY SYSTEM OF CHEST, INCLUDING SUBCUTANEOUS TISSUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1056, N'0042T', N'CEREBRAL PERFUSION ANALYSIS USING COMPUTED TOMOGRAPHY WITH CONTRAST ADMINISTRATION, INCLUDING POST-PROCESSING OF PARAMETRIC MAPS WITH DETERMINATION OF CEREBRAL BLOOD FLOW, CEREBRAL BLOOD VOLUME, AND MEAN TRANSIT TIME', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1057, N'00450', N'ANESTHESIA FOR PROCEDURES ON CLAVICLE AND SCAPULA; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1058, N'0045T', N'WHOLE BODY INTEGUMENTARY PHOTOGRAPHY, AT REQUEST OF A PHYSICIAN, FOR MONITORING OF HIGH-RISK PATIENTS; WITH HISTORY OF DYSPLASTIC NEVI OR PERSONAL HISTORY OF MELANOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1059, N'00211', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; CRANIOTOMY OR CRANIECTOMY FOR EVACUATION OF HEMATOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1060, N'00212', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; SUBDURAL TAPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1061, N'00352', N'ANESTHESIA FOR PROCEDURES ON MAJOR VESSELS OF NECK; SIMPLE LIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1062, N'00400', N'ANESTHESIA FOR PROCEDURES ON THE INTEGUMENTARY SYSTEM ON THE EXTREMITIES, ANTERIOR TRUNK AND PERINEUM; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1063, N'0048T', N'IMPLANTATION OF A VENTRICULAR ASSIST DEVICE, EXTRACORPOREAL, PERCUTANEOUS TRANSSEPTAL ACCESS, SINGLE OR DUAL CANNULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1064, N'00500', N'ANESTHESIA FOR ALL PROCEDURES ON ESOPHAGUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1065, N'00220', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; CEREBROSPINAL FLUID SHUNTING PROCEDURES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1066, N'0025T', N'DETERMINATION OF CORNEAL THICKNESS (EG, PACHYMETRY) WITH INTERPRETATION AND REPORT, BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1067, N'0050T', N'REMOVAL OF A VENTRICULAR ASSIST DEVICE, EXTRACORPOREAL, PERCUTANEOUS TRANSSEPTAL ACCESS, SINGLE OR DUAL CANNULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1068, N'00524', N'ANESTHESIA FOR CLOSED CHEST PROCEDURES; PNEUMOCENTESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1069, N'0031T', N'SPECULOSCOPY;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1070, N'0035T', N'PLACEMENT OF PROXIMAL OR DISTAL EXTENSION PROSTHESIS FOR ENDOVASCULAR REPAIR OF DESCENDING THORACIC AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION; INITIAL EXTENSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1071, N'00530', N'ANESTHESIA FOR PERMANENT TRANSVENOUS PACEMAKER INSERTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1072, N'00534', N'ANESTHESIA FOR TRANSVENOUS INSERTION OR REPLACEMENT OF PACING CARDIOVERTER-DEFIBRILLATOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1073, N'00537', N'ANESTHESIA FOR CARDIAC ELECTROPHYSIOLOGIC PROCEDURES INCLUDING RADIOFREQUENCY ABLATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1074, N'00580', N'ANESTHESIA FOR HEART TRANSPLANT OR HEART/LUNG TRANSPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1075, N'0036T', N'PLACEMENT OF PROXIMAL OR DISTAL EXTENSION PROSTHESIS FOR ENDOVASCULAR REPAIR OF DESCENDING THORACIC AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION; EACH ADDITIONAL EXTENSION (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1076, N'00620', N'ANESTHESIA FOR PROCEDURES ON THORACIC SPINE AND CORD; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1077, N'0062T', N'PERCUTANEOUS INTRADISCAL ANNULOPLASTY, ANY METHOD EXCEPT ELECTROTHERMAL, UNILATERAL OR BILATERAL INCLUDING FLUOROSCOPIC GUIDANCE; SINGLE LEVEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1078, N'0039T', N'ENDOVASCULAR REPAIR OF DESCENDING THORACIC AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION NOT INVOLVING COVERAGE OF LEFT SUBCLAVIAN ARTERY ORIGIN, INITIAL ENDOPROSTHESIS, RADIOLOGICAL SUPERVISION AND INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1079, N'0063T', N'PERCUTANEOUS INTRADISCAL ANNULOPLASTY, ANY METHOD, UNILATERAL OR         BILATERAL INCLUDING FLUOROSCOPIC GUIDANCE; ONE OR MORE ADDITIONAL        LEVELS (LIST SEPARATELY IN ADDITION TO 0062T FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1080, N'00404', N'ANESTHESIA FOR PROCEDURES ON THE INTEGUMENTARY SYSTEM ON THE EXTREMITIES, ANTERIOR TRUNK AND PERINEUM; RADICAL OR MODIFIED RADICAL PROCEDURES ON BREAST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1081, N'00406', N'ANESTHESIA FOR PROCEDURES ON THE INTEGUMENTARY SYSTEM ON THE EXTREMITIES, ANTERIOR TRUNK AND PERINEUM; RADICAL OR MODIFIED RADICAL PROCEDURES ON BREAST WITH INTERNAL MAMMARY NODE DISSECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1082, N'00640', N'ANESTHESIA FOR MANIPULATION OF THE SPINE OR FOR CLOSED PROCEDURES ON THE CERVICAL, THORACIC OR LUMBAR SPINE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1083, N'0064T', N'SPECTROSCOPY, EXPIRED GAS ANALYSIS (EG, NITRIC OXIDE/CARBON DIOXIDE      TEST)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1084, N'00454', N'ANESTHESIA FOR PROCEDURES ON CLAVICLE AND SCAPULA; BIOPSY OF CLAVICLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1085, N'00470', N'ANESTHESIA FOR PARTIAL RIB RESECTION; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1086, N'00402', N'ANESTHESIA FOR PROCEDURES ON THE INTEGUMENTARY SYSTEM ON THE EXTREMITIES, ANTERIOR TRUNK AND PERINEUM; RECONSTRUCTIVE PROCEDURES ON BREAST (EG, REDUCTION OR AUGMENTATION MAMMOPLASTY, MUSCLE FLAPS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1087, N'0040T', N'PLACEMENT OF PROXIMAL OR DISTAL EXTENSION PROSTHESIS FOR ENDOVASCULAR REPAIR OF DESCENDING THORACIC AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION, EACH EXTENSION, RADIOLOGICAL SUPERVISION AND INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1088, N'0046T', N'CATHETER LAVAGE OF A MAMMARY DUCT(S) FOR COLLECTION OF CYTOLOGY SPECIMEN(S), IN HIGH RISK INDIVIDUALS (GAIL RISK SCORING OR PRIOR PERSONAL HISTORY OF BREAST CANCER), EACH BREAST; SINGLE DUCT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1089, N'0003T', N'CERVICOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1090, N'0004F', N'TOBACCO USE CESSATION INTERVENTION, COUNSELING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1091, N'0005F', N'OSTEOARTHRITIS ASSESSED (INCLUDES ASSESSMENT OF ALL THE FOLLOWING COMPONENTS): OSTEOARTHRITIS SYMPTOMS AND FUNCTIONAL STATUS ASSESSED (1006F) USE OF ANTI-INFLAMMATORY OR OVER-THE-COUNTER (OTC) ANALGESIC MEDICATIONS ASSESSED (1007F) INITIAL EXAMINATION OF THE INVOLVED JOINT(S) (INCLUDES VISUAL INSPECTION, PALPATION, RANGE OF MOTION) (2004F)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1092, N'0047T', N'CATHETER LAVAGE OF A MAMMARY DUCT(S) FOR COLLECTION OF CYTOLOGY SPECIMEN(S), IN HIGH RISK INDIVIDUALS (GAIL RISK SCORING OR PRIOR PERSONAL HISTORY OF BREAST CANCER), EACH BREAST; EACH ADDITIONAL DUCT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1093, N'0049T', N'PROLONGED EXTRACORPOREAL PERCUTANEOUS TRANSSEPTAL VENTRICULAR ASSIST DEVICE, GREATER THAN 24 HOURS, EACH SUBSEQUENT 24 HOUR PERIOD (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1094, N'0005T', N'TRANSCATHETER PLACEMENT OF EXTRACRANIAL CEREBROVASCULAR ARTERY STENT(S), PERCUTANEOUS; INITIAL VESSEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1095, N'0008T', N'UPPER GASTROINTESTINAL ENDOSCOPY INCLUDING ESOPHAGUS, STOMACH, AND EITHER THE DUODENUM AND/OR JEJUNUM AS APPROPRIATE; WITH SUTURING OF THE ESOPHAGOGASTRIC JUNCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1096, N'00541', N'ANESTHESIA FOR THORACOTOMY PROCEDURES INVOLVING LUNGS, PLEURA, DIAPHRAGM, AND MEDIASTINUM (INCLUDING SURGICAL THORACOSCOPY); UTILIZING 1 LUNG VENTILATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1097, N'00104', N'ANESTHESIA FOR ELECTROCONVULSIVE THERAPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1098, N'0011F', N'ORAL ANTIPLATELET THERAPY; PRESCRIBED (EG, ASPIRIN, CLOPIDOGREL/ PLAVIX, OR COMBINATION OF ASPIRIN AND DIPYRIDAMOLE/AGGRENOX)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1099, N'00542', N'ANESTHESIA FOR THORACOTOMY PROCEDURES INVOLVING LUNGS, PLEURA, DIAPHRAGM, AND MEDIASTINUM (INCLUDING SURGICAL THORACOSCOPY); DECORTICATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1100, N'00544', N'ANESTHESIA FOR THORACOTOMY PROCEDURES INVOLVING LUNGS, PLEURA, DIAPHRAGM, AND MEDIASTINUM (INCLUDING SURGICAL THORACOSCOPY); PLEURECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 100 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1101, N'00124', N'ANESTHESIA FOR PROCEDURES ON EXTERNAL, MIDDLE, AND INNER EAR INCLUDING BIOPSY; OTOSCOPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1102, N'0012T', N'ARTHROSCOPY, KNEE, SURGICAL, IMPLANTATION OF OSTEOCHONDRAL GRAFT(S) FOR TREATMENT OF ARTICULAR SURFACE DEFECT; AUTOGRAFTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1103, N'00546', N'ANESTHESIA FOR THORACOTOMY PROCEDURES INVOLVING LUNGS, PLEURA, DIAPHRAGM, AND MEDIASTINUM (INCLUDING SURGICAL THORACOSCOPY); PULMONARY RESECTION WITH THORACOPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1104, N'00563', N'ANESTHESIA FOR PROCEDURES ON HEART, PERICARDIAL SAC, AND GREAT VESSELS OF CHEST; WITH PUMP OXYGENATOR WITH HYPOTHERMIC CIRCULATORY ARREST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1105, N'00472', N'ANESTHESIA FOR PARTIAL RIB RESECTION; THORACOPLASTY (ANY TYPE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1106, N'00520', N'ANESTHESIA FOR CLOSED CHEST PROCEDURES; (INCLUDING BRONCHOSCOPY) NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1107, N'00522', N'ANESTHESIA FOR CLOSED CHEST PROCEDURES; NEEDLE BIOPSY OF PLEURA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1108, N'00526', N'ANESTHESIA FOR CLOSED CHEST PROCEDURES (INCLUDING ESOPHAGOSCOPY, BRONCHOSCOPY, TRANSVENOUS PACEMAKER); THORACOSCOPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1109, N'00670', N'ANESTHESIA FOR EXTENSIVE SPINE AND SPINAL CORD PROCEDURES (EG, SPINAL INSTRUMENTATION OR VASCULAR PROCEDURES)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1110, N'00700', N'ANESTHESIA FOR PROCEDURES ON UPPER ANTERIOR ABDOMINAL WALL; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1111, N'00528', N'ANESTHESIA FOR CLOSED CHEST PROCEDURES; MEDIASTINOSCOPY AND DIAGNOSTIC THORACOSCOPY NOT UTILIZING 1 LUNG VENTILATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1112, N'00529', N'ANESTHESIA FOR CLOSED CHEST PROCEDURES; MEDIASTINOSCOPY AND DIAGNOSTIC THORACOSCOPY UTILIZING 1 LUNG VENTILATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1113, N'00145', N'ANESTHESIA FOR PROCEDURES ON EYE; VITREORETINAL SURGERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1114, N'0015F', N'MELANOMA FOLLOW UP COMPLETED (INCLUDES ASSESSMENT OF ALL OF THE FOLLOWING COMPONENTS) (ML): HISTORY OBTAINED REGARDING NEW OR CHANGING MOLES (1050F) COMPLETE PHYSICAL SKIN EXAM PERFORMED (2029F) PATIENT COUNSELED TO PERFORM A MONTHLY SELF SKIN EXAMINATION (5005F)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1115, N'0052T', N'REPLACEMENT OR REPAIR OF THORACIC UNIT OF A TOTAL REPLACEMENT HEART SYSTEM (ARTIFICIAL HEART)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1116, N'0053T', N'REPLACEMENT OR REPAIR OF IMPLANTABLE COMPONENT OR COMPONENTS OF TOTAL REPLACEMENT HEART SYSTEM (ARTIFICIAL HEART), EXCLUDING THORACIC UNIT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1117, N'00176', N'ANESTHESIA FOR INTRAORAL PROCEDURES, INCLUDING BIOPSY; RADICAL SURGERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1118, N'00190', N'ANESTHESIA FOR PROCEDURES ON FACIAL BONES OR SKULL; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1119, N'00567', N'ANESTHESIA FOR DIRECT CORONARY ARTERY BYPASS GRAFTING; WITH PUMP OXYGENATOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1120, N'00604', N'ANESTHESIA FOR PROCEDURES ON CERVICAL SPINE AND CORD; PROCEDURES WITH PATIENT IN THE SITTING POSITION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1121, N'00548', N'ANESTHESIA FOR THORACOTOMY PROCEDURES INVOLVING LUNGS, PLEURA, DIAPHRAGM, AND MEDIASTINUM (INCLUDING SURGICAL THORACOSCOPY); INTRATHORACIC PROCEDURES ON THE TRACHEA AND BRONCHI', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1122, N'00754', N'ANESTHESIA FOR HERNIA REPAIRS IN UPPER ABDOMEN; OMPHALOCELE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1123, N'0075T', N'TRANSCATHETER PLACEMENT OF EXTRACRANIAL VERTEBRAL OR INTRATHORACIC       CAROTID ARTERY STENT(S), INCLUDING RADIOLOGIC SUPERVISION AND            INTERPRETATION, PERCUTANEOUS; INITIAL VESSEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1124, N'0060T', N'ELECTRICAL IMPEDANCE SCAN OF THE BREAST, BILATERAL (RISK ASSESSMENT DEVICE FOR BREAST CANCER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1125, N'00622', N'ANESTHESIA FOR PROCEDURES ON THORACIC SPINE AND CORD; THORACOLUMBAR SYMPATHECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1126, N'0077T', N'IMPLANTING AND SECURING CEREBRAL THERMAL PERFUSION PROBE, INCLUDING      TWIST DRILL OR BURR HOLE, TO MEASURE ABSOLUTE CEREBRAL TISSUE PERFUSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1127, N'0078T', N'ENDOVASCULAR REPAIR USING PROSTHESIS OF ABDOMINAL AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION, ABDOMINAL AORTA INVOLVING VISCERAL BRANCHES (SUPERIOR MESENTERIC, CELIAC AND/OR RENAL ARTERY(S))', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1128, N'00794', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN UPPER ABDOMEN INCLUDING LAPAROSCOPY; PANCREATECTOMY, PARTIAL OR TOTAL (EG, WHIPPLE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1129, N'0055T', N'COMPUTER-ASSISTED MUSCULOSKELETAL SURGICAL NAVIGATIONAL ORTHOPEDIC       PROCEDURE, WITH IMAGE-GUIDANCE BASED ON CT/MRI IMAGES (LIST SEPARATELY   IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1130, N'00800', N'ANESTHESIA FOR PROCEDURES ON LOWER ANTERIOR ABDOMINAL WALL; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1131, N'00806', N'ANESTHESIA FOR LAPAROSCOPIC PROCEDURES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1132, N'00562', N'ANESTHESIA FOR PROCEDURES ON HEART, PERICARDIAL SAC, AND GREAT VESSELS OF CHEST; WITH PUMP OXYGENATOR, AGE 1 YEAR OR OLDER, FOR ALL NON-CORONARY BYPASS PROCEDURES (EG, VALVE PROCEDURES) OR FOR RE-OPERATION FOR CORONARY BYPASS MORE THAN 1 MONTH AFTER ORIGINAL OPERATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1133, N'0056T', N'COMPUTER ASSISTED MUSCULOSKELETAL SURGICAL NAVIGATIONAL ORTHOPEDIC PROCEDURE, IMAGE-LESS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1134, N'00810', N'ANESTHESIA FOR LOWER INTESTINAL ENDOSCOPIC PROCEDURES, ENDOSCOPE INTRODUCED DISTAL TO DUODENUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1135, N'00844', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN INCLUDING LAPAROSCOPY; ABDOMINOPERINEAL RESECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1136, N'0057T', N'UPPER GASTROINTESTINAL ENDOSCOPY, INCLUDING ESOPHAGUS, STOMACH, AND EITHER THE DUODENUM AND/OR JEJUNUM AS APPROPRIATE, WITH DELIVERY OF THERMAL ENERGY TO THE MUSCLE OF THE LOWER ESOPHAGEAL SPHINCTER AND/OR GASTRIC CARDIA, FOR TREATMENT OF GASTROESOPHAGEAL REFLUX DISEASE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1137, N'0084T', N'INSERTION OF A TEMPORARY PROSTATIC URETHRAL STENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1138, N'00850', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN INCLUDING LAPAROSCOPY; CESAREAN SECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1139, N'00851', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN INCLUDING LAPAROSCOPY; TUBAL LIGATION/TRANSECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1140, N'00855', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN INCLUDING LAPAROSCOPY; CESAREAN HYSTERECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1141, N'00857', N'NEURAXIAL ANALGESIA/ANESTHESIA FOR LABOR ENDING IN A CESAREAN DELIVERY (INCLUDES ANY REPEAT SUBARACHNOID NEEDLE PLACEMENT AND DRUG INJECTION AND/OR ANY NECESSARY REPLACEMENT OF AN EPIDURAL CATHETER DURING LABOR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1142, N'00864', N'ANESTHESIA FOR EXTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN, INCLUDING URINARY TRACT; TOTAL CYSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1143, N'00872', N'ANESTHESIA FOR LITHOTRIPSY, EXTRACORPOREAL SHOCK WAVE; WITH WATER BATH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1144, N'00873', N'ANESTHESIA FOR LITHOTRIPSY, EXTRACORPOREAL SHOCK WAVE; WITHOUT WATER BATH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1145, N'00882', N'ANESTHESIA FOR PROCEDURES ON MAJOR LOWER ABDOMINAL VESSELS; INFERIOR VENA CAVA LIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1146, N'00900', N'ANES- PERINEAL INTEG SYST; NOS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1147, N'00904', N'ANESTHESIA FOR; RADICAL PERINEAL PROCEDURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1148, N'00906', N'ANESTHESIA FOR; VULVECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1149, N'00912', N'ANESTHESIA FOR TRANSURETHRAL PROCEDURES (INCLUDING URETHROCYSTOSCOPY); TRANSURETHRAL RESECTION OF BLADDER TUMOR(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1150, N'00914', N'ANESTHESIA FOR TRANSURETHRAL PROCEDURES (INCLUDING URETHROCYSTOSCOPY); TRANSURETHRAL RESECTION OF PROSTATE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1151, N'00934', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); RADICAL AMPUTATION OF PENIS WITH BILATERAL INGUINAL LYMPHADENECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1152, N'00938', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); INSERTION OF PENILE PROSTHESIS (PERINEAL APPROACH)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1153, N'0095T', N'REMOVAL OF TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, EACH ADDITIONAL INTERSPACE, CERVICAL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1154, N'0097T', N'REVISION OF TOTAL DISC ARTHROPLASTY, ANTERIOR APPROACH; SINGLE INTERSPACE, LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1155, N'0102T', N'EXTRACORPOREAL SHOCK WAVE, HIGH ENERGY, PERFORMED BY A PHYSICIAN, REQUIRING ANESTHESIA OTHER THAN LOCAL, INVOLVING LATERAL HUMERAL EPICONDYLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1156, N'00702', N'ANESTHESIA FOR PROCEDURES ON UPPER ANTERIOR ABDOMINAL WALL; PERCUTANEOUS LIVER BIOPSY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1157, N'0071T', N'FOCUSED ULTRASOUND ABLATION OF UTERINE LEIOMYOMATA, INCLUDING MR         GUIDANCE; TOTAL LEIOMYOMATA VOLUME LESS THAN 200 CC OF TISSUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1158, N'0059T', N'CRYOPRESERVATION; OOCYTE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1159, N'0061T', N'DESTRUCTION/REDUCTION OF MALIGNANT BREAST TUMOR INCLUDING BREAST CARCINOMA CELLS IN THE MARGINS, MICROWAVE PHASED ARRAY THERMOTHERAPY, DISPOSABLE CATHETER WITH COMBINED TEMPERATURE MONITORING PROBE AND MICROWAVE SENSOR, EXTERNALLY APPLIED MICROWAVE ENERGY, INCLUDING INTERSTITIAL PLACEMENT OF SENSOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1160, N'00625', N'ANESTHESIA FOR PROCEDURES ON THE THORACIC SPINE AND CORD, VIA AN ANTERIOR TRANSTHORACIC APPROACH; NOT UTILIZING 1 LUNG VENTILATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1161, N'00634', N'ANESTHESIA FOR PROCEDURES IN LUMBAR REGION; CHEMONUCLEOLYSIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1162, N'0072T', N'FOCUSED ULTRASOUND ABLATION OF UTERINE LEIOMYOMATA, INCLUDING MR         GUIDANCE; TOTAL LEIOMYOMATA VOLUME GREATER OR EQUAL TO 200 CC OF TISSUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1163, N'00730', N'ANESTHESIA FOR PROCEDURES ON UPPER POSTERIOR ABDOMINAL WALL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1164, N'0076T', N'TRANSCATHETER PLACEMENT OF EXTRACRANIAL VERTEBRAL OR INTRATHORACIC       CAROTID ARTERY STENT(S), INCLUDING RADIOLOGIC SUPERVISION AND            INTERPRETATION, PERCUTANEOUS; EACH ADDITIONAL VESSEL (LIST SEPARATELY    IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1165, N'0080T', N'ENDOVASCULAR REPAIR USING PROSTHESIS OF ABDOMINAL AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION, ABDOMINAL AORTA INVOLVING VISCERAL VESSELS (SUPERIOR MESENTERIC, CELIAC AND/OR RENAL ARTERY[S]), RADIOLOGICAL SUPERVISION AND INTERPRETATION INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1166, N'00192', N'ANESTHESIA FOR PROCEDURES ON FACIAL BONES OR SKULL; RADICAL SURGERY (INCLUDING PROGNATHISM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1167, N'0020T', N'EXTRACORPOREAL SHOCK WAVE THERAPY; INVOLVING PLANTAR FASCIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1168, N'00820', N'ANESTHESIA FOR PROCEDURES ON LOWER POSTERIOR ABDOMINAL WALL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1169, N'0082T', N'STEREOTACTIC BODY RADIATION THERAPY, TREATMENT DELIVERY, ONE OR MORE     TREATMENT AREAS, PER DAY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1170, N'00210', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1171, N'00216', N'ANESTHESIA FOR INTRACRANIAL PROCEDURES; VASCULAR PROCEDURES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1172, N'0021T', N'INSERTION OF TRANSCERVICAL OR TRANSVAGINAL FETAL OXIMETRY SENSOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1173, N'0024T', N'NON-SURGICAL SEPTAL REDUCTION THERAPY (EG, ALCOHOL ABLATION), FOR HYPERTROPHIC OBSTRUCTIVE CARDIOMYOPATHY; WITH CORONARY ARTERIOGRAMS, WITH OR WITHOUT TEMPORARY PACEMAKER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1174, N'00635', N'ANESTHESIA FOR PROCEDURES IN LUMBAR REGION; DIAGNOSTIC OR THERAPEUTIC LUMBAR PUNCTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1175, N'0065T', N'OCULAR PHOTOSCREENING, WITH INTERPRETATION AND REPORT, BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1176, N'00832', N'ANESTHESIA FOR HERNIA REPAIRS IN LOWER ABDOMEN; VENTRAL AND INCISIONAL HERNIAS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1177, N'00842', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN INCLUDING LAPAROSCOPY; AMNIOCENTESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1178, N'0029T', N'TREATMENT(S) FOR INCONTINENCE, PULSED MAGNETIC NEUROMODULATION, PER DAY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1179, N'00326', N'ANESTHESIA FOR ALL PROCEDURES ON THE LARYNX AND TRACHEA IN CHILDREN LESS THAN 1 YEAR OF AGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1180, N'0069T', N'ACOUSTIC HEART SOUND RECORDING AND COMPUTER ANALYSIS; ACOUSTIC HEART SOUND RECORDING AND COMPUTER ANALYSIS ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1181, N'0073T', N'COMPENSATOR-BASED BEAM MODULATION TREATMENT DELIVERY OF INVERSE PLANNED TREATMENT USING 3 OR MORE HIGH RESOLUTION (MILLED OR CAST) COMPENSATOR CONVERGENT BEAM MODULATED FIELDS, PER TREATMENT SESSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1182, N'0033T', N'ENDOVASCULAR REPAIR OF DESCENDING THORACIC AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION; INVOLVING COVERAGE OF LEFT SUBCLAVIAN ARTERY ORIGIN, INITIAL ENDOPROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1183, N'00740', N'ANESTHESIA FOR UPPER GASTROINTESTINAL ENDOSCOPIC PROCEDURES, ENDOSCOPE INTRODUCED PROXIMAL TO DUODENUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1184, N'00752', N'ANESTHESIA FOR HERNIA REPAIRS IN UPPER ABDOMEN; LUMBAR AND VENTRAL (INCISIONAL) HERNIAS AND/OR WOUND DEHISCENCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1185, N'00350', N'ANESTHESIA FOR PROCEDURES ON MAJOR VESSELS OF NECK; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1186, N'0037T', N'OPEN SUBCLAVIAN TO CAROTID ARTERY TRANSPOSITION PERFORMED IN CONJUNCTION WITH ENDOVASCULAR THORACIC ANEURYSM REPAIR, BY NECK INCISION, UNILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1187, N'0038T', N'ENDOVASCULAR REPAIR OF DESCENDING THORACIC AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION INVOLVING COVERAGE OF LEFT SUBCLAVIAN ARTERY ORIGIN, INITIAL ENDOPROSTHESIS, RADIOLOGICAL SUPERVISION AND INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1188, N'00756', N'ANESTHESIA FOR HERNIA REPAIRS IN UPPER ABDOMEN; TRANSABDOMINAL REPAIR OF DIAPHRAGMATIC HERNIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1189, N'00790', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN UPPER ABDOMEN INCLUDING LAPAROSCOPY; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1190, N'00410', N'ANESTHESIA FOR PROCEDURES ON THE INTEGUMENTARY SYSTEM ON THE EXTREMITIES, ANTERIOR TRUNK AND PERINEUM; ELECTRICAL CONVERSION OF ARRHYTHMIAS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1191, N'0105T', N'INERT GAS REBREATHING FOR CARDIAC OUTPUT MEASUREMENT; DURING EXERCISE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1192, N'01140', N'ANESTHESIA FOR INTERPELVIABDOMINAL (HINDQUARTER) AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1193, N'00860', N'ANESTHESIA FOR EXTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN, INCLUDING URINARY TRACT; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1194, N'00865', N'ANESTHESIA FOR EXTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN, INCLUDING URINARY TRACT; RADICAL PROSTATECTOMY (SUPRAPUBIC, RETROPUBIC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1195, N'0087T', N'SPERM EVALUATION, HYALURONAN SPERM BINDING TEST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1196, N'00880', N'ANESTHESIA FOR PROCEDURES ON MAJOR LOWER ABDOMINAL VESSELS; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1197, N'00796', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN UPPER ABDOMEN INCLUDING LAPAROSCOPY; LIVER TRANSPLANT (RECIPIENT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1198, N'0079T', N'PLACEMENT OF VISCERAL EXTENSION PROSTHESIS FOR ENDOVASCULAR REPAIR OF    ABDOMINAL AORTIC ANEURYSM INVOLVING VISCERAL VESSELS, EACH VISCERAL      BRANCH (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1199, N'01160', N'ANESTHESIA FOR CLOSED PROCEDURES INVOLVING SYMPHYSIS PUBIS OR SACROILIAC JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1200, N'0117T', N'MEDICATION THERAPY MANAGEMENT SERVICE(S) PROVIDED BY A PHARMACIST, INDIVIDUAL, FACE-TO-FACE WITH PATIENT, INITIAL 15 MINUTES, WITH ASSESSMENT, AND INTERVENTION IF PROVIDED; EACH ADDITIONAL 15 MINUTES (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY SERVICE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1201, N'0080T', N'ENDOVASCULAR REPAIR OF ABDOMINAL AORTIC ANEURYSM, PSEUDOANEURYSM OR DISSECTION, ABDOMINAL AORTA INVOLVING VISCERAL VESSELS (SUPERIOR MESENTERIC, CELIAC OR RENAL), USING FENESTRATED MODULAR BIFURCATED PROSTHESIS (2 DOCKING LIMBS), RADIOLOGICAL SUPERVISION AND INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 200 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1202, N'00920', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1203, N'00921', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); VASECTOMY, UNILATERAL/BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1204, N'0120T', N'ABLATION, CRYOSURGICAL, OF FIBROADENOMA, INCLUDING ULTRASOUND GUIDANCE, EACH FIBROADENOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1205, N'01210', N'ANESTHESIA FOR OPEN PROCEDURES INVOLVING HIP JOINT; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1206, N'00830', N'ANESTHESIA FOR HERNIA REPAIRS IN LOWER ABDOMEN; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1207, N'00848', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN INCLUDING LAPAROSCOPY; PELVIC EXENTERATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1208, N'00922', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); SEMINAL VESICLES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1209, N'00924', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); UNDESCENDED TESTIS, UNILATERAL OR BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1210, N'01212', N'ANESTHESIA FOR OPEN PROCEDURES INVOLVING HIP JOINT; HIP DISARTICULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1211, N'01234', N'ANESTHESIA FOR OPEN PROCEDURES INVOLVING UPPER 2/3 OF FEMUR; RADICAL RESECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1212, N'0043T', N'CARBON MONOXIDE, EXPIRED GAS ANALYSIS (EG, ETCOC/HEMOLYSIS BREATH TEST)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1213, N'0044T', N'WHOLE BODY INTEGUMENTARY PHOTOGRAPHY, AT REQUEST OF A PHYSICIAN, FOR MONITORING OF HIGH-RISK PATIENTS; WITH DYSPLASTIC NEVUS SYNDROME OR FAMILIAL MELANOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1214, N'00862', N'ANESTHESIA FOR EXTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN, INCLUDING URINARY TRACT; RENAL PROCEDURES, INCLUDING UPPER 1/3 OF URETER, OR DONOR NEPHRECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1215, N'00928', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); RADICAL ORCHIECTOMY, ABDOMINAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1216, N'0092T', N'TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, INCLUDING DISCECTOMY WITH END PLATE PREPARATION (INCLUDES OSTEOPHYTECTOMY FOR NERVE ROOT OR SPINAL CORD DECOMPRESSION AND MICRODISSECTION), EACH ADDITIONAL INTERSPACE, CERVICAL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1217, N'00868', N'ANESTHESIA FOR EXTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN, INCLUDING URINARY TRACT; RENAL TRANSPLANT (RECIPIENT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1218, N'00870', N'ANESTHESIA FOR EXTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN, INCLUDING URINARY TRACT; CYSTOLITHOTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1219, N'00452', N'ANESTHESIA FOR PROCEDURES ON CLAVICLE AND SCAPULA; RADICAL SURGERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1220, N'00474', N'ANESTHESIA FOR PARTIAL RIB RESECTION; RADICAL PROCEDURES (EG, PECTUS EXCAVATUM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1221, N'00884', N'ANESTHESIA FOR PROCEDURES ON MAJOR LOWER ABDOMINAL VESSELS; TRANSVENOUS UMBRELLA INSERTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1222, N'00908', N'ANESTHESIA FOR; PERINEAL PROSTATECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1223, N'0051T', N'IMPLANTATION OF A TOTAL REPLACEMENT HEART SYSTEM (ARTIFICIAL HEART) WITH RECIPIENT CARDIECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1224, N'00532', N'ANESTHESIA FOR ACCESS TO CENTRAL VENOUS CIRCULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1225, N'0090T', N'TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, INCLUDING DISCECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION) CERVICAL; SINGLE INTERSPACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1226, N'00539', N'ANESTHESIA FOR TRACHEOBRONCHIAL RECONSTRUCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1227, N'00540', N'ANESTHESIA FOR THORACOTOMY PROCEDURES INVOLVING LUNGS, PLEURA, DIAPHRAGM, AND MEDIASTINUM (INCLUDING SURGICAL THORACOSCOPY); NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1228, N'0054T', N'COMPUTER ASSISTED MUSCULOSKELETAL SURGICAL NAVIGATIONAL ORTHOPEDIC PROCEDURE, WITH IMAGE-GUIDANCE BASED ON FLUOROSCOPIC IMAGES (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1229, N'00550', N'ANESTHESIA FOR STERNAL DEBRIDEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1230, N'00560', N'ANESTHESIA FOR PROCEDURES ON HEART, PERICARDIAL SAC, AND GREAT VESSELS OF CHEST; WITHOUT PUMP OXYGENATOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1231, N'00561', N'ANESTHESIA FOR PROCEDURES ON HEART, PERICARDIAL SAC, AND GREAT VESSELS OF CHEST; WITH PUMP OXYGENATOR, YOUNGER THAN 1 YEAR OF AGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1232, N'00566', N'ANESTHESIA FOR DIRECT CORONARY ARTERY BYPASS GRAFTING; WITHOUT PUMP OXYGENATOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1233, N'0058T', N'CRYOPRESERVATION; REPRODUCTIVE TISSUE, OVARIAN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1234, N'00600', N'ANESTHESIA FOR PROCEDURES ON CERVICAL SPINE AND CORD; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1235, N'00626', N'ANESTHESIA FOR PROCEDURES ON THE THORACIC SPINE AND CORD, VIA AN ANTERIOR TRANSTHORACIC APPROACH; UTILIZING 1 LUNG VENTILATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1236, N'00630', N'ANESTHESIA FOR PROCEDURES IN LUMBAR REGION; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1237, N'00632', N'ANESTHESIA FOR PROCEDURES IN LUMBAR REGION; LUMBAR SYMPATHECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1238, N'0066T', N'COMPUTED TOMOGRAPHIC (CT) COLONOGRAPHY (IE, VIRTUAL COLONOSCOPY);        SCREENING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1239, N'0067T', N'COMPUTED TOMOGRAPHIC (CT) COLONOGRAPHY (IE, VIRTUAL COLONOSCOPY);        DIAGNOSTIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1240, N'00918', N'ANESTHESIA FOR TRANSURETHRAL PROCEDURES (INCLUDING URETHROCYSTOSCOPY); WITH FRAGMENTATION, MANIPULATION AND/OR REMOVAL OF URETERAL CALCULUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1241, N'00932', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); COMPLETE AMPUTATION OF PENIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1242, N'0093T', N'REMOVAL OF TOTAL DISC ARTHROPLASTY, ANTERIOR APPROACH CERVICAL; SINGLE INTERSPACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1243, N'0124T', N'CONJUNCTIVAL INCISION WITH POSTERIOR EXTRASCLERAL PLACEMENT OF PHARMACOLOGICAL AGENT (DOES NOT INCLUDE SUPPLY OF MEDICATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1244, N'0135T', N'ABLATION, RENAL TUMOR(S), UNILATERAL, PERCUTANEOUS, CRYOTHERAPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1245, N'01402', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES ON KNEE JOINT; TOTAL KNEE ARTHROPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1246, N'0142T', N'PANCREATIC ISLET CELL TRANSPLANTATION THROUGH PORTAL VEIN, OPEN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1247, N'00942', N'ANESTHESIA FOR VAGINAL PROCEDURES (INCLUDING BIOPSY OF LABIA, VAGINA, CERVIX OR ENDOMETRIUM); COLPOTOMY, VAGINECTOMY, COLPORRHAPHY, AND OPEN URETHRAL PROCEDURES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1248, N'0145T', N'COMPUTED TOMOGRAPHY, HEART, WITH CONTRAST MATERIAL(S), INCLUDING NONCONTRAST IMAGES, IF PERFORMED, CARDIAC GATING AND 3D IMAGE POSTPROCESSING; CARDIAC STRUCTURE AND MORPHOLOGY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1249, N'00944', N'ANESTHESIA FOR VAGINAL PROCEDURES (INCLUDING BIOPSY OF LABIA, VAGINA, CERVIX OR ENDOMETRIUM); VAGINAL HYSTERECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1250, N'00948', N'ANESTHESIA FOR VAGINAL PROCEDURES (INCLUDING BIOPSY OF LABIA, VAGINA, CERVIX OR ENDOMETRIUM); CERVICAL CERCLAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1251, N'01464', N'ANESTHESIA FOR ARTHROSCOPIC PROCEDURES OF ANKLE AND/OR FOOT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1252, N'01474', N'ANESTHESIA FOR PROCEDURES ON NERVES, MUSCLES, TENDONS, AND FASCIA OF LOWER LEG, ANKLE, AND FOOT; GASTROCNEMIUS RECESSION (EG, STRAYER PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1253, N'0096T', N'REVISION OF TOTAL DISC ARTHROPLASTY, ANTERIOR APPROACH CERVICAL; SINGLE INTERSPACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1254, N'0099T', N'IMPLANTATION OF INTRASTROMAL CORNEAL RING SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1255, N'0103T', N'HOLOTRANSCOBALAMIN QUANTITATIVE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1256, N'0104T', N'INERT GAS REBREATHING FOR CARDIAC OUTPUT MEASUREMENT; DURING REST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1257, N'0108T', N'QUANTITATIVE SENSORY TESTING (QST), TESTING AND INTERPRETATION PER EXTREMITY; USING COOLING STIMULI TO ASSESS SMALL NERVE FIBER SENSATION AND HYPERALGESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1258, N'0109T', N'QUANTITATIVE SENSORY TESTING (QST), TESTING AND INTERPRETATION PER EXTREMITY; USING HEAT-PAIN STIMULI TO ASSESS SMALL NERVE FIBER SENSATION AND HYPERALGESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1259, N'0091T', N'TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, INCLUDING DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION) SINGLE INTERSPACE, LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1260, N'0111T', N'LONG-CHAIN (C20-22) OMEGA-3 FATTY ACIDS IN RED BLOOD CELL (RBC) MEMBRANES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1261, N'01173', N'ANESTHESIA FOR OPEN REPAIR OF FRACTURE DISRUPTION OF PELVIS OR COLUMN FRACTURE INVOLVING ACETABULUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1262, N'01180', N'ANESTHESIA FOR OBTURATOR NEURECTOMY; EXTRAPELVIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1263, N'01190', N'ANESTHESIA FOR OBTURATOR NEURECTOMY; INTRAPELVIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1264, N'01215', N'ANESTHESIA FOR OPEN PROCEDURES INVOLVING HIP JOINT; REVISION OF TOTAL HIP ARTHROPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1265, N'00936', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); RADICAL AMPUTATION OF PENIS WITH BILATERAL INGUINAL AND ILIAC LYMPHADENECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1266, N'0123T', N'FISTULIZATION OF SCLERA FOR GLAUCOMA, THROUGH CILIARY BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1267, N'0126T', N'COMMON CAROTID INTIMA-MEDIA THICKNESS (IMT) STUDY FOR EVALUATION OF ATHEROSCLEROTIC BURDEN OR CORONARY HEART DISEASE RISK FACTOR ASSESSMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1268, N'00946', N'ANESTHESIA FOR VAGINAL PROCEDURES (INCLUDING BIOPSY OF LABIA, VAGINA, CERVIX OR ENDOMETRIUM); VAGINAL DELIVERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1269, N'00955', N'NEURAXIAL ANALGESIA/ANESTHESIA FOR LABOR ENDING IN A VAGINAL DELIVERY (INCLUDES ANY REPEAT SUBARACHNOID NEEDLE PLACEMENT AND DRUG INJECTION AND/OR ANY NECESSARY REPLACEMENT OF AN EPIDURAL CATHETER DURING LABOR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1270, N'01274', N'ANESTHESIA FOR PROCEDURES INVOLVING ARTERIES OF UPPER LEG, INCLUDING BYPASS GRAFT; FEMORAL ARTERY EMBOLECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1271, N'0133T', N'UPPER GASTROINTESTINAL ENDOSCOPY, INCLUDING ESOPHAGUS, STOMACH, AND EITHER THE DUODENUM AND/OR JEJUNUM AS APPROPRIATE, WITH INJECTION OF IMPLANT MATERIAL INTO AND ALONG THE MUSCLE OF THE LOWER ESOPHAGEAL SPHINCTER (EG, FOR TREATMENT OF GASTROESOPHAGEAL REFLUX DISEASE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1272, N'0068T', N'ACOUSTIC HEART SOUND RECORDING AND COMPUTER ANALYSIS; WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1273, N'0070T', N'ACOUSTIC HEART SOUND RECORDING AND COMPUTER ANALYSIS; INTERPRETATION AND REPORT ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1274, N'0098T', N'REVISION INCLUDING REPLACEMENT OF TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, EACH ADDITIONAL INTERSPACE, CERVICAL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1275, N'01360', N'ANESTHESIA FOR ALL OPEN PROCEDURES ON LOWER 1/3 OF FEMUR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1276, N'0137T', N'BIOPSY, PROSTATE, NEEDLE, SATURATION SAMPLING FOR PROSTATE MAPPING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1277, N'01380', N'ANESTHESIA FOR ALL CLOSED PROCEDURES ON KNEE JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1278, N'0140T', N'EXHALED BREATH CONDENSATE PH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1279, N'0141T', N'PANCREATIC ISLET CELL TRANSPLANTATION THROUGH PORTAL VEIN, PERCUTANEOUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1280, N'01000', N'ANESTHESIA FOR PROCEDURES ON ANTERIOR INTEGUMENTARY SYSTEM OF PELVIS (ANTERIOR TO ILIAC CREST), EXCEPT EXTERNAL GENITALIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1281, N'0100T', N'PLACEMENT OF A SUBCONJUNCTIVAL RETINAL PROSTHESIS RECEIVER AND PULSE GENERATOR, AND IMPLANTATION OF INTRA-OCULAR RETINAL ELECTRODE ARRAY, WITH VITRECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1282, N'0074T', N'ONLINE EVALUATION AND MANAGEMENT SERVICE, PER ENCOUNTER, PROVIDED BY A   PHYSICIAN, USING THE INTERNET OR SIMILAR ELECTRONIC COMMUNICATIONS       NETWORK, IN RESPONSE TO A PATIENTS REQUEST, ESTABLISHED PATIENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1283, N'00750', N'ANESTHESIA FOR HERNIA REPAIRS IN UPPER ABDOMEN; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1284, N'00770', N'ANESTHESIA FOR ALL PROCEDURES ON MAJOR ABDOMINAL BLOOD VESSELS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1285, N'0101T', N'EXTRACORPOREAL SHOCK WAVE INVOLVING MUSCULOSKELETAL SYSTEM, NOT OTHERWISE SPECIFIED; HIGH ENERGY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1286, N'0107T', N'QUANTITATIVE SENSORY TESTING (QST), TESTING AND INTERPRETATION PER EXTREMITY; USING VIBRATION STIMULI TO ASSESS LARGEDIAMETER FIBER SENSATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1287, N'00792', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN UPPER ABDOMEN INCLUDING LAPAROSCOPY; PARTIAL HEPATECTOMY OR MANAGEMENT OF LIVER HEMORRHAGE (EXCLUDING LIVER BIOPSY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1288, N'00797', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN UPPER ABDOMEN INCLUDING LAPAROSCOPY; GASTRIC RESTRICTIVE PROCEDURE FOR MORBID OBESITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1289, N'00802', N'ANESTHESIA FOR PROCEDURES ON LOWER ANTERIOR ABDOMINAL WALL; PANNICULECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1290, N'0081T', N'PLACEMENT OF VISCERAL EXTENSION PROSTHESIS FOR ENDOVASCULAR REPAIR OF    ABDOMINAL AORTIC ANEURYSM INVOLVING VISCERAL VESSELS, EACH VISCERAL      BRANCH, RADIOLOGICAL SUPERVISION AND INTERPRETATION (LIST SEPARATELY IN  ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1291, N'01150', N'ANESTHESIA FOR RADICAL PROCEDURES FOR TUMOR OF PELVIS, EXCEPT HINDQUARTER AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1292, N'0115T', N'MEDICATION THERAPY MANAGEMENT SERVICE(S) PROVIDED BY A PHARMACIST, INDIVIDUAL, FACE-TO-FACE WITH PATIENT, INITIAL 15 MINUTES, WITH ASSESSMENT, AND INTERVENTION IF PROVIDED; INITIAL ENCOUNTER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1293, N'01482', N'ANESTHESIA FOR OPEN PROCEDURES ON BONES OF LOWER LEG, ANKLE, AND FOOT; RADICAL RESECTION (INCLUDING BELOW KNEE AMPUTATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1294, N'01486', N'ANESTHESIA FOR OPEN PROCEDURES ON BONES OF LOWER LEG, ANKLE, AND FOOT; TOTAL ANKLE REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1295, N'00834', N'ANESTHESIA FOR HERNIA REPAIRS IN THE LOWER ABDOMEN NOT OTHERWISE SPECIFIED, UNDER 1 YEAR OF AGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1296, N'00836', N'ANESTHESIA FOR HERNIA REPAIRS IN THE LOWER ABDOMEN NOT OTHERWISE SPECIFIED, INFANTS LESS THAN 37 WEEKS GESTATIONAL AGE AT BIRTH AND LESS THAN 50 WEEKS GESTATIONAL AGE AT TIME OF SURGERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1297, N'01420', N'ANESTHESIA FOR ALL CAST APPLICATIONS, REMOVAL, OR REPAIR INVOLVING KNEE JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1298, N'01432', N'ANESTHESIA FOR PROCEDURES ON VEINS OF KNEE AND POPLITEAL AREA; ARTERIOVENOUS FISTULA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1299, N'0083T', N'STEREOTACTIC BODY RADIATION THERAPY, TREATMENT MANAGEMENT, PER DAY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1300, N'00840', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN INCLUDING LAPAROSCOPY; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1301, N'01442', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF KNEE AND POPLITEAL AREA; POPLITEAL THROMBOENDARTERECTOMY, WITH OR WITHOUT PATCH GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1302, N'01444', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF KNEE AND POPLITEAL AREA; POPLITEAL EXCISION AND GRAFT OR REPAIR FOR OCCLUSION OR ANEURYSM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 300 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1303, N'00846', N'ANESTHESIA FOR INTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN INCLUDING LAPAROSCOPY; RADICAL HYSTERECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1304, N'0085T', N'BREATH TEST FOR HEART TRANSPLANT REJECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1305, N'0144T', N'COMPUTED TOMOGRAPHY, HEART, WITHOUT CONTRAST MATERIAL, INCLUDING IMAGE POST PROCESSING AND QUANTITATIVE EVALUATION OF CORONARY CALCIUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1306, N'00866', N'ANESTHESIA FOR EXTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN, INCLUDING URINARY TRACT; ADRENALECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1307, N'00869', N'ANESTHESIA FOR EXTRAPERITONEAL PROCEDURES IN LOWER ABDOMEN, INCLUDING URINARY TRACT; VASECTOMY, UNILATERAL/BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1308, N'01460', N'ANESTHESIA FOR ALL PROCEDURES ON INTEGUMENTARY SYSTEM OF LOWER LEG, ANKLE, AND FOOT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1309, N'0146T', N'COMPUTED TOMOGRAPHY, HEART, WITH CONTRAST MATERIAL(S), INCLUDING NONCONTRAST IMAGES, IF PERFORMED, CARDIAC GATING AND 3D IMAGE POSTPROCESSING; COMPUTED TOMOGRAPHIC ANGIOGRAPHY OF CORONARY ARTERIES (INCLUDING NATIVE AND ANOMALOUS CORONARY ARTERIES, CORONARY BYPASS GRAFTS), WITHOUT QUANTITATIVE EVALUATION OF CORONARY CALCIUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1310, N'0086T', N'LEFT VENTRICULAR FILLING PRESSURE INDIRECT MEASUREMENT BY COMPUTERIZED   CALIBRATION OF THE ARTERIAL WAVEFORM RESPONSE TO VALSALVA MANEUVER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1311, N'01470', N'ANESTHESIA FOR PROCEDURES ON NERVES, MUSCLES, TENDONS, AND FASCIA OF LOWER LEG, ANKLE, AND FOOT; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1312, N'01480', N'ANESTHESIA FOR OPEN PROCEDURES ON BONES OF LOWER LEG, ANKLE, AND FOOT; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1313, N'0088T', N'SUBMUCOSAL RADIOFREQUENCY TISSUE VOLUME REDUCTION OF TONGUE BASE, ONE OR MORE SITES, PER SESSION (IE, FOR TREATMENT OF OBSTRUCTIVE SLEEP APNEA    SYNDROME)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1314, N'0089T', N'ACTIGRAPHY TESTING, RECORDING, ANALYSIS AND INTERPRETATION (MINIMUM OF THREE-DAY RECORDING)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1315, N'00902', N'ANESTHESIA FOR; ANORECTAL PROCEDURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1316, N'01490', N'ANESTHESIA FOR LOWER LEG CAST APPLICATION, REMOVAL, OR REPAIR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1317, N'0149T', N'COMPUTED TOMOGRAPHY, HEART, WITH CONTRAST MATERIAL(S), INCLUDING NONCONTRAST IMAGES, IF PERFORMED, CARDIAC GATING AND 3D IMAGE POSTPROCESSING; CARDIAC STRUCTURE AND MORPHOLOGY AND COMPUTED TOMOGRAPHIC ANGIOGRAPHY OF CORONARY ARTERIES (INCLUDING NATIVE AND ANOMALOUS CORONARY ARTERIES, CORONARY BYPASS GRAFTS), WITH QUANTITATIVE EVALUATION OF CORONARY CALCIUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1318, N'00910', N'ANESTHESIA FOR TRANSURETHRAL PROCEDURES (INCLUDING URETHROCYSTOSCOPY); NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1319, N'00916', N'ANESTHESIA FOR TRANSURETHRAL PROCEDURES (INCLUDING URETHROCYSTOSCOPY); POST-TRANSURETHRAL RESECTION BLEEDING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1320, N'01170', N'ANESTHESIA FOR OPEN PROCEDURES INVOLVING SYMPHYSIS PUBIS OR SACROILIAC JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1321, N'01214', N'ANESTHESIA FOR OPEN PROCEDURES INVOLVING HIP JOINT; TOTAL HIP ARTHROPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1322, N'01220', N'ANESTHESIA FOR ALL CLOSED PROCEDURES INVOLVING UPPER 2/3 OF FEMUR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1323, N'01232', N'ANESTHESIA FOR OPEN PROCEDURES INVOLVING UPPER 2/3 OF FEMUR; AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1324, N'01500', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF LOWER LEG, INCLUDING BYPASS GRAFT; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1325, N'0150T', N'COMPUTED TOMOGRAPHY, HEART, WITH CONTRAST MATERIAL(S), INCLUDING NONCONTRAST IMAGES, IF PERFORMED, CARDIAC GATING AND 3D IMAGE POSTPROCESSING; CARDIAC STRUCTURE AND MORPHOLOGY IN CONGENITAL HEART DISEASE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1326, N'01250', N'ANESTHESIA FOR ALL PROCEDURES ON NERVES, MUSCLES, TENDONS, FASCIA, AND BURSAE OF UPPER LEG', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1327, N'01272', N'ANESTHESIA FOR PROCEDURES INVOLVING ARTERIES OF UPPER LEG, INCLUDING BYPASS GRAFT; FEMORAL ARTERY LIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1328, N'01320', N'ANESTHESIA FOR ALL PROCEDURES ON NERVES, MUSCLES, TENDONS, FASCIA, AND BURSAE OF KNEE AND/OR POPLITEAL AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1329, N'01340', N'ANESTHESIA FOR ALL CLOSED PROCEDURES ON LOWER 1/3 OF FEMUR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1330, N'01502', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF LOWER LEG, INCLUDING BYPASS GRAFT; EMBOLECTOMY, DIRECT OR WITH CATHETER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1331, N'0153T', N'TRANSCATHETER PLACEMENT OF WIRELESS PHYSIOLOGIC SENSOR IN ANEURYSMAL SAC DURING ENDOVASCULAR REPAIR, INCLUDING RADIOLOGICAL SUPERVISION AND INTERPRETATION AND INSTRUMENT CALIBRATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1332, N'01382', N'ANESTHESIA FOR DIAGNOSTIC ARTHROSCOPIC PROCEDURES OF KNEE JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1333, N'0143T', N'LAPAROSCOPY, SURGICAL, PANCREATIC ISLET CELL TRANSPLANTATION THROUGH PORTAL VEIN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1334, N'0151T', N'COMPUTED TOMOGRAPHY, HEART, WITH CONTRAST MATERIAL(S), INCLUDING NONCONTRAST IMAGES, IF PERFORMED, CARDIAC GATING AND 3D IMAGE POSTPROCESSING, FUNCTION EVALUATION (LEFT AND RIGHT VENTRICULAR FUNCTION, EJECTION-FRACTION AND SEGMENTAL WALL MOTION) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1335, N'0154T', N'NON-INVASIVE PHYSIOLOGIC STUDY OF IMPLANTED WIRELESS PRESSURE SENSOR IN ANEURYSMAL SAC FOLLOWING ENDOVASCULAR REPAIR, COMPLETE STUDY INCLUDING RECORDING, ANALYSIS OF PRESSURE AND WAVEFORM TRACINGS, INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1336, N'0159T', N'COMPUTER AIDED DETECTION, INCLUDING COMPUTER ALGORITHM ANALYSIS OF MRI IMAGE DATA FOR LESION DETECTION/CHARACTERIZATION, PHARMACOKINETIC ANALYSIS, WITH FURTHER PHYSICIAN REVIEW FOR INTERPRETATION, BREAST MRI', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1337, N'00926', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); RADICAL ORCHIECTOMY, INGUINAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1338, N'00930', N'ANESTHESIA FOR PROCEDURES ON MALE GENITALIA (INCLUDING OPEN URETHRAL PROCEDURES); ORCHIOPEXY, UNILATERAL OR BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1339, N'00940', N'ANESTHESIA FOR VAGINAL PROCEDURES (INCLUDING BIOPSY OF LABIA, VAGINA, CERVIX OR ENDOMETRIUM); NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1340, N'0094T', N'REMOVAL OF TOTAL DISC ARTHROPLASTY, ANTERIOR APPROACH; SINGLE INTERSPACE, LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1341, N'00950', N'ANESTHESIA FOR VAGINAL PROCEDURES (INCLUDING BIOPSY OF LABIA, VAGINA, CERVIX OR ENDOMETRIUM); CULDOSCOPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1342, N'00952', N'ANESTHESIA FOR VAGINAL PROCEDURES (INCLUDING BIOPSY OF LABIA, VAGINA, CERVIX OR ENDOMETRIUM); HYSTEROSCOPY AND/OR HYSTEROSALPINGOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1343, N'01634', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES ON HUMERAL HEAD AND NECK, STERNOCLAVICULAR JOINT, ACROMIOCLAVICULAR JOINT, AND SHOULDER JOINT; SHOULDER DISARTICULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1344, N'0147T', N'COMPUTED TOMOGRAPHY, HEART, WITH CONTRAST MATERIAL(S), INCLUDING NONCONTRAST IMAGES, IF PERFORMED, CARDIAC GATING AND 3D IMAGE POSTPROCESSING; COMPUTED TOMOGRAPHIC ANGIOGRAPHY OF CORONARY ARTERIES (INCLUDING NATIVE AND ANOMALOUS CORONARY ARTERIES, CORONARY BYPASS GRAFTS), WITH QUANTITATIVE EVALUATION OF CORONARY CALCIUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1345, N'0106T', N'QUANTITATIVE SENSORY TESTING (QST), TESTING AND INTERPRETATION PER EXTREMITY; USING TOUCH PRESSURE STIMULI TO ASSESS LARGE DIAMETER SENSATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1346, N'01636', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES ON HUMERAL HEAD AND NECK, STERNOCLAVICULAR JOINT, ACROMIOCLAVICULAR JOINT, AND SHOULDER JOINT; INTERTHORACOSCAPULAR (FOREQUARTER) AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1347, N'01638', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES ON HUMERAL HEAD AND NECK, STERNOCLAVICULAR JOINT, ACROMIOCLAVICULAR JOINT, AND SHOULDER JOINT; TOTAL SHOULDER REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1348, N'01520', N'ANESTHESIA FOR PROCEDURES ON VEINS OF LOWER LEG; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1349, N'0152T', N'COMPUTER AIDED DETECTION (COMPUTER ALGORITHM ANALYSIS OF DIGITAL IMAGE DATA FOR LESION DETECTION) WITH FURTHER PHYSICIAN REVIEW FOR INTERPRETATION, WITH OR WITHOUT DIGITIZATION OF FILM RADIOGRAPHIC IMAGES, CHEST RADIOGRAPH(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1350, N'0110T', N'QUANTITATIVE SENSORY TESTING (QST), TESTING AND INTERPRETATION PER EXTREMITY;USING OTHER STIMULI TO ASSESS SENSATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1351, N'01110', N'ANESTHESIA FOR PROCEDURES ON POSTERIOR INTEGUMENTARY SYSTEM OF PELVIS (POSTERIOR TO ILIAC CREST), EXCEPT PERINEUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1352, N'0163T', N'TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, INCLUDING DISCECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION), EACH ADDITIONAL INTERSPACE, LUMBAR (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1353, N'0155T', N'LAPAROSCOPY, SURGICAL, IMPLANTATION OR REPLACEMENT OF GASTRIC STIMULATION ELECTRODES, LESSER CURVATURE (IE, MORBID OBESITY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1354, N'0157T', N'LAPAROTOMY, IMPLANTATION OR REPLACEMENT OF GASTRIC STIMULATION ELECTRODES, LESSER CURVATURE (IE, MORBID OBESITY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1355, N'01600', N'ANESTHESIA FOR ALL PROCEDURES ON INTEGUMENTARY SYSTEM OF SHOULDER AND AXILLA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1356, N'01620', N'ANESTHESIA FOR ALL CLOSED PROCEDURES ON HUMERAL HEAD AND NECK, STERNOCLAVICULAR JOINT, ACROMIOCLAVICULAR JOINT, AND SHOULDER JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1357, N'01682', N'ANESTHESIA FOR SHOULDER CAST APPLICATION, REMOVAL OR REPAIR; SHOULDER SPICA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1358, N'0168T', N'RHINOPHOTOTHERAPY, INTRANASAL APPLICATION OF ULTRAVIOLET AND VISIBLE LIGHT, BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1359, N'01112', N'ANESTHESIA FOR BONE MARROW ASPIRATION AND/OR BIOPSY, ANTERIOR OR POSTERIOR ILIAC CREST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1360, N'01120', N'ANESTHESIA FOR PROCEDURES ON BONY PELVIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1361, N'0169T', N'STEREOTACTIC PLACEMENT OF INFUSION CATHETER(S) IN THE BRAIN FOR DELIVERY OF THERAPEUTIC AGENT(S), INCLUDING COMPUTERIZED STEREOTACTIC PLANNING AND BURR HOLE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1362, N'0164T', N'REMOVAL OF TOTAL DISC ARTHROPLASTY, (ARTIFICIAL DISC), ANTERIOR APPROACH, EACH ADDITIONAL INTERSPACE, LUMBAR (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1363, N'01700', N'ANESTHESIA FOR ALL PROCEDURES ON INTEGUMENTARY SYSTEM OF UPPER ARM AND ELBOW', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1364, N'0170T', N'REPAIR OF ANORECTAL FISTULA WITH PLUG (EG, PORCINE SMALL INTESTINE SUBMUCOSA [SIS])', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1365, N'01650', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF SHOULDER AND AXILLA; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1366, N'01680', N'ANESTHESIA FOR SHOULDER CAST APPLICATION, REMOVAL OR REPAIR; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1367, N'01716', N'ANESTHESIA FOR PROCEDURES ON NERVES, MUSCLES, TENDONS, FASCIA, AND BURSAE OF UPPER ARM AND ELBOW; TENODESIS, RUPTURE OF LONG TENDON OF BICEPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1368, N'01740', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES OF THE ELBOW; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1369, N'01760', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES OF THE ELBOW; TOTAL ELBOW REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1370, N'01710', N'ANESTHESIA FOR PROCEDURES ON NERVES, MUSCLES, TENDONS, FASCIA, AND BURSAE OF UPPER ARM AND ELBOW; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1371, N'01714', N'ANESTHESIA FOR PROCEDURES ON NERVES, MUSCLES, TENDONS, FASCIA, AND BURSAE OF UPPER ARM AND ELBOW; TENOPLASTY, ELBOW TO SHOULDER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1372, N'0178T', N'ELECTROCARDIOGRAM, 64 LEADS OR  GREATER, WITH GRAPHIC PRESENTATION AND ANALYSIS; WITH INTERPRETATION  AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1373, N'0181T', N'CORNEAL HYSTERESIS DETERMINATION, BY AIR IMPULSE STIMULATION, BILATERAL, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1374, N'01730', N'ANESTHESIA FOR ALL CLOSED PROCEDURES ON HUMERUS AND ELBOW', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1375, N'01732', N'ANESTHESIA FOR DIAGNOSTIC ARTHROSCOPIC PROCEDURES OF ELBOW JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1376, N'0156T', N'LAPAROSCOPY, SURGICAL, REVISION OR REMOVAL OF GASTRIC STIMULATION ELECTRODES, LESSER CURVATURE (IE, MORBID OBESITY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1377, N'0160T', N'THERAPEUTIC REPETITIVE TRANSCRANIAL MAGNETIC STIMULATION TREATMENT PLANNING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1378, N'01844', N'ANESTHESIA FOR VASCULAR SHUNT, OR SHUNT REVISION, ANY TYPE (EG, DIALYSIS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1379, N'0184T', N'EXCISION OF RECTAL TUMOR, TRANSANAL ENDOSCOPIC MICROSURGICAL APPROACH (IE, TEMS), INCLUDING MUSCULARIS PROPRIA (IE, FULL THICKNESS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1380, N'0175T', N'COMPUTER AIDED DETECTION (CAD) (COMPUTER ALGORITHM ANALYSIS OF DIGITAL IMAGE DATA FOR LESION DETECTION) WITH FURTHER PHYSICIAN REVIEW FOR INTERPRETATION AND REPORT, WITH OR WITHOUT DIGITIZATION OF FILM RADIOGRAPHIC IMAGES, CHEST RADIOGRAPH(S), PERFORMED REMOTE FROM PRIMARY INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1381, N'01610', N'ANESTHESIA FOR ALL PROCEDURES ON NERVES, MUSCLES, TENDONS, FASCIA, AND BURSAE OF SHOULDER AND AXILLA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1382, N'01622', N'ANESTHESIA FOR DIAGNOSTIC ARTHROSCOPIC PROCEDURES OF SHOULDER JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1383, N'01630', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES ON HUMERAL HEAD AND NECK, STERNOCLAVICULAR JOINT, ACROMIOCLAVICULAR JOINT, AND SHOULDER JOINT; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1384, N'01130', N'ANESTHESIA FOR BODY CAST APPLICATION OR REVISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1385, N'0116T', N'MEDICATION THERAPY MANAGEMENT SERVICE(S) PROVIDED BY A PHARMACIST, INDIVIDUAL, FACE-TO-FACE WITH PATIENT, INITIAL 15 MINUTES, WITH ASSESSMENT, AND INTERVENTION IF PROVIDED; SUBSEQUENT ENCOUNTER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1386, N'01850', N'ANESTHESIA FOR PROCEDURES ON VEINS OF FOREARM, WRIST, AND HAND; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1387, N'01860', N'ANESTHESIA FOR FOREARM, WRIST, OR HAND CAST APPLICATION, REMOVAL, OR REPAIR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1388, N'01632', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES ON HUMERAL HEAD AND NECK, STERNOCLAVICULAR JOINT, ACROMIOCLAVICULAR JOINT, AND SHOULDER JOINT; RADICAL RESECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1389, N'01900', N'ANESTHESIA FOR INJECTION PROCEDURE FOR HYSTEROSALPINGOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1390, N'01906', N'ANESTHESIA FOR INJECTION PROCEDURE FOR MYELOGRAPHY; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1391, N'01652', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF SHOULDER AND AXILLA; AXILLARY-BRACHIAL ANEURYSM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1392, N'01654', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF SHOULDER AND AXILLA; BYPASS GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1393, N'01712', N'ANESTHESIA FOR PROCEDURES ON NERVES, MUSCLES, TENDONS, FASCIA, AND BURSAE OF UPPER ARM AND ELBOW; TENOTOMY, ELBOW TO SHOULDER, OPEN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1394, N'0180T', N'ELECTROCARDIOGRAM, 64 LEADS OR GREATER, INTERPRETATION AND REPORT ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1395, N'01820', N'ANESTHESIA FOR ALL CLOSED PROCEDURES ON RADIUS, ULNA, WRIST, OR HAND BONES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1396, N'01200', N'ANESTHESIA FOR ALL CLOSED PROCEDURES INVOLVING HIP JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1397, N'01202', N'ANESTHESIA FOR ARTHROSCOPIC PROCEDURES OF HIP JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1398, N'01830', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC/ENDOSCOPIC PROCEDURES ON DISTAL RADIUS, DISTAL ULNA, WRIST, OR HAND JOINTS; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1399, N'01230', N'ANESTHESIA FOR OPEN PROCEDURES INVOLVING UPPER 2/3 OF FEMUR; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1400, N'01240', N'ANESTHESIA FOR ALL PROCEDURES ON INTEGUMENTARY SYSTEM OF UPPER LEG', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1401, N'01832', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC/ENDOSCOPIC PROCEDURES ON DISTAL RADIUS, DISTAL ULNA, WRIST, OR HAND JOINTS; TOTAL WRIST REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1402, N'01260', N'ANESTHESIA FOR ALL PROCEDURES INVOLVING VEINS OF UPPER LEG, INCLUDING EXPLORATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1403, N'01270', N'ANESTHESIA FOR PROCEDURES INVOLVING ARTERIES OF UPPER LEG, INCLUDING BYPASS GRAFT; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 400 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1404, N'01842', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF FOREARM, WRIST, AND HAND; EMBOLECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1405, N'0185T', N'MULTIVARIATE ANALYSIS OF PATIENT-SPECIFIC FINDINGS WITH QUANTIFIABLE COMPUTER PROBABILITY ASSESSMENT, INCLUDING REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1406, N'0189T', N'REMOTE REAL-TIME INTERACTIVE VIDEO-CONFERENCED CRITICAL CARE, EVALUATION AND MANAGEMENT OF THE CRITICALLY ILL OR CRITICALLY INJURED PATIENT; EACH ADDITIONAL 30 MINUTES (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY SERVICE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1407, N'01908', N'ANESTHESIA FOR INJECTION PROCEDURE FOR MYELOGRAPHY; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1408, N'01910', N'ANESTHESIA FOR INJECTION PROCEDURE FOR MYELOGRAPHY; POSTERIOR FOSSA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1409, N'01902', N'ANESTHESIA FOR BURR HOLE(S) FOR VENTRICULOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1410, N'01904', N'ANESTHESIA FOR INJECTION PROCEDURE FOR PNEUMOENCEPHALOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1411, N'01918', N'ANESTHESIA FOR ARTERIOGRAMS, NEEDLE; RETROGRADE, BRACHIAL OR FEMORAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1412, N'01921', N'ANESTHESIA FOR ANGIOPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1413, N'01931', N'ANESTHESIA FOR THERAPEUTIC INTERVENTIONAL RADIOLOGICAL PROCEDURES INVOLVING THE VENOUS/LYMPHATIC SYSTEM (NOT TO INCLUDE ACCESS TO THE CENTRAL CIRCULATION); INTRAHEPATIC OR PORTAL CIRCULATION (EG, TRANSVENOUS INTRAHEPATIC PORTOSYSTEMIC SHUNT[S] [TIPS])', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1414, N'01905', N'ANESTHESIA FOR MYELOGRAPHY, DISKOGRAPHY, VERTEBROPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1415, N'0191T', N'INSERTION OF ANTERIOR SEGMENT AQUEOUS DRAINAGE DEVICE, WITHOUT EXTRAOCULAR RESERVOIR; INTERNAL APPROACH, INTO THE TRABECULAR MESHWORK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1416, N'01932', N'ANESTHESIA FOR THERAPEUTIC INTERVENTIONAL RADIOLOGIC PROCEDURES INVOLVING THE VENOUS/LYMPHATIC SYSTEM (NOT TO INCLUDE ACCESS TO THE CENTRAL CIRCULATION); INTRATHORACIC OR JUGULAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1417, N'0172T', N'EACH ADDITIONAL LEVEL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1418, N'0173T', N'MONITORING OF INTRAOCULAR PRESSURE DURING VITRECTOMY SURGERY (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1419, N'01933', N'ANESTHESIA FOR THERAPEUTIC INTERVENTIONAL RADIOLOGIC PROCEDURES INVOLVING THE VENOUS/LYMPHATIC SYSTEM (NOT TO INCLUDE ACCESS TO THE CENTRAL CIRCULATION); INTRACRANIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1420, N'0193T', N'TRANSURETHRAL, RADIOFREQUENCY MICRO-REMODELING OF THE FEMALE BLADDER NECK AND PROXIMAL URETHRA FOR STRESS URINARY INCONTINENCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1421, N'01952', N'ANESTHESIA FOR SECOND AND THIRD DEGREE BURN EXCISION OR DEBRIDEMENT WITH OR WITHOUT SKIN GRAFTING, ANY SITE, FOR TOTAL BODY SURFACE AREA (TBSA) TREATED DURING ANESTHESIA AND SURGERY; BETWEEN FOUR AND NINE PERCENT OF TOTAL BODY SURFACE AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1422, N'01924', N'ANESTHESIA FOR THERAPEUTIC INTERVENTIONAL RADIOLOGIC PROCEDURES INVOLVING THE ARTERIAL SYSTEM; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1423, N'01926', N'ANESTHESIA FOR THERAPEUTIC INTERVENTIONAL RADIOLOGIC PROCEDURES INVOLVING THE ARTERIAL SYSTEM; INTRACRANIAL, INTRACARDIAC, OR AORTIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1424, N'01964', N'ANESTHESIA FOR; ABORTION PROCEDURES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1425, N'01967', N'NEURAXIAL LABOR ANALGESIA/ANESTHESIA FOR PLANNED VAGINAL DELIVERY (THIS INCLUDES ANY REPEAT SUBARACHNOID NEEDLE PLACEMENT AND DRUG INJECTION AND/OR ANY NECESSARY REPLACEMENT OF AN EPIDURAL CATHETER DURING LABOR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1426, N'01930', N'ANESTHESIA FOR THERAPEUTIC INTERVENTIONAL RADIOLOGIC PROCEDURES INVOLVING THE VENOUS/LYMPHATIC SYSTEM (NOT TO INCLUDE ACCESS TO THE CENTRAL CIRCULATION); NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1427, N'01968', N'ANESTHESIA FOR CESAREAN DELIVERY FOLLOWING NEURAXIAL LABOR ANALGESIA/ANESTHESIA (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE PERFORMED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1428, N'01936', N'ANESTHESIA FOR PERCUTANEOUS IMAGE GUIDED PROCEDURES ON THE SPINE AND SPINAL CORD; THERAPEUTIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1429, N'0194T', N'PROCALCITONIN (PCT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1430, N'01969', N'ANESTHESIA FOR CESAREAN HYSTERECTOMY FOLLOWING NEURAXIAL LABOR ANALGESIA/ANESTHESIA (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE PERFORMED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1431, N'01742', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES OF THE ELBOW; OSTEOTOMY OF HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1432, N'01744', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES OF THE ELBOW; REPAIR OF NONUNION OR MALUNION OF HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1433, N'01990', N'PHYSIOLOGICAL SUPPORT FOR HARVESTING OF ORGAN(S) FROM BRAIN-DEAD PATIENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1434, N'0207T', N'EVACUATION OF MEIBOMIAN GLANDS, AUTOMATED, USING HEAT AND INTERMITTENT PRESSURE, UNILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1435, N'01756', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES OF THE ELBOW; RADICAL PROCEDURES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1436, N'01758', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES OF THE ELBOW; EXCISION OF CYST OR TUMOR OF HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1437, N'01300', N'ANESTHESIA FOR ALL PROCEDURES ON INTEGUMENTARY SYSTEM OF KNEE AND/OR POPLITEAL AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1438, N'0130T', N'VALIDATED, STATISTICALLY RELIABLE, RANDOMIZED, CONTROLLED, SINGLE-PATIENT CLINICAL INVESTIGATION OF FDA APPROVED CHRONIC CARE DRUGS, PROVIDED BY A PHARMACIST, INTERPRETATION AND REPORT TO THE PRESCRIBING HEALTH CARE PROFESSIONAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1439, N'01951', N'ANESTHESIA FOR SECOND AND THIRD DEGREE BURN EXCISION OR DEBRIDEMENT WITH OR WITHOUT SKIN GRAFTING, ANY SITE, FOR TOTAL BODY SURFACE AREA (TBSA) TREATED DURING ANESTHESIA AND SURGERY; LESS THAN FOUR PERCENT TOTAL BODY SURFACE AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1440, N'0211T', N'SPEECH AUDIOMETRY THRESHOLD, AUTOMATED; WITH SPEECH RECOGNITION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1441, N'0215T', N'INJECTION(S), DIAGNOSTIC OR THERAPEUTIC AGENT, PARAVERTEBRAL FACET (ZYGAPOPHYSEAL) JOINT (OR NERVES INNERVATING THAT JOINT) WITH ULTRASOUND GUIDANCE, CERVICAL OR THORACIC; THIRD AND ANY ADDITIONAL LEVEL(S) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1442, N'01960', N'ANESTHESIA FOR; VAGINAL DELIVERY ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1443, N'01962', N'ANESTHESIA FOR; URGENT HYSTERECTOMY FOLLOWING DELIVERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1444, N'01966', N'ANESTHESIA FOR INDUCED ABORTION PROCEDURES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1445, N'01390', N'ANESTHESIA FOR ALL CLOSED PROCEDURES ON UPPER ENDS OF TIBIA, FIBULA, AND/OR PATELLA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1446, N'01392', N'ANESTHESIA FOR ALL OPEN PROCEDURES ON UPPER ENDS OF TIBIA, FIBULA, AND/OR PATELLA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1447, N'01400', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES ON KNEE JOINT; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1448, N'01404', N'ANESTHESIA FOR OPEN OR SURGICAL ARTHROSCOPIC PROCEDURES ON KNEE JOINT; DISARTICULATION AT KNEE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1449, N'0176T', N'TRANSLUMINAL DILATION OF AQUEOUS OUTFLOW CANAL; WITHOUT RETENTION OF DEVICE OR STENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1450, N'01770', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF UPPER ARM AND ELBOW; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1451, N'01430', N'ANESTHESIA FOR PROCEDURES ON VEINS OF KNEE AND POPLITEAL AREA; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1452, N'01440', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF KNEE AND POPLITEAL AREA; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1453, N'01772', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF UPPER ARM AND ELBOW; EMBOLECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1454, N'0177T', N'WITH RETENTION OF DEVICE OR STENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1455, N'01780', N'ANESTHESIA FOR PROCEDURES ON VEINS OF UPPER ARM AND ELBOW; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1456, N'01462', N'ANESTHESIA FOR ALL CLOSED PROCEDURES ON LOWER LEG, ANKLE, AND FOOT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1457, N'01472', N'ANESTHESIA FOR PROCEDURES ON NERVES, MUSCLES, TENDONS, AND FASCIA OF LOWER LEG, ANKLE, AND FOOT; REPAIR OF RUPTURED ACHILLES TENDON, WITH OR WITHOUT GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1458, N'0197T', N'INTRA-FRACTION LOCALIZATION AND TRACKING OF TARGET OR PATIENT MOTION DURING DELIVERY OF RADIATION THERAPY (EG, 3D POSITIONAL TRACKING, GATING, 3D SURFACE TRACKING), EACH FRACTION OF TREATMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1459, N'01784', N'ANES- REPR ARTERIO-VENOUS FISTULA CONGEN/ACQUIRE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1460, N'01800', N'ANESTHESIA FOR ALL PROCEDURES ON INTEGUMENTARY SYSTEM OF FOREARM, WRIST, AND HAND', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1461, N'0182T', N'HIGH DOSE RATE ELECTRONIC BRACHYTHERAPY, PER FRACTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1462, N'0183T', N'LOW FREQUENCY, NON-CONTACT, NON-THERMAL ULTRASOUND, INCLUDING TOPICAL APPLICATION(S) WHEN PERFORMED, WOUND ASSESSMENT, AND INSTRUCTION(S) FOR ONGOING CARE, PER DAY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1463, N'01484', N'ANESTHESIA FOR OPEN PROCEDURES ON BONES OF LOWER LEG, ANKLE, AND FOOT; OSTEOTOMY OR OSTEOPLASTY OF TIBIA AND/OR FIBULA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1464, N'0148T', N'COMPUTED TOMOGRAPHY, HEART, WITH CONTRAST MATERIAL(S), INCLUDING NONCONTRAST IMAGES, IF PERFORMED, CARDIAC GATING AND 3D IMAGE POSTPROCESSING; CARDIAC STRUCTURE AND MORPHOLOGY AND COMPUTED TOMOGRAPHIC ANGIOGRAPHY OF CORONARY ARTERIES (INCLUDING NATIVE AND ANOMALOUS CORONARY ARTERIES, CORONARY BYPASS GRAFTS), WITHOUT QUANTITATIVE EVALUATION OF CORONARY CALCIUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1465, N'01991', N'ANESTHESIA FOR DIAGNOSTIC OR THERAPEUTIC NERVE BLOCKS AND INJECTIONS (WHEN BLOCK OR INJECTION IS PERFORMED BY A DIFFERENT PROVIDER); OTHER THAN THE PRONE POSITION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1466, N'0219T', N'PLACEMENT OF POSTERIOR INTRAFACET IMPLANT(S), UNILATERAL OR BILATERAL, INCLUDING IMAGING AND PLACEMENT OF BONE GRAFT(S) OR SYNTHETIC DEVICE(S), SINGLE LEVEL; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1467, N'01992', N'ANESTHESIA FOR DIAGNOSTIC OR THERAPEUTIC NERVE BLOCKS AND INJECTIONS (WHEN BLOCK OR INJECTION IS PERFORMED BY A DIFFERENT PROVIDER); PRONE POSITION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1468, N'01522', N'ANESTHESIA FOR PROCEDURES ON VEINS OF LOWER LEG; VENOUS THROMBECTOMY, DIRECT OR WITH CATHETER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1469, N'0158T', N'LAPAROTOMY, REVISION OR REMOVAL OF GASTRIC STIMULATION ELECTRODES, LESSER CURVATURE (IE, MORBID OBESITY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1470, N'01996', N'DAILY HOSPITAL MANAGEMENT OF EPIDURAL OR SUBARACHNOID CONTINUOUS DRUG ADMINISTRATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1471, N'01999', N'UNLISTED ANESTHESIA PROCEDURE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1472, N'0186T', N'SUPRACHOROIDAL DELIVERY OF PHARMACOLOGIC AGENT (DOES NOT INCLUDE SUPPLY OF MEDICATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1473, N'0187T', N'SCANNING COMPUTERIZED OPHTHALMIC DIAGNOSTIC IMAGING, ANTERIOR SEGMENT, WITH INTERPRETATION AND REPORT, UNILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1474, N'0220T', N'PLACEMENT OF POSTERIOR INTRAFACET IMPLANT(S), UNILATERAL OR BILATERAL, INCLUDING IMAGING AND PLACEMENT OF BONE GRAFT(S) OR SYNTHETIC DEVICE(S), SINGLE LEVEL; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1475, N'0199T', N'PHYSIOLOGIC RECORDING OF TREMOR USING ACCELEROMETER(S) AND/OR GYROSCOPE(S) (INCLUDING FREQUENCY AND AMPLITUDE), INCLUDING INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1476, N'0223T', N'ACOUSTIC CARDIOGRAPHY, INCLUDING AUTOMATED ANALYSIS OF COMBINED ACOUSTIC AND ELECTRICAL INTERVALS; SINGLE, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1477, N'0190T', N'PLACEMENT OF INTRAOCULAR RADIATION SOURCE APPLICATOR (LIST SEPARATELY IN ADDITION TO PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1478, N'01920', N'ANESTHESIA FOR CARDIAC CATHETERIZATION INCLUDING CORONARY ANGIOGRAPHY AND VENTRICULOGRAPHY (NOT TO INCLUDE SWAN-GANZ CATHETER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1479, N'0161T', N'THERAPEUTIC REPETITIVE TRANSCRANIAL MAGNETIC STIMULATION TREATMENT DELIVERY AND MANAGEMENT, PER SESSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1480, N'0162T', N'ELECTRONIC ANALYSIS AND PROGRAMMING, REPROGRAMMING OF GASTRIC NEUROSTIMULATOR (IE, MORBID OBESITY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1481, N'01935', N'ANESTHESIA FOR PERCUTANEOUS IMAGE GUIDED PROCEDURES ON THE SPINE AND SPINAL CORD; DIAGNOSTIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1482, N'01958', N'ANESTHESIA FOR EXTERNAL CEPHALIC VERSION PROCEDURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1483, N'0225T', N'ACOUSTIC CARDIOGRAPHY, INCLUDING AUTOMATED ANALYSIS OF COMBINED ACOUSTIC AND ELECTRICAL INTERVALS; MULTIPLE, INCLUDING SERIAL TRENDED ANALYSIS AND LIMITED REPROGRAMMING OF DEVICE PARAMETER - AV AND VV DELAYS, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1484, N'0200T', N'PERCUTANEOUS SACRAL AUGMENTATION (SACROPLASTY), UNILATERAL INJECTION(S), INCLUDING THE USE OF A BALLOON OR MECHANICAL DEVICE, WHEN USED, 1 OR MORE NEEDLES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1485, N'0225T', N'ACOUSTIC CARDIOGRAPHY, INCLUDING AUTOMATED ANALYSIS OF COMBINED ACOUSTIC AND ELECTRICAL INTERVALS; MULTIPLE, INCLUDING SERIAL TRENDED ANALYSIS AND LIMITED REPROGRAMMING OF DEVICE PARAMETER, AV AND VV DELAYS, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1486, N'0208T', N'PURE TONE AUDIOMETRY (THRESHOLD), AUTOMATED; AIR ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1487, N'0212T', N'COMPREHENSIVE AUDIOMETRY THRESHOLD EVALUATION AND SPEECH RECOGNITION (0209T, 0211T COMBINED), AUTOMATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1488, N'0228T', N'INJECTION(S), ANESTHETIC AGENT AND/OR STEROID, TRANSFORAMINAL EPIDURAL, WITH ULTRASOUND GUIDANCE, CERVICAL OR THORACIC; SINGLE LEVEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1489, N'0195T', N'ARTHRODESIS, PRE-SACRAL INTERBODY TECHNIQUE, INCLUDING INSTRUMENTATION, IMAGING (WHEN PERFORMED), AND DISCECTOMY TO PREPARE INTERSPACE, LUMBAR; SINGLE INTERSPACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1490, N'01656', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF SHOULDER AND AXILLA; AXILLARY-FEMORAL BYPASS GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1491, N'0165T', N'REVISION INCLUDING REPLACEMENT OF TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, EACH ADDITIONAL INTERSPACE, LUMBAR (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1492, N'01961', N'ANESTHESIA FOR; CESAREAN DELIVERY ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1493, N'0196T', N'ARTHRODESIS, PRE-SACRAL INTERBODY TECHNIQUE, INCLUDING INSTRUMENTATION, IMAGING (WHEN PERFORMED), AND DISCECTOMY TO PREPARE INTERSPACE, LUMBAR; EACH ADDITIONAL INTERSPACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1494, N'0213T', N'INJECTION(S), DIAGNOSTIC OR THERAPEUTIC AGENT, PARAVERTEBRAL FACET (ZYGAPOPHYSEAL) JOINT (OR NERVES INNERVATING THAT JOINT) WITH ULTRASOUND GUIDANCE, CERVICAL OR THORACIC; SINGLE LEVEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1495, N'0229T', N'INJECTION(S), ANESTHETIC AGENT AND/OR STEROID, TRANSFORAMINAL EPIDURAL, WITH ULTRASOUND GUIDANCE, CERVICAL OR THORACIC; EACH ADDITIONAL LEVEL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1496, N'0214T', N'INJECTION(S), DIAGNOSTIC OR THERAPEUTIC AGENT, PARAVERTEBRAL FACET (ZYGAPOPHYSEAL) JOINT (OR NERVES INNERVATING THAT JOINT) WITH ULTRASOUND GUIDANCE, CERVICAL OR THORACIC; SECOND LEVEL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1497, N'0232T', N'INJECTION(S), PLATELET RICH PLASMA, ANY SITE, INCLUDING IMAGE GUIDANCE, HARVESTING AND PREPARATION WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1498, N'0237T', N'TRANSLUMINAL PERIPHERAL ATHERECTOMY, OPEN OR PERCUTANEOUS, INCLUDING RADIOLOGICAL SUPERVISION AND INTERPRETATION; BRACHIOCEPHALIC TRUNK AND BRANCHES, EACH VESSEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1499, N'0201T', N'PERCUTANEOUS SACRAL AUGMENTATION (SACROPLASTY), BILATERAL INJECTIONS, INCLUDING THE USE OF A BALLOON OR MECHANICAL DEVICE, WHEN USED, 2 OR MORE NEEDLES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1500, N'0166T', N'TRANSMYOCARDIAL TRANSCATHETER CLOSURE OF VENTRICULAR SEPTAL DEFECT, WITH IMPLANT; WITHOUT CARDIOPULMONARY BYPASS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1501, N'01670', N'ANESTHESIA FOR ALL PROCEDURES ON VEINS OF SHOULDER AND AXILLA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1502, N'0217T', N'INJECTION(S), DIAGNOSTIC OR THERAPEUTIC AGENT, PARAVERTEBRAL FACET (ZYGAPOPHYSEAL) JOINT (OR NERVES INNERVATING THAT JOINT) WITH ULTRASOUND GUIDANCE, LUMBAR OR SACRAL; SECOND LEVEL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1503, N'0239T', N'BIOIMPEDANCE SPECTROSCOPY (BIS), MEASURING 100 FREQUENCIES OR GREATER, DIRECT MEASUREMENT OF EXTRACELLULAR FLUID DIFFERENCES BETWEEN THE LIMBS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1504, N'0240T', N'ESOPHAGEAL MOTILITY (MANOMETRIC STUDY OF THE ESOPHAGUS AND/OR GASTROESOPHAGEAL JUNCTION) STUDY WITH INTERPRETATION AND REPORT; WITH 3-DIMENSIONAL HIGH RESOLUTION ESOPHAGEAL PRESSURE TOPOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 500 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1505, N'0218T', N'INJECTION(S), DIAGNOSTIC OR THERAPEUTIC AGENT, PARAVERTEBRAL FACET (ZYGAPOPHYSEAL) JOINT (OR NERVES INNERVATING THAT JOINT) WITH ULTRASOUND GUIDANCE, LUMBAR OR SACRAL; THIRD AND ANY ADDITIONAL LEVEL(S) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1506, N'0241T', N'ESOPHAGEAL MOTILITY (MANOMETRIC STUDY OF THE ESOPHAGUS AND/OR GASTROESOPHAGEAL JUNCTION) STUDY WITH INTERPRETATION AND REPORT; WITH STIMULATION OR PERFUSION DURING HIGH RESOLUTION ESOPHAGEAL PRESSURE TOPOGRAPHY STUDY (EG, STIMULANT, ACID OR ALKALI PERFUSION) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE) PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1507, N'0222T', N'PLACEMENT OF POSTERIOR INTRAFACET IMPLANT(S), UNILATERAL OR BILATERAL, INCLUDING IMAGING AND PLACEMENT OF BONE GRAFT(S) OR SYNTHETIC DEVICE(S), EACH ADDITIONAL VERTEBRAL SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1508, N'0244T', N'CONTINUOUS MEASUREMENT OF WHEEZE RATE DURING TREATMENT ASSESSMENT OR DURING SLEEP FOR DOCUMENTATION OF NOCTURNAL WHEEZE AND COUGH FOR DIAGNOSTIC EVALUATION 3 TO 24 HOURS, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1509, N'0167T', N'TRANSMYOCARDIAL TRANSCATHETER CLOSURE OF VENTRICULAR SEPTAL DEFECT, WITH IMPLANT; WITH CARDIOPULMONARY BYPASS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1510, N'0171T', N'INSERTION OF POSTERIOR SPINOUS PROCESS DISTRACTION DEVICE (INCLUDING NECESSARY REMOVAL OF BONE OR LIGAMENT FOR INSERTION AND IMAGING GUIDANCE), LUMBAR; SINGLE LEVEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1511, N'0174T', N'COMPUTER AIDED DETECTION (CAD) (COMPUTER ALGORITHM ANALYSIS OF DIGITAL IMAGE DATA FOR LESION DETECTION) WITH FURTHER PHYSICIAN REVIEW FOR INTERPRETATION AND REPORT, WITH OR WITHOUT DIGITIZATION OF FILM RADIOGRAPHIC IMAGES, CHEST RADIOGRAPH(S), PERFORMED CONCURRENT WITH PRIMARY INTERPRETATION (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1512, N'0202T', N'POSTERIOR VERTEBRAL JOINT(S) ARTHROPLASTY (EG, FACET JOINT[S] REPLACEMENT), INCLUDING FACETECTOMY, LAMINECTOMY, FORAMINOTOMY, AND VERTEBRAL COLUMN FIXATION, INJECTION OF BONE CEMENT, WHEN PERFORMED, INCLUDING FLUOROSCOPY, SINGLE LEVEL, LUMBAR SPINE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1513, N'0224T', N'ACOUSTIC CARDIOGRAPHY, INCLUDING AUTOMATED ANALYSIS OF COMBINED ACOUSTIC AND ELECTRICAL INTERVALS; MULTIPLE, INCLUDING SERIAL TRENDED ANALYSIS AND LIMITED REPROGRAMMING OF DEVICE PARAMETER - AV OR VV DELAYS ONLY, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1514, N'0203T', N'SLEEP STUDY, UNATTENDED, SIMULTANEOUS RECORDING; HEART RATE, OXYGEN SATURATION, RESPIRATORY ANALYSIS (EG, BY AIR FLOW OR PERIPHERAL ARTERIAL TONE) AND SLEEP TIME', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1515, N'01782', N'ANESTHESIA FOR PROCEDURES ON VEINS OF UPPER ARM AND ELBOW; PHLEBORRHAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1516, N'0179T', N'ELECTROCARDIOGRAM, 64 LEADS OR GREATER, TRACING AND GRAPHICS ONLY, WITHOUT INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1517, N'0205T', N'INTRAVASCULAR CATHETER-BASED CORONARY VESSEL OR GRAFT SPECTROSCOPY (EG, INFRARED) DURING DIAGNOSTIC EVALUATION AND/OR THERAPEUTIC INTERVENTION INCLUDING IMAGING SUPERVISION, INTERPRETATION, AND REPORT, EACH VESSEL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1518, N'01810', N'ANESTHESIA FOR ALL PROCEDURES ON NERVES, MUSCLES, TENDONS, FASCIA, AND BURSAE OF FOREARM, WRIST, AND HAND', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1519, N'01829', N'ANESTHESIA FOR DIAGNOSTIC ARTHROSCOPIC PROCEDURES ON THE WRIST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1520, N'0206T', N'COMPUTERIZED DATABASE ANALYSIS OF MULTIPLE CYCLES OF DIGITIZED CARDIAC ELECTRICAL DATA FROM TWO OR MORE ECG LEADS, INCLUDING TRANSMISSION TO A REMOTE CENTER, APPLICATION OF MULTIPLE NONLINEAR MATHEMATICAL TRANSFORMATIONS, WITH CORONARY ARTERY OBSTRUCTION SEVERITY ASSESSMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1521, N'01840', N'ANESTHESIA FOR PROCEDURES ON ARTERIES OF FOREARM, WRIST, AND HAND; NOT OTHERWISE SPECIFIED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1522, N'01852', N'ANESTHESIA FOR PROCEDURES ON VEINS OF FOREARM, WRIST, AND HAND; PHLEBORRHAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1523, N'0188T', N'REMOTE REAL-TIME INTERACTIVE VIDEO-CONFERENCED CRITICAL CARE, EVALUATION AND MANAGEMENT OF THE CRITICALLY ILL OR CRITICALLY INJURED PATIENT; FIRST 30-74 MINUTES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1524, N'0210T', N'SPEECH AUDIOMETRY THRESHOLD, AUTOMATED;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1525, N'0216T', N'INJECTION(S), DIAGNOSTIC OR THERAPEUTIC AGENT, PARAVERTEBRAL FACET (ZYGAPOPHYSEAL) JOINT (OR NERVES INNERVATING THAT JOINT) WITH ULTRASOUND GUIDANCE, LUMBAR OR SACRAL; SINGLE LEVEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1526, N'01912', N'ANESTHESIA FOR INJECTION PROCEDURE FOR DISKOGRAPHY; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1527, N'01914', N'ANESTHESIA FOR INJECTION PROCEDURE FOR DISKOGRAPHY; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1528, N'01916', N'ANESTHESIA FOR DIAGNOSTIC ARTERIOGRAPHY/VENOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1529, N'01922', N'ANESTHESIA FOR NON-INVASIVE IMAGING OR RADIATION THERAPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1530, N'01925', N'ANESTHESIA FOR THERAPEUTIC INTERVENTIONAL RADIOLOGIC PROCEDURES INVOLVING THE ARTERIAL SYSTEM; CAROTID OR CORONARY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1531, N'0192T', N'INSERTION OF ANTERIOR SEGMENT AQUEOUS DRAINAGE DEVICE, WITHOUT EXTRAOCULAR RESERVOIR; EXTERNAL APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1532, N'01953', N'ANESTHESIA FOR SECOND AND THIRD DEGREE BURN EXCISION OR DEBRIDEMENT WITH OR WITHOUT SKIN GRAFTING, ANY SITE, FOR TOTAL BODY SURFACE AREA (TBSA) TREATED DURING ANESTHESIA AND SURGERY; EACH ADDITIONAL NINE PERCENT TOTAL BODY SURFACE AREA OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1533, N'0221T', N'PLACEMENT OF POSTERIOR INTRAFACET IMPLANT(S), UNILATERAL OR BILATERAL, INCLUDING IMAGING AND PLACEMENT OF BONE GRAFT(S) OR SYNTHETIC DEVICE(S), SINGLE LEVEL; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1534, N'01963', N'ANESTHESIA FOR; CESAREAN HYSTERECTOMY WITHOUT ANY LABOR ANALGESIA/ANESTHESIA CARE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1535, N'01965', N'ANESTHESIA FOR INCOMPLETE OR MISSED ABORTION PROCEDURES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1536, N'0230T', N'INJECTION(S), ANESTHETIC AGENT AND/OR STEROID, TRANSFORAMINAL EPIDURAL, WITH ULTRASOUND GUIDANCE, LUMBAR OR SACRAL; SINGLE LEVEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1537, N'0233T', N'SKIN ADVANCED GLYCATION ENDPRODUCTS (AGE) MEASUREMENT BY MULTI-WAVELENGTH FLUORESCENT SPECTROSCOPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1538, N'0227T', N'ANOSCOPY, HIGH RESOLUTION (HRA) (WITH MAGNIFICATION AND CHEMICAL AGENT ENHANCEMENT); WITH BIOPSY(IES)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1539, N'0231T', N'INJECTION(S), ANESTHETIC AGENT AND/OR STEROID, TRANSFORAMINAL EPIDURAL, WITH ULTRASOUND GUIDANCE, LUMBAR OR SACRAL; EACH ADDITIONAL LEVEL (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1540, N'0198T', N'MEASUREMENT OF OCULAR BLOOD FLOW BY REPETITIVE INTRAOCULAR PRESSURE SAMPLING, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1541, N'01995', N'REGIONAL INTRAVENOUS ADMINISTRATION OF LOCAL ANESTHETIC AGENT OR OTHER MEDICATION (UPPER OR LOWER EXTREMITY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1542, N'0235T', N'TRANSLUMINAL PERIPHERAL ATHERECTOMY, OPEN OR PERCUTANEOUS, INCLUDING RADIOLOGICAL SUPERVISION AND INTERPRETATION; VISCERAL ARTERY (EXCEPT RENAL), EACH VESSEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1543, N'0243T', N'INTERMITTENT MEASUREMENT OF WHEEZE RATE FOR BRONCHODILATOR OR BRONCHIAL-CHALLENGE DIAGNOSTIC EVALUATION(S), WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1544, N'0236T', N'TRANSLUMINAL PERIPHERAL ATHERECTOMY, OPEN OR PERCUTANEOUS, INCLUDING RADIOLOGICAL SUPERVISION AND INTERPRETATION; ABDOMINAL AORTA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1545, N'0241T', N'ESOPHAGEAL MOTILITY (MANOMETRIC STUDY OF THE ESOPHAGUS AND/OR GASTROESOPHAGEAL JUNCTION) STUDY WITH INTERPRETATION AND REPORT; WITH STIMULATION OR PERFUSION DURING 3-DIMENSIONAL HIGH RESOLUTION ESOPHAGEAL TOPOGRAPHY STUDY (EG, STIMULANT, ACID OR ALKALI PERFUSION) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1546, N'0247T', N'OPEN TREATMENT OF RIB FRACTURE REQUIRING INTERNAL FIXATION, UNILATERAL (EG, FLAIL CHEST); 5-6 RIBS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1547, N'0250T', N'AIRWAY SIZING AND INSERTION OF BRONCHIAL VALVE(S), EACH LOBE (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1548, N'0251T', N'BRONCHOSCOPY, RIGID OR FLEXIBLE, INCLUDING FLUOROSCOPIC GUIDANCE, WHEN PERFORMED; WITH REMOVAL OF BRONCHIAL VALVE(S), INITIAL LOBE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1549, N'0258T', N'TRANSTHORACIC CARDIAC EXPOSURE (EG, STERNOTOMY, THORACOTOMY, SUBXIPHOID) FOR CATHETER-DELIVERED AORTIC VALVE REPLACEMENT; WITHOUT CARDIOPULMONARY BYPASS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1550, N'0263T', N'INTRAMUSCULAR AUTOLOGOUS BONE MARROW CELL THERAPY, WITH PREPARATION OF HARVESTED CELLS, MULTIPLE INJECTIONS, ONE LEG, INCLUDING ULTRASOUND GUIDANCE, IF PERFORMED; COMPLETE PROCEDURE INCLUDING UNILATERAL OR BILATERAL BONE MARROW HARVEST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1551, N'0204T', N'SLEEP STUDY, UNATTENDED, SIMULTANEOUS RECORDING; MINIMUM OF HEART RATE, OXYGEN SATURATION, AND RESPIRATORY ANALYSIS (EG, BY AIR FLOW OR PERIPHERAL ARTERIAL TONE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1552, N'0242T', N'GASTROINTESTINAL TRACT TRANSIT AND PRESSURE MEASUREMENT, STOMACH THROUGH COLON, WIRELESS CAPSULE, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1553, N'0246T', N'OPEN TREATMENT OF RIB FRACTURE REQUIRING INTERNAL FIXATION, UNILATERAL (EG, FLAIL CHEST); 3-4 RIBS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1554, N'0209T', N'PURE TONE AUDIOMETRY (THRESHOLD), AUTOMATED; AIR AND BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1555, N'0224T', N'ACOUSTIC CARDIOGRAPHY, INCLUDING AUTOMATED ANALYSIS OF COMBINED ACOUSTIC AND ELECTRICAL INTERVALS; MULTIPLE, INCLUDING SERIAL TRENDED ANALYSIS AND LIMITED REPROGRAMMING OF DEVICE PARAMETER, AV OR VV DELAYS ONLY, WITH INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1556, N'0246T', N'OPEN TREATMENT OF RIB FRACTURE REQUIRING INTERNAL FIXATION, UNILATERAL; 3-4 RIBS FLAIL CHEST); 3-4 RIBS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1557, N'0247T', N'OPEN TREATMENT OF RIB FRACTURE REQUIRING INTERNAL FIXATION, UNILATERAL; 5-6 RIBS FLAIL CHEST); 5-6 RIBS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1558, N'0248T', N'OPEN TREATMENT OF RIB FRACTURE REQUIRING INTERNAL FIXATION, UNILATERAL; 7 OR MORE RIBS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1559, N'0252T', N'BRONCHOSCOPY, RIGID OR FLEXIBLE, INCLUDING FLUOROSCOPIC GUIDANCE, WHEN PERFORMED; WITH REMOVAL OF BRONCHIAL VALVE(S), EACH ADDITIONAL LOBE (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1560, N'0226T', N'ANOSCOPY, HIGH RESOLUTION (HRA) (WITH MAGNIFICATION AND CHEMICAL AGENT ENHANCEMENT); DIAGNOSTIC, INCLUDING COLLECTION OF SPECIMEN(S) BY BRUSHING OR WASHING WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1561, N'0266T', N'IMPLANTATION OR REPLACEMENT OF CAROTID SINUS BAROREFLEX ACTIVATION DEVICE; TOTAL SYSTEM (INCLUDES GENERATOR PLACEMENT, UNILATERAL OR BILATERAL LEAD PLACEMENT, INTRA-OPERATIVE INTERROGATION, PROGRAMMING, AND REPOSITIONING, WHEN PERFORMED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1562, N'0261T', N'SELECTIVE HEAD HYPOTHERMIA, PER DAY, IN THE NEONATE 28 DAYS OR YOUNGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1563, N'0269T', N'REVISION OR REMOVAL OF CAROTID SINUS BAROREFLEX ACTIVATION DEVICE; TOTAL SYSTEM (INCLUDES GENERATOR PLACEMENT, UNILATERAL OR BILATERAL LEAD PLACEMENT, INTRA-OPERATIVE INTERROGATION, PROGRAMMING, AND REPOSITIONING, WHEN PERFORMED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1564, N'0234T', N'TRANSLUMINAL PERIPHERAL ATHERECTOMY, OPEN OR PERCUTANEOUS, INCLUDING RADIOLOGICAL SUPERVISION AND INTERPRETATION; RENAL ARTERY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1565, N'0238T', N'TRANSLUMINAL PERIPHERAL ATHERECTOMY, OPEN OR PERCUTANEOUS, INCLUDING RADIOLOGICAL SUPERVISION AND INTERPRETATION; ILIAC ARTERY, EACH VESSEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1566, N'0259T', N'TRANSTHORACIC CARDIAC EXPOSURE (EG, STERNOTOMY, THORACOTOMY, SUBXIPHOID) FOR CATHETER-DELIVERED AORTIC VALVE REPLACEMENT; WITH CARDIOPULMONARY BYPASS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1567, N'0240T', N'ESOPHAGEAL MOTILITY (MANOMETRIC STUDY OF THE ESOPHAGUS AND/OR GASTROESOPHAGEAL JUNCTION) STUDY WITH INTERPRETATION AND REPORT; WITH HIGH RESOLUTION ESOPHAGEAL PRESSURE TOPOGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1568, N'0272T', N'INTERROGATION DEVICE EVALUATION (IN PERSON), CAROTID SINUS BAROREFLEX ACTIVATION SYSTEM, INCLUDING TELEMETRIC ITERATIVE COMMUNICATION WITH THE IMPLANTABLE DEVICE TO MONITOR DEVICE DIAGNOSTICS AND PROGRAMMED THERAPY VALUES, WITH INTERPRETATION AND REPORT (EG, BATTERY STATUS, LEAD IMPEDANCE, PULSE AMPLITUDE, PULSE WIDTH, THERAPY FREQUENCY, PATHWAY MODE, BURST MODE, THERAPY START/STOP TIMES EACH DAY);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1569, N'0278T', N'TRANSCUTANEOUS ELECTRICAL MODULATION PAIN REPROCESSING (EG, SCRAMBLER THERAPY), EACH TREATMENT SESSION (INCLUDES PLACEMENT OF ELECTRODES)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1570, N'0245T', N'OPEN TREATMENT OF RIB FRACTURE REQUIRING INTERNAL FIXATION, UNILATERAL; 1-2 RIBS FLAIL CHEST); 1-2 RIBS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1571, N'0249T', N'LIGATION, HEMORRHOIDAL VASCULAR BUNDLE(S), INCLUDING ULTRASOUND GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1572, N'0253T', N'INSERTION OF ANTERIOR SEGMENT AQUEOUS DRAINAGE DEVICE, WITHOUT EXTRAOCULAR RESERVOIR; INTERNAL APPROACH, INTO THE SUPRACHOROIDAL SPACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1573, N'0254T', N'ENDOVASCULAR REPAIR OF ILIAC ARTERY BIFURCATION (EG, ANEURYSM, PSEUDOANEURYSM, ARTERIOVENOUS MALFORMATION, TRAUMA) USING BIFURCATED ENDOPROSTHESIS FROM THE COMMON ILIAC ARTERY INTO BOTH THE EXTERNAL AND INTERNAL ILIAC ARTERY, UNILATERAL;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1574, N'0284T', N'REVISION OR REMOVAL OF PULSE GENERATOR OR ELECTRODES, INCLUDING IMAGING GUIDANCE, WHEN PERFORMED, INCLUDING ADDITION OF NEW ELECTRODES, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1575, N'0255T', N'ENDOVASCULAR REPAIR OF ILIAC ARTERY BIFURCATION (EG, ANEURYSM, PSEUDOANEURYSM, ARTERIOVENOUS MALFORMATION, TRAUMA) USING BIFURCATED ENDOPROSTHESIS FROM THE COMMON ILIAC ARTERY INTO BOTH THE EXTERNAL AND INTERNAL ILIAC ARTERY, UNILATERAL; RADIOLOGICAL SUPERVISION AND INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1576, N'0260T', N'TOTAL BODY SYSTEMIC HYPOTHERMIA, PER DAY, IN THE NEONATE 28 DAYS OF AGE OR YOUNGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1577, N'0264T', N'INTRAMUSCULAR AUTOLOGOUS BONE MARROW CELL THERAPY, WITH PREPARATION OF HARVESTED CELLS, MULTIPLE INJECTIONS, ONE LEG, INCLUDING ULTRASOUND GUIDANCE, IF PERFORMED; COMPLETE PROCEDURE EXCLUDING BONE MARROW HARVEST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1578, N'0270T', N'REVISION OR REMOVAL OF CAROTID SINUS BAROREFLEX ACTIVATION DEVICE; LEAD ONLY, UNILATERAL (INCLUDES INTRA-OPERATIVE INTERROGATION, PROGRAMMING, AND REPOSITIONING, WHEN PERFORMED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1579, N'0268T', N'IMPLANTATION OR REPLACEMENT OF CAROTID SINUS BAROREFLEX ACTIVATION DEVICE; PULSE GENERATOR ONLY (INCLUDES INTRA-OPERATIVE INTERROGATION, PROGRAMMING, AND REPOSITIONING, WHEN PERFORMED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1580, N'0271T', N'REVISION OR REMOVAL OF CAROTID SINUS BAROREFLEX ACTIVATION DEVICE; PULSE GENERATOR ONLY (INCLUDES INTRA-OPERATIVE INTERROGATION, PROGRAMMING, AND REPOSITIONING, WHEN PERFORMED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1581, N'0282T', N'PERCUTANEOUS OR OPEN IMPLANTATION OF NEUROSTIMULATOR ELECTRODE ARRAY(S), SUBCUTANEOUS (PERIPHERAL SUBCUTANEOUS FIELD STIMULATION), INCLUDING IMAGING GUIDANCE, WHEN PERFORMED, CERVICAL, THORACIC OR LUMBAR; FOR TRIAL, INCLUDING REMOVAL AT THE CONCLUSION OF TRIAL PERIOD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1582, N'0273T', N'INTERROGATION DEVICE EVALUATION (IN PERSON), CAROTID SINUS BAROREFLEX ACTIVATION SYSTEM, INCLUDING TELEMETRIC ITERATIVE COMMUNICATION WITH THE IMPLANTABLE DEVICE TO MONITOR DEVICE DIAGNOSTICS AND PROGRAMMED THERAPY VALUES, WITH INTERPRETATION AND REPORT (EG, BATTERY STATUS, LEAD IMPEDANCE, PULSE AMPLITUDE, PULSE WIDTH, THERAPY FREQUENCY, PATHWAY MODE, BURST MODE, THERAPY START/STOP TIMES EACH DAY); WITH PROGRAMMING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1583, N'0283T', N'PERCUTANEOUS OR OPEN IMPLANTATION OF NEUROSTIMULATOR ELECTRODE ARRAY(S), SUBCUTANEOUS (PERIPHERAL SUBCUTANEOUS FIELD STIMULATION), INCLUDING IMAGING GUIDANCE, WHEN PERFORMED, CERVICAL, THORACIC OR LUMBAR; PERMANENT, WITH IMPLANTATION OF A PULSE GENERATOR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1584, N'0274T', N'PERCUTANEOUS LAMINOTOMY/LAMINECTOMY (INTERLAMINAR APPROACH) FOR DECOMPRESSION OF NEURAL ELEMENTS, (WITH OR WITHOUT LIGAMENTOUS RESECTION, DISCECTOMY, FACETECTOMY AND/OR FORAMINOTOMY), ANY METHOD, UNDER INDIRECT IMAGE GUIDANCE (EG, FLUOROSCOPIC, CT), WITH OR WITHOUT THE USE OF AN ENDOSCOPE, SINGLE OR MULTIPLE LEVELS, UNILATERAL OR BILATERAL; CERVICAL OR THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1585, N'0292T', N'INTRAVASCULAR OPTICAL COHERENCE TOMOGRAPHY (CORONARY NATIVE VESSEL OR GRAFT) DURING DIAGNOSTIC EVALUATION AND/OR THERAPEUTIC INTERVENTION, INCLUDING IMAGING SUPERVISION, INTERPRETATION, AND REPORT; EACH ADDITIONAL VESSEL (LIST SEPARATELY IN ADDITION TO PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1586, N'0275T', N'PERCUTANEOUS LAMINOTOMY/LAMINECTOMY (INTRALAMINAR APPROACH) FOR DECOMPRESSION OF NEURAL ELEMENTS, (WITH OR WITHOUT LIGAMENTOUS RESECTION, DISCECTOMY, FACETECTOMY AND/OR FORAMINOTOMY) ANY METHOD UNDER INDIRECT IMAGE GUIDANCE (EG, FLUOROSCOPIC, CT), WITH OR WITHOUT THE USE OF AN ENDOSCOPE, SINGLE OR MULTIPLE LEVELS, UNILATERAL OR BILATERAL; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1587, N'0293T', N'INSERTION OF LEFT ATRIAL HEMODYNAMIC MONITOR; COMPLETE SYSTEM, INCLUDES IMPLANTED COMMUNICATION MODULE AND PRESSURE SENSOR LEAD IN LEFT ATRIUM INCLUDING TRANSSEPTAL ACCESS, RADIOLOGICAL SUPERVISION AND INTERPRETATION, AND ASSOCIATED INJECTION PROCEDURES, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1588, N'0276T', N'BRONCHOSCOPY, RIGID OR FLEXIBLE, INCLUDING FLUOROSCOPIC GUIDANCE, WHEN PERFORMED; WITH BRONCHIAL THERMOPLASTY, 1 LOBE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1589, N'0279T', N'CELL ENUMERATION USING IMMUNOLOGIC SELECTION AND IDENTIFICATION IN FLUID SPECIMEN (EG, CIRCULATING TUMOR CELLS IN BLOOD);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1590, N'0281T', N'PERCUTANEOUS TRANSCATHETER CLOSURE OF THE LEFT ATRIAL APPENDAGE WITH IMPLANT, INCLUDING FLUOROSCOPY, TRANSSEPTAL PUNCTURE, CATHETER PLACEMENT(S), LEFT ATRIAL ANGIOGRAPHY, LEFT ATRIAL APPENDAGE ANGIOGRAPHY, RADIOLOGICAL SUPERVISION AND INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1591, N'0297T', N'EXTERNAL ELECTROCARDIOGRAPHIC RECORDING FOR MORE THAN 48 HOURS UP TO 21 DAYS BY CONTINUOUS RHYTHM RECORDING AND STORAGE; SCANNING ANALYSIS WITH REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1592, N'0285T', N'ELECTRONIC ANALYSIS OF IMPLANTED PERIPHERAL SUBCUTANEOUS FIELD STIMULATION PULSE GENERATOR, WITH REPROGRAMMING WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1593, N'0289T', N'CORNEAL INCISIONS IN THE DONOR CORNEA CREATED USING A LASER, IN PREPARATION FOR PENETRATING OR LAMELLAR KERATOPLASTY (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1594, N'0286T', N'NEAR-INFRARED SPECTROSCOPY STUDIES OF LOWER EXTREMITY WOUNDS (EG, FOR OXYHEMOGLOBIN MEASUREMENT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1595, N'0288T', N'ANOSCOPY, WITH DELIVERY OF THERMAL ENERGY TO THE MUSCLE OF THE ANAL CANAL (EG, FOR FECAL INCONTINENCE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1596, N'0303T', N'INSERTION OR REMOVAL AND REPLACEMENT OF INTRACARDIAC ISCHEMIA MONITORING SYSTEM INCLUDING IMAGING SUPERVISION AND INTERPRETATION WHEN PERFORMED AND INTRA-OPERATIVE INTERROGATION AND PROGRAMMING WHEN PERFORMED; ELECTRODE ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1597, N'0290T', N'CORNEAL INCISIONS IN THE RECIPIENT CORNEA CREATED USING A LASER, IN PREPARATION FOR PENETRATING OR LAMELLAR KERATOPLASTY (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1598, N'0299T', N'EXTRACORPOREAL SHOCK WAVE FOR INTEGUMENTARY WOUND HEALING, HIGH ENERGY, INCLUDING TOPICAL APPLICATION AND DRESSING CARE; INITIAL WOUND', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1599, N'0291T', N'INTRAVASCULAR OPTICAL COHERENCE TOMOGRAPHY (CORONARY NATIVE VESSEL OR GRAFT) DURING DIAGNOSTIC EVALUATION AND/OR THERAPEUTIC INTERVENTION, INCLUDING IMAGING SUPERVISION, INTERPRETATION, AND REPORT; INITIAL VESSEL (LIST SEPARATELY IN ADDITION TO PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1600, N'0302T', N'INSERTION OR REMOVAL AND REPLACEMENT OF INTRACARDIAC ISCHEMIA MONITORING SYSTEM INCLUDING IMAGING SUPERVISION AND INTERPRETATION WHEN PERFORMED AND INTRA-OPERATIVE INTERROGATION AND PROGRAMMING WHEN PERFORMED; COMPLETE SYSTEM (INCLUDES DEVICE AND ELECTRODE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1601, N'0308T', N'INSERTION OF OCULAR TELESCOPE PROSTHESIS INCLUDING REMOVAL OF CRYSTALLINE LENS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1602, N'0503F', N'POSTPARTUM CARE VISIT2', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1603, N'0256T', N'IMPLANTATION OF CATHETER-DELIVERED PROSTHETIC AORTIC HEART VALVE; ENDOVASCULAR APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1604, N'0257T', N'IMPLANTATION OF CATHETER-DELIVERED PROSTHETIC AORTIC HEART VALVE; OPEN THORACIC APPROACH (EG, TRANSAPICAL, TRANSVENTRICULAR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1605, N'0262T', N'IMPLANTATION OF CATHETER-DELIVERED PROSTHETIC PULMONARY VALVE, ENDOVASCULAR APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 600 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1606, N'0265T', N'INTRAMUSCULAR AUTOLOGOUS BONE MARROW CELL THERAPY, WITH PREPARATION OF HARVESTED CELLS, MULTIPLE INJECTIONS, ONE LEG, INCLUDING ULTRASOUND GUIDANCE, IF PERFORMED; UNILATERAL OR BILATERAL BONE MARROW HARVEST ONLY FOR INTRAMUSCULAR AUTOLOGOUS BONE MARROW CELL THERAPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1607, N'0505F', N'HEMODIALYSIS PLAN OF CARE DOCUMENTED (ESRD, P-ESRD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1608, N'0513F', N'ELEVATED BLOOD PRESSURE PLAN OF CARE DOCUMENTED (CKD)1', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1609, N'0516F', N'ANEMIA PLAN OF CARE DOCUMENTED (ESRD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1610, N'0294T', N'INSERTION OF LEFT ATRIAL HEMODYNAMIC MONITOR; PRESSURE SENSOR LEAD AT TIME OF INSERTION OF PACING CARDIOVERTER-DEFIBRILLATOR PULSE GENERATOR INCLUDING RADIOLOGICAL SUPERVISION AND INTERPRETATION AND ASSOCIATED INJECTION PROCEDURES, WHEN PERFORMED (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1611, N'0267T', N'IMPLANTATION OR REPLACEMENT OF CAROTID SINUS BAROREFLEX ACTIVATION DEVICE; LEAD ONLY, UNILATERAL (INCLUDES INTRA-OPERATIVE INTERROGATION, PROGRAMMING, AND REPOSITIONING, WHEN PERFORMED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1612, N'0295T', N'EXTERNAL ELECTROCARDIOGRAPHIC RECORDING FOR MORE THAN 48 HOURS UP TO 21 DAYS BY CONTINUOUS RHYTHM RECORDING AND STORAGE; INCLUDES RECORDING, SCANNING ANALYSIS WITH REPORT, REVIEW AND INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1613, N'0304T', N'INSERTION OR REMOVAL AND REPLACEMENT OF INTRACARDIAC ISCHEMIA MONITORING SYSTEM INCLUDING IMAGING SUPERVISION AND INTERPRETATION WHEN PERFORMED AND INTRA-OPERATIVE INTERROGATION AND PROGRAMMING WHEN PERFORMED; DEVICE ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1614, N'0274T', N'PERCUTANEOUS LAMINOTOMY/LAMINECTOMY (INTRALAMINAR APPROACH) FOR DECOMPRESSION OF NEURAL ELEMENTS, (WITH OR WITHOUT LIGAMENTOUS RESECTION, DISCECTOMY, FACETECTOMY AND/OR FORAMINOTOMY) ANY METHOD UNDER INDIRECT IMAGE GUIDANCE (EG, FLUOROSCOPIC, CT), WITH OR WITHOUT THE USE OF AN ENDOSCOPE, SINGLE OR MULTIPLE LEVELS, UNILATERAL OR BILATERAL; CERVICAL OR THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1615, N'0275T', N'PERCUTANEOUS LAMINOTOMY/LAMINECTOMY (INTERLAMINAR APPROACH) FOR DECOMPRESSION OF NEURAL ELEMENTS, (WITH OR WITHOUT LIGAMENTOUS RESECTION, DISCECTOMY, FACETECTOMY AND/OR FORAMINOTOMY), ANY METHOD, UNDER INDIRECT IMAGE GUIDANCE (EG, FLUOROSCOPIC, CT), WITH OR WITHOUT THE USE OF AN ENDOSCOPE, SINGLE OR MULTIPLE LEVELS, UNILATERAL OR BILATERAL; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1616, N'0296T', N'EXTERNAL ELECTROCARDIOGRAPHIC RECORDING FOR MORE THAN 48 HOURS UP TO 21 DAYS BY CONTINUOUS RHYTHM RECORDING AND STORAGE; RECORDING (INCLUDES CONNECTION AND INITIAL RECORDING)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1617, N'0277T', N'BRONCHOSCOPY, RIGID OR FLEXIBLE, INCLUDING FLUOROSCOPIC GUIDANCE, WHEN PERFORMED; WITH BRONCHIAL THERMOPLASTY, 2 OR MORE LOBES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1618, N'0280T', N'CELL ENUMERATION USING IMMUNOLOGIC SELECTION AND IDENTIFICATION IN FLUID SPECIMEN (EG, CIRCULATING TUMOR CELLS IN BLOOD); INTERPRETATION AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1619, N'0300T', N'EXTRACORPOREAL SHOCK WAVE FOR INTEGUMENTARY WOUND HEALING, HIGH ENERGY, INCLUDING TOPICAL APPLICATION AND DRESSING CARE; EACH ADDITIONAL WOUND (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1620, N'0287T', N'NEAR-INFRARED GUIDANCE FOR VASCULAR ACCESS REQUIRING REAL-TIME DIGITAL VISUALIZATION OF SUBCUTANEOUS VASCULATURE FOR EVALUATION OF POTENTIAL ACCESS SITES AND VESSEL PATENCY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1621, N'0298T', N'EXTERNAL ELECTROCARDIOGRAPHIC RECORDING FOR MORE THAN 48 HOURS UP TO 21 DAYS BY CONTINUOUS RHYTHM RECORDING AND STORAGE; REVIEW AND INTERPRETATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1622, N'0301T', N'DESTRUCTION/REDUCTION OF MALIGNANT BREAST TUMOR WITH EXTERNALLY APPLIED FOCUSED MICROWAVE, INCLUDING INTERSTITIAL PLACEMENT OF DISPOSABLE CATHETER WITH COMBINED TEMPERATURE MONITORING PROBE AND MICROWAVE FOCUSING SENSOCATHETER UNDER ULTRASOUND THERMOTHERAPY GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1623, N'0509F', N'URINARY INCONTINENCE PLAN OF CARE DOCUMENTED (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1624, N'0519F', N'PLANNED CHEMOTHERAPY REGIMEN, INCLUDING AT A MINIMUM: DRUG(S) PRESCRIBED, DOSE, AND DURATION, DOCUMENTED PRIOR TO INITIATION OF A NEW TREATMENT REGIMEN (ONC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1625, N'0306T', N'INTERROGATION DEVICE EVALUATION (IN PERSON) OF INTRACARDIAC ISCHEMIA MONITORING SYSTEM WITH ANALYSIS, REVIEW, AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1626, N'0307T', N'REMOVAL OF INTRACARDIAC ISCHEMIA MONITORING DEVICE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1627, N'0517F', N'GLAUCOMA PLAN OF CARE DOCUMENTED (EC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1628, N'0521F', N'PLAN OF CARE TO ADDRESS PAIN DOCUMENTED (COA) (ONC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1629, N'0540F', N'GLUCORTICOID MANAGEMENT PLAN DOCUMENTED (RA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1630, N'0502F', N'SUBSEQUENT PRENATAL CARE VISIT                                           [EXCLUDES:  PATIENTS WHO ARE SEEN FOR A CONDITION UNRELATED TO PREGNANCY OR PRENATAL CARE (EG, AN UPPER RESPIRATORY INFECTION; PATIENTS SEEN FOR  CONSULTATION ONLY, NOT FOR CONTINUING CARE)]', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1631, N'0528F', N'RECOMMENDED FOLLOW-UP INTERVAL FOR REPEAT COLONOSCOPY OF AT LEAST 10 YEARS DOCUMENTED IN COLONOSCOPY REPORT (END/POLYP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1632, N'0535F', N'DYSPNEA MANAGEMENT PLAN OF CARE, DOCUMENTED (PALL CR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1633, N'10000', N'INCISION AND DRAINAGE OF INFECTED OR NONINFECTED SEBACEOUS CYST; ONE LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1634, N'1001F', N'TOBACCO USE, NON-SMOKING, ASSESSED1', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1635, N'0507F', N'PERITONEAL DIALYSIS PLAN OF CARE DOCUMENTED (ESRD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1636, N'0518F', N'FALLS PLAN OF CARE DOCUMENTED (GER)5', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1637, N'0525F', N'INITIAL VISIT FOR EPISODE (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1638, N'0545F', N'PLAN FOR FOLLOW-UP CARE FOR MAJOR DEPRESSIVE DISORDER, DOCUMENTED (MDD ADOL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1639, N'0575F', N'HIV RNA CONTROL PLAN OF CARE, DOCUMENTED (HIV)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1640, N'10020', N'INCISION AND DRAINAGE OF FURUNCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1641, N'1007F', N'USE OF ANTI-INFLAMMATORY OR ANALGESIC OVER-THE-COUNTER (OTC) MEDICATIONS FOR SYMPTOM RELIEF ASSESSED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1642, N'1002F', N'ANGINAL SYMPTOMS AND LEVEL OF ACTIVITY, ASSESSED1', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1643, N'1003F', N'LEVEL OF ACTIVITY ASSESSED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1644, N'1011F', N'ANGINA PRESENT (CAD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1645, N'10080', N'INCISION AND DRAINAGE OF PILONIDAL CYST; SIMPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1646, N'10101', N'INCISION AND DRAINAGE OF ONYCHIA OR PARONYCHIA; MULTIPLE OR COMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1647, N'0305T', N'PROGRAMMING DEVICE EVALUATION (IN PERSON) OF INTRACARDIAC ISCHEMIA MONITORING SYSTEM WITH ITERATIVE ADJUSTMENT OF PROGRAMMED VALUES, WITH ANALYSIS, REVIEW, AND REPORT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1648, N'10140', N'INCISION AND DRAINAGE OF HEMATOMA, SEROMA OR FLUID COLLECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1649, N'10180', N'INCISION AND DRAINAGE, COMPLEX, POSTOPERATIVE WOUND INFECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1650, N'0500F', N'INITIAL PRENATAL CARE VISIT (REPORT AT FIRST PRENATAL ENCOUNTER WITH     HEALTH CARE PROFESSIONAL PROVIDING OBSTETRICAL CARE. REPORT ALSO DATE    OF VISIT AND, IN A SEPARATE FIELD, THE DATE OF THE LAST MENSTRUAL        PERIOD - LMP)2', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1651, N'0501F', N'PRENATAL FLOW SHEET DOCUMENTED IN MEDICAL RECORD BY FIRST PRENATAL VISIT (DOCUMENTATION INCLUDES AT MINIMUM BLOOD PRESSURE, WEIGHT, URINE         PROTEIN, UTERINE SIZE, FETAL HEART TONES, AND ESTIMATED DATE OF          DELIVERY).  REPORT ALSO:  DATE OF VISIT AND, IN A SEPARATE FIELD, THE    DATE OF THE LAST MENSTRUAL PERIOD - LMP (NOTE:  IF REPORTING 0501F       PRENATAL FLOW SHEET, IT IS NOT NECESSARY TO REPORT 0500F INITIAL         PRENATAL CARE VISIT)1', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1652, N'1018F', N'DYSPNEA ASSESSED, NOT PRESENT (COPD1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1653, N'1030F', N'INFLUENZA IMMUNIZATION STATUS ASSESSED (CAP1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1654, N'1032F', N'CURRENT TOBACCO SMOKER OR CURRENTLY EXPOSED TO SECONDHAND SMOKE (ASTHMA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1655, N'0514F', N'PLAN OF CARE FOR ELEVATED HEMOGLOBIN LEVEL DOCUMENTED FOR PATIENT RECEIVING ERYTHROPOIESIS-STIMULATING AGENT THERAPY (ESA) (CKD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1656, N'0520F', N'RADIATION DOSE LIMITS TO NORMAL TISSUES ESTABLISHED PRIOR TO THE INITIATION OF A COURSE OF 3D CONFORMAL RADIATION FOR A MINIMUM OF 2 TISSUE/ORGAN (ONC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1657, N'1055F', N'VISUAL FUNCTIONAL STATUS ASSESSED (EC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1658, N'1066F', N'ISCHEMIC STROKE SYMPTOM ONSET GREATER THAN OR EQUAL TO 3 HOURS PRIOR TO ARRIVAL (STR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1659, N'11004', N'DEBRIDEMENT OF SKIN, SUBCUTANEOUS TISSUE, MUSCLE AND FASCIA FOR          NECROTIZING SOFT TISSUE INFECTION; EXTERNAL GENITALIA AND PERINEUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1660, N'0550F', N'CYTOPATHOLOGY REPORT ON ROUTINE NONGYNECOLOGIC SPECIMEN FINALIZED WITHIN TWO WORKING DAYS OF ACCESSION DATE (PATH)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1661, N'0551F', N'CYTOPATHOLOGY REPORT ON NONGYNECOLOGIC SPECIMEN WITH DOCUMENTATION THAT THE SPECIMEN WAS NON-ROUTINE (PATH)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1662, N'11005', N'NECROTIZING SOFT TISSUE INFECTION; ABDOMINAL WALL, WITH OR WITHOUT       FASCIAL CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1663, N'11010', N'DEBRIDEMENT INCLUDING REMOVAL OF FOREIGN MATERIAL AT THE SITE OF AN OPEN FRACTURE AND/OR AN OPEN DISLOCATION (EG, EXCISIONAL DEBRIDEMENT); SKIN AND SUBCUTANEOUS TISSUES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1664, N'0555F', N'SYMPTOM MANAGEMENT PLAN OF CARE DOCUMENTED (HF)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1665, N'0557F', N'PLAN OF CARE TO MANAGE ANGINAL SYMPTOMS DOCUMENTED (CAD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1666, N'10003', N'INCISION AND DRAINAGE OF INFECTED OR NONINFECTED EPITHELIAL INCLUSION CYST (''''SEBACEOUS CYST'''') WITH COMPLETE REMOVAL OF SAC AND TREATMENT OF CAVITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1667, N'11040', N'DEBRIDEMENT; SKIN, PARTIAL THICKNESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1668, N'11045', N'DEBRIDEMENT, SUBCUTANEOUS TISSUE (INCLUDES EPIDERMIS AND DERMIS, IF PERFORMED); EACH ADDITIONAL 20 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1669, N'11046', N'DEBRIDEMENT, MUSCLE AND/OR FASCIA (INCLUDES EPIDERMIS, DERMIS, AND SUBCUTANEOUS TISSUE, IF PERFORMED); EACH ADDITIONAL 20 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1670, N'10021', N'FINE NEEDLE ASPIRATION; WITHOUT IMAGING GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1671, N'10022', N'FINE NEEDLE ASPIRATION; WITH IMAGING GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1672, N'1004F', N'CLINICAL SYMPTOMS OF VOLUME OVERLOAD (EXCESS) ASSESSED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1673, N'11050', N'PARING OR CURETTEMENT OF BENIGN HYPERKERATOTIC SKIN LESION WITH OR WITHOUT CHEMICAL CAUTERIZATION (SUCH AS VERRUCAE OR CLAVI) NOT EXTENDING THROUGH THE STRATUM CORNEUM (EG, CALLUS OR WART) WITH OR WITHOUT LOCAL ANESTHESIA; SINGLE LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1674, N'1019F', N'DYSPNEA ASSESSED, PRESENT (COPD1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1675, N'1026F', N'CO-MORBID CONDITIONS ASSESSED (EG, INCLUDES ASSESSMENT FOR PRESENCE OR ABSENCE OF:  MALIGNANCY, LIVER DISEASE, CONGESTIVE HEART FAILURE, CEREBROVASCULAR DISEASE, RENAL DISEASE, CHRONIC OBSTRUCTIVE PULMONARY DISEASE, ASTHMA, DIABETES, OTHER CO-MORBID CONDITIONS) (CAP1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1676, N'0526F', N'SUBSEQUENT VISIT FOR EPISODE (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1677, N'0529F', N'INTERVAL OF 3 OR MORE YEARS SINCE PATIENT''S LAST COLONOSCOPY, DOCUMENTED (END/POLYP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1678, N'10060', N'INCISION AND DRAINAGE OF ABSCESS (EG, CARBUNCLE, SUPPURATIVE HIDRADENITIS, CUTANEOUS OR SUBCUTANEOUS ABSCESS, CYST, FURUNCLE, OR PARONYCHIA); SIMPLE OR SINGLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1679, N'11051', N'PARING OR CURETTEMENT OF BENIGN HYPERKERATOTIC SKIN LESION WITH OR WITHOUT CHEMICAL CAUTERIZATION (SUCH AS VERRUCAE OR CLAVI) NOT EXTENDING THROUGH THE STRATUM CORNEUM (EG, CALLUS OR WART) WITH OR WITHOUT LOCAL ANESTHESIA; TWO TO FOUR LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1680, N'0556F', N'PLAN OF CARE TO ACHIEVE LIPID CONTROL DOCUMENTED (CAD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1681, N'10001', N'INCISION AND DRAINAGE OF INFECTED OR NONINFECTED SEBACEOUS CYST; SECOND LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1682, N'10061', N'INCISION AND DRAINAGE OF ABSCESS (EG, CARBUNCLE, SUPPURATIVE HIDRADENITIS, CUTANEOUS OR SUBCUTANEOUS ABSCESS, CYST, FURUNCLE, OR PARONYCHIA); COMPLICATED OR MULTIPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1683, N'10002', N'INCISION AND DRAINAGE OF INFECTED OR NONINFECTED SEBACEOUS CYST; MORE THAN TWO LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1684, N'1000F', N'TOBACCO USE ASSESSED (CAD, CAP, COPD, PV)1 (DM)4', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1685, N'1034F', N'CURRENT TOBACCO SMOKER (CAD1, CAP1, COPD1, DM4, PV1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1686, N'1040F', N'DSM-IV CRITERIA FOR MAJOR DEPRESSIVE DISORDER DOCUMENTED AT THE INITIAL EVALUATION (MDD, MDD ADOL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1687, N'10040', N'ACNE SURGERY (EG, MARSUPIALIZATION, OPENING OR REMOVAL OF MULTIPLE MILIA, COMEDONES, CYSTS, PUSTULES)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1688, N'1005F', N'ASTHMA SYMPTOMS EVALUATED (INCLUDES PHYSICIAN DOCUMENTATION OF NUMERIC FREQUENCY OF SYMPTOMS OR PATIENT COMPLETION OF AN ASTHMA ASSESSMENT TOOL/SURVEY/QUESTIONNAIRE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1689, N'1050F', N'HISTORY OBTAINED REGARDING NEW OR CHANGING MOLES (ML)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1690, N'1060F', N'DOCUMENTATION OF PERMANENT OR PERSISTENT OR PAROXYSMAL ATRIAL FIBRILLATION (STR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1691, N'1006F', N'OSTEOARTHRITIS SYMPTOMS AND FUNCTIONAL STATUS ASSESSED (MAY INCLUDE THE USE OF A STANDARDIZED SCALE OR THE COMPLETION OF AN ASSESSMENT QUESTIONNAIRE, SUCH AS THE SF-36, AAOS HIP &amp; KNEE QUESTIONNAIRE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1692, N'1071F', N'ALARM SYMPTOMS (INVOLUNTARY WEIGHT LOSS, DYSPHAGIA, OR GASTROINTESTINAL BLEEDING) ASSESSED; 1 OR MORE PRESENT (GERD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1693, N'1080F', N'SURROGATE DECISION MAKER OR ADVANCE CARE PLAN DOCUMENTED IN THE MEDICAL RECORD (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1694, N'1008F', N'GASTROINTESTINAL AND RENAL RISK FACTORS ASSESSED FOR PATIENTS ON PRESCRIBED OR OTC NON-STEROIDAL ANTI-INFLAMMATORY DRUG (NSAID)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1695, N'1012F', N'ANGINA ABSENT (CAD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1696, N'11000', N'DEBRIDEMENT OF EXTENSIVE ECZEMATOUS OR INFECTED SKIN; UP TO 10% OF BODY SURFACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1697, N'11001', N'DEBRIDEMENT OF EXTENSIVE ECZEMATOUS OR INFECTED SKIN; EACH ADDITIONAL 10% OF THE BODY SURFACE, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1698, N'1022F', N'PNEUMOCOCCUS IMMUNIZATION STATUS ASSESSED (CAP1, COPD1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1699, N'1035F', N'CURRENT SMOKELESS TOBACCO USER (EG, CHEW, SNUFF) (PV1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1700, N'1100F', N'PATIENT SCREENED FOR FUTURE FALL RISK; DOCUMENTATION OF 2 OR MORE FALLS IN THE PAST YEAR OR ANY FALL WITH INJURY IN THE PAST YEAR (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1701, N'1100F', N'PATIENT SCREENED FOR FUTURE FALL RISK; DOCUMENTATION OF 2 OR MORE FALLS IN THE YEAR OR ANY FALL WITH INJURY IN THE PAST YEAR (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1702, N'11012', N'DEBRIDEMENT INCLUDING REMOVAL OF FOREIGN MATERIAL AT THE SITE OF AN OPEN FRACTURE AND/OR AN OPEN DISLOCATION (EG, EXCISIONAL DEBRIDEMENT); SKIN, SUBCUTANEOUS TISSUE, MUSCLE FASCIA, MUSCLE, AND BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1703, N'1101F', N'PATIENT SCREENED FOR FALL RISK; DOCUMENTATION OF NO FALLS IN THE PAST YEAR OR YEAR OR ONLY 1 FALL WITHOUT INJURY IN THE PAST YEAR (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1704, N'11060', N'SHAVING OF EPIDERMAL OR SUPERFICIAL DERMAL LESION; SINGLE LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1705, N'11061', N'SHAVING OF EPIDERMAL OR SUPERFICIAL DERMAL LESION; TWO TO FOUR LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1706, N'1036F', N'CURRENT TOBACCO NON-USER (CAD1, CAP1, COPD1, DM4, PV1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 700 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1707, N'1039F', N'INTERMITTENT ASTHMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1708, N'1052F', N'TYPE, ANATOMIC LOCATION, AND ACTIVITY ALL ASSESSED (IBD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1709, N'11041', N'DEBRIDEMENT; SKIN, FULL THICKNESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1710, N'11042', N'DEBRIDEMENT, SUBCUTANEOUS TISSUE (INCLUDES EPIDERMIS AND DERMIS, IF PERFORMED); FIRST 20 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1711, N'10081', N'INCISION AND DRAINAGE OF PILONIDAL CYST; COMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1712, N'10100', N'INCISION AND DRAINAGE OF ONYCHIA OR PARONYCHIA; SINGLE OR SIMPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1713, N'1010F', N'SEVERITY OF ANGINA ASSESSED BY LEVEL OF ACTIVITY (CAD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1714, N'10120', N'INCISION AND REMOVAL OF FOREIGN BODY, SUBCUTANEOUS TISSUES; SIMPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1715, N'1111F', N'DISCHARGE MEDICATIONS RECONCILED WITH THE CURRENT MEDICATION LIST IN OUTPATIENT MEDICAL RECORD (COA) (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1716, N'1123F', N'ADVANCE CARE PLANNING DISCUSSED AND DOCUMENTED ADVANCE CARE PLAN OR SURROGATE DECISION MAKER DOCUMENTED IN THE MEDICAL RECORD (GER, PALL CR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1717, N'10121', N'INCISION AND REMOVAL OF FOREIGN BODY, SUBCUTANEOUS TISSUES; COMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1718, N'10141', N'INCISION AND DRAINAGE OF HEMATOMA; COMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1719, N'11043', N'DEBRIDEMENT, MUSCLE AND/OR FASCIA (INCLUDES EPIDERMIS, DERMIS, AND SUBCUTANEOUS TISSUE, IF PERFORMED); FIRST 20 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1720, N'11044', N'DEBRIDEMENT, BONE (INCLUDES EPIDERMIS, DERMIS, SUBCUTANEOUS TISSUE, MUSCLE AND/OR FASCIA, IF PERFORMED); FIRST 20 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1721, N'1061F', N'DOCUMENTATION OF ABSENCE OF PERMANENT AND PERSISTENT AND PAROXYSMAL ATRIAL FIBRILLATION (STR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1722, N'1090F', N'PRESENCE OR ABSENCE OF URINARY INCONTINENCE ASSESSED (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1723, N'11052', N'PARING OR CURETTEMENT OF BENIGN HYPERKERATOTIC SKIN LESION WITH OR WITHOUT CHEMICAL CAUTERIZATION (SUCH AS VERRUCAE OR CLAVI) NOT EXTENDING THROUGH THE STRATUM CORNEUM (EG, CALLUS OR WART) WITH OR WITHOUT LOCAL ANESTHESIA; MORE THAN FOUR LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1724, N'1015F', N'CHRONIC OBSTRUCTIVE PULMONARY DISEASE (COPD) SYMPTOMS ASSESSED (INCLUDES ASSESSMENT OF AT LEAST 1 OF THE FOLLOWING: DYSPNEA, COUGH/SPUTUM, WHEEZING), OR RESPIRATORY SYMPTOM ASSESSMENT TOOL COMPLETED (COPD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1725, N'11055', N'PARING OR CUTTING OF BENIGN HYPERKERATOTIC LESION (EG, CORN OR CALLUS); SINGLE LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1726, N'11056', N'PARING OR CUTTING OF BENIGN HYPERKERATOTIC LESION (EG, CORN OR CALLUS); TWO TO FOUR LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1727, N'10160', N'PUNCTURE ASPIRATION OF ABSCESS, HEMATOMA, BULLA, OR CYST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1728, N'1031F', N'SMOKING STATUS AND EXPOSURE TO SECOND HAND SMOKE IN THE HOME ASSESSED (ASTHMA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1729, N'1126F', N'PAIN SEVERITY QUANTIFIED; NO PAIN PRESENT (COA) (ONC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1730, N'1127F', N'NEW EPISODE FOR CONDITION (NMA-NO MEASURE ASSOCIATED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1731, N'1128F', N'SUBSEQUENT EPISODE FOR CONDITION (NMA-NO MEASURE ASSOCIATED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1732, N'1091F', N'URINARY INCONTINENCE CHARACTERIZED (EG FREQUENCY, VOLUME, TIMING, TYPE OF SYMPTOMS, HOW BOTHERSOME) (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1733, N'11011', N'DEBRIDEMENT INCLUDING REMOVAL OF FOREIGN MATERIAL AT THE SITE OF AN OPEN FRACTURE AND/OR AN OPEN DISLOCATION (EG, EXCISIONAL DEBRIDEMENT); SKIN, SUBCUTANEOUS TISSUE, MUSCLE FASCIA, AND MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1734, N'11100', N'BIOPSY OF SKIN, SUBCUTANEOUS TISSUE AND/OR MUCOUS MEMBRANE (INCLUDING SIMPLE CLOSURE), UNLESS OTHERWISE LISTED; SINGLE LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1735, N'1110F', N'PATIENT DISCHARGED FROM AN INPATIENT FACILITY (EG, HOSPITAL, SKILLED NURSING FACILITY, OR REHABILITATION FACILITY) WITHIN THE LAST 60 DAYS (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1736, N'1033F', N'CURRENT TOBACCO NON-SMOKER AND NOT CURRENTLY EXPOSED TO SECONDHAND SMOKE (ASTHMA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1737, N'1038F', N'PERSISTENT ASTHMA (MILD, MODERATE OR SEVERE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1738, N'11308', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER OVER 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1739, N'1130F', N'BACK PAIN AND FUNCTION ASSESSED, INCLUDING ALL OF THE FOLLOWING: PAIN ASSESSMENT AND FUNCTIONAL STATUS AND PATIENT HISTORY, INCLUDING NOTATION OF PRESENCE OR ABSENCE OF RED FLAGS (WARNING SIGNS) AND ASSESSMENT OF PRIOR TREATMENT AND RESPONSE, AND EMPLOYMENT STATUS (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1740, N'1101F', N'PATIENT SCREENED FOR FUTURE FALL RISK; DOCUMENTATION OF NO FALLS IN THE PAST YEAR OR ONLY 1 FALL WITHOUT INJURY IN THE PAST YEAR (GER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1741, N'11310', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1742, N'1065F', N'ISCHEMIC STROKE SYMPTOM ONSET OF LESS THAN 3 HOURS PRIOR TO ARRIVAL (STR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1743, N'1070F', N'ALARM SYMPTOMS (INVOLUNTARY WEIGHT LOSS, DYSPHAGIA, OR GASTROINTESTINAL BLEEDING) ASSESSED; NONE PRESENT (GERD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1744, N'1134F', N'EPISODE OF BACK PAIN LASTING 6 WEEKS OR LESS (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1745, N'1135F', N'EPISODE OF BACK PAIN LASTING LONGER THAN 6 WEEKS (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1746, N'1137F', N'EPISODE OF BACK PAIN LASTING LONGER THAN 12 WEEKS (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1747, N'1116F', N'AURICULAR OR PERIAURICULAR PAIN ASSESSED (AOE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1748, N'1118F', N'GERD SYMPTOMS ASSESSED AFTER 12 MONTHS OF THERAPY (GERD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1749, N'11201', N'REMOVAL OF SKIN TAGS, MULTIPLE FIBROCUTANEOUS TAGS, ANY AREA; EACH ADDITIONAL 10 LESIONS, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1750, N'1125F', N'PAIN SEVERITY QUANTIFIED; PAIN PRESENT (COA) (ONC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1751, N'11300', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, TRUNK, ARMS OR LEGS; LESION DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1752, N'11305', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1753, N'11307', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1754, N'11423', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1755, N'11006', N'DEBRIDEMENT OF SKIN, SUBCUTANEOUS TISSUE, MUSCLE AND FASCIA FOR          NECROTIZING SOFT TISSUE INFECTION; EXTERNAL GENITALIA, PERINEUM AND      ABDOMINAL WALL, WITH OR WITHOUT FASCIAL CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1756, N'11311', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1757, N'11008', N'REMOVAL OF PROSTHETIC MATERIAL OR MESH, ABDOMINAL WALL FOR INFECTION (EG, FOR CHRONIC OR RECURRENT MESH INFECTION OR NECROTIZING SOFT TISSUE INFECTION) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1758, N'11403', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), TRUNK, ARMS OR LEGS; EXCISED DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1759, N'11404', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), TRUNK, ARMS OR LEGS; EXCISED DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1760, N'11424', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1761, N'11057', N'PARING OR CUTTING OF BENIGN HYPERKERATOTIC LESION (EG, CORN OR CALLUS); MORE THAN FOUR LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1762, N'1119F', N'INITIAL EVALUATION FOR CONDITION (HEP C)(EPI)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1763, N'11200', N'REMOVAL OF SKIN TAGS, MULTIPLE FIBROCUTANEOUS TAGS, ANY AREA; UP TO AND INCLUDING 15 LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1764, N'11306', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1765, N'11426', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1766, N'11312', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1767, N'11313', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER OVER 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1768, N'11047', N'DEBRIDEMENT, BONE (INCLUDES EPIDERMIS, DERMIS, SUBCUTANEOUS TISSUE, MUSCLE AND/OR FASCIA, IF PERFORMED); EACH ADDITIONAL 20 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1769, N'11463', N'EXCISION OF SKIN AND SUBCUTANEOUS TISSUE FOR HIDRADENITIS, INGUINAL; WITH COMPLEX REPAIR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1770, N'11470', N'EXCISION OF SKIN AND SUBCUTANEOUS TISSUE FOR HIDRADENITIS, PERIANAL, PERINEAL, OR UMBILICAL; WITH SIMPLE OR INTERMEDIATE REPAIR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1771, N'11406', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), TRUNK, ARMS OR LEGS; EXCISED DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1772, N'1136F', N'EPISODE OF BACK PAIN LASTING 12 WEEKS OR LESS (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1773, N'11400', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), TRUNK, ARMS OR LEGS; EXCISED DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1774, N'11062', N'SHAVING OF EPIDERMAL OR SUPERFICIAL DERMAL LESION; MORE THAN FOUR LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1775, N'11101', N'BIOPSY OF SKIN, SUBCUTANEOUS TISSUE AND/OR MUCOUS MEMBRANE (INCLUDING SIMPLE CLOSURE), UNLESS OTHERWISE LISTED (SEPARATE PROCEDURE); EACH SEPARATE/ADDITIONAL LESION (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1776, N'1150F', N'DOCUMENTATION THAT A PATIENT HAS A SUBSTANTIAL RISK OF DEATH WITHIN ONE YEAR (PALL CR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1777, N'11600', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, TRUNK, ARMS, OR LEGS; EXCISED DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1778, N'11402', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), TRUNK, ARMS OR LEGS; EXCISED DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1779, N'11606', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, TRUNK, ARMS, OR LEGS; EXCISED DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1780, N'11623', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1781, N'11624', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1782, N'11641', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, FACE, EARS, EYELIDS, NOSE, LIPS; EXCISED DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1783, N'1121F', N'SUBSEQUENT EVALUATION FOR CONDITION (HEP C) (EPI)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1784, N'1124F', N'ADVANCE CARE PLANNING DISCUSSED AND DOCUMENTED IN THE MEDICAL RECORD, PATIENT DID NOT WISH OR WAS NOT ABLE TO NAME A SURROGATE DECISION MAKER OR PROVIDE AN ADVANCE CARE PLAN (GER, PALL CR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1785, N'11646', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, FACE, EARS, EYELIDS, NOSE, LIPS; EXCISED DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1786, N'11701', N'DEBRIDEMENT OF NAILS, MANUAL; EACH ADDITIONAL, FIVE OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1787, N'11711', N'DEBRIDEMENT OF NAILS, ELECTRIC GRINDER; EACH ADDITIONAL, FIVE OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1788, N'11719', N'TRIMMING OF NONDYSTROPHIC NAILS, ANY NUMBER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1789, N'11720', N'DEBRIDEMENT OF NAIL(S) BY ANY METHOD(S); 1 TO 5', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1790, N'11730', N'AVULSION OF NAIL PLATE, PARTIAL OR COMPLETE, SIMPLE; SINGLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1791, N'11301', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, TRUNK, ARMS OR LEGS; LESION DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1792, N'11302', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, TRUNK, ARMS OR LEGS; LESION DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1793, N'11303', N'SHAVING OF EPIDERMAL OR DERMAL LESION, SINGLE LESION, TRUNK, ARMS OR LEGS; LESION DIAMETER OVER 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1794, N'11401', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), TRUNK, ARMS OR LEGS; EXCISED DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1795, N'11420', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1796, N'11422', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1797, N'11421', N'EXCISION, BENIGN LESION INCLUDING MARGINS, EXCEPT SKIN TAG (UNLESS LISTED ELSEWHERE), SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1798, N'11462', N'EXCISION OF SKIN AND SUBCUTANEOUS TISSUE FOR HIDRADENITIS, INGUINAL; WITH SIMPLE OR INTERMEDIATE REPAIR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1799, N'11471', N'EXCISION OF SKIN AND SUBCUTANEOUS TISSUE FOR HIDRADENITIS, PERIANAL, PERINEAL, OR UMBILICAL; WITH COMPLEX REPAIR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1800, N'11441', N'EXCISION, OTHER BENIGN LESION INCLUDING MARGINS (UNLESS LISTED ELSEWHERE), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; EXCISED DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1801, N'11732', N'AVULSION OF NAIL PLATE, PARTIAL OR COMPLETE, SIMPLE; EACH ADDITIONAL NAIL PLATE (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1802, N'1157F', N'ADVANCE CARE PLAN OR SIMILAR LEGAL DOCUMENT PRESENT IN THE MEDICAL RECORD (COA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1803, N'1158F', N'ADVANCE CARE PLANNING DISCUSSION DOCUMENTED IN THE MEDICAL RECORD (COA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1804, N'11443', N'EXCISION, OTHER BENIGN LESION INCLUDING MARGINS (UNLESS LISTED ELSEWHERE), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; EXCISED DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1805, N'11601', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, TRUNK, ARMS, OR LEGS; EXCISED DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1806, N'11621', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1807, N'11440', N'EXCISION, OTHER BENIGN LESION INCLUDING MARGINS (UNLESS LISTED ELSEWHERE), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; EXCISED DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 800 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1808, N'11622', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1809, N'11626', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1810, N'1152F', N'DOCUMENTATION OF ADVANCED DISEASE DIAGNOSIS, GOALS OF CARE PRIORITIZE COMFORT (PALL CR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1811, N'1153F', N'DOCUMENTATION OF ADVANCED DISEASE DIAGNOSIS, GOALS OF CARE DO NOT PRIORITIZE COMFORT (PALL CR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1812, N'11442', N'EXCISION, OTHER BENIGN LESION INCLUDING MARGINS (UNLESS LISTED ELSEWHERE), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; EXCISED DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1813, N'11444', N'EXCISION, OTHER BENIGN LESION INCLUDING MARGINS (UNLESS LISTED ELSEWHERE), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; EXCISED DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1814, N'11643', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, FACE, EARS, EYELIDS, NOSE, LIPS; EXCISED DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1815, N'11700', N'DEBRIDEMENT OF NAILS, MANUAL; FIVE OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1816, N'1175F', N'FUNCTIONAL STATUS FOR DEMENTIA ASSESSED AND RESULTS REVIEWED (DEM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1817, N'11762', N'RECONSTRUCTION OF NAIL BED WITH GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1818, N'11765', N'WEDGE EXCISION OF SKIN OF NAIL FOLD (EG, FOR INGROWN TOENAIL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1819, N'11770', N'EXCISION OF PILONIDAL CYST OR SINUS; SIMPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1820, N'1182F', N'NEUROPSYCHIATRIC SYMPTOMS, ONE OR MORE PRESENT (DEM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1821, N'1183F', N'NEUROPSYCHIATRIC SYMPTOMS, ABSENT (DEM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1822, N'11921', N'TATTOOING, INTRADERMAL INTRODUCTION OF INSOLUBLE OPAQUE PIGMENTS TO CORRECT COLOR DEFECTS OF SKIN, INCLUDING MICROPIGMENTATION; 6.1 TO 20.0 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1823, N'11446', N'EXCISION, OTHER BENIGN LESION INCLUDING MARGINS (UNLESS LISTED ELSEWHERE), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; EXCISED DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1824, N'11450', N'EXCISION OF SKIN AND SUBCUTANEOUS TISSUE FOR HIDRADENITIS, AXILLARY; WITH SIMPLE OR INTERMEDIATE REPAIR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1825, N'11451', N'EXCISION OF SKIN AND SUBCUTANEOUS TISSUE FOR HIDRADENITIS, AXILLARY; WITH COMPLEX REPAIR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1826, N'1151F', N'DOCUMENTATION THAT A PATIENT DOES NOT HAVE A SUBSTANTIAL RISK OF DEATH WITHIN ONE YEAR (PALL CR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1827, N'11603', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, TRUNK, ARMS, OR LEGS; EXCISED DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1828, N'11604', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, TRUNK, ARMS, OR LEGS; EXCISED DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1829, N'1160F', N'REVIEW OF ALL MEDICATIONS BY A PRESCRIBING PRACTITIONER OR CLINICAL PHARMACIST (SUCH AS, PRESCRIPTIONS, OTCS, HERBAL THERAPIES AND SUPPLEMENTS) DOCUMENTED IN THE MEDICAL RECORD (COA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1830, N'11954', N'SUBCUTANEOUS INJECTION OF FILLING MATERIAL (EG, COLLAGEN); OVER 10.0 CC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1831, N'11970', N'REPLACEMENT OF TISSUE EXPANDER WITH PERMANENT PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1832, N'1170F', N'FUNCTIONAL STATUS ASSESSED (COA) (RA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1833, N'11731', N'AVULSION OF NAIL PLATE, PARTIAL OR COMPLETE, SIMPLE; SECOND NAIL PLATE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1834, N'11740', N'EVACUATION OF SUBUNGUAL HEMATOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1835, N'11981', N'INSERTION, NON-BIODEGRADABLE DRUG DELIVERY IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1836, N'11983', N'REMOVAL WITH REINSERTION, NON-BIODEGRADABLE DRUG DELIVERY IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1837, N'11640', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, FACE, EARS, EYELIDS, NOSE, LIPS; EXCISED DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1838, N'11642', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, FACE, EARS, EYELIDS, NOSE, LIPS; EXCISED DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1839, N'11750', N'EXCISION OF NAIL AND NAIL MATRIX, PARTIAL OR COMPLETE, (EG, INGROWN OR DEFORMED NAIL) FOR PERMANENT REMOVAL;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1840, N'1181F', N'NEUROPSYCHIATRIC SYMPTOMS ASSESSED AND RESULTS REVIEWED (DEM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1841, N'11710', N'DEBRIDEMENT OF NAILS, ELECTRIC GRINDER; FIVE OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1842, N'11755', N'BIOPSY OF NAIL UNIT (EG, PLATE, BED, MATRIX, HYPONYCHIUM, PROXIMAL AND LATERAL NAIL FOLDS) (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1843, N'12007', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF SCALP, NECK, AXILLAE, EXTERNAL GENITALIA, TRUNK AND/OR EXTREMITIES (INCLUDING HANDS AND FEET); OVER 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1844, N'1159F', N'MEDICATION LIST DOCUMENTED IN MEDICAL RECORD (COA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1845, N'11602', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, TRUNK, ARMS, OR LEGS; EXCISED DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1846, N'11620', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, SCALP, NECK, HANDS, FEET, GENITALIA; EXCISED DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1847, N'11644', N'EXCISION, MALIGNANT LESION INCLUDING MARGINS, FACE, EARS, EYELIDS, NOSE, LIPS; EXCISED DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1848, N'11901', N'INJECTION, INTRALESIONAL; MORE THAN SEVEN LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1849, N'11920', N'TATTOOING, INTRADERMAL INTRODUCTION OF INSOLUBLE OPAQUE PIGMENTS TO CORRECT COLOR DEFECTS OF SKIN, INCLUDING MICROPIGMENTATION; 6.0 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1850, N'11721', N'DEBRIDEMENT OF NAIL(S) BY ANY METHOD(S); 6 OR MORE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1851, N'11752', N'EXCISION OF NAIL AND NAIL MATRIX, PARTIAL OR COMPLETE, (EG, INGROWN OR DEFORMED NAIL) FOR PERMANENT REMOVAL; WITH AMPUTATION OF TUFT OF DISTAL PHALANX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1852, N'11922', N'TATTOOING, INTRADERMAL INTRODUCTION OF INSOLUBLE OPAQUE PIGMENTS TO CORRECT COLOR DEFECTS OF SKIN, INCLUDING MICROPIGMENTATION; EACH ADDITIONAL 20.0 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1853, N'1200F', N'SEIZURE TYPE(S) AND CURRENT SEIZURE FREQUENCY(IES) DOCUMENTED (EPI)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1854, N'12014', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 5.1 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1855, N'11980', N'SUBCUTANEOUS HORMONE PELLET IMPLANTATION (IMPLANTATION OF ESTRADIOL AND/OR TESTOSTERONE PELLETS BENEATH THE SKIN)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1856, N'12001', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF SCALP, NECK, AXILLAE, EXTERNAL GENITALIA, TRUNK AND/OR EXTREMITIES (INCLUDING HANDS AND FEET); 2.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1857, N'12006', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF SCALP, NECK, AXILLAE, EXTERNAL GENITALIA, TRUNK AND/OR EXTREMITIES (INCLUDING HANDS AND FEET); 20.1 CM TO 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1858, N'11771', N'EXCISION OF PILONIDAL CYST OR SINUS; EXTENSIVE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1859, N'11900', N'INJECTION, INTRALESIONAL; UP TO AND INCLUDING SEVEN LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1860, N'11950', N'SUBCUTANEOUS INJECTION OF FILLING MATERIAL (EG, COLLAGEN); 1 CC OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1861, N'12011', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 2.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1862, N'12013', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 2.6 CM TO 5.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1863, N'11960', N'INSERTION OF TISSUE EXPANDER(S) FOR OTHER THAN BREAST, INCLUDING SUBSEQUENT EXPANSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1864, N'11971', N'REMOVAL OF TISSUE EXPANDER(S) WITHOUT INSERTION OF PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1865, N'12021', N'TREATMENT OF SUPERFICIAL WOUND DEHISCENCE; WITH PACKING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1866, N'12034', N'REPAIR, INTERMEDIATE, WOUNDS OF SCALP, AXILLAE, TRUNK AND/OR EXTREMITIES (EXCLUDING HANDS AND FEET); 7.6 CM TO 12.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1867, N'11975', N'INSERTION, IMPLANTABLE CONTRACEPTIVE CAPSULES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1868, N'11977', N'REMOVAL WITH REINSERTION, IMPLANTABLE CONTRACEPTIVE CAPSULES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1869, N'11982', N'REMOVAL, NON-BIODEGRADABLE DRUG DELIVERY IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1870, N'12051', N'REPAIR, INTERMEDIATE, WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 2.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1871, N'12053', N'REPAIR, INTERMEDIATE, WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 5.1 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1872, N'12004', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF SCALP, NECK, AXILLAE, EXTERNAL GENITALIA, TRUNK AND/OR EXTREMITIES (INCLUDING HANDS AND FEET); 7.6 CM TO 12.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1873, N'11760', N'REPAIR OF NAIL BED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1874, N'11772', N'EXCISION OF PILONIDAL CYST OR SINUS; COMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1875, N'1180F', N'ALL SPECIFIED THROMBOEMBOLIC RISK FACTORS ASSESSED (AFIB)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1876, N'12015', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 7.6 CM TO 12.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1877, N'12018', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; OVER 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1878, N'12016', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 12.6 CM TO 20.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1879, N'12035', N'REPAIR, INTERMEDIATE, WOUNDS OF SCALP, AXILLAE, TRUNK AND/OR EXTREMITIES (EXCLUDING HANDS AND FEET); 12.6 CM TO 20.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1880, N'12036', N'REPAIR, INTERMEDIATE, WOUNDS OF SCALP, AXILLAE, TRUNK AND/OR EXTREMITIES (EXCLUDING HANDS AND FEET); 20.1 CM TO 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1881, N'12037', N'REPAIR, INTERMEDIATE, WOUNDS OF SCALP, AXILLAE, TRUNK AND/OR EXTREMITIES (EXCLUDING HANDS AND FEET); OVER 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1882, N'12041', N'REPAIR, INTERMEDIATE, WOUNDS OF NECK, HANDS, FEET AND/OR EXTERNAL GENITALIA; 2.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1883, N'12042', N'REPAIR, INTERMEDIATE, WOUNDS OF NECK, HANDS, FEET AND/OR EXTERNAL GENITALIA; 2.6 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1884, N'12054', N'REPAIR, INTERMEDIATE, WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 7.6 CM TO 12.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1885, N'13101', N'REPAIR, COMPLEX, TRUNK; 2.6 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1886, N'13102', N'REPAIR, COMPLEX, TRUNK; EACH ADDITIONAL 5 CM OR LESS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1887, N'13151', N'REPAIR, COMPLEX, EYELIDS, NOSE, EARS AND/OR LIPS; 1.1 CM TO 2.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1888, N'13153', N'REPAIR, COMPLEX, EYELIDS, NOSE, EARS AND/OR LIPS; EACH ADDITIONAL 5 CM OR LESS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1889, N'11951', N'SUBCUTANEOUS INJECTION OF FILLING MATERIAL (EG, COLLAGEN); 1.1 TO 5.0 CC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1890, N'11952', N'SUBCUTANEOUS INJECTION OF FILLING MATERIAL (EG, COLLAGEN); 5.1 TO 10.0 CC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1891, N'1400F', N'PARKINSON''S DISEASE DIAGNOSIS REVIEWED (PRKNS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1892, N'14020', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, SCALP, ARMS AND/OR LEGS; DEFECT 10 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1893, N'12056', N'REPAIR, INTERMEDIATE, WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 20.1 CM TO 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1894, N'12057', N'REPAIR, INTERMEDIATE, WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; OVER 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1895, N'14021', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, SCALP, ARMS AND/OR LEGS; DEFECT 10.1 SQ CM TO 30.0 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1896, N'14040', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS AND/OR FEET; DEFECT 10 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1897, N'14041', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS AND/OR FEET; DEFECT 10.1 SQ CM TO 30.0 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1898, N'11976', N'REMOVAL, IMPLANTABLE CONTRACEPTIVE CAPSULES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1899, N'12002', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF SCALP, NECK, AXILLAE, EXTERNAL GENITALIA, TRUNK AND/OR EXTREMITIES (INCLUDING HANDS AND FEET); 2.6 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1900, N'12005', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF SCALP, NECK, AXILLAE, EXTERNAL GENITALIA, TRUNK AND/OR EXTREMITIES (INCLUDING HANDS AND FEET); 12.6 CM TO 20.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1901, N'12031', N'REPAIR, INTERMEDIATE, WOUNDS OF SCALP, AXILLAE, TRUNK AND/OR EXTREMITIES (EXCLUDING HANDS AND FEET); 2.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1902, N'12032', N'REPAIR, INTERMEDIATE, WOUNDS OF SCALP, AXILLAE, TRUNK AND/OR EXTREMITIES (EXCLUDING HANDS AND FEET); 2.6 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1903, N'1205F', N'ETIOLOGY OF EPILEPSY OR EPILEPSY SYNDROME(S) REVIEWED AND DOCUMENTED (EPI)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1904, N'1220F', N'PATIENT SCREENED FOR DEPRESSION (SUD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1905, N'15003', N'SURGICAL PREPARATION OR CREATION OF RECIPIENT SITE BY EXCISION OF OPEN WOUNDS, BURN ESCHAR, OR SCAR (INCLUDING SUBCUTANEOUS TISSUES), OR INCISIONAL RELEASE OF SCAR CONTRACTURE, TRUNK, ARMS, LEGS; EACH ADDITIONAL 100 SQ CM, OR PART THEREOF, OR EACH ADDITIONAL 1% OF BODY AREA OF INFANTS AND CHILDREN (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1906, N'12017', N'SIMPLE REPAIR OF SUPERFICIAL WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 20.1 CM TO 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1907, N'12020', N'TREATMENT OF SUPERFICIAL WOUND DEHISCENCE; SIMPLE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1908, N'15120', N'SPLIT-THICKNESS AUTOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN (EXCEPT 15050)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 900 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1909, N'12045', N'REPAIR, INTERMEDIATE, WOUNDS OF NECK, HANDS, FEET AND/OR EXTERNAL GENITALIA; 12.6 CM TO 20.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1910, N'12046', N'REPAIR, INTERMEDIATE, WOUNDS OF NECK, HANDS, FEET AND/OR EXTERNAL GENITALIA; 20.1 CM TO 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1911, N'12047', N'REPAIR, INTERMEDIATE, WOUNDS OF NECK, HANDS, FEET AND/OR EXTERNAL GENITALIA; OVER 30.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1912, N'12055', N'REPAIR, INTERMEDIATE, WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 12.6 CM TO 20.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1913, N'12044', N'REPAIR, INTERMEDIATE, WOUNDS OF NECK, HANDS, FEET AND/OR EXTERNAL GENITALIA; 7.6 CM TO 12.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1914, N'12052', N'REPAIR, INTERMEDIATE, WOUNDS OF FACE, EARS, EYELIDS, NOSE, LIPS AND/OR MUCOUS MEMBRANES; 2.6 CM TO 5.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1915, N'13122', N'REPAIR, COMPLEX, SCALP, ARMS, AND/OR LEGS; EACH ADDITIONAL 5 CM OR LESS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1916, N'13121', N'REPAIR, COMPLEX, SCALP, ARMS, AND/OR LEGS; 2.6 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1917, N'13131', N'REPAIR, COMPLEX, FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS AND/OR FEET; 1.1 CM TO 2.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1918, N'13133', N'REPAIR, COMPLEX, FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS AND/OR FEET; EACH ADDITIONAL 5 CM OR LESS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1919, N'13100', N'REPAIR, COMPLEX, TRUNK; 1.1 CM TO 2.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1920, N'13120', N'REPAIR, COMPLEX, SCALP, ARMS, AND/OR LEGS; 1.1 CM TO 2.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1921, N'13152', N'REPAIR, COMPLEX, EYELIDS, NOSE, EARS AND/OR LIPS; 2.6 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1922, N'14301', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, ANY AREA; DEFECT 30.1 SQ CM TO 60.0 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1923, N'15000', N'SURGICAL PREPARATION OR CREATION OF RECIPIENT SITE BY EXCISION OF OPEN WOUNDS, BURN ESCHAR, OR SCAR (INCLUDING SUBCUTANEOUS TISSUES), OR INCISIONAL RELEASE OF SCAR CONTRACTURE; FIRST 100 SQ CM OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1924, N'13132', N'REPAIR, COMPLEX, FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS AND/OR FEET; 2.6 CM TO 7.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1925, N'13150', N'REPAIR, COMPLEX, EYELIDS, NOSE, EARS AND/OR LIPS; 1.0 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1926, N'15002', N'SURGICAL PREPARATION OR CREATION OF RECIPIENT SITE BY EXCISION OF OPEN WOUNDS, BURN ESCHAR, OR SCAR (INCLUDING SUBCUTANEOUS TISSUES), OR INCISIONAL RELEASE OF SCAR CONTRACTURE, TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR 1% OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1927, N'13160', N'SECONDARY CLOSURE OF SURGICAL WOUND OR DEHISCENCE, EXTENSIVE OR COMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1928, N'14001', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, TRUNK; DEFECT 10.1 SQ CM TO 30.0 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1929, N'15004', N'SURGICAL PREPARATION OR CREATION OF RECIPIENT SITE BY EXCISION OF OPEN WOUNDS, BURN ESCHAR, OR SCAR (INCLUDING SUBCUTANEOUS TISSUES), OR INCISIONAL RELEASE OF SCAR CONTRACTURE, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR 1% OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1930, N'15040', N'HARVEST OF SKIN FOR TISSUE CULTURED SKIN AUTOGRAFT, 100 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1931, N'15156', N'TISSUE CULTURED SKIN AUTOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; ADDITIONAL 1 SQ CM TO 75 SQ CM (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1932, N'14060', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, EYELIDS, NOSE, EARS AND/OR LIPS; DEFECT 10 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1933, N'14061', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, EYELIDS, NOSE, EARS AND/OR LIPS; DEFECT 10.1 SQ CM TO 30.0 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1934, N'15150', N'TISSUE CULTURED SKIN AUTOGRAFT, TRUNK, ARMS, LEGS; FIRST 25 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1935, N'15152', N'TISSUE CULTURED SKIN AUTOGRAFT, TRUNK, ARMS, LEGS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL 1% OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1936, N'14302', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, ANY AREA; EACH ADDITIONAL 30.0 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1937, N'15155', N'TISSUE CULTURED SKIN AUTOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 25 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1938, N'13300', N'REPAIR, UNUSUAL, COMPLICATED, OVER 7.5 CM, ANY AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1939, N'14000', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, TRUNK; DEFECT 10 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1940, N'15171', N'ACELLULAR DERMAL REPLACEMENT, TRUNK, ARMS, LEGS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1941, N'14300', N'ADJACENT TISSUE TRANSFER OR REARRANGEMENT, MORE THAN 30 SQ CM, UNUSUAL OR COMPLICATED, ANY AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1942, N'14350', N'FILLETED FINGER OR TOE FLAP, INCLUDING PREPARATION OF RECIPIENT SITE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1943, N'15175', N'ACELLULAR DERMAL REPLACEMENT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1944, N'1460F', N'QUALIFYING CARDIAC EVENT/DIAGNOSIS IN PREVIOUS 12 MONTHS (CAD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1945, N'1461F', N'NO QUALIFYING CARDIAC EVENT/DIAGNOSIS IN PREVIOUS 12 MONTHS (CAD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1946, N'15261', N'FULL THICKNESS GRAFT, FREE, INCLUDING DIRECT CLOSURE OF DONOR SITE, NOSE, EARS, EYELIDS, AND/OR LIPS; EACH ADDITIONAL 20 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1947, N'1450F', N'SYMPTOMS IMPROVED OR REMAINED CONSISTENT WITH TREATMENT GOALS SINCE LAST ASSESSMENT (HF)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1948, N'1451F', N'SYMPTOMS DEMONSTRATED CLINICALLY IMPORTANT DETERIORATION SINCE LAST ASSESSMENT (HF)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1949, N'15157', N'TISSUE CULTURED EPIDERMAL AUTOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1950, N'1490F', N'DEMENTIA SEVERITY CLASSIFIED, MILD (DEM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1951, N'1491F', N'DEMENTIA SEVERITY CLASSIFIED, MODERATE (DEM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1952, N'1493F', N'DEMENTIA SEVERITY CLASSIFIED, SEVERE (DEM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1953, N'15005', N'SURGICAL PREPARATION OR CREATION OF RECIPIENT SITE BY EXCISION OF OPEN WOUNDS, BURN ESCHAR, OR SCAR (INCLUDING SUBCUTANEOUS TISSUES), OR INCISIONAL RELEASE OF SCAR CONTRACTURE, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR PART THEREOF, OR EACH ADDITIONAL 1% OF BODY AREA OF INFANTS AND CHILDREN (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1954, N'15170', N'ACELLULAR DERMAL REPLACEMENT, TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1955, N'15176', N'ACELLULAR DERMAL REPLACEMENT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1956, N'15275', N'APPLICATION OF SKIN SUBSTITUTE GRAFT TO FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS, TOTAL WOUND SURFACE AREA UP TO 100 SQ CM; FIRST 25 SQ CM OR LESS WOUND SURFACE AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1957, N'15273', N'APPLICATION OF SKIN SUBSTITUTE GRAFT TO TRUNK, ARMS, LEGS, TOTAL WOUND SURFACE AREA GREATER THAN OR EQUAL TO 100 SQ CM; FIRST 100 SQ CM WOUND SURFACE AREA, OR 1% OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1958, N'1494F', N'COGNITION ASSESSED AND REVIEWED (DEM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1959, N'15001', N'SURGICAL PREPARATION OR CREATION OF RECIPIENT SITE BY EXCISION OF OPEN WOUNDS, BURN ESCHAR, OR SCAR (INCLUDING SUBCUTANEOUS TISSUES); EACH ADDITIONAL 100 SQ CM OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1960, N'15300', N'ALLOGRAFT SKIN FOR TEMPORARY WOUND CLOSURE, TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1961, N'15050', N'PINCH GRAFT, SINGLE OR MULTIPLE, TO COVER SMALL ULCER, TIP OF DIGIT, OR OTHER MINIMAL OPEN AREA (EXCEPT ON FACE), UP TO DEFECT SIZE 2 CM DIAMETER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1962, N'15341', N'TISSUE CULTURED ALLOGENEIC SKIN SUBSTITUTE; EACH ADDITIONAL 25 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1963, N'15101', N'SPLIT GRAFT, TRUNK, ARMS, LEGS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1964, N'15366', N'TISSUE CULTURED ALLOGENEIC DERMAL SUBSTITUTE, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1965, N'15111', N'EPIDERMAL AUTOGRAFT, TRUNK, ARMS, LEGS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1966, N'15412', N'FREE TRANSPLANTATION OF SKIN FLAP BY MICROSURGICAL TECHNIQUE, INCLUDING MICROVASCULAR ANASTOMOSIS; BETWEEN 101 AND 160 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1967, N'15545', N'PRIMARY ATTACHMENT OF OPEN OR TUBED PEDICLE FLAP TO RECIPIENT SITE REQUIRING MINIMAL PREPARATION; TO SCALP, ARMS, OR LEGS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1968, N'15115', N'EPIDERMAL AUTOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1969, N'15276', N'APPLICATION OF SKIN SUBSTITUTE GRAFT TO FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS, TOTAL WOUND SURFACE AREA UP TO 100 SQ CM; EACH ADDITIONAL 25 SQ CM WOUND SURFACE AREA, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1970, N'15555', N'PRIMARY ATTACHMENT OF OPEN OR TUBED PEDICLE FLAP TO RECIPIENT SITE REQUIRING MINIMAL PREPARATION; TO EYELIDS, NOSE, EARS, OR LIPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1971, N'15700', N'EXCISION OF LESION AND/OR EXCISIONAL PREPARATION OF RECIPIENT SITE AND ATTACHMENT OF DIRECT OR TUBED PEDICLE FLAP; TRUNK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1972, N'15277', N'APPLICATION OF SKIN SUBSTITUTE GRAFT TO FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS, TOTAL WOUND SURFACE AREA GREATER THAN OR EQUAL TO 100 SQ CM; FIRST 100 SQ CM WOUND SURFACE AREA, OR 1% OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1973, N'15100', N'SPLIT-THICKNESS AUTOGRAFT, TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN (EXCEPT 15050)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1974, N'15116', N'EPIDERMAL AUTOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1975, N'15110', N'EPIDERMAL AUTOGRAFT, TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1976, N'15121', N'SPLIT GRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1977, N'15131', N'DERMAL AUTOGRAFT, TRUNK, ARMS, LEGS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1978, N'15130', N'DERMAL AUTOGRAFT, TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1979, N'15151', N'TISSUE CULTURED SKIN AUTOGRAFT, TRUNK, ARMS, LEGS; ADDITIONAL 1 SQ CM TO 75 SQ CM (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1980, N'15135', N'DERMAL AUTOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1981, N'15710', N'EXCISION OF LESION AND/OR EXCISIONAL PREPARATION OF RECIPIENT SITE AND ATTACHMENT OF DIRECT OR TUBED PEDICLE FLAP; SCALP, ARMS, OR LEGS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1982, N'15136', N'DERMAL AUTOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1983, N'15720', N'EXCISION OF LESION AND/OR EXCISIONAL PREPARATION OF RECIPIENT SITE AND ATTACHMENT OF DIRECT OR TUBED PEDICLE FLAP; FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS, OR FEET', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1984, N'15200', N'FULL THICKNESS GRAFT, FREE, INCLUDING DIRECT CLOSURE OF DONOR SITE, TRUNK; 20 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1985, N'15201', N'FULL THICKNESS GRAFT, FREE, INCLUDING DIRECT CLOSURE OF DONOR SITE, TRUNK; EACH ADDITIONAL 20 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1986, N'15731', N'FOREHEAD FLAP WITH PRESERVATION OF VASCULAR PEDICLE (EG, AXIAL PATTERN FLAP, PARAMEDIAN FOREHEAD FLAP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1987, N'15734', N'MUSCLE, MYOCUTANEOUS, OR FASCIOCUTANEOUS FLAP; TRUNK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1988, N'15278', N'APPLICATION OF SKIN SUBSTITUTE GRAFT TO FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS, TOTAL WOUND SURFACE AREA GREATER THAN OR EQUAL TO 100 SQ CM; EACH ADDITIONAL 100 SQ CM WOUND SURFACE AREA, OR PART THEREOF, OR EACH ADDITIONAL 1% OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1989, N'15220', N'FULL THICKNESS GRAFT, FREE, INCLUDING DIRECT CLOSURE OF DONOR SITE, SCALP, ARMS, AND/OR LEGS; 20 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1990, N'15221', N'FULL THICKNESS GRAFT, FREE, INCLUDING DIRECT CLOSURE OF DONOR SITE, SCALP, ARMS, AND/OR LEGS; EACH ADDITIONAL 20 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1991, N'15321', N'ALLOGRAFT SKIN FOR TEMPORARY WOUND CLOSURE, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1992, N'15241', N'FULL THICKNESS GRAFT, FREE, INCLUDING DIRECT CLOSURE OF DONOR SITE, FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS, AND/OR FEET; EACH ADDITIONAL 20 SQ CM, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1993, N'15335', N'ACELLULAR DERMAL ALLOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1994, N'15271', N'APPLICATION OF SKIN SUBSTITUTE GRAFT TO TRUNK, ARMS, LEGS, TOTAL WOUND SURFACE AREA UP TO 100 SQ CM; FIRST 25 SQ CM OR LESS WOUND SURFACE AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1995, N'15343', N'APPLICATION OF BILAMINATE SKIN SUBSTITUTE/NEODERMIS; EACH ADDITIONAL 25 SQ CM (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1996, N'15240', N'FULL THICKNESS GRAFT, FREE, INCLUDING DIRECT CLOSURE OF DONOR SITE, FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS, AND/OR FEET; 20 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1997, N'15351', N'APPLICATION OF ALLOGRAFT, SKIN; EACH ADDITIONAL 100 SQ CM (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1998, N'15361', N'TISSUE CULTURED ALLOGENEIC DERMAL SUBSTITUTE; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (1999, N'15260', N'FULL THICKNESS GRAFT, FREE, INCLUDING DIRECT CLOSURE OF DONOR SITE, NOSE, EARS, EYELIDS, AND/OR LIPS; 20 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2000, N'15272', N'APPLICATION OF SKIN SUBSTITUTE GRAFT TO TRUNK, ARMS, LEGS, TOTAL WOUND SURFACE AREA UP TO 100 SQ CM; EACH ADDITIONAL 25 SQ CM WOUND SURFACE AREA, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2001, N'15365', N'TISSUE CULTURED ALLOGENEIC DERMAL SUBSTITUTE, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2002, N'15274', N'APPLICATION OF SKIN SUBSTITUTE GRAFT TO TRUNK, ARMS, LEGS, TOTAL WOUND SURFACE AREA GREATER THAN OR EQUAL TO 100 SQ CM; EACH ADDITIONAL 100 SQ CM WOUND SURFACE AREA, OR PART THEREOF, OR EACH ADDITIONAL 1% OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2003, N'15410', N'FREE TRANSPLANTATION OF SKIN FLAP BY MICROSURGICAL TECHNIQUE, INCLUDING MICROVASCULAR ANASTOMOSIS; 100 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2004, N'15414', N'FREE TRANSPLANTATION OF SKIN FLAP BY MICROSURGICAL TECHNIQUE, INCLUDING MICROVASCULAR ANASTOMOSIS; BETWEEN 161 AND 230 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2005, N'15301', N'ALLOGRAFT SKIN FOR TEMPORARY WOUND CLOSURE, TRUNK, ARMS, LEGS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2006, N'15755', N'FREE FLAP (MICROVASCULAR TRANSFER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2007, N'15776', N'PUNCH GRAFT FOR HAIR TRANSPLANT; MORE THAN 15 PUNCH GRAFTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2008, N'15777', N'IMPLANTATION OF BIOLOGIC IMPLANT (EG, ACELLULAR DERMAL MATRIX) FOR SOFT TISSUE REINFORCEMENT (EG, BREAST, TRUNK) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2009, N'15330', N'ACELLULAR DERMAL ALLOGRAFT, TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1000 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2010, N'15340', N'TISSUE CULTURED ALLOGENEIC SKIN SUBSTITUTE; FIRST 25 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2011, N'15781', N'DERMABRASION; SEGMENTAL, FACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2012, N'15783', N'DERMABRASION; SUPERFICIAL, ANY SITE, (EG, TATTOO REMOVAL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2013, N'15788', N'CHEMICAL PEEL, FACIAL; EPIDERMAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2014, N'15342', N'APPLICATION OF BILAMINATE SKIN SUBSTITUTE/NEODERMIS; 25 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2015, N'15360', N'TISSUE CULTURED ALLOGENEIC DERMAL SUBSTITUTE; TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2016, N'15789', N'CHEMICAL PEEL, FACIAL; DERMAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2017, N'15790', N'CHEMICAL PEEL (CHEMEXFOLIATION); TOTAL FACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2018, N'15791', N'CHEMICAL PEEL (CHEMEXFOLIATION); REGIONAL, FACE, HAND, OR ELSEWHERE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2019, N'15421', N'XENOGRAFT SKIN (DERMAL), FOR TEMPORARY WOUND CLOSURE, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2020, N'15320', N'ALLOGRAFT SKIN FOR TEMPORARY WOUND CLOSURE, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2021, N'15510', N'FORMATION OF TUBE PEDICLE WITHOUT TRANSFER, OR MAJOR ''''DELAY'''' OF LARGE FLAP WITHOUT TRANSFER; ON FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS, OR FEET', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2022, N'15331', N'ACELLULAR DERMAL ALLOGRAFT, TRUNK, ARMS, LEGS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2023, N'15540', N'PRIMARY ATTACHMENT OF OPEN OR TUBED PEDICLE FLAP TO RECIPIENT SITE REQUIRING MINIMAL PREPARATION; TO TRUNK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2024, N'15550', N'PRIMARY ATTACHMENT OF OPEN OR TUBED PEDICLE FLAP TO RECIPIENT SITE REQUIRING MINIMAL PREPARATION; TO FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, OR HANDS, FEET', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2025, N'15336', N'ACELLULAR DERMAL ALLOGRAFT, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2026, N'15416', N'FREE TRANSPLANTATION OF SKIN FLAP BY MICROSURGICAL TECHNIQUE, INCLUDING MICROVASCULAR ANASTOMOSIS; OVER 230 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2027, N'15420', N'XENOGRAFT SKIN (DERMAL), FOR TEMPORARY WOUND CLOSURE, FACE, SCALP, EYELIDS, MOUTH, NECK, EARS, ORBITS, GENITALIA, HANDS, FEET, AND/OR MULTIPLE DIGITS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2028, N'15350', N'APPLICATION OF ALLOGRAFT, SKIN; 100 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2029, N'15400', N'XENOGRAFT, SKIN (DERMAL), FOR TEMPORARY WOUND CLOSURE; TRUNK, ARMS, LEGS; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2030, N'15572', N'FORMATION OF DIRECT OR TUBED PEDICLE, WITH OR WITHOUT TRANSFER; SCALP, ARMS, OR LEGS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2031, N'15574', N'FORMATION OF DIRECT OR TUBED PEDICLE, WITH OR WITHOUT TRANSFER; FOREHEAD, CHEEKS, CHIN, MOUTH, NECK, AXILLAE, GENITALIA, HANDS OR FEET', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2032, N'15793', N'CHEMICAL PEEL, NONFACIAL; DERMAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2033, N'15824', N'RHYTIDECTOMY; FOREHEAD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2034, N'15829', N'RHYTIDECTOMY; SUPERFICIAL MUSCULOAPONEUROTIC SYSTEM (SMAS) FLAP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2035, N'15580', N'CROSS FINGER FLAP, INCLUDING FREE GRAFT TO DONOR SITE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2036, N'15730', N'EXCISION OF LESION AND/OR EXCISIONAL PREPARATION OF RECIPIENT SITE AND ATTACHMENT OF DIRECT OR TUBED PEDICLE FLAP; EYELIDS, NOSE, EARS, OR LIPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2037, N'15430', N'ACELLULAR XENOGRAFT IMPLANT; FIRST 100 SQ CM OR LESS, OR ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2038, N'15515', N'FORMATION OF TUBE PEDICLE WITHOUT TRANSFER, OR MAJOR ''''DELAY'''' OF LARGE FLAP WITHOUT TRANSFER; ON EYELIDS, NOSE, EARS, OR LIPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2039, N'15732', N'MUSCLE, MYOCUTANEOUS, OR FASCIOCUTANEOUS FLAP; HEAD AND NECK (EG, TEMPORALIS, MASSETER MUSCLE, STERNOCLEIDOMASTOID, LEVATOR SCAPULAE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2040, N'15570', N'FORMATION OF DIRECT OR TUBED PEDICLE, WITH OR WITHOUT TRANSFER; TRUNK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2041, N'15576', N'FORMATION OF DIRECT OR TUBED PEDICLE, WITH OR WITHOUT TRANSFER; EYELIDS, NOSE, EARS, LIPS, OR INTRAORAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2042, N'15736', N'MUSCLE, MYOCUTANEOUS, OR FASCIOCUTANEOUS FLAP; UPPER EXTREMITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2043, N'15757', N'FREE SKIN FLAP WITH MICROVASCULAR ANASTOMOSIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2044, N'15758', N'FREE FASCIAL FLAP WITH MICROVASCULAR ANASTOMOSIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2045, N'15610', N'DELAY OF FLAP OR SECTIONING OF FLAP (DIVISION AND INSET); AT SCALP, ARMS, OR LEGS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2046, N'15620', N'DELAY OF FLAP OR SECTIONING OF FLAP (DIVISION AND INSET); AT FOREHEAD, CHEEKS, CHIN, NECK, AXILLAE, GENITALIA, HANDS, OR FEET', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2047, N'15401', N'XENOGRAFT, SKIN (DERMAL), FOR TEMPORARY WOUND CLOSURE; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2048, N'15630', N'DELAY OF FLAP OR SECTIONING OF FLAP (DIVISION AND INSET); AT EYELIDS, NOSE, EARS, OR LIPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2049, N'15650', N'TRANSFER, INTERMEDIATE, OF ANY PEDICLE FLAP (EG, ABDOMEN TO WRIST, WALKING TUBE), ANY LOCATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2050, N'15431', N'ACELLULAR XENOGRAFT IMPLANT; EACH ADDITIONAL 100 SQ CM, OR EACH ADDITIONAL ONE PERCENT OF BODY AREA OF INFANTS AND CHILDREN, OR PART THEREOF (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2051, N'15830', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDES LIPECTOMY); ABDOMEN, INFRAUMBILICAL PANNICULECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2052, N'15834', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); HIP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2053, N'15500', N'FORMATION OF TUBE PEDICLE WITHOUT TRANSFER, OR MAJOR ''''DELAY'''' OF LARGE FLAP WITHOUT TRANSFER; ON TRUNK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2054, N'15505', N'FORMATION OF TUBE PEDICLE WITHOUT TRANSFER, OR MAJOR ''''DELAY'''' OF LARGE FLAP WITHOUT TRANSFER; ON SCALP, ARMS, OR LEGS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2055, N'15842', N'GRAFT FOR FACIAL NERVE PARALYSIS; FREE MUSCLE FLAP BY MICROSURGICAL TECHNIQUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2056, N'15847', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDES LIPECTOMY), ABDOMEN (EG, ABDOMINOPLASTY) (INCLUDES UMBILICAL TRANSPOSITION AND FASCIAL PLICATION) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2057, N'15760', N'GRAFT; COMPOSITE (EG, FULL THICKNESS OF EXTERNAL EAR OR NASAL ALA), INCLUDING PRIMARY CLOSURE, DONOR AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2058, N'15775', N'PUNCH GRAFT FOR HAIR TRANSPLANT; 1 TO 15 PUNCH GRAFTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2059, N'15738', N'MUSCLE, MYOCUTANEOUS, OR FASCIOCUTANEOUS FLAP; LOWER EXTREMITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2060, N'15740', N'FLAP; ISLAND PEDICLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2061, N'15745', N'GRAFT; MYOCUTANEOUS FLAP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2062, N'15787', N'ABRASION; EACH ADDITIONAL 4 LESIONS OR LESS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2063, N'15820', N'BLEPHAROPLASTY, LOWER EYELID;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2064, N'15600', N'DELAY OF FLAP OR SECTIONING OF FLAP (DIVISION AND INSET); AT TRUNK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2065, N'15625', N'DELAY OF FLAP OR SECTIONING OF FLAP (DIVISION AND INSET); SECTION PEDICLE OF CROSS FINGER FLAP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2066, N'15825', N'RHYTIDECTOMY; NECK WITH PLATYSMAL TIGHTENING (PLATYSMAL FLAP, P-FLAP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2067, N'15826', N'RHYTIDECTOMY; GLABELLAR FROWN LINES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2068, N'15831', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); ABDOMEN (ABDOMINOPLASTY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2069, N'15750', N'FLAP; NEUROVASCULAR PEDICLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2070, N'15780', N'DERMABRASION; TOTAL FACE (EG, FOR ACNE SCARRING, FINE WRINKLING, RHYTIDS, GENERAL KERATOSIS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2071, N'15832', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); THIGH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2072, N'15833', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); LEG', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2073, N'15792', N'CHEMICAL PEEL, NONFACIAL; EPIDERMAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2074, N'15811', N'SALABRASION; OVER 20 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2075, N'15822', N'BLEPHAROPLASTY, UPPER EYELID;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2076, N'15837', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); FOREARM OR HAND', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2077, N'15852', N'DRESSING CHANGE (FOR OTHER THAN BURNS) UNDER ANESTHESIA (OTHER THAN LOCAL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2078, N'15823', N'BLEPHAROPLASTY, UPPER EYELID; WITH EXCESSIVE SKIN WEIGHTING DOWN LID', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2079, N'15828', N'RHYTIDECTOMY; CHEEK, CHIN, AND NECK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2080, N'15835', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); BUTTOCK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2081, N'15860', N'INTRAVENOUS INJECTION OF AGENT (EG, FLUORESCEIN) TO TEST VASCULAR FLOW IN FLAP OR GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2082, N'15876', N'SUCTION ASSISTED LIPECTOMY; HEAD AND NECK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2083, N'15756', N'FREE MUSCLE OR MYOCUTANEOUS FLAP WITH MICROVASCULAR ANASTOMOSIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2084, N'15770', N'GRAFT; DERMA-FAT-FASCIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2085, N'15782', N'DERMABRASION; REGIONAL, OTHER THAN FACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2086, N'15878', N'SUCTION ASSISTED LIPECTOMY; UPPER EXTREMITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2087, N'15933', N'EXCISION, SACRAL PRESSURE ULCER, WITH PRIMARY SUTURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2088, N'15836', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); ARM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2089, N'15839', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); OTHER AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2090, N'15935', N'EXCISION, SACRAL PRESSURE ULCER, WITH SKIN FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2091, N'15936', N'EXCISION, SACRAL PRESSURE ULCER, IN PREPARATION FOR MUSCLE OR MYOCUTANEOUS FLAP OR SKIN GRAFT CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2092, N'15786', N'ABRASION; SINGLE LESION (EG, KERATOSIS, SCAR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2093, N'15810', N'SALABRASION; 20 SQ CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2094, N'15819', N'CERVICOPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2095, N'15851', N'REMOVAL OF SUTURES UNDER ANESTHESIA (OTHER THAN LOCAL), OTHER SURGEON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2096, N'15922', N'EXCISION, COCCYGEAL PRESSURE ULCER, WITH COCCYGECTOMY; WITH FLAP CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2097, N'15821', N'BLEPHAROPLASTY, LOWER EYELID; WITH EXTENSIVE HERNIATED FAT PAD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2098, N'15838', N'EXCISION, EXCESSIVE SKIN AND SUBCUTANEOUS TISSUE (INCLUDING LIPECTOMY); SUBMENTAL FAT PAD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2099, N'15937', N'EXCISION, SACRAL PRESSURE ULCER, IN PREPARATION FOR MUSCLE OR MYOCUTANEOUS FLAP OR SKIN GRAFT CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2100, N'15945', N'EXCISION, ISCHIAL PRESSURE ULCER, WITH SKIN FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2101, N'15841', N'GRAFT FOR FACIAL NERVE PARALYSIS; FREE MUSCLE GRAFT (INCLUDING OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2102, N'15845', N'GRAFT FOR FACIAL NERVE PARALYSIS; REGIONAL MUSCLE TRANSFER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2103, N'15953', N'EXCISION, TROCHANTERIC PRESSURE ULCER, WITH SKIN FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2104, N'15964', N'EXCISION, HEEL PRESSURE ULCER, WITH LOCAL SKIN FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2105, N'15850', N'REMOVAL OF SUTURES UNDER ANESTHESIA (OTHER THAN LOCAL), SAME SURGEON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2106, N'15875', N'SUCTION ASSISTED LIPECTOMY, ANY SITE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2107, N'15967', N'EXCISION, HEEL PRESSURE ULCER, WITH OTHER FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2108, N'15971', N'EXCISION, LEG PRESSURE ULCER, WITH PRIMARY SUTURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2109, N'15952', N'EXCISION, TROCHANTERIC PRESSURE ULCER, WITH SKIN FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2110, N'15954', N'EXCISION, TROCHANTERIC PRESSURE ULCER, WITH BIPEDICLE FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1100 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2111, N'15980', N'EXCISION, KNEE PRESSURE ULCER, WITH LOCAL SKIN FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2112, N'16015', N'DRESSINGS AND/OR DEBRIDEMENT, INITIAL OR SUBSEQUENT; UNDER ANESTHESIA, MEDIUM OR LARGE, OR WITH MAJOR DEBRIDEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2113, N'15955', N'EXCISION, TROCHANTERIC PRESSURE ULCER, WITH BIPEDICLE FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2114, N'15972', N'EXCISION, LEG PRESSURE ULCER, WITH LOCAL SKIN FLAP(S);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2115, N'15879', N'SUCTION ASSISTED LIPECTOMY; LOWER EXTREMITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2116, N'15920', N'EXCISION, COCCYGEAL PRESSURE ULCER, WITH COCCYGECTOMY; WITH PRIMARY SUTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2117, N'15982', N'EXCISION, KNEE PRESSURE ULCER, WITH OTHER FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2118, N'15999', N'UNLISTED PROCEDURE, EXCISION PRESSURE ULCER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2119, N'16000', N'INITIAL TREATMENT, FIRST DEGREE BURN, WHEN NO MORE THAN LOCAL TREATMENT IS REQUIRED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2120, N'15931', N'EXCISION, SACRAL PRESSURE ULCER, WITH PRIMARY SUTURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2121, N'15934', N'EXCISION, SACRAL PRESSURE ULCER, WITH SKIN FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2122, N'15840', N'GRAFT FOR FACIAL NERVE PARALYSIS; FREE FASCIA GRAFT (INCLUDING OBTAINING FASCIA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2123, N'15877', N'SUCTION ASSISTED LIPECTOMY; TRUNK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2124, N'15941', N'EXCISION, ISCHIAL PRESSURE ULCER, WITH PRIMARY SUTURE; WITH OSTECTOMY (ISCHIECTOMY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2125, N'15944', N'EXCISION, ISCHIAL PRESSURE ULCER, WITH SKIN FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2126, N'15946', N'EXCISION, ISCHIAL PRESSURE ULCER, WITH OSTECTOMY, IN PREPARATION FOR MUSCLE OR MYOCUTANEOUS FLAP OR SKIN GRAFT CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2127, N'15951', N'EXCISION, TROCHANTERIC PRESSURE ULCER, WITH PRIMARY SUTURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2128, N'15940', N'EXCISION, ISCHIAL PRESSURE ULCER, WITH PRIMARY SUTURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2129, N'15950', N'EXCISION, TROCHANTERIC PRESSURE ULCER, WITH PRIMARY SUTURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2130, N'15958', N'EXCISION, TROCHANTERIC PRESSURE ULCER, IN PREPARATION FOR MUSCLE OR MYOCUTANEOUS FLAP OR SKIN GRAFT CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2131, N'15961', N'EXCISION, HEEL PRESSURE ULCER, WITH PRIMARY SUTURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2132, N'16010', N'DRESSINGS AND/OR DEBRIDEMENT, INITIAL OR SUBSEQUENT; UNDER ANESTHESIA, SMALL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2133, N'17010', N'DESTRUCTION BY ANY METHOD, INCLUDING LASER, WITH OR WITHOUT SURGICAL CURETTEMENT, ALL BENIGN FACIAL LESIONS OR PREMALIGNANT LESIONS IN ANY LOCATION, OR BENIGN LESIONS OTHER THAN CUTANEOUS VASCULAR PROLIFERATIVE LESIONS, INCLUDING LOCAL ANESTHESIA; COMPLICATED LESION(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2134, N'15965', N'EXCISION, HEEL PRESSURE ULCER, WITH LOCAL SKIN FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2135, N'15966', N'EXCISION, HEEL PRESSURE ULCER, WITH OTHER FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2136, N'17101', N'DESTRUCTION BY ANY METHOD, INCLUDING LASER, OF BENIGN SKIN LESIONS OTHER THAN CUTANEOUS VASCULAR PROLIFERATIVE LESIONS ON ANY AREA OTHER THAN THE FACE, INCLUDING LOCAL ANESTHESIA; SECOND LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2137, N'15975', N'EXCISION, LEG PRESSURE ULCER, WITH MUSCLE OR MYOCUTANEOUS FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2138, N'15981', N'EXCISION, KNEE PRESSURE ULCER, WITH LOCAL SKIN FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2139, N'17107', N'DESTRUCTION OF CUTANEOUS VASCULAR PROLIFERATIVE LESIONS (EG, LASER TECHNIQUE); 10.0 TO 50.0 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2140, N'17264', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), TRUNK, ARMS OR LEGS; LESION DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2141, N'16020', N'DRESSINGS AND/OR DEBRIDEMENT OF PARTIAL-THICKNESS BURNS, INITIAL OR SUBSEQUENT; SMALL (LESS THAN 5% TOTAL BODY SURFACE AREA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2142, N'16025', N'DRESSINGS AND/OR DEBRIDEMENT OF PARTIAL-THICKNESS BURNS, INITIAL OR SUBSEQUENT; MEDIUM (EG, WHOLE FACE OR WHOLE EXTREMITY, OR 5% TO 10% TOTAL BODY SURFACE AREA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2143, N'17273', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2144, N'16030', N'DRESSINGS AND/OR DEBRIDEMENT OF PARTIAL-THICKNESS BURNS, INITIAL OR SUBSEQUENT; LARGE (EG, MORE THAN 1 EXTREMITY, OR GREATER THAN 10% TOTAL BODY SURFACE AREA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2145, N'17276', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2146, N'16035', N'ESCHAROTOMY; INITIAL INCISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2147, N'16036', N'ESCHAROTOMY; EACH ADDITIONAL INCISION (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2148, N'17281', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2149, N'16040', N'EXCISION BURN WOUND, WITHOUT SKIN GRAFTING, EMPLOYING ALLOPLASTIC DRESSING (EG, SYNTHETIC MESH), ANY ANATOMIC SITE; UP TO ONE PERCENT TOTAL BODY SURFACE AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2150, N'17286', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2151, N'17001', N'DESTRUCTION BY ANY METHOD, INCLUDING LASER, WITH OR WITHOUT SURGICAL CURETTEMENT, ALL BENIGN FACIAL LESIONS OR PREMALIGNANT LESIONS IN ANY LOCATION, OR BENIGN LESIONS OTHER THAN CUTANEOUS VASCULAR PROLIFERATIVE LESIONS, INCLUDING LOCAL ANESTHESIA; SECOND AND THIRD LESIONS, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2152, N'15956', N'EXCISION, TROCHANTERIC PRESSURE ULCER, IN PREPARATION FOR MUSCLE OR MYOCUTANEOUS FLAP OR SKIN GRAFT CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2153, N'15960', N'EXCISION, HEEL PRESSURE ULCER, WITH PRIMARY SUTURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2154, N'17002', N'DESTRUCTION BY ANY METHOD, INCLUDING LASER, WITH OR WITHOUT SURGICAL CURETTEMENT, ALL BENIGN FACIAL LESIONS OR PREMALIGNANT LESIONS IN ANY LOCATION, OR BENIGN LESIONS OTHER THAN CUTANEOUS VASCULAR PROLIFERATIVE LESIONS, INCLUDING LOCAL ANESTHESIA; OVER THREE LESIONS, EACH ADDITIONAL LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2155, N'15970', N'EXCISION, LEG PRESSURE ULCER, WITH PRIMARY SUTURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2156, N'15973', N'EXCISION, LEG PRESSURE ULCER, WITH LOCAL SKIN FLAP(S); WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2157, N'17004', N'DESTRUCTION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), PREMALIGNANT LESIONS (EG, ACTINIC KERATOSES), 15 OR MORE LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2158, N'15974', N'EXCISION, LEG PRESSURE ULCER, WITH MUSCLE OR MYOCUTANEOUS FLAP CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2159, N'15983', N'EXCISION, KNEE PRESSURE ULCER, WITH OTHER FLAP CLOSURE; WITH OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2160, N'17100', N'DESTRUCTION BY ANY METHOD, INCLUDING LASER, OF BENIGN SKIN LESIONS OTHER THAN CUTANEOUS VASCULAR PROLIFERATIVE LESIONS ON ANY AREA OTHER THAN THE FACE, INCLUDING LOCAL ANESTHESIA; ONE LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2161, N'16041', N'EXCISION BURN WOUND, WITHOUT SKIN GRAFTING, EMPLOYING ALLOPLASTIC DRESSING (EG, SYNTHETIC MESH), ANY ANATOMIC SITE; GREATER THAN ONE PERCENT AND UP TO NINE PERCENT TOTAL BODY SURFACE AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2162, N'17102', N'DESTRUCTION BY ANY METHOD, INCLUDING LASER, OF BENIGN SKIN LESIONS OTHER THAN CUTANEOUS VASCULAR PROLIFERATIVE LESIONS ON ANY AREA OTHER THAN THE FACE, INCLUDING LOCAL ANESTHESIA; OVER TWO LESIONS, EACH ADDITIONAL LESION UP TO 15 LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2163, N'17003', N'DESTRUCTION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), ALL BENIGN OR PREMALIGNANT LESIONS (EG, ACTINIC KERATOSES) OTHER THAN SKIN TAGS OR CUTANEOUS VASCULAR PROLIFERATIVE LESIONS; SECOND THROUGH 14 LESIONS, EACH (LIST SEPARATELY IN ADDITION TO CODE FOR FIRST LESION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2164, N'17108', N'DESTRUCTION OF CUTANEOUS VASCULAR PROLIFERATIVE LESIONS (EG, LASER TECHNIQUE); OVER 50.0 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2165, N'17110', N'DESTRUCTION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), OF BENIGN LESIONS OTHER THAN SKIN TAGS OR CUTANEOUS VASCULAR PROLIFERATIVE LESIONS; UP TO 14 LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2166, N'17104', N'DESTRUCTION BY ANY METHOD, INCLUDING LASER, OF BENIGN SKIN LESIONS OTHER THAN CUTANEOUS VASCULAR PROLIFERATIVE LESIONS ON ANY AREA OTHER THAN THE FACE, INCLUDING LOCAL ANESTHESIA; 15 OR MORE LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2167, N'17304', N'CHEMOSURGERY (MOHS MICROGRAPHIC TECHNIQUE), INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND COMPLETE HISTOPATHOLOGIC PREPARATION INCLUDING THE FIRST ROUTINE STAIN (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE); FIRST STAGE, FRESH TISSUE TECHNIQUE, UP TO 5 SPECIMENS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2168, N'17105', N'DESTRUCTION BY ANY METHOD, INCLUDING LASER, OF BENIGN SKIN LESIONS OTHER THAN CUTANEOUS VASCULAR PROLIFERATIVE LESIONS ON ANY AREA OTHER THAN THE FACE, INCLUDING LOCAL ANESTHESIA; COMPLICATED OR EXTENSIVE LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2169, N'17305', N'CHEMOSURGERY (MOHS MICROGRAPHIC TECHNIQUE), INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND COMPLETE HISTOPATHOLOGIC PREPARATION INCLUDING THE FIRST ROUTINE STAIN (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE); SECOND STAGE, FIXED OR FRESH TISSUE, UP TO 5 SPECIMENS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2170, N'16042', N'EXCISION BURN WOUND, WITHOUT SKIN GRAFTING, EMPLOYING ALLOPLASTIC DRESSING (EG, SYNTHETIC MESH), ANY ANATOMIC SITE; EACH ADDITIONAL NINE PERCENT TOTAL BODY SURFACE AREA, OR PART THEREOF', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2171, N'17250', N'CHEMICAL CAUTERIZATION OF GRANULATION TISSUE (PROUD FLESH, SINUS OR FISTULA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2172, N'17260', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), TRUNK, ARMS OR LEGS; LESION DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2173, N'17106', N'DESTRUCTION OF CUTANEOUS VASCULAR PROLIFERATIVE LESIONS (EG, LASER TECHNIQUE); LESS THAN 10 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2174, N'17200', N'ELECTROSURGICAL DESTRUCTION OF MULTIPLE FIBROCUTANEOUS TAGS; UP TO 15 LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2175, N'17262', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), TRUNK, ARMS OR LEGS; LESION DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2176, N'17201', N'ELECTROSURGICAL DESTRUCTION OF MULTIPLE FIBROCUTANEOUS TAGS; EACH ADDITIONAL TEN LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2177, N'17261', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), TRUNK, ARMS OR LEGS; LESION DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2178, N'17280', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2179, N'17266', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), TRUNK, ARMS OR LEGS; LESION DIAMETER OVER 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2180, N'17282', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2181, N'17270', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER 0.5 CM OR LESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2182, N'17284', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2183, N'17271', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER 0.6 TO 1.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2184, N'17303', N'CHEMOSURGERY (MOHS'' MICROGRAPHIC TECHNIQUE), FIRST STAGE, FIXED TISSUE TECHNIQUE, INCLUDING REMOVAL OF ALL GROSS TUMOR AND APPLICATION OF FIXATIVE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2185, N'17283', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), FACE, EARS, EYELIDS, NOSE, LIPS, MUCOUS MEMBRANE; LESION DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2186, N'17313', N'MOHS MICROGRAPHIC TECHNIQUE, INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND HISTOPATHOLOGIC PREPARATION INCLUDING ROUTINE STAIN(S) (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE), OF THE TRUNK, ARMS, OR LEGS; FIRST STAGE, UP TO 5 TISSUE BLOCKS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2187, N'17306', N'CHEMOSURGERY (MOHS MICROGRAPHIC TECHNIQUE), INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND COMPLETE HISTOPATHOLOGIC PREPARATION INCLUDING THE FIRST ROUTINE STAIN (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE); THIRD STAGE, FIXED OR FRESH TISSUE, UP TO 5 SPECIMENS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2188, N'17000', N'DESTRUCTION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), PREMALIGNANT LESIONS (EG, ACTINIC KERATOSES); FIRST LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2189, N'17310', N'CHEMOSURGERY (MOHS MICROGRAPHIC TECHNIQUE), INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND COMPLETE HISTOPATHOLOGIC PREPARATION INCLUDING THE FIRST ROUTINE STAIN (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE); EACH ADDITIONAL SPECIMEN, AFTER THE FIRST 5 SPECIMENS, FIXED OR FRESH TISSUE, ANY STAGE (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2190, N'17111', N'DESTRUCTION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), OF FLAT WARTS, MOLLUSCUM CONTAGIOSUM, OR MILIA; 15 OR MORE LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2191, N'17311', N'MOHS MICROGRAPHIC TECHNIQUE, INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND HISTOPATHOLOGIC PREPARATION INCLUDING ROUTINE STAIN(S) (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE), HEAD, NECK, HANDS, FEET, GENITALIA, OR ANY LOCATION WITH SURGERY DIRECTLY INVOLVING MUSCLE, CARTILAGE, BONE, TENDON, MAJOR NERVES, OR VESSELS; FIRST STAGE, UP TO 5 TISSUE BLOCKS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2192, N'17263', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), TRUNK, ARMS OR LEGS; LESION DIAMETER 2.1 TO 3.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2193, N'17314', N'MOHS MICROGRAPHIC TECHNIQUE, INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND HISTOPATHOLOGIC PREPARATION INCLUDING ROUTINE STAIN(S) (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE), OF THE TRUNK, ARMS, OR LEGS; EACH ADDITIONAL STAGE AFTER THE FIRST STAGE, UP TO 5 TISSUE BLOCKS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2194, N'17272', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER 1.1 TO 2.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2195, N'17315', N'MOHS MICROGRAPHIC TECHNIQUE, INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND HISTOPATHOLOGIC PREPARATION INCLUDING ROUTINE STAIN(S) (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE), EACH ADDITIONAL BLOCK AFTER THE FIRST 5 TISSUE BLOCKS, ANY STAGE (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2196, N'17274', N'DESTRUCTION, MALIGNANT LESION (EG, LASER SURGERY, ELECTROSURGERY, CRYOSURGERY, CHEMOSURGERY, SURGICAL CURETTEMENT), SCALP, NECK, HANDS, FEET, GENITALIA; LESION DIAMETER 3.1 TO 4.0 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2197, N'17380', N'ELECTROLYSIS EPILATION, EACH 1/2 HOUR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2198, N'17999', N'UNLISTED PROCEDURE, SKIN, MUCOUS MEMBRANE AND SUBCUTANEOUS TISSUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2199, N'19100', N'BIOPSY OF BREAST; PERCUTANEOUS, NEEDLE CORE, NOT USING IMAGING GUIDANCE (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2200, N'17340', N'CRYOTHERAPY (CO2 SLUSH, LIQUID N2) FOR ACNE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2201, N'19020', N'MASTOTOMY WITH EXPLORATION OR DRAINAGE OF ABSCESS, DEEP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2202, N'19103', N'BIOPSY OF BREAST; PERCUTANEOUS, AUTOMATED VACUUM ASSISTED OR ROTATING BIOPSY DEVICE, USING IMAGING GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2203, N'17360', N'CHEMICAL EXFOLIATION FOR ACNE (EG, ACNE PASTE, ACID)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2204, N'19000', N'PUNCTURE ASPIRATION OF CYST OF BREAST;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2205, N'19001', N'PUNCTURE ASPIRATION OF CYST OF BREAST; EACH ADDITIONAL CYST (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2206, N'19110', N'NIPPLE EXPLORATION, WITH OR WITHOUT EXCISION OF A SOLITARY LACTIFEROUS DUCT OR A PAPILLOMA LACTIFEROUS DUCT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2207, N'19160', N'MASTECTOMY, PARTIAL (EG, LUMPECTOMY, TYLECTOMY, QUADRANTECTOMY,          SEGMENTECTOMY);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2208, N'19105', N'ABLATION, CRYOSURGICAL, OF FIBROADENOMA, INCLUDING ULTRASOUND GUIDANCE, EACH FIBROADENOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2209, N'19125', N'EXCISION OF BREAST LESION IDENTIFIED BY PREOPERATIVE PLACEMENT OF RADIOLOGICAL MARKER, OPEN; SINGLE LESION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2210, N'17307', N'CHEMOSURGERY (MOHS MICROGRAPHIC TECHNIQUE), INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND COMPLETE HISTOPATHOLOGIC PREPARATION INCLUDING THE FIRST ROUTINE STAIN (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE); ADDITIONAL STAGE(S), UP TO 5 SPECIMENS, EACH STAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2211, N'19030', N'INJECTION PROCEDURE ONLY FOR MAMMARY DUCTOGRAM OR GALACTOGRAM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1200 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2212, N'19101', N'BIOPSY OF BREAST; OPEN, INCISIONAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2213, N'19112', N'EXCISION OF LACTIFEROUS DUCT FISTULA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2214, N'17312', N'MOHS MICROGRAPHIC TECHNIQUE, INCLUDING REMOVAL OF ALL GROSS TUMOR, SURGICAL EXCISION OF TISSUE SPECIMENS, MAPPING, COLOR CODING OF SPECIMENS, MICROSCOPIC EXAMINATION OF SPECIMENS BY THE SURGEON, AND HISTOPATHOLOGIC PREPARATION INCLUDING ROUTINE STAIN(S) (EG, HEMATOXYLIN AND EOSIN, TOLUIDINE BLUE), HEAD, NECK, HANDS, FEET, GENITALIA, OR ANY LOCATION WITH SURGERY DIRECTLY INVOLVING MUSCLE, CARTILAGE, BONE, TENDON, MAJOR NERVES, OR VESSELS; EACH ADDITIONAL STAGE AFTER THE FIRST STAGE, UP TO 5 TISSUE BLOCKS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2215, N'19126', N'EXCISION OF BREAST LESION IDENTIFIED BY PREOPERATIVE PLACEMENT OF RADIOLOGICAL MARKER, OPEN; EACH ADDITIONAL LESION SEPARATELY IDENTIFIED BY A PREOPERATIVE RADIOLOGICAL MARKER (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2216, N'19102', N'BIOPSY OF BREAST; PERCUTANEOUS, NEEDLE CORE, USING IMAGING GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2217, N'19120', N'EXCISION OF CYST, FIBROADENOMA, OR OTHER BENIGN OR MALIGNANT TUMOR, ABERRANT BREAST TISSUE, DUCT LESION, NIPPLE OR AREOLAR LESION (EXCEPT 19300), OPEN, MALE OR FEMALE, 1 OR MORE LESIONS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2218, N'19140', N'MASTECTOMY FOR GYNECOMASTIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2219, N'19162', N'MASTECTOMY, PARTIAL; WITH AXILLARY LYMPHADENECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2220, N'19182', N'MASTECTOMY, SUBCUTANEOUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2221, N'19271', N'EXCISION OF CHEST WALL TUMOR INVOLVING RIBS, WITH PLASTIC RECONSTRUCTION; WITHOUT MEDIASTINAL LYMPHADENECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2222, N'19297', N'PLACEMENT OF RADIOTHERAPY AFTERLOADING EXPANDABLE CATHETER (SINGLE OR MULTICHANNEL) INTO THE BREAST FOR INTERSTITIAL RADIOELEMENT APPLICATION FOLLOWING PARTIAL MASTECTOMY, INCLUDES IMAGING GUIDANCE; CONCURRENT WITH PARTIAL MASTECTOMY (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2223, N'19260', N'EXCISION OF CHEST WALL TUMOR INCLUDING RIBS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2224, N'19272', N'EXCISION OF CHEST WALL TUMOR INVOLVING RIBS, WITH PLASTIC RECONSTRUCTION; WITH MEDIASTINAL LYMPHADENECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2225, N'19300', N'MASTECTOMY FOR GYNECOMASTIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2226, N'19302', N'MASTECTOMY, PARTIAL (EG, LUMPECTOMY, TYLECTOMY, QUADRANTECTOMY, SEGMENTECTOMY); WITH AXILLARY LYMPHADENECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2227, N'19296', N'PLACEMENT OF RADIOTHERAPY AFTERLOADING EXPANDABLE CATHETER (SINGLE OR MULTICHANNEL) INTO THE BREAST FOR INTERSTITIAL RADIOELEMENT APPLICATION FOLLOWING PARTIAL MASTECTOMY, INCLUDES IMAGING GUIDANCE; ON DATE SEPARATE FROM PARTIAL MASTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2228, N'19304', N'MASTECTOMY, SUBCUTANEOUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2229, N'19316', N'MASTOPEXY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2230, N'19340', N'IMMEDIATE INSERTION OF BREAST PROSTHESIS FOLLOWING MASTOPEXY, MASTECTOMY OR IN RECONSTRUCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2231, N'19361', N'BREAST RECONSTRUCTION WITH LATISSIMUS DORSI FLAP, WITHOUT PROSTHETIC IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2232, N'19368', N'BREAST RECONSTRUCTION WITH TRANSVERSE RECTUS ABDOMINIS MYOCUTANEOUS FLAP (TRAM), SINGLE PEDICLE, INCLUDING CLOSURE OF DONOR SITE; WITH MICROVASCULAR ANASTOMOSIS (SUPERCHARGING)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2233, N'19298', N'PLACEMENT OF RADIOTHERAPY AFTERLOADING BRACHYTHERAPY CATHETERS (MULTIPLE TUBE AND BUTTON TYPE) INTO THE BREAST FOR INTERSTITIAL RADIOELEMENT      APPLICATION FOLLOWING (AT THE TIME OF OR SUBSEQUENT TO) PARTIAL          MASTECTOMY, INCLUDES IMAGING GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2234, N'19380', N'REVISION OF RECONSTRUCTED BREAST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2235, N'19499', N'UNLISTED PROCEDURE, BREAST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2236, N'20102', N'EXPLORATION OF PENETRATING WOUND (SEPARATE PROCEDURE); ABDOMEN/FLANK/BACK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2237, N'19324', N'MAMMAPLASTY, AUGMENTATION; WITHOUT PROSTHETIC IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2238, N'19325', N'MAMMAPLASTY, AUGMENTATION; WITH PROSTHETIC IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2239, N'19328', N'REMOVAL OF INTACT MAMMARY IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2240, N'20103', N'EXPLORATION OF PENETRATING WOUND (SEPARATE PROCEDURE); EXTREMITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2241, N'20150', N'EXCISION OF EPIPHYSEAL BAR, WITH OR WITHOUT AUTOGENOUS SOFT TISSUE GRAFT OBTAINED THROUGH SAME FASCIAL INCISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2242, N'19355', N'CORRECTION OF INVERTED NIPPLES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2243, N'19360', N'BREAST RECONSTRUCTION WITH MUSCLE OR MYOCUTANEOUS FLAP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2244, N'19369', N'BREAST RECONSTRUCTION WITH TRANSVERSE RECTUS ABDOMINIS MYOCUTANEOUS FLAP (TRAM), DOUBLE PEDICLE, INCLUDING CLOSURE OF DONOR SITE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2245, N'19240', N'MASTECTOMY, MODIFIED RADICAL, INCLUDING AXILLARY LYMPH NODES, WITH OR WITHOUT PECTORALIS MINOR MUSCLE, BUT EXCLUDING PECTORALIS MAJOR MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2246, N'19370', N'OPEN PERIPROSTHETIC CAPSULOTOMY, BREAST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2247, N'19371', N'PERIPROSTHETIC CAPSULECTOMY, BREAST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2248, N'20000', N'INCISION OF SOFT TISSUE ABSCESS (EG, SECONDARY TO OSTEOMYELITIS); SUPERFICIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2249, N'2022F', N'DILATED RETINAL EYE EXAM WITH INTERPRETATION BY AN OPHTHALMOLOGIST OR OPTOMETRIST DOCUMENTED AND REVIEWED (DM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2250, N'2026F', N'EYE IMAGING VALIDATED TO MATCH DIAGNOSIS FROM 7 STANDARD FIELD STEREOSCOPIC PHOTOS RESULTS DOCUMENTED AND REVIEWED (DM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2251, N'20005', N'INCISION AND DRAINAGE OF SOFT TISSUE ABSCESS, SUBFASCIAL (IE, INVOLVES THE SOFT TISSUE BELOW THE DEEP FASCIA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2252, N'20101', N'EXPLORATION OF PENETRATING WOUND (SEPARATE PROCEDURE); CHEST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2253, N'19295', N'IMAGE GUIDED PLACEMENT, METALLIC LOCALIZATION CLIP, PERCUTANEOUS, DURING BREAST BIOPSY/ASPIRATION (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2254, N'19180', N'MASTECTOMY, SIMPLE, COMPLETE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2255, N'19200', N'MASTECTOMY, RADICAL, INCLUDING PECTORAL MUSCLES, AXILLARY LYMPH NODES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2256, N'19220', N'MASTECTOMY, RADICAL, INCLUDING PECTORAL MUSCLES, AXILLARY AND INTERNAL MAMMARY LYMPH NODES (URBAN TYPE OPERATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2257, N'19301', N'MASTECTOMY, PARTIAL (EG, LUMPECTOMY, TYLECTOMY, QUADRANTECTOMY, SEGMENTECTOMY);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2258, N'19303', N'MASTECTOMY, SIMPLE, COMPLETE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2259, N'2027F', N'OPTIC NERVE HEAD EVALUATION PERFORMED (EC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2260, N'2031F', N'HYDRATION STATUS DOCUMENTED, DEHYDRATED (PAG)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2261, N'20526', N'INJECTION, THERAPEUTIC (EG, LOCAL ANESTHETIC, CORTICOSTEROID), CARPAL TUNNEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2262, N'19290', N'PREOPERATIVE PLACEMENT OF NEEDLE LOCALIZATION WIRE, BREAST;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2263, N'19291', N'PREOPERATIVE PLACEMENT OF NEEDLE LOCALIZATION WIRE, BREAST; EACH ADDITIONAL LESION (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2264, N'20551', N'INJECTION(S); SINGLE TENDON ORIGIN/INSERTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2265, N'20552', N'INJECTION(S); SINGLE OR MULTIPLE TRIGGER POINT(S), 1 OR 2 MUSCLE(S) GROUP(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2266, N'19306', N'MASTECTOMY, RADICAL, INCLUDING PECTORAL MUSCLES, AXILLARY AND INTERNAL MAMMARY LYMPH NODES (URBAN TYPE OPERATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2267, N'19318', N'REDUCTION MAMMAPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2268, N'20553', N'INJECTION(S); SINGLE OR MULTIPLE TRIGGER POINT(S), 3 OR MORE MUSCLE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2269, N'20555', N'PLACEMENT OF NEEDLES OR CATHETERS INTO MUSCLE AND/OR SOFT TISSUE FOR SUBSEQUENT INTERSTITIAL RADIOELEMENT APPLICATION (AT THE TIME OF OR SUBSEQUENT TO THE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2270, N'20206', N'BIOPSY, MUSCLE, PERCUTANEOUS NEEDLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2271, N'2021F', N'DILATED MACULAR OR FUNDUS EXAM PERFORMED, INCLUDING DOCUMENTATION OF THE PRESENCE OR ABSENCE OF MACULAR EDEMA AND LEVEL OF SEVERITY OF RETINOPATHY (EC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2272, N'19305', N'MASTECTOMY, RADICAL, INCLUDING PECTORAL MUSCLES, AXILLARY LYMPH NODES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2273, N'19307', N'MASTECTOMY, MODIFIED RADICAL, INCLUDING AXILLARY LYMPH NODES, WITH OR WITHOUT PECTORALIS MINOR MUSCLE, BUT EXCLUDING PECTORALIS MAJOR MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2274, N'20240', N'BIOPSY, BONE, OPEN; SUPERFICIAL (EG, ILIUM, STERNUM, SPINOUS PROCESS, RIBS, TROCHANTER OF FEMUR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2275, N'20250', N'BIOPSY, VERTEBRAL BODY, OPEN; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2276, N'19330', N'REMOVAL OF MAMMARY IMPLANT MATERIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2277, N'19362', N'BREAST RECONSTRUCTION WITH TRANSVERSE RECTUS ABDOMINIS FLAP (TRAM), INCLUDING CLOSURE OF DONOR SITE, SINGLE OR DOUBLE PEDICLE, WITH OR WITHOUT MICROVASCULAR ANASTOMOSIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2278, N'20600', N'ARTHROCENTESIS, ASPIRATION AND/OR INJECTION; SMALL JOINT OR BURSA (EG, FINGERS, TOES)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2279, N'20661', N'APPLICATION OF HALO, INCLUDING REMOVAL; CRANIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2280, N'19366', N'BREAST RECONSTRUCTION WITH OTHER TECHNIQUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2281, N'20010', N'INCISION OF SOFT TISSUE ABSCESS (EG, SECONDARY TO OSTEOMYELITIS); WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2282, N'2028F', N'FOOT EXAMINATION PERFORMED (INCLUDES EXAMINATION THROUGH VISUAL INSPECTION, SENSORY EXAM WITH MONOFILAMENT, AND PULSE EXAM - REPORT WHEN ANY OF THE 3 COMPONENTS ARE COMPLETED) (DM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2283, N'2001F', N'WEIGHT RECORDED (HF, PAG)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2284, N'2002F', N'CLINICAL SIGNS OF VOLUME OVERLOAD (EXCESS) ASSESSED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2285, N'2003F', N'AUSCULTATION OF THE HEART PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2286, N'2029F', N'COMPLETE PHYSICAL SKIN EXAM PERFORMED (ML)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2287, N'2030F', N'HYDRATION STATUS DOCUMENTED, NORMALLY HYDRATED (PAG)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2288, N'2040F', N'PHYSICAL EXAMINATION ON THE DATE OF THE INITIAL VISIT FOR LOW BACK PAIN PERFORMED, IN ACCORDANCE WITH SPECIFICATIONS (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2289, N'20670', N'REMOVAL OF IMPLANT; SUPERFICIAL, (EG, BURIED WIRE, PIN OR ROD) (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2290, N'20691', N'APPLICATION OF EXTERNAL FIXATION SYSTEM (EG, HOFFMANN APPARATUS); OTHER THAN STANDARD CONFIGURATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2291, N'20824', N'REPLANTATION, THUMB (INCLUDES CARPOMETACARPAL JOINT TO MP JOINT), COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2292, N'20826', N'REPLANTATION, THUMB (INCLUDES CARPOMETACARPAL JOINT TO MP JOINT); INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2293, N'19342', N'DELAYED INSERTION OF BREAST PROSTHESIS FOLLOWING MASTOPEXY, MASTECTOMY OR IN RECONSTRUCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2294, N'19350', N'NIPPLE/AREOLA RECONSTRUCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2295, N'20912', N'CARTILAGE GRAFT; NASAL SEPTUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2296, N'20950', N'MONITORING OF INTERSTITIAL FLUID PRESSURE (INCLUDES INSERTION OF DEVICE, EG, WICK CATHETER TECHNIQUE, NEEDLE MANOMETER TECHNIQUE) IN DETECTION OF MUSCLE COMPARTMENT SYNDROME', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2297, N'19357', N'BREAST RECONSTRUCTION, IMMEDIATE OR DELAYED, WITH TISSUE EXPANDER, INCLUDING SUBSEQUENT EXPANSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2298, N'19364', N'BREAST RECONSTRUCTION WITH FREE FLAP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2299, N'20957', N'BONE GRAFT WITH MICROVASCULAR ANASTOMOSIS; METATARSAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2300, N'20999', N'UNLISTED PROCEDURE, MUSCULOSKELETAL SYSTEM, GENERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2301, N'21015', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF FACE OR SCALP; LESS THAN 2 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2302, N'19367', N'BREAST RECONSTRUCTION WITH TRANSVERSE RECTUS ABDOMINIS MYOCUTANEOUS FLAP (TRAM), SINGLE PEDICLE, INCLUDING CLOSURE OF DONOR SITE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2303, N'19396', N'PREPARATION OF MOULAGE FOR CUSTOM BREAST IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2304, N'21029', N'REMOVAL BY CONTOURING OF BENIGN TUMOR OF FACIAL BONE (EG, FIBROUS DYSPLASIA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2305, N'21031', N'EXCISION OF TORUS MANDIBULARIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2306, N'21032', N'EXCISION OF MAXILLARY TORUS PALATINUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2307, N'2050F', N'WOUND CHARACTERISTICS INCLUDING SIZE AND NATURE OF WOUND BASE TISSUE AND AMOUNT OF DRAINAGE PRIOR TO DEBRIDEMENT DOCUMENTED (CWC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2308, N'20527', N'INJECTION, ENZYME (EG, COLLAGENASE), PALMAR FASCIAL CORD (IE, DUPUYTREN''S CONTRACTURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2309, N'21041', N'EXCISION OF BENIGN CYST OR TUMOR OF MANDIBLE; COMPLEX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2310, N'21050', N'CONDYLECTOMY, TEMPOROMANDIBULAR JOINT (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2311, N'20663', N'APPLICATION OF HALO, INCLUDING REMOVAL; FEMORAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2312, N'20665', N'REMOVAL OF TONGS OR HALO APPLIED BY ANOTHER PHYSICIAN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1300 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2313, N'20694', N'REMOVAL, UNDER ANESTHESIA, OF EXTERNAL FIXATION SYSTEM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2314, N'21071', N'CORONOIDECTOMY (SEPARATE PROCEDURE); BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2315, N'21085', N'IMPRESSION AND CUSTOM PREPARATION; ORAL SURGICAL SPLINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2316, N'21110', N'APPLICATION OF INTERDENTAL FIXATION DEVICE FOR CONDITIONS OTHER THAN FRACTURE OR DISLOCATION, INCLUDES REMOVAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2317, N'2000F', N'BLOOD PRESSURE MEASURED (CAD, CKD, HF, HTN)(DM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2318, N'20100', N'EXPLORATION OF PENETRATING WOUND (SEPARATE PROCEDURE); NECK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2319, N'21122', N'GENIOPLASTY; SLIDING OSTEOTOMIES, 2 OR MORE OSTEOTOMIES (EG, WEDGE EXCISION OR BONE WEDGE REVERSAL FOR ASYMMETRICAL CHIN)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2320, N'21125', N'AUGMENTATION, MANDIBULAR BODY OR ANGLE; PROSTHETIC MATERIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2321, N'20805', N'REPLANTATION, FOREARM (INCLUDES RADIUS AND ULNA TO RADIAL CARPAL JOINT), COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2322, N'20806', N'REPLANTATION, FOREARM (INCLUDES RADIUS AND ULNA TO RADIAL CARPAL JOINT); INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2323, N'2004F', N'INITIAL EXAMINATION OF THE INVOLVED JOINT(S) (INCLUDES VISUAL INSPECTION, PALPATION, RANGE OF MOTION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2324, N'2014F', N'MENTAL STATUS ASSESSED (CAP) (EM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2325, N'2015F', N'ASTHMA IMPAIRMENT ASSESSED (ASTHMA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2326, N'2018F', N'HYDRATION STATUS ASSESSED (NORMAL/MILDLY DEHYDRATED/SEVERELY DEHYDRATED)(CAP1)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2327, N'2010F', N'VITAL SIGNS (TEMPERATURE, PULSE, RESPIRATORY RATE, AND BLOOD PRESSURE) DOCUMENTED AND REVIEWED (CAP) (EM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2328, N'2016F', N'ASTHMA RISK ASSESSED (ASTHMA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2329, N'20812', N'REPLANTATION, HAND (INCLUDES HAND THROUGH METACARPOPHALANGEAL JOINTS); INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2330, N'21137', N'REDUCTION FOREHEAD; CONTOURING ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2331, N'21139', N'REDUCTION FOREHEAD; CONTOURING AND SETBACK OF ANTERIOR FRONTAL SINUS WALL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2332, N'20816', N'REPLANTATION, DIGIT, EXCLUDING THUMB (INCLUDES METACARPOPHALANGEAL JOINT TO INSERTION OF FLEXOR SUBLIMIS TENDON), COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2333, N'21141', N'RECONSTRUCTION MIDFACE, LEFORT I; SINGLE PIECE, SEGMENT MOVEMENT IN ANY DIRECTION (EG, FOR LONG FACE SYNDROME), WITHOUT BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2334, N'21147', N'RECONSTRUCTION MIDFACE, LEFORT I; 3 OR MORE PIECES, SEGMENT MOVEMENT IN ANY DIRECTION, REQUIRING BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS) (EG, UNGRAFTED BILATERAL ALVEOLAR CLEFT OR MULTIPLE OSTEOTOMIES)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2335, N'20820', N'REPLANTATION, DIGIT, EXCLUDING THUMB (INCLUDES METACARPOPHALANGEAL JOINT TO INSERTION OF FLEXOR SUBLIMIS TENDON); INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2336, N'21183', N'RECONSTRUCTION OF ORBITAL WALLS, RIMS, FOREHEAD, NASOETHMOID COMPLEX FOLLOWING INTRA- AND EXTRACRANIAL EXCISION OF BENIGN TUMOR OF CRANIAL BONE (EG, FIBROUS DYSPLASIA), WITH MULTIPLE AUTOGRAFTS (INCLUDES OBTAINING GRAFTS); TOTAL AREA OF BONE GRAFTING GREATER THAN 40 SQ CM BUT LESS THAN 80 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2337, N'20823', N'REPLANTATION, DIGIT, EXCLUDING THUMB (INCLUDES DISTAL TIP TO SUBLIMIS TENDON INSERTION); INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2338, N'21184', N'RECONSTRUCTION OF ORBITAL WALLS, RIMS, FOREHEAD, NASOETHMOID COMPLEX FOLLOWING INTRA- AND EXTRACRANIAL EXCISION OF BENIGN TUMOR OF CRANIAL BONE (EG, FIBROUS DYSPLASIA), WITH MULTIPLE AUTOGRAFTS (INCLUDES OBTAINING GRAFTS); TOTAL AREA OF BONE GRAFTING GREATER THAN 80 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2339, N'20828', N'REPLANTATION, THUMB (INCLUDES DISTAL TIP TO MP JOINT); INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2340, N'20838', N'REPLANTATION, FOOT, COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2341, N'2019F', N'DILATED MACULAR EXAM PERFORMED, INCLUDING DOCUMENTATION OF THE PRESENCE OR ABSENCE OF MACULAR THICKENING OR HEMORRHAGE AND THE LEVEL OF MACULAR DEGENERATION SEVERITY (EC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2342, N'20900', N'BONE GRAFT, ANY DONOR AREA; MINOR OR SMALL (EG, DOWEL OR BUTTON)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2343, N'20902', N'BONE GRAFT, ANY DONOR AREA; MAJOR OR LARGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2344, N'20910', N'CARTILAGE GRAFT; COSTOCHONDRAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2345, N'20220', N'BIOPSY, BONE, TROCAR, OR NEEDLE; SUPERFICIAL (EG, ILIUM, STERNUM, SPINOUS PROCESS, RIBS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2346, N'2024F', N'7 STANDARD FIELD STEREOSCOPIC PHOTOS WITH INTERPRETATION BY AN OPHTHALMOLOGIST OR OPTOMETRIST DOCUMENTED AND REVIEWED (DM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2347, N'20936', N'AUTOGRAFT FOR SPINE SURGERY ONLY (INCLUDES HARVESTING THE GRAFT); LOCAL (EG, RIBS, SPINOUS PROCESS, OR LAMINAR FRAGMENTS) OBTAINED FROM SAME INCISION (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2348, N'21188', N'RECONSTRUCTION MIDFACE, OSTEOTOMIES (OTHER THAN LEFORT TYPE) AND BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2349, N'21195', N'RECONSTRUCTION OF MANDIBULAR RAMI AND/OR BODY, SAGITTAL SPLIT; WITHOUT INTERNAL RIGID FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2350, N'21196', N'RECONSTRUCTION OF MANDIBULAR RAMI AND/OR BODY, SAGITTAL SPLIT; WITH INTERNAL RIGID FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2351, N'21199', N'OSTEOTOMY, MANDIBLE, SEGMENTAL; WITH GENIOGLOSSUS ADVANCEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2352, N'20937', N'AUTOGRAFT FOR SPINE SURGERY ONLY (INCLUDES HARVESTING THE GRAFT); MORSELIZED (THROUGH SEPARATE SKIN OR FASCIAL INCISION) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2353, N'20251', N'BIOPSY, VERTEBRAL BODY, OPEN; LUMBAR OR CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2354, N'20520', N'REMOVAL OF FOREIGN BODY IN MUSCLE OR TENDON SHEATH; SIMPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2355, N'20525', N'REMOVAL OF FOREIGN BODY IN MUSCLE OR TENDON SHEATH; DEEP OR COMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2356, N'20938', N'AUTOGRAFT FOR SPINE SURGERY ONLY (INCLUDES HARVESTING THE GRAFT); STRUCTURAL, BICORTICAL OR TRICORTICAL (THROUGH SEPARATE SKIN OR FASCIAL INCISION) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2357, N'20550', N'INJECTION(S); SINGLE TENDON SHEATH, OR LIGAMENT, APONEUROSIS (EG, PLANTAR FASCIA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2358, N'20552', N'INJECTION(S); SINGLE OR MULTIPLE TRIGGER POINT(S), 1 OR 2 MUSCLE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2359, N'21204', N'OSTEOTOMY (EG, FOR PROGNATHISM, MICROGNATHISM, APERTOGNATHISM OR FOR RECONSTRUCTION); MAXILLA, TOTAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2360, N'21209', N'OSTEOPLASTY, FACIAL BONES; REDUCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2361, N'20955', N'BONE GRAFT WITH MICROVASCULAR ANASTOMOSIS; FIBULA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2362, N'20962', N'BONE GRAFT WITH MICROVASCULAR ANASTOMOSIS; OTHER THAN FIBULA, ILIAC CREST, OR METATARSAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2363, N'21215', N'GRAFT, BONE; MANDIBLE (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2364, N'21245', N'RECONSTRUCTION OF MANDIBLE OR MAXILLA, SUBPERIOSTEAL IMPLANT; PARTIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2365, N'20971', N'FREE OSTEOCUTANEOUS FLAP WITH MICROVASCULAR ANASTOMOSIS; RIB', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2366, N'20973', N'FREE OSTEOCUTANEOUS FLAP WITH MICROVASCULAR ANASTOMOSIS; GREAT TOE WITH WEB SPACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2367, N'21246', N'RECONSTRUCTION OF MANDIBLE OR MAXILLA, SUBPERIOSTEAL IMPLANT; COMPLETE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2368, N'21250', N'OSTEOPLASTY OF MAXILLA AND/OR OTHER FACIAL BONES FOR MIDFACE HYPOPLASIA OR RETRUSION (LEFORT TYPE OPERATION); WITHOUT BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2369, N'20975', N'ELECTRICAL STIMULATION TO AID BONE HEALING; INVASIVE (OPERATIVE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2370, N'20976', N'ELECTRICAL STIMULATION TO AID BONE HEALING; PERCUTANEOUS INSERTION OF ELECTRODES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2371, N'21254', N'OSTEOPLASTY OF MAXILLA AND/OR OTHER FACIAL BONES FOR MIDFACE HYPOPLASIA OR RETRUSION (LEFORT TYPE OPERATION); WITH BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2372, N'21256', N'RECONSTRUCTION OF ORBIT WITH OSTEOTOMIES (EXTRACRANIAL) AND WITH BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS) (EG, MICRO-OPHTHALMIA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2373, N'20986', N'COMPUTER-ASSISTED SURGICAL NAVIGATIONAL PROCEDURE FOR MUSCULOSKELETAL PROCEDURES; WITH IMAGE GUIDANCE BASED ON INTRAOPERATIVELY OBTAINED IMAGES (EG, FLUOROSCOPY, ULTRASOUND) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2374, N'21260', N'PERIORBITAL OSTEOTOMIES FOR ORBITAL HYPERTELORISM, WITH BONE GRAFTS; EXTRACRANIAL APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2375, N'21263', N'PERIORBITAL OSTEOTOMIES FOR ORBITAL HYPERTELORISM, WITH BONE GRAFTS; WITH FOREHEAD ADVANCEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2376, N'21013', N'EXCISION, TUMOR, SOFT TISSUE OF FACE AND SCALP, SUBFASCIAL (EG, SUBGALEAL, INTRAMUSCULAR); LESS THAN 2 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2377, N'21014', N'EXCISION, TUMOR, SOFT TISSUE OF FACE AND SCALP, SUBFASCIAL (EG, SUBGALEAL, INTRAMUSCULAR); 2 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2378, N'21016', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF FACE OR SCALP; 2 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2379, N'21025', N'EXCISION OF BONE (EG, FOR OSTEOMYELITIS OR BONE ABSCESS); MANDIBLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2380, N'21280', N'MEDIAL CANTHOPEXY (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2381, N'21299', N'UNLISTED CRANIOFACIAL AND MAXILLOFACIAL PROCEDURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2382, N'21300', N'CLOSED TREATMENT OF SKULL FRACTURE WITHOUT OPERATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2383, N'21044', N'EXCISION OF MALIGNANT TUMOR OF MANDIBLE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2384, N'21049', N'EXCISION OF BENIGN TUMOR OR CYST OF MAXILLA; REQUIRING EXTRA-ORAL OSTEOTOMY AND PARTIAL MAXILLECTOMY (EG, LOCALLY AGGRESSIVE OR DESTRUCTIVE LESION(S))', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2385, N'2060F', N'PATIENT INTERVIEWED DIRECTLY BY EVALUATING CLINICIAN ON OR BEFORE DATE OF DIAGNOSIS OF MAJOR DEPRESSIVE DISORDER (MDD ADOL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2386, N'20615', N'ASPIRATION AND INJECTION FOR TREATMENT OF BONE CYST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2387, N'21060', N'MENISCECTOMY, PARTIAL OR COMPLETE, TEMPOROMANDIBULAR JOINT (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2388, N'21079', N'IMPRESSION AND CUSTOM PREPARATION; INTERIM OBTURATOR PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2389, N'21336', N'OPEN TREATMENT OF NASAL SEPTAL FRACTURE, WITH OR WITHOUT STABILIZATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2390, N'21340', N'PERCUTANEOUS TREATMENT OF NASOETHMOID COMPLEX FRACTURE, WITH SPLINT, WIRE OR HEADCAP FIXATION, INCLUDING REPAIR OF CANTHAL LIGAMENTS AND/OR THE NASOLACRIMAL APPARATUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2391, N'21082', N'IMPRESSION AND CUSTOM PREPARATION; PALATAL AUGMENTATION PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2392, N'21087', N'IMPRESSION AND CUSTOM PREPARATION; NASAL PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2393, N'21345', N'CLOSED TREATMENT OF NASOMAXILLARY COMPLEX FRACTURE (LEFORT II TYPE), WITH INTERDENTAL WIRE FIXATION OR FIXATION OF DENTURE OR SPLINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2394, N'21100', N'APPLICATION OF HALO TYPE APPLIANCE FOR MAXILLOFACIAL FIXATION, INCLUDES REMOVAL (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2395, N'21116', N'INJECTION PROCEDURE FOR TEMPOROMANDIBULAR JOINT ARTHROGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2396, N'21385', N'OPEN TREATMENT OF ORBITAL FLOOR BLOWOUT FRACTURE; TRANSANTRAL APPROACH (CALDWELL-LUC TYPE OPERATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2397, N'21400', N'CLOSED TREATMENT OF FRACTURE OF ORBIT, EXCEPT BLOWOUT; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2398, N'21120', N'GENIOPLASTY; AUGMENTATION (AUTOGRAFT, ALLOGRAFT, PROSTHETIC MATERIAL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2399, N'21127', N'AUGMENTATION, MANDIBULAR BODY OR ANGLE; WITH BONE GRAFT, ONLAY OR INTERPOSITIONAL (INCLUDES OBTAINING AUTOGRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2400, N'21406', N'OPEN TREATMENT OF FRACTURE OF ORBIT, EXCEPT BLOWOUT; WITHOUT IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2401, N'21422', N'OPEN TREATMENT OF PALATAL OR MAXILLARY FRACTURE (LEFORT I TYPE);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2402, N'20200', N'BIOPSY, MUSCLE; SUPERFICIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2403, N'20205', N'BIOPSY, MUSCLE; DEEP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2404, N'2020F', N'DILATED FUNDUS EVALUATION PERFORMED WITHIN 12 MONTHS PRIOR TO CATARACT SURGERY (EC)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2405, N'21431', N'CLOSED TREATMENT OF CRANIOFACIAL SEPARATION (LEFORT III TYPE) USING INTERDENTAL WIRE FIXATION OF DENTURE OR SPLINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2406, N'21432', N'OPEN TREATMENT OF CRANIOFACIAL SEPARATION (LEFORT III TYPE); WITH WIRING AND/OR INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2407, N'21146', N'RECONSTRUCTION MIDFACE, LEFORT I; 2 PIECES, SEGMENT MOVEMENT IN ANY DIRECTION, REQUIRING BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS) (EG, UNGRAFTED UNILATERAL ALVEOLAR CLEFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2408, N'21452', N'PERCUTANEOUS TREATMENT OF MANDIBULAR FRACTURE, WITH EXTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2409, N'21454', N'OPEN TREATMENT OF MANDIBULAR FRACTURE WITH EXTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2410, N'20225', N'BIOPSY, BONE, TROCAR, OR NEEDLE; DEEP (EG, VERTEBRAL BODY, FEMUR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2411, N'20245', N'BIOPSY, BONE, EXCISIONAL; DEEP (EG, HUMERUS, ISCHIUM, FEMUR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2412, N'20650', N'INSERTION OF WIRE OR PIN WITH APPLICATION OF SKELETAL TRACTION, INCLUDING REMOVAL (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2413, N'20660', N'APPLICATION OF CRANIAL TONGS, CALIPER, OR STEREOTACTIC FRAME, INCLUDING REMOVAL (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1400 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2414, N'2035F', N'TYMPANIC MEMBRANE MOBILITY ASSESSED WITH PNEUMATIC OTOSCOPY OR TYMPANOMETRY (OME)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2415, N'2044F', N'DOCUMENTATION OF MENTAL HEALTH ASSESSMENT PRIOR TO INTERVENTION (BACK SURGERY OR EPIDURAL STEROID INJECTION) OR FOR BACK PAIN EPISODE LASTING LONGER THAN 6 WEEKS (BKP)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2416, N'20680', N'REMOVAL OF IMPLANT; DEEP (EG, BURIED WIRE, PIN, SCREW, METAL BAND, NAIL, ROD OR PLATE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2417, N'20690', N'APPLICATION OF A UNIPLANE (PINS OR WIRES IN 1 PLANE), UNILATERAL, EXTERNAL FIXATION SYSTEM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2418, N'21455', N'CLOSED MANIPULATIVE TREATMENT BY INTERDENTAL FIXATION OF CLOSED OR OPEN MANDIBULAR FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2419, N'21470', N'OPEN TREATMENT OF COMPLICATED MANDIBULAR FRACTURE BY MULTIPLE SURGICAL APPROACHES INCLUDING INTERNAL FIXATION, INTERDENTAL FIXATION, AND/OR WIRING OF DENTURES OR SPLINTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2420, N'20693', N'ADJUSTMENT OR REVISION OF EXTERNAL FIXATION SYSTEM REQUIRING ANESTHESIA (EG, NEW PIN[S] OR WIRE[S] AND/OR NEW RING[S] OR BAR[S])', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2421, N'20696', N'APPLICATION OF MULTIPLANE (PINS OR WIRES IN MORE THAN 1 PLANE), UNILATERAL, EXTERNAL FIXATION WITH STEREOTACTIC COMPUTER-ASSISTED ADJUSTMENT (EG, SPATIAL FRAME), INCLUDING IMAGING; INITIAL AND SUBSEQUENT ALIGNMENT(S), ASSESSMENT(S), AND COMPUTATION(S) OF ADJUSTMENT SCHEDULE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2422, N'21485', N'CLOSED TREATMENT OF TEMPOROMANDIBULAR DISLOCATION; COMPLICATED (EG, RECURRENT REQUIRING INTERMAXILLARY FIXATION OR SPLINTING), INITIAL OR SUBSEQUENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2423, N'21150', N'RECONSTRUCTION MIDFACE, LEFORT II; ANTERIOR INTRUSION (EG, TREACHER-COLLINS SYNDROME)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2424, N'21151', N'RECONSTRUCTION MIDFACE, LEFORT II; ANY DIRECTION, REQUIRING BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2425, N'21494', N'CLOSED TREATMENT OF HYOID FRACTURE; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2426, N'21550', N'BIOPSY, SOFT TISSUE OF NECK OR THORAX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2427, N'21555', N'EXCISION, TUMOR, SOFT TISSUE OF NECK OR ANTERIOR THORAX, SUBCUTANEOUS; LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2428, N'21159', N'RECONSTRUCTION MIDFACE, LEFORT III (EXTRA AND INTRACRANIAL) WITH FOREHEAD ADVANCEMENT (EG, MONO BLOC), REQUIRING BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS); WITHOUT LEFORT I', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2429, N'20500', N'INJECTION OF SINUS TRACT; THERAPEUTIC (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2430, N'20501', N'INJECTION OF SINUS TRACT; DIAGNOSTIC (SINOGRAM)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2431, N'20605', N'ARTHROCENTESIS, ASPIRATION AND/OR INJECTION; INTERMEDIATE JOINT OR BURSA (EG, TEMPOROMANDIBULAR, ACROMIOCLAVICULAR, WRIST, ELBOW OR ANKLE, OLECRANON BURSA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2432, N'21175', N'RECONSTRUCTION, BIFRONTAL, SUPERIOR-LATERAL ORBITAL RIMS AND LOWER FOREHEAD, ADVANCEMENT OR ALTERATION (EG, PLAGIOCEPHALY, TRIGONOCEPHALY, BRACHYCEPHALY), WITH OR WITHOUT GRAFTS (INCLUDES OBTAINING AUTOGRAFTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2433, N'21558', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF NECK OR ANTERIOR THORAX; 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2434, N'21615', N'EXCISION FIRST AND/OR CERVICAL RIB;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2435, N'20697', N'APPLICATION OF MULTIPLANE (PINS OR WIRES IN MORE THAN 1 PLANE), UNILATERAL, EXTERNAL FIXATION WITH STEREOTACTIC COMPUTER-ASSISTED ADJUSTMENT (EG, SPATIAL FRAME), INCLUDING IMAGING; EXCHANGE (IE, REMOVAL AND REPLACEMENT) OF STRUT, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2436, N'20822', N'REPLANTATION, DIGIT, EXCLUDING THUMB (INCLUDES DISTAL TIP TO SUBLIMIS TENDON INSERTION), COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2437, N'20840', N'REPLANTATION, FOOT; INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2438, N'21616', N'EXCISION FIRST AND/OR CERVICAL RIB; WITH SYMPATHECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2439, N'21627', N'STERNAL DEBRIDEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2440, N'21685', N'HYOID MYOTOMY AND SUSPENSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2441, N'20610', N'ARTHROCENTESIS, ASPIRATION AND/OR INJECTION; MAJOR JOINT OR BURSA (EG, SHOULDER, HIP, KNEE JOINT, SUBACROMIAL BURSA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2442, N'20612', N'ASPIRATION AND/OR INJECTION OF GANGLION CYST(S) ANY LOCATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2443, N'21720', N'DIVISION OF STERNOCLEIDOMASTOID FOR TORTICOLLIS, OPEN OPERATION; WITHOUT CAST APPLICATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2444, N'21741', N'XIPHOID RESECTION PECTUS EXCAVATUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2445, N'20662', N'APPLICATION OF HALO, INCLUDING REMOVAL; PELVIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2446, N'20664', N'APPLICATION OF HALO, INCLUDING REMOVAL, CRANIAL, 6 OR MORE PINS PLACED, FOR THIN SKULL OSTEOLOGY (EG, PEDIATRIC PATIENTS, HYDROCEPHALUS, OSTEOGENESIS IMPERFECTA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2447, N'21742', N'RECONSTRUCTIVE REPAIR OF PECTUS EXCAVATUM OR CARINATUM; MINIMALLY INVASIVE APPROACH (NUSS PROCEDURE), WITHOUT THORACOSCOPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2448, N'21805', N'OPEN TREATMENT OF RIB FRACTURE WITHOUT FIXATION, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2449, N'20692', N'APPLICATION OF A MULTIPLANE (PINS OR WIRES IN MORE THAN 1 PLANE), UNILATERAL, EXTERNAL FIXATION SYSTEM (EG, ILIZAROV, MONTICELLI TYPE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2450, N'21820', N'CLOSED TREATMENT OF STERNUM FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2451, N'21930', N'EXCISION, TUMOR, SOFT TISSUE OF BACK OR FLANK, SUBCUTANEOUS; LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2452, N'20802', N'REPLANTATION, ARM (INCLUDES SURGICAL NECK OF HUMERUS THROUGH ELBOW JOINT), COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2453, N'20804', N'REPLANTATION, ARM (INCLUDES SURGICAL NECK OF HUMERUS THROUGH ELBOW JOINT); INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2454, N'22030', N'EXCISION, BENIGN TUMOR, SUBCUTANEOUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2455, N'22111', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION) OF VERTEBRAE (EG, FOR OSTEOMYELITIS), CERVICAL; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2456, N'20808', N'REPLANTATION, HAND (INCLUDES HAND THROUGH METACARPOPHALANGEAL JOINTS), COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2457, N'20827', N'REPLANTATION, THUMB (INCLUDES DISTAL TIP TO MP JOINT), COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2458, N'22114', N'PARTIAL EXCISION OF VERTEBRAL BODY, FOR INTRINSIC BONY LESION, WITHOUT DECOMPRESSION OF SPINAL CORD OR NERVE ROOT(S), SINGLE VERTEBRAL SEGMENT; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2459, N'20922', N'FASCIA LATA GRAFT; BY INCISION AND AREA EXPOSURE, COMPLEX OR SHEET', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2460, N'20924', N'TENDON GRAFT, FROM A DISTANCE (EG, PALMARIS, TOE EXTENSOR, PLANTARIS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2461, N'21182', N'RECONSTRUCTION OF ORBITAL WALLS, RIMS, FOREHEAD, NASOETHMOID COMPLEX FOLLOWING INTRA- AND EXTRACRANIAL EXCISION OF BENIGN TUMOR OF CRANIAL BONE (EG, FIBROUS DYSPLASIA), WITH MULTIPLE AUTOGRAFTS (INCLUDES OBTAINING GRAFTS); TOTAL AREA OF BONE GRAFTING LESS THAN 40 SQ CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2462, N'20930', N'ALLOGRAFT, MORSELIZED, OR PLACEMENT OF OSTEOPROMOTIVE MATERIAL, FOR SPINE SURGERY ONLY (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2463, N'21235', N'GRAFT; EAR CARTILAGE, AUTOGENOUS, TO NOSE OR EAR (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2464, N'21240', N'ARTHROPLASTY, TEMPOROMANDIBULAR JOINT, WITH OR WITHOUT AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2465, N'20832', N'REPLANTATION, LEG; COMPLETE AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2466, N'20834', N'REPLANTATION, LEG; INCOMPLETE AMPUTATION (DEVASCULARIZED EXTREMITY WITH SOFT TISSUE PEDICLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2467, N'22121', N'RADICAL RESECTION OF VERTEBRAL BODY OR COMPONENT WITH PRIMARY GRAFTING, INCLUDES OBTAINING GRAFT; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2468, N'22128', N'RADICAL RESECTION OF VERTEBRAL BODY OR COMPONENT WITH PROSTHETIC REPLACEMENT, INCLUDING FABRICATION OF PROSTHESIS; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2469, N'20920', N'FASCIA LATA GRAFT; BY STRIPPER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2470, N'20926', N'TISSUE GRAFTS, OTHER (EG, PARATENON, FAT, DERMIS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2471, N'20931', N'ALLOGRAFT, STRUCTURAL, FOR SPINE SURGERY ONLY (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2472, N'22200', N'OSTEOTOMY OF SPINE FOR CORRECTION FIXED DEFORMITY (NOT SCOLIOSIS), ANTERIOR OR LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2473, N'22212', N'OSTEOTOMY OF SPINE, POSTERIOR OR POSTEROLATERAL APPROACH, 1 VERTEBRAL SEGMENT; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2474, N'21242', N'ARTHROPLASTY, TEMPOROMANDIBULAR JOINT, WITH ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2475, N'21255', N'RECONSTRUCTION OF ZYGOMATIC ARCH AND GLENOID FOSSA WITH BONE AND CARTILAGE (INCLUDES OBTAINING AUTOGRAFTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2476, N'20960', N'BONE GRAFT WITH MICROVASCULAR ANASTOMOSIS; RIB', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2477, N'20969', N'FREE OSTEOCUTANEOUS FLAP WITH MICROVASCULAR ANASTOMOSIS; OTHER THAN ILIAC CREST, METATARSAL, OR GREAT TOE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2478, N'21261', N'PERIORBITAL OSTEOTOMIES FOR ORBITAL HYPERTELORISM, WITH BONE GRAFTS; COMBINED INTRA- AND EXTRACRANIAL APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2479, N'21267', N'ORBITAL REPOSITIONING, PERIORBITAL OSTEOTOMIES, UNILATERAL, WITH BONE GRAFTS; EXTRACRANIAL APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2480, N'22250', N'PROPHYLACTIC TREATMENT (PLATING AND/OR WIRING) WITH OR WITHOUT METHYL METHACRYLATE; LUMBAR SPINE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2481, N'22305', N'CLOSED TREATMENT OF VERTEBRAL PROCESS FRACTURE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2482, N'21270', N'MALAR AUGMENTATION, PROSTHETIC MATERIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2483, N'21282', N'LATERAL CANTHOPEXY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2484, N'21296', N'REDUCTION OF MASSETER MUSCLE AND BONE (EG, FOR TREATMENT OF BENIGN MASSETERIC HYPERTROPHY); INTRAORAL APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2485, N'22328', N'OPEN TREATMENT AND/OR REDUCTION OF VERTEBRAL FRACTURE(S) AND/OR DISLOCATION(S), POSTERIOR APPROACH, 1 FRACTURED VERTEBRA OR DISLOCATED SEGMENT; EACH ADDITIONAL FRACTURED VERTEBRA OR DISLOCATED SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2486, N'21325', N'OPEN TREATMENT OF NASAL FRACTURE; UNCOMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2487, N'21335', N'OPEN TREATMENT OF NASAL FRACTURE; WITH CONCOMITANT OPEN TREATMENT OF FRACTURED SEPTUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2488, N'22345', N'OPEN TREATMENT AND FUSION, CERVICAL SPINE; ANTERIOR APPROACH, WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT) FOR FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2489, N'21338', N'OPEN TREATMENT OF NASOETHMOID FRACTURE; WITHOUT EXTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2490, N'21343', N'OPEN TREATMENT OF DEPRESSED FRONTAL SINUS FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2491, N'22355', N'OPEN TREATMENT AND FUSION, POSTERIOR APPROACH, WITH LOCAL BONE GRAFT AND/OR INTERNAL FIXATION FOR FRACTURE; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2492, N'22356', N'OPEN TREATMENT AND FUSION, POSTERIOR APPROACH, WITH LOCAL BONE GRAFT AND/OR INTERNAL FIXATION FOR FRACTURE; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2493, N'21348', N'OPEN TREATMENT OF NASOMAXILLARY COMPLEX FRACTURE (LEFORT II TYPE); WITH BONE GRAFTING (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2494, N'21356', N'OPEN TREATMENT OF DEPRESSED ZYGOMATIC ARCH FRACTURE (EG, GILLIES APPROACH)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2495, N'20970', N'FREE OSTEOCUTANEOUS FLAP WITH MICROVASCULAR ANASTOMOSIS; ILIAC CREST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2496, N'20974', N'ELECTRICAL STIMULATION TO AID BONE HEALING; NONINVASIVE (NONOPERATIVE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2497, N'20956', N'BONE GRAFT WITH MICROVASCULAR ANASTOMOSIS; ILIAC CREST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2498, N'20972', N'FREE OSTEOCUTANEOUS FLAP WITH MICROVASCULAR ANASTOMOSIS; METATARSAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2499, N'20982', N'ABLATION, BONE TUMOR(S) (EG, OSTEOID OSTEOMA, METASTASIS) RADIOFREQUENCY, PERCUTANEOUS, INCLUDING COMPUTED TOMOGRAPHIC GUIDANCE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2500, N'21010', N'ARTHROTOMY, TEMPOROMANDIBULAR JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2501, N'20979', N'LOW INTENSITY ULTRASOUND STIMULATION TO AID BONE HEALING, NONINVASIVE (NONOPERATIVE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2502, N'20985', N'COMPUTER-ASSISTED SURGICAL NAVIGATIONAL PROCEDURE FOR MUSCULOSKELETAL PROCEDURES, IMAGE-LESS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2503, N'21012', N'EXCISION, TUMOR, SOFT TISSUE OF FACE OR SCALP, SUBCUTANEOUS; 2 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2504, N'21026', N'EXCISION OF BONE (EG, FOR OSTEOMYELITIS OR BONE ABSCESS); FACIAL BONE(S)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2505, N'22360', N'OPEN TREATMENT AND FUSION, POSTERIOR APPROACH WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT), FOR FRACTURE; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2506, N'21365', N'OPEN TREATMENT OF COMPLICATED (EG, COMMINUTED OR INVOLVING CRANIAL NERVE FORAMINA) FRACTURE(S) OF MALAR AREA, INCLUDING ZYGOMATIC ARCH AND MALAR TRIPOD; WITH INTERNAL FIXATION AND MULTIPLE SURGICAL APPROACHES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2507, N'22379', N'HARRINGTON ROD TECHNIQUE LIST SEPARATELY IN ADDITION TO CODE FOR FRACTURE AND/OR DISLOCATION OF THE SPINE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2508, N'22505', N'MANIPULATION OF SPINE REQUIRING ANESTHESIA, ANY REGION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2509, N'21387', N'OPEN TREATMENT OF ORBITAL FLOOR BLOWOUT FRACTURE; COMBINED APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2510, N'21390', N'OPEN TREATMENT OF ORBITAL FLOOR BLOWOUT FRACTURE; PERIORBITAL APPROACH, WITH ALLOPLASTIC OR OTHER IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2511, N'20987', N'COMPUTER-ASSISTED SURGICAL NAVIGATIONAL PROCEDURE FOR MUSCULOSKELETAL PROCEDURES; WITH IMAGE GUIDANCE BASED ON PREOPERATIVE IMAGES (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2512, N'21395', N'OPEN TREATMENT OF ORBITAL FLOOR BLOWOUT FRACTURE; PERIORBITAL APPROACH WITH BONE GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2513, N'21445', N'OPEN TREATMENT OF MANDIBULAR OR MAXILLARY ALVEOLAR RIDGE FRACTURE (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2514, N'21011', N'EXCISION, TUMOR, SOFT TISSUE OF FACE OR SCALP, SUBCUTANEOUS; LESS THAN 2 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1500 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2515, N'21020', N'CRANIECTOMY FOR SEQUESTRECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2516, N'21045', N'EXCISION OF MALIGNANT TUMOR OF MANDIBLE; RADICAL RESECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2517, N'21030', N'EXCISION OF BENIGN TUMOR OR CYST OF MAXILLA OR ZYGOMA BY ENUCLEATION AND CURETTAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2518, N'21034', N'EXCISION OF MALIGNANT TUMOR OF MAXILLA OR ZYGOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2519, N'21048', N'EXCISION OF BENIGN TUMOR OR CYST OF MAXILLA; REQUIRING INTRA-ORAL OSTEOTOMY (EG, LOCALLY AGGRESSIVE OR DESTRUCTIVE LESION(S))', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2520, N'21051', N'ARTHRECTOMY, TEMPOROMANDIBULAR JOINT; BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2521, N'21040', N'EXCISION OF BENIGN TUMOR OR CYST OF MANDIBLE, BY ENUCLEATION AND/OR CURETTAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2522, N'21046', N'EXCISION OF BENIGN TUMOR OR CYST OF MANDIBLE; REQUIRING INTRA-ORAL OSTEOTOMY (EG, LOCALLY AGGRESSIVE OR DESTRUCTIVE LESION(S))', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2523, N'21070', N'CORONOIDECTOMY (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2524, N'21077', N'IMPRESSION AND CUSTOM PREPARATION; ORBITAL PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2525, N'21080', N'IMPRESSION AND CUSTOM PREPARATION; DEFINITIVE OBTURATOR PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2526, N'21450', N'CLOSED TREATMENT OF MANDIBULAR FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2527, N'21499', N'UNLISTED MUSCULOSKELETAL PROCEDURE, HEAD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2528, N'21501', N'INCISION AND DRAINAGE, DEEP ABSCESS OR HEMATOMA, SOFT TISSUES OF NECK OR THORAX;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2529, N'21086', N'IMPRESSION AND CUSTOM PREPARATION; AURICULAR PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2530, N'21088', N'IMPRESSION AND CUSTOM PREPARATION; FACIAL PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2531, N'21610', N'COSTOTRANSVERSECTOMY (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2532, N'21633', N'RADICAL RESECTION OF STERNUM; FOR OSTEOMYELITIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2533, N'21705', N'DIVISION OF SCALENUS ANTICUS; WITH RESECTION OF CERVICAL RIB', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2534, N'21089', N'UNLISTED MAXILLOFACIAL PROSTHETIC PROCEDURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2535, N'21142', N'RECONSTRUCTION MIDFACE, LEFORT I; 2 PIECES, SEGMENT MOVEMENT IN ANY DIRECTION, WITHOUT BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2536, N'22522', N'PERCUTANEOUS VERTEBROPLASTY, 1 VERTEBRAL BODY, UNILATERAL OR BILATERAL INJECTION; EACH ADDITIONAL THORACIC OR LUMBAR VERTEBRAL BODY (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2537, N'21145', N'RECONSTRUCTION MIDFACE, LEFORT I; SINGLE PIECE, SEGMENT MOVEMENT IN ANY DIRECTION, REQUIRING BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2538, N'22524', N'PERCUTANEOUS VERTEBRAL AUGMENTATION, INCLUDING CAVITY CREATION (FRACTURE REDUCTION AND BONE BIOPSY INCLUDED WHEN PERFORMED) USING MECHANICAL DEVICE, 1 VERTEBRAL BODY, UNILATERAL OR BILATERAL CANNULATION (EG, KYPHOPLASTY); LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2539, N'21154', N'RECONSTRUCTION MIDFACE, LEFORT III (EXTRACRANIAL), ANY TYPE, REQUIRING BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS); WITHOUT LEFORT I', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2540, N'22525', N'PERCUTANEOUS VERTEBRAL AUGMENTATION, INCLUDING CAVITY CREATION (FRACTURE REDUCTION AND BONE BIOPSY INCLUDED WHEN PERFORMED) USING MECHANICAL DEVICE, 1 VERTEBRAL BODY, UNILATERAL OR BILATERAL CANNULATION (EG, KYPHOPLASTY); EACH ADDITIONAL THORACIC OR LUMBAR VERTEBRAL BODY (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2541, N'21155', N'RECONSTRUCTION MIDFACE, LEFORT III (EXTRACRANIAL), ANY TYPE, REQUIRING BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS); WITH LEFORT I', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2542, N'21172', N'RECONSTRUCTION SUPERIOR-LATERAL ORBITAL RIM AND LOWER FOREHEAD, ADVANCEMENT OR ALTERATION, WITH OR WITHOUT GRAFTS (INCLUDES OBTAINING AUTOGRAFTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2543, N'22532', N'ARTHRODESIS, LATERAL EXTRACAVITARY TECHNIQUE, INCLUDING MINIMAL DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION); THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2544, N'21047', N'EXCISION OF BENIGN TUMOR OR CYST OF MANDIBLE; REQUIRING EXTRA-ORAL OSTEOTOMY AND PARTIAL MANDIBULECTOMY (EG, LOCALLY AGGRESSIVE OR DESTRUCTIVE LESION(S))', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2545, N'22533', N'ARTHRODESIS, LATERAL EXTRACAVITARY TECHNIQUE, INCLUDING MINIMAL DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION); LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2546, N'21180', N'RECONSTRUCTION, ENTIRE OR MAJORITY OF FOREHEAD AND/OR SUPRAORBITAL RIMS; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2547, N'21198', N'OSTEOTOMY, MANDIBLE, SEGMENTAL;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2548, N'22555', N'ARTHRODESIS WITH DISKECTOMY, CERVICAL, ANTERIOR INTERBODY APPROACH WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2549, N'21230', N'GRAFT; RIB CARTILAGE, AUTOGENOUS, TO FACE, CHIN, NOSE OR EAR (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2550, N'21248', N'RECONSTRUCTION OF MANDIBLE OR MAXILLA, ENDOSTEAL IMPLANT (EG, BLADE, CYLINDER); PARTIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2551, N'21725', N'DIVISION OF STERNOCLEIDOMASTOID FOR TORTICOLLIS, OPEN OPERATION; WITH CAST APPLICATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2552, N'21740', N'RECONSTRUCTIVE REPAIR OF PECTUS EXCAVATUM OR CARINATUM; OPEN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2553, N'21249', N'RECONSTRUCTION OF MANDIBLE OR MAXILLA, ENDOSTEAL IMPLANT (EG, BLADE, CYLINDER); COMPLETE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2554, N'21275', N'SECONDARY REVISION OF ORBITOCRANIOFACIAL RECONSTRUCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2555, N'21800', N'CLOSED TREATMENT OF RIB FRACTURE, UNCOMPLICATED, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2556, N'21810', N'TREATMENT OF RIB FRACTURE REQUIRING EXTERNAL FIXATION (FLAIL CHEST)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2557, N'22558', N'ARTHRODESIS, ANTERIOR INTERBODY TECHNIQUE, INCLUDING MINIMAL DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION); LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2558, N'21920', N'BIOPSY, SOFT TISSUE OF BACK OR FLANK; SUPERFICIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2559, N'21925', N'BIOPSY, SOFT TISSUE OF BACK OR FLANK; DEEP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2560, N'21935', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF BACK OR FLANK; LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2561, N'22560', N'ARTHRODESIS WITH DISKECTOMY, LUMBAR OR THORACIC, POSTERIOR POSTEROLATERAL OR POSTERIOR INTERBODY APPROACH; LOCAL BONE GRAFT AND/OR INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2562, N'21936', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF BACK OR FLANK; 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2563, N'22011', N'BIOPSY, SPINAL SOFT TISSUES; DEEP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2564, N'22590', N'ARTHRODESIS, POSTERIOR TECHNIQUE, CRANIOCERVICAL (OCCIPUT-C2)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2565, N'22600', N'ARTHRODESIS, POSTERIOR OR POSTEROLATERAL TECHNIQUE, SINGLE LEVEL; CERVICAL BELOW C2 SEGMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2566, N'22101', N'PARTIAL EXCISION OF POSTERIOR VERTEBRAL COMPONENT (EG, SPINOUS PROCESS, LAMINA OR FACET) FOR INTRINSIC BONY LESION, SINGLE VERTEBRAL SEGMENT; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2567, N'22605', N'CERVICAL FUSION, POSTERIOR APPROACH, BELOW C1 LEVEL; WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2568, N'22614', N'ARTHRODESIS, POSTERIOR OR POSTEROLATERAL TECHNIQUE, SINGLE LEVEL; EACH ADDITIONAL VERTEBRAL SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2569, N'22102', N'PARTIAL EXCISION OF POSTERIOR VERTEBRAL COMPONENT (EG, SPINOUS PROCESS, LAMINA OR FACET) FOR INTRINSIC BONY LESION, SINGLE VERTEBRAL SEGMENT; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2570, N'21310', N'CLOSED TREATMENT OF NASAL BONE FRACTURE WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2571, N'21315', N'CLOSED TREATMENT OF NASAL BONE FRACTURE; WITHOUT STABILIZATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2572, N'22105', N'PARTIAL RESECTION OF VERTEBRAL COMPONENT FOR TUMOR (EG, PARTIAL FACETECTOMY, WITHOUT PRIMARY GRAFTING); CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2573, N'22106', N'PARTIAL RESECTION OF VERTEBRAL COMPONENT FOR TUMOR (EG, PARTIAL FACETECTOMY, WITHOUT PRIMARY GRAFTING); THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2574, N'21320', N'CLOSED TREATMENT OF NASAL BONE FRACTURE; WITH STABILIZATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2575, N'21330', N'OPEN TREATMENT OF NASAL FRACTURE; COMPLICATED, WITH INTERNAL AND/OR EXTERNAL SKELETAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2576, N'21061', N'MENISCECTOMY, TEMPOROMANDIBULAR JOINT; BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2577, N'21073', N'MANIPULATION OF TEMPOROMANDIBULAR JOINT(S) (TMJ), THERAPEUTIC, REQUIRING AN ANESTHESIA SERVICE (IE, GENERAL OR MONITORED ANESTHESIA CARE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2578, N'21344', N'OPEN TREATMENT OF COMPLICATED (EG, COMMINUTED OR INVOLVING POSTERIOR WALL) FRONTAL SINUS FRACTURE, VIA CORONAL OR MULTIPLE APPROACHES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2579, N'21076', N'IMPRESSION AND CUSTOM PREPARATION; SURGICAL OBTURATOR PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2580, N'21081', N'IMPRESSION AND CUSTOM PREPARATION; MANDIBULAR RESECTION PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2581, N'21083', N'IMPRESSION AND CUSTOM PREPARATION; PALATAL LIFT PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2582, N'21084', N'IMPRESSION AND CUSTOM PREPARATION; SPEECH AID PROSTHESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2583, N'21355', N'PERCUTANEOUS TREATMENT OF FRACTURE OF MALAR AREA, INCLUDING ZYGOMATIC ARCH AND MALAR TRIPOD, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2584, N'21360', N'OPEN TREATMENT OF DEPRESSED MALAR FRACTURE, INCLUDING ZYGOMATIC ARCH AND MALAR TRIPOD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2585, N'21121', N'GENIOPLASTY; SLIDING OSTEOTOMY, SINGLE PIECE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2586, N'21123', N'GENIOPLASTY; SLIDING, AUGMENTATION WITH INTERPOSITIONAL BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2587, N'22633', N'ARTHRODESIS, COMBINED POSTERIOR OR POSTEROLATERAL TECHNIQUE WITH POSTERIOR INTERBODY TECHNIQUE INCLUDING LAMINECTOMY AND/OR DISCECTOMY SUFFICIENT TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION), SINGLE INTERSPACE AND SEGMENT; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2588, N'22115', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION) OF VERTEBRAE (EG, FOR OSTEOMYELITIS), LUMBAR; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2589, N'22120', N'RADICAL RESECTION OF VERTEBRAL BODY OR COMPONENT WITH PRIMARY GRAFTING, INCLUDES OBTAINING GRAFT; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2590, N'21366', N'OPEN TREATMENT OF COMPLICATED (EG, COMMINUTED OR INVOLVING CRANIAL NERVE FORAMINA) FRACTURE(S) OF MALAR AREA, INCLUDING ZYGOMATIC ARCH AND MALAR TRIPOD; WITH BONE GRAFTING (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2591, N'21138', N'REDUCTION FOREHEAD; CONTOURING AND APPLICATION OF PROSTHETIC MATERIAL OR BONE GRAFT (INCLUDES OBTAINING AUTOGRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2592, N'21143', N'RECONSTRUCTION MIDFACE, LEFORT I; 3 OR MORE PIECES, SEGMENT MOVEMENT IN ANY DIRECTION, WITHOUT BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2593, N'22634', N'ARTHRODESIS, COMBINED POSTERIOR OR POSTEROLATERAL TECHNIQUE WITH POSTERIOR INTERBODY TECHNIQUE INCLUDING LAMINECTOMY AND/OR DISCECTOMY SUFFICIENT TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION), SINGLE INTERSPACE AND SEGMENT; EACH ADDITIONAL INTERSPACE AND SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2594, N'21144', N'RECONSTRUCTION MIDFACE, LEFORT I; INTRUSION, SINGLE PIECE (EG, FOR LONG FACE SYNDROME)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2595, N'21160', N'RECONSTRUCTION MIDFACE, LEFORT III (EXTRA AND INTRACRANIAL) WITH FOREHEAD ADVANCEMENT (EG, MONO BLOC), REQUIRING BONE GRAFTS (INCLUDES OBTAINING AUTOGRAFTS); WITH LEFORT I', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2596, N'22650', N'ARTHRODESIS, POSTERIOR, POSTEROLATERAL OR LATERAL TRANSVERSE PROCESS TECHNIQUE, EACH ADDITIONAL INTERSPACE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2597, N'22735', N'ARTHRODESIS, PRIMARY OR REPAIR OF PSEUDARTHROSIS; MORE THAN TWO LEVELS (LIST SEPARATELY IN ADDITION TO CODE FOR SINGLE LEVEL ARTHRODESIS, 22600-22720)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2598, N'21179', N'RECONSTRUCTION, ENTIRE OR MAJORITY OF FOREHEAD AND/OR SUPRAORBITAL RIMS; WITH GRAFTS (ALLOGRAFT OR PROSTHETIC MATERIAL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2599, N'21181', N'RECONSTRUCTION BY CONTOURING OF BENIGN TUMOR OF CRANIAL BONES (EG, FIBROUS DYSPLASIA), EXTRACRANIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2600, N'22800', N'ARTHRODESIS, POSTERIOR, FOR SPINAL DEFORMITY, WITH OR WITHOUT CAST; UP TO 6 VERTEBRAL SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2601, N'22801', N'ARTHRODESIS, PRIMARY FOR SCOLIOSIS WITH OR WITHOUT POSTOPERATIVE CAST, 6 OR LESS VERTEBRAE; WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2602, N'21193', N'RECONSTRUCTION OF MANDIBULAR RAMI, HORIZONTAL, VERTICAL, C, OR L OSTEOTOMY; WITHOUT BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2603, N'21194', N'RECONSTRUCTION OF MANDIBULAR RAMI, HORIZONTAL, VERTICAL, C, OR L OSTEOTOMY; WITH BONE GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2604, N'22803', N'ARTHRODESIS, PRIMARY FOR SCOLIOSIS WITH OR WITHOUT POSTOPERATIVE CAST, SEVEN OR MORE VERTEBRAE; WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2605, N'21200', N'OSTEOTOMY (EG, FOR PROGNATHISM, MICROGNATHISM, APERTOGNATHISM OR FOR RECONSTRUCTION); MANDIBLE, TOTAL OR HORIZONTAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2606, N'21202', N'OSTEOTOMY (EG, FOR PROGNATHISM, MICROGNATHISM, APERTOGNATHISM OR FOR RECONSTRUCTION); MANDIBLE, SEGMENTAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2607, N'22810', N'ARTHRODESIS, ANTERIOR, FOR SPINAL DEFORMITY, WITH OR WITHOUT CAST; 4 TO 7 VERTEBRAL SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2608, N'22847', N'ANTERIOR INSTRUMENTATION; 8 OR MORE VERTEBRAL SEGMENTS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2609, N'21401', N'CLOSED TREATMENT OF FRACTURE OF ORBIT, EXCEPT BLOWOUT; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2610, N'21407', N'OPEN TREATMENT OF FRACTURE OF ORBIT, EXCEPT BLOWOUT; WITH IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2611, N'22140', N'RECONSTRUCTION OF SPINE WITH BONE GRAFT (AUTOGRAFT, ALLOGRAFT) AND/OR METHYL METHACRYLATE FOLLOWING RESECTION OF SINGLE VERTEBRAL BODY; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2612, N'21408', N'OPEN TREATMENT OF FRACTURE OF ORBIT, EXCEPT BLOWOUT; WITH BONE GRAFTING (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2613, N'21433', N'OPEN TREATMENT OF CRANIOFACIAL SEPARATION (LEFORT III TYPE); COMPLICATED (EG, COMMINUTED OR INVOLVING CRANIAL NERVE FORAMINA), MULTIPLE SURGICAL APPROACHES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2614, N'22142', N'RECONSTRUCTION OF SPINE WITH BONE GRAFT (AUTOGRAFT, ALLOGRAFT) AND/OR METHYL METHACRYLATE FOLLOWING RESECTION OF SINGLE VERTEBRAL BODY; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2615, N'21435', N'OPEN TREATMENT OF CRANIOFACIAL SEPARATION (LEFORT III TYPE); COMPLICATED, UTILIZING INTERNAL AND/OR EXTERNAL FIXATION TECHNIQUES (EG, HEAD CAP, HALO DEVICE, AND/OR INTERMAXILLARY FIXATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1600 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2616, N'22145', N'RECONSTRUCTION OF SPINE FOLLOWING VERTEBRAL BODY RESECTION, EACH ADDITIONAL VERTEBRAL BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2617, N'22150', N'RECONSTRUCTION OF SPINE WITH PREFABRICATED PROSTHETIC REPLACEMENT FOLLOWING RESECTION OF ONE OR MORE VERTEBRAL BODIES; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2618, N'22903', N'EXCISION, TUMOR, SOFT TISSUE OF ABDOMINAL WALL, SUBCUTANEOUS; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2619, N'23020', N'CAPSULAR CONTRACTURE RELEASE (EG, SEVER TYPE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2620, N'22151', N'RECONSTRUCTION OF SPINE WITH PREFABRICATED PROSTHETIC REPLACEMENT FOLLOWING RESECTION OF ONE OR MORE VERTEBRAL BODIES; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2621, N'22152', N'RECONSTRUCTION OF SPINE WITH PREFABRICATED PROSTHETIC REPLACEMENT FOLLOWING RESECTION OF ONE OR MORE VERTEBRAL BODIES; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2622, N'23031', N'INCISION AND DRAINAGE, SHOULDER AREA; INFECTED BURSA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2623, N'23036', N'INCISION, DEEP, WITH OPENING OF CORTEX (EG, FOR OSTEOMYELITIS OR BONE ABSCESS); WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2624, N'22208', N'OSTEOTOMY OF SPINE, POSTERIOR OR POSTEROLATERAL APPROACH, 3 COLUMNS, 1 VERTEBRAL SEGMENT (EG, PEDICLE/VERTEBRAL BODY SUBTRACTION); EACH ADDITIONAL VERTEBRAL SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2625, N'23066', N'BIOPSY, SOFT TISSUE OF SHOULDER AREA; DEEP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2626, N'23071', N'EXCISION, TUMOR, SOFT TISSUE OF SHOULDER AREA, SUBCUTANEOUS; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2627, N'22210', N'OSTEOTOMY OF SPINE, POSTERIOR OR POSTEROLATERAL APPROACH, 1 VERTEBRAL SEGMENT; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2628, N'22216', N'OSTEOTOMY OF SPINE, POSTERIOR OR POSTEROLATERAL APPROACH, 1 VERTEBRAL SEGMENT; EACH ADDITIONAL VERTEBRAL SEGMENT (LIST SEPARATELY IN ADDITION TO PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2629, N'23105', N'ARTHROTOMY; GLENOHUMERAL JOINT, WITH SYNOVECTOMY, WITH OR WITHOUT BIOPSY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2630, N'23106', N'ARTHROTOMY; STERNOCLAVICULAR JOINT, WITH SYNOVECTOMY, WITH OR WITHOUT BIOPSY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2631, N'22224', N'OSTEOTOMY OF SPINE, INCLUDING DISKECTOMY, ANTERIOR APPROACH, SINGLE VERTEBRAL SEGMENT; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2632, N'22226', N'OSTEOTOMY OF SPINE, INCLUDING DISKECTOMY, ANTERIOR APPROACH, SINGLE VERTEBRAL SEGMENT; EACH ADDITIONAL VERTEBRAL SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2633, N'23140', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF CLAVICLE OR SCAPULA;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2634, N'23146', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF CLAVICLE OR SCAPULA; WITH ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2635, N'21203', N'OSTEOTOMY (EG, FOR PROGNATHISM, MICROGNATHISM, APERTOGNATHISM OR FOR RECONSTRUCTION); MANDIBULAR RAMUS (OSTEOTOMY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2636, N'21206', N'OSTEOTOMY, MAXILLA, SEGMENTAL (EG, WASSMUND OR SCHUCHARD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2637, N'23150', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF PROXIMAL HUMERUS;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2638, N'23156', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF PROXIMAL HUMERUS; WITH ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2639, N'21440', N'CLOSED TREATMENT OF MANDIBULAR OR MAXILLARY ALVEOLAR RIDGE FRACTURE (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2640, N'21451', N'CLOSED TREATMENT OF MANDIBULAR FRACTURE; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2641, N'23174', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), HUMERAL HEAD TO SURGICAL NECK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2642, N'23332', N'REMOVAL OF FOREIGN BODY, SHOULDER; COMPLICATED (EG, TOTAL SHOULDER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2643, N'21207', N'REDUCTION GENIOPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2644, N'21208', N'OSTEOPLASTY, FACIAL BONES; AUGMENTATION (AUTOGRAFT, ALLOGRAFT, OR PROSTHETIC IMPLANT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2645, N'21210', N'GRAFT, BONE; NASAL, MAXILLARY OR MALAR AREAS (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2646, N'23356', N'ARTHROSCOPY, SHOULDER, SURGICAL; DEBRIDEMENT WITH CARTILAGE SHAVING AND OR DRILLING AND/OR RESECTION OF REACTIVE SYNOVIUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2647, N'23395', N'MUSCLE TRANSFER, ANY TYPE, SHOULDER OR UPPER ARM; SINGLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2648, N'21453', N'CLOSED TREATMENT OF MANDIBULAR FRACTURE WITH INTERDENTAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2649, N'21461', N'OPEN TREATMENT OF MANDIBULAR FRACTURE; WITHOUT INTERDENTAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2650, N'23397', N'MUSCLE TRANSFER, ANY TYPE, SHOULDER OR UPPER ARM; MULTIPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2651, N'23400', N'SCAPULOPEXY (EG, SPRENGELS DEFORMITY OR FOR PARALYSIS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2652, N'21462', N'OPEN TREATMENT OF MANDIBULAR FRACTURE; WITH INTERDENTAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2653, N'21495', N'OPEN TREATMENT OF HYOID FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2654, N'21552', N'EXCISION, TUMOR, SOFT TISSUE OF NECK OR ANTERIOR THORAX, SUBCUTANEOUS; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2655, N'23405', N'TENOTOMY, SHOULDER AREA; SINGLE TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2656, N'23462', N'CAPSULORRHAPHY, ANTERIOR, ANY TYPE; WITH CORACOID PROCESS TRANSFER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2657, N'23480', N'OSTEOTOMY, CLAVICLE, WITH OR WITHOUT INTERNAL FIXATION;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2658, N'21239', N'IMPLANT, CHIN, HOMOLOGOUS, HETEROLOGOUS, OR ALLOPLASTIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2659, N'21243', N'ARTHROPLASTY, TEMPOROMANDIBULAR JOINT, WITH PROSTHETIC JOINT REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2660, N'22318', N'OPEN TREATMENT AND/OR REDUCTION OF ODONTOID FRACTURE(S) AND OR DISLOCATION(S) (INCLUDING OS ODONTOIDEUM), ANTERIOR APPROACH, INCLUDING PLACEMENT OF INTERNAL FIXATION; WITHOUT GRAFTING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2661, N'21244', N'RECONSTRUCTION OF MANDIBLE, EXTRAORAL, WITH TRANSOSTEAL BONE PLATE (EG, MANDIBULAR STAPLE BONE PLATE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2662, N'21247', N'RECONSTRUCTION OF MANDIBULAR CONDYLE WITH BONE AND CARTILAGE AUTOGRAFTS (INCLUDES OBTAINING GRAFTS) (EG, FOR HEMIFACIAL MICROSOMIA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2663, N'23515', N'OPEN TREATMENT OF CLAVICULAR FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2664, N'23520', N'CLOSED TREATMENT OF STERNOCLAVICULAR DISLOCATION; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2665, N'22325', N'OPEN TREATMENT AND/OR REDUCTION OF VERTEBRAL FRACTURE(S) AND/OR DISLOCATION(S), POSTERIOR APPROACH, 1 FRACTURED VERTEBRA OR DISLOCATED SEGMENT; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2666, N'21268', N'ORBITAL REPOSITIONING, PERIORBITAL OSTEOTOMIES, UNILATERAL, WITH BONE GRAFTS; COMBINED INTRA- AND EXTRACRANIAL APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2667, N'21295', N'REDUCTION OF MASSETER MUSCLE AND BONE (EG, FOR TREATMENT OF BENIGN MASSETERIC HYPERTROPHY); EXTRAORAL APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2668, N'22326', N'OPEN TREATMENT AND/OR REDUCTION OF VERTEBRAL FRACTURE(S) AND/OR DISLOCATION(S), POSTERIOR APPROACH, 1 FRACTURED VERTEBRA OR DISLOCATED SEGMENT; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2669, N'21557', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF NECK OR ANTERIOR THORAX; LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2670, N'21620', N'OSTECTOMY OF STERNUM, PARTIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2671, N'21337', N'CLOSED TREATMENT OF NASAL SEPTAL FRACTURE, WITH OR WITHOUT STABILIZATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2672, N'21339', N'OPEN TREATMENT OF NASOETHMOID FRACTURE; WITH EXTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2673, N'22361', N'OPEN TREATMENT AND FUSION, POSTERIOR APPROACH WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT), FOR FRACTURE; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2674, N'21632', N'RADICAL RESECTION OF STERNUM; WITH MEDIASTINAL LYMPHADENECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2675, N'21700', N'DIVISION OF SCALENUS ANTICUS; WITHOUT RESECTION OF CERVICAL RIB', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2676, N'23532', N'OPEN TREATMENT OF STERNOCLAVICULAR DISLOCATION, ACUTE OR CHRONIC; WITH FASCIAL GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2677, N'23540', N'CLOSED TREATMENT OF ACROMIOCLAVICULAR DISLOCATION; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2678, N'21750', N'CLOSURE OF MEDIAN STERNOTOMY SEPARATION WITH OR WITHOUT DEBRIDEMENT (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2679, N'21825', N'OPEN TREATMENT OF STERNUM FRACTURE WITH OR WITHOUT SKELETAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2680, N'23552', N'OPEN TREATMENT OF ACROMIOCLAVICULAR DISLOCATION, ACUTE OR CHRONIC; WITH FASCIAL GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2681, N'23575', N'CLOSED TREATMENT OF SCAPULAR FRACTURE; WITH MANIPULATION, WITH OR WITHOUT SKELETAL TRACTION (WITH OR WITHOUT SHOULDER JOINT INVOLVEMENT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2682, N'21899', N'UNLISTED PROCEDURE, NECK OR THORAX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2683, N'22012', N'BIOPSY, SPINAL SOFT TISSUES, PERCUTANEOUS NEEDLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2684, N'22015', N'INCISION AND DRAINAGE, OPEN, OF DEEP ABSCESS (SUBFASCIAL), POSTERIOR SPINE; LUMBAR, SACRAL, OR LUMBOSACRAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2685, N'23600', N'CLOSED TREATMENT OF PROXIMAL HUMERAL (SURGICAL OR ANATOMICAL NECK) FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2686, N'23615', N'OPEN TREATMENT OF PROXIMAL HUMERAL (SURGICAL OR ANATOMICAL NECK) FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED, INCLUDES REPAIR OF TUBEROSITY(S), WHEN PERFORMED;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2687, N'22031', N'EXCISION, BENIGN TUMOR, DEEP, SUBFASCIAL, INTRAMUSCULAR; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2688, N'22032', N'EXCISION, BENIGN TUMOR, DEEP, SUBFASCIAL, INTRAMUSCULAR; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2689, N'23620', N'CLOSED TREATMENT OF GREATER HUMERAL TUBEROSITY FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2690, N'23625', N'CLOSED TREATMENT OF GREATER HUMERAL TUBEROSITY FRACTURE; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2691, N'22100', N'PARTIAL EXCISION OF POSTERIOR VERTEBRAL COMPONENT (EG, SPINOUS PROCESS, LAMINA OR FACET) FOR INTRINSIC BONY LESION, SINGLE VERTEBRAL SEGMENT; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2692, N'23650', N'CLOSED TREATMENT OF SHOULDER DISLOCATION, WITH MANIPULATION; WITHOUT ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2693, N'23680', N'OPEN TREATMENT OF SHOULDER DISLOCATION, WITH SURGICAL OR ANATOMICAL NECK FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2694, N'22103', N'PARTIAL EXCISION OF POSTERIOR VERTEBRAL COMPONENT (EG, SPINOUS PROCESS, LAMINA OR FACET) FOR INTRINSIC BONY LESION, SINGLE VERTEBRAL SEGMENT; EACH ADDITIONAL SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2695, N'22107', N'PARTIAL RESECTION OF VERTEBRAL COMPONENT FOR TUMOR (EG, PARTIAL FACETECTOMY, WITHOUT PRIMARY GRAFTING); LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2696, N'22110', N'PARTIAL EXCISION OF VERTEBRAL BODY, FOR INTRINSIC BONY LESION, WITHOUT DECOMPRESSION OF SPINAL CORD OR NERVE ROOT(S), SINGLE VERTEBRAL SEGMENT; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2697, N'22370', N'OPEN TREATMENT AND FUSION, POSTEROLATERAL OR ANTEROLATERAL APPROACH, WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT) FOR FRACTURE; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2698, N'22113', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION) OF VERTEBRAE (EG, FOR OSTEOMYELITIS), THORACIC; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2699, N'22122', N'RADICAL RESECTION OF VERTEBRAL BODY OR COMPONENT WITH PRIMARY GRAFTING, INCLUDES OBTAINING GRAFT; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2700, N'22534', N'ARTHRODESIS, LATERAL EXTRACAVITARY TECHNIQUE, INCLUDING MINIMAL DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION); THORACIC OR LUMBAR, EACH ADDITIONAL VERTEBRAL SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2701, N'21346', N'OPEN TREATMENT OF NASOMAXILLARY COMPLEX FRACTURE (LEFORT II TYPE); WITH WIRING AND/OR LOCAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2702, N'21347', N'OPEN TREATMENT OF NASOMAXILLARY COMPLEX FRACTURE (LEFORT II TYPE); REQUIRING MULTIPLE OPEN APPROACHES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2703, N'22548', N'ARTHRODESIS, ANTERIOR TRANSORAL OR EXTRAORAL TECHNIQUE, CLIVUS-C1-C2 (ATLAS-AXIS), WITH OR WITHOUT EXCISION OF ODONTOID PROCESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2704, N'22550', N'ARTHRODESIS WITH DISKECTOMY, CERVICAL, POSTERIOR APPROACH; LOCAL BONE GRAFT AND/OR INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2705, N'21386', N'OPEN TREATMENT OF ORBITAL FLOOR BLOWOUT FRACTURE; PERIORBITAL APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2706, N'21421', N'CLOSED TREATMENT OF PALATAL OR MAXILLARY FRACTURE (LEFORT I TYPE), WITH INTERDENTAL WIRE FIXATION OR FIXATION OF DENTURE OR SPLINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2707, N'22551', N'ARTHRODESIS, ANTERIOR INTERBODY, INCLUDING DISC SPACE PREPARATION, DISCECTOMY, OSTEOPHYTECTOMY AND DECOMPRESSION OF SPINAL CORD AND/OR NERVE ROOTS; CERVICAL BELOW C2', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2708, N'21423', N'OPEN TREATMENT OF PALATAL OR MAXILLARY FRACTURE (LEFORT I TYPE); COMPLICATED (COMMINUTED OR INVOLVING CRANIAL NERVE FORAMINA), MULTIPLE APPROACHES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2709, N'23935', N'INCISION, DEEP, WITH OPENING OF BONE CORTEX (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), HUMERUS OR ELBOW', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2710, N'24077', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF UPPER ARM OR ELBOW AREA; LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2711, N'21436', N'OPEN TREATMENT OF CRANIOFACIAL SEPARATION (LEFORT III TYPE); COMPLICATED, MULTIPLE SURGICAL APPROACHES, INTERNAL FIXATION, WITH BONE GRAFTING (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2712, N'24125', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF HEAD OR NECK OF RADIUS OR OLECRANON PROCESS; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2713, N'21465', N'OPEN TREATMENT OF MANDIBULAR CONDYLAR FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2714, N'21480', N'CLOSED TREATMENT OF TEMPOROMANDIBULAR DISLOCATION; INITIAL OR SUBSEQUENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2715, N'24126', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF HEAD OR NECK OF RADIUS OR OLECRANON PROCESS; WITH ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2716, N'24130', N'EXCISION, RADIAL HEAD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1700 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2717, N'24136', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), RADIAL HEAD OR NECK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2718, N'24139', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), OLECRANON PROCESS; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2719, N'21490', N'OPEN TREATMENT OF TEMPOROMANDIBULAR DISLOCATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2720, N'21493', N'CLOSED TREATMENT OF HYOID FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2721, N'21497', N'INTERDENTAL WIRING, FOR CONDITION OTHER THAN FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2722, N'24146', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS), RADIAL HEAD OR NECK; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2723, N'21502', N'INCISION AND DRAINAGE, DEEP ABSCESS OR HEMATOMA, SOFT TISSUES OF NECK OR THORAX; WITH PARTIAL RIB OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2724, N'21510', N'INCISION, DEEP, WITH OPENING OF BONE CORTEX (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), THORAX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2725, N'24153', N'RADICAL RESECTION FOR TUMOR, RADIAL HEAD OR NECK; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2726, N'24164', N'IMPLANT REMOVAL; RADIAL HEAD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2727, N'21511', N'INCISION, DEEP, WITH OPENING OF BONE CORTEX (EG, FOR OSTEOMYELITIS OR BONE ABSCESS); WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2728, N'21554', N'EXCISION, TUMOR, SOFT TISSUE OF NECK OR ANTERIOR THORAX, SUBFASCIAL (EG, INTRAMUSCULAR); 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2729, N'22552', N'ARTHRODESIS, ANTERIOR INTERBODY, INCLUDING DISC SPACE PREPARATION, DISCECTOMY, OSTEOPHYTECTOMY AND DECOMPRESSION OF SPINAL CORD AND/OR NERVE ROOTS; CERVICAL BELOW C2, EACH ADDITIONAL INTERSPACE (LIST SEPARATELY IN ADDITION TO CODE FOR SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2730, N'21556', N'EXCISION, TUMOR, SOFT TISSUE OF NECK OR ANTERIOR THORAX, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2731, N'21600', N'EXCISION OF RIB, PARTIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2732, N'22561', N'ARTHRODESIS WITH DISKECTOMY, LUMBAR OR THORACIC, POSTERIOR POSTEROLATERAL OR POSTERIOR INTERBODY APPROACH; WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2733, N'22565', N'ARTHRODESIS WITH DISKECTOMY, LOWER LUMBAR SPINE, ANTERIOR INTERBODY APPROACH, (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2734, N'22595', N'ARTHRODESIS, POSTERIOR TECHNIQUE, ATLAS-AXIS (C1-C2)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2735, N'22130', N'RADICAL RESECTION OF VERTEBRAL BODY OR COMPONENT WITH PROSTHETIC REPLACEMENT, INCLUDING FABRICATION OF PROSTHESIS; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2736, N'22148', N'HARVESTING OF BONE AUTOGRAFT FOR VERTEBRAL RECONSTRUCTION FOLLOWING VERTEBRAL CORPECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2737, N'21630', N'RADICAL RESECTION OF STERNUM;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2738, N'21743', N'RECONSTRUCTIVE REPAIR OF PECTUS EXCAVATUM OR CARINATUM; MINIMALLY INVASIVE APPROACH (NUSS PROCEDURE), WITH THORACOSCOPY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2739, N'21931', N'EXCISION, TUMOR, SOFT TISSUE OF BACK OR FLANK, SUBCUTANEOUS; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2740, N'21932', N'EXCISION, TUMOR, SOFT TISSUE OF BACK OR FLANK, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2741, N'22201', N'OSTEOTOMY OF SPINE FOR CORRECTION FIXED DEFORMITY (NOT SCOLIOSIS), ANTERIOR OR THORACIC OR CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2742, N'22202', N'OSTEOTOMY OF SPINE FOR CORRECTION FIXED DEFORMITY (NOT SCOLIOSIS), ANTERIOR AND POSTERIOR; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2743, N'21933', N'EXCISION, TUMOR, SOFT TISSUE OF BACK OR FLANK, SUBFASCIAL (EG, INTRAMUSCULAR); 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2744, N'22010', N'INCISION AND DRAINAGE, OPEN, OF DEEP ABSCESS (SUBFASCIAL), POSTERIOR SPINE; CERVICAL, THORACIC, OR CERVICOTHORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2745, N'22615', N'CERVICAL FUSION, ANTERIOR APPROACH (C3-T1) WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2746, N'22625', N'ARTHRODESIS, LATERAL TRANSVERSE PROCESS TECHNIQUE, WITH LOCAL BONE OR BONE ALLOGRAFT AND/OR INTERNAL WIRE FIXATION, LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2747, N'22033', N'EXCISION, BENIGN TUMOR, DEEP, SUBFASCIAL, INTRAMUSCULAR; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2748, N'22112', N'PARTIAL EXCISION OF VERTEBRAL BODY, FOR INTRINSIC BONY LESION, WITHOUT DECOMPRESSION OF SPINAL CORD OR NERVE ROOT(S), SINGLE VERTEBRAL SEGMENT; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2749, N'22116', N'PARTIAL EXCISION OF VERTEBRAL BODY, FOR INTRINSIC BONY LESION, WITHOUT DECOMPRESSION OF SPINAL CORD OR NERVE ROOT(S), SINGLE VERTEBRAL SEGMENT; EACH ADDITIONAL VERTEBRAL SEGMENT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2750, N'22207', N'OSTEOTOMY OF SPINE, POSTERIOR OR POSTEROLATERAL APPROACH, 3 COLUMNS, 1 VERTEBRAL SEGMENT (EG, PEDICLE/VERTEBRAL BODY SUBTRACTION); LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2751, N'24300', N'MANIPULATION, ELBOW, UNDER ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2752, N'24305', N'TENDON LENGTHENING, UPPER ARM OR ELBOW, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2753, N'24342', N'REINSERTION OF RUPTURED BICEPS OR TRICEPS TENDON, DISTAL, WITH OR WITHOUT TENDON GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2754, N'22220', N'OSTEOTOMY OF SPINE, INCLUDING DISKECTOMY, ANTERIOR APPROACH, SINGLE VERTEBRAL SEGMENT; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2755, N'22230', N'OSTEOTOMY OF SPINE, ANY APPROACH, EACH ADDITIONAL SEGMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2756, N'22730', N'ARTHRODESIS, PRIMARY OR REPAIR OF PSEUDARTHROSIS; TWO LEVELS (LIST SEPARATELY IN ADDITION TO CODE FOR SINGLE LEVEL ARTHRODESIS, 22600-22720)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2757, N'22310', N'CLOSED TREATMENT OF VERTEBRAL BODY FRACTURE(S), WITHOUT MANIPULATION, REQUIRING AND INCLUDING CASTING OR BRACING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2758, N'22315', N'CLOSED TREATMENT OF VERTEBRAL FRACTURE(S) AND/OR DISLOCATION(S) REQUIRING CASTING OR BRACING, WITH AND INCLUDING CASTING AND/OR BRACING BY MANIPULATION OR TRACTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2759, N'22804', N'ARTHRODESIS, POSTERIOR, FOR SPINAL DEFORMITY, WITH OR WITHOUT CAST; 13 OR MORE VERTEBRAL SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2760, N'22830', N'EXPLORATION OF SPINAL FUSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2761, N'22129', N'RADICAL RESECTION OF VERTEBRAL BODY OR COMPONENT WITH PROSTHETIC REPLACEMENT, INCLUDING FABRICATION OF PROSTHESIS; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2762, N'22141', N'RECONSTRUCTION OF SPINE WITH BONE GRAFT (AUTOGRAFT, ALLOGRAFT) AND/OR METHYL METHACRYLATE FOLLOWING RESECTION OF SINGLE VERTEBRAL BODY; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2763, N'22844', N'POSTERIOR SEGMENTAL INSTRUMENTATION (EG, PEDICLE FIXATION, DUAL RODS WITH MULTIPLE HOOKS AND SUBLAMINAR WIRES); 13 OR MORE VERTEBRAL SEGMENTS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2764, N'22203', N'OSTEOTOMY OF SPINE FOR CORRECTION FIXED DEFORMITY (NOT SCOLIOSIS), ANTERIOR AND POSTERIOR; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2765, N'22206', N'OSTEOTOMY OF SPINE, POSTERIOR OR POSTEROLATERAL APPROACH, 3 COLUMNS, 1 VERTEBRAL SEGMENT (EG, PEDICLE/VERTEBRAL BODY SUBTRACTION); THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2766, N'22864', N'REMOVAL OF TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, SINGLE INTERSPACE; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2767, N'22899', N'UNLISTED PROCEDURE, SPINE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2768, N'22214', N'OSTEOTOMY OF SPINE, POSTERIOR OR POSTEROLATERAL APPROACH, 1 VERTEBRAL SEGMENT; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2769, N'22222', N'OSTEOTOMY OF SPINE, INCLUDING DISKECTOMY, ANTERIOR APPROACH, SINGLE VERTEBRAL SEGMENT; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2770, N'22902', N'EXCISION, TUMOR, SOFT TISSUE OF ABDOMINAL WALL, SUBCUTANEOUS; LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2771, N'22999', N'UNLISTED PROCEDURE, ABDOMEN, MUSCULOSKELETAL SYSTEM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2772, N'22319', N'OPEN TREATMENT AND/OR REDUCTION OF ODONTOID FRACTURE(S) AND OR DISLOCATION(S) (INCLUDING OS ODONTOIDEUM), ANTERIOR APPROACH, INCLUDING PLACEMENT OF INTERNAL FIXATION; WITH GRAFTING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2773, N'22327', N'OPEN TREATMENT AND/OR REDUCTION OF VERTEBRAL FRACTURE(S) AND/OR DISLOCATION(S), POSTERIOR APPROACH, 1 FRACTURED VERTEBRA OR DISLOCATED SEGMENT; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2774, N'23000', N'REMOVAL OF SUBDELTOID CALCAREOUS DEPOSITS, OPEN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2775, N'23035', N'INCISION, BONE CORTEX (EG, OSTEOMYELITIS OR BONE ABSCESS), SHOULDER AREA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2776, N'22371', N'OPEN TREATMENT AND FUSION, POSTEROLATERAL OR ANTEROLATERAL APPROACH, WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT) FOR FRACTURE; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2777, N'22521', N'PERCUTANEOUS VERTEBROPLASTY, 1 VERTEBRAL BODY, UNILATERAL OR BILATERAL INJECTION; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2778, N'22526', N'PERCUTANEOUS INTRADISCAL ELECTROTHERMAL ANNULOPLASTY, UNILATERAL OR BILATERAL INCLUDING FLUOROSCOPIC GUIDANCE; SINGLE LEVEL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2779, N'23075', N'EXCISION, TUMOR, SOFT TISSUE OF SHOULDER AREA, SUBCUTANEOUS; LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2780, N'23076', N'EXCISION, TUMOR, SOFT TISSUE OF SHOULDER AREA, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2781, N'22251', N'PROPHYLACTIC TREATMENT (PLATING AND/OR WIRING) WITH OR WITHOUT METHYL METHACRYLATE; CERVICAL OR THORACIC SPINE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2782, N'22330', N'OPEN TREATMENT AND FUSION, CERVICAL SPINE; POSTERIOR APPROACH, WITH LOCAL BONE GRAFT AND/OR INTERNAL FIXATION FOR FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2783, N'24345', N'REPAIR MEDIAL COLLATERAL LIGAMENT, ELBOW, WITH LOCAL TISSUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2784, N'24354', N'FASCIOTOMY, LATERAL OR MEDIAL (EG, TENNIS ELBOW OR EPICONDYLITIS); WITH STRIPPING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2785, N'22335', N'OPEN TREATMENT AND FUSION, CERVICAL SPINE; POSTERIOR APPROACH, WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT), FOR FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2786, N'23077', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF SHOULDER AREA; LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2787, N'23100', N'ARTHROTOMY, GLENOHUMERAL JOINT, INCLUDING BIOPSY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2788, N'22520', N'PERCUTANEOUS VERTEBROPLASTY, 1 VERTEBRAL BODY, UNILATERAL OR BILATERAL INJECTION; THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2789, N'22523', N'PERCUTANEOUS VERTEBRAL AUGMENTATION, INCLUDING CAVITY CREATION (FRACTURE REDUCTION AND BONE BIOPSY INCLUDED WHEN PERFORMED) USING MECHANICAL DEVICE, 1 VERTEBRAL BODY, UNILATERAL OR BILATERAL CANNULATION (EG, KYPHOPLASTY); THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2790, N'23101', N'ARTHROTOMY, ACROMIOCLAVICULAR JOINT OR STERNOCLAVICULAR JOINT, INCLUDING BIOPSY AND/OR EXCISION OF TORN CARTILAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2791, N'23107', N'ARTHROTOMY, GLENOHUMERAL JOINT, WITH JOINT EXPLORATION, WITH OR WITHOUT REMOVAL OF LOOSE OR FOREIGN BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2792, N'22527', N'PERCUTANEOUS INTRADISCAL ELECTROTHERMAL ANNULOPLASTY, UNILATERAL OR BILATERAL INCLUDING FLUOROSCOPIC GUIDANCE; 1 OR MORE ADDITIONAL LEVELS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2793, N'24357', N'TENOTOMY, ELBOW, LATERAL OR MEDIAL (EG, EPICONDYLITIS, TENNIS ELBOW, GOLFER''S ELBOW); PERCUTANEOUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2794, N'24358', N'TENOTOMY, ELBOW, LATERAL OR MEDIAL (EG, EPICONDYLITIS, TENNIS ELBOW, GOLFER''S ELBOW); DEBRIDEMENT, SOFT TISSUE AND/OR BONE, OPEN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2795, N'22585', N'ARTHRODESIS, ANTERIOR INTERBODY TECHNIQUE, INCLUDING MINIMAL DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION); EACH ADDITIONAL INTERSPACE (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2796, N'23130', N'ACROMIOPLASTY OR ACROMIONECTOMY, PARTIAL, WITH OR WITHOUT CORACOACROMIAL LIGAMENT RELEASE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2797, N'23172', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), SCAPULA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2798, N'22630', N'ARTHRODESIS, POSTERIOR INTERBODY TECHNIQUE, INCLUDING LAMINECTOMY AND/OR DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION), SINGLE INTERSPACE; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2799, N'23183', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS), SCAPULA; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2800, N'23190', N'OSTECTOMY OF SCAPULA, PARTIAL (EG, SUPERIOR MEDIAL ANGLE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2801, N'23195', N'RESECTION, HUMERAL HEAD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2802, N'23221', N'RADICAL RESECTION OF BONE TUMOR, PROXIMAL HUMERUS; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2803, N'22632', N'ARTHRODESIS, POSTERIOR INTERBODY TECHNIQUE, INCLUDING LAMINECTOMY AND/OR DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION), SINGLE INTERSPACE; EACH ADDITIONAL INTERSPACE (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2804, N'23222', N'RADICAL RESECTION OF BONE TUMOR, PROXIMAL HUMERUS; WITH PROSTHETIC REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2805, N'23355', N'ARTHROSCOPY, SHOULDER, DIAGNOSTIC (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2806, N'22640', N'THORACIC OR LUMBAR FUSION, POSTERIOR OR POSTEROLATERAL APPROACH; LOCAL BONE GRAFT AND/OR INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2807, N'22645', N'THORACIC OR LUMBAR FUSION, POSTERIOR OR POSTEROLATERAL APPROACH; WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2808, N'24359', N'TENOTOMY, ELBOW, LATERAL OR MEDIAL (EG, EPICONDYLITIS, TENNIS ELBOW, GOLFER''S ELBOW); DEBRIDEMENT, SOFT TISSUE AND/OR BONE, OPEN WITH TENDON REPAIR OR REATTACHMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2809, N'22670', N'THORACIC OR LUMBAR FUSION; LATERAL APPROACH (TRANSVERSE PROCESS TO TRANSVERSE PROCESS AND/OR SACRUM) WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT AND/OR INTERNAL FIXATION (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2810, N'23430', N'TENODESIS OF LONG TENDON OF BICEPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2811, N'23455', N'CAPSULORRHAPHY, ANTERIOR; WITH LABRAL REPAIR (EG, BANKART PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2812, N'23470', N'ARTHROPLASTY, GLENOHUMERAL JOINT; HEMIARTHROPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2813, N'22700', N'LUMBAR SPINE FUSION; ANTERIOR INTERBODY FUSION (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2814, N'22720', N'LUMBAR SPINE FUSION; POSTERIOR APPROACH, HARRINGTON OR KNODT ROD DISTRACTION FUSION, WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2815, N'24362', N'ARTHROPLASTY, ELBOW; WITH IMPLANT AND FASCIA LATA LIGAMENT RECONSTRUCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2816, N'24400', N'OSTEOTOMY, HUMERUS, WITH OR WITHOUT INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2817, N'22819', N'KYPHECTOMY, CIRCUMFERENTIAL EXPOSURE OF SPINE AND RESECTION OF VERTEBRAL SEGMENT(S) (INCLUDING BODY AND POSTERIOR ELEMENTS); 3 OR MORE SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1800 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2818, N'23472', N'ARTHROPLASTY, GLENOHUMERAL JOINT; TOTAL SHOULDER (GLENOID AND PROXIMAL HUMERAL REPLACEMENT (EG, TOTAL SHOULDER))', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2819, N'23505', N'CLOSED TREATMENT OF CLAVICULAR FRACTURE; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2820, N'22554', N'ARTHRODESIS, ANTERIOR INTERBODY TECHNIQUE, INCLUDING MINIMAL DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION); CERVICAL BELOW C2', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2821, N'23510', N'TREATMENT OF OPEN CLAVICULAR FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2822, N'23530', N'OPEN TREATMENT OF STERNOCLAVICULAR DISLOCATION, ACUTE OR CHRONIC;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2823, N'22556', N'ARTHRODESIS, ANTERIOR INTERBODY TECHNIQUE, INCLUDING MINIMAL DISKECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION); THORACIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2824, N'23545', N'CLOSED TREATMENT OF ACROMIOCLAVICULAR DISLOCATION; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2825, N'23550', N'OPEN TREATMENT OF ACROMIOCLAVICULAR DISLOCATION, ACUTE OR CHRONIC;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2826, N'23585', N'OPEN TREATMENT OF SCAPULAR FRACTURE (BODY, GLENOID OR ACROMION) INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2827, N'23630', N'OPEN TREATMENT OF GREATER HUMERAL TUBEROSITY FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2828, N'23658', N'TREATMENT OF OPEN SHOULDER DISLOCATION, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2829, N'23670', N'OPEN TREATMENT OF SHOULDER DISLOCATION, WITH FRACTURE OF GREATER HUMERAL TUBEROSITY, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2830, N'22610', N'ARTHRODESIS, POSTERIOR OR POSTEROLATERAL TECHNIQUE, SINGLE LEVEL; THORACIC (WITH OR WITHOUT LATERAL TRANSVERSE TECHNIQUE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2831, N'22612', N'ARTHRODESIS, POSTERIOR OR POSTEROLATERAL TECHNIQUE, SINGLE LEVEL; LUMBAR (WITH OR WITHOUT LATERAL TRANSVERSE TECHNIQUE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2832, N'24500', N'CLOSED TREATMENT OF HUMERAL SHAFT FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2833, N'24515', N'OPEN TREATMENT OF HUMERAL SHAFT FRACTURE WITH PLATE/SCREWS, WITH OR WITHOUT CERCLAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2834, N'23700', N'MANIPULATION UNDER ANESTHESIA, SHOULDER JOINT, INCLUDING APPLICATION OF FIXATION APPARATUS (DISLOCATION EXCLUDED)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2835, N'23802', N'ARTHRODESIS, GLENOHUMERAL JOINT; WITH AUTOGENOUS GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2836, N'22617', N'ATLAS-AXIS FUSION (C1-C2 OR C3) WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT (INCLUDES OBTAINING GRAFT) (POSTERIOR OR ANTERIOR APPROACH)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2837, N'23921', N'DISARTICULATION OF SHOULDER; SECONDARY CLOSURE OR SCAR REVISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2838, N'23929', N'UNLISTED PROCEDURE, SHOULDER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2839, N'23936', N'INCISION, DEEP, WITH OPENING OF (EG, CORTEX FOR OSTEOMYELITIS OR BONE ABSCESS); WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2840, N'22620', N'CERVICOCRANIAL FUSION (OCCIPUT THROUGH C2) WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT) (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2841, N'22655', N'THORACIC OR LUMBAR FUSION; POSTERIOR INTERBODY TECHNIQUE, WITH ILIAC OR OTHER AUTOGENOUS BONE GRAFT, (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2842, N'24000', N'ARTHROTOMY, ELBOW, INCLUDING EXPLORATION, DRAINAGE, OR REMOVAL OF FOREIGN BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2843, N'24001', N'ARTHROTOMY, ELBOW, WITH EXPLORATION, DRAINAGE OR REMOVAL OF FOREIGN BODY; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2844, N'24516', N'TREATMENT OF HUMERAL SHAFT FRACTURE, WITH INSERTION OF INTRAMEDULLARY IMPLANT, WITH OR WITHOUT CERCLAGE AND/OR LOCKING SCREWS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2845, N'24530', N'CLOSED TREATMENT OF SUPRACONDYLAR OR TRANSCONDYLAR HUMERAL FRACTURE, WITH OR WITHOUT INTERCONDYLAR EXTENSION; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2846, N'24065', N'BIOPSY, SOFT TISSUE OF UPPER ARM OR ELBOW AREA; SUPERFICIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2847, N'24071', N'EXCISION, TUMOR, SOFT TISSUE OF UPPER ARM OR ELBOW AREA, SUBCUTANEOUS; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2848, N'22680', N'THORACIC OR LUMBAR FUSION; ANTEROLATERAL OR ANTERIOR INTERBODY FUSION, TRANSTHORACIC APPROACH (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2849, N'22802', N'ARTHRODESIS, POSTERIOR, FOR SPINAL DEFORMITY, WITH OR WITHOUT CAST; 7 TO 12 VERTEBRAL SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2850, N'24073', N'EXCISION, TUMOR, SOFT TISSUE OF UPPER ARM OR ELBOW AREA, SUBFASCIAL (EG, INTRAMUSCULAR); 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2851, N'24075', N'EXCISION, TUMOR, SOFT TISSUE OF UPPER ARM OR ELBOW AREA, SUBCUTANEOUS; LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2852, N'24538', N'PERCUTANEOUS SKELETAL FIXATION OF SUPRACONDYLAR OR TRANSCONDYLAR HUMERAL FRACTURE, WITH OR WITHOUT INTERCONDYLAR EXTENSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2853, N'24546', N'OPEN TREATMENT OF HUMERAL SUPRACONDYLAR OR TRANSCONDYLAR FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED; WITH INTERCONDYLAR EXTENSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2854, N'22820', N'HARVESTING OF BONE AUTOGRAFT THROUGH SEPARATE INCISION (EG, ILIUM, FIBULA) FOR SPINAL ARTHRODESIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2855, N'22840', N'POSTERIOR NON-SEGMENTAL INSTRUMENTATION (EG, HARRINGTON ROD TECHNIQUE, PEDICLE FIXATION ACROSS 1 INTERSPACE, ATLANTOAXIAL TRANSARTICULAR SCREW FIXATION, SUBLAMINAR WIRING AT C1, FACET SCREW FIXATION) (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2856, N'24579', N'OPEN TREATMENT OF HUMERAL CONDYLAR FRACTURE, MEDIAL OR LATERAL, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2857, N'24581', N'TREATMENT OF CLOSED COMMINUTED ELBOW FRACTURE (FRACTURE DISTAL HUMERUS AND/OR PROXIMAL ULNA AND/OR PROXIMAL RADIUS), TREATMENT WITH TRACTION, (PIN OR SKIN); WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2858, N'22842', N'POSTERIOR SEGMENTAL INSTRUMENTATION (EG, PEDICLE FIXATION, DUAL RODS WITH MULTIPLE HOOKS AND SUBLAMINAR WIRES); 3 TO 6 VERTEBRAL SEGMENTS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2859, N'24586', N'OPEN TREATMENT OF PERIARTICULAR FRACTURE AND/OR DISLOCATION OF THE ELBOW (FRACTURE DISTAL HUMERUS AND PROXIMAL ULNA AND/ OR PROXIMAL RADIUS);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2860, N'22843', N'POSTERIOR SEGMENTAL INSTRUMENTATION (EG, PEDICLE FIXATION, DUAL RODS WITH MULTIPLE HOOKS AND SUBLAMINAR WIRES); 7 TO 12 VERTEBRAL SEGMENTS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2861, N'24610', N'TREATMENT OF OPEN ELBOW DISLOCATION, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2862, N'24650', N'CLOSED TREATMENT OF RADIAL HEAD OR NECK FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2863, N'22846', N'ANTERIOR INSTRUMENTATION; 4 TO 7 VERTEBRAL SEGMENTS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2864, N'22851', N'APPLICATION OF INTERVERTEBRAL BIOMECHANICAL DEVICE(S) (EG, SYNTHETIC CAGE(S), METHYLMETHACRYLATE) TO VERTEBRAL DEFECT OR INTERSPACE (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2865, N'24660', N'TREATMENT OF OPEN RADIAL HEAD OR NECK FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2866, N'24665', N'OPEN TREATMENT OF RADIAL HEAD OR NECK FRACTURE, INCLUDES INTERNAL FIXATION OR RADIAL HEAD EXCISION, WHEN PERFORMED;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2867, N'22855', N'REMOVAL OF ANTERIOR INSTRUMENTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2868, N'22857', N'TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, INCLUDING DISCECTOMY TO PREPARE INTERSPACE (OTHER THAN FOR DECOMPRESSION), SINGLE INTERSPACE, LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2869, N'24680', N'TREATMENT OF OPEN ULNAR FRACTURE, PROXIMAL END (OLECRANON PROCESS), WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2870, N'24700', N'MANIPULATION UNDER GENERAL ANESTHESIA (INCLUDES APPLICATION OF TRACTION OR OTHER FIXATION DEVICE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2871, N'22808', N'ARTHRODESIS, ANTERIOR, FOR SPINAL DEFORMITY, WITH OR WITHOUT CAST; 2 TO 3 VERTEBRAL SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2872, N'22812', N'ARTHRODESIS, ANTERIOR, FOR SPINAL DEFORMITY, WITH OR WITHOUT CAST; 8 OR MORE VERTEBRAL SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2873, N'24900', N'AMPUTATION, ARM THROUGH HUMERUS; WITH PRIMARY CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2874, N'24920', N'AMPUTATION, ARM THROUGH HUMERUS; OPEN, CIRCULAR (GUILLOTINE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2875, N'22861', N'REVISION INCLUDING REPLACEMENT OF TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, SINGLE INTERSPACE; CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2876, N'22865', N'REMOVAL OF TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, SINGLE INTERSPACE; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2877, N'24100', N'ARTHROTOMY, ELBOW; WITH SYNOVIAL BIOPSY ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2878, N'24102', N'ARTHROTOMY, ELBOW; WITH SYNOVECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2879, N'24110', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR, HUMERUS;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2880, N'22818', N'KYPHECTOMY, CIRCUMFERENTIAL EXPOSURE OF SPINE AND RESECTION OF VERTEBRAL SEGMENT(S) (INCLUDING BODY AND POSTERIOR ELEMENTS); SINGLE OR 2 SEGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2881, N'22900', N'EXCISION, TUMOR, SOFT TISSUE OF ABDOMINAL WALL, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2882, N'22904', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF ABDOMINAL WALL; LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2883, N'22841', N'INTERNAL SPINAL FIXATION BY WIRING OF SPINOUS PROCESSES (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2884, N'22845', N'ANTERIOR INSTRUMENTATION; 2 TO 3 VERTEBRAL SEGMENTS (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2885, N'23030', N'INCISION AND DRAINAGE, SHOULDER AREA; DEEP ABSCESS OR HEMATOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2886, N'23040', N'ARTHROTOMY, GLENOHUMERAL JOINT, INCLUDING EXPLORATION, DRAINAGE, OR REMOVAL OF FOREIGN BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2887, N'22848', N'PELVIC FIXATION (ATTACHMENT OF CAUDAL END OF INSTRUMENTATION TO PELVIC BONY STRUCTURES) OTHER THAN SACRUM (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2888, N'24940', N'CINEPLASTY, UPPER EXTREMITY, COMPLETE PROCEDURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2889, N'25005', N'TENDON SHEATH INCISION; AT WRIST FOR OTHER STENOSING TENOSYNOVITIS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2890, N'22849', N'REINSERTION OF SPINAL FIXATION DEVICE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2891, N'22850', N'REMOVAL OF POSTERIOR NONSEGMENTAL INSTRUMENTATION (EG, HARRINGTON ROD)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2892, N'22852', N'REMOVAL OF POSTERIOR SEGMENTAL INSTRUMENTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2893, N'23065', N'BIOPSY, SOFT TISSUE OF SHOULDER AREA; SUPERFICIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2894, N'23073', N'EXCISION, TUMOR, SOFT TISSUE OF SHOULDER AREA, SUBFASCIAL (EG, INTRAMUSCULAR); 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2895, N'24116', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR, HUMERUS; WITH ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2896, N'24120', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF HEAD OR NECK OF RADIUS OR OLECRANON PROCESS;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2897, N'23078', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF SHOULDER AREA; 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2898, N'23110', N'EXCISION, SUBACROMIAL (SUBDELTOID) BURSA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2899, N'24134', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), SHAFT OR DISTAL HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2900, N'24137', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), RADIAL HEAD OR NECK; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2901, N'25020', N'DECOMPRESSION FASCIOTOMY, FOREARM AND/OR WRIST, FLEXOR OR EXTENSOR COMPARTMENT; WITHOUT DEBRIDEMENT OF NONVIABLE MUSCLE AND/OR NERVE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2902, N'24145', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) BONE (EG, OSTEOMYELITIS), RADIAL HEAD OR NECK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2903, N'24147', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) BONE (EG, OSTEOMYELITIS), OLECRANON PROCESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2904, N'25023', N'DECOMPRESSION FASCIOTOMY, FOREARM AND/OR WRIST, FLEXOR OR EXTENSOR COMPARTMENT; WITH DEBRIDEMENT OF NONVIABLE MUSCLE AND/OR NERVE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2905, N'25031', N'INCISION AND DRAINAGE, FOREARM AND/OR WRIST; BURSA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2906, N'24148', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS), OLECRANON PROCESS; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2907, N'25065', N'BIOPSY, SOFT TISSUE OF FOREARM AND/OR WRIST; SUPERFICIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2908, N'25077', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF FOREARM AND/OR WRIST AREA; LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2909, N'24149', N'RADICAL RESECTION OF CAPSULE, SOFT TISSUE, AND HETEROTOPIC BONE, ELBOW, WITH CONTRACTURE RELEASE (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2910, N'24152', N'RADICAL RESECTION OF TUMOR, RADIAL HEAD OR NECK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2911, N'23120', N'CLAVICULECTOMY; PARTIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2912, N'23145', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF CLAVICLE OR SCAPULA; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2913, N'22856', N'TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, INCLUDING DISCECTOMY WITH END PLATE PREPARATION (INCLUDES OSTEOPHYTECTOMY FOR NERVE ROOT OR SPINAL CORD DECOMPRESSION AND MICRODISSECTION), SINGLE INTERSPACE, CERVICAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2914, N'23155', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF PROXIMAL HUMERUS; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2915, N'23171', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), CLAVICLE; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2916, N'22862', N'REVISION INCLUDING REPLACEMENT OF TOTAL DISC ARTHROPLASTY (ARTIFICIAL DISC), ANTERIOR APPROACH, SINGLE INTERSPACE; LUMBAR', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2917, N'22901', N'EXCISION, TUMOR, SOFT TISSUE OF ABDOMINAL WALL, SUBFASCIAL (EG, INTRAMUSCULAR); 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2918, N'23175', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), HUMERAL HEAD TO SURGICAL NECK; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 1900 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2919, N'23180', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) BONE (EG, OSTEOMYELITIS), CLAVICLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2920, N'22905', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF ABDOMINAL WALL; 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2921, N'22910', N'ABDOMINAL FASCIAL TRANSPLANTS, BILATERAL LOWMAN TYPE PROCEDURE) (INCLUDES OBTAINING ASCIA)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2922, N'23181', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS), CLAVICLE; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2923, N'25105', N'ARTHROTOMY, WRIST JOINT; WITH SYNOVECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2924, N'25115', N'RADICAL EXCISION OF BURSA, SYNOVIA OF WRIST, OR FOREARM TENDON SHEATHS (EG, TENOSYNOVITIS, FUNGUS, TBC, OR OTHER GRANULOMAS, RHEUMATOID ARTHRITIS); FLEXORS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2925, N'23182', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) BONE (EG, OSTEOMYELITIS), SCAPULA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2926, N'23184', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) BONE (EG, OSTEOMYELITIS), PROXIMAL HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2927, N'23042', N'ARTHROTOMY WITH EXPLORATION, DRAINAGE OR REMOVAL OF FOREIGN BODY, GLENOHUMERAL JOINT; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2928, N'23044', N'ARTHROTOMY, ACROMIOCLAVICULAR, STERNOCLAVICULAR JOINT, INCLUDING EXPLORATION, DRAINAGE, OR REMOVAL OF FOREIGN BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2929, N'24155', N'RESECTION OF ELBOW JOINT (ARTHRECTOMY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2930, N'24201', N'REMOVAL OF FOREIGN BODY, UPPER ARM OR ELBOW AREA; DEEP (SUBFASCIAL OR INTRAMUSCULAR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2931, N'23125', N'CLAVICULECTOMY; TOTAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2932, N'23170', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), CLAVICLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2933, N'23173', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), SCAPULA WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2934, N'25119', N'SYNOVECTOMY, EXTENSOR TENDON SHEATH, WRIST, SINGLE COMPARTMENT; WITH RESECTION OF DISTAL ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2935, N'25125', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF RADIUS OR ULNA (EXCLUDING HEAD OR NECK OF RADIUS AND OLECRANON PROCESS); WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2936, N'23185', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS), PROXIMAL HUMERUS; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2937, N'25126', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF RADIUS OR ULNA (EXCLUDING HEAD OR NECK OF RADIUS AND OLECRANON PROCESS); WITH ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2938, N'23220', N'RADICAL RESECTION OF TUMOR, PROXIMAL HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2939, N'23330', N'REMOVAL OF FOREIGN BODY, SHOULDER; SUBCUTANEOUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2940, N'23331', N'REMOVAL OF FOREIGN BODY, SHOULDER; DEEP (EG, NEER HEMIARTHROPLASTY REMOVAL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2941, N'23200', N'RADICAL RESECTION OF TUMOR; CLAVICLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2942, N'23210', N'RADICAL RESECTION OF TUMOR; SCAPULA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2943, N'23350', N'INJECTION PROCEDURE FOR SHOULDER ARTHROGRAPHY OR ENHANCED CT/MRI SHOULDER ARTHROGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2944, N'25153', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS); RADIUS OR ULNA, WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2945, N'23358', N'ARTHROSCOPY, SHOULDER, SURGICAL; WITH REMOVAL OF LOOSE BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2946, N'23406', N'TENOTOMY, SHOULDER AREA; MULTIPLE TENDONS THROUGH SAME INCISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2947, N'25260', N'REPAIR, TENDON OR MUSCLE, FLEXOR, FOREARM AND/OR WRIST; PRIMARY, SINGLE, EACH TENDON OR MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2948, N'25263', N'REPAIR, TENDON OR MUSCLE, FLEXOR, FOREARM AND/OR WRIST; SECONDARY, SINGLE, EACH TENDON OR MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2949, N'23415', N'CORACOACROMIAL LIGAMENT RELEASE, WITH OR WITHOUT ACROMIOPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2950, N'23440', N'RESECTION OR TRANSPLANTATION OF LONG TENDON OF BICEPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2951, N'24220', N'INJECTION PROCEDURE FOR ELBOW ARTHROGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2952, N'24330', N'FLEXOR-PLASTY, ELBOW (EG, STEINDLER TYPE ADVANCEMENT);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2953, N'24332', N'TENOLYSIS, TRICEPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2954, N'23357', N'ARTHROSCOPY, SHOULDER, SURGICAL; WITH SYNOVIAL BIOPSY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2955, N'23410', N'REPAIR OF RUPTURED MUSCULOTENDINOUS CUFF (EG, ROTATOR CUFF) OPEN; ACUTE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2956, N'24344', N'RECONSTRUCTION LATERAL COLLATERAL LIGAMENT, ELBOW, WITH TENDON GRAFT (INCLUDES HARVESTING OF GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2957, N'24356', N'FASCIOTOMY, LATERAL OR MEDIAL (EG, TENNIS ELBOW OR EPICONDYLITIS); WITH PARTIAL OSTECTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2958, N'25310', N'TENDON TRANSPLANTATION OR TRANSFER, FLEXOR OR EXTENSOR, FOREARM AND/OR WRIST, SINGLE; EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2959, N'25317', N'FLEXOR ORIGIN SLIDE FOR VOLKMANN CONTRACTURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2960, N'24430', N'REPAIR OF NONUNION OR MALUNION, HUMERUS; WITHOUT GRAFT (EG, COMPRESSION TECHNIQUE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2961, N'24505', N'CLOSED TREATMENT OF HUMERAL SHAFT FRACTURE; WITH MANIPULATION, WITH OR WITHOUT SKELETAL TRACTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2962, N'23412', N'REPAIR OF RUPTURED MUSCULOTENDINOUS CUFF (EG, ROTATOR CUFF) OPEN; CHRONIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2963, N'23420', N'RECONSTRUCTION OF COMPLETE SHOULDER (ROTATOR) CUFF AVULSION, CHRONIC (INCLUDES ACROMIOPLASTY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2964, N'24506', N'TREATMENT OF CLOSED HUMERAL SHAFT FRACTURE; PERCUTANEOUS INSERTION OF PIN OR ROD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2965, N'24510', N'TREATMENT OF OPEN HUMERAL SHAFT FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2966, N'25320', N'CAPSULORRHAPHY OR RECONSTRUCTION, WRIST, OPEN (EG, CAPSULODESIS, LIGAMENT REPAIR, TENDON TRANSFER OR GRAFT) (INCLUDES SYNOVECTOMY, CAPSULOTOMY AND OPEN REDUCTION) FOR CARPAL INSTABILITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2967, N'23460', N'CAPSULORRHAPHY, ANTERIOR, ANY TYPE; WITH BONE BLOCK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2968, N'23490', N'PROPHYLACTIC TREATMENT (NAILING, PINNING, PLATING OR WIRING) WITH OR WITHOUT METHYLMETHACRYLATE; CLAVICLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2969, N'24535', N'CLOSED TREATMENT OF SUPRACONDYLAR OR TRANSCONDYLAR HUMERAL FRACTURE, WITH OR WITHOUT INTERCONDYLAR EXTENSION; WITH MANIPULATION, WITH OR WITHOUT SKIN OR SKELETAL TRACTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2970, N'24540', N'TREATMENT OF OPEN HUMERAL SUPRACONDYLAR OR TRANSCONDYLAR FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2971, N'24566', N'PERCUTANEOUS SKELETAL FIXATION OF HUMERAL EPICONDYLAR FRACTURE, MEDIAL OR LATERAL, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2972, N'23450', N'CAPSULORRHAPHY, ANTERIOR; PUTTI-PLATT PROCEDURE OR MAGNUSON TYPE OPERATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2973, N'23465', N'CAPSULORRHAPHY, GLENOHUMERAL JOINT, POSTERIOR, WITH OR WITHOUT BONE BLOCK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2974, N'24570', N'TREATMENT OF OPEN HUMERAL EPICONDYLAR FRACTURE, MEDIAL OR LATERAL, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2975, N'24582', N'PERCUTANEOUS SKELETAL FIXATION OF HUMERAL CONDYLAR FRACTURE, MEDIAL OR LATERAL, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2976, N'25332', N'ARTHROPLASTY, WRIST, WITH OR WITHOUT INTERPOSITION, WITH OR WITHOUT EXTERNAL OR INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2977, N'25335', N'CENTRALIZATION OF WRIST ON ULNA (EG, RADIAL CLUB HAND)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2978, N'24583', N'TREATMENT OF OPEN COMMINUTED ELBOW FRACTURE (FRACTURE DISTAL HUMERUS AND/OR PROXIMAL ULNA AND/OR PROXIMAL RADIUS), WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2979, N'23466', N'CAPSULORRHAPHY, GLENOHUMERAL JOINT, ANY TYPE MULTI-DIRECTIONAL INSTABILITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2980, N'23485', N'OSTEOTOMY, CLAVICLE, WITH OR WITHOUT INTERNAL FIXATION; WITH BONE GRAFT FOR NONUNION OR MALUNION (INCLUDES OBTAINING GRAFT AND/OR NECESSARY FIXATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2981, N'24588', N'OPEN TREATMENT OF CLOSED OR OPEN COMMINUTED ELBOW FRACTURE (FRACTURE DISTAL HUMERUS AND/OR PROXIMAL ULNA/RADIUS), WITH OR WITHOUT INTERNAL OR EXTERNAL SKELETAL FIXATION; WITH IMPLANTS AND FASCIA LATA LIGAMENT RECONSTRUCTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2982, N'23580', N'TREATMENT OF OPEN SCAPULAR FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2983, N'23655', N'CLOSED TREATMENT OF SHOULDER DISLOCATION, WITH MANIPULATION; REQUIRING ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2984, N'24605', N'TREATMENT OF CLOSED ELBOW DISLOCATION; REQUIRING ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2985, N'24635', N'OPEN TREATMENT OF MONTEGGIA TYPE OF FRACTURE DISLOCATION AT ELBOW (FRACTURE PROXIMAL END OF ULNA WITH DISLOCATION OF RADIAL HEAD), INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2986, N'23800', N'ARTHRODESIS, GLENOHUMERAL JOINT;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2987, N'23900', N'INTERTHORACOSCAPULAR AMPUTATION (FOREQUARTER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2988, N'23931', N'INCISION AND DRAINAGE, UPPER ARM OR ELBOW AREA; BURSA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2989, N'24655', N'CLOSED TREATMENT OF RADIAL HEAD OR NECK FRACTURE; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2990, N'24675', N'CLOSED TREATMENT OF ULNAR FRACTURE, PROXIMAL END (EG, OLECRANON OR CORONOID PROCESS[ES]); WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2991, N'25337', N'RECONSTRUCTION FOR STABILIZATION OF UNSTABLE DISTAL ULNA OR DISTAL RADIOULNAR JOINT, SECONDARY BY SOFT TISSUE STABILIZATION (EG, TENDON TRANSFER, TENDON GRAFT OR WEAVE, OR TENODESIS) WITH OR WITHOUT OPEN REDUCTION OF DISTAL RADIOULNAR JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2992, N'23491', N'PROPHYLACTIC TREATMENT (NAILING, PINNING, PLATING OR WIRING) WITH OR WITHOUT METHYLMETHACRYLATE; PROXIMAL HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2993, N'23500', N'CLOSED TREATMENT OF CLAVICULAR FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2994, N'25360', N'OSTEOTOMY; ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2995, N'25400', N'REPAIR OF NONUNION OR MALUNION, RADIUS OR ULNA; WITHOUT GRAFT (EG, COMPRESSION TECHNIQUE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2996, N'25405', N'REPAIR OF NONUNION OR MALUNION, RADIUS OR ULNA; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2997, N'23525', N'CLOSED TREATMENT OF STERNOCLAVICULAR DISLOCATION; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2998, N'23570', N'CLOSED TREATMENT OF SCAPULAR FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (2999, N'25431', N'REPAIR OF NONUNION OF CARPAL BONE (EXCLUDING CARPAL SCAPHOID (NAVICULAR)) (INCLUDES OBTAINING GRAFT AND NECESSARY FIXATION), EACH BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3000, N'24685', N'OPEN TREATMENT OF ULNAR FRACTURE, PROXIMAL END (EG, OLECRANON OR CORONOID PROCESS[ES]), INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3001, N'24930', N'AMPUTATION, ARM THROUGH HUMERUS; RE-AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3002, N'24006', N'ARTHROTOMY OF THE ELBOW, WITH CAPSULAR EXCISION FOR CAPSULAR RELEASE (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3003, N'24066', N'BIOPSY, SOFT TISSUE OF UPPER ARM OR ELBOW AREA; DEEP (SUBFASCIAL OR INTRAMUSCULAR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3004, N'24931', N'AMPUTATION, ARM THROUGH HUMERUS; WITH IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3005, N'25025', N'DECOMPRESSION FASCIOTOMY, FOREARM AND/OR WRIST, FLEXOR AND EXTENSOR COMPARTMENT; WITH DEBRIDEMENT OF NONVIABLE MUSCLE AND/OR NERVE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3006, N'23605', N'CLOSED TREATMENT OF PROXIMAL HUMERAL (SURGICAL OR ANATOMICAL NECK) FRACTURE; WITH MANIPULATION, WITH OR WITHOUT SKELETAL TRACTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3007, N'23610', N'TREATMENT OF OPEN HUMERAL (SURGICAL OR ANATOMICAL NECK) FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3008, N'25075', N'EXCISION, TUMOR, SOFT TISSUE OF FOREARM AND/OR WRIST AREA, SUBCUTANEOUS; LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3009, N'25107', N'ARTHROTOMY, DISTAL RADIOULNAR JOINT INCLUDING REPAIR OF TRIANGULAR CARTILAGE, COMPLEX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3010, N'24079', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF UPPER ARM OR ELBOW AREA; 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3011, N'24101', N'ARTHROTOMY, ELBOW; WITH JOINT EXPLORATION, WITH OR WITHOUT BIOPSY, WITH OR WITHOUT REMOVAL OF LOOSE OR FOREIGN BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3012, N'25440', N'REPAIR OF NONUNION, SCAPHOID CARPAL (NAVICULAR) BONE, WITH OR WITHOUT RADIAL STYLOIDECTOMY (INCLUDES OBTAINING GRAFT AND NECESSARY FIXATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3013, N'24105', N'EXCISION, OLECRANON BURSA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3014, N'24151', N'RADICAL RESECTION FOR TUMOR, SHAFT OR DISTAL HUMERUS; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3015, N'25442', N'ARTHROPLASTY WITH PROSTHETIC REPLACEMENT; DISTAL ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3016, N'25443', N'ARTHROPLASTY WITH PROSTHETIC REPLACEMENT; SCAPHOID CARPAL (NAVICULAR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3017, N'24200', N'REMOVAL OF FOREIGN BODY, UPPER ARM OR ELBOW AREA; SUBCUTANEOUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3018, N'24320', N'TENOPLASTY, WITH MUSCLE TRANSFER, WITH OR WITHOUT FREE GRAFT, ELBOW TO SHOULDER, SINGLE (SEDDON-BROOKES TYPE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3019, N'25444', N'ARTHROPLASTY WITH PROSTHETIC REPLACEMENT; LUNATE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 2000 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3020, N'25445', N'ARTHROPLASTY WITH PROSTHETIC REPLACEMENT; TRAPEZIUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3021, N'25449', N'REVISION OF ARTHROPLASTY, INCLUDING REMOVAL OF IMPLANT, WRIST JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3022, N'24331', N'FLEXOR-PLASTY, ELBOW (EG, STEINDLER TYPE ADVANCEMENT); WITH EXTENSOR ADVANCEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3023, N'24341', N'REPAIR, TENDON OR MUSCLE, UPPER ARM OR ELBOW, EACH TENDON OR MUSCLE, PRIMARY OR SECONDARY (EXCLUDES ROTATOR CUFF)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3024, N'23616', N'OPEN TREATMENT OF PROXIMAL HUMERAL (SURGICAL OR ANATOMICAL NECK) FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED, INCLUDES REPAIR OF TUBEROSITY(S), WHEN PERFORMED; WITH PROXIMAL HUMERAL PROSTHETIC REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3025, N'24343', N'REPAIR LATERAL COLLATERAL LIGAMENT, ELBOW, WITH LOCAL TISSUE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3026, N'24350', N'FASCIOTOMY, LATERAL OR MEDIAL (EG, TENNIS ELBOW OR EPICONDYLITIS);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3027, N'23660', N'OPEN TREATMENT OF ACUTE SHOULDER DISLOCATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3028, N'23665', N'CLOSED TREATMENT OF SHOULDER DISLOCATION, WITH FRACTURE OF GREATER HUMERAL TUBEROSITY, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3029, N'25110', N'EXCISION, LESION OF TENDON SHEATH, FOREARM AND/OR WRIST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3030, N'25111', N'EXCISION OF GANGLION, WRIST (DORSAL OR VOLAR); PRIMARY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3031, N'25450', N'EPIPHYSEAL ARREST BY EPIPHYSIODESIS OR STAPLING; DISTAL RADIUS OR ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3032, N'25491', N'PROPHYLACTIC TREATMENT (NAILING, PINNING, PLATING OR WIRING) WITH OR WITHOUT METHYLMETHACRYLATE; ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3033, N'25112', N'EXCISION OF GANGLION, WRIST (DORSAL OR VOLAR); RECURRENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3034, N'25130', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF CARPAL BONES;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3035, N'25545', N'OPEN TREATMENT OF ULNAR SHAFT FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3036, N'25560', N'CLOSED TREATMENT OF RADIAL AND ULNAR SHAFT FRACTURES; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3037, N'25136', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF CARPAL BONES; WITH ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3038, N'25145', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), FOREARM AND/OR WRIST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3039, N'25570', N'TREATMENT OF OPEN RADIAL AND ULNAR SHAFT FRACTURES, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3040, N'25575', N'OPEN TREATMENT OF RADIAL AND ULNAR SHAFT FRACTURES, WITH INTERNAL FIXATION, WHEN PERFORMED; OF RADIUS AND ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3041, N'25146', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS); WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3042, N'25150', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS); ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3043, N'25608', N'OPEN TREATMENT OF DISTAL RADIAL INTRA-ARTICULAR FRACTURE OR EPIPHYSEAL SEPARATION; WITH INTERNAL FIXATION OF 2 FRAGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3044, N'25622', N'CLOSED TREATMENT OF CARPAL SCAPHOID (NAVICULAR) FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3045, N'25210', N'CARPECTOMY; 1 BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3046, N'25215', N'CARPECTOMY; ALL BONES OF PROXIMAL ROW', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3047, N'25240', N'EXCISION DISTAL ULNA PARTIAL OR COMPLETE (EG, DARRACH TYPE OR MATCHED RESECTION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3048, N'25630', N'CLOSED TREATMENT OF CARPAL BONE FRACTURE (EXCLUDING CARPAL SCAPHOID [NAVICULAR]); WITHOUT MANIPULATION, EACH BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3049, N'25640', N'TREATMENT OF OPEN CARPAL BONE FRACTURE (EXCLUDING CARPAL SCAPHOID (NAVICULAR)), WITH UNCOMPLICATED SOFT TISSUE CLOSURE, EACH BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3050, N'25246', N'INJECTION PROCEDURE FOR WRIST ARTHROGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3051, N'25248', N'EXPLORATION WITH REMOVAL OF DEEP FOREIGN BODY, FOREARM OR WRIST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3052, N'25259', N'MANIPULATION, WRIST, UNDER ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3053, N'25660', N'CLOSED TREATMENT OF RADIOCARPAL OR INTERCARPAL DISLOCATION, 1 OR MORE BONES, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3054, N'25675', N'CLOSED TREATMENT OF DISTAL RADIOULNAR DISLOCATION WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3055, N'25270', N'REPAIR, TENDON OR MUSCLE, EXTENSOR, FOREARM AND/OR WRIST; PRIMARY, SINGLE, EACH TENDON OR MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3056, N'25290', N'TENOTOMY, OPEN, FLEXOR OR EXTENSOR TENDON, FOREARM AND/OR WRIST, SINGLE, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3057, N'25695', N'OPEN TREATMENT OF LUNATE DISLOCATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3058, N'25700', N'MANIPULATION OF JOINT UNDER GENERAL ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3059, N'25810', N'ARTHRODESIS, WRIST; WITH ILIAC OR OTHER AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3060, N'25312', N'TENDON TRANSPLANTATION OR TRANSFER, FLEXOR OR EXTENSOR, FOREARM AND/OR WRIST, SINGLE; WITH TENDON GRAFT(S) (INCLUDES OBTAINING GRAFT), EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3061, N'24361', N'ARTHROPLASTY, ELBOW; WITH DISTAL HUMERAL PROSTHETIC REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3062, N'24366', N'ARTHROPLASTY, RADIAL HEAD; WITH IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3063, N'24410', N'MULTIPLE OSTEOTOMIES WITH REALIGNMENT ON INTRAMEDULLARY ROD, HUMERAL SHAFT (SOFIELD TYPE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3064, N'23675', N'CLOSED TREATMENT OF SHOULDER DISLOCATION, WITH SURGICAL OR ANATOMICAL NECK FRACTURE, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3065, N'23920', N'DISARTICULATION OF SHOULDER;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3066, N'25900', N'AMPUTATION, FOREARM, THROUGH RADIUS AND ULNA;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3067, N'25905', N'AMPUTATION, FOREARM, THROUGH RADIUS AND ULNA; OPEN, CIRCULAR (GUILLOTINE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3068, N'23930', N'INCISION AND DRAINAGE, UPPER ARM OR ELBOW AREA; DEEP ABSCESS OR HEMATOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3069, N'24076', N'EXCISION, TUMOR, SOFT TISSUE OF UPPER ARM OR ELBOW AREA, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3070, N'25330', N'ARTHROPLASTY, WRIST;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3071, N'25331', N'ARTHROPLASTY, WRIST; WITH IMPLANT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3072, N'25350', N'OSTEOTOMY, RADIUS; DISTAL THIRD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3073, N'24115', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR, HUMERUS; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3074, N'24135', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), SHAFT OR DISTAL HUMERUS; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3075, N'25909', N'AMPUTATION, FOREARM, THROUGH RADIUS AND ULNA; RE-AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3076, N'25924', N'DISARTICULATION THROUGH WRIST; RE-AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3077, N'25927', N'TRANSMETACARPAL AMPUTATION;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3078, N'24435', N'REPAIR OF NONUNION OR MALUNION, HUMERUS; WITH ILIAC OR OTHER AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3079, N'24470', N'HEMIEPIPHYSEAL ARREST (EG, CUBITUS VARUS OR VALGUS, DISTAL HUMERUS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3080, N'25929', N'TRANSMETACARPAL AMPUTATION; SECONDARY CLOSURE OR SCAR REVISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3081, N'26010', N'DRAINAGE OF FINGER ABSCESS; SIMPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3082, N'26011', N'DRAINAGE OF FINGER ABSCESS; COMPLICATED (EG, FELON)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3083, N'24495', N'DECOMPRESSION FASCIOTOMY, FOREARM, WITH BRACHIAL ARTERY EXPLORATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3084, N'24536', N'TREATMENT OF CLOSED HUMERAL SUPRACONDYLAR OR TRANSCONDYLAR FRACTURE, WITH MANIPULATION; WITH TRACTION (PIN OR SKIN)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3085, N'24138', N'SEQUESTRECTOMY (EG, FOR OSTEOMYELITIS OR BONE ABSCESS), OLECRANON PROCESS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3086, N'24140', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) BONE (EG, OSTEOMYELITIS), HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3087, N'25392', N'OSTEOPLASTY, RADIUS AND ULNA; SHORTENING (EXCLUDING 64876)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3088, N'25394', N'OSTEOPLASTY, CARPAL BONE, SHORTENING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3089, N'25415', N'REPAIR OF NONUNION OR MALUNION, RADIUS AND ULNA; WITHOUT GRAFT (EG, COMPRESSION TECHNIQUE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3090, N'24144', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS), HUMERUS; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3091, N'24150', N'RADICAL RESECTION OF TUMOR, SHAFT OR DISTAL HUMERUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3092, N'25420', N'REPAIR OF NONUNION OR MALUNION, RADIUS AND ULNA; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3093, N'25505', N'CLOSED TREATMENT OF RADIAL SHAFT FRACTURE; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3094, N'24160', N'IMPLANT REMOVAL; ELBOW JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3095, N'24301', N'MUSCLE OR TENDON TRANSFER, ANY TYPE, UPPER ARM OR ELBOW, SINGLE (EXCLUDING 24320-24331)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3096, N'24542', N'TREATMENT OF OPEN HUMERAL SUPRACONDYLAR OR TRANSCONDYLAR FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE; WITH TRACTION (PIN OR SKIN)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3097, N'24310', N'TENOTOMY, OPEN, ELBOW TO SHOULDER, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3098, N'24340', N'TENODESIS OF BICEPS TENDON AT ELBOW (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3099, N'24346', N'RECONSTRUCTION MEDIAL COLLATERAL LIGAMENT, ELBOW, WITH TENDON GRAFT (INCLUDES HARVESTING OF GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3100, N'24351', N'FASCIOTOMY, LATERAL OR MEDIAL (EG, TENNIS ELBOW OR EPICONDYLITIS); WITH EXTENSOR ORIGIN DETACHMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3101, N'24352', N'FASCIOTOMY, LATERAL OR MEDIAL (EG, TENNIS ELBOW OR EPICONDYLITIS); WITH ANNULAR LIGAMENT RESECTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3102, N'24545', N'OPEN TREATMENT OF HUMERAL SUPRACONDYLAR OR TRANSCONDYLAR FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED; WITHOUT INTERCONDYLAR EXTENSION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3103, N'24360', N'ARTHROPLASTY, ELBOW; WITH MEMBRANE (EG, FASCIAL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3104, N'24363', N'ARTHROPLASTY, ELBOW; WITH DISTAL HUMERUS AND PROXIMAL ULNAR PROSTHETIC REPLACEMENT (EG, TOTAL ELBOW)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3105, N'24560', N'CLOSED TREATMENT OF HUMERAL EPICONDYLAR FRACTURE, MEDIAL OR LATERAL; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3106, N'24577', N'CLOSED TREATMENT OF HUMERAL CONDYLAR FRACTURE, MEDIAL OR LATERAL; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3107, N'24365', N'ARTHROPLASTY, RADIAL HEAD;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3108, N'24420', N'OSTEOPLASTY, HUMERUS (EG, SHORTENING OR LENGTHENING) (EXCLUDING 64876)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3109, N'24498', N'PROPHYLACTIC TREATMENT (NAILING, PINNING, PLATING OR WIRING), WITH OR WITHOUT METHYLMETHACRYLATE, HUMERAL SHAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3110, N'24578', N'TREATMENT OF OPEN HUMERAL CONDYLAR FRACTURE, MEDIAL OR LATERAL, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3111, N'24585', N'OPEN TREATMENT OF CLOSED OR OPEN COMMINUTED ELBOW FRACTURE (FRACTURE DISTAL HUMERUS AND/OR PROXIMAL ULNA/RADIUS), WITH OR WITHOUT INTERNAL OR EXTERNAL SKELETAL FIXATION;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3112, N'26030', N'DRAINAGE OF PALMAR BURSA; MULTIPLE BURSA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3113, N'26040', N'FASCIOTOMY, PALMAR (EG, DUPUYTREN''S CONTRACTURE); PERCUTANEOUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3114, N'26105', N'ARTHROTOMY WITH BIOPSY; METACARPOPHALANGEAL JOINT, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3115, N'24615', N'OPEN TREATMENT OF ACUTE OR CHRONIC ELBOW DISLOCATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3116, N'24666', N'OPEN TREATMENT OF RADIAL HEAD OR NECK FRACTURE, INCLUDES INTERNAL FIXATION OR RADIAL HEAD EXCISION, WHEN PERFORMED; WITH RADIAL HEAD PROSTHETIC REPLACEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3117, N'26120', N'FASCIECTOMY, PALMAR, SIMPLE, FOR DUPUYTREN''S CONTRACTURE; PARTIAL EXCISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3118, N'26123', N'FASCIECTOMY, PARTIAL PALMAR WITH RELEASE OF SINGLE DIGIT INCLUDING PROXIMAL INTERPHALANGEAL JOINT, WITH OR WITHOUT Z-PLASTY, OTHER LOCAL TISSUE REARRANGEMENT, OR SKIN GRAFTING (INCLUDES OBTAINING GRAFT);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3119, N'24800', N'ARTHRODESIS, ELBOW JOINT; LOCAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3120, N'24802', N'ARTHRODESIS, ELBOW JOINT; WITH AUTOGENOUS GRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 2100 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3121, N'24935', N'STUMP ELONGATION, UPPER EXTREMITY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3122, N'26135', N'SYNOVECTOMY, METACARPOPHALANGEAL JOINT INCLUDING INTRINSIC RELEASE AND EXTENSOR HOOD RECONSTRUCTION, EACH DIGIT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3123, N'26216', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF PROXIMAL, MIDDLE OR DISTAL PHALANX; WITH HOMOGENOUS OR OTHER NONAUTOGENOUS GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3124, N'25515', N'OPEN TREATMENT OF RADIAL SHAFT FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3125, N'25535', N'CLOSED TREATMENT OF ULNAR SHAFT FRACTURE; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3126, N'26340', N'MANIPULATION, FINGER JOINT, UNDER ANESTHESIA, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3127, N'26341', N'MANIPULATION, PALMAR FASCIAL CORD (IE, DUPUYTREN''S CORD), POST ENZYME INJECTION (EG, COLLAGENASE), SINGLE CORD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3128, N'25540', N'TREATMENT OF OPEN ULNAR SHAFT FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3129, N'25574', N'OPEN TREATMENT OF RADIAL AND ULNAR SHAFT FRACTURES, WITH INTERNAL FIXATION, WHEN PERFORMED; OF RADIUS OR ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3130, N'24531', N'TREATMENT OF CLOSED HUMERAL SUPRACONDYLAR OR TRANSCONDYLAR FRACTURE, WITHOUT MANIPULATION; WITH TRACTION (PIN OR SKIN)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3131, N'24565', N'CLOSED TREATMENT OF HUMERAL EPICONDYLAR FRACTURE, MEDIAL OR LATERAL; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3132, N'26358', N'REPAIR OR ADVANCEMENT, FLEXOR TENDON, IN ZONE 2 DIGITAL FLEXOR TENDON SHEATH (EG, NO MAN''S LAND); SECONDARY WITH FREE GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3133, N'25607', N'OPEN TREATMENT OF DISTAL RADIAL EXTRA-ARTICULAR FRACTURE OR EPIPHYSEAL SEPARATION, WITH INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3134, N'25609', N'OPEN TREATMENT OF DISTAL RADIAL INTRA-ARTICULAR FRACTURE OR EPIPHYSEAL SEPARATION; WITH INTERNAL FIXATION OF 3 OR MORE FRAGMENTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3135, N'26370', N'REPAIR OR ADVANCEMENT OF PROFUNDUS TENDON, WITH INTACT SUPERFICIALIS TENDON; PRIMARY, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3136, N'26372', N'REPAIR OR ADVANCEMENT OF PROFUNDUS TENDON, WITH INTACT SUPERFICIALIS TENDON; SECONDARY WITH FREE GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3137, N'25611', N'PERCUTANEOUS SKELETAL FIXATION OF DISTAL RADIAL FRACTURE (EG, COLLES OR SMITH TYPE) OR EPIPHYSEAL SEPARATION, WITH OR WITHOUT FRACTURE OF ULNAR STYLOID, REQUIRING MANIPULATION, WITH OR WITHOUT EXTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3138, N'24999', N'UNLISTED PROCEDURE, HUMERUS OR ELBOW', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3139, N'25001', N'INCISION, FLEXOR TENDON SHEATH, WRIST (EG, FLEXOR CARPI RADIALIS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3140, N'25035', N'INCISION, DEEP, BONE CORTEX, FOREARM AND/OR WRIST (EG, OSTEOMYELITIS OR BONE ABSCESS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3141, N'25615', N'TREATMENT OF OPEN DISTAL RADIAL FRACTURE (EG, COLLES OR SMITH TYPE) OR EPIPHYSEAL SEPARATION, WITH OR WITHOUT FRACTURE OF ULNAR STYLOID, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3142, N'25036', N'INCISION, DEEP, WITH OPENING OF CORTEX (EG, FOR OSTEOMYELITIS OR BONE ABSCESS); WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3143, N'25066', N'BIOPSY, SOFT TISSUE OF FOREARM AND/OR WRIST; DEEP (SUBFASCIAL OR INTRAMUSCULAR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3144, N'25626', N'TREATMENT OF OPEN CARPAL SCAPHOID (NAVICULAR) FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3145, N'25628', N'OPEN TREATMENT OF CARPAL SCAPHOID (NAVICULAR) FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3146, N'25073', N'EXCISION, TUMOR, SOFT TISSUE OF FOREARM AND/OR WRIST AREA, SUBFASCIAL (EG, INTRAMUSCULAR); 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3147, N'25100', N'ARTHROTOMY, WRIST JOINT; WITH BIOPSY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3148, N'26373', N'REPAIR OR ADVANCEMENT OF PROFUNDUS TENDON, WITH INTACT SUPERFICIALIS TENDON; SECONDARY WITHOUT FREE GRAFT, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3149, N'26390', N'EXCISION FLEXOR TENDON, WITH IMPLANTATION OF SYNTHETIC ROD FOR DELAYED TENDON GRAFT, HAND OR FINGER, EACH ROD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3150, N'24575', N'OPEN TREATMENT OF HUMERAL EPICONDYLAR FRACTURE, MEDIAL OR LATERAL, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3151, N'24576', N'CLOSED TREATMENT OF HUMERAL CONDYLAR FRACTURE, MEDIAL OR LATERAL; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3152, N'26392', N'REMOVAL OF SYNTHETIC ROD AND INSERTION OF FLEXOR TENDON GRAFT, HAND OR FINGER (INCLUDES OBTAINING GRAFT), EACH ROD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3153, N'26412', N'REPAIR, EXTENSOR TENDON, HAND, PRIMARY OR SECONDARY; WITH FREE GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3154, N'24580', N'TREATMENT OF CLOSED COMMINUTED ELBOW FRACTURE (FRACTURE DISTAL HUMERUS AND/OR PROXIMAL ULNA AND/OR PROXIMAL RADIUS), TREATMENT WITH TRACTION, (PIN OR SKIN); WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3155, N'24587', N'OPEN TREATMENT OF PERIARTICULAR FRACTURE AND/OR DISLOCATION OF THE ELBOW (FRACTURE DISTAL HUMERUS AND PROXIMAL ULNA AND/ OR PROXIMAL RADIUS); WITH IMPLANT ARTHROPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3156, N'25651', N'PERCUTANEOUS SKELETAL FIXATION OF ULNAR STYLOID FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3157, N'25652', N'OPEN TREATMENT OF ULNAR STYLOID FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3158, N'25670', N'OPEN TREATMENT OF RADIOCARPAL OR INTERCARPAL DISLOCATION, 1 OR MORE BONES', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3159, N'24600', N'TREATMENT OF CLOSED ELBOW DISLOCATION; WITHOUT ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3160, N'24620', N'CLOSED TREATMENT OF MONTEGGIA TYPE OF FRACTURE DISLOCATION AT ELBOW (FRACTURE PROXIMAL END OF ULNA WITH DISLOCATION OF RADIAL HEAD), WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3161, N'25671', N'PERCUTANEOUS SKELETAL FIXATION OF DISTAL RADIOULNAR DISLOCATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3162, N'25676', N'OPEN TREATMENT OF DISTAL RADIOULNAR DISLOCATION, ACUTE OR CHRONIC', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3163, N'24625', N'TREATMENT OF OPEN MONTEGGIA TYPE OF FRACTURE DISLOCATION AT ELBOW (FRACTURE PROXIMAL END OF ULNA WITH DISLOCATION OF RADIAL HEAD), WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3164, N'25680', N'CLOSED TREATMENT OF TRANS-SCAPHOPERILUNAR TYPE OF FRACTURE DISLOCATION, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3165, N'25820', N'ARTHRODESIS, WRIST; LIMITED, WITHOUT BONE GRAFT (EG, INTERCARPAL OR RADIOCARPAL)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3166, N'24640', N'CLOSED TREATMENT OF RADIAL HEAD SUBLUXATION IN CHILD, NURSEMAID ELBOW, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3167, N'24670', N'CLOSED TREATMENT OF ULNAR FRACTURE, PROXIMAL END (EG, OLECRANON OR CORONOID PROCESS[ES]); WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3168, N'25920', N'DISARTICULATION THROUGH WRIST;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3169, N'25999', N'UNLISTED PROCEDURE, FOREARM OR WRIST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3170, N'26070', N'ARTHROTOMY, WITH EXPLORATION, DRAINAGE, OR REMOVAL OF LOOSE OR FOREIGN BODY; CARPOMETACARPAL JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3171, N'24925', N'AMPUTATION, ARM THROUGH HUMERUS; SECONDARY CLOSURE OR SCAR REVISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3172, N'25000', N'INCISION, EXTENSOR TENDON SHEATH, WRIST (EG, DEQUERVAINS DISEASE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3173, N'26420', N'REPAIR, EXTENSOR TENDON, FINGER, PRIMARY OR SECONDARY; WITH FREE GRAFT (INCLUDES OBTAINING GRAFT) EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3174, N'26437', N'REALIGNMENT OF EXTENSOR TENDON, HAND, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3175, N'25101', N'ARTHROTOMY, WRIST JOINT; WITH JOINT EXPLORATION, WITH OR WITHOUT BIOPSY, WITH OR WITHOUT REMOVAL OF LOOSE OR FOREIGN BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3176, N'25109', N'EXCISION OF TENDON, FOREARM AND/OR WRIST, FLEXOR OR EXTENSOR, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3177, N'26442', N'TENOLYSIS, FLEXOR TENDON; PALM AND FINGER, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3178, N'26445', N'TENOLYSIS, EXTENSOR TENDON, HAND OR FINGER; EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3179, N'25116', N'RADICAL EXCISION OF BURSA, SYNOVIA OF WRIST, OR FOREARM TENDON SHEATHS (EG, TENOSYNOVITIS, FUNGUS, TBC, OR OTHER GRANULOMAS, RHEUMATOID ARTHRITIS); EXTENSORS, WITH OR WITHOUT TRANSPOSITION OF DORSAL RETINACULUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3180, N'26479', N'SHORTENING OF TENDON, FLEXOR, HAND OR FINGER, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3181, N'26489', N'TRANSFER OR TRANSPLANT OF TENDON, PALMAR; WITH FREE TENDON GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3182, N'25250', N'REMOVAL OF WRIST PROSTHESIS; (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3183, N'25251', N'REMOVAL OF WRIST PROSTHESIS; COMPLICATED, INCLUDING TOTAL WRIST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3184, N'26100', N'ARTHROTOMY WITH BIOPSY; CARPOMETACARPAL JOINT, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3185, N'26110', N'ARTHROTOMY WITH BIOPSY; INTERPHALANGEAL JOINT, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3186, N'26113', N'EXCISION, TUMOR, SOFT TISSUE, OR VASCULAR MALFORMATION, OF HAND OR FINGER, SUBFASCIAL (EG, INTRAMUSCULAR); 1.5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3187, N'26494', N'OPPONENSPLASTY; HYPOTHENAR MUSCLE TRANSFER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3188, N'26497', N'TRANSFER OF TENDON TO RESTORE INTRINSIC FUNCTION; RING AND SMALL FINGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3189, N'25272', N'REPAIR, TENDON OR MUSCLE, EXTENSOR, FOREARM AND/OR WRIST; SECONDARY, SINGLE, EACH TENDON OR MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3190, N'25280', N'LENGTHENING OR SHORTENING OF FLEXOR OR EXTENSOR TENDON, FOREARM AND/OR WRIST, SINGLE, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3191, N'26500', N'RECONSTRUCTION OF TENDON PULLEY, EACH TENDON; WITH LOCAL TISSUES (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3192, N'26504', N'RECONSTRUCTION OF TENDON PULLEY, EACH TENDON; WITH TENDON PROSTHESIS (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3193, N'25024', N'DECOMPRESSION FASCIOTOMY, FOREARM AND/OR WRIST, FLEXOR AND EXTENSOR COMPARTMENT; WITHOUT DEBRIDEMENT OF NONVIABLE MUSCLE AND/OR NERVE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3194, N'26516', N'CAPSULODESIS, METACARPOPHALANGEAL JOINT; SINGLE DIGIT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3195, N'26518', N'CAPSULODESIS, METACARPOPHALANGEAL JOINT; 3 OR 4 DIGITS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3196, N'26545', N'RECONSTRUCTION, COLLATERAL LIGAMENT, INTERPHALANGEAL JOINT, SINGLE, INCLUDING GRAFT, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3197, N'25028', N'INCISION AND DRAINAGE, FOREARM AND/OR WRIST; DEEP ABSCESS OR HEMATOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3198, N'25040', N'ARTHROTOMY, RADIOCARPAL OR MIDCARPAL JOINT, WITH EXPLORATION, DRAINAGE, OR REMOVAL OF FOREIGN BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3199, N'26116', N'EXCISION, TUMOR, SOFT TISSUE, OR VASCULAR MALFORMATION, OF HAND OR FINGER, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 1.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3200, N'26122', N'FASCIECTOMY, PALMAR, SIMPLE, FOR DUPUYTREN''S CONTRACTURE; UP TO ONE-HALF PALMAR FASCIA, WITH SINGLE DIGIT INVOLVEMENT, WITH OR WITHOUT Z-PLASTY OR OTHER LOCAL TISSUE REARRANGEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3201, N'25295', N'TENOLYSIS, FLEXOR OR EXTENSOR TENDON, FOREARM AND/OR WRIST, SINGLE, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3202, N'25315', N'FLEXOR ORIGIN SLIDE (EG, FOR CEREBRAL PALSY, VOLKMANN CONTRACTURE), FOREARM AND/OR WRIST;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3203, N'26130', N'SYNOVECTOMY, CARPOMETACARPAL JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3204, N'26145', N'SYNOVECTOMY, TENDON SHEATH, RADICAL (TENOSYNOVECTOMY), FLEXOR TENDON, PALM AND/OR FINGER, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3205, N'25316', N'FLEXOR ORIGIN SLIDE (EG, FOR CEREBRAL PALSY, VOLKMANN CONTRACTURE), FOREARM AND/OR WRIST; WITH TENDON(S) TRANSFER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3206, N'25318', N'FLEXOR ORIGIN SLIDE FOR VOLKMANN CONTRACTURE; WITH TENDON(S) TRANSFER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3207, N'26548', N'REPAIR AND RECONSTRUCTION, FINGER, VOLAR PLATE, INTERPHALANGEAL JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3208, N'26550', N'POLLICIZATION OF A DIGIT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3209, N'26552', N'RECONSTRUCTION THUMB WITH TOE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3210, N'25355', N'OSTEOTOMY, RADIUS; MIDDLE OR PROXIMAL THIRD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3211, N'25365', N'OSTEOTOMY; RADIUS AND ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3212, N'25375', N'MULTIPLE OSTEOTOMIES, WITH REALIGNMENT ON INTRAMEDULLARY ROD (SOFIELD TYPE PROCEDURE); RADIUS AND ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3213, N'26180', N'EXCISION OF TENDON, FINGER, FLEXOR OR EXTENSOR, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3214, N'26205', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF METACARPAL; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3215, N'25390', N'OSTEOPLASTY, RADIUS OR ULNA; SHORTENING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3216, N'25391', N'OSTEOPLASTY, RADIUS OR ULNA; LENGTHENING WITH AUTOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3217, N'25430', N'INSERTION OF VASCULAR PEDICLE INTO CARPAL BONE (EG, HORI PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3218, N'26557', N'TOE TO FINGER TRANSFER; FIRST STAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3219, N'26565', N'OSTEOTOMY; METACARPAL, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3220, N'26574', N'BONE GRAFT, (INCLUDES OBTAINING GRAFT); PHALANX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3221, N'26585', N'REPAIR BIFID DIGIT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 2200 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3222, N'26591', N'REPAIR, INTRINSIC MUSCLES OF HAND, EACH MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3223, N'26597', N'RELEASE OF SCAR CONTRACTURE, FLEXOR OR EXTENSOR, WITH SKIN GRAFTS, REARRANGEMENT FLAPS, OR Z-PLASTIES, HAND AND/OR FINGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3224, N'25041', N'ARTHROTOMY WITH EXPLORATION, DRAINAGE, OR REMOVAL OF LOOSE OR FOREIGN BODY, INFECTION, RADIOCARPAL OR MEDIOCARPAL JOINT; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3225, N'26600', N'CLOSED TREATMENT OF METACARPAL FRACTURE, SINGLE; WITHOUT MANIPULATION, EACH BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3226, N'26655', N'TREATMENT OF OPEN CARPOMETACARPAL FRACTURE DISLOCATION, THUMB (BENNETT FRACTURE), WITH UNCOMPLICATED SOFT TISSUE CLOSURE;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3227, N'25071', N'EXCISION, TUMOR, SOFT TISSUE OF FOREARM AND/OR WRIST AREA, SUBCUTANEOUS; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3228, N'25076', N'EXCISION, TUMOR, SOFT TISSUE OF FOREARM AND/OR WRIST AREA, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3229, N'26706', N'PERCUTANEOUS SKELETAL FIXATION OF METACARPOPHALANGEAL DISLOCATION, SINGLE, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3230, N'26730', N'TREATMENT OF OPEN PHALANGEAL SHAFT FRACTURE, PROXIMAL OR MIDDLE PHALANX, FINGER OR THUMB, WITH UNCOMPLICATED SOFT TISSUE CLOSURE, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3231, N'25078', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF FOREARM AND/OR WRIST AREA; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3232, N'25085', N'CAPSULOTOMY, WRIST (EG, CONTRACTURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3233, N'26235', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) BONE (EG, OSTEOMYELITIS); PROXIMAL OR MIDDLE PHALANX OF FINGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3234, N'26255', N'RADICAL RESECTION, METACARPAL (EG, TUMOR); WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3235, N'25118', N'SYNOVECTOMY, EXTENSOR TENDON SHEATH, WRIST, SINGLE COMPARTMENT;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3236, N'25120', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF RADIUS OR ULNA (EXCLUDING HEAD OR NECK OF RADIUS AND OLECRANON PROCESS);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3237, N'26740', N'CLOSED TREATMENT OF ARTICULAR FRACTURE, INVOLVING METACARPOPHALANGEAL OR INTERPHALANGEAL JOINT; WITHOUT MANIPULATION, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3238, N'26744', N'TREATMENT OF OPEN ARTICULAR FRACTURE, INVOLVING METACARPOPHALANGEAL OR PROXIMAL INTERPHALANGEAL JOINT, WITH UNCOMPLICATED SOFT TISSUE CLOSURE, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3239, N'25135', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF CARPAL BONES; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3240, N'25151', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) OF BONE (EG, FOR OSTEOMYELITIS); RADIUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3241, N'26260', N'RADICAL RESECTION OF TUMOR, PROXIMAL OR MIDDLE PHALANX OF FINGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3242, N'26261', N'RADICAL RESECTION, PROXIMAL OR MIDDLE PHALANX OF FINGER (EG, TUMOR); WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3243, N'25170', N'RADICAL RESECTION OF TUMOR, RADIUS OR ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3244, N'25230', N'RADIAL STYLOIDECTOMY (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3245, N'25265', N'REPAIR, TENDON OR MUSCLE, FLEXOR, FOREARM AND/OR WRIST; SECONDARY, WITH FREE GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON OR MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3246, N'26320', N'REMOVAL OF IMPLANT FROM FINGER OR HAND', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3247, N'26356', N'REPAIR OR ADVANCEMENT, FLEXOR TENDON, IN ZONE 2 DIGITAL FLEXOR TENDON SHEATH (EG, NO MAN''S LAND); PRIMARY, WITHOUT FREE GRAFT, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3248, N'25274', N'REPAIR, TENDON OR MUSCLE, EXTENSOR, FOREARM AND/OR WRIST; SECONDARY, WITH FREE GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON OR MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3249, N'26760', N'TREATMENT OF OPEN DISTAL PHALANGEAL FRACTURE, FINGER OR THUMB, WITH UNCOMPLICATED SOFT TISSUE CLOSURE, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3250, N'26780', N'TREATMENT OF OPEN INTERPHALANGEAL JOINT DISLOCATION, SINGLE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3251, N'25441', N'ARTHROPLASTY WITH PROSTHETIC REPLACEMENT; DISTAL RADIUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3252, N'25447', N'ARTHROPLASTY, INTERPOSITION, INTERCARPAL OR CARPOMETACARPAL JOINTS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3253, N'26426', N'REPAIR OF EXTENSOR TENDON, CENTRAL SLIP, SECONDARY (EG, BOUTONNIERE DEFORMITY); USING LOCAL TISSUE(S), INCLUDING LATERAL BAND(S), EACH FINGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3254, N'25455', N'EPIPHYSEAL ARREST BY EPIPHYSIODESIS OR STAPLING; DISTAL RADIUS AND ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3255, N'25490', N'PROPHYLACTIC TREATMENT (NAILING, PINNING, PLATING OR WIRING) WITH OR WITHOUT METHYLMETHACRYLATE; RADIUS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3256, N'26433', N'REPAIR OF EXTENSOR TENDON, DISTAL INSERTION, PRIMARY OR SECONDARY; WITHOUT GRAFT (EG, MALLET FINGER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3257, N'26449', N'TENOLYSIS, COMPLEX, EXTENSOR TENDON, FINGER, INCLUDING FOREARM, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3258, N'25510', N'TREATMENT OF OPEN RADIAL SHAFT FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3259, N'25520', N'CLOSED TREATMENT OF RADIAL SHAFT FRACTURE AND CLOSED TREATMENT OF DISLOCATION OF DISTAL RADIOULNAR JOINT (GALEAZZI FRACTURE/DISLOCATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3260, N'26841', N'ARTHRODESIS, CARPOMETACARPAL JOINT, THUMB, WITH OR WITHOUT INTERNAL FIXATION;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3261, N'26842', N'ARTHRODESIS, CARPOMETACARPAL JOINT, THUMB, WITH OR WITHOUT INTERNAL FIXATION; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3262, N'25526', N'OPEN TREATMENT OF RADIAL SHAFT FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED, AND OPEN TREATMENT OF DISTAL RADIOULNAR JOINT DISLOCATION (GALEAZZI FRACTURE/ DISLOCATION), INCLUDES INTERNAL FIXATION, WHEN PERFORMED, INCLUDES REPAIR OF TRIANGULAR FIBROCARTILAGE COMPLEX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3263, N'26862', N'ARTHRODESIS, INTERPHALANGEAL JOINT, WITH OR WITHOUT INTERNAL FIXATION; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3264, N'26863', N'ARTHRODESIS, INTERPHALANGEAL JOINT, WITH OR WITHOUT INTERNAL FIXATION; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT), EACH ADDITIONAL JOINT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3265, N'25530', N'CLOSED TREATMENT OF ULNAR SHAFT FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3266, N'25565', N'CLOSED TREATMENT OF RADIAL AND ULNAR SHAFT FRACTURES; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3267, N'27001', N'TENOTOMY, ADDUCTOR OF HIP, OPEN', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3268, N'27002', N'TENOTOMY, ADDUCTOR OF HIP, SUBCUTANEOUS, OPEN; BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3269, N'27025', N'FASCIOTOMY, HIP OR THIGH, ANY TYPE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3270, N'25600', N'CLOSED TREATMENT OF DISTAL RADIAL FRACTURE (EG, COLLES OR SMITH TYPE) OR EPIPHYSEAL SEPARATION, INCLUDES CLOSED TREATMENT OF FRACTURE OF ULNAR STYLOID, WHEN PERFORMED; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3271, N'27045', N'EXCISION, TUMOR, SOFT TISSUE OF PELVIS AND HIP AREA, SUBFASCIAL (EG, INTRAMUSCULAR); 5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3272, N'27048', N'EXCISION, TUMOR, SOFT TISSUE OF PELVIS AND HIP AREA, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3273, N'25605', N'CLOSED TREATMENT OF DISTAL RADIAL FRACTURE (EG, COLLES OR SMITH TYPE) OR EPIPHYSEAL SEPARATION, WITH OR WITHOUT FRACTURE OF ULNAR STYLOID; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3274, N'27062', N'EXCISION; TROCHANTERIC BURSA OR CALCIFICATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3275, N'27070', N'PARTIAL EXCISION, WING OF ILIUM, SYMPHYSIS PUBIS, OR GREATER TROCHANTER OF FEMUR, (CRATERIZATION, SAUCERIZATION) (EG, OSTEOMYELITIS OR BONE ABSCESS); SUPERFICIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3276, N'25620', N'OPEN TREATMENT OF DISTAL RADIAL FRACTURE (EG, COLLES OR SMITH TYPE) OR EPIPHYSEAL SEPARATION, WITH OR WITHOUT FRACTURE OF ULNAR STYLOID, WITH OR WITHOUT INTERNAL OR EXTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3277, N'25275', N'REPAIR, TENDON SHEATH, EXTENSOR, FOREARM AND/OR WRIST, WITH FREE GRAFT (INCLUDES OBTAINING GRAFT) (EG, FOR EXTENSOR CARPI ULNARIS SUBLUXATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3278, N'26460', N'TENOTOMY, EXTENSOR, HAND OR FINGER, OPEN, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3279, N'26474', N'TENODESIS; OF DISTAL JOINT, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3280, N'26480', N'TRANSFER OR TRANSPLANT OF TENDON, CARPOMETACARPAL AREA OR DORSUM OF HAND; WITHOUT FREE GRAFT, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3281, N'25300', N'TENODESIS AT WRIST; FLEXORS OF FINGERS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3282, N'25301', N'TENODESIS AT WRIST; EXTENSORS OF FINGERS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3283, N'25370', N'MULTIPLE OSTEOTOMIES, WITH REALIGNMENT ON INTRAMEDULLARY ROD (SOFIELD TYPE PROCEDURE); RADIUS OR ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3284, N'27071', N'PARTIAL EXCISION, WING OF ILIUM, SYMPHYSIS PUBIS, OR GREATER TROCHANTER OF FEMUR, (CRATERIZATION, SAUCERIZATION) (EG, OSTEOMYELITIS OR BONE ABSCESS); DEEP (SUBFASCIAL OR INTRAMUSCULAR)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3285, N'25393', N'OSTEOPLASTY, RADIUS AND ULNA; LENGTHENING WITH AUTOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3286, N'25425', N'REPAIR OF DEFECT WITH AUTOGRAFT; RADIUS OR ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3287, N'25426', N'REPAIR OF DEFECT WITH AUTOGRAFT; RADIUS AND ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3288, N'27088', N'REMOVAL OF FOREIGN BODY; DEEP, COMPLICATED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3289, N'27100', N'TRANSFER EXTERNAL OBLIQUE MUSCLE TO GREATER TROCHANTER INCLUDING FASCIAL OR TENDON EXTENSION (GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3290, N'25446', N'ARTHROPLASTY WITH PROSTHETIC REPLACEMENT; DISTAL RADIUS AND PARTIAL OR ENTIRE CARPUS (TOTAL WRIST)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3291, N'25492', N'PROPHYLACTIC TREATMENT (NAILING, PINNING, PLATING OR WIRING) WITH OR WITHOUT METHYLMETHACRYLATE; RADIUS AND ULNA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3292, N'27111', N'TRANSFER ILIOPSOAS; TO FEMORAL NECK', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3293, N'27120', N'ACETABULOPLASTY; (EG, WHITMAN, COLONNA, HAYGROVES, OR CUP TYPE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3294, N'27125', N'HEMIARTHROPLASTY, HIP, PARTIAL (EG, FEMORAL STEM PROSTHESIS, BIPOLAR ARTHROPLASTY)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3295, N'25500', N'CLOSED TREATMENT OF RADIAL SHAFT FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3296, N'25525', N'OPEN TREATMENT OF RADIAL SHAFT FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED, AND CLOSED TREATMENT OF DISTAL RADIOULNAR JOINT DISLOCATION (GALEAZZI FRACTURE/ DISLOCATION), INCLUDES PERCUTANEOUS SKELETAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3297, N'26502', N'RECONSTRUCTION OF TENDON PULLEY, EACH TENDON; WITH TENDON OR FASCIAL GRAFT (INCLUDES OBTAINING GRAFT) (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3298, N'26508', N'RELEASE OF THENAR MUSCLE(S) (EG, THUMB CONTRACTURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3299, N'25606', N'PERCUTANEOUS SKELETAL FIXATION OF DISTAL RADIAL FRACTURE OR EPIPHYSEAL SEPARATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3300, N'25610', N'TREATMENT OF CLOSED, COMPLEX, DISTAL RADIAL FRACTURE (EG, COLLES OR SMITH TYPE) OR EPIPHYSEAL SEPARATION, WITH OR WITHOUT FRACTURE OF ULNAR STYLOID, REQUIRING MANIPULATION; WITHOUT EXTERNAL SKELETAL FIXATION OR PERCUTANEOUS PINNING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3301, N'26520', N'CAPSULECTOMY OR CAPSULOTOMY; METACARPOPHALANGEAL JOINT, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3302, N'26551', N'TRANSFER, TOE-TO-HAND WITH MICROVASCULAR ANASTOMOSIS; GREAT TOE WRAP-AROUND WITH BONE GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3303, N'25635', N'CLOSED TREATMENT OF CARPAL BONE FRACTURE (EXCLUDING CARPAL SCAPHOID [NAVICULAR]); WITH MANIPULATION, EACH BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3304, N'25645', N'OPEN TREATMENT OF CARPAL BONE FRACTURE (OTHER THAN CARPAL SCAPHOID [NAVICULAR]), EACH BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3305, N'27126', N'PARTIAL HIP REPLACEMENT (HEMIARTHROPLASTY); CUP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3306, N'27130', N'ARTHROPLASTY, ACETABULAR AND PROXIMAL FEMORAL PROSTHETIC REPLACEMENT (TOTAL HIP ARTHROPLASTY), WITH OR WITHOUT AUTOGRAFT OR ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3307, N'25650', N'CLOSED TREATMENT OF ULNAR STYLOID FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3308, N'25815', N'ARTHRODESIS, INTERCARPAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3309, N'25915', N'KRUKENBERG PROCEDURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3310, N'25624', N'CLOSED TREATMENT OF CARPAL SCAPHOID (NAVICULAR) FRACTURE; WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3311, N'25665', N'TREATMENT OF OPEN RADIOCARPAL OR INTERCARPAL DISLOCATION, ONE OR MORE BONES, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3312, N'26567', N'OSTEOTOMY; PHALANX OF FINGER, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3313, N'26568', N'OSTEOPLASTY, LENGTHENING, METACARPAL OR PHALANX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3314, N'26580', N'REPAIR CLEFT HAND', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3315, N'25685', N'OPEN TREATMENT OF TRANS-SCAPHOPERILUNAR TYPE OF FRACTURE DISLOCATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3316, N'25690', N'CLOSED TREATMENT OF LUNATE DISLOCATION, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3317, N'27131', N'ARTHROPLASTY, ACETABULAR AND PROXIMAL FEMORAL PROSTHETIC REPLACEMENT (TOTAL HIP REPLACEMENT); COMPLEX', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3318, N'27138', N'REVISION OF TOTAL HIP ARTHROPLASTY; FEMORAL COMPONENT ONLY, WITH OR WITHOUT ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3319, N'25800', N'ARTHRODESIS, WRIST; COMPLETE, WITHOUT BONE GRAFT (INCLUDES RADIOCARPAL AND/OR INTERCARPAL AND/OR CARPOMETACARPAL JOINTS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3320, N'25805', N'ARTHRODESIS, WRIST; WITH SLIDING GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3321, N'27140', N'OSTEOTOMY AND TRANSFER OF GREATER TROCHANTER OF FEMUR (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3322, N'27156', N'OSTEOTOMY, ILIAC, ACETABULAR OR INNOMINATE BONE; WITH FEMORAL OSTEOTOMY AND WITH OPEN REDUCTION OF HIP', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 2300 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3323, N'25825', N'ARTHRODESIS, WRIST; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3324, N'25830', N'ARTHRODESIS, DISTAL RADIOULNAR JOINT WITH SEGMENTAL RESECTION OF ULNA, WITH OR WITHOUT BONE GRAFT (EG, SAUVE-KAPANDJI PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3325, N'27178', N'OPEN TREATMENT OF SLIPPED FEMORAL EPIPHYSIS; CLOSED MANIPULATION WITH SINGLE OR MULTIPLE PINNING', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3326, N'27194', N'CLOSED TREATMENT OF PELVIC RING FRACTURE, DISLOCATION, DIASTASIS OR SUBLUXATION; WITH MANIPULATION, REQUIRING MORE THAN LOCAL ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3327, N'25907', N'AMPUTATION, FOREARM, THROUGH RADIUS AND ULNA; SECONDARY CLOSURE OR SCAR REVISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3328, N'26032', N'DRAINAGE OF PALMAR BURSA; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3329, N'27202', N'OPEN TREATMENT OF COCCYGEAL FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3330, N'27214', N'OPEN TREATMENT OF CLOSED OR OPEN ILIAC, PUBIC OR ISCHIAL FRACTURE, WITH OR WITHOUT INTERNAL SKELETAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3331, N'26034', N'INCISION, BONE CORTEX, HAND OR FINGER (EG, OSTEOMYELITIS OR BONE ABSCESS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3332, N'26045', N'FASCIOTOMY, PALMAR (EG, DUPUYTREN''S CONTRACTURE); OPEN, PARTIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3333, N'27224', N'OPEN TREATMENT OF CLOSED OR OPEN ACETABULUM (HIP SOCKET) FRACTURE(S), WITH OR WITHOUT INTERNAL OR EXTERNAL SKELETAL FIXATION; SIMPLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3334, N'26055', N'TENDON SHEATH INCISION (EG, FOR TRIGGER FINGER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3335, N'26111', N'EXCISION, TUMOR OR VASCULAR MALFORMATION, SOFT TISSUE OF HAND OR FINGER, SUBCUTANEOUS; 1.5 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3336, N'27225', N'OPEN TREATMENT OF CLOSED OR OPEN ACETABULUM (HIP SOCKET) FRACTURE(S), WITH OR WITHOUT INTERNAL OR EXTERNAL SKELETAL FIXATION; COMPLICATED, INTRAPELVIC APPROACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3337, N'26124', N'FASCIECTOMY, PALMAR, COMPLICATED, REQUIRING SKIN GRAFTING (INCLUDES OBTAINING GRAFT); WITH SINGLE DIGIT INVOLVEMENT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3338, N'26125', N'FASCIECTOMY, PARTIAL PALMAR WITH RELEASE OF SINGLE DIGIT INCLUDING PROXIMAL INTERPHALANGEAL JOINT, WITH OR WITHOUT Z-PLASTY, OTHER LOCAL TISSUE REARRANGEMENT, OR SKIN GRAFTING (INCLUDES OBTAINING GRAFT); EACH ADDITIONAL DIGIT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3339, N'26587', N'RECONSTRUCTION OF POLYDACTYLOUS DIGIT, SOFT TISSUE AND BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3340, N'26676', N'PERCUTANEOUS SKELETAL FIXATION OF CARPOMETACARPAL DISLOCATION, OTHER THAN THUMB, WITH MANIPULATION, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3341, N'26126', N'FASCIECTOMY, PALMAR, COMPLICATED, REQUIRING SKIN GRAFTING (INCLUDES OBTAINING GRAFT); EACH ADDITIONAL DIGIT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3342, N'26128', N'FASCIECTOMY, PALMAR, COMPLICATED, REQUIRING SKIN GRAFTING (INCLUDES OBTAINING GRAFT); EACH FINGER JOINT RELEASE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3343, N'26680', N'TREATMENT OF OPEN CARPOMETACARPAL DISLOCATION, OTHER THAN BENNETT FRACTURE, SINGLE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3344, N'26685', N'OPEN TREATMENT OF CARPOMETACARPAL DISLOCATION, OTHER THAN THUMB; INCLUDES INTERNAL FIXATION, WHEN PERFORMED, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3345, N'26140', N'SYNOVECTOMY, PROXIMAL INTERPHALANGEAL JOINT, INCLUDING EXTENSOR RECONSTRUCTION, EACH INTERPHALANGEAL JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3346, N'26185', N'SESAMOIDECTOMY, THUMB OR FINGER (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3347, N'26710', N'TREATMENT OF OPEN METACARPOPHALANGEAL DISLOCATION, SINGLE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3348, N'26742', N'CLOSED TREATMENT OF ARTICULAR FRACTURE, INVOLVING METACARPOPHALANGEAL OR INTERPHALANGEAL JOINT; WITH MANIPULATION, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3349, N'26206', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF METACARPAL; WITH HOMOGENOUS OR OTHER NONAUTOGENOUS GRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3350, N'26210', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF PROXIMAL, MIDDLE, OR DISTAL PHALANX OF FINGER;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3351, N'26743', N'TREATMENT OF CLOSED ARTICULAR FRACTURE, INVOLVING METACARPOPHALANGEAL OR PROXIMAL INTERPHALANGEAL JOINT; WITH MANIPULATION REQUIRING TRACTION FOR FIXATION, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3352, N'26230', N'PARTIAL EXCISION (CRATERIZATION, SAUCERIZATION, OR DIAPHYSECTOMY) BONE (EG, OSTEOMYELITIS); METACARPAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3353, N'26250', N'RADICAL RESECTION OF TUMOR, METACARPAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3354, N'26755', N'CLOSED TREATMENT OF DISTAL PHALANGEAL FRACTURE, FINGER OR THUMB; WITH MANIPULATION, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3355, N'26775', N'CLOSED TREATMENT OF INTERPHALANGEAL JOINT DISLOCATION, SINGLE, WITH MANIPULATION; REQUIRING ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3356, N'27226', N'OPEN TREATMENT OF POSTERIOR OR ANTERIOR ACETABULAR WALL FRACTURE, WITH INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3357, N'27228', N'OPEN TREATMENT OF ACETABULAR FRACTURE(S) INVOLVING ANTERIOR AND POSTERIOR (TWO) COLUMNS, INCLUDES T-FRACTURE AND BOTH COLUMN FRACTURE WITH COMPLETE ARTICULAR DETACHMENT, OR SINGLE COLUMN OR TRANSVERSE FRACTURE WITH ASSOCIATED ACETABULAR WALL FRACTURE, WITH INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3358, N'26776', N'PERCUTANEOUS SKELETAL FIXATION OF INTERPHALANGEAL JOINT DISLOCATION, SINGLE, WITH MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3359, N'26785', N'OPEN TREATMENT OF INTERPHALANGEAL JOINT DISLOCATION, INCLUDES INTERNAL FIXATION, WHEN PERFORMED, SINGLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3360, N'27240', N'CLOSED TREATMENT OF INTERTROCHANTERIC, PERTROCHANTERIC, OR SUBTROCHANTERIC FEMORAL FRACTURE; WITH MANIPULATION, WITH OR WITHOUT SKIN OR SKELETAL TRACTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3361, N'26843', N'ARTHRODESIS, CARPOMETACARPAL JOINT, DIGIT, OTHER THAN THUMB, EACH;', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3362, N'26861', N'ARTHRODESIS, INTERPHALANGEAL JOINT, WITH OR WITHOUT INTERNAL FIXATION; EACH ADDITIONAL INTERPHALANGEAL JOINT (LIST SEPARATELY IN ADDITION TO CODE FOR PRIMARY PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3363, N'27242', N'TREATMENT OF OPEN INTERTROCHANTERIC, PERTROCHANTERIC, OR SUBTROCHANTERIC FEMORAL FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE (INCLUDING TRACTION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3364, N'26989', N'UNLISTED PROCEDURE, HANDS OR FINGERS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3365, N'26990', N'INCISION AND DRAINAGE, PELVIS OR HIP JOINT AREA; DEEP ABSCESS OR HEMATOMA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3366, N'26262', N'RADICAL RESECTION OF TUMOR, DISTAL PHALANX OF FINGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3367, N'26352', N'REPAIR OR ADVANCEMENT, FLEXOR TENDON, NOT IN ZONE 2 DIGITAL FLEXOR TENDON SHEATH (EG, NO MAN''S LAND); SECONDARY WITH FREE GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3368, N'27005', N'TENOTOMY, HIP FLEXOR(S), OPEN (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3369, N'27015', N'ILIAC CREST FASCIOTOMY (SOUTTER OR CAMPBELL TYPE PROCEDURE), STRIPPING OF ILIUM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3370, N'26410', N'REPAIR, EXTENSOR TENDON, HAND, PRIMARY OR SECONDARY; WITHOUT FREE GRAFT, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3371, N'26416', N'REMOVAL OF SYNTHETIC ROD AND INSERTION OF EXTENSOR TENDON GRAFT (INCLUDES OBTAINING GRAFT), HAND OR FINGER, EACH ROD', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3372, N'27026', N'OBER-YOUNT FASCIOTOMY, COMBINED WITH SPICA CAST, PINS IN TIBIA, WEDGING THE CAST, ETC; BILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3373, N'27027', N'DECOMPRESSION FASCIOTOMY(IES), PELVIC (BUTTOCK) COMPARTMENT(S) (EG, GLUTEUS MEDIUS-MINIMUS, GLUTEUS MAXIMUS, ILIOPSOAS, AND/OR TENSOR FASCIA LATA MUSCLE), UNILATERAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3374, N'26418', N'REPAIR, EXTENSOR TENDON, FINGER, PRIMARY OR SECONDARY; WITHOUT FREE GRAFT, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3375, N'26428', N'REPAIR OF EXTENSOR TENDON, CENTRAL SLIP, SECONDARY (EG, BOUTONNIERE DEFORMITY); WITH FREE GRAFT (INCLUDES OBTAINING GRAFT), EACH FINGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3376, N'27030', N'ARTHROTOMY, HIP, WITH DRAINAGE (EG, INFECTION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3377, N'27031', N'ARTHROTOMY, HIP, FOR DRAINAGE; WITH SUCTION IRRIGATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3378, N'27033', N'ARTHROTOMY, HIP, INCLUDING EXPLORATION OR REMOVAL OF LOOSE OR FOREIGN BODY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3379, N'26432', N'CLOSED TREATMENT OF DISTAL EXTENSOR TENDON INSERTION, WITH OR WITHOUT PERCUTANEOUS PINNING (EG, MALLET FINGER)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3380, N'26471', N'TENODESIS; OF PROXIMAL INTERPHALANGEAL JOINT, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3381, N'27040', N'BIOPSY, SOFT TISSUE OF PELVIS AND HIP AREA; SUPERFICIAL', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3382, N'27043', N'EXCISION, TUMOR, SOFT TISSUE OF PELVIS AND HIP AREA, SUBCUTANEOUS; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3383, N'26476', N'LENGTHENING OF TENDON, EXTENSOR, HAND OR FINGER, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3384, N'26477', N'SHORTENING OF TENDON, EXTENSOR, HAND OR FINGER, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3385, N'27065', N'EXCISION OF BONE CYST OR BENIGN TUMOR, WING OF ILIUM, SYMPHYSIS PUBIS, OR GREATER TROCHANTER OF FEMUR; SUPERFICIAL, INCLUDES AUTOGRAFT, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3386, N'25922', N'DISARTICULATION THROUGH WRIST; SECONDARY CLOSURE OR SCAR REVISION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3387, N'25931', N'TRANSMETACARPAL AMPUTATION; RE-AMPUTATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3388, N'26020', N'DRAINAGE OF TENDON SHEATH, DIGIT AND/OR PALM, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3389, N'27080', N'COCCYGECTOMY, PRIMARY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3390, N'27095', N'INJECTION PROCEDURE FOR HIP ARTHROGRAPHY; WITH ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3391, N'27096', N'INJECTION PROCEDURE FOR SACROILIAC JOINT, ARTHROGRAPHY AND/OR ANESTHETIC/STEROID', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3392, N'26025', N'DRAINAGE OF PALMAR BURSA; SINGLE, BURSA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3393, N'26035', N'DECOMPRESSION FINGERS AND/OR HAND, INJECTION INJURY (EG, GREASE GUN)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3394, N'26037', N'DECOMPRESSIVE FASCIOTOMY, HAND (EXCLUDES 26035)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3395, N'26060', N'TENOTOMY, PERCUTANEOUS, SINGLE, EACH DIGIT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3396, N'26075', N'ARTHROTOMY, WITH EXPLORATION, DRAINAGE, OR REMOVAL OF LOOSE OR FOREIGN BODY; METACARPOPHALANGEAL JOINT, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3397, N'27244', N'TREATMENT OF INTERTROCHANTERIC, PERTROCHANTERIC, OR SUBTROCHANTERIC FEMORAL FRACTURE; WITH PLATE/SCREW TYPE IMPLANT, WITH OR WITHOUT CERCLAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3398, N'26080', N'ARTHROTOMY, WITH EXPLORATION, DRAINAGE, OR REMOVAL OF LOOSE OR FOREIGN BODY; INTERPHALANGEAL JOINT, EACH', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3399, N'26115', N'EXCISION, TUMOR OR VASCULAR MALFORMATION, SOFT TISSUE OF HAND OR FINGER, SUBCUTANEOUS; LESS THAN 1.5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3400, N'27127', N'PARTIAL HIP REPLACEMENT (HEMIARTHROPLASTY); CUP WITH ACETABULOPLASTY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3401, N'27132', N'CONVERSION OF PREVIOUS HIP SURGERY TO TOTAL HIP ARTHROPLASTY, WITH OR WITHOUT AUTOGRAFT OR ALLOGRAFT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3402, N'26478', N'LENGTHENING OF TENDON, FLEXOR, HAND OR FINGER, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3403, N'26483', N'TRANSFER OR TRANSPLANT OF TENDON, CARPOMETACARPAL AREA OR DORSUM OF HAND; WITH FREE TENDON GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3404, N'27161', N'OSTEOTOMY, FEMORAL NECK (SEPARATE PROCEDURE)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3405, N'27165', N'OSTEOTOMY, INTERTROCHANTERIC OR SUBTROCHANTERIC INCLUDING INTERNAL OR EXTERNAL FIXATION AND/OR CAST', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3406, N'27246', N'CLOSED TREATMENT OF GREATER TROCHANTERIC FRACTURE, WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3407, N'27248', N'OPEN TREATMENT OF GREATER TROCHANTERIC FRACTURE, INCLUDES INTERNAL FIXATION, WHEN PERFORMED', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3408, N'27176', N'TREATMENT OF SLIPPED FEMORAL EPIPHYSIS; BY SINGLE OR MULTIPLE PINNING, IN SITU', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3409, N'27192', N'OPEN TREATMENT OF CLOSED OR OPEN SACRAL FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3410, N'27253', N'OPEN TREATMENT OF HIP DISLOCATION, TRAUMATIC, WITHOUT INTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3411, N'27255', N'OPEN TREATMENT OF CLOSED OR OPEN HIP DISLOCATION, TRAUMATIC, WITH ACETABULAR LIP FIXATION, WITH OR WITHOUT INTERNAL OR EXTERNAL SKELETAL FIXATION; COMPLICATED OR LATE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3412, N'27195', N'TREATMENT OF SACROILIAC AND/OR SYMPHYSIS PUBIS DISLOCATION, WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3413, N'27200', N'CLOSED TREATMENT OF COCCYGEAL FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3414, N'27257', N'TREATMENT OF SPONTANEOUS HIP DISLOCATION (DEVELOPMENTAL, INCLUDING CONGENITAL OR PATHOLOGICAL), BY ABDUCTION, SPLINT OR TRACTION; WITH MANIPULATION, REQUIRING ANESTHESIA', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3415, N'27201', N'TREATMENT OF OPEN COCCYGEAL FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3416, N'27211', N'TREATMENT OF CLOSED ILIAC, PUBIC OR ISCHIAL FRACTURE, WITHOUT MANIPULATION; MORE THAN ONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3417, N'27258', N'OPEN TREATMENT OF SPONTANEOUS HIP DISLOCATION (DEVELOPMENTAL, INCLUDING CONGENITAL OR PATHOLOGICAL), REPLACEMENT OF FEMORAL HEAD IN ACETABULUM (INCLUDING TENOTOMY, ETC);', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3418, N'27212', N'TREATMENT OF OPEN ILIAC, PUBIC OR ISCHIAL FRACTURE, WITH UNCOMPLICATED SOFT TISSUE CLOSURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3419, N'27222', N'CLOSED TREATMENT OF ACETABULUM (HIP SOCKET) FRACTURE(S); WITH MANIPULATION, WITH OR WITHOUT SKELETAL TRACTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3420, N'26490', N'OPPONENSPLASTY; SUPERFICIALIS TENDON TRANSFER TYPE, EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3421, N'26492', N'OPPONENSPLASTY; TENDON TRANSFER WITH GRAFT (INCLUDES OBTAINING GRAFT), EACH TENDON', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3422, N'27232', N'CLOSED TREATMENT OF FEMORAL FRACTURE, PROXIMAL END, NECK; WITH MANIPULATION, WITH OR WITHOUT SKELETAL TRACTION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3423, N'27234', N'TREATMENT OF OPEN FEMORAL FRACTURE, PROXIMAL END, NECK, WITH UNCOMPLICATED SOFT TISSUE CLOSURE, WITH MANIPULATION (INCLUDING SKELETAL TRACTION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
GO
print 'Processed 2400 total records'
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3424, N'27235', N'PERCUTANEOUS SKELETAL FIXATION OF FEMORAL FRACTURE, PROXIMAL END, NECK UNDISPLACED, MILDLY DISPLACED, OR IMPACTED FRACTURE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3425, N'27238', N'CLOSED TREATMENT OF INTERTROCHANTERIC, PERTROCHANTERIC, OR SUBTROCHANTERIC FEMORAL FRACTURE; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3426, N'26496', N'OPPONENSPLASTY; OTHER METHODS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3427, N'26498', N'TRANSFER OF TENDON TO RESTORE INTRINSIC FUNCTION; ALL 4 FINGERS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3428, N'26499', N'CORRECTION CLAW FINGER, OTHER METHODS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3429, N'27245', N'TREATMENT OF INTERTROCHANTERIC, PERTROCHANTERIC, OR SUBTROCHANTERIC FEMORAL FRACTURE; WITH INTRAMEDULLARY IMPLANT, WITH OR WITHOUT INTERLOCKING SCREWS AND/OR CERCLAGE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3430, N'27267', N'CLOSED TREATMENT OF FEMORAL FRACTURE, PROXIMAL END, HEAD; WITHOUT MANIPULATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3431, N'27280', N'ARTHRODESIS, SACROILIAC JOINT (INCLUDING OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3432, N'27254', N'OPEN TREATMENT OF HIP DISLOCATION, TRAUMATIC, WITH ACETABULAR WALL AND FEMORAL HEAD FRACTURE, WITH OR WITHOUT INTERNAL OR EXTERNAL FIXATION', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3433, N'27303', N'INCISION, DEEP, WITH OPENING OF BONE CORTEX, FEMUR OR KNEE (EG, OSTEOMYELITIS OR BONE ABSCESS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3434, N'27326', N'NEURECTOMY, POPLITEAL (GASTROCNEMIUS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3435, N'27282', N'ARTHRODESIS, SYMPHYSIS PUBIS (INCLUDING OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3436, N'27286', N'ARTHRODESIS, HIP JOINT (INCLUDING OBTAINING GRAFT); WITH SUBTROCHANTERIC OSTEOTOMY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3437, N'26517', N'CAPSULODESIS, METACARPOPHALANGEAL JOINT; 2 DIGITS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3438, N'26525', N'CAPSULECTOMY OR CAPSULOTOMY; INTERPHALANGEAL JOINT, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3439, N'26117', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF HAND OR FINGER; LESS THAN 3 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3440, N'26118', N'RADICAL RESECTION OF TUMOR (EG, MALIGNANT NEOPLASM), SOFT TISSUE OF HAND OR FINGER; 3 CM OR GREATER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3441, N'26527', N'ARTHROPLASTY, CARPOMETACARPAL JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3442, N'26530', N'ARTHROPLASTY, METACARPOPHALANGEAL JOINT; EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3443, N'26535', N'ARTHROPLASTY, INTERPHALANGEAL JOINT; EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3444, N'27328', N'EXCISION, TUMOR, SOFT TISSUE OF THIGH OR KNEE AREA, SUBFASCIAL (EG, INTRAMUSCULAR); LESS THAN 5 CM', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3445, N'27330', N'ARTHROTOMY, KNEE; WITH SYNOVIAL BIOPSY ONLY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3446, N'26536', N'ARTHROPLASTY, INTERPHALANGEAL JOINT; WITH PROSTHETIC IMPLANT, EACH JOINT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3447, N'26546', N'REPAIR NON-UNION, METACARPAL OR PHALANX, (INCLUDES OBTAINING BONE GRAFT WITH OR WITHOUT EXTERNAL OR INTERNAL FIXATION)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3448, N'26121', N'FASCIECTOMY, PALM ONLY, WITH OR WITHOUT Z-PLASTY, OTHER LOCAL TISSUE REARRANGEMENT, OR SKIN GRAFTING (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3449, N'26160', N'EXCISION OF LESION OF TENDON SHEATH OR JOINT CAPSULE (EG, CYST, MUCOUS CYST, OR GANGLION), HAND OR FINGER', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3450, N'26560', N'REPAIR OF SYNDACTYLY (WEB FINGER) EACH WEB SPACE; WITH SKIN FLAPS', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3451, N'26562', N'REPAIR OF SYNDACTYLY (WEB FINGER) EACH WEB SPACE; COMPLEX (EG, INVOLVING BONE, NAILS)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3452, N'27357', N'EXCISION OR CURETTAGE OF BONE CYST OR BENIGN TUMOR OF FEMUR; WITH AUTOGRAFT (INCLUDES OBTAINING GRAFT)', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3453, N'27370', N'INJECTION PROCEDURE FOR KNEE ARTHROGRAPHY', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3454, N'26590', N'REPAIR MACRODACTYLIA, EACH DIGIT', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3455, N'26593', N'RELEASE, INTRINSIC MUSCLES OF HAND, EACH MUSCLE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG]) VALUES (3456, N'26605', N'CLOSED TREATMENT OF METACARPAL FRACTURE, SINGLE; WITH MANIPULATION, EACH BONE', N'DHassell', N'Dhassell', CAST(0x0000A0E5006C1351 AS DateTime), CAST(0x0000A0E5006C1351 AS DateTime), 1, 0, 0)
INSERT [dbo].[STD_CPT_Code] ([cpt_code_id], [code], [code_description