-- 20708: Add Missing / Incorrect Diagnosis Codes

if not exists(Select * from sys.columns where name='DVEIR_FLAG' and object_id=object_id('STD_ICD_CODE'))
BEGIN
	alter table STD_ICD_CODE
	add [DVEIR_FLAG] [BIT] NOT NULL CONSTRAINT [DF_STD_ICD_CODE_DVEIR_FLAG] DEFAULT 0

	alter table STD_ICD_CODE
	add [EFR_FLAG] [BIT] NOT NULL CONSTRAINT [DF_STD_ICD_CODE_FER_FLAG] DEFAULT 0

	alter table STD_ICD_CODE
	add [TBI_FLAG] [BIT] NOT NULL CONSTRAINT [DF_STD_ICD_CODE_TBI_FLAG] DEFAULT 0

	alter table STD_ICD_CODE
	alter column [CODE] [varchar](50) NOT NULL 

	alter table STD_ICD_CODE
	alter column [CODE_DESCRIPTION] [varchar](MAX) NOT NULL

END
GO	


---- Foreign in [DVEIR].[ER_DIAG_DTL]
IF  NOT EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_DIAG_DTL' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_DIAG_DTL]
ADD [ICD_CODE_ID] INT NULL
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = object_id(N'[DVEIR].[FK_ER_DIAG_DTL_ICD_CODE_ID]') AND parent_object_id = object_id(N'[DVEIR].[ER_DIAG_DTL]'))

ALTER TABLE [DVEIR].[ER_DIAG_DTL]  WITH CHECK ADD CONSTRAINT [FK_ER_DIAG_DTL_ICD_CODE_ID] FOREIGN KEY([ICD_CODE_ID])
REFERENCES [dbo].[STD_ICD_CODE] ([ICD_CODE_ID])
GO

ALTER TABLE [DVEIR].[ER_DIAG_DTL] CHECK CONSTRAINT [FK_ER_DIAG_DTL_ICD_CODE_ID]
GO


IF  NOT EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_DIAG_DTL_H' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_DIAG_DTL_H]
ADD [ICD_CODE_ID] INT NULL
END
GO


---- Foreign in [DVEIR].[ER_DIAG_DTL_ETL]
IF  NOT EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_DIAG_DTL_ETL' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL]
ADD [ICD_CODE_ID] INT NULL
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = object_id(N'[DVEIR].[FK_ER_DIAG_DTL_ETL_ICD_CODE_ID]') AND parent_object_id = object_id(N'[DVEIR].[ER_DIAG_DTL_ETL]'))

ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL]  WITH CHECK ADD CONSTRAINT [FK_ER_DIAG_DTL_ETL_ICD_CODE_ID] FOREIGN KEY([ICD_CODE_ID])
REFERENCES [dbo].[STD_ICD_CODE] ([ICD_CODE_ID])
GO

ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL] CHECK CONSTRAINT [FK_ER_DIAG_DTL_ETL_ICD_CODE_ID]
GO



---- Foreign in [DVEIR].[ER_PROCEDURE_DTL]
IF  NOT EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_PROCEDURE_DTL' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL]
ADD [ICD_CODE_ID] INT NULL
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = object_id(N'[DVEIR].[FK_ER_PROCEDURE_DTL_ICD_CODE_ID]') AND parent_object_id = object_id(N'[DVEIR].[ER_PROCEDURE_DTL]'))

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL]  WITH CHECK ADD CONSTRAINT [FK_ER_PROCEDURE_DTL_ICD_CODE_ID] FOREIGN KEY([ICD_CODE_ID])
REFERENCES [dbo].[STD_ICD_CODE] ([ICD_CODE_ID])
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL] CHECK CONSTRAINT [FK_ER_PROCEDURE_DTL_ICD_CODE_ID]
GO


IF  NOT EXISTS (SELECT NAME FROM sys.columns WHERE OBJECT_NAME(object_id) = 'ER_PROCEDURE_DTL_H' AND name = 'ICD_CODE_ID')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_H]
ADD [ICD_CODE_ID] INT NULL
END
GO

-- Trigger for the history tables
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_DIAG_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DIAG_DTL_DEL_H]
GO

CREATE TRIGGER  [DVEIR].[TRG_ER_DIAG_DTL_DEL_H]
on  [DVEIR].[ER_DIAG_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
, [ICD_CODE_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
, [ICD_CODE_ID]
From Deleted
End

GO

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_DIAG_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_DIAG_DTL_H]
GO

CREATE trigger [DVEIR].[TRG_ER_DIAG_DTL_H] on [DVEIR].[ER_DIAG_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_DIAG_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
, [ICD_CODE_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_DIAG_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD_CODESET]
, [ICD_CODE_ID]
FROM INSERTED
End

GO
	
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
GO

CREATE TRIGGER  [DVEIR].[TRG_ER_PROCEDURE_DTL_DEL_H]
on  [DVEIR].[ER_PROCEDURE_DTL] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
, [ICD_CODE_ID]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
, [ICD_CODE_ID]
From Deleted
End

GO

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[DVEIR].[TRG_ER_PROCEDURE_DTL_H]'))
DROP TRIGGER [DVEIR].[TRG_ER_PROCEDURE_DTL_H]
GO

CREATE trigger [DVEIR].[TRG_ER_PROCEDURE_DTL_H] on [DVEIR].[ER_PROCEDURE_DTL]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [DVEIR].[ER_PROCEDURE_DTL_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
, [ICD_CODE_ID]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [ER_PROCEDURE_DTL_ID]
, [COMMENT_TEXT]
, [CREATED]
, [UPDATED]
, [CREATEDBY]
, [UPDATEDBY]
, [ER_ENCOUNTER_ID]
, [CODE]
, [DESCRIPTION_TEXT]
, [ICD9_FLAG]
, [ICD_CODESET]
, [ICD_CODE_ID]
FROM INSERTED
End

GO



------------------------------------------------------
-- Insert data to STD_ICD_CODE table
-- The data is the combination of CMS ICD and CDW ICD
------------------------------------------------------
DELETE FROM [dbo].[STD_ICD_CODE]
SET IDENTITY_INSERT [dbo].[STD_ICD_CODE] ON
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1, N'001.0', N'CHOLERA DUE TO VIBRIO CHOLERAE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2, N'001.1', N'CHOLERA DUE TO VIBRIO CHOLERAE EL TOR', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (3, N'001.9', N'CHOLERA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (4, N'002.0', N'TYPHOID FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (5, N'002.1', N'PARATYPHOID FEVER A', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (6, N'002.2', N'PARATYPHOID FEVER B', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (7, N'002.3', N'PARATYPHOID FEVER C', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (8, N'002.9', N'PARATYPHOID FEVER, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (9, N'003.0', N'SALMONELLA GASTROENTERITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (10, N'003.1', N'SALMONELLA SEPTICEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (11, N'003.20', N'LOCALIZED SALMONELLA INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (12, N'003.21', N'SALMONELLA MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (13, N'003.22', N'SALMONELLA PNEUMONIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (14, N'003.23', N'SALMONELLA ARTHRITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (15, N'003.24', N'SALMONELLA OSTEOMYELITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (16, N'003.29', N'OTHER LOCALIZED SALMONELLA INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (17, N'003.8', N'OTHER SPECIFIED SALMONELLA INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (18, N'003.9', N'SALMONELLA INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (19, N'004.0', N'SHIGELLA DYSENTERIAE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (20, N'004.1', N'SHIGELLA FLEXNERI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (21, N'004.2', N'SHIGELLA BOYDII', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (22, N'004.3', N'SHIGELLA SONNEI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (23, N'004.8', N'OTHER SPECIFIED SHIGELLA INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (24, N'004.9', N'SHIGELLOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (25, N'005.0', N'STAPHYLOCOCCAL FOOD POISONING', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (26, N'005.1', N'BOTULISM FOOD POISONING', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (27, N'005.2', N'FOOD POISONING DUE TO CLOSTRIDIUM PERFRINGENS (C. WELCHII)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (28, N'005.3', N'FOOD POISONING DUE TO OTHER CLOSTRIDIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (29, N'005.4', N'FOOD POISONING DUE TO VIBRIO PARAHAEMOLYTICUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (30, N'005.81', N'FOOD POISONING DUE TO VIBRIO VULNIFICUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (31, N'005.89', N'OTHER BACTERIAL FOOD POISONING', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (32, N'005.9', N'FOOD POISONING, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (33, N'006.0', N'ACUTE AMEBIC DYSENTERY WITHOUT MENTION OF ABSCESS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (34, N'006.1', N'CHRONIC INTESTINAL AMEBIASIS WITHOUT MENTION OF ABSCESS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (35, N'006.2', N'AMEBIC NONDYSENTERIC COLITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (36, N'006.3', N'AMEBIC LIVER ABSCESS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (37, N'006.4', N'AMEBIC LUNG ABSCESS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (38, N'006.5', N'AMEBIC BRAIN ABSCESS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (39, N'006.6', N'AMEBIC SKIN ULCERATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (40, N'006.8', N'AMEBIC INFECTION OF OTHER SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (41, N'006.9', N'AMEBIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (42, N'007.0', N'BALANTIDIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (43, N'007.1', N'GIARDIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (44, N'007.2', N'COCCIDIOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (45, N'007.3', N'INTESTINAL TRICHOMONIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (46, N'007.4', N'CRYPTOSPORIDIOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (47, N'007.5', N'CYCLOSPORIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (48, N'007.8', N'OTHER SPECIFIED PROTOZOAL INTESTINAL DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (49, N'007.9', N'UNSPECIFIED PROTOZOAL INTESTINAL DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (50, N'008.00', N'INTESTINAL INFECTION DUE TO E. COLI, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (51, N'008.01', N'INTESTINAL INFECTION DUE TO ENTEROPATHOGENIC E. COLI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (52, N'008.02', N'INTESTINAL INFECTION DUE TO ENTEROTOXIGENIC E. COLI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (53, N'008.03', N'INTESTINAL INFECTION DUE TO ENTEROINVASIVE E. COLI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (54, N'008.04', N'INTESTINAL INFECTION DUE TO ENTEROHEMORRHAGIC E. COLI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (55, N'008.09', N'INTESTINAL INFECTION DUE TO OTHER INTESTINAL E. COLI INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (56, N'008.1', N'INTESTINAL INFECTION DUE TO ARIZONA GROUP OF PARACOLON BACILLI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (57, N'008.2', N'INTESTINAL INFECTION DUE TO AEROBACTER AEROGENES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (58, N'008.3', N'INTESTINAL INFECTION DUE TO PROTEUS (MIRABILIS) (MORGANII)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (59, N'008.41', N'INTESTINAL INFECTION DUE TO STAPHYLOCOCCUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (60, N'008.42', N'INTESTINAL INFECTION DUE TO PSEUDOMONAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (61, N'008.43', N'INTESTINAL INFECTION DUE TO CAMPYLOBACTER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (62, N'008.44', N'INTESTINAL INFECTION DUE TO YERSINIA ENTEROCOLITICA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (63, N'008.45', N'INTESTINAL INFECTION DUE TO CLOSTRIDIUM DIFFICILE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (64, N'008.46', N'INTESTINAL INFECTION DUE TO OTHER ANAEROBES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (65, N'008.47', N'INTESTINAL INFECTION DUE TO OTHER GRAM-NEGATIVE BACTERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (66, N'008.49', N'INTESTINAL INFECTION DUE TO OTHER ORGANISMS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (67, N'008.5', N'BACTERIAL ENTERITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (68, N'008.61', N'ENTERITIS DUE TO ROTAVIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (69, N'008.62', N'ENTERITIS DUE TO ADENOVIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (70, N'008.63', N'ENTERITIS DUE TO NORWALK VIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (71, N'008.64', N'ENTERITIS DUE TO OTHER SMALL ROUND VIRUSES [SRV''S]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (72, N'008.65', N'ENTERITIS DUE TO CALICIVIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (73, N'008.66', N'ENTERITIS DUE TO ASTROVIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (74, N'008.67', N'ENTERITIS DUE TO ENTEROVIRUS NEC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (75, N'008.69', N'ENTERITIS DUE TO OTHER VIRAL ENTERITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (76, N'008.8', N'INTESTINAL INFECTION DUE TO OTHER ORGANISM, NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (77, N'009.0', N'INFECTIOUS COLITIS, ENTERITIS, AND GASTROENTERITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (78, N'009.1', N'COLITIS, ENTERITIS, AND GASTROENTERITIS OF PRESUMED INFECTIOUS ORIGIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (79, N'009.2', N'INFECTIOUS DIARRHEA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (80, N'009.3', N'DIARRHEA OF PRESUMED INFECTIOUS ORIGIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (81, N'010.00', N'PRIMARY TUBERCULOUS INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (82, N'010.01', N'PRIMARY TUBERCULOUS INFECTION, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (83, N'010.02', N'PRIMARY TUBERCULOUS INFECTION, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (84, N'010.03', N'PRIMARY TUBERCULOUS INFECTION, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (85, N'010.04', N'PRIMARY TUBERCULOUS INFECTION, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (86, N'010.05', N'PRIMARY TUBERCULOUS INFECTION, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (87, N'010.06', N'PRIMARY TUBERCULOUS INFECTION, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (88, N'010.10', N'TUBERCULOUS PLEURISY IN PRIMARY PROGRESSIVE TUBERCULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (89, N'010.11', N'TUBERCULOUS PLEURISY IN PRIMARY PROGRESSIVE TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (90, N'010.12', N'TUBERCULOUS PLEURISY IN PRIMARY PROGRESSIVE TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (91, N'010.13', N'TUBERCULOUS PLEURISY IN PRIMARY PROGRESSIVE TUBERCULOSIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (92, N'010.14', N'TUBERCULOUS PLEURISY IN PRIMARY PROGRESSIVE TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (93, N'010.15', N'TUBERCULOUS PLEURISY IN PRIMARY PROGRESSIVE TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (94, N'010.16', N'TUBERCULOUS PLEURISY IN PRIMARY PROGRESSIVE TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (95, N'010.80', N'OTHER PRIMARY PROGRESSIVE TUBERCULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (96, N'010.81', N'OTHER PRIMARY PROGRESSIVE TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (97, N'010.82', N'OTHER PRIMARY PROGRESSIVE TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (98, N'010.83', N'OTHER PRIMARY PROGRESSIVE TUBERCULOSIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (99, N'010.84', N'OTHER PRIMARY PROGRESSIVE TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (100, N'010.85', N'OTHER PRIMARY PROGRESSIVE TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 100 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (101, N'010.86', N'OTHER PRIMARY PROGRESSIVE TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (102, N'010.90', N'PRIMARY TUBERCULOUS INFECTION, UNSPECIFIED, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (103, N'010.91', N'PRIMARY TUBERCULOUS INFECTION, UNSPECIFIED, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (104, N'010.92', N'PRIMARY TUBERCULOUS INFECTION, UNSPECIFIED, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (105, N'010.93', N'PRIMARY TUBERCULOUS INFECTION, UNSPECIFIED, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (106, N'010.94', N'PRIMARY TUBERCULOUS INFECTION, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (107, N'010.95', N'PRIMARY TUBERCULOUS INFECTION, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (108, N'010.96', N'PRIMARY TUBERCULOUS INFECTION, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (109, N'011.00', N'TUBERCULOSIS OF LUNG, INFILTRATIVE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (110, N'011.01', N'TUBERCULOSIS OF LUNG, INFILTRATIVE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (111, N'011.02', N'TUBERCULOSIS OF LUNG, INFILTRATIVE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (112, N'011.03', N'TUBERCULOSIS OF LUNG, INFILTRATIVE, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (113, N'011.04', N'TUBERCULOSIS OF LUNG, INFILTRATIVE, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (114, N'011.05', N'TUBERCULOSIS OF LUNG, INFILTRATIVE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (115, N'011.06', N'TUBERCULOSIS OF LUNG, INFILTRATIVE, TUBERCLE BACILLI NOT FOUND BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (116, N'011.10', N'TUBERCULOSIS OF LUNG, NODULAR, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (117, N'011.11', N'TUBERCULOSIS OF LUNG, NODULAR, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (118, N'011.12', N'TUBERCULOSIS OF LUNG, NODULAR, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (119, N'011.13', N'TUBERCULOSIS OF LUNG, NODULAR, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (120, N'011.14', N'TUBERCULOSIS OF LUNG, NODULAR, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (121, N'011.15', N'TUBERCULOSIS OF LUNG, NODULAR, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (122, N'011.16', N'TUBERCULOSIS OF LUNG, NODULAR, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (123, N'011.20', N'TUBERCULOSIS OF LUNG WITH CAVITATION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (124, N'011.21', N'TUBERCULOSIS OF LUNG WITH CAVITATION, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (125, N'011.22', N'TUBERCULOSIS OF LUNG WITH CAVITATION, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (126, N'011.23', N'TUBERCULOSIS OF LUNG WITH CAVITATION, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (127, N'011.24', N'TUBERCULOSIS OF LUNG WITH CAVITATION, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (128, N'011.25', N'TUBERCULOSIS OF LUNG WITH CAVITATION, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (129, N'011.26', N'TUBERCULOSIS OF LUNG WITH CAVITATION, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (130, N'011.30', N'TUBERCULOSIS OF BRONCHUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (131, N'011.31', N'TUBERCULOSIS OF BRONCHUS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (132, N'011.32', N'TUBERCULOSIS OF BRONCHUS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (133, N'011.33', N'TUBERCULOSIS OF BRONCHUS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (134, N'011.34', N'TUBERCULOSIS OF BRONCHUS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND IN BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (135, N'011.35', N'TUBERCULOSIS OF BRONCHUS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (136, N'011.36', N'TUBERCULOSIS OF BRONCHUS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (137, N'011.40', N'TUBERCULOUS FIBROSIS OF LUNG, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (138, N'011.41', N'TUBERCULOUS FIBROSIS OF LUNG, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (139, N'011.42', N'TUBERCULOUS FIBROSIS OF LUNG, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (140, N'011.43', N'TUBERCULOUS FIBROSIS OF LUNG, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (141, N'011.44', N'TUBERCULOUS FIBROSIS OF LUNG, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (142, N'011.45', N'TUBERCULOUS FIBROSIS OF LUNG, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (143, N'011.46', N'TUBERCULOUS FIBROSIS OF LUNG, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (144, N'011.50', N'TUBERCULOUS BRONCHIECTASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (145, N'011.51', N'TUBERCULOUS BRONCHIECTASIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (146, N'011.52', N'TUBERCULOUS BRONCHIECTASIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (147, N'011.53', N'TUBERCULOUS BRONCHIECTASIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (148, N'011.54', N'TUBERCULOUS BRONCHIECTASIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (149, N'011.55', N'TUBERCULOUS BRONCHIECTASIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (150, N'011.56', N'TUBERCULOUS BRONCHIECTASIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (151, N'011.60', N'TUBERCULOUS PNEUMONIA [ANY FORM], UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (152, N'011.61', N'TUBERCULOUS PNEUMONIA [ANY FORM], BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (153, N'011.62', N'TUBERCULOUS PNEUMONIA [ANY FORM], BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (154, N'011.63', N'TUBERCULOUS PNEUMONIA [ANY FORM], TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (155, N'011.64', N'TUBERCULOUS PNEUMONIA [ANY FORM], TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (156, N'011.65', N'TUBERCULOUS PNEUMONIA [ANY FORM], TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (157, N'011.66', N'TUBERCULOUS PNEUMONIA [ANY FORM], TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (158, N'011.70', N'TUBERCULOUS PNEUMOTHORAX, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (159, N'011.71', N'TUBERCULOUS PNEUMOTHORAX, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (160, N'011.72', N'TUBERCULOUS PNEUMOTHORAX, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (161, N'011.73', N'TUBERCULOUS PNEUMOTHORAX, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (162, N'011.74', N'TUBERCULOUS PNEUMOTHORAX, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (163, N'011.75', N'TUBERCULOUS PNEUMOTHORAX, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (164, N'011.76', N'TUBERCULOUS PNEUMOTHORAX, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (165, N'011.80', N'OTHER SPECIFIED PULMONARY TUBERCULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (166, N'011.81', N'OTHER SPECIFIED PULMONARY TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (167, N'011.82', N'OTHER SPECIFIED PULMONARY TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (168, N'011.83', N'OTHER SPECIFIED PULMONARY TUBERCULOSIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (169, N'011.84', N'OTHER SPECIFIED PULMONARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (170, N'011.85', N'OTHER SPECIFIED PULMONARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (171, N'011.86', N'OTHER SPECIFIED PULMONARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (172, N'011.90', N'PULMONARY TUBERCULOSIS, UNSPECIFIED, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (173, N'011.91', N'PULMONARY TUBERCULOSIS, UNSPECIFIED, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (174, N'011.92', N'PULMONARY TUBERCULOSIS, UNSPECIFIED, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (175, N'011.93', N'PULMONARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (176, N'011.94', N'PULMONARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (177, N'011.95', N'PULMONARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (178, N'011.96', N'PULMONARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (179, N'012.00', N'TUBERCULOUS PLEURISY, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (180, N'012.01', N'TUBERCULOUS PLEURISY, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (181, N'012.02', N'TUBERCULOUS PLEURISY, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (182, N'012.03', N'TUBERCULOUS PLEURISY, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (183, N'012.04', N'TUBERCULOUS PLEURISY, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (184, N'012.05', N'TUBERCULOUS PLEURISY, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (185, N'012.06', N'TUBERCULOUS PLEURISY, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (186, N'012.10', N'TUBERCULOSIS OF INTRATHORACIC LYMPH NODES, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (187, N'012.11', N'TUBERCULOSIS OF INTRATHORACIC LYMPH NODES, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (188, N'012.12', N'TUBERCULOSIS OF INTRATHORACIC LYMPH NODES, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (189, N'012.13', N'TUBERCULOSIS OF INTRATHORACIC LYMPH NODES, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (190, N'012.14', N'TUBERCULOSIS OF INTRATHORACIC LYMPH NODES, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (191, N'012.15', N'TUBERCULOSIS OF INTRATHORACIC LYMPH NODES, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (192, N'012.16', N'TUBERCULOSIS OF INTRATHORACIC LYMPH NODES, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (193, N'012.20', N'ISOLATED TRACHEAL OR BRONCHIAL TUBERCULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (194, N'012.21', N'ISOLATED TRACHEAL OR BRONCHIAL TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (195, N'012.22', N'ISOLATED TRACHEAL OR BRONCHIAL TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (196, N'012.23', N'ISOLATED TRACHEAL OR BRONCHIAL TUBERCULOSIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (197, N'012.24', N'ISOLATED TRACHEAL OR BRONCHIAL TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (198, N'012.25', N'ISOLATED TRACHEAL OR BRONCHIAL TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (199, N'012.26', N'ISOLATED TRACHEAL OR BRONCHIAL TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (200, N'012.30', N'TUBERCULOUS LARYNGITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (201, N'012.31', N'TUBERCULOUS LARYNGITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 200 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (202, N'012.32', N'TUBERCULOUS LARYNGITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (203, N'012.33', N'TUBERCULOUS LARYNGITIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (204, N'012.34', N'TUBERCULOUS LARYNGITIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (205, N'012.35', N'TUBERCULOUS LARYNGITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (206, N'012.36', N'TUBERCULOUS LARYNGITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (207, N'012.80', N'OTHER SPECIFIED RESPIRATORY TUBERCULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (208, N'012.81', N'OTHER SPECIFIED RESPIRATORY TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (209, N'012.82', N'OTHER SPECIFIED RESPIRATORY TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (210, N'012.83', N'OTHER SPECIFIED RESPIRATORY TUBERCULOSIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (211, N'012.84', N'OTHER SPECIFIED RESPIRATORY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (212, N'012.85', N'OTHER SPECIFIED RESPIRATORY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (213, N'012.86', N'OTHER SPECIFIED RESPIRATORY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (214, N'013.00', N'TUBERCULOUS MENINGITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (215, N'013.01', N'TUBERCULOUS MENINGITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (216, N'013.02', N'TUBERCULOUS MENINGITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (217, N'013.03', N'TUBERCULOUS MENINGITIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (218, N'013.04', N'TUBERCULOUS MENINGITIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (219, N'013.05', N'TUBERCULOUS MENINGITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (220, N'013.06', N'TUBERCULOUS MENINGITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (221, N'013.10', N'TUBERCULOMA OF MENINGES, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (222, N'013.11', N'TUBERCULOMA OF MENINGES, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (223, N'013.12', N'TUBERCULOMA OF MENINGES, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (224, N'013.13', N'TUBERCULOMA OF MENINGES, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (225, N'013.14', N'TUBERCULOMA OF MENINGES, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (226, N'013.15', N'TUBERCULOMA OF MENINGES, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (227, N'013.16', N'TUBERCULOMA OF MENINGES, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (228, N'013.20', N'TUBERCULOMA OF BRAIN, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (229, N'013.21', N'TUBERCULOMA OF BRAIN, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (230, N'013.22', N'TUBERCULOMA OF BRAIN, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (231, N'013.23', N'TUBERCULOMA OF BRAIN, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (232, N'013.24', N'TUBERCULOMA OF BRAIN, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (233, N'013.25', N'TUBERCULOMA OF BRAIN, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (234, N'013.26', N'TUBERCULOMA OF BRAIN, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (235, N'013.30', N'TUBERCULOUS ABSCESS OF BRAIN, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (236, N'013.31', N'TUBERCULOUS ABSCESS OF BRAIN, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (237, N'013.32', N'TUBERCULOUS ABSCESS OF BRAIN, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (238, N'013.33', N'TUBERCULOUS ABSCESS OF BRAIN, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (239, N'013.34', N'TUBERCULOUS ABSCESS OF BRAIN, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (240, N'013.35', N'TUBERCULOUS ABSCESS OF BRAIN, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (241, N'013.36', N'TUBERCULOUS ABSCESS OF BRAIN, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (242, N'013.40', N'TUBERCULOMA OF SPINAL CORD, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (243, N'013.41', N'TUBERCULOMA OF SPINAL CORD, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (244, N'013.42', N'TUBERCULOMA OF SPINAL CORD, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (245, N'013.43', N'TUBERCULOMA OF SPINAL CORD, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (246, N'013.44', N'TUBERCULOMA OF SPINAL CORD, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (247, N'013.45', N'TUBERCULOMA OF SPINAL CORD, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (248, N'013.46', N'TUBERCULOMA OF SPINAL CORD, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (249, N'013.50', N'TUBERCULOUS ABSCESS OF SPINAL CORD, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (250, N'013.51', N'TUBERCULOUS ABSCESS OF SPINAL CORD, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (251, N'013.52', N'TUBERCULOUS ABSCESS OF SPINAL CORD, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (252, N'013.53', N'TUBERCULOUS ABSCESS OF SPINAL CORD, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (253, N'013.54', N'TUBERCULOUS ABSCESS OF SPINAL CORD, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (254, N'013.55', N'TUBERCULOUS ABSCESS OF SPINAL CORD, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (255, N'013.56', N'TUBERCULOUS ABSCESS OF SPINAL CORD, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (256, N'013.60', N'TUBERCULOUS ENCEPHALITIS OR MYELITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (257, N'013.61', N'TUBERCULOUS ENCEPHALITIS OR MYELITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (258, N'013.62', N'TUBERCULOUS ENCEPHALITIS OR MYELITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (259, N'013.63', N'TUBERCULOUS ENCEPHALITIS OR MYELITIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (260, N'013.64', N'TUBERCULOUS ENCEPHALITIS OR MYELITIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (261, N'013.65', N'TUBERCULOUS ENCEPHALITIS OR MYELITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (262, N'013.66', N'TUBERCULOUS ENCEPHALITIS OR MYELITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (263, N'013.80', N'OTHER SPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (264, N'013.81', N'OTHER SPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (265, N'013.82', N'OTHER SPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (266, N'013.83', N'OTHER SPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (267, N'013.84', N'OTHER SPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (268, N'013.85', N'OTHER SPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (269, N'013.86', N'OTHER SPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (270, N'013.90', N'UNSPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (271, N'013.91', N'UNSPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (272, N'013.92', N'UNSPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (273, N'013.93', N'UNSPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (274, N'013.94', N'UNSPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (275, N'013.95', N'UNSPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (276, N'013.96', N'UNSPECIFIED TUBERCULOSIS OF CENTRAL NERVOUS SYSTEM, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (277, N'014.00', N'TUBERCULOUS PERITONITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (278, N'014.01', N'TUBERCULOUS PERITONITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (279, N'014.02', N'TUBERCULOUS PERITONITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (280, N'014.03', N'TUBERCULOUS PERITONITIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (281, N'014.04', N'TUBERCULOUS PERITONITIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (282, N'014.05', N'TUBERCULOUS PERITONITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (283, N'014.06', N'TUBERCULOUS PERITONITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (284, N'014.80', N'OTHER TUBERCULOSIS OF INTESTINES, PERITONEUM, AND MESENTERIC GLANDS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (285, N'014.81', N'OTHER TUBERCULOSIS OF INTESTINES, PERITONEUM, AND MESENTERIC GLANDS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (286, N'014.82', N'OTHER TUBERCULOSIS OF INTESTINES, PERITONEUM, AND MESENTERIC GLANDS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (287, N'014.83', N'OTHER TUBERCULOSIS OF INTESTINES, PERITONEUM, AND MESENTERIC GLANDS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (288, N'014.84', N'OTHER TUBERCULOSIS OF INTESTINES, PERITONEUM, AND MESENTERIC GLANDS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (289, N'014.85', N'OTHER TUBERCULOSIS OF INTESTINES, PERITONEUM, AND MESENTERIC GLANDS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (290, N'014.86', N'OTHER TUBERCULOSIS OF INTESTINES, PERITONEUM, AND MESENTERIC GLANDS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (291, N'015.00', N'TUBERCULOSIS OF VERTEBRAL COLUMN, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (292, N'015.01', N'TUBERCULOSIS OF VERTEBRAL COLUMN, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (293, N'015.02', N'TUBERCULOSIS OF VERTEBRAL COLUMN, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (294, N'015.03', N'TUBERCULOSIS OF VERTEBRAL COLUMN, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (295, N'015.04', N'TUBERCULOSIS OF VERTEBRAL COLUMN, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (296, N'015.05', N'TUBERCULOSIS OF VERTEBRAL COLUMN, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (297, N'015.06', N'TUBERCULOSIS OF VERTEBRAL COLUMN, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (298, N'015.10', N'TUBERCULOSIS OF HIP, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (299, N'015.11', N'TUBERCULOSIS OF HIP, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (300, N'015.12', N'TUBERCULOSIS OF HIP, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (301, N'015.13', N'TUBERCULOSIS OF HIP, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (302, N'015.14', N'TUBERCULOSIS OF HIP, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 300 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (303, N'015.15', N'TUBERCULOSIS OF HIP, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (304, N'015.16', N'TUBERCULOSIS OF HIP, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (305, N'015.20', N'TUBERCULOSIS OF KNEE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (306, N'015.21', N'TUBERCULOSIS OF KNEE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (307, N'015.22', N'TUBERCULOSIS OF KNEE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (308, N'015.23', N'TUBERCULOSIS OF KNEE, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (309, N'015.24', N'TUBERCULOSIS OF KNEE, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (310, N'015.25', N'TUBERCULOSIS OF KNEE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (311, N'015.26', N'TUBERCULOSIS OF KNEE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (312, N'015.50', N'TUBERCULOSIS OF LIMB BONES, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (313, N'015.51', N'TUBERCULOSIS OF LIMB BONES, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (314, N'015.52', N'TUBERCULOSIS OF LIMB BONES, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (315, N'015.53', N'TUBERCULOSIS OF LIMB BONES, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (316, N'015.54', N'TUBERCULOSIS OF LIMB BONES, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (317, N'015.55', N'TUBERCULOSIS OF LIMB BONES, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (318, N'015.56', N'TUBERCULOSIS OF LIMB BONES, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (319, N'015.60', N'TUBERCULOSIS OF MASTOID, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (320, N'015.61', N'TUBERCULOSIS OF MASTOID, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (321, N'015.62', N'TUBERCULOSIS OF MASTOID, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (322, N'015.63', N'TUBERCULOSIS OF MASTOID, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (323, N'015.64', N'TUBERCULOSIS OF MASTOID, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (324, N'015.65', N'TUBERCULOSIS OF MASTOID, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (325, N'015.66', N'TUBERCULOSIS OF MASTOID, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (326, N'015.70', N'TUBERCULOSIS OF OTHER SPECIFIED BONE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (327, N'015.71', N'TUBERCULOSIS OF OTHER SPECIFIED BONE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (328, N'015.72', N'TUBERCULOSIS OF OTHER SPECIFIED BONE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (329, N'015.73', N'TUBERCULOSIS OF OTHER SPECIFIED BONE, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (330, N'015.74', N'TUBERCULOSIS OF OTHER SPECIFIED BONE, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (331, N'015.75', N'TUBERCULOSIS OF OTHER SPECIFIED BONE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (332, N'015.76', N'TUBERCULOSIS OF OTHER SPECIFIED BONE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (333, N'015.80', N'TUBERCULOSIS OF OTHER SPECIFIED JOINT, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (334, N'015.81', N'TUBERCULOSIS OF OTHER SPECIFIED JOINT, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (335, N'015.82', N'TUBERCULOSIS OF OTHER SPECIFIED JOINT, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (336, N'015.83', N'TUBERCULOSIS OF OTHER SPECIFIED JOINT, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (337, N'015.84', N'TUBERCULOSIS OF OTHER SPECIFIED JOINT, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (338, N'015.85', N'TUBERCULOSIS OF OTHER SPECIFIED JOINT, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (339, N'015.86', N'TUBERCULOSIS OF OTHER SPECIFIED JOINT, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (340, N'015.90', N'TUBERCULOSIS OF UNSPECIFIED BONES AND JOINTS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (341, N'015.91', N'TUBERCULOSIS OF UNSPECIFIED BONES AND JOINTS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (342, N'015.92', N'TUBERCULOSIS OF UNSPECIFIED BONES AND JOINTS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (343, N'015.93', N'TUBERCULOSIS OF UNSPECIFIED BONES AND JOINTS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (344, N'015.94', N'TUBERCULOSIS OF UNSPECIFIED BONES AND JOINTS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (345, N'015.95', N'TUBERCULOSIS OF UNSPECIFIED BONES AND JOINTS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (346, N'015.96', N'TUBERCULOSIS OF UNSPECIFIED BONES AND JOINTS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (347, N'016.00', N'TUBERCULOSIS OF KIDNEY, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (348, N'016.01', N'TUBERCULOSIS OF KIDNEY, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (349, N'016.02', N'TUBERCULOSIS OF KIDNEY, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (350, N'016.03', N'TUBERCULOSIS OF KIDNEY, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (351, N'016.04', N'TUBERCULOSIS OF KIDNEY, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (352, N'016.05', N'TUBERCULOSIS OF KIDNEY, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (353, N'016.06', N'TUBERCULOSIS OF KIDNEY, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (354, N'016.10', N'TUBERCULOSIS OF BLADDER, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (355, N'016.11', N'TUBERCULOSIS OF BLADDER, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (356, N'016.12', N'TUBERCULOSIS OF BLADDER, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (357, N'016.13', N'TUBERCULOSIS OF BLADDER, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (358, N'016.14', N'TUBERCULOSIS OF BLADDER, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (359, N'016.15', N'TUBERCULOSIS OF BLADDER, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (360, N'016.16', N'TUBERCULOSIS OF BLADDER, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (361, N'016.20', N'TUBERCULOSIS OF URETER, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (362, N'016.21', N'TUBERCULOSIS OF URETER, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (363, N'016.22', N'TUBERCULOSIS OF URETER, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (364, N'016.23', N'TUBERCULOSIS OF URETER, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (365, N'016.24', N'TUBERCULOSIS OF URETER, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (366, N'016.25', N'TUBERCULOSIS OF URETER, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (367, N'016.26', N'TUBERCULOSIS OF URETER, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (368, N'016.30', N'TUBERCULOSIS OF OTHER URINARY ORGANS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (369, N'016.31', N'TUBERCULOSIS OF OTHER URINARY ORGANS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (370, N'016.32', N'TUBERCULOSIS OF OTHER URINARY ORGANS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (371, N'016.33', N'TUBERCULOSIS OF OTHER URINARY ORGANS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (372, N'016.34', N'TUBERCULOSIS OF OTHER URINARY ORGANS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (373, N'016.35', N'TUBERCULOSIS OF OTHER URINARY ORGANS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (374, N'016.36', N'TUBERCULOSIS OF OTHER URINARY ORGANS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (375, N'016.40', N'TUBERCULOSIS OF EPIDIDYMIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (376, N'016.41', N'TUBERCULOSIS OF EPIDIDYMIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (377, N'016.42', N'TUBERCULOSIS OF EPIDIDYMIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (378, N'016.43', N'TUBERCULOSIS OF EPIDIDYMIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (379, N'016.44', N'TUBERCULOSIS OF EPIDIDYMIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (380, N'016.45', N'TUBERCULOSIS OF EPIDIDYMIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (381, N'016.46', N'TUBERCULOSIS OF EPIDIDYMIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (382, N'016.50', N'TUBERCULOSIS OF OTHER MALE GENITAL ORGANS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (383, N'016.51', N'TUBERCULOSIS OF OTHER MALE GENITAL ORGANS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (384, N'016.52', N'TUBERCULOSIS OF OTHER MALE GENITAL ORGANS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (385, N'016.53', N'TUBERCULOSIS OF OTHER MALE GENITAL ORGANS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (386, N'016.54', N'TUBERCULOSIS OF OTHER MALE GENITAL ORGANS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (387, N'016.55', N'TUBERCULOSIS OF OTHER MALE GENITAL ORGANS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (388, N'016.56', N'TUBERCULOSIS OF OTHER MALE GENITAL ORGANS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (389, N'016.60', N'TUBERCULOUS OOPHORITIS AND SALPINGITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (390, N'016.61', N'TUBERCULOUS OOPHORITIS AND SALPINGITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (391, N'016.62', N'TUBERCULOUS OOPHORITIS AND SALPINGITIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (392, N'016.63', N'TUBERCULOUS OOPHORITIS AND SALPINGITIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (393, N'016.64', N'TUBERCULOUS OOPHORITIS AND SALPINGITIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (394, N'016.65', N'TUBERCULOUS OOPHORITIS AND SALPINGITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (395, N'016.66', N'TUBERCULOUS OOPHORITIS AND SALPINGITIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (396, N'016.70', N'TUBERCULOSIS OF OTHER FEMALE GENITAL ORGANS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (397, N'016.71', N'TUBERCULOSIS OF OTHER FEMALE GENITAL ORGANS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (398, N'016.72', N'TUBERCULOSIS OF OTHER FEMALE GENITAL ORGANS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (399, N'016.73', N'TUBERCULOSIS OF OTHER FEMALE GENITAL ORGANS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (400, N'016.74', N'TUBERCULOSIS OF OTHER FEMALE GENITAL ORGANS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (401, N'016.75', N'TUBERCULOSIS OF OTHER FEMALE GENITAL ORGANS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (402, N'016.76', N'TUBERCULOSIS OF OTHER FEMALE GENITAL ORGANS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (403, N'016.90', N'GENITOURINARY TUBERCULOSIS, UNSPECIFIED, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 400 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (404, N'016.91', N'GENITOURINARY TUBERCULOSIS, UNSPECIFIED, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (405, N'016.92', N'GENITOURINARY TUBERCULOSIS, UNSPECIFIED, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (406, N'016.93', N'GENITOURINARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (407, N'016.94', N'GENITOURINARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (408, N'016.95', N'GENITOURINARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (409, N'016.96', N'GENITOURINARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (410, N'017.00', N'TUBERCULOSIS OF SKIN AND SUBCUTANEOUS CELLULAR TISSUE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (411, N'017.01', N'TUBERCULOSIS OF SKIN AND SUBCUTANEOUS CELLULAR TISSUE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (412, N'017.02', N'TUBERCULOSIS OF SKIN AND SUBCUTANEOUS CELLULAR TISSUE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (413, N'017.03', N'TUBERCULOSIS OF SKIN AND SUBCUTANEOUS CELLULAR TISSUE, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (414, N'017.04', N'TUBERCULOSIS OF SKIN AND SUBCUTANEOUS CELLULAR TISSUE, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (415, N'017.05', N'TUBERCULOSIS OF SKIN AND SUBCUTANEOUS CELLULAR TISSUE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (416, N'017.06', N'TUBERCULOSIS OF SKIN AND SUBCUTANEOUS CELLULAR TISSUE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (417, N'017.10', N'ERYTHEMA NODOSUM WITH HYPERSENSITIVITY REACTION IN TUBERCULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (418, N'017.11', N'ERYTHEMA NODOSUM WITH HYPERSENSITIVITY REACTION IN TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (419, N'017.12', N'ERYTHEMA NODOSUM WITH HYPERSENSITIVITY REACTION IN TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (420, N'017.13', N'ERYTHEMA NODOSUM WITH HYPERSENSITIVITY REACTION IN TUBERCULOSIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (421, N'017.14', N'ERYTHEMA NODOSUM WITH HYPERSENSITIVITY REACTION IN TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (422, N'017.15', N'ERYTHEMA NODOSUM WITH HYPERSENSITIVITY REACTION IN TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (423, N'017.16', N'ERYTHEMA NODOSUM WITH HYPERSENSITIVITY REACTION IN TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (424, N'017.20', N'TUBERCULOSIS OF PERIPHERAL LYMPH NODES, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (425, N'017.21', N'TUBERCULOSIS OF PERIPHERAL LYMPH NODES, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (426, N'017.22', N'TUBERCULOSIS OF PERIPHERAL LYMPH NODES, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (427, N'017.23', N'TUBERCULOSIS OF PERIPHERAL LYMPH NODES, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (428, N'017.24', N'TUBERCULOSIS OF PERIPHERAL LYMPH NODES, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (429, N'017.25', N'TUBERCULOSIS OF PERIPHERAL LYMPH NODES, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (430, N'017.26', N'TUBERCULOSIS OF PERIPHERAL LYMPH NODES, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (431, N'017.30', N'TUBERCULOSIS OF EYE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (432, N'017.31', N'TUBERCULOSIS OF EYE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (433, N'017.32', N'TUBERCULOSIS OF EYE, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (434, N'017.33', N'TUBERCULOSIS OF EYE, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (435, N'017.34', N'TUBERCULOSIS OF EYE, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (436, N'017.35', N'TUBERCULOSIS OF EYE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (437, N'017.36', N'TUBERCULOSIS OF EYE, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (438, N'017.40', N'TUBERCULOSIS OF EAR, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (439, N'017.41', N'TUBERCULOSIS OF EAR, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (440, N'017.42', N'TUBERCULOSIS OF EAR, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (441, N'017.43', N'TUBERCULOSIS OF EAR, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (442, N'017.44', N'TUBERCULOSIS OF EAR, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (443, N'017.45', N'TUBERCULOSIS OF EAR, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (444, N'017.46', N'TUBERCULOSIS OF EAR, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (445, N'017.50', N'TUBERCULOSIS OF THYROID GLAND, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (446, N'017.51', N'TUBERCULOSIS OF THYROID GLAND, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (447, N'017.52', N'TUBERCULOSIS OF THYROID GLAND, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (448, N'017.53', N'TUBERCULOSIS OF THYROID GLAND, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (449, N'017.54', N'TUBERCULOSIS OF THYROID GLAND, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (450, N'017.55', N'TUBERCULOSIS OF THYROID GLAND, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (451, N'017.56', N'TUBERCULOSIS OF THYROID GLAND, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (452, N'017.60', N'TUBERCULOSIS OF ADRENAL GLANDS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (453, N'017.61', N'TUBERCULOSIS OF ADRENAL GLANDS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (454, N'017.62', N'TUBERCULOSIS OF ADRENAL GLANDS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (455, N'017.63', N'TUBERCULOSIS OF ADRENAL GLANDS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (456, N'017.64', N'TUBERCULOSIS OF ADRENAL GLANDS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (457, N'017.65', N'TUBERCULOSIS OF ADRENAL GLANDS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (458, N'017.66', N'TUBERCULOSIS OF ADRENAL GLANDS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (459, N'017.70', N'TUBERCULOSIS OF SPLEEN, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (460, N'017.71', N'TUBERCULOSIS OF SPLEEN, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (461, N'017.72', N'TUBERCULOSIS OF SPLEEN, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (462, N'017.73', N'TUBERCULOSIS OF SPLEEN, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (463, N'017.74', N'TUBERCULOSIS OF SPLEEN, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (464, N'017.75', N'TUBERCULOSIS OF SPLEEN, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (465, N'017.76', N'TUBERCULOSIS OF SPLEEN, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (466, N'017.80', N'TUBERCULOSIS OF ESOPHAGUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (467, N'017.81', N'TUBERCULOSIS OF ESOPHAGUS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (468, N'017.82', N'TUBERCULOSIS OF ESOPHAGUS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (469, N'017.83', N'TUBERCULOSIS OF ESOPHAGUS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (470, N'017.84', N'TUBERCULOSIS OF ESOPHAGUS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (471, N'017.85', N'TUBERCULOSIS OF ESOPHAGUS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (472, N'017.86', N'TUBERCULOSIS OF ESOPHAGUS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (473, N'017.90', N'TUBERCULOSIS OF OTHER SPECIFIED ORGANS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (474, N'017.91', N'TUBERCULOSIS OF OTHER SPECIFIED ORGANS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (475, N'017.92', N'TUBERCULOSIS OF OTHER SPECIFIED ORGANS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (476, N'017.93', N'TUBERCULOSIS OF OTHER SPECIFIED ORGANS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (477, N'017.94', N'TUBERCULOSIS OF OTHER SPECIFIED ORGANS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (478, N'017.95', N'TUBERCULOSIS OF OTHER SPECIFIED ORGANS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (479, N'017.96', N'TUBERCULOSIS OF OTHER SPECIFIED ORGANS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (480, N'018.00', N'ACUTE MILIARY TUBERCULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (481, N'018.01', N'ACUTE MILIARY TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (482, N'018.02', N'ACUTE MILIARY TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (483, N'018.03', N'ACUTE MILIARY TUBERCULOSIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (484, N'018.04', N'ACUTE MILIARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (485, N'018.05', N'ACUTE MILIARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (486, N'018.06', N'ACUTE MILIARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (487, N'018.80', N'OTHER SPECIFIED MILIARY TUBERCULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (488, N'018.81', N'OTHER SPECIFIED MILIARY TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (489, N'018.82', N'OTHER SPECIFIED MILIARY TUBERCULOSIS, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (490, N'018.83', N'OTHER SPECIFIED MILIARY TUBERCULOSIS, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (491, N'018.84', N'OTHER SPECIFIED MILIARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (492, N'018.85', N'OTHER SPECIFIED MILIARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (493, N'018.86', N'OTHER SPECIFIED MILIARY TUBERCULOSIS, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (494, N'018.90', N'MILIARY TUBERCULOSIS, UNSPECIFIED, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (495, N'018.91', N'MILIARY TUBERCULOSIS, UNSPECIFIED, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION NOT DONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (496, N'018.92', N'MILIARY TUBERCULOSIS, UNSPECIFIED, BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION UNKNOWN (AT PRESENT)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (497, N'018.93', N'MILIARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI FOUND (IN SPUTUM) BY MICROSCOPY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (498, N'018.94', N'MILIARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND (IN SPUTUM) BY MICROSCOPY, BUT FOUND BY BACTERIAL CULTURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (499, N'018.95', N'MILIARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED HISTOLOGICALLY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (500, N'018.96', N'MILIARY TUBERCULOSIS, UNSPECIFIED, TUBERCLE BACILLI NOT FOUND BY BACTERIOLOGICAL OR HISTOLOGICAL EXAMINATION, BUT TUBERCULOSIS CONFIRMED BY OTHER METHODS [INOCULATION OF ANIMALS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (501, N'020.0', N'BUBONIC PLAGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (502, N'020.1', N'CELLULOCUTANEOUS PLAGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (503, N'020.2', N'SEPTICEMIC PLAGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (504, N'020.3', N'PRIMARY PNEUMONIC PLAGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 500 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (505, N'020.4', N'SECONDARY PNEUMONIC PLAGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (506, N'020.5', N'PNEUMONIC PLAGUE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (507, N'020.8', N'OTHER SPECIFIED TYPES OF PLAGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (508, N'020.9', N'PLAGUE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (509, N'021.0', N'ULCEROGLANDULAR TULAREMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (510, N'021.1', N'ENTERIC TULAREMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (511, N'021.2', N'PULMONARY TULAREMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (512, N'021.3', N'OCULOGLANDULAR TULAREMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (513, N'021.8', N'OTHER SPECIFIED TULAREMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (514, N'021.9', N'UNSPECIFIED TULAREMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (515, N'022.0', N'CUTANEOUS ANTHRAX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (516, N'022.1', N'PULMONARY ANTHRAX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (517, N'022.2', N'GASTROINTESTINAL ANTHRAX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (518, N'022.3', N'ANTHRAX SEPTICEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (519, N'022.8', N'OTHER SPECIFIED MANIFESTATIONS OF ANTHRAX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (520, N'022.9', N'ANTHRAX, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (521, N'023.0', N'BRUCELLA MELITENSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (522, N'023.1', N'BRUCELLA ABORTUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (523, N'023.2', N'BRUCELLA SUIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (524, N'023.3', N'BRUCELLA CANIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (525, N'023.8', N'OTHER BRUCELLOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (526, N'023.9', N'BRUCELLOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (527, N'024.', N'GLANDERS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (528, N'025.', N'MELIOIDOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (529, N'026.0', N'SPIRILLARY FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (530, N'026.1', N'STREPTOBACILLARY FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (531, N'026.9', N'UNSPECIFIED RAT-BITE FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (532, N'027.0', N'LISTERIOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (533, N'027.1', N'ERYSIPELOTHRIX INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (534, N'027.2', N'PASTEURELLOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (535, N'027.8', N'OTHER SPECIFIED ZOONOTIC BACTERIAL DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (536, N'027.9', N'UNSPECIFIED ZOONOTIC BACTERIAL DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (537, N'030.0', N'LEPROMATOUS LEPROSY [TYPE L]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (538, N'030.1', N'TUBERCULOID LEPROSY [TYPE T]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (539, N'030.2', N'INDETERMINATE LEPROSY [GROUP I]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (540, N'030.3', N'BORDERLINE LEPROSY [GROUP B]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (541, N'030.8', N'OTHER SPECIFIED LEPROSY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (542, N'030.9', N'LEPROSY, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (543, N'031.0', N'PULMONARY DISEASES DUE TO OTHER MYCOBACTERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (544, N'031.1', N'CUTANEOUS DISEASES DUE TO OTHER MYCOBACTERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (545, N'031.2', N'DISSEMINATED DUE TO OTHER MYCOBACTERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (546, N'031.8', N'OTHER SPECIFIED MYCOBACTERIAL DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (547, N'031.9', N'UNSPECIFIED DISEASES DUE TO MYCOBACTERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (548, N'032.0', N'FAUCIAL DIPHTHERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (549, N'032.1', N'NASOPHARYNGEAL DIPHTHERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (550, N'032.2', N'ANTERIOR NASAL DIPHTHERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (551, N'032.3', N'LARYNGEAL DIPHTHERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (552, N'032.81', N'CONJUNCTIVAL DIPHTHERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (553, N'032.82', N'DIPHTHERITIC MYOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (554, N'032.83', N'DIPHTHERITIC PERITONITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (555, N'032.84', N'DIPHTHERITIC CYSTITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (556, N'032.85', N'CUTANEOUS DIPHTHERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (557, N'032.89', N'OTHER SPECIFIED DIPHTHERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (558, N'032.9', N'DIPHTHERIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (559, N'033.0', N'WHOOPING COUGH DUE TO BORDETELLA PERTUSSIS [B. PERTUSSIS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (560, N'033.1', N'WHOOPING COUGH DUE TO BORDETELLA PARAPERTUSSIS [B. PARAPERTUSSIS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (561, N'033.8', N'WHOOPING COUGH DUE TO OTHER SPECIFIED ORGANISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (562, N'033.9', N'WHOOPING COUGH, UNSPECIFIED ORGANISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (563, N'034.0', N'STREPTOCOCCAL SORE THROAT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (564, N'034.1', N'SCARLET FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (565, N'035.', N'ERYSIPELAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (566, N'036.0', N'MENINGOCOCCAL MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (567, N'036.1', N'MENINGOCOCCAL ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (568, N'036.2', N'MENINGOCOCCEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (569, N'036.3', N'WATERHOUSE-FRIDERICHSEN SYNDROME, MENINGOCOCCAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (570, N'036.40', N'MENINGOCOCCAL CARDITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (571, N'036.41', N'MENINGOCOCCAL PERICARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (572, N'036.42', N'MENINGOCOCCAL ENDOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (573, N'036.43', N'MENINGOCOCCAL MYOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (574, N'036.81', N'MENINGOCOCCAL OPTIC NEURITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (575, N'036.82', N'MENINGOCOCCAL ARTHROPATHY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (576, N'036.89', N'OTHER SPECIFIED MENINGOCOCCAL INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (577, N'036.9', N'MENINGOCOCCAL INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (578, N'037.', N'TETANUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (579, N'038.0', N'STREPTOCOCCAL SEPTICEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (580, N'038.10', N'STAPHYLOCOCCAL SEPTICEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (581, N'038.11', N'METHICILLIN SUSCEPTIBLE STAPHYLOCOCCUS AUREUS SEPTICEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (582, N'038.12', N'METHICILLIN RESISTANT STAPHYLOCOCCUS AUREUS SEPTICEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (583, N'038.19', N'OTHER STAPHYLOCOCCAL SEPTICEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (584, N'038.2', N'PNEUMOCOCCAL SEPTICEMIA [STREPTOCOCCUS PNEUMONIAE SEPTICEMIA]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (585, N'038.3', N'SEPTICEMIA DUE TO ANAEROBES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (586, N'038.40', N'SEPTICEMIA DUE TO GRAM-NEGATIVE ORGANISM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (587, N'038.41', N'SEPTICEMIA DUE TO HEMOPHILUS INFLUENZAE [H. INFLUENZAE]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (588, N'038.42', N'SEPTICEMIA DUE TO ESCHERICHIA COLI [E. COLI]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (589, N'038.43', N'SEPTICEMIA DUE TO PSEUDOMONAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (590, N'038.44', N'SEPTICEMIA DUE TO SERRATIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (591, N'038.49', N'OTHER SEPTICEMIA DUE TO GRAM-NEGATIVE ORGANISMS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (592, N'038.8', N'OTHER SPECIFIED SEPTICEMIAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (593, N'038.9', N'UNSPECIFIED SEPTICEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (594, N'039.0', N'CUTANEOUS ACTINOMYCOTIC INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (595, N'039.1', N'PULMONARY ACTINOMYCOTIC INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (596, N'039.2', N'ABDOMINAL ACTINOMYCOTIC INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (597, N'039.3', N'CERVICOFACIAL ACTINOMYCOTIC INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (598, N'039.4', N'MADURA FOOT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (599, N'039.8', N'ACTINOMYCOTIC INFECTION OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (600, N'039.9', N'ACTINOMYCOTIC INFECTION OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (601, N'040.0', N'GAS GANGRENE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (602, N'040.1', N'RHINOSCLEROMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (603, N'040.2', N'WHIPPLE''S DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (604, N'040.3', N'NECROBACILLOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (605, N'040.41', N'INFANT BOTULISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 600 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (606, N'040.42', N'WOUND BOTULISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (607, N'040.81', N'TROPICAL PYOMYOSITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (608, N'040.82', N'TOXIC SHOCK SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (609, N'040.89', N'OTHER SPECIFIED BACTERIAL DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (610, N'041.00', N'STREPTOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, STREPTOCOCCUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (611, N'041.01', N'STREPTOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, STREPTOCOCCUS, GROUP A', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (612, N'041.02', N'STREPTOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, STREPTOCOCCUS, GROUP B', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (613, N'041.03', N'STREPTOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, STREPTOCOCCUS, GROUP C', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (614, N'041.04', N'STREPTOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, STREPTOCOCCUS, GROUP D [ENTEROCOCCUS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (615, N'041.05', N'STREPTOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, STREPTOCOCCUS, GROUP G', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (616, N'041.09', N'STREPTOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, OTHER STREPTOCOCCUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (617, N'041.10', N'STAPHYLOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, STAPHYLOCOCCUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (618, N'041.11', N'METHICILLIN SUSCEPTIBLE STAPHYLOCOCCUS AUREUS IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (619, N'041.12', N'METHICILLIN RESISTANT STAPHYLOCOCCUS AUREUS IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (620, N'041.19', N'STAPHYLOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, OTHER STAPHYLOCOCCUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (621, N'041.2', N'PNEUMOCOCCUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (622, N'041.3', N'FRIEDLSNDER''S BACILLUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (623, N'041.41', N'SHIGA TOXIN-PRODUCING ESCHERICHIA COLI [E. COLI] (STEC) O157', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (624, N'041.42', N'OTHER SPECIFIED SHIGA TOXIN-PRODUCING ESCHERICHIA COLI [E. COLI] (STEC)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (625, N'041.43', N'SHIGA TOXIN-PRODUCING ESCHERICHIA COLI [E. COLI] (STEC), UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (626, N'041.49', N'OTHER AND UNSPECIFIED ESCHERICHIA COLI [E. COLI]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (627, N'041.5', N'HEMOPHILUS INFLUENZAE [H. INFLUENZAE] INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (628, N'041.6', N'PROTEUS (MIRABILIS) (MORGANII) INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (629, N'041.7', N'PSEUDOMONAS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (630, N'041.81', N'OTHER SPECIFIED BACTERIAL INFECTIONS IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, MYCOPLASMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (631, N'041.82', N'BACTEROIDES FRAGILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (632, N'041.83', N'OTHER SPECIFIED BACTERIAL INFECTIONS IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, CLOSTRIDIUM PERFRINGENS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (633, N'041.84', N'OTHER SPECIFIED BACTERIAL INFECTIONS IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, OTHER ANAEROBES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (634, N'041.85', N'OTHER SPECIFIED BACTERIAL INFECTIONS IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, OTHER GRAM-NEGATIVE ORGANISMS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (635, N'041.86', N'HELICOBACTER PYLORI [H. PYLORI]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (636, N'041.89', N'OTHER SPECIFIED BACTERIAL INFECTIONS IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE, OTHER SPECIFIED BACTERIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (637, N'041.9', N'BACTERIAL INFECTION, UNSPECIFIED, IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (638, N'042.', N'HUMAN IMMUNODEFICIENCY VIRUS [HIV] DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (639, N'045.00', N'ACUTE PARALYTIC POLIOMYELITIS SPECIFIED AS BULBAR, POLIOVIRUS, UNSPECIFIED TYPE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (640, N'045.01', N'ACUTE PARALYTIC POLIOMYELITIS SPECIFIED AS BULBAR, POLIOVIRUS TYPE I', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (641, N'045.02', N'ACUTE PARALYTIC POLIOMYELITIS SPECIFIED AS BULBAR, POLIOVIRUS TYPE II', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (642, N'045.03', N'ACUTE PARALYTIC POLIOMYELITIS SPECIFIED AS BULBAR, POLIOVIRUS TYPE III', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (643, N'045.10', N'ACUTE POLIOMYELITIS WITH OTHER PARALYSIS, POLIOVIRUS, UNSPECIFIED TYPE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (644, N'045.11', N'ACUTE POLIOMYELITIS WITH OTHER PARALYSIS, POLIOVIRUS TYPE I', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (645, N'045.12', N'ACUTE POLIOMYELITIS WITH OTHER PARALYSIS, POLIOVIRUS TYPE II', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (646, N'045.13', N'ACUTE POLIOMYELITIS WITH OTHER PARALYSIS, POLIOVIRUS TYPE III', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (647, N'045.20', N'ACUTE NONPARALYTIC POLIOMYELITIS, POLIOVIRUS, UNSPECIFIED TYPE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (648, N'045.21', N'ACUTE NONPARALYTIC POLIOMYELITIS, POLIOVIRUS TYPE I', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (649, N'045.22', N'ACUTE NONPARALYTIC POLIOMYELITIS, POLIOVIRUS TYPE II', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (650, N'045.23', N'ACUTE NONPARALYTIC POLIOMYELITIS, POLIOVIRUS TYPE III', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (651, N'045.90', N'ACUTE POLIOMYELITIS, UNSPECIFIED, POLIOVIRUS, UNSPECIFIED TYPE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (652, N'045.91', N'ACUTE POLIOMYELITIS, UNSPECIFIED, POLIOVIRUS TYPE I', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (653, N'045.92', N'ACUTE POLIOMYELITIS, UNSPECIFIED, POLIOVIRUS TYPE II', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (654, N'045.93', N'ACUTE POLIOMYELITIS, UNSPECIFIED, POLIOVIRUS TYPE III', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (655, N'046.0', N'KURU', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (656, N'046.11', N'VARIANT CREUTZFELDT-JAKOB DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (657, N'046.19', N'OTHER AND UNSPECIFIED CREUTZFELDT-JAKOB DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (658, N'046.2', N'SUBACUTE SCLEROSING PANENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (659, N'046.3', N'PROGRESSIVE MULTIFOCAL LEUKOENCEPHALOPATHY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (660, N'046.71', N'GERSTMANN-STRSUSSLER-SCHEINKER SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (661, N'046.72', N'FATAL FAMILIAL INSOMNIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (662, N'046.79', N'OTHER AND UNSPECIFIED PRION DISEASE OF CENTRAL NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (663, N'046.8', N'OTHER SPECIFIED SLOW VIRUS INFECTION OF CENTRAL NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (664, N'046.9', N'UNSPECIFIED SLOW VIRUS INFECTION OF CENTRAL NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (665, N'047.0', N'MENINGITIS DUE TO COXSACKIE VIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (666, N'047.1', N'MENINGITIS DUE TO ECHO VIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (667, N'047.8', N'OTHER SPECIFIED VIRAL MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (668, N'047.9', N'UNSPECIFIED VIRAL MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (669, N'048.', N'OTHER ENTEROVIRUS DISEASES OF CENTRAL NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (670, N'049.0', N'LYMPHOCYTIC CHORIOMENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (671, N'049.1', N'MENINGITIS DUE TO ADENOVIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (672, N'049.8', N'OTHER SPECIFIED NON-ARTHROPOD-BORNE VIRAL DISEASES OF CENTRAL NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (673, N'049.9', N'UNSPECIFIED NON-ARTHROPOD-BORNE VIRAL DISEASES OF CENTRAL NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (674, N'050.0', N'VARIOLA MAJOR', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (675, N'050.1', N'ALASTRIM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (676, N'050.2', N'MODIFIED SMALLPOX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (677, N'050.9', N'SMALLPOX, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (678, N'051.01', N'COWPOX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (679, N'051.02', N'VACCINIA NOT FROM VACCINATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (680, N'051.1', N'PSEUDOCOWPOX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (681, N'051.2', N'CONTAGIOUS PUSTULAR DERMATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (682, N'051.9', N'PARAVACCINIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (683, N'052.0', N'POSTVARICELLA ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (684, N'052.1', N'VARICELLA (HEMORRHAGIC) PNEUMONITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (685, N'052.2', N'POSTVARICELLA MYELITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (686, N'052.7', N'CHICKENPOX WITH OTHER SPECIFIED COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (687, N'052.8', N'CHICKENPOX WITH UNSPECIFIED COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (688, N'052.9', N'VARICELLA WITHOUT MENTION OF COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (689, N'053.0', N'HERPES ZOSTER WITH MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (690, N'053.10', N'HERPES ZOSTER WITH UNSPECIFIED NERVOUS SYSTEM COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (691, N'053.11', N'GENICULATE HERPES ZOSTER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (692, N'053.12', N'POSTHERPETIC TRIGEMINAL NEURALGIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (693, N'053.13', N'POSTHERPETIC POLYNEUROPATHY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (694, N'053.14', N'HERPES ZOSTER MYELITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (695, N'053.19', N'HERPES ZOSTER WITH OTHER NERVOUS SYSTEM COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (696, N'053.20', N'HERPES ZOSTER DERMATITIS OF EYELID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (697, N'053.21', N'HERPES ZOSTER KERATOCONJUNCTIVITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (698, N'053.22', N'HERPES ZOSTER IRIDOCYCLITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (699, N'053.29', N'HERPES ZOSTER WITH OTHER OPHTHALMIC COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (700, N'053.71', N'OTITIS EXTERNA DUE TO HERPES ZOSTER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (701, N'053.79', N'HERPES ZOSTER WITH OTHER SPECIFIED COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (702, N'053.8', N'HERPES ZOSTER WITH UNSPECIFIED COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (703, N'053.9', N'HERPES ZOSTER WITHOUT MENTION OF COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (704, N'054.0', N'ECZEMA HERPETICUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (705, N'054.10', N'GENITAL HERPES, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (706, N'054.11', N'HERPETIC VULVOVAGINITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 700 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (707, N'054.12', N'HERPETIC ULCERATION OF VULVA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (708, N'054.13', N'HERPETIC INFECTION OF PENIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (709, N'054.19', N'OTHER GENITAL HERPES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (710, N'054.2', N'HERPETIC GINGIVOSTOMATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (711, N'054.3', N'HERPETIC MENINGOENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (712, N'054.40', N'HERPES SIMPLEX WITH UNSPECIFIED OPHTHALMIC COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (713, N'054.41', N'HERPES SIMPLEX DERMATITIS OF EYELID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (714, N'054.42', N'DENDRITIC KERATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (715, N'054.43', N'HERPES SIMPLEX DISCIFORM KERATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (716, N'054.44', N'HERPES SIMPLEX IRIDOCYCLITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (717, N'054.49', N'HERPES SIMPLEX WITH OTHER OPHTHALMIC COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (718, N'054.5', N'HERPETIC SEPTICEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (719, N'054.6', N'HERPETIC WHITLOW', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (720, N'054.71', N'VISCERAL HERPES SIMPLEX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (721, N'054.72', N'HERPES SIMPLEX MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (722, N'054.73', N'HERPES SIMPLEX OTITIS EXTERNA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (723, N'054.74', N'HERPES SIMPLEX MYELITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (724, N'054.79', N'HERPES SIMPLEX WITH OTHER SPECIFIED COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (725, N'054.8', N'HERPES SIMPLEX WITH UNSPECIFIED COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (726, N'054.9', N'HERPES SIMPLEX WITHOUT MENTION OF COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (727, N'055.0', N'POSTMEASLES ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (728, N'055.1', N'POSTMEASLES PNEUMONIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (729, N'055.2', N'POSTMEASLES OTITIS MEDIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (730, N'055.71', N'MEASLES KERATOCONJUNCTIVITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (731, N'055.79', N'MEASLES WITH OTHER SPECIFIED COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (732, N'055.8', N'MEASLES WITH UNSPECIFIED COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (733, N'055.9', N'MEASLES WITHOUT MENTION OF COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (734, N'056.00', N'RUBELLA WITH UNSPECIFIED NEUROLOGICAL COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (735, N'056.01', N'ENCEPHALOMYELITIS DUE TO RUBELLA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (736, N'056.09', N'RUBELLA WITH OTHER NEUROLOGICAL COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (737, N'056.71', N'ARTHRITIS DUE TO RUBELLA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (738, N'056.79', N'RUBELLA WITH OTHER SPECIFIED COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (739, N'056.8', N'RUBELLA WITH UNSPECIFIED COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (740, N'056.9', N'RUBELLA WITHOUT MENTION OF COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (741, N'057.0', N'ERYTHEMA INFECTIOSUM (FIFTH DISEASE)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (742, N'057.8', N'OTHER SPECIFIED VIRAL EXANTHEMATA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (743, N'057.9', N'VIRAL EXANTHEM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (744, N'058.10', N'ROSEOLA INFANTUM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (745, N'058.11', N'ROSEOLA INFANTUM DUE TO HUMAN HERPESVIRUS 6', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (746, N'058.12', N'ROSEOLA INFANTUM DUE TO HUMAN HERPESVIRUS 7', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (747, N'058.21', N'HUMAN HERPESVIRUS 6 ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (748, N'058.29', N'OTHER HUMAN HERPESVIRUS ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (749, N'058.81', N'HUMAN HERPESVIRUS 6 INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (750, N'058.82', N'HUMAN HERPESVIRUS 7 INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (751, N'058.89', N'OTHER HUMAN HERPESVIRUS INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (752, N'059.00', N'ORTHOPOXVIRUS INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (753, N'059.01', N'MONKEYPOX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (754, N'059.09', N'OTHER ORTHOPOXVIRUS INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (755, N'059.10', N'PARAPOXVIRUS INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (756, N'059.11', N'BOVINE STOMATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (757, N'059.12', N'SEALPOX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (758, N'059.19', N'OTHER PARAPOXVIRUS INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (759, N'059.20', N'YATAPOXVIRUS INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (760, N'059.21', N'TANAPOX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (761, N'059.22', N'YABA MONKEY TUMOR VIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (762, N'059.8', N'OTHER POXVIRUS INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (763, N'059.9', N'POXVIRUS INFECTIONS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (764, N'060.0', N'SYLVATIC YELLOW FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (765, N'060.1', N'URBAN YELLOW FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (766, N'060.9', N'YELLOW FEVER, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (767, N'061.', N'DENGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (768, N'062.0', N'JAPANESE ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (769, N'062.1', N'WESTERN EQUINE ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (770, N'062.2', N'EASTERN EQUINE ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (771, N'062.3', N'ST. LOUIS ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (772, N'062.4', N'AUSTRALIAN ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (773, N'062.5', N'CALIFORNIA VIRUS ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (774, N'062.8', N'OTHER SPECIFIED MOSQUITO-BORNE VIRAL ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (775, N'062.9', N'MOSQUITO-BORNE VIRAL ENCEPHALITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (776, N'063.0', N'RUSSIAN SPRING-SUMMER [TAIGA] ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (777, N'063.1', N'LOUPING ILL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (778, N'063.2', N'CENTRAL EUROPEAN ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (779, N'063.8', N'OTHER SPECIFIED TICK-BORNE VIRAL ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (780, N'063.9', N'TICK-BORNE VIRAL ENCEPHALITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (781, N'064.', N'VIRAL ENCEPHALITIS TRANSMITTED BY OTHER AND UNSPECIFIED ARTHROPODS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (782, N'065.0', N'CRIMEAN HEMORRHAGIC FEVER [CHF CONGO VIRUS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (783, N'065.1', N'OMSK HEMORRHAGIC FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (784, N'065.2', N'KYASANUR FOREST DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (785, N'065.3', N'OTHER TICK-BORNE HEMORRHAGIC FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (786, N'065.4', N'MOSQUITO-BORNE HEMORRHAGIC FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (787, N'065.8', N'OTHER SPECIFIED ARTHROPOD-BORNE HEMORRHAGIC FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (788, N'065.9', N'ARTHROPOD-BORNE HEMORRHAGIC FEVER, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (789, N'066.0', N'PHLEBOTOMUS FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (790, N'066.1', N'TICK-BORNE FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (791, N'066.2', N'VENEZUELAN EQUINE FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (792, N'066.3', N'OTHER MOSQUITO-BORNE FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (793, N'066.40', N'WEST NILE FEVER, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (794, N'066.41', N'WEST NILE FEVER WITH ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (795, N'066.42', N'WEST NILE FEVER WITH OTHER NEUROLOGIC MANIFESTATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (796, N'066.49', N'WEST NILE FEVER WITH OTHER COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (797, N'066.8', N'OTHER SPECIFIED ARTHROPOD-BORNE VIRAL DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (798, N'066.9', N'ARTHROPOD-BORNE VIRAL DISEASE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (799, N'070.0', N'VIRAL HEPATITIS A WITH HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (800, N'070.1', N'VIRAL HEPATITIS A WITHOUT MENTION OF HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (801, N'070.20', N'VIRAL HEPATITIS B WITH HEPATIC COMA, ACUTE OR UNSPECIFIED, WITHOUT MENTION OF HEPATITIS DELTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (802, N'070.21', N'VIRAL HEPATITIS B WITH HEPATIC COMA, ACUTE OR UNSPECIFIED, WITH HEPATITIS DELTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (803, N'070.22', N'CHRONIC VIRAL HEPATITIS B WITH HEPATIC COMA WITHOUT HEPATITIS DELTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (804, N'070.23', N'CHRONIC VIRAL HEPATITIS B WITH HEPATIC COMA WITH HEPATITIS DELTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (805, N'070.30', N'VIRAL HEPATITIS B WITHOUT MENTION OF HEPATIC COMA, ACUTE OR UNSPECIFIED, WITHOUT MENTION OF HEPATITIS DELTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (806, N'070.31', N'VIRAL HEPATITIS B WITHOUT MENTION OF HEPATIC COMA, ACUTE OR UNSPECIFIED, WITH HEPATITIS DELTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (807, N'070.32', N'CHRONIC VIRAL HEPATITIS B WITHOUT MENTION OF HEPATIC COMA WITHOUT MENTION OF HEPATITIS DELTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 800 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (808, N'070.33', N'CHRONIC VIRAL HEPATITIS B WITHOUT MENTION OF HEPATIC COMA WITH HEPATITIS DELTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (809, N'070.41', N'ACUTE HEPATITIS C WITH HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (810, N'070.42', N'HEPATITIS DELTA WITHOUT MENTION OF ACTIVE HEPATITIS B DISEASE WITH HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (811, N'070.43', N'HEPATITIS E WITH HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (812, N'070.44', N'CHRONIC HEPATITIS C WITH HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (813, N'070.49', N'OTHER SPECIFIED VIRAL HEPATITIS WITH HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (814, N'070.51', N'ACUTE HEPATITIS C WITHOUT MENTION OF HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (815, N'070.52', N'HEPATITIS DELTA WITHOUT MENTION OF ACTIVE HEPATITIS B DISEASE OR HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (816, N'070.53', N'HEPATITIS E WITHOUT MENTION OF HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (817, N'070.54', N'CHRONIC HEPATITIS C WITHOUT MENTION OF HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (818, N'070.59', N'OTHER SPECIFIED VIRAL HEPATITIS WITHOUT MENTION OF HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (819, N'070.6', N'UNSPECIFIED VIRAL HEPATITIS WITH HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (820, N'070.70', N'UNSPECIFIED VIRAL HEPATITIS C WITHOUT HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (821, N'070.71', N'UNSPECIFIED VIRAL HEPATITIS C WITH HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (822, N'070.9', N'UNSPECIFIED VIRAL HEPATITIS WITHOUT MENTION OF HEPATIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (823, N'071.', N'RABIES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (824, N'072.0', N'MUMPS ORCHITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (825, N'072.1', N'MUMPS MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (826, N'072.2', N'MUMPS ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (827, N'072.3', N'MUMPS PANCREATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (828, N'072.71', N'MUMPS HEPATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (829, N'072.72', N'MUMPS POLYNEUROPATHY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (830, N'072.79', N'OTHER MUMPS WITH OTHER SPECIFIED COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (831, N'072.8', N'MUMPS WITH UNSPECIFIED COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (832, N'072.9', N'MUMPS WITHOUT MENTION OF COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (833, N'073.0', N'ORNITHOSIS WITH PNEUMONIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (834, N'073.7', N'ORNITHOSIS WITH OTHER SPECIFIED COMPLICATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (835, N'073.8', N'ORNITHOSIS WITH UNSPECIFIED COMPLICATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (836, N'073.9', N'ORNITHOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (837, N'074.0', N'HERPANGINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (838, N'074.1', N'EPIDEMIC PLEURODYNIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (839, N'074.20', N'COXSACKIE CARDITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (840, N'074.21', N'COXSACKIE PERICARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (841, N'074.22', N'COXSACKIE ENDOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (842, N'074.23', N'COXSACKIE MYOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (843, N'074.3', N'HAND, FOOT, AND MOUTH DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (844, N'074.8', N'OTHER SPECIFIED DISEASES DUE TO COXSACKIE VIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (845, N'075.', N'INFECTIOUS MONONUCLEOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (846, N'076.0', N'TRACHOMA, INITIAL STAGE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (847, N'076.1', N'TRACHOMA, ACTIVE STAGE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (848, N'076.9', N'TRACHOMA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (849, N'077.0', N'INCLUSION CONJUNCTIVITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (850, N'077.1', N'EPIDEMIC KERATOCONJUNCTIVITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (851, N'077.2', N'PHARYNGOCONJUNCTIVAL FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (852, N'077.3', N'OTHER ADENOVIRAL CONJUNCTIVITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (853, N'077.4', N'EPIDEMIC HEMORRHAGIC CONJUNCTIVITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (854, N'077.8', N'OTHER VIRAL CONJUNCTIVITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (855, N'077.98', N'UNSPECIFIED DISEASES OF CONJUNCTIVA DUE TO CHLAMYDIAE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (856, N'077.99', N'UNSPECIFIED DISEASES OF CONJUNCTIVA DUE TO VIRUSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (857, N'078.0', N'MOLLUSCUM CONTAGIOSUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (858, N'078.10', N'VIRAL WARTS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (859, N'078.11', N'CONDYLOMA ACUMINATUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (860, N'078.12', N'PLANTAR WART', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (861, N'078.19', N'OTHER SPECIFIED VIRAL WARTS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (862, N'078.2', N'SWEATING FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (863, N'078.3', N'CAT-SCRATCH DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (864, N'078.4', N'FOOT AND MOUTH DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (865, N'078.5', N'CYTOMEGALOVIRAL DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (866, N'078.6', N'HEMORRHAGIC NEPHROSONEPHRITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (867, N'078.7', N'ARENAVIRAL HEMORRHAGIC FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (868, N'078.81', N'EPIDEMIC VERTIGO', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (869, N'078.82', N'EPIDEMIC VOMITING SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (870, N'078.88', N'OTHER SPECIFIED DISEASES DUE TO CHLAMYDIAE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (871, N'078.89', N'OTHER SPECIFIED DISEASES DUE TO VIRUSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (872, N'079.0', N'ADENOVIRUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (873, N'079.1', N'ECHO VIRUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (874, N'079.2', N'COXSACKIE VIRUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (875, N'079.3', N'RHINOVIRUS INFECTION IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (876, N'079.4', N'HUMAN PAPILLOMAVIRUS IN CONDITIONS CLASSIFIED ELSEWHERE AND OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (877, N'079.50', N'RETROVIRUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (878, N'079.51', N'HUMAN T-CELL LYMPHOTROPHIC VIRUS, TYPE I [HTLV-I]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (879, N'079.52', N'HUMAN T-CELL LYMPHOTROPHIC VIRUS, TYPE II [HTLV-II]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (880, N'079.53', N'HUMAN IMMUNODEFICIENCY VIRUS, TYPE 2 [HIV-2]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (881, N'079.59', N'OTHER SPECIFIED RETROVIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (882, N'079.6', N'RESPIRATORY SYNCYTIAL VIRUS (RSV)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (883, N'079.81', N'HANTAVIRUS INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (884, N'079.82', N'SARS-ASSOCIATED CORONAVIRUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (885, N'079.83', N'PARVOVIRUS B19', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (886, N'079.88', N'OTHER SPECIFIED CHLAMYDIAL INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (887, N'079.89', N'OTHER SPECIFIED VIRAL INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (888, N'079.98', N'UNSPECIFIED CHLAMYDIAL INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (889, N'079.99', N'UNSPECIFIED VIRAL INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (890, N'080.', N'LOUSE-BORNE (EPIDEMIC) TYPHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (891, N'081.0', N'MURINE (ENDEMIC) TYPHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (892, N'081.1', N'BRILL''S DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (893, N'081.2', N'SCRUB TYPHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (894, N'081.9', N'TYPHUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (895, N'082.0', N'SPOTTED FEVERS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (896, N'082.1', N'BOUTONNEUSE FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (897, N'082.2', N'NORTH ASIAN TICK FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (898, N'082.3', N'QUEENSLAND TICK TYPHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (899, N'082.40', N'EHRLICHIOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (900, N'082.41', N'EHRLICHIOSIS CHAFEENSIS [E. CHAFEENSIS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (901, N'082.49', N'OTHER EHRLICHIOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (902, N'082.8', N'OTHER SPECIFIED TICK-BORNE RICKETTSIOSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (903, N'082.9', N'TICK-BORNE RICKETTSIOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (904, N'083.0', N'Q FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (905, N'083.1', N'TRENCH FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (906, N'083.2', N'RICKETTSIALPOX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (907, N'083.8', N'OTHER SPECIFIED RICKETTSIOSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (908, N'083.9', N'RICKETTSIOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 900 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (909, N'084.0', N'FALCIPARUM MALARIA [MALIGNANT TERTIAN]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (910, N'084.1', N'VIVAX MALARIA [BENIGN TERTIAN]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (911, N'084.2', N'QUARTAN MALARIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (912, N'084.3', N'OVALE MALARIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (913, N'084.4', N'OTHER MALARIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (914, N'084.5', N'MIXED MALARIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (915, N'084.6', N'MALARIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (916, N'084.7', N'INDUCED MALARIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (917, N'084.8', N'BLACKWATER FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (918, N'084.9', N'OTHER PERNICIOUS COMPLICATIONS OF MALARIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (919, N'085.0', N'VISCERAL [KALA-AZAR] LEISHMANIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (920, N'085.1', N'CUTANEOUS LEISHMANIASIS, URBAN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (921, N'085.2', N'CUTANEOUS LEISHMANIASIS, ASIAN DESERT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (922, N'085.3', N'CUTANEOUS LEISHMANIASIS, ETHIOPIAN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (923, N'085.4', N'CUTANEOUS LEISHMANIASIS, AMERICAN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (924, N'085.5', N'MUCOCUTANEOUS LEISHMANIASIS, (AMERICAN)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (925, N'085.9', N'LEISHMANIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (926, N'086.0', N'CHAGAS'' DISEASE WITH HEART INVOLVEMENT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (927, N'086.1', N'CHAGAS'' DISEASE WITH OTHER ORGAN INVOLVEMENT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (928, N'086.2', N'CHAGAS'' DISEASE WITHOUT MENTION OF ORGAN INVOLVEMENT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (929, N'086.3', N'GAMBIAN TRYPANOSOMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (930, N'086.4', N'RHODESIAN TRYPANOSOMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (931, N'086.5', N'AFRICAN TRYPANOSOMIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (932, N'086.9', N'TRYPANOSOMIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (933, N'087.0', N'RELAPSING FEVER, LOUSE-BORNE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (934, N'087.1', N'RELAPSING FEVER, TICK-BORNE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (935, N'087.9', N'RELAPSING FEVER, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (936, N'088.0', N'BARTONELLOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (937, N'088.81', N'LYME DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (938, N'088.82', N'BABESIOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (939, N'088.89', N'OTHER SPECIFIED ARTHROPOD-BORNE DISEASES, OTHER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (940, N'088.9', N'ARTHROPOD-BORNE DISEASE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (941, N'090.0', N'EARLY CONGENITAL SYPHILIS, SYMPTOMATIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (942, N'090.1', N'EARLY CONGENITAL SYPHILIS, LATENT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (943, N'090.2', N'EARLY CONGENITAL SYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (944, N'090.3', N'SYPHILITIC INTERSTITIAL KERATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (945, N'090.40', N'JUVENILE NEUROSYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (946, N'090.41', N'CONGENITAL SYPHILITIC ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (947, N'090.42', N'CONGENITAL SYPHILITIC MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (948, N'090.49', N'OTHER JUVENILE NEUROSYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (949, N'090.5', N'OTHER LATE CONGENITAL SYPHILIS, SYMPTOMATIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (950, N'090.6', N'LATE CONGENITAL SYPHILIS, LATENT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (951, N'090.7', N'LATE CONGENITAL SYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (952, N'090.9', N'CONGENITAL SYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (953, N'091.0', N'GENITAL SYPHILIS (PRIMARY)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (954, N'091.1', N'PRIMARY ANAL SYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (955, N'091.2', N'OTHER PRIMARY SYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (956, N'091.3', N'SECONDARY SYPHILIS OF SKIN OR MUCOUS MEMBRANES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (957, N'091.4', N'ADENOPATHY DUE TO SECONDARY SYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (958, N'091.50', N'SYPHILITIC UVEITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (959, N'091.51', N'SYPHILITIC CHORIORETINITIS (SECONDARY)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (960, N'091.52', N'SYPHILITIC IRIDOCYCLITIS (SECONDARY)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (961, N'091.61', N'SECONDARY SYPHILITIC PERIOSTITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (962, N'091.62', N'SECONDARY SYPHILITIC HEPATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (963, N'091.69', N'SECONDARY SYPHILIS OF OTHER VISCERA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (964, N'091.7', N'SECONDARY SYPHILIS, RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (965, N'091.81', N'ACUTE SYPHILITIC MENINGITIS (SECONDARY)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (966, N'091.82', N'SYPHILITIC ALOPECIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (967, N'091.89', N'OTHER FORMS OF SECONDARY SYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (968, N'091.9', N'UNSPECIFIED SECONDARY SYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (969, N'092.0', N'EARLY SYPHILIS, LATENT, SEROLOGICAL RELAPSE AFTER TREATMENT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (970, N'092.9', N'EARLY SYPHILIS, LATENT, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (971, N'093.0', N'ANEURYSM OF AORTA, SPECIFIED AS SYPHILITIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (972, N'093.1', N'SYPHILITIC AORTITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (973, N'093.20', N'SYPHILITIC ENDOCARDITIS OF VALVE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (974, N'093.21', N'SYPHILITIC ENDOCARDITIS OF MITRAL VALVE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (975, N'093.22', N'SYPHILITIC ENDOCARDITIS OF AORTIC VALVE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (976, N'093.23', N'SYPHILITIC ENDOCARDITIS OF TRICUSPID VALVE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (977, N'093.24', N'SYPHILITIC ENDOCARDITIS OF PULMONARY VALVE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (978, N'093.81', N'SYPHILITIC PERICARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (979, N'093.82', N'SYPHILITIC MYOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (980, N'093.89', N'OTHER SPECIFIED CARDIOVASCULAR SYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (981, N'093.9', N'CARDIOVASCULAR SYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (982, N'094.0', N'TABES DORSALIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (983, N'094.1', N'GENERAL PARESIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (984, N'094.2', N'SYPHILITIC MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (985, N'094.3', N'ASYMPTOMATIC NEUROSYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (986, N'094.81', N'SYPHILITIC ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (987, N'094.82', N'SYPHILITIC PARKINSONISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (988, N'094.83', N'SYPHILITIC DISSEMINATED RETINOCHOROIDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (989, N'094.84', N'SYPHILITIC OPTIC ATROPHY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (990, N'094.85', N'SYPHILITIC RETROBULBAR NEURITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (991, N'094.86', N'SYPHILITIC ACOUSTIC NEURITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (992, N'094.87', N'SYPHILITIC RUPTURED CEREBRAL ANEURYSM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (993, N'094.89', N'OTHER SPECIFIED NEUROSYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (994, N'094.9', N'NEUROSYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (995, N'095.0', N'SYPHILITIC EPISCLERITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (996, N'095.1', N'SYPHILIS OF LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (997, N'095.2', N'SYPHILITIC PERITONITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (998, N'095.3', N'SYPHILIS OF LIVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (999, N'095.4', N'SYPHILIS OF KIDNEY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1000, N'095.5', N'SYPHILIS OF BONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1001, N'095.6', N'SYPHILIS OF MUSCLE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1002, N'095.7', N'SYPHILIS OF SYNOVIUM, TENDON, AND BURSA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1003, N'095.8', N'OTHER SPECIFIED FORMS OF LATE SYMPTOMATIC SYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1004, N'095.9', N'LATE SYMPTOMATIC SYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1005, N'096.', N'LATE SYPHILIS, LATENT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1006, N'097.0', N'LATE SYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1007, N'097.1', N'LATENT SYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1008, N'097.9', N'SYPHILIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1009, N'098.0', N'GONOCOCCAL INFECTION (ACUTE) OF LOWER GENITOURINARY TRACT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1000 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1010, N'098.10', N'GONOCOCCAL INFECTION (ACUTE) OF UPPER GENITOURINARY TRACT, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1011, N'098.11', N'GONOCOCCAL CYSTITIS (ACUTE)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1012, N'098.12', N'GONOCOCCAL PROSTATITIS (ACUTE)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1013, N'098.13', N'GONOCOCCAL EPIDIDYMO-ORCHITIS (ACUTE)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1014, N'098.14', N'GONOCOCCAL SEMINAL VESICULITIS (ACUTE)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1015, N'098.15', N'GONOCOCCAL CERVICITIS (ACUTE)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1016, N'098.16', N'GONOCOCCAL ENDOMETRITIS (ACUTE)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1017, N'098.17', N'GONOCOCCAL SALPINGITIS, SPECIFIED AS ACUTE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1018, N'098.19', N'OTHER GONOCOCCAL INFECTION (ACUTE) OF UPPER GENITOURINARY TRACT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1019, N'098.2', N'GONOCOCCAL INFECTION, CHRONIC, OF LOWER GENITOURINARY TRACT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1020, N'098.30', N'CHRONIC GONOCOCCAL INFECTION OF UPPER GENITOURINARY TRACT, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1021, N'098.31', N'GONOCOCCAL CYSTITIS, CHRONIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1022, N'098.32', N'GONOCOCCAL PROSTATITIS, CHRONIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1023, N'098.33', N'GONOCOCCAL EPIDIDYMO-ORCHITIS, CHRONIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1024, N'098.34', N'GONOCOCCAL SEMINAL VESICULITIS, CHRONIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1025, N'098.35', N'GONOCOCCAL CERVICITIS, CHRONIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1026, N'098.36', N'GONOCOCCAL ENDOMETRITIS, CHRONIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1027, N'098.37', N'GONOCOCCAL SALPINGITIS (CHRONIC)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1028, N'098.39', N'OTHER CHRONIC GONOCOCCAL INFECTION OF UPPER GENITOURINARY TRACT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1029, N'098.40', N'GONOCOCCAL CONJUNCTIVITIS (NEONATORUM)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1030, N'098.41', N'GONOCOCCAL IRIDOCYCLITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1031, N'098.42', N'GONOCOCCAL ENDOPHTHALMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1032, N'098.43', N'GONOCOCCAL KERATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1033, N'098.49', N'OTHER GONOCOCCAL INFECTION OF EYE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1034, N'098.50', N'GONOCOCCAL ARTHRITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1035, N'098.51', N'GONOCOCCAL SYNOVITIS AND TENOSYNOVITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1036, N'098.52', N'GONOCOCCAL BURSITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1037, N'098.53', N'GONOCOCCAL SPONDYLITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1038, N'098.59', N'OTHER GONOCOCCAL INFECTION OF JOINT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1039, N'098.6', N'GONOCOCCAL INFECTION OF PHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1040, N'098.7', N'GONOCOCCAL INFECTION OF ANUS AND RECTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1041, N'098.81', N'GONOCOCCAL KERATOSIS (BLENNORRHAGICA)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1042, N'098.82', N'GONOCOCCAL MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1043, N'098.83', N'GONOCOCCAL PERICARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1044, N'098.84', N'GONOCOCCAL ENDOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1045, N'098.85', N'OTHER GONOCOCCAL HEART DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1046, N'098.86', N'GONOCOCCAL PERITONITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1047, N'098.89', N'GONOCOCCAL INFECTION OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1048, N'099.0', N'CHANCROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1049, N'099.1', N'LYMPHOGRANULOMA VENEREUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1050, N'099.2', N'GRANULOMA INGUINALE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1051, N'099.3', N'REITER''S DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1052, N'099.40', N'OTHER NONGONOCOCCAL URETHRITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1053, N'099.41', N'OTHER NONGONOCOCCAL URETHRITIS, CHLAMYDIA TRACHOMATIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1054, N'099.49', N'OTHER NONGONOCOCCAL URETHRITIS, OTHER SPECIFIED ORGANISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1055, N'099.50', N'OTHER VENEREAL DISEASES DUE TO CHLAMYDIA TRACHOMATIS, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1056, N'099.51', N'OTHER VENEREAL DISEASES DUE TO CHLAMYDIA TRACHOMATIS, PHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1057, N'099.52', N'OTHER VENEREAL DISEASES DUE TO CHLAMYDIA TRACHOMATIS, ANUS AND RECTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1058, N'099.53', N'OTHER VENEREAL DISEASES DUE TO CHLAMYDIA TRACHOMATIS, LOWER GENITOURINARY SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1059, N'099.54', N'OTHER VENEREAL DISEASES DUE TO CHLAMYDIA TRACHOMATIS, OTHER GENITOURINARY SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1060, N'099.55', N'OTHER VENEREAL DISEASES DUE TO CHLAMYDIA TRACHOMATIS, UNSPECIFIED GENITOURINARY SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1061, N'099.56', N'OTHER VENEREAL DISEASES DUE TO CHLAMYDIA TRACHOMATIS, PERITONEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1062, N'099.59', N'OTHER VENEREAL DISEASES DUE TO CHLAMYDIA TRACHOMATIS, OTHER SPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1063, N'099.8', N'OTHER SPECIFIED VENEREAL DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1064, N'099.9', N'VENEREAL DISEASE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1065, N'100.0', N'LEPTOSPIROSIS ICTEROHEMORRHAGICA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1066, N'100.81', N'LEPTOSPIRAL MENINGITIS (ASEPTIC)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1067, N'100.89', N'OTHER SPECIFIED LEPTOSPIRAL INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1068, N'100.9', N'LEPTOSPIROSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1069, N'101.', N'VINCENT''S ANGINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1070, N'102.0', N'INITIAL LESIONS OF YAWS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1071, N'102.1', N'MULTIPLE PAPILLOMATA DUE TO YAWS AND WET CRAB YAWS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1072, N'102.2', N'OTHER EARLY SKIN LESIONS OF YAWS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1073, N'102.3', N'HYPERKERATOSIS DUE TO YAWS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1074, N'102.4', N'GUMMATA AND ULCERS DUE TO YAWS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1075, N'102.5', N'GANGOSA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1076, N'102.6', N'BONE AND JOINT LESIONS DUE TO YAWS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1077, N'102.7', N'OTHER MANIFESTATIONS OF YAWS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1078, N'102.8', N'LATENT YAWS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1079, N'102.9', N'YAWS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1080, N'103.0', N'PRIMARY LESIONS OF PINTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1081, N'103.1', N'INTERMEDIATE LESIONS OF PINTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1082, N'103.2', N'LATE LESIONS OF PINTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1083, N'103.3', N'MIXED LESIONS OF PINTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1084, N'103.9', N'PINTA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1085, N'104.0', N'NONVENEREAL ENDEMIC SYPHILIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1086, N'104.8', N'OTHER SPECIFIED SPIROCHETAL INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1087, N'104.9', N'SPIROCHETAL INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1088, N'110.0', N'DERMATOPHYTOSIS OF SCALP AND BEARD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1089, N'110.1', N'DERMATOPHYTOSIS OF NAIL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1090, N'110.2', N'DERMATOPHYTOSIS OF HAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1091, N'110.3', N'DERMATOPHYTOSIS OF GROIN AND PERIANAL AREA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1092, N'110.4', N'DERMATOPHYTOSIS OF FOOT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1093, N'110.5', N'DERMATOPHYTOSIS OF THE BODY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1094, N'110.6', N'DEEP SEATED DERMATOPHYTOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1095, N'110.8', N'DERMATOPHYTOSIS OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1096, N'110.9', N'DERMATOPHYTOSIS OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1097, N'111.0', N'PITYRIASIS VERSICOLOR', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1098, N'111.1', N'TINEA NIGRA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1099, N'111.2', N'TINEA BLANCA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1100, N'111.3', N'BLACK PIEDRA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1101, N'111.8', N'OTHER SPECIFIED DERMATOMYCOSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1102, N'111.9', N'DERMATOMYCOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1103, N'112.0', N'CANDIDIASIS OF MOUTH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1104, N'112.1', N'CANDIDIASIS OF VULVA AND VAGINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1105, N'112.2', N'CANDIDIASIS OF OTHER UROGENITAL SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1106, N'112.3', N'CANDIDIASIS OF SKIN AND NAILS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1107, N'112.4', N'CANDIDIASIS OF LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1108, N'112.5', N'DISSEMINATED CANDIDIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1109, N'112.81', N'CANDIDAL ENDOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1110, N'112.82', N'CANDIDAL OTITIS EXTERNA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1100 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1111, N'112.83', N'CANDIDAL MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1112, N'112.84', N'CANDIDAL ESOPHAGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1113, N'112.85', N'CANDIDAL ENTERITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1114, N'112.89', N'OTHER CANDIDIASIS OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1115, N'112.9', N'CANDIDIASIS OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1116, N'114.0', N'PRIMARY COCCIDIOIDOMYCOSIS (PULMONARY)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1117, N'114.1', N'PRIMARY EXTRAPULMONARY COCCIDIOIDOMYCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1118, N'114.2', N'COCCIDIOIDAL MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1119, N'114.3', N'OTHER FORMS OF PROGRESSIVE COCCIDIOIDOMYCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1120, N'114.4', N'CHRONIC PULMONARY COCCIDIOIDOMYCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1121, N'114.5', N'PULMONARY COCCIDIOIDOMYCOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1122, N'114.9', N'COCCIDIOIDOMYCOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1123, N'115.00', N'INFECTION BY HISTOPLASMA CAPSULATUM, WITHOUT MENTION OF MANIFESTATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1124, N'115.01', N'INFECTION BY HISTOPLASMA CAPSULATUM, MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1125, N'115.02', N'INFECTION BY HISTOPLASMA CAPSULATUM, RETINITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1126, N'115.03', N'INFECTION BY HISTOPLASMA CAPSULATUM, PERICARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1127, N'115.04', N'INFECTION BY HISTOPLASMA CAPSULATUM, ENDOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1128, N'115.05', N'INFECTION BY HISTOPLASMA CAPSULATUM, PNEUMONIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1129, N'115.09', N'INFECTION BY HISTOPLASMA CAPSULATUM, OTHER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1130, N'115.10', N'INFECTION BY HISTOPLASMA DUBOISII, WITHOUT MENTION OF MANIFESTATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1131, N'115.11', N'INFECTION BY HISTOPLASMA DUBOISII, MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1132, N'115.12', N'INFECTION BY HISTOPLASMA DUBOISII, RETINITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1133, N'115.13', N'INFECTION BY HISTOPLASMA DUBOISII, PERICARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1134, N'115.14', N'INFECTION BY HISTOPLASMA DUBOISII, ENDOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1135, N'115.15', N'INFECTION BY HISTOPLASMA DUBOISII, PNEUMONIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1136, N'115.19', N'INFECTION BY HISTOPLASMA DUBOISII, OTHER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1137, N'115.90', N'HISTOPLASMOSIS, UNSPECIFIED, WITHOUT MENTION OF MANIFESTATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1138, N'115.91', N'HISTOPLASMOSIS, UNSPECIFIED, MENINGITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1139, N'115.92', N'HISTOPLASMOSIS, UNSPECIFIED, RETINITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1140, N'115.93', N'HISTOPLASMOSIS, UNSPECIFIED, PERICARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1141, N'115.94', N'HISTOPLASMOSIS, UNSPECIFIED, ENDOCARDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1142, N'115.95', N'HISTOPLASMOSIS, UNSPECIFIED, PNEUMONIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1143, N'115.99', N'HISTOPLASMOSIS, UNSPECIFIED, OTHER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1144, N'116.0', N'BLASTOMYCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1145, N'116.1', N'PARACOCCIDIOIDOMYCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1146, N'116.2', N'LOBOMYCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1147, N'117.0', N'RHINOSPORIDIOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1148, N'117.1', N'SPOROTRICHOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1149, N'117.2', N'CHROMOBLASTOMYCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1150, N'117.3', N'ASPERGILLOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1151, N'117.4', N'MYCOTIC MYCETOMAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1152, N'117.5', N'CRYPTOCOCCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1153, N'117.6', N'ALLESCHERIOSIS [PETRIELLIDOSIS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1154, N'117.7', N'ZYGOMYCOSIS [PHYCOMYCOSIS OR MUCORMYCOSIS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1155, N'117.8', N'INFECTION BY DEMATIACIOUS FUNGI [PHAEHYPHOMYCOSIS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1156, N'117.9', N'OTHER AND UNSPECIFIED MYCOSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1157, N'118.', N'OPPORTUNISTIC MYCOSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1158, N'120.0', N'SCHISTOSOMIASIS DUE TO SCHISTOSOMA HAEMATOBIUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1159, N'120.1', N'SCHISTOSOMIASIS DUE TO SCHISTOSOMA MANSONI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1160, N'120.2', N'SCHISTOSOMIASIS DUE TO SCHISTOSOMA JAPONICUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1161, N'120.3', N'CUTANEOUS SCHISTOSOMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1162, N'120.8', N'OTHER SPECIFIED SCHISTOSOMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1163, N'120.9', N'SCHISTOSOMIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1164, N'121.0', N'OPISTHORCHIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1165, N'121.1', N'CLONORCHIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1166, N'121.2', N'PARAGONIMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1167, N'121.3', N'FASCIOLIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1168, N'121.4', N'FASCIOLOPSIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1169, N'121.5', N'METAGONIMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1170, N'121.6', N'HETEROPHYIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1171, N'121.8', N'OTHER SPECIFIED TREMATODE INFECTIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1172, N'121.9', N'TREMATODE INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1173, N'122.0', N'ECHINOCOCCUS GRANULOSUS INFECTION OF LIVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1174, N'122.1', N'ECHINOCOCCUS GRANULOSUS INFECTION OF LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1175, N'122.2', N'ECHINOCOCCUS GRANULOSUS INFECTION OF THYROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1176, N'122.3', N'ECHINOCOCCUS GRANULOSUS INFECTION, OTHER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1177, N'122.4', N'ECHINOCOCCUS GRANULOSUS INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1178, N'122.5', N'ECHINOCOCCUS MULTILOCULARIS INFECTION OF LIVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1179, N'122.6', N'ECHINOCOCCUS MULTILOCULARIS INFECTION, OTHER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1180, N'122.7', N'ECHINOCOCCUS MULTILOCULARIS INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1181, N'122.8', N'ECHINOCOCCOSIS, UNSPECIFIED, OF LIVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1182, N'122.9', N'ECHINOCOCCOSIS, OTHER AND UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1183, N'123.0', N'TAENIA SOLIUM INFECTION, INTESTINAL FORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1184, N'123.1', N'CYSTICERCOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1185, N'123.2', N'TAENIA SAGINATA INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1186, N'123.3', N'TAENIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1187, N'123.4', N'DIPHYLLOBOTHRIASIS, INTESTINAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1188, N'123.5', N'SPARGANOSIS [LARVAL DIPHYLLOBOTHRIASIS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1189, N'123.6', N'HYMENOLEPIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1190, N'123.8', N'OTHER SPECIFIED CESTODE INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1191, N'123.9', N'CESTODE INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1192, N'124.', N'TRICHINOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1193, N'125.0', N'BANCROFTIAN FILARIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1194, N'125.1', N'MALAYAN FILARIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1195, N'125.2', N'LOIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1196, N'125.3', N'ONCHOCERCIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1197, N'125.4', N'DIPETALONEMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1198, N'125.5', N'MANSONELLA OZZARDI INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1199, N'125.6', N'OTHER SPECIFIED FILARIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1200, N'125.7', N'DRACONTIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1201, N'125.9', N'UNSPECIFIED FILARIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1202, N'126.0', N'ANCYLOSTOMIASIS DUE TO ANCYLOSTOMA DUODENALE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1203, N'126.1', N'NECATORIASIS DUE TO NECATOR AMERICANUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1204, N'126.2', N'ANCYLOSTOMIASIS DUE TO ANCYLOSTOMA BRAZILIENSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1205, N'126.3', N'ANCYLOSTOMIASIS DUE TO ANCYLOSTOMA CEYLANICUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1206, N'126.8', N'OTHER SPECIFIED ANCYLOSTOMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1207, N'126.9', N'ANCYLOSTOMIASIS AND NECATORIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1208, N'127.0', N'ASCARIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1209, N'127.1', N'ANISAKIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1210, N'127.2', N'STRONGYLOIDIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1211, N'127.3', N'TRICHURIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1200 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1212, N'127.4', N'ENTEROBIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1213, N'127.5', N'CAPILLARIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1214, N'127.6', N'TRICHOSTRONGYLIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1215, N'127.7', N'OTHER SPECIFIED INTESTINAL HELMINTHIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1216, N'127.8', N'MIXED INTESTINAL HELMINTHIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1217, N'127.9', N'INTESTINAL HELMINTHIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1218, N'128.0', N'TOXOCARIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1219, N'128.1', N'GNATHOSTOMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1220, N'128.8', N'OTHER SPECIFIED HELMINTHIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1221, N'128.9', N'HELMINTH INFECTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1222, N'129.', N'INTESTINAL PARASITISM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1223, N'130.0', N'MENINGOENCEPHALITIS DUE TO TOXOPLASMOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1224, N'130.1', N'CONJUNCTIVITIS DUE TO TOXOPLASMOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1225, N'130.2', N'CHORIORETINITIS DUE TO TOXOPLASMOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1226, N'130.3', N'MYOCARDITIS DUE TO TOXOPLASMOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1227, N'130.4', N'PNEUMONITIS DUE TO TOXOPLASMOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1228, N'130.5', N'HEPATITIS DUE TO TOXOPLASMOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1229, N'130.7', N'TOXOPLASMOSIS OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1230, N'130.8', N'MULTISYSTEMIC DISSEMINATED TOXOPLASMOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1231, N'130.9', N'TOXOPLASMOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1232, N'131.00', N'UROGENITAL TRICHOMONIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1233, N'131.01', N'TRICHOMONAL VULVOVAGINITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1234, N'131.02', N'TRICHOMONAL URETHRITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1235, N'131.03', N'TRICHOMONAL PROSTATITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1236, N'131.09', N'OTHER UROGENITAL TRICHOMONIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1237, N'131.8', N'TRICHOMONIASIS OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1238, N'131.9', N'TRICHOMONIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1239, N'132.0', N'PEDICULUS CAPITIS [HEAD LOUSE]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1240, N'132.1', N'PEDICULUS CORPORIS [BODY LOUSE]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1241, N'132.2', N'PHTHIRUS PUBIS [PUBIC LOUSE]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1242, N'132.3', N'MIXED PEDICULOSIS INFESTATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1243, N'132.9', N'PEDICULOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1244, N'133.0', N'SCABIES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1245, N'133.8', N'OTHER ACARIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1246, N'133.9', N'ACARIASIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1247, N'134.0', N'MYIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1248, N'134.1', N'OTHER ARTHROPOD INFESTATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1249, N'134.2', N'HIRUDINIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1250, N'134.8', N'OTHER SPECIFIED INFESTATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1251, N'134.9', N'INFESTATION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1252, N'135.', N'SARCOIDOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1253, N'136.0', N'AINHUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1254, N'136.1', N'BEHCET''S SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1255, N'136.21', N'SPECIFIC INFECTION DUE TO ACANTHAMOEBA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1256, N'136.29', N'OTHER SPECIFIC INFECTIONS BY FREE-LIVING AMEBAE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1257, N'136.3', N'PNEUMOCYSTOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1258, N'136.4', N'PSOROSPERMIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1259, N'136.5', N'SARCOSPORIDIOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1260, N'136.8', N'OTHER SPECIFIED INFECTIOUS AND PARASITIC DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1261, N'136.9', N'UNSPECIFIED INFECTIOUS AND PARASITIC DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1262, N'137.0', N'LATE EFFECTS OF RESPIRATORY OR UNSPECIFIED TUBERCULOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1263, N'137.1', N'LATE EFFECTS OF CENTRAL NERVOUS SYSTEM TUBERCULOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1264, N'137.2', N'LATE EFFECTS OF GENITOURINARY TUBERCULOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1265, N'137.3', N'LATE EFFECTS OF TUBERCULOSIS OF BONES AND JOINTS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1266, N'137.4', N'LATE EFFECTS OF TUBERCULOSIS OF OTHER SPECIFIED ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1267, N'138.', N'LATE EFFECTS OF ACUTE POLIOMYELITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1268, N'139.0', N'LATE EFFECTS OF VIRAL ENCEPHALITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1269, N'139.1', N'LATE EFFECTS OF TRACHOMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1270, N'139.8', N'LATE EFFECTS OF OTHER AND UNSPECIFIED INFECTIOUS AND PARASITIC DISEASES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1271, N'140.0', N'MALIGNANT NEOPLASM OF UPPER LIP, VERMILION BORDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1272, N'140.1', N'MALIGNANT NEOPLASM OF LOWER LIP, VERMILION BORDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1273, N'140.3', N'MALIGNANT NEOPLASM OF UPPER LIP, INNER ASPECT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1274, N'140.4', N'MALIGNANT NEOPLASM OF LOWER LIP, INNER ASPECT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1275, N'140.5', N'MALIGNANT NEOPLASM OF LIP, UNSPECIFIED, INNER ASPECT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1276, N'140.6', N'MALIGNANT NEOPLASM OF COMMISSURE OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1277, N'140.8', N'MALIGNANT NEOPLASM OF OTHER SITES OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1278, N'140.9', N'MALIGNANT NEOPLASM OF LIP, UNSPECIFIED, VERMILION BORDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1279, N'141.0', N'MALIGNANT NEOPLASM OF BASE OF TONGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1280, N'141.1', N'MALIGNANT NEOPLASM OF DORSAL SURFACE OF TONGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1281, N'141.2', N'MALIGNANT NEOPLASM OF TIP AND LATERAL BORDER OF TONGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1282, N'141.3', N'MALIGNANT NEOPLASM OF VENTRAL SURFACE OF TONGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1283, N'141.4', N'MALIGNANT NEOPLASM OF ANTERIOR TWO-THIRDS OF TONGUE, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1284, N'141.5', N'MALIGNANT NEOPLASM OF JUNCTIONAL ZONE OF TONGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1285, N'141.6', N'MALIGNANT NEOPLASM OF LINGUAL TONSIL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1286, N'141.8', N'MALIGNANT NEOPLASM OF OTHER SITES OF TONGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1287, N'141.9', N'MALIGNANT NEOPLASM OF TONGUE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1288, N'142.0', N'MALIGNANT NEOPLASM OF PAROTID GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1289, N'142.1', N'MALIGNANT NEOPLASM OF SUBMANDIBULAR GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1290, N'142.2', N'MALIGNANT NEOPLASM OF SUBLINGUAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1291, N'142.8', N'MALIGNANT NEOPLASM OF OTHER MAJOR SALIVARY GLANDS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1292, N'142.9', N'MALIGNANT NEOPLASM OF SALIVARY GLAND, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1293, N'143.0', N'MALIGNANT NEOPLASM OF UPPER GUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1294, N'143.1', N'MALIGNANT NEOPLASM OF LOWER GUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1295, N'143.8', N'MALIGNANT NEOPLASM OF OTHER SITES OF GUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1296, N'143.9', N'MALIGNANT NEOPLASM OF GUM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1297, N'144.0', N'MALIGNANT NEOPLASM OF ANTERIOR PORTION OF FLOOR OF MOUTH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1298, N'144.1', N'MALIGNANT NEOPLASM OF LATERAL PORTION OF FLOOR OF MOUTH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1299, N'144.8', N'MALIGNANT NEOPLASM OF OTHER SITES OF FLOOR OF MOUTH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1300, N'144.9', N'MALIGNANT NEOPLASM OF FLOOR OF MOUTH, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1301, N'145.0', N'MALIGNANT NEOPLASM OF CHEEK MUCOSA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1302, N'145.1', N'MALIGNANT NEOPLASM OF VESTIBULE OF MOUTH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1303, N'145.2', N'MALIGNANT NEOPLASM OF HARD PALATE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1304, N'145.3', N'MALIGNANT NEOPLASM OF SOFT PALATE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1305, N'145.4', N'MALIGNANT NEOPLASM OF UVULA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1306, N'145.5', N'MALIGNANT NEOPLASM OF PALATE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1307, N'145.6', N'MALIGNANT NEOPLASM OF RETROMOLAR AREA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1308, N'145.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED PARTS OF MOUTH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1309, N'145.9', N'MALIGNANT NEOPLASM OF MOUTH, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1310, N'146.0', N'MALIGNANT NEOPLASM OF TONSIL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1311, N'146.1', N'MALIGNANT NEOPLASM OF TONSILLAR FOSSA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1312, N'146.2', N'MALIGNANT NEOPLASM OF TONSILLAR PILLARS (ANTERIOR) (POSTERIOR)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1300 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1313, N'146.3', N'MALIGNANT NEOPLASM OF VALLECULA EPIGLOTTICA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1314, N'146.4', N'MALIGNANT NEOPLASM OF ANTERIOR ASPECT OF EPIGLOTTIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1315, N'146.5', N'MALIGNANT NEOPLASM OF JUNCTIONAL REGION OF OROPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1316, N'146.6', N'MALIGNANT NEOPLASM OF LATERAL WALL OF OROPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1317, N'146.7', N'MALIGNANT NEOPLASM OF POSTERIOR WALL OF OROPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1318, N'146.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF OROPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1319, N'146.9', N'MALIGNANT NEOPLASM OF OROPHARYNX, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1320, N'147.0', N'MALIGNANT NEOPLASM OF SUPERIOR WALL OF NASOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1321, N'147.1', N'MALIGNANT NEOPLASM OF POSTERIOR WALL OF NASOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1322, N'147.2', N'MALIGNANT NEOPLASM OF LATERAL WALL OF NASOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1323, N'147.3', N'MALIGNANT NEOPLASM OF ANTERIOR WALL OF NASOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1324, N'147.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF NASOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1325, N'147.9', N'MALIGNANT NEOPLASM OF NASOPHARYNX, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1326, N'148.0', N'MALIGNANT NEOPLASM OF POSTCRICOID REGION OF HYPOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1327, N'148.1', N'MALIGNANT NEOPLASM OF PYRIFORM SINUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1328, N'148.2', N'MALIGNANT NEOPLASM OF ARYEPIGLOTTIC FOLD, HYPOPHARYNGEAL ASPECT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1329, N'148.3', N'MALIGNANT NEOPLASM OF POSTERIOR HYPOPHARYNGEAL WALL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1330, N'148.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF HYPOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1331, N'148.9', N'MALIGNANT NEOPLASM OF HYPOPHARYNX, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1332, N'149.0', N'MALIGNANT NEOPLASM OF PHARYNX, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1333, N'149.1', N'MALIGNANT NEOPLASM OF WALDEYER''S RING', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1334, N'149.8', N'MALIGNANT NEOPLASM OF OTHER SITES WITHIN THE LIP AND ORAL CAVITY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1335, N'149.9', N'MALIGNANT NEOPLASM OF ILL-DEFINED SITES WITHIN THE LIP AND ORAL CAVITY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1336, N'150.0', N'MALIGNANT NEOPLASM OF CERVICAL ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1337, N'150.1', N'MALIGNANT NEOPLASM OF THORACIC ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1338, N'150.2', N'MALIGNANT NEOPLASM OF ABDOMINAL ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1339, N'150.3', N'MALIGNANT NEOPLASM OF UPPER THIRD OF ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1340, N'150.4', N'MALIGNANT NEOPLASM OF MIDDLE THIRD OF ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1341, N'150.5', N'MALIGNANT NEOPLASM OF LOWER THIRD OF ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1342, N'150.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED PART OF ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1343, N'150.9', N'MALIGNANT NEOPLASM OF ESOPHAGUS, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1344, N'151.0', N'MALIGNANT NEOPLASM OF CARDIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1345, N'151.1', N'MALIGNANT NEOPLASM OF PYLORUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1346, N'151.2', N'MALIGNANT NEOPLASM OF PYLORIC ANTRUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1347, N'151.3', N'MALIGNANT NEOPLASM OF FUNDUS OF STOMACH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1348, N'151.4', N'MALIGNANT NEOPLASM OF BODY OF STOMACH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1349, N'151.5', N'MALIGNANT NEOPLASM OF LESSER CURVATURE OF STOMACH, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1350, N'151.6', N'MALIGNANT NEOPLASM OF GREATER CURVATURE OF STOMACH, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1351, N'151.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF STOMACH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1352, N'151.9', N'MALIGNANT NEOPLASM OF STOMACH, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1353, N'152.0', N'MALIGNANT NEOPLASM OF DUODENUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1354, N'152.1', N'MALIGNANT NEOPLASM OF JEJUNUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1355, N'152.2', N'MALIGNANT NEOPLASM OF ILEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1356, N'152.3', N'MALIGNANT NEOPLASM OF MECKEL''S DIVERTICULUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1357, N'152.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF SMALL INTESTINE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1358, N'152.9', N'MALIGNANT NEOPLASM OF SMALL INTESTINE, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1359, N'153.0', N'MALIGNANT NEOPLASM OF HEPATIC FLEXURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1360, N'153.1', N'MALIGNANT NEOPLASM OF TRANSVERSE COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1361, N'153.2', N'MALIGNANT NEOPLASM OF DESCENDING COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1362, N'153.3', N'MALIGNANT NEOPLASM OF SIGMOID COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1363, N'153.4', N'MALIGNANT NEOPLASM OF CECUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1364, N'153.5', N'MALIGNANT NEOPLASM OF APPENDIX VERMIFORMIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1365, N'153.6', N'MALIGNANT NEOPLASM OF ASCENDING COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1366, N'153.7', N'MALIGNANT NEOPLASM OF SPLENIC FLEXURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1367, N'153.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF LARGE INTESTINE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1368, N'153.9', N'MALIGNANT NEOPLASM OF COLON, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1369, N'154.0', N'MALIGNANT NEOPLASM OF RECTOSIGMOID JUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1370, N'154.1', N'MALIGNANT NEOPLASM OF RECTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1371, N'154.2', N'MALIGNANT NEOPLASM OF ANAL CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1372, N'154.3', N'MALIGNANT NEOPLASM OF ANUS, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1373, N'154.8', N'MALIGNANT NEOPLASM OF OTHER SITES OF RECTUM, RECTOSIGMOID JUNCTION, AND ANUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1374, N'155.0', N'MALIGNANT NEOPLASM OF LIVER, PRIMARY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1375, N'155.1', N'MALIGNANT NEOPLASM OF INTRAHEPATIC BILE DUCTS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1376, N'155.2', N'MALIGNANT NEOPLASM OF LIVER, NOT SPECIFIED AS PRIMARY OR SECONDARY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1377, N'156.0', N'MALIGNANT NEOPLASM OF GALLBLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1378, N'156.1', N'MALIGNANT NEOPLASM OF EXTRAHEPATIC BILE DUCTS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1379, N'156.2', N'MALIGNANT NEOPLASM OF AMPULLA OF VATER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1380, N'156.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF GALLBLADDER AND EXTRAHEPATIC BILE DUCTS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1381, N'156.9', N'MALIGNANT NEOPLASM OF BILIARY TRACT, PART UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1382, N'157.0', N'MALIGNANT NEOPLASM OF HEAD OF PANCREAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1383, N'157.1', N'MALIGNANT NEOPLASM OF BODY OF PANCREAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1384, N'157.2', N'MALIGNANT NEOPLASM OF TAIL OF PANCREAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1385, N'157.3', N'MALIGNANT NEOPLASM OF PANCREATIC DUCT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1386, N'157.4', N'MALIGNANT NEOPLASM OF ISLETS OF LANGERHANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1387, N'157.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF PANCREAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1388, N'157.9', N'MALIGNANT NEOPLASM OF PANCREAS, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1389, N'158.0', N'MALIGNANT NEOPLASM OF RETROPERITONEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1390, N'158.8', N'MALIGNANT NEOPLASM OF SPECIFIED PARTS OF PERITONEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1391, N'158.9', N'MALIGNANT NEOPLASM OF PERITONEUM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1392, N'159.0', N'MALIGNANT NEOPLASM OF INTESTINAL TRACT, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1393, N'159.1', N'MALIGNANT NEOPLASM OF SPLEEN, NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1394, N'159.8', N'MALIGNANT NEOPLASM OF OTHER SITES OF DIGESTIVE SYSTEM AND INTRA-ABDOMINAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1395, N'159.9', N'MALIGNANT NEOPLASM OF ILL-DEFINED SITES WITHIN THE DIGESTIVE ORGANS AND PERITONEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1396, N'160.0', N'MALIGNANT NEOPLASM OF NASAL CAVITIES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1397, N'160.1', N'MALIGNANT NEOPLASM OF AUDITORY TUBE, MIDDLE EAR, AND MASTOID AIR CELLS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1398, N'160.2', N'MALIGNANT NEOPLASM OF MAXILLARY SINUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1399, N'160.3', N'MALIGNANT NEOPLASM OF ETHMOIDAL SINUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1400, N'160.4', N'MALIGNANT NEOPLASM OF FRONTAL SINUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1401, N'160.5', N'MALIGNANT NEOPLASM OF SPHENOIDAL SINUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1402, N'160.8', N'MALIGNANT NEOPLASM OF OTHER ACCESSORY SINUSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1403, N'160.9', N'MALIGNANT NEOPLASM OF ACCESSORY SINUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1404, N'161.0', N'MALIGNANT NEOPLASM OF GLOTTIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1405, N'161.1', N'MALIGNANT NEOPLASM OF SUPRAGLOTTIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1406, N'161.2', N'MALIGNANT NEOPLASM OF SUBGLOTTIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1407, N'161.3', N'MALIGNANT NEOPLASM OF LARYNGEAL CARTILAGES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1408, N'161.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF LARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1409, N'161.9', N'MALIGNANT NEOPLASM OF LARYNX, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1410, N'162.0', N'MALIGNANT NEOPLASM OF TRACHEA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1411, N'162.2', N'MALIGNANT NEOPLASM OF MAIN BRONCHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1412, N'162.3', N'MALIGNANT NEOPLASM OF UPPER LOBE, BRONCHUS OR LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1413, N'162.4', N'MALIGNANT NEOPLASM OF MIDDLE LOBE, BRONCHUS OR LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1400 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1414, N'162.5', N'MALIGNANT NEOPLASM OF LOWER LOBE, BRONCHUS OR LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1415, N'162.8', N'MALIGNANT NEOPLASM OF OTHER PARTS OF BRONCHUS OR LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1416, N'162.9', N'MALIGNANT NEOPLASM OF BRONCHUS AND LUNG, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1417, N'163.0', N'MALIGNANT NEOPLASM OF PARIETAL PLEURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1418, N'163.1', N'MALIGNANT NEOPLASM OF VISCERAL PLEURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1419, N'163.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF PLEURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1420, N'163.9', N'MALIGNANT NEOPLASM OF PLEURA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1421, N'164.0', N'MALIGNANT NEOPLASM OF THYMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1422, N'164.1', N'MALIGNANT NEOPLASM OF HEART', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1423, N'164.2', N'MALIGNANT NEOPLASM OF ANTERIOR MEDIASTINUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1424, N'164.3', N'MALIGNANT NEOPLASM OF POSTERIOR MEDIASTINUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1425, N'164.8', N'MALIGNANT NEOPLASM OF OTHER PARTS OF MEDIASTINUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1426, N'164.9', N'MALIGNANT NEOPLASM OF MEDIASTINUM, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1427, N'165.0', N'MALIGNANT NEOPLASM OF UPPER RESPIRATORY TRACT, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1428, N'165.8', N'MALIGNANT NEOPLASM OF OTHER SITES WITHIN THE RESPIRATORY SYSTEM AND INTRATHORACIC ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1429, N'165.9', N'MALIGNANT NEOPLASM OF ILL-DEFINED SITES WITHIN THE RESPIRATORY SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1430, N'170.0', N'MALIGNANT NEOPLASM OF BONES OF SKULL AND FACE, EXCEPT MANDIBLE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1431, N'170.1', N'MALIGNANT NEOPLASM OF MANDIBLE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1432, N'170.2', N'MALIGNANT NEOPLASM OF VERTEBRAL COLUMN, EXCLUDING SACRUM AND COCCYX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1433, N'170.3', N'MALIGNANT NEOPLASM OF RIBS, STERNUM, AND CLAVICLE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1434, N'170.4', N'MALIGNANT NEOPLASM OF SCAPULA AND LONG BONES OF UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1435, N'170.5', N'MALIGNANT NEOPLASM OF SHORT BONES OF UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1436, N'170.6', N'MALIGNANT NEOPLASM OF PELVIC BONES, SACRUM, AND COCCYX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1437, N'170.7', N'MALIGNANT NEOPLASM OF LONG BONES OF LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1438, N'170.8', N'MALIGNANT NEOPLASM OF SHORT BONES OF LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1439, N'170.9', N'MALIGNANT NEOPLASM OF BONE AND ARTICULAR CARTILAGE, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1440, N'171.0', N'MALIGNANT NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1441, N'171.2', N'MALIGNANT NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1442, N'171.3', N'MALIGNANT NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1443, N'171.4', N'MALIGNANT NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF THORAX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1444, N'171.5', N'MALIGNANT NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF ABDOMEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1445, N'171.6', N'MALIGNANT NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF PELVIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1446, N'171.7', N'MALIGNANT NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF TRUNK, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1447, N'171.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF CONNECTIVE AND OTHER SOFT TISSUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1448, N'171.9', N'MALIGNANT NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1449, N'172.0', N'MALIGNANT MELANOMA OF SKIN OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1450, N'172.1', N'MALIGNANT MELANOMA OF SKIN OF EYELID, INCLUDING CANTHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1451, N'172.2', N'MALIGNANT MELANOMA OF SKIN OF EAR AND EXTERNAL AUDITORY CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1452, N'172.3', N'MALIGNANT MELANOMA OF SKIN OF OTHER AND UNSPECIFIED PARTS OF FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1453, N'172.4', N'MALIGNANT MELANOMA OF SKIN OF SCALP AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1454, N'172.5', N'MALIGNANT MELANOMA OF SKIN OF TRUNK, EXCEPT SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1455, N'172.6', N'MALIGNANT MELANOMA OF SKIN OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1456, N'172.7', N'MALIGNANT MELANOMA OF SKIN OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1457, N'172.8', N'MALIGNANT MELANOMA OF OTHER SPECIFIED SITES OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1458, N'172.9', N'MELANOMA OF SKIN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1459, N'173.00', N'UNSPECIFIED MALIGNANT NEOPLASM OF SKIN OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1460, N'173.01', N'BASAL CELL CARCINOMA OF SKIN OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1461, N'173.02', N'SQUAMOUS CELL CARCINOMA OF SKIN OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1462, N'173.09', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF SKIN OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1463, N'173.10', N'UNSPECIFIED MALIGNANT NEOPLASM OF EYELID, INCLUDING CANTHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1464, N'173.11', N'BASAL CELL CARCINOMA OF EYELID, INCLUDING CANTHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1465, N'173.12', N'SQUAMOUS CELL CARCINOMA OF EYELID, INCLUDING CANTHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1466, N'173.19', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF EYELID, INCLUDING CANTHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1467, N'173.20', N'UNSPECIFIED MALIGNANT NEOPLASM OF SKIN OF EAR AND EXTERNAL AUDITORY CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1468, N'173.21', N'BASAL CELL CARCINOMA OF SKIN OF EAR AND EXTERNAL AUDITORY CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1469, N'173.22', N'SQUAMOUS CELL CARCINOMA OF SKIN OF EAR AND EXTERNAL AUDITORY CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1470, N'173.29', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF SKIN OF EAR AND EXTERNAL AUDITORY CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1471, N'173.30', N'UNSPECIFIED MALIGNANT NEOPLASM OF SKIN OF OTHER AND UNSPECIFIED PARTS OF FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1472, N'173.31', N'BASAL CELL CARCINOMA OF SKIN OF OTHER AND UNSPECIFIED PARTS OF FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1473, N'173.32', N'SQUAMOUS CELL CARCINOMA OF SKIN OF OTHER AND UNSPECIFIED PARTS OF FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1474, N'173.39', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF SKIN OF OTHER AND UNSPECIFIED PARTS OF FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1475, N'173.40', N'UNSPECIFIED MALIGNANT NEOPLASM OF SCALP AND SKIN OF NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1476, N'173.41', N'BASAL CELL CARCINOMA OF SCALP AND SKIN OF NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1477, N'173.42', N'SQUAMOUS CELL CARCINOMA OF SCALP AND SKIN OF NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1478, N'173.49', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF SCALP AND SKIN OF NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1479, N'173.50', N'UNSPECIFIED MALIGNANT NEOPLASM OF SKIN OF TRUNK, EXCEPT SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1480, N'173.51', N'BASAL CELL CARCINOMA OF SKIN OF TRUNK, EXCEPT SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1481, N'173.52', N'SQUAMOUS CELL CARCINOMA OF SKIN OF TRUNK, EXCEPT SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1482, N'173.59', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF SKIN OF TRUNK, EXCEPT SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1483, N'173.60', N'UNSPECIFIED MALIGNANT NEOPLASM OF SKIN OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1484, N'173.61', N'BASAL CELL CARCINOMA OF SKIN OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1485, N'173.62', N'SQUAMOUS CELL CARCINOMA OF SKIN OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1486, N'173.69', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF SKIN OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1487, N'173.70', N'UNSPECIFIED MALIGNANT NEOPLASM OF SKIN OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1488, N'173.71', N'BASAL CELL CARCINOMA OF SKIN OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1489, N'173.72', N'SQUAMOUS CELL CARCINOMA OF SKIN OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1490, N'173.79', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF SKIN OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1491, N'173.80', N'UNSPECIFIED MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1492, N'173.81', N'BASAL CELL CARCINOMA OF OTHER SPECIFIED SITES OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1493, N'173.82', N'SQUAMOUS CELL CARCINOMA OF OTHER SPECIFIED SITES OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1494, N'173.89', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1495, N'173.90', N'UNSPECIFIED MALIGNANT NEOPLASM OF SKIN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1496, N'173.91', N'BASAL CELL CARCINOMA OF SKIN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1497, N'173.92', N'SQUAMOUS CELL CARCINOMA OF SKIN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1498, N'173.99', N'OTHER SPECIFIED MALIGNANT NEOPLASM OF SKIN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1499, N'174.0', N'MALIGNANT NEOPLASM OF NIPPLE AND AREOLA OF FEMALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1500, N'174.1', N'MALIGNANT NEOPLASM OF CENTRAL PORTION OF FEMALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1501, N'174.2', N'MALIGNANT NEOPLASM OF UPPER-INNER QUADRANT OF FEMALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1502, N'174.3', N'MALIGNANT NEOPLASM OF LOWER-INNER QUADRANT OF FEMALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1503, N'174.4', N'MALIGNANT NEOPLASM OF UPPER-OUTER QUADRANT OF FEMALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1504, N'174.5', N'MALIGNANT NEOPLASM OF LOWER-OUTER QUADRANT OF FEMALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1505, N'174.6', N'MALIGNANT NEOPLASM OF AXILLARY TAIL OF FEMALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1506, N'174.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF FEMALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1507, N'174.9', N'MALIGNANT NEOPLASM OF BREAST (FEMALE), UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1508, N'175.0', N'MALIGNANT NEOPLASM OF NIPPLE AND AREOLA OF MALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1509, N'175.9', N'MALIGNANT NEOPLASM OF OTHER AND UNSPECIFIED SITES OF MALE BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1510, N'176.0', N'KAPOSI''S SARCOMA, SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1511, N'176.1', N'KAPOSI''S SARCOMA, SOFT TISSUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1512, N'176.2', N'KAPOSI''S SARCOMA, PALATE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1513, N'176.3', N'KAPOSI''S SARCOMA, GASTROINTESTINAL SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1514, N'176.4', N'KAPOSI''S SARCOMA, LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1500 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1515, N'176.5', N'KAPOSI''S SARCOMA, LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1516, N'176.8', N'KAPOSI''S SARCOMA, OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1517, N'176.9', N'KAPOSI''S SARCOMA, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1518, N'179.', N'MALIGNANT NEOPLASM OF UTERUS, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1519, N'180.0', N'MALIGNANT NEOPLASM OF ENDOCERVIX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1520, N'180.1', N'MALIGNANT NEOPLASM OF EXOCERVIX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1521, N'180.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF CERVIX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1522, N'180.9', N'MALIGNANT NEOPLASM OF CERVIX UTERI, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1523, N'181.', N'MALIGNANT NEOPLASM OF PLACENTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1524, N'182.0', N'MALIGNANT NEOPLASM OF CORPUS UTERI, EXCEPT ISTHMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1525, N'182.1', N'MALIGNANT NEOPLASM OF ISTHMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1526, N'182.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF BODY OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1527, N'183.0', N'MALIGNANT NEOPLASM OF OVARY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1528, N'183.2', N'MALIGNANT NEOPLASM OF FALLOPIAN TUBE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1529, N'183.3', N'MALIGNANT NEOPLASM OF BROAD LIGAMENT OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1530, N'183.4', N'MALIGNANT NEOPLASM OF PARAMETRIUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1531, N'183.5', N'MALIGNANT NEOPLASM OF ROUND LIGAMENT OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1532, N'183.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF UTERINE ADNEXA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1533, N'183.9', N'MALIGNANT NEOPLASM OF UTERINE ADNEXA, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1534, N'184.0', N'MALIGNANT NEOPLASM OF VAGINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1535, N'184.1', N'MALIGNANT NEOPLASM OF LABIA MAJORA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1536, N'184.2', N'MALIGNANT NEOPLASM OF LABIA MINORA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1537, N'184.3', N'MALIGNANT NEOPLASM OF CLITORIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1538, N'184.4', N'MALIGNANT NEOPLASM OF VULVA, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1539, N'184.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF FEMALE GENITAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1540, N'184.9', N'MALIGNANT NEOPLASM OF FEMALE GENITAL ORGAN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1541, N'185.', N'MALIGNANT NEOPLASM OF PROSTATE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1542, N'186.0', N'MALIGNANT NEOPLASM OF UNDESCENDED TESTIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1543, N'186.9', N'MALIGNANT NEOPLASM OF OTHER AND UNSPECIFIED TESTIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1544, N'187.1', N'MALIGNANT NEOPLASM OF PREPUCE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1545, N'187.2', N'MALIGNANT NEOPLASM OF GLANS PENIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1546, N'187.3', N'MALIGNANT NEOPLASM OF BODY OF PENIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1547, N'187.4', N'MALIGNANT NEOPLASM OF PENIS, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1548, N'187.5', N'MALIGNANT NEOPLASM OF EPIDIDYMIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1549, N'187.6', N'MALIGNANT NEOPLASM OF SPERMATIC CORD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1550, N'187.7', N'MALIGNANT NEOPLASM OF SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1551, N'187.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF MALE GENITAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1552, N'187.9', N'MALIGNANT NEOPLASM OF MALE GENITAL ORGAN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1553, N'188.0', N'MALIGNANT NEOPLASM OF TRIGONE OF URINARY BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1554, N'188.1', N'MALIGNANT NEOPLASM OF DOME OF URINARY BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1555, N'188.2', N'MALIGNANT NEOPLASM OF LATERAL WALL OF URINARY BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1556, N'188.3', N'MALIGNANT NEOPLASM OF ANTERIOR WALL OF URINARY BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1557, N'188.4', N'MALIGNANT NEOPLASM OF POSTERIOR WALL OF URINARY BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1558, N'188.5', N'MALIGNANT NEOPLASM OF BLADDER NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1559, N'188.6', N'MALIGNANT NEOPLASM OF URETERIC ORIFICE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1560, N'188.7', N'MALIGNANT NEOPLASM OF URACHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1561, N'188.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1562, N'188.9', N'MALIGNANT NEOPLASM OF BLADDER, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1563, N'189.0', N'MALIGNANT NEOPLASM OF KIDNEY, EXCEPT PELVIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1564, N'189.1', N'MALIGNANT NEOPLASM OF RENAL PELVIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1565, N'189.2', N'MALIGNANT NEOPLASM OF URETER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1566, N'189.3', N'MALIGNANT NEOPLASM OF URETHRA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1567, N'189.4', N'MALIGNANT NEOPLASM OF PARAURETHRAL GLANDS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1568, N'189.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF URINARY ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1569, N'189.9', N'MALIGNANT NEOPLASM OF URINARY ORGAN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1570, N'190.0', N'MALIGNANT NEOPLASM OF EYEBALL, EXCEPT CONJUNCTIVA, CORNEA, RETINA, AND CHOROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1571, N'190.1', N'MALIGNANT NEOPLASM OF ORBIT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1572, N'190.2', N'MALIGNANT NEOPLASM OF LACRIMAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1573, N'190.3', N'MALIGNANT NEOPLASM OF CONJUNCTIVA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1574, N'190.4', N'MALIGNANT NEOPLASM OF CORNEA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1575, N'190.5', N'MALIGNANT NEOPLASM OF RETINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1576, N'190.6', N'MALIGNANT NEOPLASM OF CHOROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1577, N'190.7', N'MALIGNANT NEOPLASM OF LACRIMAL DUCT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1578, N'190.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF EYE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1579, N'190.9', N'MALIGNANT NEOPLASM OF EYE, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1580, N'191.0', N'MALIGNANT NEOPLASM OF CEREBRUM, EXCEPT LOBES AND VENTRICLES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1581, N'191.1', N'MALIGNANT NEOPLASM OF FRONTAL LOBE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1582, N'191.2', N'MALIGNANT NEOPLASM OF TEMPORAL LOBE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1583, N'191.3', N'MALIGNANT NEOPLASM OF PARIETAL LOBE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1584, N'191.4', N'MALIGNANT NEOPLASM OF OCCIPITAL LOBE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1585, N'191.5', N'MALIGNANT NEOPLASM OF VENTRICLES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1586, N'191.6', N'MALIGNANT NEOPLASM OF CEREBELLUM NOS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1587, N'191.7', N'MALIGNANT NEOPLASM OF BRAIN STEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1588, N'191.8', N'MALIGNANT NEOPLASM OF OTHER PARTS OF BRAIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1589, N'191.9', N'MALIGNANT NEOPLASM OF BRAIN, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1590, N'192.0', N'MALIGNANT NEOPLASM OF CRANIAL NERVES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1591, N'192.1', N'MALIGNANT NEOPLASM OF CEREBRAL MENINGES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1592, N'192.2', N'MALIGNANT NEOPLASM OF SPINAL CORD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1593, N'192.3', N'MALIGNANT NEOPLASM OF SPINAL MENINGES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1594, N'192.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES OF NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1595, N'192.9', N'MALIGNANT NEOPLASM OF NERVOUS SYSTEM, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1596, N'193.', N'MALIGNANT NEOPLASM OF THYROID GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1597, N'194.0', N'MALIGNANT NEOPLASM OF ADRENAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1598, N'194.1', N'MALIGNANT NEOPLASM OF PARATHYROID GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1599, N'194.3', N'MALIGNANT NEOPLASM OF PITUITARY GLAND AND CRANIOPHARYNGEAL DUCT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1600, N'194.4', N'MALIGNANT NEOPLASM OF PINEAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1601, N'194.5', N'MALIGNANT NEOPLASM OF CAROTID BODY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1602, N'194.6', N'MALIGNANT NEOPLASM OF AORTIC BODY AND OTHER PARAGANGLIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1603, N'194.8', N'MALIGNANT NEOPLASM OF OTHER ENDOCRINE GLANDS AND RELATED STRUCTURES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1604, N'194.9', N'MALIGNANT NEOPLASM OF ENDOCRINE GLAND, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1605, N'195.0', N'MALIGNANT NEOPLASM OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1606, N'195.1', N'MALIGNANT NEOPLASM OF THORAX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1607, N'195.2', N'MALIGNANT NEOPLASM OF ABDOMEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1608, N'195.3', N'MALIGNANT NEOPLASM OF PELVIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1609, N'195.4', N'MALIGNANT NEOPLASM OF UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1610, N'195.5', N'MALIGNANT NEOPLASM OF LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1611, N'195.8', N'MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1612, N'196.0', N'SECONDARY AND UNSPECIFIED MALIGNANT NEOPLASM OF LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1613, N'196.1', N'SECONDARY AND UNSPECIFIED MALIGNANT NEOPLASM OF INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1614, N'196.2', N'SECONDARY AND UNSPECIFIED MALIGNANT NEOPLASM OF INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1615, N'196.3', N'SECONDARY AND UNSPECIFIED MALIGNANT NEOPLASM OF LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1600 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1616, N'196.5', N'SECONDARY AND UNSPECIFIED MALIGNANT NEOPLASM OF LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1617, N'196.6', N'SECONDARY AND UNSPECIFIED MALIGNANT NEOPLASM OF INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1618, N'196.8', N'SECONDARY AND UNSPECIFIED MALIGNANT NEOPLASM OF LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1619, N'196.9', N'SECONDARY AND UNSPECIFIED MALIGNANT NEOPLASM OF LYMPH NODES, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1620, N'197.0', N'SECONDARY MALIGNANT NEOPLASM OF LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1621, N'197.1', N'SECONDARY MALIGNANT NEOPLASM OF MEDIASTINUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1622, N'197.2', N'SECONDARY MALIGNANT NEOPLASM OF PLEURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1623, N'197.3', N'SECONDARY MALIGNANT NEOPLASM OF OTHER RESPIRATORY ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1624, N'197.4', N'SECONDARY MALIGNANT NEOPLASM OF SMALL INTESTINE INCLUDING DUODENUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1625, N'197.5', N'SECONDARY MALIGNANT NEOPLASM OF LARGE INTESTINE AND RECTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1626, N'197.6', N'SECONDARY MALIGNANT NEOPLASM OF RETROPERITONEUM AND PERITONEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1627, N'197.7', N'MALIGNANT NEOPLASM OF LIVER, SECONDARY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1628, N'197.8', N'SECONDARY MALIGNANT NEOPLASM OF OTHER DIGESTIVE ORGANS AND SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1629, N'198.0', N'SECONDARY MALIGNANT NEOPLASM OF KIDNEY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1630, N'198.1', N'SECONDARY MALIGNANT NEOPLASM OF OTHER URINARY ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1631, N'198.2', N'SECONDARY MALIGNANT NEOPLASM OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1632, N'198.3', N'SECONDARY MALIGNANT NEOPLASM OF BRAIN AND SPINAL CORD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1633, N'198.4', N'SECONDARY MALIGNANT NEOPLASM OF OTHER PARTS OF NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1634, N'198.5', N'SECONDARY MALIGNANT NEOPLASM OF BONE AND BONE MARROW', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1635, N'198.6', N'SECONDARY MALIGNANT NEOPLASM OF OVARY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1636, N'198.7', N'SECONDARY MALIGNANT NEOPLASM OF ADRENAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1637, N'198.81', N'SECONDARY MALIGNANT NEOPLASM OF BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1638, N'198.82', N'SECONDARY MALIGNANT NEOPLASM OF GENITAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1639, N'198.89', N'SECONDARY MALIGNANT NEOPLASM OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1640, N'199.0', N'DISSEMINATED MALIGNANT NEOPLASM WITHOUT SPECIFICATION OF SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1641, N'199.1', N'OTHER MALIGNANT NEOPLASM WITHOUT SPECIFICATION OF SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1642, N'199.2', N'MALIGNANT NEOPLASM ASSOCIATED WITH TRANSPLANT ORGAN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1643, N'200.00', N'RETICULOSARCOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1644, N'200.01', N'RETICULOSARCOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1645, N'200.02', N'RETICULOSARCOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1646, N'200.03', N'RETICULOSARCOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1647, N'200.04', N'RETICULOSARCOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1648, N'200.05', N'RETICULOSARCOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1649, N'200.06', N'RETICULOSARCOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1650, N'200.07', N'RETICULOSARCOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1651, N'200.08', N'RETICULOSARCOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1652, N'200.10', N'LYMPHOSARCOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1653, N'200.11', N'LYMPHOSARCOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1654, N'200.12', N'LYMPHOSARCOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1655, N'200.13', N'LYMPHOSARCOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1656, N'200.14', N'LYMPHOSARCOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1657, N'200.15', N'LYMPHOSARCOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1658, N'200.16', N'LYMPHOSARCOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1659, N'200.17', N'LYMPHOSARCOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1660, N'200.18', N'LYMPHOSARCOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1661, N'200.20', N'BURKITT''S TUMOR OR LYMPHOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1662, N'200.21', N'BURKITT''S TUMOR OR LYMPHOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1663, N'200.22', N'BURKITT''S TUMOR OR LYMPHOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1664, N'200.23', N'BURKITT''S TUMOR OR LYMPHOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1665, N'200.24', N'BURKITT''S TUMOR OR LYMPHOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1666, N'200.25', N'BURKITT''S TUMOR OR LYMPHOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1667, N'200.26', N'BURKITT''S TUMOR OR LYMPHOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1668, N'200.27', N'BURKITT''S TUMOR OR LYMPHOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1669, N'200.28', N'BURKITT''S TUMOR OR LYMPHOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1670, N'200.30', N'MARGINAL ZONE LYMPHOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1671, N'200.31', N'MARGINAL ZONE LYMPHOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1672, N'200.32', N'MARGINAL ZONE LYMPHOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1673, N'200.33', N'MARGINAL ZONE LYMPHOMA, INTRAABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1674, N'200.34', N'MARGINAL ZONE LYMPHOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1675, N'200.35', N'MARGINAL ZONE LYMPHOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1676, N'200.36', N'MARGINAL ZONE LYMPHOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1677, N'200.37', N'MARGINAL ZONE LYMPHOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1678, N'200.38', N'MARGINAL ZONE LYMPHOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1679, N'200.40', N'MANTLE CELL LYMPHOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1680, N'200.41', N'MANTLE CELL LYMPHOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1681, N'200.42', N'MANTLE CELL LYMPHOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1682, N'200.43', N'MANTLE CELL LYMPHOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1683, N'200.44', N'MANTLE CELL LYMPHOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1684, N'200.45', N'MANTLE CELL LYMPHOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1685, N'200.46', N'MANTLE CELL LYMPHOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1686, N'200.47', N'MANTLE CELL LYMPHOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1687, N'200.48', N'MANTLE CELL LYMPHOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1688, N'200.50', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1689, N'200.51', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1690, N'200.52', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1691, N'200.53', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1692, N'200.54', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1693, N'200.55', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1694, N'200.56', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1695, N'200.57', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1696, N'200.58', N'PRIMARY CENTRAL NERVOUS SYSTEM LYMPHOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1697, N'200.60', N'ANAPLASTIC LARGE CELL LYMPHOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1698, N'200.61', N'ANAPLASTIC LARGE CELL LYMPHOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1699, N'200.62', N'ANAPLASTIC LARGE CELL LYMPHOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1700, N'200.63', N'ANAPLASTIC LARGE CELL LYMPHOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1701, N'200.64', N'ANAPLASTIC LARGE CELL LYMPHOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1702, N'200.65', N'ANAPLASTIC LARGE CELL LYMPHOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1703, N'200.66', N'ANAPLASTIC LARGE CELL LYMPHOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1704, N'200.67', N'ANAPLASTIC LARGE CELL LYMPHOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1705, N'200.68', N'ANAPLASTIC LARGE CELL LYMPHOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1706, N'200.70', N'LARGE CELL LYMPHOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1707, N'200.71', N'LARGE CELL LYMPHOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1708, N'200.72', N'LARGE CELL LYMPHOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1709, N'200.73', N'LARGE CELL LYMPHOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1710, N'200.74', N'LARGE CELL LYMPHOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1711, N'200.75', N'LARGE CELL LYMPHOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1712, N'200.76', N'LARGE CELL LYMPHOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1713, N'200.77', N'LARGE CELL LYMPHOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1714, N'200.78', N'LARGE CELL LYMPHOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1715, N'200.80', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1716, N'200.81', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1700 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1717, N'200.82', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA,INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1718, N'200.83', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1719, N'200.84', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1720, N'200.85', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1721, N'200.86', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1722, N'200.87', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1723, N'200.88', N'OTHER NAMED VARIANTS OF LYMPHOSARCOMA AND RETICULOSARCOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1724, N'201.00', N'HODGKIN''S PARAGRANULOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1725, N'201.01', N'HODGKIN''S PARAGRANULOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1726, N'201.02', N'HODGKIN''S PARAGRANULOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1727, N'201.03', N'HODGKIN''S PARAGRANULOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1728, N'201.04', N'HODGKIN''S PARAGRANULOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1729, N'201.05', N'HODGKIN''S PARAGRANULOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1730, N'201.06', N'HODGKIN''S PARAGRANULOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1731, N'201.07', N'HODGKIN''S PARAGRANULOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1732, N'201.08', N'HODGKIN''S PARAGRANULOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1733, N'201.10', N'HODGKIN''S GRANULOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1734, N'201.11', N'HODGKIN''S GRANULOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1735, N'201.12', N'HODGKIN''S GRANULOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1736, N'201.13', N'HODGKIN''S GRANULOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1737, N'201.14', N'HODGKIN''S GRANULOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1738, N'201.15', N'HODGKIN''S GRANULOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1739, N'201.16', N'HODGKIN''S GRANULOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1740, N'201.17', N'HODGKIN''S GRANULOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1741, N'201.18', N'HODGKIN''S GRANULOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1742, N'201.20', N'HODGKIN''S SARCOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1743, N'201.21', N'HODGKIN''S SARCOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1744, N'201.22', N'HODGKIN''S SARCOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1745, N'201.23', N'HODGKIN''S SARCOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1746, N'201.24', N'HODGKIN''S SARCOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1747, N'201.25', N'HODGKIN''S SARCOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1748, N'201.26', N'HODGKIN''S SARCOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1749, N'201.27', N'HODGKIN''S SARCOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1750, N'201.28', N'HODGKIN''S SARCOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1751, N'201.40', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1752, N'201.41', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1753, N'201.42', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1754, N'201.43', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1755, N'201.44', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1756, N'201.45', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1757, N'201.46', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1758, N'201.47', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1759, N'201.48', N'HODGKIN''S DISEASE, LYMPHOCYTIC-HISTIOCYTIC PREDOMINANCE, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1760, N'201.50', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1761, N'201.51', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1762, N'201.52', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1763, N'201.53', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1764, N'201.54', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1765, N'201.55', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1766, N'201.56', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1767, N'201.57', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1768, N'201.58', N'HODGKIN''S DISEASE, NODULAR SCLEROSIS, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1769, N'201.60', N'HODGKIN''S DISEASE, MIXED CELLULARITY, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1770, N'201.61', N'HODGKIN''S DISEASE, MIXED CELLULARITY, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1771, N'201.62', N'HODGKIN''S DISEASE, MIXED CELLULARITY, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1772, N'201.63', N'HODGKIN''S DISEASE, MIXED CELLULARITY, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1773, N'201.64', N'HODGKIN''S DISEASE, MIXED CELLULARITY, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1774, N'201.65', N'HODGKIN''S DISEASE, MIXED CELLULARITY, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1775, N'201.66', N'HODGKIN''S DISEASE, MIXED CELLULARITY, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1776, N'201.67', N'HODGKIN''S DISEASE, MIXED CELLULARITY, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1777, N'201.68', N'HODGKIN''S DISEASE, MIXED CELLULARITY, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1778, N'201.70', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1779, N'201.71', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1780, N'201.72', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1781, N'201.73', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1782, N'201.74', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1783, N'201.75', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1784, N'201.76', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1785, N'201.77', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1786, N'201.78', N'HODGKIN''S DISEASE, LYMPHOCYTIC DEPLETION, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1787, N'201.90', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1788, N'201.91', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1789, N'201.92', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1790, N'201.93', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1791, N'201.94', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1792, N'201.95', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1793, N'201.96', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1794, N'201.97', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1795, N'201.98', N'HODGKIN''S DISEASE, UNSPECIFIED TYPE, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1796, N'202.00', N'NODULAR LYMPHOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1797, N'202.01', N'NODULAR LYMPHOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1798, N'202.02', N'NODULAR LYMPHOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1799, N'202.03', N'NODULAR LYMPHOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1800, N'202.04', N'NODULAR LYMPHOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1801, N'202.05', N'NODULAR LYMPHOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1802, N'202.06', N'NODULAR LYMPHOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1803, N'202.07', N'NODULAR LYMPHOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1804, N'202.08', N'NODULAR LYMPHOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1805, N'202.10', N'MYCOSIS FUNGOIDES, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1806, N'202.11', N'MYCOSIS FUNGOIDES, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1807, N'202.12', N'MYCOSIS FUNGOIDES, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1808, N'202.13', N'MYCOSIS FUNGOIDES, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1809, N'202.14', N'MYCOSIS FUNGOIDES, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1810, N'202.15', N'MYCOSIS FUNGOIDES, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1811, N'202.16', N'MYCOSIS FUNGOIDES, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1812, N'202.17', N'MYCOSIS FUNGOIDES, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1813, N'202.18', N'MYCOSIS FUNGOIDES, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1814, N'202.20', N'SEZARY''S DISEASE, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1815, N'202.21', N'SEZARY''S DISEASE, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1816, N'202.22', N'SEZARY''S DISEASE, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1817, N'202.23', N'SEZARY''S DISEASE, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1800 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1818, N'202.24', N'SEZARY''S DISEASE, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1819, N'202.25', N'SEZARY''S DISEASE, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1820, N'202.26', N'SEZARY''S DISEASE, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1821, N'202.27', N'SEZARY''S DISEASE, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1822, N'202.28', N'SEZARY''S DISEASE, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1823, N'202.30', N'MALIGNANT HISTIOCYTOSIS, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1824, N'202.31', N'MALIGNANT HISTIOCYTOSIS, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1825, N'202.32', N'MALIGNANT HISTIOCYTOSIS, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1826, N'202.33', N'MALIGNANT HISTIOCYTOSIS, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1827, N'202.34', N'MALIGNANT HISTIOCYTOSIS, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1828, N'202.35', N'MALIGNANT HISTIOCYTOSIS, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1829, N'202.36', N'MALIGNANT HISTIOCYTOSIS, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1830, N'202.37', N'MALIGNANT HISTIOCYTOSIS, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1831, N'202.38', N'MALIGNANT HISTIOCYTOSIS, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1832, N'202.40', N'LEUKEMIC RETICULOENDOTHELIOSIS, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1833, N'202.41', N'LEUKEMIC RETICULOENDOTHELIOSIS, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1834, N'202.42', N'LEUKEMIC RETICULOENDOTHELIOSIS, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1835, N'202.43', N'LEUKEMIC RETICULOENDOTHELIOSIS, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1836, N'202.44', N'LEUKEMIC RETICULOENDOTHELIOSIS, LYMPH NODES OF AXILLA AND UPPER ARM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1837, N'202.45', N'LEUKEMIC RETICULOENDOTHELIOSIS, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1838, N'202.46', N'LEUKEMIC RETICULOENDOTHELIOSIS, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1839, N'202.47', N'LEUKEMIC RETICULOENDOTHELIOSIS, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1840, N'202.48', N'LEUKEMIC RETICULOENDOTHELIOSIS, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1841, N'202.50', N'LETTERER-SIWE DISEASE, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1842, N'202.51', N'LETTERER-SIWE DISEASE, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1843, N'202.52', N'LETTERER-SIWE DISEASE, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1844, N'202.53', N'LETTERER-SIWE DISEASE, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1845, N'202.54', N'LETTERER-SIWE DISEASE, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1846, N'202.55', N'LETTERER-SIWE DISEASE, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1847, N'202.56', N'LETTERER-SIWE DISEASE, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1848, N'202.57', N'LETTERER-SIWE DISEASE, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1849, N'202.58', N'LETTERER-SIWE DISEASE, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1850, N'202.60', N'MALIGNANT MAST CELL TUMORS, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1851, N'202.61', N'MALIGNANT MAST CELL TUMORS, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1852, N'202.62', N'MALIGNANT MAST CELL TUMORS, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1853, N'202.63', N'MALIGNANT MAST CELL TUMORS, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1854, N'202.64', N'MALIGNANT MAST CELL TUMORS, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1855, N'202.65', N'MALIGNANT MAST CELL TUMORS, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1856, N'202.66', N'MALIGNANT MAST CELL TUMORS, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1857, N'202.67', N'MALIGNANT MAST CELL TUMORS, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1858, N'202.68', N'MALIGNANT MAST CELL TUMORS, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1859, N'202.70', N'PERIPHERAL T CELL LYMPHOMA, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1860, N'202.71', N'PERIPHERAL T CELL LYMPHOMA, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1861, N'202.72', N'PERIPHERAL T CELL LYMPHOMA, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1862, N'202.73', N'PERIPHERAL T CELL LYMPHOMA, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1863, N'202.74', N'PERIPHERAL T CELL LYMPHOMA, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1864, N'202.75', N'PERIPHERAL T CELL LYMPHOMA, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1865, N'202.76', N'PERIPHERAL T CELL LYMPHOMA, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1866, N'202.77', N'PERIPHERAL T CELL LYMPHOMA, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1867, N'202.78', N'PERIPHERAL T CELL LYMPHOMA, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1868, N'202.80', N'OTHER MALIGNANT LYMPHOMAS, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1869, N'202.81', N'OTHER MALIGNANT LYMPHOMAS, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1870, N'202.82', N'OTHER MALIGNANT LYMPHOMAS, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1871, N'202.83', N'OTHER MALIGNANT LYMPHOMAS, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1872, N'202.84', N'OTHER MALIGNANT LYMPHOMAS, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1873, N'202.85', N'OTHER MALIGNANT LYMPHOMAS, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1874, N'202.86', N'OTHER MALIGNANT LYMPHOMAS, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1875, N'202.87', N'OTHER MALIGNANT LYMPHOMAS, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1876, N'202.88', N'OTHER MALIGNANT LYMPHOMAS, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1877, N'202.90', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, UNSPECIFIED SITE, EXTRANODAL AND SOLID ORGAN SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1878, N'202.91', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, LYMPH NODES OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1879, N'202.92', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, INTRATHORACIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1880, N'202.93', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, INTRA-ABDOMINAL LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1881, N'202.94', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, LYMPH NODES OF AXILLA AND UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1882, N'202.95', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, LYMPH NODES OF INGUINAL REGION AND LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1883, N'202.96', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, INTRAPELVIC LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1884, N'202.97', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, SPLEEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1885, N'202.98', N'OTHER AND UNSPECIFIED MALIGNANT NEOPLASMS OF LYMPHOID AND HISTIOCYTIC TISSUE, LYMPH NODES OF MULTIPLE SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1886, N'203.00', N'MULTIPLE MYELOMA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1887, N'203.01', N'MULTIPLE MYELOMA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1888, N'203.02', N'MULTIPLE MYELOMA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1889, N'203.10', N'PLASMA CELL LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1890, N'203.11', N'PLASMA CELL LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1891, N'203.12', N'PLASMA CELL LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1892, N'203.80', N'OTHER IMMUNOPROLIFERATIVE NEOPLASMS, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1893, N'203.81', N'OTHER IMMUNOPROLIFERATIVE NEOPLASMS, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1894, N'203.82', N'OTHER IMMUNOPROLIFERATIVE NEOPLASMS, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1895, N'204.00', N'ACUTE LYMPHOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1896, N'204.01', N'ACUTE LYMPHOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1897, N'204.02', N'ACUTE LYMPHOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1898, N'204.10', N'CHRONIC LYMPHOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1899, N'204.11', N'CHRONIC LYMPHOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1900, N'204.12', N'CHRONIC LYMPHOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1901, N'204.20', N'SUBACUTE LYMPHOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1902, N'204.21', N'SUBACUTE LYMPHOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1903, N'204.22', N'SUBACUTE LYMPHOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1904, N'204.80', N'OTHER LYMPHOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1905, N'204.81', N'OTHER LYMPHOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1906, N'204.82', N'OTHER LYMPHOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1907, N'204.90', N'UNSPECIFIED LYMPHOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1908, N'204.91', N'UNSPECIFIED LYMPHOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1909, N'204.92', N'UNSPECIFIED LYMPHOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1910, N'205.00', N'ACUTE MYELOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1911, N'205.01', N'ACUTE MYELOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1912, N'205.02', N'ACUTE MYELOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1913, N'205.10', N'CHRONIC MYELOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1914, N'205.11', N'CHRONIC MYELOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1915, N'205.12', N'CHRONIC MYELOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1916, N'205.20', N'SUBACUTE MYELOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1917, N'205.21', N'SUBACUTE MYELOID LEUKEMIA,IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1918, N'205.22', N'SUBACUTE MYELOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 1900 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1919, N'205.30', N'MYELOID SARCOMA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1920, N'205.31', N'MYELOID SARCOMA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1921, N'205.32', N'MYELOID SARCOMA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1922, N'205.80', N'OTHER MYELOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1923, N'205.81', N'OTHER MYELOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1924, N'205.82', N'OTHER MYELOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1925, N'205.90', N'UNSPECIFIED MYELOID LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1926, N'205.91', N'UNSPECIFIED MYELOID LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1927, N'205.92', N'UNSPECIFIED MYELOID LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1928, N'206.00', N'ACUTE MONOCYTIC LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1929, N'206.01', N'ACUTE MONOCYTIC LEUKEMIA,IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1930, N'206.02', N'ACUTE MONOCYTIC LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1931, N'206.10', N'CHRONIC MONOCYTIC LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1932, N'206.11', N'CHRONIC MONOCYTIC LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1933, N'206.12', N'CHRONIC MONOCYTIC LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1934, N'206.20', N'SUBACUTE MONOCYTIC LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1935, N'206.21', N'SUBACUTE MONOCYTIC LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1936, N'206.22', N'SUBACUTE MONOCYTIC LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1937, N'206.80', N'OTHER MONOCYTIC LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1938, N'206.81', N'OTHER MONOCYTIC LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1939, N'206.82', N'OTHER MONOCYTIC LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1940, N'206.90', N'UNSPECIFIED MONOCYTIC LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1941, N'206.91', N'UNSPECIFIED MONOCYTIC LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1942, N'206.92', N'UNSPECIFIED MONOCYTIC LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1943, N'207.00', N'ACUTE ERYTHREMIA AND ERYTHROLEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1944, N'207.01', N'ACUTE ERYTHREMIA AND ERYTHROLEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1945, N'207.02', N'ACUTE ERYTHREMIA AND ERYTHROLEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1946, N'207.10', N'CHRONIC ERYTHREMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1947, N'207.11', N'CHRONIC ERYTHREMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1948, N'207.12', N'CHRONIC ERYTHREMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1949, N'207.20', N'MEGAKARYOCYTIC LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1950, N'207.21', N'MEGAKARYOCYTIC LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1951, N'207.22', N'MEGAKARYOCYTIC LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1952, N'207.80', N'OTHER SPECIFIED LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1953, N'207.81', N'OTHER SPECIFIED LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1954, N'207.82', N'OTHER SPECIFIED LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1955, N'208.00', N'ACUTE LEUKEMIA OF UNSPECIFIED CELL TYPE, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1956, N'208.01', N'ACUTE LEUKEMIA OF UNSPECIFIED CELL TYPE, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1957, N'208.02', N'ACUTE LEUKEMIA OF UNSPECIFIED CELL TYPE, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1958, N'208.10', N'CHRONIC LEUKEMIA OF UNSPECIFIED CELL TYPE, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1959, N'208.11', N'CHRONIC LEUKEMIA OF UNSPECIFIED CELL TYPE, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1960, N'208.12', N'CHRONIC LEUKEMIA OF UNSPECIFIED CELL TYPE, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1961, N'208.20', N'SUBACUTE LEUKEMIA OF UNSPECIFIED CELL TYPE, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1962, N'208.21', N'SUBACUTE LEUKEMIA OF UNSPECIFIED CELL TYPE, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1963, N'208.22', N'SUBACUTE LEUKEMIA OF UNSPECIFIED CELL TYPE, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1964, N'208.80', N'OTHER LEUKEMIA OF UNSPECIFIED CELL TYPE, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1965, N'208.81', N'OTHER LEUKEMIA OF UNSPECIFIED CELL TYPE, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1966, N'208.82', N'OTHER LEUKEMIA OF UNSPECIFIED CELL TYPE, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1967, N'208.90', N'UNSPECIFIED LEUKEMIA, WITHOUT MENTION OF HAVING ACHIEVED REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1968, N'208.91', N'UNSPECIFIED LEUKEMIA, IN REMISSION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1969, N'208.92', N'UNSPECIFIED LEUKEMIA, IN RELAPSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1970, N'209.00', N'MALIGNANT CARCINOID TUMOR OF THE SMALL INTESTINE, UNSPECIFIED PORTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1971, N'209.01', N'MALIGNANT CARCINOID TUMOR OF THE DUODENUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1972, N'209.02', N'MALIGNANT CARCINOID TUMOR OF THE JEJUNUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1973, N'209.03', N'MALIGNANT CARCINOID TUMOR OF THE ILEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1974, N'209.10', N'MALIGNANT CARCINOID TUMOR OF THE LARGE INTESTINE, UNSPECIFIED PORTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1975, N'209.11', N'MALIGNANT CARCINOID TUMOR OF THE APPENDIX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1976, N'209.12', N'MALIGNANT CARCINOID TUMOR OF THE CECUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1977, N'209.13', N'MALIGNANT CARCINOID TUMOR OF THE ASCENDING COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1978, N'209.14', N'MALIGNANT CARCINOID TUMOR OF THE TRANSVERSE COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1979, N'209.15', N'MALIGNANT CARCINOID TUMOR OF THE DESCENDING COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1980, N'209.16', N'MALIGNANT CARCINOID TUMOR OF THE SIGMOID COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1981, N'209.17', N'MALIGNANT CARCINOID TUMOR OF THE RECTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1982, N'209.20', N'MALIGNANT CARCINOID TUMOR OF UNKNOWN PRIMARY SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1983, N'209.21', N'MALIGNANT CARCINOID TUMOR OF THE BRONCHUS AND LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1984, N'209.22', N'MALIGNANT CARCINOID TUMOR OF THE THYMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1985, N'209.23', N'MALIGNANT CARCINOID TUMOR OF THE STOMACH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1986, N'209.24', N'MALIGNANT CARCINOID TUMOR OF THE KIDNEY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1987, N'209.25', N'MALIGNANT CARCINOID TUMOR OF FOREGUT, NOT OTHERWISE SPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1988, N'209.26', N'MALIGNANT CARCINOID TUMOR OF MIDGUT, NOT OTHERWISE SPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1989, N'209.27', N'MALIGNANT CARCINOID TUMOR OF HINDGUT, NOT OTHERWISE SPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1990, N'209.29', N'MALIGNANT CARCINOID TUMOR OF OTHER SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1991, N'209.30', N'MALIGNANT POORLY DIFFERENTIATED NEUROENDOCRINE CARCINOMA, ANY SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1992, N'209.31', N'MERKEL CELL CARCINOMA OF THE FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1993, N'209.32', N'MERKEL CELL CARCINOMA OF THE SCALP AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1994, N'209.33', N'MERKEL CELL CARCINOMA OF THE UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1995, N'209.34', N'MERKEL CELL CARCINOMA OF THE LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1996, N'209.35', N'MERKEL CELL CARCINOMA OF THE TRUNK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1997, N'209.36', N'MERKEL CELL CARCINOMA OF OTHER SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1998, N'209.40', N'BENIGN CARCINOID TUMOR OF THE SMALL INTESTINE, UNSPECIFIED PORTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (1999, N'209.41', N'BENIGN CARCINOID TUMOR OF THE DUODENUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2000, N'209.42', N'BENIGN CARCINOID TUMOR OF THE JEJUNUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2001, N'209.43', N'BENIGN CARCINOID TUMOR OF THE ILEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2002, N'209.50', N'BENIGN CARCINOID TUMOR OF THE LARGE INTESTINE, UNSPECIFIED PORTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2003, N'209.51', N'BENIGN CARCINOID TUMOR OF THE APPENDIX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2004, N'209.52', N'BENIGN CARCINOID TUMOR OF THE CECUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2005, N'209.53', N'BENIGN CARCINOID TUMOR OF THE ASCENDING COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2006, N'209.54', N'BENIGN CARCINOID TUMOR OF THE TRANSVERSE COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2007, N'209.55', N'BENIGN CARCINOID TUMOR OF THE DESCENDING COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2008, N'209.56', N'BENIGN CARCINOID TUMOR OF THE SIGMOID COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2009, N'209.57', N'BENIGN CARCINOID TUMOR OF THE RECTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2010, N'209.60', N'BENIGN CARCINOID TUMOR OF UNKNOWN PRIMARY SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2011, N'209.61', N'BENIGN CARCINOID TUMOR OF THE BRONCHUS AND LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2012, N'209.62', N'BENIGN CARCINOID TUMOR OF THE THYMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2013, N'209.63', N'BENIGN CARCINOID TUMOR OF THE STOMACH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2014, N'209.64', N'BENIGN CARCINOID TUMOR OF THE KIDNEY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2015, N'209.65', N'BENIGN CARCINOID TUMOR OF FOREGUT, NOT OTHERWISE SPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2016, N'209.66', N'BENIGN CARCINOID TUMOR OF MIDGUT, NOT OTHERWISE SPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2017, N'209.67', N'BENIGN CARCINOID TUMOR OF HINDGUT, NOT OTHERWISE SPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2018, N'209.69', N'BENIGN CARCINOID TUMOR OF OTHER SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2019, N'209.70', N'SECONDARY NEUROENDOCRINE TUMOR, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 2000 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2020, N'209.71', N'SECONDARY NEUROENDOCRINE TUMOR OF DISTANT LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2021, N'209.72', N'SECONDARY NEUROENDOCRINE TUMOR OF LIVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2022, N'209.73', N'SECONDARY NEUROENDOCRINE TUMOR OF BONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2023, N'209.74', N'SECONDARY NEUROENDOCRINE TUMOR OF PERITONEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2024, N'209.75', N'SECONDARY MERKEL CELL CARCINOMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2025, N'209.79', N'SECONDARY NEUROENDOCRINE TUMOR OF OTHER SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2026, N'210.0', N'BENIGN NEOPLASM OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2027, N'210.1', N'BENIGN NEOPLASM OF TONGUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2028, N'210.2', N'BENIGN NEOPLASM OF MAJOR SALIVARY GLANDS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2029, N'210.3', N'BENIGN NEOPLASM OF FLOOR OF MOUTH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2030, N'210.4', N'BENIGN NEOPLASM OF OTHER AND UNSPECIFIED PARTS OF MOUTH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2031, N'210.5', N'BENIGN NEOPLASM OF TONSIL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2032, N'210.6', N'BENIGN NEOPLASM OF OTHER PARTS OF OROPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2033, N'210.7', N'BENIGN NEOPLASM OF NASOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2034, N'210.8', N'BENIGN NEOPLASM OF HYPOPHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2035, N'210.9', N'BENIGN NEOPLASM OF PHARYNX, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2036, N'211.0', N'BENIGN NEOPLASM OF ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2037, N'211.1', N'BENIGN NEOPLASM OF STOMACH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2038, N'211.2', N'BENIGN NEOPLASM OF DUODENUM, JEJUNUM, AND ILEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2039, N'211.3', N'BENIGN NEOPLASM OF COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2040, N'211.4', N'BENIGN NEOPLASM OF RECTUM AND ANAL CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2041, N'211.5', N'BENIGN NEOPLASM OF LIVER AND BILIARY PASSAGES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2042, N'211.6', N'BENIGN NEOPLASM OF PANCREAS, EXCEPT ISLETS OF LANGERHANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2043, N'211.7', N'BENIGN NEOPLASM OF ISLETS OF LANGERHANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2044, N'211.8', N'BENIGN NEOPLASM OF RETROPERITONEUM AND PERITONEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2045, N'211.9', N'BENIGN NEOPLASM OF OTHER AND UNSPECIFIED SITE IN THE DIGESTIVE SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2046, N'212.0', N'BENIGN NEOPLASM OF NASAL CAVITIES, MIDDLE EAR, AND ACCESSORY SINUSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2047, N'212.1', N'BENIGN NEOPLASM OF LARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2048, N'212.2', N'BENIGN NEOPLASM OF TRACHEA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2049, N'212.3', N'BENIGN NEOPLASM OF BRONCHUS AND LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2050, N'212.4', N'BENIGN NEOPLASM OF PLEURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2051, N'212.5', N'BENIGN NEOPLASM OF MEDIASTINUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2052, N'212.6', N'BENIGN NEOPLASM OF THYMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2053, N'212.7', N'BENIGN NEOPLASM OF HEART', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2054, N'212.8', N'BENIGN NEOPLASM OF OTHER SPECIFIED SITES OF RESPIRATORY AND INTRATHORACIC ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2055, N'212.9', N'BENIGN NEOPLASM OF RESPIRATORY AND INTRATHORACIC ORGANS, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2056, N'213.0', N'BENIGN NEOPLASM OF BONES OF SKULL AND FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2057, N'213.1', N'BENIGN NEOPLASM OF LOWER JAW BONE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2058, N'213.2', N'BENIGN NEOPLASM OF VERTEBRAL COLUMN, EXCLUDING SACRUM AND COCCYX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2059, N'213.3', N'BENIGN NEOPLASM OF RIBS, STERNUM, AND CLAVICLE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2060, N'213.4', N'BENIGN NEOPLASM OF SCAPULA AND LONG BONES OF UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2061, N'213.5', N'BENIGN NEOPLASM OF SHORT BONES OF UPPER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2062, N'213.6', N'BENIGN NEOPLASM OF PELVIC BONES, SACRUM, AND COCCYX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2063, N'213.7', N'BENIGN NEOPLASM OF LONG BONES OF LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2064, N'213.8', N'BENIGN NEOPLASM OF SHORT BONES OF LOWER LIMB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2065, N'213.9', N'BENIGN NEOPLASM OF BONE AND ARTICULAR CARTILAGE, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2066, N'214.0', N'LIPOMA OF SKIN AND SUBCUTANEOUS TISSUE OF FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2067, N'214.1', N'LIPOMA OF OTHER SKIN AND SUBCUTANEOUS TISSUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2068, N'214.2', N'LIPOMA OF INTRATHORACIC ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2069, N'214.3', N'LIPOMA OF INTRA-ABDOMINAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2070, N'214.4', N'LIPOMA OF SPERMATIC CORD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2071, N'214.8', N'LIPOMA OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2072, N'214.9', N'LIPOMA, UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2073, N'215.0', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF HEAD, FACE, AND NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2074, N'215.2', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2075, N'215.3', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2076, N'215.4', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF THORAX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2077, N'215.5', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF ABDOMEN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2078, N'215.6', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF PELVIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2079, N'215.7', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF TRUNK, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2080, N'215.8', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2081, N'215.9', N'OTHER BENIGN NEOPLASM OF CONNECTIVE AND OTHER SOFT TISSUE, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2082, N'216.0', N'BENIGN NEOPLASM OF SKIN OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2083, N'216.1', N'BENIGN NEOPLASM OF EYELID, INCLUDING CANTHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2084, N'216.2', N'BENIGN NEOPLASM OF EAR AND EXTERNAL AUDITORY CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2085, N'216.3', N'BENIGN NEOPLASM OF SKIN OF OTHER AND UNSPECIFIED PARTS OF FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2086, N'216.4', N'BENIGN NEOPLASM OF SCALP AND SKIN OF NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2087, N'216.5', N'BENIGN NEOPLASM OF SKIN OF TRUNK, EXCEPT SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2088, N'216.6', N'BENIGN NEOPLASM OF SKIN OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2089, N'216.7', N'BENIGN NEOPLASM OF SKIN OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2090, N'216.8', N'BENIGN NEOPLASM OF OTHER SPECIFIED SITES OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2091, N'216.9', N'BENIGN NEOPLASM OF SKIN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2092, N'217.', N'BENIGN NEOPLASM OF BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2093, N'218.0', N'SUBMUCOUS LEIOMYOMA OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2094, N'218.1', N'INTRAMURAL LEIOMYOMA OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2095, N'218.2', N'SUBSEROUS LEIOMYOMA OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2096, N'218.9', N'LEIOMYOMA OF UTERUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2097, N'219.0', N'BENIGN NEOPLASM OF CERVIX UTERI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2098, N'219.1', N'BENIGN NEOPLASM OF CORPUS UTERI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2099, N'219.8', N'BENIGN NEOPLASM OF OTHER SPECIFIED PARTS OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2100, N'219.9', N'BENIGN NEOPLASM OF UTERUS, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2101, N'220.', N'BENIGN NEOPLASM OF OVARY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2102, N'221.0', N'BENIGN NEOPLASM OF FALLOPIAN TUBE AND UTERINE LIGAMENTS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2103, N'221.1', N'BENIGN NEOPLASM OF VAGINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2104, N'221.2', N'BENIGN NEOPLASM OF VULVA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2105, N'221.8', N'BENIGN NEOPLASM OF OTHER SPECIFIED SITES OF FEMALE GENITAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2106, N'221.9', N'BENIGN NEOPLASM OF FEMALE GENITAL ORGAN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2107, N'222.0', N'BENIGN NEOPLASM OF TESTIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2108, N'222.1', N'BENIGN NEOPLASM OF PENIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2109, N'222.2', N'BENIGN NEOPLASM OF PROSTATE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2110, N'222.3', N'BENIGN NEOPLASM OF EPIDIDYMIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2111, N'222.4', N'BENIGN NEOPLASM OF SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2112, N'222.8', N'BENIGN NEOPLASM OF OTHER SPECIFIED SITES OF MALE GENITAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2113, N'222.9', N'BENIGN NEOPLASM OF MALE GENITAL ORGAN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2114, N'223.0', N'BENIGN NEOPLASM OF KIDNEY, EXCEPT PELVIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2115, N'223.1', N'BENIGN NEOPLASM OF RENAL PELVIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2116, N'223.2', N'BENIGN NEOPLASM OF URETER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2117, N'223.3', N'BENIGN NEOPLASM OF BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2118, N'223.81', N'BENIGN NEOPLASM OF URETHRA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2119, N'223.89', N'BENIGN NEOPLASM OF OTHER SPECIFIED SITES OF URINARY ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2120, N'223.9', N'BENIGN NEOPLASM OF URINARY ORGAN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 2100 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2121, N'224.0', N'BENIGN NEOPLASM OF EYEBALL, EXCEPT CONJUNCTIVA, CORNEA, RETINA, AND CHOROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2122, N'224.1', N'BENIGN NEOPLASM OF ORBIT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2123, N'224.2', N'BENIGN NEOPLASM OF LACRIMAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2124, N'224.3', N'BENIGN NEOPLASM OF CONJUNCTIVA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2125, N'224.4', N'BENIGN NEOPLASM OF CORNEA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2126, N'224.5', N'BENIGN NEOPLASM OF RETINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2127, N'224.6', N'BENIGN NEOPLASM OF CHOROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2128, N'224.7', N'BENIGN NEOPLASM OF LACRIMAL DUCT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2129, N'224.8', N'BENIGN NEOPLASM OF OTHER SPECIFIED PARTS OF EYE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2130, N'224.9', N'BENIGN NEOPLASM OF EYE, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2131, N'225.0', N'BENIGN NEOPLASM OF BRAIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2132, N'225.1', N'BENIGN NEOPLASM OF CRANIAL NERVES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2133, N'225.2', N'BENIGN NEOPLASM OF CEREBRAL MENINGES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2134, N'225.3', N'BENIGN NEOPLASM OF SPINAL CORD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2135, N'225.4', N'BENIGN NEOPLASM OF SPINAL MENINGES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2136, N'225.8', N'BENIGN NEOPLASM OF OTHER SPECIFIED SITES OF NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2137, N'225.9', N'BENIGN NEOPLASM OF NERVOUS SYSTEM, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2138, N'226.', N'BENIGN NEOPLASM OF THYROID GLANDS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2139, N'227.0', N'BENIGN NEOPLASM OF ADRENAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2140, N'227.1', N'BENIGN NEOPLASM OF PARATHYROID GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2141, N'227.3', N'BENIGN NEOPLASM OF PITUITARY GLAND AND CRANIOPHARYNGEAL DUCT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2142, N'227.4', N'BENIGN NEOPLASM OF PINEAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2143, N'227.5', N'BENIGN NEOPLASM OF CAROTID BODY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2144, N'227.6', N'BENIGN NEOPLASM OF AORTIC BODY AND OTHER PARAGANGLIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2145, N'227.8', N'BENIGN NEOPLASM OF OTHER ENDOCRINE GLANDS AND RELATED STRUCTURES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2146, N'227.9', N'BENIGN NEOPLASM OF ENDOCRINE GLAND, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2147, N'228.00', N'HEMANGIOMA OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2148, N'228.01', N'HEMANGIOMA OF SKIN AND SUBCUTANEOUS TISSUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2149, N'228.02', N'HEMANGIOMA OF INTRACRANIAL STRUCTURES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2150, N'228.03', N'HEMANGIOMA OF RETINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2151, N'228.04', N'HEMANGIOMA OF INTRA-ABDOMINAL STRUCTURES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2152, N'228.09', N'HEMANGIOMA OF OTHER SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2153, N'228.1', N'LYMPHANGIOMA, ANY SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2154, N'229.0', N'BENIGN NEOPLASM OF LYMPH NODES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2155, N'229.8', N'BENIGN NEOPLASM OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2156, N'229.9', N'BENIGN NEOPLASM OF UNSPECIFIED SITE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2157, N'230.0', N'CARCINOMA IN SITU OF LIP, ORAL CAVITY, AND PHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2158, N'230.1', N'CARCINOMA IN SITU OF ESOPHAGUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2159, N'230.2', N'CARCINOMA IN SITU OF STOMACH', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2160, N'230.3', N'CARCINOMA IN SITU OF COLON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2161, N'230.4', N'CARCINOMA IN SITU OF RECTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2162, N'230.5', N'CARCINOMA IN SITU OF ANAL CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2163, N'230.6', N'CARCINOMA IN SITU OF ANUS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2164, N'230.7', N'CARCINOMA IN SITU OF OTHER AND UNSPECIFIED PARTS OF INTESTINE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2165, N'230.8', N'CARCINOMA IN SITU OF LIVER AND BILIARY SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2166, N'230.9', N'CARCINOMA IN SITU OF OTHER AND UNSPECIFIED DIGESTIVE ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2167, N'231.0', N'CARCINOMA IN SITU OF LARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2168, N'231.1', N'CARCINOMA IN SITU OF TRACHEA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2169, N'231.2', N'CARCINOMA IN SITU OF BRONCHUS AND LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2170, N'231.8', N'CARCINOMA IN SITU OF OTHER SPECIFIED PARTS OF RESPIRATORY SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2171, N'231.9', N'CARCINOMA IN SITU OF RESPIRATORY SYSTEM, PART UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2172, N'232.0', N'CARCINOMA IN SITU OF SKIN OF LIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2173, N'232.1', N'CARCINOMA IN SITU OF EYELID, INCLUDING CANTHUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2174, N'232.2', N'CARCINOMA IN SITU OF SKIN OF EAR AND EXTERNAL AUDITORY CANAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2175, N'232.3', N'CARCINOMA IN SITU OF SKIN OF OTHER AND UNSPECIFIED PARTS OF FACE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2176, N'232.4', N'CARCINOMA IN SITU OF SCALP AND SKIN OF NECK', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2177, N'232.5', N'CARCINOMA IN SITU OF SKIN OF TRUNK, EXCEPT SCROTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2178, N'232.6', N'CARCINOMA IN SITU OF SKIN OF UPPER LIMB, INCLUDING SHOULDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2179, N'232.7', N'CARCINOMA IN SITU OF SKIN OF LOWER LIMB, INCLUDING HIP', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2180, N'232.8', N'CARCINOMA IN SITU OF OTHER SPECIFIED SITES OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2181, N'232.9', N'CARCINOMA IN SITU OF SKIN, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2182, N'233.0', N'CARCINOMA IN SITU OF BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2183, N'233.1', N'CARCINOMA IN SITU OF CERVIX UTERI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2184, N'233.2', N'CARCINOMA IN SITU OF OTHER AND UNSPECIFIED PARTS OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2185, N'233.30', N'CARCINOMA IN SITU, UNSPECIFIED FEMALE GENITAL ORGAN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2186, N'233.31', N'CARCINOMA IN SITU, VAGINA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2187, N'233.32', N'CARCINOMA IN SITU, VULVA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2188, N'233.39', N'CARCINOMA IN SITU, OTHER FEMALE GENITAL ORGAN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2189, N'233.4', N'CARCINOMA IN SITU OF PROSTATE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2190, N'233.5', N'CARCINOMA IN SITU OF PENIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2191, N'233.6', N'CARCINOMA IN SITU OF OTHER AND UNSPECIFIED MALE GENITAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2192, N'233.7', N'CARCINOMA IN SITU OF BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2193, N'233.9', N'CARCINOMA IN SITU OF OTHER AND UNSPECIFIED URINARY ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2194, N'234.0', N'CARCINOMA IN SITU OF EYE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2195, N'234.8', N'CARCINOMA IN SITU OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2196, N'234.9', N'CARCINOMA IN SITU, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2197, N'235.0', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF MAJOR SALIVARY GLANDS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2198, N'235.1', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF LIP, ORAL CAVITY, AND PHARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2199, N'235.2', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF STOMACH, INTESTINES, AND RECTUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2200, N'235.3', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF LIVER AND BILIARY PASSAGES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2201, N'235.4', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF RETROPERITONEUM AND PERITONEUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2202, N'235.5', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OTHER AND UNSPECIFIED DIGESTIVE ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2203, N'235.6', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF LARYNX', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2204, N'235.7', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF TRACHEA, BRONCHUS, AND LUNG', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2205, N'235.8', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF PLEURA, THYMUS, AND MEDIASTINUM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2206, N'235.9', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OTHER AND UNSPECIFIED RESPIRATORY ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2207, N'236.0', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF UTERUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2208, N'236.1', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF PLACENTA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2209, N'236.2', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OVARY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2210, N'236.3', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OTHER AND UNSPECIFIED FEMALE GENITAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2211, N'236.4', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF TESTIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2212, N'236.5', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF PROSTATE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2213, N'236.6', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OTHER AND UNSPECIFIED MALE GENITAL ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2214, N'236.7', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2215, N'236.90', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF URINARY ORGAN, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2216, N'236.91', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF KIDNEY AND URETER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2217, N'236.99', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OTHER AND UNSPECIFIED URINARY ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2218, N'237.0', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF PITUITARY GLAND AND CRANIOPHARYNGEAL DUCT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2219, N'237.1', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF PINEAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2220, N'237.2', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF ADRENAL GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2221, N'237.3', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF PARAGANGLIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 2200 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2222, N'237.4', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OTHER AND UNSPECIFIED ENDOCRINE GLANDS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2223, N'237.5', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF BRAIN AND SPINAL CORD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2224, N'237.6', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF MENINGES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2225, N'237.70', N'NEUROFIBROMATOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2226, N'237.71', N'NEUROFIBROMATOSIS, TYPE 1 [VON RECKLINGHAUSEN''S DISEASE]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2227, N'237.72', N'NEUROFIBROMATOSIS, TYPE 2 [ACOUSTIC NEUROFIBROMATOSIS]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2228, N'237.73', N'SCHWANNOMATOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2229, N'237.79', N'OTHER NEUROFIBROMATOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2230, N'237.9', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OTHER AND UNSPECIFIED PARTS OF NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2231, N'238.0', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF BONE AND ARTICULAR CARTILAGE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2232, N'238.1', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF CONNECTIVE AND OTHER SOFT TISSUE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2233, N'238.2', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2234, N'238.3', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2235, N'238.4', N'POLYCYTHEMIA VERA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2236, N'238.5', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF HISTIOCYTIC AND MAST CELLS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2237, N'238.6', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF PLASMA CELLS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2238, N'238.71', N'ESSENTIAL THROMBOCYTHEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2239, N'238.72', N'LOW GRADE MYELODYSPLASTIC SYNDROME LESIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2240, N'238.73', N'HIGH GRADE MYELODYSPLASTIC SYNDROME LESIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2241, N'238.74', N'MYELODYSPLASTIC SYNDROME WITH 5Q DELETION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2242, N'238.75', N'MYELODYSPLASTIC SYNDROME, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2243, N'238.76', N'MYELOFIBROSIS WITH MYELOID METAPLASIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2244, N'238.77', N'POST-TRANSPLANT LYMPHOPROLIFERATIVE DISORDER (PTLD)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2245, N'238.79', N'OTHER LYMPHATIC AND HEMATOPOIETIC TISSUES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2246, N'238.8', N'NEOPLASM OF UNCERTAIN BEHAVIOR OF OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2247, N'238.9', N'NEOPLASM OF UNCERTAIN BEHAVIOR, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2248, N'239.0', N'NEOPLASM OF UNSPECIFIED NATURE OF DIGESTIVE SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2249, N'239.1', N'NEOPLASM OF UNSPECIFIED NATURE OF RESPIRATORY SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2250, N'239.2', N'NEOPLASM OF UNSPECIFIED NATURE OF BONE, SOFT TISSUE, AND SKIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2251, N'239.3', N'NEOPLASM OF UNSPECIFIED NATURE OF BREAST', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2252, N'239.4', N'NEOPLASM OF UNSPECIFIED NATURE OF BLADDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2253, N'239.5', N'NEOPLASM OF UNSPECIFIED NATURE OF OTHER GENITOURINARY ORGANS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2254, N'239.6', N'NEOPLASM OF UNSPECIFIED NATURE OF BRAIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2255, N'239.7', N'NEOPLASM OF UNSPECIFIED NATURE OF ENDOCRINE GLANDS AND OTHER PARTS OF NERVOUS SYSTEM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2256, N'239.81', N'NEOPLASMS OF UNSPECIFIED NATURE, RETINA AND CHOROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2257, N'239.89', N'NEOPLASMS OF UNSPECIFIED NATURE, OTHER SPECIFIED SITES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2258, N'239.9', N'NEOPLASM OF UNSPECIFIED NATURE, SITE UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2259, N'240.0', N'GOITER, SPECIFIED AS SIMPLE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2260, N'240.9', N'GOITER, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2261, N'241.0', N'NONTOXIC UNINODULAR GOITER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2262, N'241.1', N'NONTOXIC MULTINODULAR GOITER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2263, N'241.9', N'UNSPECIFIED NONTOXIC NODULAR GOITER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2264, N'242.00', N'TOXIC DIFFUSE GOITER WITHOUT MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2265, N'242.01', N'TOXIC DIFFUSE GOITER WITH MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2266, N'242.10', N'TOXIC UNINODULAR GOITER WITHOUT MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2267, N'242.11', N'TOXIC UNINODULAR GOITER WITH MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2268, N'242.20', N'TOXIC MULTINODULAR GOITER WITHOUT MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2269, N'242.21', N'TOXIC MULTINODULAR GOITER WITH MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2270, N'242.30', N'TOXIC NODULAR GOITER, UNSPECIFIED TYPE, WITHOUT MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2271, N'242.31', N'TOXIC NODULAR GOITER, UNSPECIFIED TYPE, WITH MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2272, N'242.40', N'THYROTOXICOSIS FROM ECTOPIC THYROID NODULE WITHOUT MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2273, N'242.41', N'THYROTOXICOSIS FROM ECTOPIC THYROID NODULE WITH MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2274, N'242.80', N'THYROTOXICOSIS OF OTHER SPECIFIED ORIGIN WITHOUT MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2275, N'242.81', N'THYROTOXICOSIS OF OTHER SPECIFIED ORIGIN WITH MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2276, N'242.90', N'THYROTOXICOSIS WITHOUT MENTION OF GOITER OR OTHER CAUSE, AND WITHOUT MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2277, N'242.91', N'THYROTOXICOSIS WITHOUT MENTION OF GOITER OR OTHER CAUSE, WITH MENTION OF THYROTOXIC CRISIS OR STORM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2278, N'243.', N'CONGENITAL HYPOTHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2279, N'244.0', N'POSTSURGICAL HYPOTHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2280, N'244.1', N'OTHER POSTABLATIVE HYPOTHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2281, N'244.2', N'IODINE HYPOTHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2282, N'244.3', N'OTHER IATROGENIC HYPOTHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2283, N'244.8', N'OTHER SPECIFIED ACQUIRED HYPOTHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2284, N'244.9', N'UNSPECIFIED ACQUIRED HYPOTHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2285, N'245.0', N'ACUTE THYROIDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2286, N'245.1', N'SUBACUTE THYROIDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2287, N'245.2', N'CHRONIC LYMPHOCYTIC THYROIDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2288, N'245.3', N'CHRONIC FIBROUS THYROIDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2289, N'245.4', N'IATROGENIC THYROIDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2290, N'245.8', N'OTHER AND UNSPECIFIED CHRONIC THYROIDITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2291, N'245.9', N'THYROIDITIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2292, N'246.0', N'DISORDERS OF THYROCALCITONIN SECRETION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2293, N'246.1', N'DYSHORMONOGENIC GOITER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2294, N'246.2', N'CYST OF THYROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2295, N'246.3', N'HEMORRHAGE AND INFARCTION OF THYROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2296, N'246.8', N'OTHER SPECIFIED DISORDERS OF THYROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2297, N'246.9', N'UNSPECIFIED DISORDER OF THYROID', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2298, N'249.00', N'SECONDARY DIABETES MELLITUS WITHOUT MENTION OF COMPLICATION, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2299, N'249.01', N'SECONDARY DIABETES MELLITUS WITHOUT MENTION OF COMPLICATION, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2300, N'249.10', N'SECONDARY DIABETES MELLITUS WITH KETOACIDOSIS, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2301, N'249.11', N'SECONDARY DIABETES MELLITUS WITH KETOACIDOSIS, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2302, N'249.20', N'SECONDARY DIABETES MELLITUS WITH HYPEROSMOLARITY, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2303, N'249.21', N'SECONDARY DIABETES MELLITUS WITH HYPEROSMOLARITY, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2304, N'249.30', N'SECONDARY DIABETES MELLITUS WITH OTHER COMA, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2305, N'249.31', N'SECONDARY DIABETES MELLITUS WITH OTHER COMA, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2306, N'249.40', N'SECONDARY DIABETES MELLITUS WITH RENAL MANIFESTATIONS, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2307, N'249.41', N'SECONDARY DIABETES MELLITUS WITH RENAL MANIFESTATIONS, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2308, N'249.50', N'SECONDARY DIABETES MELLITUS WITH OPHTHALMIC MANIFESTATIONS, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2309, N'249.51', N'SECONDARY DIABETES MELLITUS WITH OPHTHALMIC MANIFESTATIONS, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2310, N'249.60', N'SECONDARY DIABETES MELLITUS WITH NEUROLOGICAL MANIFESTATIONS, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2311, N'249.61', N'SECONDARY DIABETES MELLITUS WITH NEUROLOGICAL MANIFESTATIONS, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2312, N'249.70', N'SECONDARY DIABETES MELLITUS WITH PERIPHERAL CIRCULATORY DISORDERS, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2313, N'249.71', N'SECONDARY DIABETES MELLITUS WITH PERIPHERAL CIRCULATORY DISORDERS, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2314, N'249.80', N'SECONDARY DIABETES MELLITUS WITH OTHER SPECIFIED MANIFESTATIONS, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2315, N'249.81', N'SECONDARY DIABETES MELLITUS WITH OTHER SPECIFIED MANIFESTATIONS, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2316, N'249.90', N'SECONDARY DIABETES MELLITUS WITH UNSPECIFIED COMPLICATION, NOT STATED AS UNCONTROLLED, OR UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2317, N'249.91', N'SECONDARY DIABETES MELLITUS WITH UNSPECIFIED COMPLICATION, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2318, N'250.00', N'DIABETES MELLITUS WITHOUT MENTION OF COMPLICATION, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2319, N'250.01', N'DIABETES MELLITUS WITHOUT MENTION OF COMPLICATION, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2320, N'250.02', N'DIABETES MELLITUS WITHOUT MENTION OF COMPLICATION, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2321, N'250.03', N'DIABETES MELLITUS WITHOUT MENTION OF COMPLICATION, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2322, N'250.10', N'DIABETES WITH KETOACIDOSIS, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 2300 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2323, N'250.11', N'DIABETES WITH KETOACIDOSIS, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2324, N'250.12', N'DIABETES WITH KETOACIDOSIS, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2325, N'250.13', N'DIABETES WITH KETOACIDOSIS, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2326, N'250.20', N'DIABETES WITH HYPEROSMOLARITY, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2327, N'250.21', N'DIABETES WITH HYPEROSMOLARITY, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2328, N'250.22', N'DIABETES WITH HYPEROSMOLARITY, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2329, N'250.23', N'DIABETES WITH HYPEROSMOLARITY, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2330, N'250.30', N'DIABETES WITH OTHER COMA, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2331, N'250.31', N'DIABETES WITH OTHER COMA, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2332, N'250.32', N'DIABETES WITH OTHER COMA, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2333, N'250.33', N'DIABETES WITH OTHER COMA, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2334, N'250.40', N'DIABETES WITH RENAL MANIFESTATIONS, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2335, N'250.41', N'DIABETES WITH RENAL MANIFESTATIONS, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2336, N'250.42', N'DIABETES WITH RENAL MANIFESTATIONS, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2337, N'250.43', N'DIABETES WITH RENAL MANIFESTATIONS, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2338, N'250.50', N'DIABETES WITH OPHTHALMIC MANIFESTATIONS, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2339, N'250.51', N'DIABETES WITH OPHTHALMIC MANIFESTATIONS, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2340, N'250.52', N'DIABETES WITH OPHTHALMIC MANIFESTATIONS, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2341, N'250.53', N'DIABETES WITH OPHTHALMIC MANIFESTATIONS, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2342, N'250.60', N'DIABETES WITH NEUROLOGICAL MANIFESTATIONS, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2343, N'250.61', N'DIABETES WITH NEUROLOGICAL MANIFESTATIONS, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2344, N'250.62', N'DIABETES WITH NEUROLOGICAL MANIFESTATIONS, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2345, N'250.63', N'DIABETES WITH NEUROLOGICAL MANIFESTATIONS, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2346, N'250.70', N'DIABETES WITH PERIPHERAL CIRCULATORY DISORDERS, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2347, N'250.71', N'DIABETES WITH PERIPHERAL CIRCULATORY DISORDERS, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2348, N'250.72', N'DIABETES WITH PERIPHERAL CIRCULATORY DISORDERS, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2349, N'250.73', N'DIABETES WITH PERIPHERAL CIRCULATORY DISORDERS, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2350, N'250.80', N'DIABETES WITH OTHER SPECIFIED MANIFESTATIONS, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2351, N'250.81', N'DIABETES WITH OTHER SPECIFIED MANIFESTATIONS, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2352, N'250.82', N'DIABETES WITH OTHER SPECIFIED MANIFESTATIONS, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2353, N'250.83', N'DIABETES WITH OTHER SPECIFIED MANIFESTATIONS, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2354, N'250.90', N'DIABETES WITH UNSPECIFIED COMPLICATION, TYPE II OR UNSPECIFIED TYPE, NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2355, N'250.91', N'DIABETES WITH UNSPECIFIED COMPLICATION, TYPE I [JUVENILE TYPE], NOT STATED AS UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2356, N'250.92', N'DIABETES WITH UNSPECIFIED COMPLICATION, TYPE II OR UNSPECIFIED TYPE, UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2357, N'250.93', N'DIABETES WITH UNSPECIFIED COMPLICATION, TYPE I [JUVENILE TYPE], UNCONTROLLED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2358, N'251.0', N'HYPOGLYCEMIC COMA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2359, N'251.1', N'OTHER SPECIFIED HYPOGLYCEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2360, N'251.2', N'HYPOGLYCEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2361, N'251.3', N'POSTSURGICAL HYPOINSULINEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2362, N'251.4', N'ABNORMALITY OF SECRETION OF GLUCAGON', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2363, N'251.5', N'ABNORMALITY OF SECRETION OF GASTRIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2364, N'251.8', N'OTHER SPECIFIED DISORDERS OF PANCREATIC INTERNAL SECRETION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2365, N'251.9', N'UNSPECIFIED DISORDER OF PANCREATIC INTERNAL SECRETION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2366, N'252.00', N'HYPERPARATHYROIDISM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2367, N'252.01', N'PRIMARY HYPERPARATHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2368, N'252.02', N'SECONDARY HYPERPARATHYROIDISM, NON-RENAL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2369, N'252.08', N'OTHER HYPERPARATHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2370, N'252.1', N'HYPOPARATHYROIDISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2371, N'252.8', N'OTHER SPECIFIED DISORDERS OF PARATHYROID GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2372, N'252.9', N'UNSPECIFIED DISORDER OF PARATHYROID GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2373, N'253.0', N'ACROMEGALY AND GIGANTISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2374, N'253.1', N'OTHER AND UNSPECIFIED ANTERIOR PITUITARY HYPERFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2375, N'253.2', N'PANHYPOPITUITARISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2376, N'253.3', N'PITUITARY DWARFISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2377, N'253.4', N'OTHER ANTERIOR PITUITARY DISORDERS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2378, N'253.5', N'DIABETES INSIPIDUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2379, N'253.6', N'OTHER DISORDERS OF NEUROHYPOPHYSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2380, N'253.7', N'IATROGENIC PITUITARY DISORDERS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2381, N'253.8', N'OTHER DISORDERS OF THE PITUITARY AND OTHER SYNDROMES OF DIENCEPHALOHYPOPHYSEAL ORIGIN', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2382, N'253.9', N'UNSPECIFIED DISORDER OF THE PITUITARY GLAND AND ITS HYPOTHALAMIC CONTROL', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2383, N'254.0', N'PERSISTENT HYPERPLASIA OF THYMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2384, N'254.1', N'ABSCESS OF THYMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2385, N'254.8', N'OTHER SPECIFIED DISEASES OF THYMUS GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2386, N'254.9', N'UNSPECIFIED DISEASE OF THYMUS GLAND', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2387, N'255.0', N'CUSHING''S SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2388, N'255.10', N'HYPERALDOSTERONISM, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2389, N'255.11', N'GLUCOCORTICOID-REMEDIABLE ALDOSTERONISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2390, N'255.12', N'CONN''S SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2391, N'255.13', N'BARTTER''S SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2392, N'255.14', N'OTHER SECONDARY ALDOSTERONISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2393, N'255.2', N'ADRENOGENITAL DISORDERS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2394, N'255.3', N'OTHER CORTICOADRENAL OVERACTIVITY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2395, N'255.41', N'GLUCOCORTICOID DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2396, N'255.42', N'MINERALOCORTICOID DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2397, N'255.5', N'OTHER ADRENAL HYPOFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2398, N'255.6', N'MEDULLOADRENAL HYPERFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2399, N'255.8', N'OTHER SPECIFIED DISORDERS OF ADRENAL GLANDS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2400, N'255.9', N'UNSPECIFIED DISORDER OF ADRENAL GLANDS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2401, N'256.0', N'HYPERESTROGENISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2402, N'256.1', N'OTHER OVARIAN HYPERFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2403, N'256.2', N'POSTABLATIVE OVARIAN FAILURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2404, N'256.31', N'PREMATURE MENOPAUSE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2405, N'256.39', N'OTHER OVARIAN FAILURE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2406, N'256.4', N'POLYCYSTIC OVARIES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2407, N'256.8', N'OTHER OVARIAN DYSFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2408, N'256.9', N'UNSPECIFIED OVARIAN DYSFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2409, N'257.0', N'TESTICULAR HYPERFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2410, N'257.1', N'POSTABLATIVE TESTICULAR HYPOFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2411, N'257.2', N'OTHER TESTICULAR HYPOFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2412, N'257.8', N'OTHER TESTICULAR DYSFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2413, N'257.9', N'UNSPECIFIED TESTICULAR DYSFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2414, N'258.01', N'MULTIPLE ENDOCRINE NEOPLASIA [MEN] TYPE I', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2415, N'258.02', N'MULTIPLE ENDOCRINE NEOPLASIA [MEN] TYPE IIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2416, N'258.03', N'MULTIPLE ENDOCRINE NEOPLASIA [MEN] TYPE IIB', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2417, N'258.1', N'OTHER COMBINATIONS OF ENDOCRINE DYSFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2418, N'258.8', N'OTHER SPECIFIED POLYGLANDULAR DYSFUNCTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2419, N'258.9', N'POLYGLANDULAR DYSFUNCTION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2420, N'259.0', N'DELAY IN SEXUAL DEVELOPMENT AND PUBERTY, NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2421, N'259.1', N'PRECOCIOUS SEXUAL DEVELOPMENT AND PUBERTY, NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2422, N'259.2', N'CARCINOID SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2423, N'259.3', N'ECTOPIC HORMONE SECRETION, NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 2400 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2424, N'259.4', N'DWARFISM, NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2425, N'259.50', N'ANDROGEN INSENSITIVITY, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2426, N'259.51', N'ANDROGEN INSENSITIVITY SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2427, N'259.52', N'PARTIAL ANDROGEN INSENSITIVITY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2428, N'259.8', N'OTHER SPECIFIED ENDOCRINE DISORDERS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2429, N'259.9', N'UNSPECIFIED ENDOCRINE DISORDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2430, N'260.', N'KWASHIORKOR', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2431, N'261.', N'NUTRITIONAL MARASMUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2432, N'262.', N'OTHER SEVERE PROTEIN-CALORIE MALNUTRITION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2433, N'263.0', N'MALNUTRITION OF MODERATE DEGREE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2434, N'263.1', N'MALNUTRITION OF MILD DEGREE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2435, N'263.2', N'ARRESTED DEVELOPMENT FOLLOWING PROTEIN-CALORIE MALNUTRITION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2436, N'263.8', N'OTHER PROTEIN-CALORIE MALNUTRITION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2437, N'263.9', N'UNSPECIFIED PROTEIN-CALORIE MALNUTRITION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2438, N'264.0', N'VITAMIN A DEFICIENCY WITH CONJUNCTIVAL XEROSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2439, N'264.1', N'VITAMIN A DEFICIENCY WITH CONJUNCTIVAL XEROSIS AND BITOT''S SPOT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2440, N'264.2', N'VITAMIN A DEFICIENCY WITH CORNEAL XEROSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2441, N'264.3', N'VITAMIN A DEFICIENCY WITH CORNEAL ULCERATION AND XEROSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2442, N'264.4', N'VITAMIN A DEFICIENCY WITH KERATOMALACIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2443, N'264.5', N'VITAMIN A DEFICIENCY WITH NIGHT BLINDNESS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2444, N'264.6', N'VITAMIN A DEFICIENCY WITH XEROPHTHALMIC SCARS OF CORNEA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2445, N'264.7', N'OTHER OCULAR MANIFESTATIONS OF VITAMIN A DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2446, N'264.8', N'OTHER MANIFESTATIONS OF VITAMIN A DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2447, N'264.9', N'UNSPECIFIED VITAMIN A DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2448, N'265.0', N'BERIBERI', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2449, N'265.1', N'OTHER AND UNSPECIFIED MANIFESTATIONS OF THIAMINE DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2450, N'265.2', N'PELLAGRA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2451, N'266.0', N'ARIBOFLAVINOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2452, N'266.1', N'VITAMIN B6 DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2453, N'266.2', N'OTHER B-COMPLEX DEFICIENCIES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2454, N'266.9', N'UNSPECIFIED VITAMIN B DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2455, N'267.', N'ASCORBIC ACID DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2456, N'268.0', N'RICKETS, ACTIVE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2457, N'268.1', N'RICKETS, LATE EFFECT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2458, N'268.2', N'OSTEOMALACIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2459, N'268.9', N'UNSPECIFIED VITAMIN D DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2460, N'269.0', N'DEFICIENCY OF VITAMIN K', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2461, N'269.1', N'DEFICIENCY OF OTHER VITAMINS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2462, N'269.2', N'UNSPECIFIED VITAMIN DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2463, N'269.3', N'MINERAL DEFICIENCY, NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2464, N'269.8', N'OTHER NUTRITIONAL DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2465, N'269.9', N'UNSPECIFIED NUTRITIONAL DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2466, N'270.0', N'DISTURBANCES OF AMINO-ACID TRANSPORT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2467, N'270.1', N'PHENYLKETONURIA [PKU]', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2468, N'270.2', N'OTHER DISTURBANCES OF AROMATIC AMINO-ACID METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2469, N'270.3', N'DISTURBANCES OF BRANCHED-CHAIN AMINO-ACID METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2470, N'270.4', N'DISTURBANCES OF SULPHUR-BEARING AMINO-ACID METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2471, N'270.5', N'DISTURBANCES OF HISTIDINE METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2472, N'270.6', N'DISORDERS OF UREA CYCLE METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2473, N'270.7', N'OTHER DISTURBANCES OF STRAIGHT-CHAIN AMINO-ACID METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2474, N'270.8', N'OTHER SPECIFIED DISORDERS OF AMINO-ACID METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2475, N'270.9', N'UNSPECIFIED DISORDER OF AMINO-ACID METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2476, N'271.0', N'GLYCOGENOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2477, N'271.1', N'GALACTOSEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2478, N'271.2', N'HEREDITARY FRUCTOSE INTOLERANCE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2479, N'271.3', N'INTESTINAL DISACCHARIDASE DEFICIENCIES AND DISACCHARIDE MALABSORPTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2480, N'271.4', N'RENAL GLYCOSURIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2481, N'271.8', N'OTHER SPECIFIED DISORDERS OF CARBOHYDRATE TRANSPORT AND METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2482, N'271.9', N'UNSPECIFIED DISORDER OF CARBOHYDRATE TRANSPORT AND METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2483, N'272.0', N'PURE HYPERCHOLESTEROLEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2484, N'272.1', N'PURE HYPERGLYCERIDEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2485, N'272.2', N'MIXED HYPERLIPIDEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2486, N'272.3', N'HYPERCHYLOMICRONEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2487, N'272.4', N'OTHER AND UNSPECIFIED HYPERLIPIDEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2488, N'272.5', N'LIPOPROTEIN DEFICIENCIES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2489, N'272.6', N'LIPODYSTROPHY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2490, N'272.7', N'LIPIDOSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2491, N'272.8', N'OTHER DISORDERS OF LIPOID METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2492, N'272.9', N'UNSPECIFIED DISORDER OF LIPOID METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2493, N'273.0', N'POLYCLONAL HYPERGAMMAGLOBULINEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2494, N'273.1', N'MONOCLONAL PARAPROTEINEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2495, N'273.2', N'OTHER PARAPROTEINEMIAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2496, N'273.3', N'MACROGLOBULINEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2497, N'273.4', N'ALPHA-1-ANTITRYPSIN DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2498, N'273.8', N'OTHER DISORDERS OF PLASMA PROTEIN METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2499, N'273.9', N'UNSPECIFIED DISORDER OF PLASMA PROTEIN METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2500, N'274.00', N'GOUTY ARTHROPATHY, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2501, N'274.01', N'ACUTE GOUTY ARTHROPATHY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2502, N'274.02', N'CHRONIC GOUTY ARTHROPATHY WITHOUT MENTION OF TOPHUS (TOPHI)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2503, N'274.03', N'CHRONIC GOUTY ARTHROPATHY WITH TOPHUS (TOPHI)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2504, N'274.10', N'GOUTY NEPHROPATHY, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2505, N'274.11', N'URIC ACID NEPHROLITHIASIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2506, N'274.19', N'OTHER GOUTY NEPHROPATHY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2507, N'274.81', N'GOUTY TOPHI OF EAR', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2508, N'274.82', N'GOUTY TOPHI OF OTHER SITES, EXCEPT EAR', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2509, N'274.89', N'GOUT WITH OTHER SPECIFIED MANIFESTATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2510, N'274.9', N'GOUT, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2511, N'275.01', N'HEREDITARY HEMOCHROMATOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2512, N'275.02', N'HEMOCHROMATOSIS DUE TO REPEATED RED BLOOD CELL TRANSFUSIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2513, N'275.03', N'OTHER HEMOCHROMATOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2514, N'275.09', N'OTHER DISORDERS OF IRON METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2515, N'275.1', N'DISORDERS OF COPPER METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2516, N'275.2', N'DISORDERS OF MAGNESIUM METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2517, N'275.3', N'DISORDERS OF PHOSPHORUS METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2518, N'275.40', N'UNSPECIFIED DISORDER OF CALCIUM METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2519, N'275.41', N'HYPOCALCEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2520, N'275.42', N'HYPERCALCEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2521, N'275.49', N'OTHER DISORDERS OF CALCIUM METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2522, N'275.5', N'HUNGRY BONE SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2523, N'275.8', N'OTHER SPECIFIED DISORDERS OF MINERAL METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2524, N'275.9', N'UNSPECIFIED DISORDER OF MINERAL METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 2500 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2525, N'276.0', N'HYPEROSMOLALITY AND/OR HYPERNATREMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2526, N'276.1', N'HYPOSMOLALITY AND/OR HYPONATREMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2527, N'276.2', N'ACIDOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2528, N'276.3', N'ALKALOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2529, N'276.4', N'MIXED ACID-BASE BALANCE DISORDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2530, N'276.50', N'VOLUME DEPLETION, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2531, N'276.51', N'DEHYDRATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2532, N'276.52', N'HYPOVOLEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2533, N'276.61', N'TRANSFUSION ASSOCIATED CIRCULATORY OVERLOAD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2534, N'276.69', N'OTHER FLUID OVERLOAD', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2535, N'276.7', N'HYPERPOTASSEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2536, N'276.8', N'HYPOPOTASSEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2537, N'276.9', N'ELECTROLYTE AND FLUID DISORDERS NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2538, N'277.00', N'CYSTIC FIBROSIS WITHOUT MENTION OF MECONIUM ILEUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2539, N'277.01', N'CYSTIC FIBROSIS WITH MECONIUM ILEUS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2540, N'277.02', N'CYSTIC FIBROSIS WITH PULMONARY MANIFESTATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2541, N'277.03', N'CYSTIC FIBROSIS WITH GASTROINTESTINAL MANIFESTATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2542, N'277.09', N'CYSTIC FIBROSIS WITH OTHER MANIFESTATIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2543, N'277.1', N'DISORDERS OF PORPHYRIN METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2544, N'277.2', N'OTHER DISORDERS OF PURINE AND PYRIMIDINE METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2545, N'277.30', N'AMYLOIDOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2546, N'277.31', N'FAMILIAL MEDITERRANEAN FEVER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2547, N'277.39', N'OTHER AMYLOIDOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2548, N'277.4', N'DISORDERS OF BILIRUBIN EXCRETION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2549, N'277.5', N'MUCOPOLYSACCHARIDOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2550, N'277.6', N'OTHER DEFICIENCIES OF CIRCULATING ENZYMES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2551, N'277.7', N'DYSMETABOLIC SYNDROME X', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2552, N'277.81', N'PRIMARY CARNITINE DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2553, N'277.82', N'CARNITINE DEFICIENCY DUE TO INBORN ERRORS OF METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2554, N'277.83', N'IATROGENIC CARNITINE DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2555, N'277.84', N'OTHER SECONDARY CARNITINE DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2556, N'277.85', N'DISORDERS OF FATTY ACID OXIDATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2557, N'277.86', N'PEROXISOMAL DISORDERS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2558, N'277.87', N'DISORDERS OF MITOCHONDRIAL METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2559, N'277.88', N'TUMOR LYSIS SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2560, N'277.89', N'OTHER SPECIFIED DISORDERS OF METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2561, N'277.9', N'UNSPECIFIED DISORDER OF METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2562, N'278.00', N'OBESITY, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2563, N'278.01', N'MORBID OBESITY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2564, N'278.02', N'OVERWEIGHT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2565, N'278.03', N'OBESITY HYPOVENTILATION SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2566, N'278.1', N'LOCALIZED ADIPOSITY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2567, N'278.2', N'HYPERVITAMINOSIS A', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2568, N'278.3', N'HYPERCAROTINEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2569, N'278.4', N'HYPERVITAMINOSIS D', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2570, N'278.8', N'OTHER HYPERALIMENTATION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2571, N'279.00', N'HYPOGAMMAGLOBULINEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2572, N'279.01', N'SELECTIVE IGA IMMUNODEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2573, N'279.02', N'SELECTIVE IGM IMMUNODEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2574, N'279.03', N'OTHER SELECTIVE IMMUNOGLOBULIN DEFICIENCIES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2575, N'279.04', N'CONGENITAL HYPOGAMMAGLOBULINEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2576, N'279.05', N'IMMUNODEFICIENCY WITH INCREASED IGM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2577, N'279.06', N'COMMON VARIABLE IMMUNODEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2578, N'279.09', N'OTHER DEFICIENCY OF HUMORAL IMMUNITY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2579, N'279.10', N'IMMUNODEFICIENCY WITH PREDOMINANT T-CELL DEFECT, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2580, N'279.11', N'DIGEORGE''S SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2581, N'279.12', N'WISKOTT-ALDRICH SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2582, N'279.13', N'NEZELOF''S SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2583, N'279.19', N'OTHER DEFICIENCY OF CELL-MEDIATED IMMUNITY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2584, N'279.2', N'COMBINED IMMUNITY DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2585, N'279.3', N'UNSPECIFIED IMMUNITY DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2586, N'279.41', N'AUTOIMMUNE LYMPHOPROLIFERATIVE SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2587, N'279.49', N'AUTOIMMUNE DISEASE, NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2588, N'279.50', N'GRAFT-VERSUS-HOST DISEASE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2589, N'279.51', N'ACUTE GRAFT-VERSUS-HOST DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2590, N'279.52', N'CHRONIC GRAFT-VERSUS-HOST DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2591, N'279.53', N'ACUTE ON CHRONIC GRAFT-VERSUS-HOST DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2592, N'279.8', N'OTHER SPECIFIED DISORDERS INVOLVING THE IMMUNE MECHANISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2593, N'279.9', N'UNSPECIFIED DISORDER OF IMMUNE MECHANISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2594, N'280.0', N'IRON DEFICIENCY ANEMIA SECONDARY TO BLOOD LOSS (CHRONIC)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2595, N'280.1', N'IRON DEFICIENCY ANEMIA SECONDARY TO INADEQUATE DIETARY IRON INTAKE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2596, N'280.8', N'OTHER SPECIFIED IRON DEFICIENCY ANEMIAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2597, N'280.9', N'IRON DEFICIENCY ANEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2598, N'281.0', N'PERNICIOUS ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2599, N'281.1', N'OTHER VITAMIN B12 DEFICIENCY ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2600, N'281.2', N'FOLATE-DEFICIENCY ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2601, N'281.3', N'OTHER SPECIFIED MEGALOBLASTIC ANEMIAS NOT ELSEWHERE CLASSIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2602, N'281.4', N'PROTEIN-DEFICIENCY ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2603, N'281.8', N'ANEMIA ASSOCIATED WITH OTHER SPECIFIED NUTRITIONAL DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2604, N'281.9', N'UNSPECIFIED DEFICIENCY ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2605, N'282.0', N'HEREDITARY SPHEROCYTOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2606, N'282.1', N'HEREDITARY ELLIPTOCYTOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2607, N'282.2', N'ANEMIAS DUE TO DISORDERS OF GLUTATHIONE METABOLISM', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2608, N'282.3', N'OTHER HEMOLYTIC ANEMIAS DUE TO ENZYME DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2609, N'282.40', N'THALASSEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2610, N'282.41', N'SICKLE-CELL THALASSEMIA WITHOUT CRISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2611, N'282.42', N'SICKLE-CELL THALASSEMIA WITH CRISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2612, N'282.43', N'ALPHA THALASSEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2613, N'282.44', N'BETA THALASSEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2614, N'282.45', N'DELTA-BETA THALASSEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2615, N'282.46', N'THALASSEMIA MINOR', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2616, N'282.47', N'HEMOGLOBIN E-BETA THALASSEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2617, N'282.49', N'OTHER THALASSEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2618, N'282.5', N'SICKLE-CELL TRAIT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2619, N'282.60', N'SICKLE-CELL DISEASE, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2620, N'282.61', N'HB-SS DISEASE WITHOUT CRISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2621, N'282.62', N'HB-SS DISEASE WITH CRISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2622, N'282.63', N'SICKLE-CELL/HB-C DISEASE WITHOUT CRISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2623, N'282.64', N'SICKLE-CELL/HB-C DISEASE WITH CRISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2624, N'282.68', N'OTHER SICKLE-CELL DISEASE WITHOUT CRISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2625, N'282.69', N'OTHER SICKLE-CELL DISEASE WITH CRISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
GO
print 'Processed 2600 total records'
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2626, N'282.7', N'OTHER HEMOGLOBINOPATHIES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2627, N'282.8', N'OTHER SPECIFIED HEREDITARY HEMOLYTIC ANEMIAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2628, N'282.9', N'HEREDITARY HEMOLYTIC ANEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2629, N'283.0', N'AUTOIMMUNE HEMOLYTIC ANEMIAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2630, N'283.10', N'NON-AUTOIMMUNE HEMOLYTIC ANEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2631, N'283.11', N'HEMOLYTIC-UREMIC SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2632, N'283.19', N'OTHER NON-AUTOIMMUNE HEMOLYTIC ANEMIAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2633, N'283.2', N'HEMOGLOBINURIA DUE TO HEMOLYSIS FROM EXTERNAL CAUSES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2634, N'283.9', N'ACQUIRED HEMOLYTIC ANEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2635, N'284.01', N'CONSTITUTIONAL RED BLOOD CELL APLASIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2636, N'284.09', N'OTHER CONSTITUTIONAL APLASTIC ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2637, N'284.11', N'ANTINEOPLASTIC CHEMOTHERAPY INDUCED PANCYTOPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2638, N'284.12', N'OTHER DRUG-INDUCED PANCYTOPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2639, N'284.19', N'OTHER PANCYTOPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2640, N'284.2', N'MYELOPHTHISIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2641, N'284.81', N'RED CELL APLASIA (ACQUIRED)(ADULT)(WITH THYMOMA)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2642, N'284.89', N'OTHER SPECIFIED APLASTIC ANEMIAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2643, N'284.9', N'APLASTIC ANEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2644, N'285.0', N'SIDEROBLASTIC ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2645, N'285.1', N'ACUTE POSTHEMORRHAGIC ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2646, N'285.21', N'ANEMIA IN CHRONIC KIDNEY DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2647, N'285.22', N'ANEMIA IN NEOPLASTIC DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2648, N'285.29', N'ANEMIA OF OTHER CHRONIC DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2649, N'285.3', N'ANTINEOPLASTIC CHEMOTHERAPY INDUCED ANEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2650, N'285.8', N'OTHER SPECIFIED ANEMIAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2651, N'285.9', N'ANEMIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2652, N'286.0', N'CONGENITAL FACTOR VIII DISORDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2653, N'286.1', N'CONGENITAL FACTOR IX DISORDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2654, N'286.2', N'CONGENITAL FACTOR XI DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2655, N'286.3', N'CONGENITAL DEFICIENCY OF OTHER CLOTTING FACTORS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2656, N'286.4', N'VON WILLEBRAND''S DISEASE', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2657, N'286.52', N'ACQUIRED HEMOPHILIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2658, N'286.53', N'ANTIPHOSPHOLIPID ANTIBODY WITH HEMORRHAGIC DISORDER', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2659, N'286.59', N'OTHER HEMORRHAGIC DISORDER DUE TO INTRINSIC CIRCULATING ANTICOAGULANTS, ANTIBODIES, OR INHIBITORS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2660, N'286.6', N'DEFIBRINATION SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2661, N'286.7', N'ACQUIRED COAGULATION FACTOR DEFICIENCY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2662, N'286.9', N'OTHER AND UNSPECIFIED COAGULATION DEFECTS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2663, N'287.0', N'ALLERGIC PURPURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2664, N'287.1', N'QUALITATIVE PLATELET DEFECTS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2665, N'287.2', N'OTHER NONTHROMBOCYTOPENIC PURPURAS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2666, N'287.30', N'PRIMARY THROMBOCYTOPENIA,UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2667, N'287.31', N'IMMUNE THROMBOCYTOPENIC PURPURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2668, N'287.32', N'EVANS'' SYNDROME', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2669, N'287.33', N'CONGENITAL AND HEREDITARY THROMBOCYTOPENIC PURPURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2670, N'287.39', N'OTHER PRIMARY THROMBOCYTOPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2671, N'287.41', N'POSTTRANSFUSION PURPURA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2672, N'287.49', N'OTHER SECONDARY THROMBOCYTOPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2673, N'287.5', N'THROMBOCYTOPENIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2674, N'287.8', N'OTHER SPECIFIED HEMORRHAGIC CONDITIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2675, N'287.9', N'UNSPECIFIED HEMORRHAGIC CONDITIONS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2676, N'288.00', N'NEUTROPENIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2677, N'288.01', N'CONGENITAL NEUTROPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2678, N'288.02', N'CYCLIC NEUTROPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2679, N'288.03', N'DRUG INDUCED NEUTROPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2680, N'288.04', N'NEUTROPENIA DUE TO INFECTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2681, N'288.09', N'OTHER NEUTROPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2682, N'288.1', N'FUNCTIONAL DISORDERS OF POLYMORPHONUCLEAR NEUTROPHILS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2683, N'288.2', N'GENETIC ANOMALIES OF LEUKOCYTES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2684, N'288.3', N'EOSINOPHILIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2685, N'288.4', N'HEMOPHAGOCYTIC SYNDROMES', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2686, N'288.50', N'LEUKOCYTOPENIA, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2687, N'288.51', N'LYMPHOCYTOPENIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2688, N'288.59', N'OTHER DECREASED WHITE BLOOD CELL COUNT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2689, N'288.60', N'LEUKOCYTOSIS, UNSPECIFIED', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2690, N'288.61', N'LYMPHOCYTOSIS (SYMPTOMATIC)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2691, N'288.62', N'LEUKEMOID REACTION', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2692, N'288.63', N'MONOCYTOSIS (SYMPTOMATIC)', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2693, N'288.64', N'PLASMACYTOSIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2694, N'288.65', N'BASOPHILIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2695, N'288.66', N'BANDEMIA', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2696, N'288.69', N'OTHER ELEVATED WHITE BLOOD CELL COUNT', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2697, N'288.8', N'OTHER SPECIFIED DISEASE OF WHITE BLOOD CELLS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2698, N'288.9', N'UNSPECIFIED DISEASE OF WHITE BLOOD CELLS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2699, N'289.0', N'POLYCYTHEMIA, SECONDARY', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2700, N'289.1', N'CHRONIC LYMPHADENITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2701, N'289.2', N'NONSPECIFIC MESENTERIC LYMPHADENITIS', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F AS DateTime), CAST(0x0000A20000A7F88F AS DateTime))
INSERT [dbo].[STD_ICD_CODE] ([ICD_CODE_ID], [CODE], [CODE_DESCRIPTION], [CODESET], [DVEIR_FLAG], [EFR_FLAG], [TBI_FLAG], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) VALUES (2702, N'289.3', N'LYMPHADENITIS, UNSPECIFIED, EXCEPT MESENTERIC', N'9         ', 1, 0, 0, N'CMS', N'CMS', CAST(0x0000A20000A7F88F A