
/*
	Sherry Wang - 9/10/2013 - Rollback scripts for 06.04.002.20709.
*/

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_DIAGDTLETL_ENCOUNTER]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_DIAG_DTL_ETL]'))
ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL] DROP CONSTRAINT [FK_ER_DIAGDTLETL_ENCOUNTER]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_ERDIAGDTLETL_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL] DROP CONSTRAINT [DF_ERDIAGDTLETL_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_ERDIAGDTLETL_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL] DROP CONSTRAINT [DF_ERDIAGDTLETL_UPDATED]
END

GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_ENCOUNTER_ETL_PROVIDER]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_ENCOUNTER_ETL]'))
ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL] DROP CONSTRAINT [FK_ER_ENCOUNTER_ETL_PROVIDER]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_ENCOUNTER_ETL_REFERRAL]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_ENCOUNTER_ETL]'))
ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL] DROP CONSTRAINT [FK_ER_ENCOUNTER_ETL_REFERRAL]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_ENCOUNTER_ETL_CREATE]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL] DROP CONSTRAINT [DF_ENCOUNTER_ETL_CREATE]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_ENCOUNTER_ETL_UPDATE]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL] DROP CONSTRAINT [DF_ENCOUNTER_ETL_UPDATE]
END

GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_EXAM_ETL_ER_ENCOUNTER]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_EXAM_ETL]'))
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [FK_ER_EXAM_ETL_ER_ENCOUNTER]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_EXAM_ETL_PATIENT]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_EXAM_ETL]'))
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [FK_ER_EXAM_ETL_PATIENT]
GO

IF  EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[DVEIR].[EXAM_ETL_LEFT_UNKNOWN_FLAG]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_EXAM_ETL]'))
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [EXAM_ETL_LEFT_UNKNOWN_FLAG]
GO

IF  EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[DVEIR].[EXAM_ETL_RIGHT_UNKNOWN_FLAG]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_EXAM_ETL]'))
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [EXAM_ETL_RIGHT_UNKNOWN_FLAG]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_ER_EXAM_ETL_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [DF_ER_EXAM_ETL_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_ER_EXAM_ETL_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [DF_ER_EXAM_ETL_UPDATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_EXAM_ETL_LEFT_UNKNOWN_FLAG]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [DF_EXAM_ETL_LEFT_UNKNOWN_FLAG]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_EXAM_ETL_RIGHT_UNKNOWN_FLAG]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [DF_EXAM_ETL_RIGHT_UNKNOWN_FLAG]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_EXAM_ETL_LEFT_CONFRONTATION_PERFORMED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [DF_EXAM_ETL_LEFT_CONFRONTATION_PERFORMED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_EXAM_ETL_RIGHT_CONFRONTATION_PERFORMED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_EXAM_ETL] DROP CONSTRAINT [DF_EXAM_ETL_RIGHT_CONFRONTATION_PERFORMED]
END

GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[EROUTCOMEETL_STDERVSNST_FK]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_OUTCOME_ETL]'))
ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] DROP CONSTRAINT [EROUTCOMEETL_STDERVSNST_FK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_OUTCOME_ETL_ER_ENCOUNTER]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_OUTCOME_ETL]'))
ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] DROP CONSTRAINT [FK_ER_OUTCOME_ETL_ER_ENCOUNTER]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_OUTCOME_ETL_PATIENT]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_OUTCOME_ETL]'))
ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] DROP CONSTRAINT [FK_ER_OUTCOME_ETL_PATIENT]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_OUTCOME_ETL_VFQ]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_OUTCOME_ETL]'))
ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] DROP CONSTRAINT [FK_ER_OUTCOME_ETL_VFQ]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_ER_UTCOMEETL_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] DROP CONSTRAINT [DF_ER_UTCOMEETL_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_ER_UTCOMEETL_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] DROP CONSTRAINT [DF_ER_UTCOMEETL_UPDATED]
END

GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[DVEIR].[FK_ER_PROCEDUREDTLETL_ENCOUNTER]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_PROCEDURE_DTL_ETL]'))
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] DROP CONSTRAINT [FK_ER_PROCEDUREDTLETL_ENCOUNTER]
GO

IF  EXISTS (SELECT * FROM sys.check_constraints WHERE object_id = OBJECT_ID(N'[DVEIR].[PROC_DTL_ETL_ICD9_FLAG]') AND parent_object_id = OBJECT_ID(N'[DVEIR].[ER_PROCEDURE_DTL_ETL]'))
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] DROP CONSTRAINT [PROC_DTL_ETL_ICD9_FLAG]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_PROCEDUREDTLETL_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] DROP CONSTRAINT [DF_PROCEDUREDTLETL_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_PROCEDUREDTLETL_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] DROP CONSTRAINT [DF_PROCEDUREDTLETL_UPDATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_PROCEDUREDTLETL_ICD9_FLAG]') AND type = 'D')
BEGIN
ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] DROP CONSTRAINT [DF_PROCEDUREDTLETL_ICD9_FLAG]
END

GO


/****** Object:  Table [DVEIR].[ER_DIAG_DTL_ETL]    Script Date: 10/26/2011 09:48:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DVEIR].[ER_DIAG_DTL_ETL]') AND type in (N'U'))
DROP TABLE [DVEIR].[ER_DIAG_DTL_ETL]
GO

/****** Object:  Table [DVEIR].[ER_ENCOUNTER_ETL]    Script Date: 10/26/2011 09:48:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DVEIR].[ER_ENCOUNTER_ETL]') AND type in (N'U'))
DROP TABLE [DVEIR].[ER_ENCOUNTER_ETL]
GO

/****** Object:  Table [DVEIR].[ER_EXAM_ETL]    Script Date: 10/26/2011 09:48:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DVEIR].[ER_EXAM_ETL]') AND type in (N'U'))
DROP TABLE [DVEIR].[ER_EXAM_ETL]
GO

/****** Object:  Table [DVEIR].[ER_OUTCOME_ETL]    Script Date: 10/26/2011 09:48:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DVEIR].[ER_OUTCOME_ETL]') AND type in (N'U'))
DROP TABLE [DVEIR].[ER_OUTCOME_ETL]
GO

/****** Object:  Table [DVEIR].[ER_PROCEDURE_DTL_ETL]    Script Date: 10/26/2011 09:48:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DVEIR].[ER_PROCEDURE_DTL_ETL]') AND type in (N'U'))
DROP TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL]
GO



/****** Object:  Table [DVEIR].[ER_DIAG_DTL_ETL]    Script Date: 10/26/2011 09:48:54 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING OFF
GO

CREATE TABLE [DVEIR].[ER_DIAG_DTL_ETL](
	[ER_DIAG_DTL_ID] [int] IDENTITY(1,1) NOT NULL,
	[COMMENT_TEXT] [varchar](4000) NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[ER_ENCOUNTER_ID] [int] NULL,
	[CODE] [varchar](50) NULL,
	[DESCRIPTION_TEXT] [varchar](500) NULL,
 CONSTRAINT [ERDIAGDTLETL_PK] PRIMARY KEY CLUSTERED 
(
	[ER_DIAG_DTL_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [DVEIR],
 CONSTRAINT [UNQ_PatientDiagDTLETL] UNIQUE NONCLUSTERED 
(
	[ER_ENCOUNTER_ID] ASC,
	[CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [DVEIR]
) ON [DVEIR]

GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Enter supporting comments for a row of data - such as usually when list value "Other" is checked' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_DIAG_DTL_ETL', @level2type=N'COLUMN',@level2name=N'COMMENT_TEXT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Initial and Final Diagnosis such as:
Periocular Laceration
Lacrimal Laceration
Corneal Burn: Thermal
Corneal Burn: Alkaline
Corneal Burn: Acid
Rupture (if selected, need Length in mm)
Uveal Prolapse 
Can also list ICD 9 codes' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_DIAG_DTL_ETL'
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DVEIR].[ER_ENCOUNTER_ETL]') AND type in (N'U'))
DROP TABLE [DVEIR].[ER_ENCOUNTER_ETL]
GO

CREATE TABLE [DVEIR].[ER_ENCOUNTER_ETL](
	[ER_ENCOUNTER_ID] [int] IDENTITY(1,1) NOT NULL,
	[REFERRAL_ID] [int] NOT NULL,
	[PROVIDER_ID] [int] NULL,
	[STA6A] [varchar](10) NOT NULL,
	[VISIT_DATE] [datetime] NOT NULL,
	[CHIEF_COMPLAINT_TEXT] [varchar](4000) NULL,
	[TBI_IND] [varchar](1) NULL,
	[TBI_READ_PRBLM_IND] [varchar](1) NULL,
	[TBI_DIPLOPIA_IND] [varchar](1) NULL,
	[TBI_DAZZLING_IND] [varchar](1) NULL,
	[TBI_PHOTOPHOBIA_IND] [varchar](1) NULL,
	[OTHER_NEUROLOGICAL_IND] [varchar](1) NULL,
	[NEUROLOGICAL_COMMENT_TEXT] [varchar](4000) NULL,
	[DIAGNOSIS_SUMMARY_COMMENT_TEXT] [varchar](4000) NULL,
	[PROCEDURE_SUMMARY_COMMENT_TEXT] [varchar](4000) NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[CURRENTLY_HOSPITALIZED_IND] [varchar](1) NULL,
	[TBI_EYE_STRAIN_IND] [varchar](1) NULL,
	[TBI_BLURRED_VISION_IND] [varchar](1) NULL,
	[PRIMARYCLINICSTOP] [varchar](10) NULL,
	[PRIMARYCLINICSTOPDESC] [varchar](50) NULL,
	[SendTo_DoD_DVEIR_FLAG] [bit] NULL,
	[Ready_to_Send_to_DVEIR_FLAG] [bit] NULL,
	[UniqueVHAEncounterIDPrimaryKey] varchar(50)NULL,
 CONSTRAINT [ERENCOUNTERETL_PK] PRIMARY KEY CLUSTERED 
(
	[ER_ENCOUNTER_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [DVEIR],
 CONSTRAINT [UNQ_PatientEncounterETL] UNIQUE NONCLUSTERED 
(
	[REFERRAL_ID] ASC,
	[PROVIDER_ID] ASC,
	[STA6A] ASC,
	[UniqueVHAEncounterIDPrimaryKey] ASC,
	[VISIT_DATE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [DVEIR]
) ON [DVEIR]

GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This indicator reflect if the record is ready to be sent to DODDVEIR' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_ENCOUNTER_ETL', @level2type=N'COLUMN',@level2name=N'Ready_to_Send_to_DVEIR_FLAG'
GO



/****** Object:  Table [DVEIR].[ER_EXAM_ETL]    Script Date: 10/26/2011 09:48:54 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING OFF
GO

CREATE TABLE [DVEIR].[ER_EXAM_ETL](
	[ER_EXAM_ID] [int] NOT NULL,
	[PATIENT_ID] [int] NOT NULL,
	[PATIENT_VISIT_COUNT] [int] NULL,
	[LEFT_REFRACTION_NUMBER] [varchar](100) NULL,
	[RIGHT_REFRACTION_NUMBER] [varchar](100) NULL,
	[LEFT_COLOR_RESPONSE_NUMBER] [varchar](100) NULL,
	[RIGHT_COLOR_RESPONSE_NUMBER] [varchar](100) NULL,
	[LEFT_CONFRONTATION_NUMBER] [varchar](100) NULL,
	[RIGHT_CONFRONTATION_NUMBER] [varchar](100) NULL,
	[LEFT_MEAN_DEVIATION_NUMBER] [varchar](100) NULL,
	[RIGHT_MEAN_DEVIATION_NUMBER] [varchar](100) NULL,
	[LEFT_STD_DEVIATION_NUMBER] [varchar](100) NULL,
	[RIGHT_STD_DEVIATION_NUMBER] [varchar](100) NULL,
	[LEFT_FIXATION_LOSS_NUMBER] [varchar](100) NULL,
	[RIGHT_FIXATION_LOSS_NUMBER] [varchar](100) NULL,
	[EXAM_DATE] [datetime] NULL,
	[COMMENT_TEXT] [varchar](4000) NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[LEFT_SPHERE_NUMBER] [varchar](10) NULL,
	[RIGHT_SPHERE_NUMBER] [varchar](10) NULL,
	[LEFT_CYLINDER_NUMBER] [varchar](10) NULL,
	[RIGHT_CYLINDER_NUMBER] [varchar](10) NULL,
	[LEFT_MEAN_DEVIATION_COMMENTS] [varchar](4000) NULL,
	[RIGHT_MEAN_DEVIATION_COMMENTS] [varchar](4000) NULL,
	[LEFT_REFRACTION_UNKNOWN_FLAG] [bit] NOT NULL,
	[RIGHT_REFRACTION_UNKNOWN_FLAG] [bit] NOT NULL,
	[LEFT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS] [varchar](100) NULL,
	[RIGHT_KINETIC_VISUAL_FIELDS_GOLDMAN_COMMENTS] [varchar](100) NULL,
	[LEFT_CONFRONTATION_PERFORMED] [char](1) NULL,
	[RIGHT_CONFRONTATION_PERFORMED] [char](1) NULL,
	[LEFT_CONFRONTATION_STATUS] [varchar](1) NULL,
	[RIGHT_CONFRONTATION_STATUS] [varchar](1) NULL,
	[LEFT_REFERENCE_SCALE] [varchar](1) NULL,
	[RIGHT_REFERENCE_SCALE] [varchar](1) NULL,
 CONSTRAINT [EREXAMETL_PK] PRIMARY KEY CLUSTERED 
(
	[ER_EXAM_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [DVEIR]
) ON [DVEIR]

GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Refraction (**Need to capture for both Right Eye and for Left Eye)	
example +3.00-6.00X045 (3 parts) text (eg. +/-x.xx+/-x.xx@xxx)	for Right Eye (RE)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'LEFT_REFRACTION_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Refraction (**Need to capture for both Right Eye and for Left Eye)	
example +3.00-6.00X045 (3 parts) text (eg. +/-x.xx+/-x.xx@xxx)	for Left Eye (LE)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'RIGHT_REFRACTION_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Color Vision (**Need to capture for both Right Eye and for Left Eye)	Number of correct responses over number of possible responses' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'LEFT_COLOR_RESPONSE_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Color Vision (**Need to capture for both Right Eye and for Left Eye)	Number of correct responses over number of possible responses' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'RIGHT_COLOR_RESPONSE_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Confrontation Visual Fields  (**Need to capture for both Right Eye and for Left Eye)
measured in the horizontal meridian, usually expressed as x degrees; also include comment section to allow free text or diagnosis code of specific field defects' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'LEFT_CONFRONTATION_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Confrontation Visual Fields  (**Need to capture for both Right Eye and for Left Eye)
measured in the horizontal meridian, usually expressed as x degrees; also include comment section to allow free text or diagnosis code of specific field defects' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'RIGHT_CONFRONTATION_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visual Field: 1) Mean deviation  (**Need to capture for both Right Eye and for Left Eye)
for Right Eye (RE)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'LEFT_MEAN_DEVIATION_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visual Field: 1) Mean deviation  (**Need to capture for both Right Eye and for Left Eye)
for Left Eye (LE)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'RIGHT_MEAN_DEVIATION_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visual Field: 2) Pattern standard deviation (**Need to capture for both Right Eye and for Left Eye)
for Right Eye (RE)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'LEFT_STD_DEVIATION_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visual Field: 2) Pattern standard deviation (**Need to capture for both Right Eye and for Left Eye)
for Left Eye (LE)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'RIGHT_STD_DEVIATION_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visual Field: 3) Fixation losses  (**Need to capture for both Right Eye and for Left Eye)
for Right Eye (RE)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'LEFT_FIXATION_LOSS_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visual Field: 3) Fixation losses  (**Need to capture for both Right Eye and for Left Eye)
for Left Eye (LE)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL', @level2type=N'COLUMN',@level2name=N'RIGHT_FIXATION_LOSS_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'To describe the results of one or many Eye Exams performed on the veteran.  The Eye Exam information could be for multiple eye exams, and has child entities which contain all the detailed eye exam results for the patient. Each detail examination is stored in a table which is a detail or ''child'' to the Eye Exam table. The data contained in the Eye Exam tab is very detailed about the eye and sight of the patient and is critical to capture for the Data Store.' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_EXAM_ETL'
GO



/****** Object:  Table [DVEIR].[ER_OUTCOME_ETL]    Script Date: 10/26/2011 09:48:54 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING OFF
GO

CREATE TABLE [DVEIR].[ER_OUTCOME_ETL](
	[ER_OUTCOME_ID] [int] NOT NULL,
	[PATIENT_ID] [int] NOT NULL,
	[STD_ER_VISION_STATUS_ID] [int] NULL,
	[DUTY_RETURN_IND] [varchar](1) NULL,
	[DUTY_RETURN_DSCR] [varchar](4000) NULL,
	[CURRENT_DISABILITY_RATING_NUMB] [varchar](100) NULL,
	[DISABILITY_RATING_DATE] [datetime] NULL,
	[REHABILITATION_REFERRAL_IND] [varchar](1) NULL,
	[VFQ_NUMBER] [varchar](100) NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID] [int] NULL,
	[PROSTHETICS_ORDERED_COMMENTS] [varchar](4000) NULL,
 CONSTRAINT [EROUTCOMEETL_PK] PRIMARY KEY CLUSTERED 
(
	[ER_OUTCOME_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [DVEIR]
) ON [DVEIR]

GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Return to Duty (RTD)
YES/No' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_OUTCOME_ETL', @level2type=N'COLUMN',@level2name=N'DUTY_RETURN_IND'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Return to Duty (RTD) Description/Disposition
details related to their RTD with description or disposition' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_OUTCOME_ETL', @level2type=N'COLUMN',@level2name=N'DUTY_RETURN_DSCR'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Current Disability Rating ' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_OUTCOME_ETL', @level2type=N'COLUMN',@level2name=N'CURRENT_DISABILITY_RATING_NUMB'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of Disability Rating ' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_OUTCOME_ETL', @level2type=N'COLUMN',@level2name=N'DISABILITY_RATING_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Referred to rehabilitation Y/N' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_OUTCOME_ETL', @level2type=N'COLUMN',@level2name=N'REHABILITATION_REFERRAL_IND'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visual Functional Questionaire (VFQ)
Validated method of capturing visual functional on a analog scale (eg. VFQ is 20)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_OUTCOME_ETL', @level2type=N'COLUMN',@level2name=N'VFQ_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'To describe the current diagnosis and/or long term prognosis for the veteran.  This table contains final diagnosis, treatment procedures, and a treatment plan for a given visit by the patient.' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_OUTCOME_ETL'
GO


/****** Object:  Table [DVEIR].[ER_PROCEDURE_DTL_ETL]    Script Date: 10/26/2011 09:48:54 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING OFF
GO

CREATE TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL](
	[ER_PROCEDURE_DTL_ID] [int] IDENTITY(1,1) NOT NULL,
	[COMMENT_TEXT] [varchar](4000) NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[ER_ENCOUNTER_ID] [int] NULL,
	[CODE] [varchar](50) NULL,
	[DESCRIPTION_TEXT] [varchar](500) NULL,
	[ICD9_FLAG] [bit] NOT NULL,
	[PARTIAL_COMMENT] [varchar](100) NULL,
 CONSTRAINT [ERPROCDTLETL_PK] PRIMARY KEY CLUSTERED 
(
	[ER_PROCEDURE_DTL_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [DVEIR],
 CONSTRAINT [UNQ_PatientProcedureDTLETL] UNIQUE NONCLUSTERED 
(
	[ER_ENCOUNTER_ID] ASC,
	[CODE] ASC,
	[PARTIAL_COMMENT] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [DVEIR]
) ON [DVEIR]

GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Enter supporting comments for a row of data - such as usually when list value "Other" is checked' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_PROCEDURE_DTL_ETL', @level2type=N'COLUMN',@level2name=N'COMMENT_TEXT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'List of procedures
****CPT 4 codes; needs to have related Diagnosis Code (ICD9/10) such as:
Repair wound eyelid full thickness (capture Date)
Repair wound eyelid partial thickness (capture Date)
Repair Lacrimal System (capture Date)
Repair Corneoscleral Laceration (capture Date)
Repair Corneoscleral Laceration - Rupture (capture Date)
Repair Corneal Laceration (capture Date)
Repair Corneal Laceration - Rupture (capture Date)
Repair Sclera Laceration (capture Date)
Repair Scleara Laceration - Rupture (capture Date)
Exploration (capture Date)
Temporary Keratoprosthesis (capture Date)
Repair Wound Dehiscence (capture Date)
Corneal Transplant (capture Date)' , @level0type=N'SCHEMA',@level0name=N'DVEIR', @level1type=N'TABLE',@level1name=N'ER_PROCEDURE_DTL_ETL'
GO

ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL]  WITH CHECK ADD  CONSTRAINT [FK_ER_DIAGDTLETL_ENCOUNTER] FOREIGN KEY([ER_ENCOUNTER_ID])
REFERENCES [DVEIR].[ER_ENCOUNTER_ETL] ([ER_ENCOUNTER_ID])
GO

ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL] CHECK CONSTRAINT [FK_ER_DIAGDTLETL_ENCOUNTER]
GO

ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL] ADD  CONSTRAINT [DF_ERDIAGDTLETL_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [DVEIR].[ER_DIAG_DTL_ETL] ADD  CONSTRAINT [DF_ERDIAGDTLETL_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL]  WITH NOCHECK ADD  CONSTRAINT [FK_ER_ENCOUNTER_ETL_PROVIDER] FOREIGN KEY([PROVIDER_ID])
REFERENCES [dbo].[PROVIDER] ([PROVIDER_ID])
GO

ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL] CHECK CONSTRAINT [FK_ER_ENCOUNTER_ETL_PROVIDER]
GO

ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL]  WITH NOCHECK ADD  CONSTRAINT [FK_ER_ENCOUNTER_ETL_REFERRAL] FOREIGN KEY([REFERRAL_ID])
REFERENCES [dbo].[REFERRAL] ([REFERRAL_ID])
GO

ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL] CHECK CONSTRAINT [FK_ER_ENCOUNTER_ETL_REFERRAL]
GO

ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL] ADD  CONSTRAINT [DF_ENCOUNTER_ETL_CREATE]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [DVEIR].[ER_ENCOUNTER_ETL] ADD  CONSTRAINT [DF_ENCOUNTER_ETL_UPDATE]  DEFAULT (getdate()) FOR [UPDATED]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL]  WITH NOCHECK ADD  CONSTRAINT [FK_ER_EXAM_ETL_ER_ENCOUNTER] FOREIGN KEY([ER_EXAM_ID])
REFERENCES [DVEIR].[ER_ENCOUNTER_ETL] ([ER_ENCOUNTER_ID])
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] CHECK CONSTRAINT [FK_ER_EXAM_ETL_ER_ENCOUNTER]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL]  WITH NOCHECK ADD  CONSTRAINT [FK_ER_EXAM_ETL_PATIENT] FOREIGN KEY([PATIENT_ID])
REFERENCES [dbo].[PATIENT] ([PATIENT_ID])
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] CHECK CONSTRAINT [FK_ER_EXAM_ETL_PATIENT]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL]  WITH NOCHECK ADD  CONSTRAINT [EXAM_ETL_LEFT_UNKNOWN_FLAG] CHECK  (([LEFT_REFRACTION_UNKNOWN_FLAG]>=(0) AND [LEFT_REFRACTION_UNKNOWN_FLAG]<=(0) OR [LEFT_REFRACTION_UNKNOWN_FLAG]>=(1) AND [LEFT_REFRACTION_UNKNOWN_FLAG]<=(1)))
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] CHECK CONSTRAINT [EXAM_ETL_LEFT_UNKNOWN_FLAG]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL]  WITH NOCHECK ADD  CONSTRAINT [EXAM_ETL_RIGHT_UNKNOWN_FLAG] CHECK  (([RIGHT_REFRACTION_UNKNOWN_FLAG]>=(0) AND [RIGHT_REFRACTION_UNKNOWN_FLAG]<=(0) OR [RIGHT_REFRACTION_UNKNOWN_FLAG]>=(1) AND [RIGHT_REFRACTION_UNKNOWN_FLAG]<=(1)))
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] CHECK CONSTRAINT [EXAM_ETL_RIGHT_UNKNOWN_FLAG]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] ADD  CONSTRAINT [DF_ER_EXAM_ETL_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] ADD  CONSTRAINT [DF_ER_EXAM_ETL_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] ADD  CONSTRAINT [DF_EXAM_ETL_LEFT_UNKNOWN_FLAG]  DEFAULT ((0)) FOR [LEFT_REFRACTION_UNKNOWN_FLAG]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] ADD  CONSTRAINT [DF_EXAM_ETL_RIGHT_UNKNOWN_FLAG]  DEFAULT ((0)) FOR [RIGHT_REFRACTION_UNKNOWN_FLAG]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] ADD  CONSTRAINT [DF_EXAM_ETL_LEFT_CONFRONTATION_PERFORMED]  DEFAULT ('0') FOR [LEFT_CONFRONTATION_PERFORMED]
GO

ALTER TABLE [DVEIR].[ER_EXAM_ETL] ADD  CONSTRAINT [DF_EXAM_ETL_RIGHT_CONFRONTATION_PERFORMED]  DEFAULT ('0') FOR [RIGHT_CONFRONTATION_PERFORMED]
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL]  WITH NOCHECK ADD  CONSTRAINT [EROUTCOMEETL_STDERVSNST_FK] FOREIGN KEY([STD_ER_VISION_STATUS_ID])
REFERENCES [DVEIR].[STD_ER_VISION_STATUS] ([ID])
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] CHECK CONSTRAINT [EROUTCOMEETL_STDERVSNST_FK]
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL]  WITH NOCHECK ADD  CONSTRAINT [FK_ER_OUTCOME_ETL_ER_ENCOUNTER] FOREIGN KEY([ER_OUTCOME_ID])
REFERENCES [DVEIR].[ER_ENCOUNTER_ETL] ([ER_ENCOUNTER_ID])
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] CHECK CONSTRAINT [FK_ER_OUTCOME_ETL_ER_ENCOUNTER]
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL]  WITH NOCHECK ADD  CONSTRAINT [FK_ER_OUTCOME_ETL_PATIENT] FOREIGN KEY([PATIENT_ID])
REFERENCES [dbo].[PATIENT] ([PATIENT_ID])
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] CHECK CONSTRAINT [FK_ER_OUTCOME_ETL_PATIENT]
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL]  WITH NOCHECK ADD  CONSTRAINT [FK_ER_OUTCOME_ETL_VFQ] FOREIGN KEY([STD_ER_VFQ_QUESTIONNAIRE_TYPE_ID])
REFERENCES [DVEIR].[STD_ER_VFQ_QUESTIONNAIRE_TYPE] ([ID])
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] CHECK CONSTRAINT [FK_ER_OUTCOME_ETL_VFQ]
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] ADD  CONSTRAINT [DF_ER_UTCOMEETL_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [DVEIR].[ER_OUTCOME_ETL] ADD  CONSTRAINT [DF_ER_UTCOMEETL_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL]  WITH CHECK ADD  CONSTRAINT [FK_ER_PROCEDUREDTLETL_ENCOUNTER] FOREIGN KEY([ER_ENCOUNTER_ID])
REFERENCES [DVEIR].[ER_ENCOUNTER_ETL] ([ER_ENCOUNTER_ID])
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] CHECK CONSTRAINT [FK_ER_PROCEDUREDTLETL_ENCOUNTER]
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL]  WITH CHECK ADD  CONSTRAINT [PROC_DTL_ETL_ICD9_FLAG] CHECK  (([ICD9_FLAG]>=(0) AND [ICD9_FLAG]<=(0) OR [ICD9_FLAG]>=(1) AND [ICD9_FLAG]<=(1)))
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] CHECK CONSTRAINT [PROC_DTL_ETL_ICD9_FLAG]
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] ADD  CONSTRAINT [DF_PROCEDUREDTLETL_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] ADD  CONSTRAINT [DF_PROCEDUREDTLETL_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

ALTER TABLE [DVEIR].[ER_PROCEDURE_DTL_ETL] ADD  CONSTRAINT [DF_PROCEDUREDTLETL_ICD9_FLAG]  DEFAULT ((0)) FOR [ICD9_FLAG]
GO

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('06'
           ,'07'
           ,'001'
           ,0
           ,'20709: Create tables for DVEIRGetMissingEncounters ETL package.'
		   ,'***Rollback***'
           ,'DVEIR'
           ,GETDATE())
end
GO

