

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_REFERRAL_Original_STD_RE_RANK]') AND parent_object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original]'))
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [FK_REFERRAL_Original_STD_RE_RANK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_REFERRAL_Original_REMINDERCLASS]') AND parent_object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original]'))
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [FK_REFERRAL_Original_REMINDERCLASS]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original_PATIENT_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original]'))
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [REFERRAL_Original_PATIENT_FK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original_STDINST_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original]'))
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [REFERRAL_Original_STDINST_FK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original_STDREFST_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original]'))
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [REFERRAL_Original_STDREFST_FK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original_STDREG_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original]'))
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [REFERRAL_Original_STDREG_FK]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_Original_CREATED_DATE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [DF_REFERRAL_Original_CREATED_DATE]
END
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_Original_INSERTED_DATE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_ORIGINAL] DROP CONSTRAINT [DF_REFERRAL_Original_INSERTED_DATE]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_Original_UPDATED_DATE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [DF_REFERRAL_Original_UPDATED_DATE]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_Original_ZIP_PLUS_4]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [DF_REFERRAL_Original_ZIP_PLUS_4]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_Original_PROVIDER_ZIP_PLUS_4]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [DF_REFERRAL_Original_PROVIDER_ZIP_PLUS_4]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_Original_DUPLICATE_FLAG]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [DF_REFERRAL_Original_DUPLICATE_FLAG]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_Originial_Orderby_ZIP_PLUS_4]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_Original] DROP CONSTRAINT [DF_REFERRAL_Originial_Orderby_ZIP_PLUS_4]
END

GO

/****** Object:  Table [dbo].[REFERRAL_Original]    Script Date: 02/21/2014 13:37:23 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[REFERRAL_Original]') AND type in (N'U'))
DROP TABLE [dbo].[REFERRAL_Original]
GO


/****** Object:  Table [dbo].[REFERRAL_Original]    Script Date: 02/21/2014 13:37:28 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[REFERRAL_ORIGINAL](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[InsertedDate] DATETIME NOT NULL CONSTRAINT DF_REFERRAL_Original_INSERTED_DATE DEFAULT GETDATE(),
	[REFERRAL_ID] [int] NOT NULL,
	[STD_REFERRALSTS_ID] [int] NOT NULL,
	[STD_REGISTRY_ID] [int] NOT NULL,
	[PATIENT_ID] [int] NOT NULL,
	[STD_INSTITUTION_ID] [int] NULL,
	[REFERRAL_DATE] [datetime] NULL,
	[REFERRAL_CLASS_TEXT] [varchar](4000) NULL,
	[PROVIDER_ID_NUMBER] [varchar](30) NULL,
	[PROVIDER_NAME] [varchar](100) NULL,
	[PROVIDER_PHONE] [varchar](50) NULL,
	[PROVIDER_EMAIL] [varchar](128) NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[COMMENT_TEXT] [varchar](4000) NULL,
	[ADDRESS_LINE1] [varchar](100) NULL,
	[ADDRESS_LINE2] [varchar](100) NULL,
	[ADDRESS_LINE3] [varchar](100) NULL,
	[CITY] [varchar](60) NULL,
	[COUNTRY] [varchar](50) NULL,
	[COUNTY] [varchar](50) NULL,
	[POSTAL_CODE] [varchar](20) NULL,
	[STATE] [varchar](50) NULL,
	[VAMC_CONTACT_EMAIL] [varchar](255) NULL,
	[VAMC_CONTACT_NAME] [varchar](255) NULL,
	[VAMC_CONTACT_PHONE] [varchar](255) NULL,
	[ZIP_PLUS_4] [varchar](6) NULL,
	[VAMC_CONTACT_FAX] [varchar](255) NULL,
	[PROVIDER_ADDRESS_LINE1] [varchar](100) NULL,
	[PROVIDER_ADDRESS_LINE2] [varchar](100) NULL,
	[PROVIDER_ADDRESS_LINE3] [varchar](100) NULL,
	[PROVIDER_CITY] [varchar](60) NULL,
	[PROVIDER_STATE] [varchar](50) NULL,
	[PROVIDER_COUNTY] [varchar](50) NULL,
	[PROVIDER_COUNTRY] [varchar](50) NULL,
	[PROVIDER_POSTAL_CODE] [varchar](20) NULL,
	[PROVIDER_ZIP_PLUS_4] [varchar](6) NULL,
	[PROVIDER_FAX] [varchar](50) NULL,
	[STD_REMINDERCLASS_ID] [int] NULL,
	[REVIEW_BY] [varchar](30) NULL,
	[REVIEW_DATE] [datetime] NULL,
	[DUPLICATE_FLAG] [bit] NOT NULL,
	[ORDERBY_PROVIDER_ID_NUMBER] [varchar](30) NULL,
	[ORDERBY_PROVIDER_NAME] [varchar](100) NULL,
	[ORDERBY_PROVIDER_PHONE] [varchar](50) NULL,
	[ORDERBY_PROVIDER_EMAIL] [varchar](128) NULL,
	[ORDERBY_PROVIDER_ADDRESS_LINE1] [varchar](100) NULL,
	[ORDERBY_PROVIDER_ADDRESS_LINE2] [varchar](100) NULL,
	[ORDERBY_PROVIDER_ADDRESS_LINE3] [varchar](100) NULL,
	[ORDERBY_PROVIDER_CITY] [varchar](60) NULL,
	[ORDERBY_PROVIDER_STATE] [varchar](50) NULL,
	[ORDERBY_PROVIDER_COUNTRY] [varchar](50) NULL,
	[ORDERBY_PROVIDER_POSTAL_CODE] [varchar](20) NULL,
	[ORDERBY_PROVIDER_ZIP_PLUS_4] [varchar](6) NULL,
	[ORDERBY_PROVIDER_FAX] [varchar](50) NULL,
	[STD_REFERRALRANK_ID] [int] NOT NULL,
 CONSTRAINT [REFERRAL_Original_PK] PRIMARY KEY CLUSTERED 
(
	[REFERRAL_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY_2],
 CONSTRAINT [REFERRAL_Original_UniquReferral] UNIQUE NONCLUSTERED 
(
	[PATIENT_ID] ASC,
	[REFERRAL_DATE] ASC,
	[STD_INSTITUTION_ID] ASC,
	[STD_REGISTRY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY_2]

GO

SET ANSI_PADDING OFF
GO


ALTER TABLE [dbo].[REFERRAL_Original]  WITH CHECK ADD  CONSTRAINT [FK_REFERRAL_Original_STD_RE_RANK] FOREIGN KEY([STD_REFERRALRANK_ID])
REFERENCES [dbo].[STD_REFERRALRANK] ([RankID])
GO

ALTER TABLE [dbo].[REFERRAL_Original] CHECK CONSTRAINT [FK_REFERRAL_Original_STD_RE_RANK]
GO

ALTER TABLE [dbo].[REFERRAL_Original]  WITH CHECK ADD  CONSTRAINT [FK_REFERRAL_Original_REMINDERCLASS] FOREIGN KEY([STD_REMINDERCLASS_ID])
REFERENCES [dbo].[STD_REMINDERCLASS] ([ID])
GO

ALTER TABLE [dbo].[REFERRAL_Original] CHECK CONSTRAINT [FK_REFERRAL_Original_REMINDERCLASS]
GO

ALTER TABLE [dbo].[REFERRAL_Original]  WITH CHECK ADD  CONSTRAINT [REFERRAL_Original_PATIENT_FK] FOREIGN KEY([PATIENT_ID])
REFERENCES [dbo].[PATIENT] ([PATIENT_ID])
GO

ALTER TABLE [dbo].[REFERRAL_Original] CHECK CONSTRAINT [REFERRAL_Original_PATIENT_FK]
GO

ALTER TABLE [dbo].[REFERRAL_Original]  WITH CHECK ADD  CONSTRAINT [REFERRAL_Original_STDINST_FK] FOREIGN KEY([STD_INSTITUTION_ID])
REFERENCES [dbo].[STD_INSTITUTION] ([ID])
GO

ALTER TABLE [dbo].[REFERRAL_Original] CHECK CONSTRAINT [REFERRAL_Original_STDINST_FK]
GO

ALTER TABLE [dbo].[REFERRAL_Original]  WITH CHECK ADD  CONSTRAINT [REFERRAL_Original_STDREFST_FK] FOREIGN KEY([STD_REFERRALSTS_ID])
REFERENCES [dbo].[STD_REFERRALSTS] ([ID])
GO

ALTER TABLE [dbo].[REFERRAL_Original] CHECK CONSTRAINT [REFERRAL_Original_STDREFST_FK]
GO

ALTER TABLE [dbo].[REFERRAL_Original]  WITH CHECK ADD  CONSTRAINT [REFERRAL_Original_STDREG_FK] FOREIGN KEY([STD_REGISTRY_ID])
REFERENCES [dbo].[STD_REGISTRY] ([ID])
GO

ALTER TABLE [dbo].[REFERRAL_Original] CHECK CONSTRAINT [REFERRAL_Original_STDREG_FK]
GO

ALTER TABLE [dbo].[REFERRAL_Original] ADD  CONSTRAINT [DF_REFERRAL_Original_CREATED_DATE]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [dbo].[REFERRAL_Original] ADD  CONSTRAINT [DF_REFERRAL_Original_UPDATED_DATE]  DEFAULT (getdate()) FOR [UPDATED]
GO

ALTER TABLE [dbo].[REFERRAL_Original] ADD  CONSTRAINT [DF_REFERRAL_Original_ZIP_PLUS_4]  DEFAULT ('') FOR [ZIP_PLUS_4]
GO

ALTER TABLE [dbo].[REFERRAL_Original] ADD  CONSTRAINT [DF_REFERRAL_Original_PROVIDER_ZIP_PLUS_4]  DEFAULT ('') FOR [PROVIDER_ZIP_PLUS_4]
GO

ALTER TABLE [dbo].[REFERRAL_Original] ADD  CONSTRAINT [DF_REFERRAL_Original_DUPLICATE_FLAG]  DEFAULT ((0)) FOR [DUPLICATE_FLAG]
GO

ALTER TABLE [dbo].[REFERRAL_Original] ADD  CONSTRAINT [DF_REFERRAL_Originial_Orderby_ZIP_PLUS_4]  DEFAULT ('') FOR [ORDERBY_PROVIDER_ZIP_PLUS_4]
GO

ALTER TABLE [dbo].[REFERRAL_Original] ADD  DEFAULT ((9999)) FOR [STD_REFERRALRANK_ID]
GO

------------------------


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[REFERRAL_DETAIL_Original_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[REFERRAL_DETAIL_ORIGINAL]'))
ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL] DROP CONSTRAINT [REFERRAL_DETAIL_Original_FK]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[REFERRAL_DETAIL_Original_STDHLTHFCT_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[REFERRAL_DETAIL_ORIGINAL]'))
ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL] DROP CONSTRAINT [REFERRAL_DETAIL_Original_STDHLTHFCT_FK]
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_DETAIL_Original_INSERTED_DATE]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_DETAIL_Original] DROP CONSTRAINT [DF_REFERRAL_DETAIL_Original_INSERTED_DATE]
END
GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_DETAIL_Original_CREATED]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL] DROP CONSTRAINT [DF_REFERRAL_DETAIL_Original_CREATED]
END

GO

IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_REFERRAL_DETAIL_ORIGINAL_UPDATED]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL] DROP CONSTRAINT [DF_REFERRAL_DETAIL_ORIGINAL_UPDATED]
END

GO

/****** Object:  Table [dbo].[REFERRAL_DETAIL_ORIGINAL]    Script Date: 02/21/2014 13:54:12 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[REFERRAL_DETAIL_ORIGINAL]') AND type in (N'U'))
DROP TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL]
GO

/****** Object:  Table [dbo].[REFERRAL_DETAIL_ORIGINAL]    Script Date: 02/21/2014 13:54:19 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[InsertedDate] DATETIME NOT NULL CONSTRAINT DF_REFERRAL_DETAIL_Original_INSERTED_DATE DEFAULT GETDATE(),
	[REFERRAL_DETAIL_ID] [int] NOT NULL,
	[REFERRAL_ID] [int] NOT NULL,
	[STD_HEALTHFACTOR_ID] [int] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[COMMENT_TEXT] [varchar](4000) NULL,
	[HF_IEN] [int] NULL,
	[DFN] [bigint] NULL,
	[HF_VISITID] [varchar](50) NULL,
	[VISIT_IEN] [int] NULL,
	[ICN] [varchar](50) NULL,
	[Clinic] [varchar](200) NULL,
	[CurSta3n] [varchar](10) NULL,
	[AdmParent_Key] [int] NULL,
 CONSTRAINT [REFERRAL_DETAIL_Original_PK] PRIMARY KEY NONCLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY_2]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL]  WITH CHECK ADD  CONSTRAINT [REFERRAL_DETAIL_Original_FK] FOREIGN KEY([REFERRAL_ID])
REFERENCES [dbo].[REFERRAL] ([REFERRAL_ID])
GO

ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL] CHECK CONSTRAINT [REFERRAL_DETAIL_Original_FK]
GO

ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL]  WITH CHECK ADD  CONSTRAINT [REFERRAL_DETAIL_Original_STDHLTHFCT_FK] FOREIGN KEY([STD_HEALTHFACTOR_ID])
REFERENCES [dbo].[STD_HEALTHFACTOR] ([ID])
GO

ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL] CHECK CONSTRAINT [REFERRAL_DETAIL_Original_STDHLTHFCT_FK]
GO

ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL] ADD  CONSTRAINT [DF_REFERRAL_DETAIL_Original_CREATED]  DEFAULT (getdate()) FOR [CREATED]
GO

ALTER TABLE [dbo].[REFERRAL_DETAIL_ORIGINAL] ADD  CONSTRAINT [DF_REFERRAL_DETAIL_ORIGINAL_UPDATED]  DEFAULT (getdate()) FOR [UPDATED]
GO

-----------------------------


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_SaveOriginalReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_SaveOriginalReferral]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ===============================================
-- Author:		Atlee Whiteleather
-- Create date: 1/30/2014
-- Description:	Use to push referral data from 
--              one referral to another
-- ===============================================

CREATE PROCEDURE [dbo].[usp_EFR_SaveOriginalReferral]
	@referralId int
AS
BEGIN

Begin Transaction

	declare @error int
	set @error = 0 -- 0 is successful, anything else is the error code from the transaction

	insert into REFERRAL_ORIGINAL (
       [REFERRAL_ID]
      ,[STD_REFERRALSTS_ID]
      ,[STD_REGISTRY_ID]
      ,[PATIENT_ID]
      ,[STD_INSTITUTION_ID]
      ,[REFERRAL_DATE]
      ,[REFERRAL_CLASS_TEXT]
      ,[PROVIDER_ID_NUMBER]
      ,[PROVIDER_NAME]
      ,[PROVIDER_PHONE]
      ,[PROVIDER_EMAIL]
      ,[CREATEDBY]
      ,[CREATED]
      ,[UPDATEDBY]
      ,[UPDATED]
      ,[COMMENT_TEXT]
      ,[ADDRESS_LINE1]
      ,[ADDRESS_LINE2]
      ,[ADDRESS_LINE3]
      ,[CITY]
      ,[COUNTRY]
      ,[COUNTY]
      ,[POSTAL_CODE]
      ,[STATE]
      ,[VAMC_CONTACT_EMAIL]
      ,[VAMC_CONTACT_NAME]
      ,[VAMC_CONTACT_PHONE]
      ,[ZIP_PLUS_4]
      ,[VAMC_CONTACT_FAX]
      ,[PROVIDER_ADDRESS_LINE1]
      ,[PROVIDER_ADDRESS_LINE2]
      ,[PROVIDER_ADDRESS_LINE3]
      ,[PROVIDER_CITY]
      ,[PROVIDER_STATE]
      ,[PROVIDER_COUNTY]
      ,[PROVIDER_COUNTRY]
      ,[PROVIDER_POSTAL_CODE]
      ,[PROVIDER_ZIP_PLUS_4]
      ,[PROVIDER_FAX]
      ,[STD_REMINDERCLASS_ID]
      ,[REVIEW_BY]
      ,[REVIEW_DATE]
      ,[DUPLICATE_FLAG]
      ,[ORDERBY_PROVIDER_ID_NUMBER]
      ,[ORDERBY_PROVIDER_NAME]
      ,[ORDERBY_PROVIDER_PHONE]
      ,[ORDERBY_PROVIDER_EMAIL]
      ,[ORDERBY_PROVIDER_ADDRESS_LINE1]
      ,[ORDERBY_PROVIDER_ADDRESS_LINE2]
      ,[ORDERBY_PROVIDER_ADDRESS_LINE3]
      ,[ORDERBY_PROVIDER_CITY]
      ,[ORDERBY_PROVIDER_STATE]
      ,[ORDERBY_PROVIDER_COUNTRY]
      ,[ORDERBY_PROVIDER_POSTAL_CODE]
      ,[ORDERBY_PROVIDER_ZIP_PLUS_4]
      ,[ORDERBY_PROVIDER_FAX]
      ,[STD_REFERRALRANK_ID])
	  
	  select 
		   [REFERRAL_ID]
		  ,[STD_REFERRALSTS_ID]
		  ,[STD_REGISTRY_ID]
		  ,[PATIENT_ID]
		  ,[STD_INSTITUTION_ID]
		  ,[REFERRAL_DATE]
		  ,[REFERRAL_CLASS_TEXT]
		  ,[PROVIDER_ID_NUMBER]
		  ,[PROVIDER_NAME]
		  ,[PROVIDER_PHONE]
		  ,[PROVIDER_EMAIL]
		  ,[CREATEDBY]
		  ,[CREATED]
		  ,[UPDATEDBY]
		  ,[UPDATED]
		  ,[COMMENT_TEXT]
		  ,[ADDRESS_LINE1]
		  ,[ADDRESS_LINE2]
		  ,[ADDRESS_LINE3]
		  ,[CITY]
		  ,[COUNTRY]
		  ,[COUNTY]
		  ,[POSTAL_CODE]
		  ,[STATE]
		  ,[VAMC_CONTACT_EMAIL]
		  ,[VAMC_CONTACT_NAME]
		  ,[VAMC_CONTACT_PHONE]
		  ,[ZIP_PLUS_4]
		  ,[VAMC_CONTACT_FAX]
		  ,[PROVIDER_ADDRESS_LINE1]
		  ,[PROVIDER_ADDRESS_LINE2]
		  ,[PROVIDER_ADDRESS_LINE3]
		  ,[PROVIDER_CITY]
		  ,[PROVIDER_STATE]
		  ,[PROVIDER_COUNTY]
		  ,[PROVIDER_COUNTRY]
		  ,[PROVIDER_POSTAL_CODE]
		  ,[PROVIDER_ZIP_PLUS_4]
		  ,[PROVIDER_FAX]
		  ,[STD_REMINDERCLASS_ID]
		  ,[REVIEW_BY]
		  ,[REVIEW_DATE]
		  ,[DUPLICATE_FLAG]
		  ,[ORDERBY_PROVIDER_ID_NUMBER]
		  ,[ORDERBY_PROVIDER_NAME]
		  ,[ORDERBY_PROVIDER_PHONE]
		  ,[ORDERBY_PROVIDER_EMAIL]
		  ,[ORDERBY_PROVIDER_ADDRESS_LINE1]
		  ,[ORDERBY_PROVIDER_ADDRESS_LINE2]
		  ,[ORDERBY_PROVIDER_ADDRESS_LINE3]
		  ,[ORDERBY_PROVIDER_CITY]
		  ,[ORDERBY_PROVIDER_STATE]
		  ,[ORDERBY_PROVIDER_COUNTRY]
		  ,[ORDERBY_PROVIDER_POSTAL_CODE]
		  ,[ORDERBY_PROVIDER_ZIP_PLUS_4]
		  ,[ORDERBY_PROVIDER_FAX]
		  ,[STD_REFERRALRANK_ID]

		from REFERRAL
		where REFERRAL_ID = @referralId
	          
	set @error = @@ERROR
	if (@error = 0 AND @@ROWCOUNT = 0)
	Begin
		set @error = -1  -- Code needs to know that -1 is a custom error meaning no rows found
	End
	
	if (@error = 0)
	Begin
		insert into referral_detail_original (
		   [REFERRAL_DETAIL_ID]
		  ,[REFERRAL_ID]
		  ,[STD_HEALTHFACTOR_ID]
		  ,[CREATEDBY]
		  ,[CREATED]
		  ,[UPDATEDBY]
		  ,[UPDATED]
		  ,[COMMENT_TEXT]
		  ,[HF_IEN]
		  ,[DFN]
		  ,[HF_VISITID]
		  ,[VISIT_IEN]
		  ,[ICN]
		  ,[Clinic]
		  ,[CurSta3n]
		  ,[AdmParent_Key])
		 select 
		   [REFERRAL_DETAIL_ID]
		  ,[REFERRAL_ID]
		  ,[STD_HEALTHFACTOR_ID]
		  ,[CREATEDBY]
		  ,[CREATED]
		  ,[UPDATEDBY]
		  ,[UPDATED]
		  ,[COMMENT_TEXT]
		  ,[HF_IEN]
		  ,[DFN]
		  ,[HF_VISITID]
		  ,[VISIT_IEN]
		  ,[ICN]
		  ,[Clinic]
		  ,[CurSta3n]
		  ,[AdmParent_Key]
		 from REFERRAL_DETAIL
		 where REFERRAL_ID = @referralId			
		
		set @error = @@ERROR
	End


	if (@error = 0)
	Begin
		Commit Transaction
		-- Print ('Im a supastar')
	End
	Else
	Begin
		Rollback Transaction
		-- Print ('Something is wrong')
	End
	
	select @error
END
GO
----------------------------------------
/****** Object:  StoredProcedure [dbo].[GetEFRReferralOriginalRecordCount]    Script Date: 01/28/2014 12:13:33 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEFRReferralOriginalRecordCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetEFRReferralOriginalRecordCount]
GO

/****** Object:  StoredProcedure [dbo].[GetEFRReferralOriginalRecordCount]    Script Date: 01/28/2014 12:13:33 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ===============================================
-- Author:		Atlee Whiteleather
-- Create date: 1/28/2014
-- Description:	Use to return the # of 
--              referral history entries
--              for the given referral
-- ===============================================

CREATE PROCEDURE [dbo].[GetEFRReferralOriginalRecordCount]
	 @REFERRAL_ID int
AS
BEGIN
	declare @result int
	
	set @result = 
		(
		 SELECT count(ID)
		 FROM Referral_Original
		 where REFERRAL_ID = @REFERRAL_ID
		)
		
	select (@result) as [NumReferrals]
END


GO
--------------------------------------------

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_GetOriginalReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_GetOriginalReferral]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ===============================================
-- Author:		Atlee Whiteleather
-- Create date: 2/26/2014
-- Description:	Use to retrieve Original Referral
-- ===============================================

CREATE PROCEDURE [dbo].[usp_EFR_GetOriginalReferral]
	@referralId int
AS
BEGIN	  

	---- compile the health factors first

	--DECLARE @Table TABLE( 
	--EFP bit default (0) NOT NULL
	--); 

	--update @Table
	--set EFP = 

  select 
	   r.[REFERRAL_ID]
	  ,r.[STD_REFERRALSTS_ID]
	  ,r.[STD_REGISTRY_ID]
	  ,r.[PATIENT_ID]
	  ,r.[STD_INSTITUTION_ID]
	  ,r.[REFERRAL_DATE]
	  ,r.[REFERRAL_CLASS_TEXT]
	  ,r.[PROVIDER_ID_NUMBER]
	  ,r.[PROVIDER_NAME]
	  ,r.[PROVIDER_PHONE]
	  ,r.[PROVIDER_EMAIL]
	  ,r.[CREATEDBY]
	  ,r.[CREATED]
	  ,r.[UPDATEDBY]
	  ,r.[UPDATED]
	  ,r.[COMMENT_TEXT]
	  ,r.[ADDRESS_LINE1]
	  ,r.[ADDRESS_LINE2]
	  ,r.[ADDRESS_LINE3]
	  ,r.[CITY]
	  ,r.[COUNTRY]
	  ,r.[COUNTY]
	  ,r.[POSTAL_CODE]
	  ,r.[STATE]
	  ,r.[VAMC_CONTACT_EMAIL]
	  ,r.[VAMC_CONTACT_NAME]
	  ,r.[VAMC_CONTACT_PHONE]
	  ,r.[ZIP_PLUS_4]
	  ,r.[VAMC_CONTACT_FAX]
	  ,r.[PROVIDER_ADDRESS_LINE1]
	  ,r.[PROVIDER_ADDRESS_LINE2]
	  ,r.[PROVIDER_ADDRESS_LINE3]
	  ,r.[PROVIDER_CITY]
	  ,r.[PROVIDER_STATE]
	  ,r.[PROVIDER_COUNTY]
	  ,r.[PROVIDER_COUNTRY]
	  ,r.[PROVIDER_POSTAL_CODE]
	  ,r.[PROVIDER_ZIP_PLUS_4]
	  ,r.[PROVIDER_FAX]
	  ,r.[STD_REMINDERCLASS_ID]
	  ,r.[REVIEW_BY]
	  ,r.[REVIEW_DATE]
	  ,r.[DUPLICATE_FLAG]
	  ,r.[ORDERBY_PROVIDER_ID_NUMBER]
	  ,r.[ORDERBY_PROVIDER_NAME]
	  ,r.[ORDERBY_PROVIDER_PHONE]
	  ,r.[ORDERBY_PROVIDER_EMAIL]
	  ,r.[ORDERBY_PROVIDER_ADDRESS_LINE1]
	  ,r.[ORDERBY_PROVIDER_ADDRESS_LINE2]
	  ,r.[ORDERBY_PROVIDER_ADDRESS_LINE3]
	  ,r.[ORDERBY_PROVIDER_CITY]
	  ,r.[ORDERBY_PROVIDER_STATE]
	  ,r.[ORDERBY_PROVIDER_COUNTRY]
	  ,r.[ORDERBY_PROVIDER_POSTAL_CODE]
	  ,r.[ORDERBY_PROVIDER_ZIP_PLUS_4]
	  ,r.[ORDERBY_PROVIDER_FAX]
	  ,r.[STD_REFERRALRANK_ID]
	  ,p.[SSN]
	  ,si.[ID]
	  ,si.[STREETADDRESSLINE1]
	  ,si.[STREETADDRESSLINE2]
	  ,si.[STREETADDRESSLINE3]
	  ,si.[STREETCITY]
	  ,si.[STREETPOSTALCODE]
	  ,si.[STREETSTATE_ID]
	  ,si.[STREETCOUNTRY_ID]
	  ,si.[MAILINGADDRESSLINE1]
	  ,si.[MAILINGADDRESSLINE2]
	  ,si.[MAILINGADDRESSLINE3]
	  ,si.[MAILINGCITY]
	  ,si.[MAILINGPOSTALCODE]
	  ,si.[MAILINGSTATE_ID]
	  ,si.[MAILINGCOUNTRY_ID]
	  -- Fragments
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 69 and REFERRAL_ID = r.referral_id)
	   as 'EFP'
	  ,case
			when (select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
				  where std_healthfactor_ID = 69 and REFERRAL_ID = r.referral_id) > 0
			then
				(select COMMENT_TEXT from REFERRAL_DETAIL_ORIGINAL
				where std_healthfactor_ID = 69 and REFERRAL_ID = r.referral_id)
			else 
				(select '')
			end as 'EFP COMMENT'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 70 and REFERRAL_ID = r.referral_id)
	   as 'NEF'
	   
	   -- Injury Type
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 4 and REFERRAL_ID = r.referral_id)
	   as 'BI'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 21 and REFERRAL_ID = r.referral_id)
	   as 'NBI'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 3 and REFERRAL_ID = r.referral_id)
	   as 'BEI'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 20 and REFERRAL_ID = r.referral_id)
	   as 'NBEI'
	   
	   -- Blast/Explosion Type
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 17 and REFERRAL_ID = r.referral_id)
	   as 'IED'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 26 and REFERRAL_ID = r.referral_id)
	   as 'RPG'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 19 and REFERRAL_ID = r.referral_id)
	   as 'LM'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 16 and REFERRAL_ID = r.referral_id)
	   as 'Gr'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 8 and REFERRAL_ID = r.referral_id)
	   as 'EF'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 15 and REFERRAL_ID = r.referral_id)
	   as 'FF'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 2 and REFERRAL_ID = r.referral_id)
	   as 'UT'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 1 and REFERRAL_ID = r.referral_id)
	   as 'Other'
	  ,case
			when (select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
				  where std_healthfactor_ID = 1 and REFERRAL_ID = r.referral_id) > 0
			then
				(select COMMENT_TEXT from REFERRAL_DETAIL_ORIGINAL
				where std_healthfactor_ID = 1 and REFERRAL_ID = r.referral_id)
			else 
				(select '')
			end as 'Other COMMENT'
			
	   -- Fragments in Body
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 9 and REFERRAL_ID = r.referral_id)
	   as 'FIB'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 22 and REFERRAL_ID = r.referral_id)
	   as 'NFIB'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 27 and REFERRAL_ID = r.referral_id)
	   as 'UFIB'
	   
	   -- Radiography
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 12 and REFERRAL_ID = r.referral_id)
	   as 'FOR'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 23 and REFERRAL_ID = r.referral_id)
	   as 'NFOR'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 28 and REFERRAL_ID = r.referral_id)
	   as 'UFOR'
	   
	   -- Vehicle
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 18 and REFERRAL_ID = r.referral_id)
	   as 'IV'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 24 and REFERRAL_ID = r.referral_id)
	   as 'NIV'
	   
	   -- Surgery
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 13 and REFERRAL_ID = r.referral_id)
	   as 'FRIS'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 10 and REFERRAL_ID = r.referral_id)
	   as 'FNRIS'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 29 and REFERRAL_ID = r.referral_id)
	   as 'UFRIS'
	   
	   -- Laboratory
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 14 and REFERRAL_ID = r.referral_id)
	   as 'FSTL'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 11 and REFERRAL_ID = r.referral_id)
	   as 'FNSTL'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 30 and REFERRAL_ID = r.referral_id)
	   as 'UFSTL'
	   
	   -- Unable to Screen
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 75 and REFERRAL_ID = r.referral_id)
	   as 'AI'
	  ,case
			when (select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
				  where std_healthfactor_ID = 75 and REFERRAL_ID = r.referral_id) > 0
			then
				(select COMMENT_TEXT from REFERRAL_DETAIL_ORIGINAL
				where std_healthfactor_ID = 75 and REFERRAL_ID = r.referral_id)
			else 
				(select '')
			end as 'AI Comment'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 79 and REFERRAL_ID = r.referral_id)
	   as 'SCI'
	  ,case
			when (select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
				  where std_healthfactor_ID = 79 and REFERRAL_ID = r.referral_id) > 0
			then
				(select COMMENT_TEXT from REFERRAL_DETAIL_ORIGINAL
				where std_healthfactor_ID = 79 and REFERRAL_ID = r.referral_id)
			else 
				(select '')
			end as 'SCI Comment'
	  ,(select count(std_healthfactor_ID) from REFERRAL_DETAIL_ORIGINAL
	   where std_healthfactor_ID = 25 and REFERRAL_ID = r.referral_id)
	   as 'RST'
	   

	from REFERRAL_ORIGINAL r
	join PATIENT p on p.[PATIENT_ID] = r.[PATIENT_ID]
	join STD_INSTITUTION si on si.ID = r.STD_INSTITUTION_ID
	where r.REFERRAL_ID = @referralId
	
END
GO
---------------------------------------------


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R8'
           ,'00'
           ,'001'
           ,0
           ,'EFR 20755 - Show Original Referral'
		   ,'Script will create the tables and stored procedures for EFR 20755'
           ,'EFR'
           ,GETDATE())

GO
