/*
	Add CRS_DB_LOG table & create procedure to insert into it

*/

USE [Registry]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CRS_SP_INS_CRSDBLOG]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[CRS_SP_INS_CRSDBLOG]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CRS_DB_LOG]') AND type in (N'U'))
DROP TABLE [dbo].[CRS_DB_LOG]
GO


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R7'
           ,'00'
           ,'001'
           ,0
           ,'CRS Update'
		   ,'ROLLBACK: Script will create the CRS_DB_LOG table and associated procedures'
           ,'EFR'
           ,GETDATE())

GO
