/****** Object:  StoredProcedure [dbo].[GetEFRNumberOfReferralHistoryRecords]    Script Date: 01/28/2014 12:13:33 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEFRNumberOfReferralHistoryRecords]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetEFRNumberOfReferralHistoryRecords]
GO

/****** Object:  StoredProcedure [dbo].[GetEFRNumberOfReferralHistoryRecords]    Script Date: 01/28/2014 12:13:33 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ===============================================
-- Author:		Atlee Whiteleather
-- Create date: 1/28/2014
-- Description:	Use to return the # of 
--              referral history entries
--              for the given referral
-- ===============================================

CREATE PROCEDURE [dbo].[GetEFRNumberOfReferralHistoryRecords]
	 @REFERRAL_ID int
AS
BEGIN
	declare @result int
	
	set @result = 
		(
		 SELECT count(Audit_Referral_H_ID)
		 FROM Referral_H 
		 where Referral_H.REFERRAL_ID = @REFERRAL_ID
		)
		
	select (@result) as [NumReferrals]
END


GO



IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_UpdateWorkingReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_UpdateWorkingReferral]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ===============================================
-- Author:		Atlee Whiteleather
-- Create date: 1/30/2014
-- Description:	Use to push referral data from 
--              one referral to another
-- ===============================================

CREATE PROCEDURE [dbo].[usp_EFR_UpdateWorkingReferral]
	@dupReferralId int
	,@workingReferralId int
AS
BEGIN

Begin Transaction

	declare @error int
	set @error = 0 -- 0 is successful, anything else is the error code from the transaction

	update wr 
	set [VAMC_CONTACT_NAME] = dr.[VAMC_CONTACT_NAME]
		,[VAMC_CONTACT_PHONE] = dr.[VAMC_CONTACT_PHONE]
		,[VAMC_CONTACT_EMAIL] = dr.[VAMC_CONTACT_EMAIL]
		,[VAMC_CONTACT_FAX] = dr.[VAMC_CONTACT_FAX]
		,[STD_INSTITUTION_ID] = dr.[STD_INSTITUTION_ID]
		,[ADDRESS_LINE1] = dr.[ADDRESS_LINE1]
		,[ADDRESS_LINE2] = dr.[ADDRESS_LINE2]
		,[ADDRESS_LINE3] = dr.[ADDRESS_LINE3]
		,[CITY] = dr.[CITY]
		,[COUNTRY] = dr.[COUNTRY]
		,[COUNTY] = dr.[COUNTY]
		,[POSTAL_CODE] = dr.[POSTAL_CODE]
		,[STATE] = dr.[STATE]
		,[ZIP_PLUS_4] = dr.[ZIP_PLUS_4]
		,[PROVIDER_ID_NUMBER] = dr.[PROVIDER_ID_NUMBER]
		,[PROVIDER_NAME] = dr.[PROVIDER_NAME]
		,[PROVIDER_PHONE] = dr.[PROVIDER_PHONE]
		,[PROVIDER_EMAIL] = dr.[PROVIDER_EMAIL]
		,[PROVIDER_ADDRESS_LINE1] = dr.[PROVIDER_ADDRESS_LINE1]
		,[PROVIDER_ADDRESS_LINE2] = dr.[PROVIDER_ADDRESS_LINE2]
		,[PROVIDER_ADDRESS_LINE3] = dr.[PROVIDER_ADDRESS_LINE3]
		,[PROVIDER_CITY] = dr.[PROVIDER_CITY]
		,[PROVIDER_STATE] = dr.[PROVIDER_STATE]
		,[PROVIDER_COUNTY] = dr.[PROVIDER_COUNTY]
		,[PROVIDER_COUNTRY] = dr.[PROVIDER_COUNTRY]
		,[PROVIDER_POSTAL_CODE] = dr.[PROVIDER_POSTAL_CODE]
		,[PROVIDER_ZIP_PLUS_4] = dr.[PROVIDER_ZIP_PLUS_4]
		,[PROVIDER_FAX] = dr.[PROVIDER_FAX]
		,[REFERRAL_DATE] = DATEADD(ss,1,dr.[REFERRAL_DATE]) -- add one second to prevent duplicates
		,[CREATED] = dr.[CREATED]
		,[CREATEDBY] = 			
			case	
			when CHARINDEX(' (', wr.[CREATEDBY]) > 0 then 
				SUBSTRING(wr.[CREATEDBY], 0, CHARINDEX(' (', wr.[CREATEDBY])) + ' (' + convert(varchar(10), @dupReferralId)  + ')'
			when CHARINDEX(' (', wr.[CREATEDBY]) = 0 then wr.[CREATEDBY]  + ' (' + convert(varchar(10), @dupReferralId)  + ')'
			else 'null'
			end 		
		,[REVIEW_DATE] = dr.[REVIEW_DATE]
		,[REVIEW_BY] = dr.[REVIEW_BY]
	from REFERRAL wr
	inner join (select @WorkingReferralId as [Referral_id], [VAMC_CONTACT_NAME], [VAMC_CONTACT_FAX], [VAMC_CONTACT_PHONE], [VAMC_CONTACT_EMAIL],
				[STD_INSTITUTION_ID], [ADDRESS_LINE1],[ADDRESS_LINE2],[ADDRESS_LINE3],
				[CITY],[COUNTRY],[COUNTY],[POSTAL_CODE],[STATE],[ZIP_PLUS_4],
				[PROVIDER_ID_NUMBER],[PROVIDER_NAME],[PROVIDER_PHONE],[PROVIDER_EMAIL],  
				[PROVIDER_ADDRESS_LINE1],[PROVIDER_ADDRESS_LINE2],[PROVIDER_ADDRESS_LINE3], 
				[PROVIDER_CITY],[PROVIDER_STATE],[PROVIDER_COUNTY],[PROVIDER_COUNTRY],
				[PROVIDER_POSTAL_CODE],[PROVIDER_ZIP_PLUS_4],[PROVIDER_FAX],
				[REFERRAL_DATE],[CREATED],[CREATEDBY],[REVIEW_DATE],[REVIEW_BY]
		from REFERRAL
		where REFERRAL_ID = @dupReferralId
			  ) dr  on dr.[REFERRAL_ID] = wr.[REFERRAL_ID]
	          
	set @error = @@ERROR
	if (@error = 0 AND @@ROWCOUNT = 0)
	Begin
		set @error = -1  -- Code needs to know that -1 is a custom error meaning no rows found
	End
	
	if (@error = 0)
	Begin	
		-- Health Factors
		delete referral_detail
		where referral_id = @workingReferralId
		
		set @error = @@ERROR
	End
	
	if (@error = 0)
	Begin
		insert into referral_detail (
			REFERRAL_ID, STD_HEALTHFACTOR_ID, CREATEDBY, CREATED, UPDATEDBY, UPDATED,
			COMMENT_TEXT, HF_IEN, DFN, HF_VISITID, VISIT_IEN, ICN, Clinic, CurSta3n,
			AdmParent_Key)
			(
			 select @workingReferralId, STD_HEALTHFACTOR_ID, CREATEDBY, CREATED, UPDATEDBY, UPDATED,
				COMMENT_TEXT, HF_IEN, DFN, HF_VISITID, VISIT_IEN, ICN, Clinic, CurSta3n,
				AdmParent_Key
			 from REFERRAL_DETAIL
			 where REFERRAL_ID = @dupReferralId
			)
		
		set @error = @@ERROR
	End


	if (@error = 0)
	Begin
		Commit Transaction
		-- Print ('Im a supastar')
	End
	Else
	Begin
		Rollback Transaction
		-- Print ('Something is wrong')
	End
	
	select @error
END
GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R7'
           ,'00'
           ,'001'
           ,0
           ,'20745  Prod Defect_Update a "manual" Referral'
		   ,'Script will create the usp_EFR_UpdateWorkingReferral stored procedure'
           ,'EFR'
           ,GETDATE())

GO

