/*
	Add CRS_DB_LOG table & create procedure to insert into it

*/

USE [Registry]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CRS_DB_LOG]') AND type in (N'U'))
DROP TABLE [dbo].[CRS_DB_LOG]
GO
CREATE TABLE [dbo].[CRS_DB_LOG](
	[CRS_DB_LOG_ID] [int] IDENTITY(1,1) NOT NULL,
	[STD_REGISTRY_ID] [int] NOT NULL,
	[IS_ERROR] BIT not null default 0,
	[PROCESS_NAME] varchar(200) Null,
	[MESSAGE] varchar(max) null,
	[COMMENTS] varchar(max) null,
	[CREATED] [datetime] NOT NULL,
	[CREATEDBY] varchar(30) not null,
 CONSTRAINT [CRSDBLOG_PK] PRIMARY KEY CLUSTERED 
(
	[CRS_DB_LOG_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This table is used to store general log information for the CRS database .' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CRS_DB_LOG'
GO

ALTER TABLE [dbo].[CRS_DB_LOG] WITH CHECK ADD CONSTRAINT [CRSDBLOG_STDREG_FK] FOREIGN KEY([STD_REGISTRY_ID])
REFERENCES [dbo].[STD_REGISTRY] ([ID])
GO
ALTER TABLE [dbo].[CRS_DB_LOG] CHECK CONSTRAINT [CRSDBLOG_STDREG_FK] 
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CRS_SP_INS_CRSDBLOG]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[CRS_SP_INS_CRSDBLOG]
GO
CREATE PROCEDURE [dbo].[CRS_SP_INS_CRSDBLOG]
(
	@StdRegistryFk INT,
	@IsError BIT,
	@ProcessName varchar(100),
	@Message varchar(max),
	@Comments varchar(max),
	@CreatedBy varchar(30)
)
AS
Begin
	Declare @Created datetime 
	
	-- Default
	set @Created = GETDATE()

	-- set blanks
	if (@ProcessName = '') set @ProcessName = null
	if (@Message = '') set @Message = null		
	if (@Comments = '') set @Comments = null
	if (@CreatedBy = '') set @CreatedBy = null

	-- required fields check
	if (@CreatedBy is null)
	Begin
		Print ('@CreatedBy Cannot be blank or Null')
		Return
	End
	if (@StdRegistryFk is null)
	Begin
		Print ('@StdRegistryFk  Cannot be blank or Null')
		Return
	End

	-- Insert of new log record
	Insert into [dbo].[CRS_DB_LOG]
	([STD_REGISTRY_ID], [IS_ERROR], [PROCESS_NAME], [MESSAGE], [COMMENTS], [CREATED], [CREATEDBY])
	Values (@StdRegistryFk, @IsError, @ProcessName, @Message, @Comments, @Created, @CreatedBy)

End
GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R7'
           ,'00'
           ,'001'
           ,0
           ,'CRS Update'
		   ,'Script will create the CRS_DB_LOG table and associated procedures'
           ,'EFR'
           ,GETDATE())

GO
