/****** Object:  UserDefinedFunction [dbo].[GetEFRFormVersion]    Script Date: 10/30/2013 10:59:01 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEFRFormVersion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetEFRFormVersion]
GO

/****** Object:  UserDefinedFunction [dbo].[GetEFRFormVersion]    Script Date: 10/30/2013 10:59:01 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [dbo].[GetEFRFormVersion](
 @activityId int
)
AS
BEGIN
	declare @result varchar(200)
	declare @is2009 bit
	declare @is2012 bit
		
	
	set @result = 'unknown'
	
	set @is2009 = (select top(1) FORM_2009_FLAG 
    from EFR.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT
    where WKF_CASE_ACTIVITY_ID = @activityId)
	
	set @is2012 = (select top(1) FORM_2012_FLAG 
    from EFR.QUES_BIOLOGICAL_MONITORING_SPECIMEN_COLLECTION_KIT
    where WKF_CASE_ACTIVITY_ID = @activityId)
    
    if (ISNULL(@is2009,0) = 1)
    begin
		set @result = '2009'
	end
	else if (ISNULL(@is2012,0) = 1)
	begin
		set @result = '2012'
	end
		
	
	select @result as Version
	
END

GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R4b'
           ,'00'
           ,'001'
           ,0
           ,'29265: Biomonitoring Questionnaire - update access points from Patient information'
		   ,'Script will create GetEFRFormVersion stored procedure'
           ,'EFR'
           ,GETDATE())
end