/****** Object:  StoredProcedure [dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]    Script Date: 11/01/2013 11:42:50 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]    Script Date: 11/01/2013 11:42:50 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		David Hassell
-- Create date: 08/03/2010
-- Description:	This procedure was formerly in 
--              PatientBioLabIntrprtnLetter.rdl
--
-- Update 11/1/2013 - Atlee Whiteleather. Order
-- Analytes in result set
--
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LETTER_ANALYTE_DETAILS]
	@activityID int
AS
BEGIN

	Declare @activityType int 

	SELECT TOP (1) @activityType = [t2].[ID]
	FROM [dbo].[WKF_CASE_ACTIVITY] AS [t0]
	INNER JOIN ([dbo].[WKF_CASE] AS [t1]
		INNER JOIN [dbo].[STD_WKFCASETYPE] AS [t2] ON [t2].[ID] = [t1].[STD_WKFCASETYPE_ID]) ON [t1].[WKF_CASE_ID] = [t0].[WKF_CASE_ID]
	WHERE [t0].[WKF_CASE_ACTIVITY_ID] = @activityId
	  AND [t0].ARCHIVED_FLAG = 0 --Added per bug tracker #1539


	IF @activityType = 3
		BEGIN
			--Biological Monitoring Lab Analytes
			SELECT [t0].[TEST_NAME] AS [TestMethod], 
				--JH 8/16/2010: per build 2 design removing U235 items from letter report
				--[Analyte] =
				--CASE [t0].[TEST_NAME]
				--WHEN 'RATIO U235/U238' THEN [t0].[TEST_NAME]
				--ELSE [t0].[ANALYTE_NAME]
				--END
				[t0].[ANALYTE_NAME] as  [Analyte]
				, 
				--JH 8/16/2010: per build 2 design, display comment text if result is not present
				[Result] = 
				CASE [t0].[RESULT_TEXT]
				WHEN NULL THEN [t0].OTHER_COMMENT_TEXT 
				WHEN '' THEN [t0].OTHER_COMMENT_TEXT
				ELSE [t0].[RESULT_TEXT]
				END
				, [t0].[RESULT_UNIT_NUMBER] AS [Units],
				--JH 8/16/2010: per build 2 design, range will be the TEFSC range
				--[t0].[ORIGINAL_RANGE_NUMBER] AS [Range]
				[t0].[TEFSC_REFERENCE_RANGE] + ' ' + [TEFSC_UNITS] as [Range]
				,
				--JH 8/16/2010: per build 2 design, adding above TEFSC reference range
				[TEFSC_ABOVE_REFERENCE_RANGE] = 
				CASE [t0].TEFSC_ABOVE_REFERENCE_RANGE
				WHEN 1 THEN 'Yes'
				WHEN 0 THEN 'No'
				ELSE 'No'
				END
			FROM 
			(
			SELECT     TEST_NAME 
						, [RESULT_TEXT] =
							CASE CHARINDEX ('LOD' , RESULT_TEXT)
							WHEN 0 THEN RESULT_TEXT
							WHEN NULL THEN RESULT_TEXT
							ELSE RESULT_TEXT + '*'
							END
						, [std_units].CODE AS RESULT_UNIT_NUMBER , ANALYSIS_DETAIL.LAB_REFERENCE_RANGE AS [ORIGINAL_RANGE_NUMBER] , ANALYSIS_DETAIL_ID, 
						  FRAGMENT_ANALYSIS_ID, SPECIMEN_ANALYSIS_ID, STD_TEST_NAME_ID, ANALYTE_NAME, TEFSC_ABOVE_REFERENCE_RANGE, OTHER_COMMENT_TEXT, TEFSC_REFERENCE_RANGE, STD_UNIT1.NAME as [TEFSC_UNITS]
			FROM         EFR.ANALYSIS_DETAIL 
							INNER JOIN
						 EFR.STD_TEST_NAME ON ANALYSIS_DETAIL.STD_TEST_NAME_ID = STD_TEST_NAME.ID
							LEFT OUTER JOIN 
						 [EFR].STD_UNITS AS [std_units] on [std_units].ID = ANALYSIS_DETAIL.RESULT_UNIT_ID
							LEFT OUTER JOIN
						 [EFR].STD_UNITS AS [STD_UNIT1] on [STD_UNIT1].ID = ANALYSIS_DETAIL.TEFSC_REFERENCE_RANGE_UNIT_ID
			
    			--JH 8/16/2010: per build 2 design removing U235 items from letter report
    			--WHERE STD_TEST_NAME.CODE IN ('STANDARDIZED','RATIO U235/U238')
    			WHERE STD_TEST_NAME.CODE = 'STANDARDIZED' 
    			
    			)
			AS t0
			LEFT OUTER JOIN [EFR].[SPECIMEN_ANALYSIS] AS [t1] ON [t1].[SPECIMEN_ANALYSIS_ID] = [t0].[SPECIMEN_ANALYSIS_ID]
			LEFT OUTER JOIN [EFR].[FRAGMENT_ANALYSIS] AS [t2] ON [t2].[FRAGMENT_ANALYSIS_ID] = [t0].[FRAGMENT_ANALYSIS_ID]
			WHERE (([t1].[WKF_CASE_ACTIVITY_ID] = @activityId) OR ([t2].[WKF_CASE_ACTIVITY_ID] = @activityId))
			Order By [t0].[ANALYTE_NAME]
		END

		IF @activityType = 4
		BEGIN
			--Fragment Analyis Lab Analytes
			SELECT [t1].[CODE] AS [TestMethod], [t0].[ANALYTE_NAME] AS [Analyte]
			--JH 8/16/2010: per build 2 design, display comment text if result is not present
			--, [std_units].CODE AS [Result]
			,[Result] = 
				CASE [t0].[RESULT_TEXT]
				WHEN NULL THEN [t0].OTHER_COMMENT_TEXT 
				WHEN '' THEN [t0].OTHER_COMMENT_TEXT
				ELSE [t0].[RESULT_TEXT]
				END
			--JH 8/16/2010: per build 2 design, range will be the TEFSC range
			--, [t0].LAB_REFERENCE_RANGE AS [Range]
			,[t0].TEFSC_REFERENCE_RANGE + '' + [STD_UNITS1].[NAME]  as [Range]
			--JH 8/16/2010: per build 2 design, adding above TEFSC reference range
			,[TEFSC_ABOVE_REFERENCE_RANGE] = 
				CASE [t0].TEFSC_ABOVE_REFERENCE_RANGE
				WHEN 1 THEN 'Yes'
				WHEN 0 THEN 'No'
				ELSE 'No'
				END
			
			FROM 
			
						(SELECT     TEST_NAME 
						, [RESULT_TEXT] =
							CASE CHARINDEX ('LOD' , RESULT_TEXT)
							WHEN 0 THEN RESULT_TEXT
							WHEN NULL THEN RESULT_TEXT
							ELSE RESULT_TEXT + '*'
							END
						, ANALYSIS_DETAIL.LAB_REFERENCE_RANGE AS [ORIGINAL_RANGE_NUMBER] , ANALYSIS_DETAIL_ID, 
						  FRAGMENT_ANALYSIS_ID, SPECIMEN_ANALYSIS_ID, STD_TEST_NAME_ID, ANALYTE_NAME, TEFSC_ABOVE_REFERENCE_RANGE, OTHER_COMMENT_TEXT, TEFSC_REFERENCE_RANGE
						  ,STD_ANALYSISMETHOD_ID,RESULT_UNIT_ID,[TEFSC_REFERENCE_RANGE_UNIT_ID]
			FROM         EFR.ANALYSIS_DETAIL)
			AS [t0]
			--[EFR].[ANALYSIS_DETAIL] AS [t0]
			LEFT OUTER JOIN [EFR].[STD_ANALYSISMETHOD] AS [t1] ON [t1].[ID] = [t0].[STD_ANALYSISMETHOD_ID]
			LEFT OUTER JOIN [EFR].[SPECIMEN_ANALYSIS] AS [t2] ON [t2].[SPECIMEN_ANALYSIS_ID] = [t0].[SPECIMEN_ANALYSIS_ID]
			LEFT OUTER JOIN [EFR].[FRAGMENT_ANALYSIS] AS [t3] ON [t3].[FRAGMENT_ANALYSIS_ID] = [t0].[FRAGMENT_ANALYSIS_ID]
			LEFT OUTER JOIN [EFR].STD_UNITS AS [std_units] on [std_units].ID = [t0].RESULT_UNIT_ID
			LEFT OUTER JOIN [EFR].STD_UNITS as [STD_UNITS1] on [STD_UNITS1].ID = [t0].[TEFSC_REFERENCE_RANGE_UNIT_ID]
			WHERE ([t2].[WKF_CASE_ACTIVITY_ID] = @activityId) OR ([t3].[WKF_CASE_ACTIVITY_ID] = @activityId)

		END
	END
GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R4'
           ,'0B'
           ,'001'
           ,0
           ,'29257 - Molybdenum out of order on Interpretation & Follow Up printed reports'
		   ,'Script will update usp_EFR_LETTER_ANALYTE_DETAILS stored procedure'
           ,'EFR'
           ,GETDATE())

GO
           