-------------------------------------------
--
-- VIA settings for MSSR
--
-------------------------------------------

declare @mssrId int
set @mssrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'MSSR'
)

delete from CRS_SETTINGS
where [NAME] = 'MssrMsatPageTimeout'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MssrMsatPageTimeout'  
		   ,'600000'            
		   ,'This is the page auto-save interval on the MSAT form in ms' 
		   ,'The save kicks in after the set amount of inactivity' 
		   ,GETDATE()                        
		   ,'awhiteleather') 

	
delete from CRS_SETTINGS
where [NAME] = 'MSSRServiceRequestingApp'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MSSRServiceRequestingApp'  
		   ,'MSSR'            
		   ,'MSSR previously used TBI, so reset to that if there is an issue' 
		   ,'This is sent to VIA as requestingApp' 
		   ,GETDATE()                        
		   ,'awhiteleather') 
		   
delete from CRS_SETTINGS
where [NAME] = 'MSSRServiceUseCreds'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MSSRServiceUseCreds'  
		   ,'true'            
		   ,'Set to true to use VIA creds, false not to' 
		   ,'Value used to determine if we send VIA creds or not' 
		   ,GETDATE()                        
		   ,'awhiteleather') 
		   
delete from CRS_SETTINGS
where [NAME] = 'MSSRServiceCred1'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MSSRServiceCred1'  
		   ,'CrsMssrViaOne!ID'            
		   ,'Used for VIA' 
		   ,'This is sent to VIA' 
		   ,GETDATE()                        
		   ,'awhiteleather')  
		   
delete from CRS_SETTINGS
where [NAME] = 'MSSRServiceCred2'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MSSRServiceCred2'  
		   ,'C7y5s4gF7t'            
		   ,'Used for VIA' 
		   ,'This is sent to VIA' 
		   ,GETDATE()                        
		   ,'awhiteleather')  
		   
go