/*
  Update Deployment Script for:
  1. spGetFiscalYear
  2. rpt_DVEIR_ReferalYearlyBreakdownReport
  3. rpt_DVEIR_ReferalOverviewReport
  4. rpt_DVEIR_DiagnosisReport
  5. prcGetReportingYears
  6. prcDVEIRReferralYearlyDiagnosisReport
  7. prcDVEIRReferralYearlyBreakdownReport
  8. prcDVEIRReferralProceduresReport
  9. prcDVEIRReferralOverviewRpt_JH
  10.prcDVEIRReferralOverviewReport_alt1
  11.prcDVEIRReferralOverviewReport_alt
  12.prcDVEIRReferralOverviewReport
  13.OLD_prcDVEIRReferralOverviewRpt
  14.DimTBIDateMonth




*/


/****** Object:  View [dbo].[DimTBIDateMonth]    Script Date: 5/18/2015 3:39:37 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DimTBIDateMonth]') AND type in (N'V'))
DROP VIEW [dbo].[DimTBIDateMonth]
GO

/****** Object:  View [dbo].[DimTBIDateMonth]    Script Date: 5/18/2015 3:39:37 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- MODIFICATION HISTORY
-- WHO		WHEN			WHAT
-- ------------------------------------------------------------------------------------------------------
-- Michael G 05-07-2015     Replaced dimCalendar with dimTime:- dimCalendar.FiscalYaer/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year
----------------------------------------------------------------------------------------------------------

CREATE VIEW [dbo].[DimTBIDateMonth]
AS
--SELECT MIN(Full_Day) AS StartMonth, MAX(Full_day) AS EndMonth,
-- Month_Short_Name AS [MonthName],MonthID,FiscalMonth,
--Quarter,FiscalQuarter,FiscalQuarterID,FYQuarter, EPRPQuarter,
--Year AS CalendarYear, FiscalYear
--FROM dbo.dimCalendar 
--WHERE Month_Short_Name IS NOT NULL
--GROUP BY Month_Short_Name,MonthID,FiscalMonth,
--Quarter,FiscalQuarter,FiscalQuarterID,FYQuarter,EPRPQuarter,
--Year, FiscalYear

SELECT 
		MIN(PK_Date) AS StartMonth,
		MAX(PK_Date) AS EndMonth,
		Month_Short_Name AS [MonthName],
		Month_ID AS MonthID,
		Fiscal_Month_Of_Year AS FiscalMonth,
		Quarter_Of_Year AS [Quarter],
		Fiscal_Quarter_Of_Year AS FiscalQuarter,
		FiscalQuarterID,
		FYQuarter, 
		EPRPQuarter,
		Calendar_Year AS CalendarYear,
		FiscalYear
FROM dbo.DimTime 
GROUP BY 
		Month_Short_Name,
		Month_ID,
		Fiscal_Month_Of_Year,
		Quarter_Of_Year,
		Fiscal_Quarter_Of_Year,
		Fiscal_Month_Of_Year,
		FiscalQuarterID,
		FYQuarter,
		EPRPQuarter,
		Calendar_Year, 
		FiscalYear
 


GO

/****** Object:  StoredProcedure [dbo].[spGetFiscalYear]    Script Date: 5/18/2015 3:03:34 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spGetFiscalYear]') AND type in (N'P'))
DROP PROCEDURE [dbo].[spGetFiscalYear]
GO

/****** Object:  StoredProcedure [dbo].[spGetFiscalYear]    Script Date: 5/18/2015 3:03:34 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROC [dbo].[spGetFiscalYear]
AS


-- MODIFICATION HISTORY:
-- WHEN			WHO		WHY
-- --------------------------------------------------------------------------------------------------
  
-- 05-07-2015   Michael G   Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year
      
BEGIN TRY
	SELECT 
	DISTINCT FiscalYear
	FROM dbo.DimTime
	WHERE FiscalYear > 0
	ORDER BY 1
END TRY
BEGIN CATCH
 RETURN
END CATCH
GO

/****** Object:  StoredProcedure [dbo].[rpt_DVEIR_ReferalYearlyBreakdownReport]    Script Date: 5/18/2015 1:44:07 PM ******/
DROP PROCEDURE [dbo].[rpt_DVEIR_ReferalYearlyBreakdownReport]
GO

/****** Object:  StoredProcedure [dbo].[rpt_DVEIR_ReferalYearlyBreakdownReport]    Script Date: 5/18/2015 1:44:07 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROC [dbo].[rpt_DVEIR_ReferalYearlyBreakdownReport]
  
  AS
  -- WHO		WHEN			WHAT
-- ------------------------------------------------------------------------------------------------------
-- Michael G 05-07-2015     Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year

 BEGIN TRY 
	SELECT DISTINCT
		V.VisnID,
		DATEPART(yy,R.REFERRAL_DATE) AS 'Fiscal Year',
		COUNT(DISTINCT R.Referral_ID)AS 'Referral Count',
		COUNT(CASE WHEN E.SendTo_DoD_DVEIR_FLAG = 1 THEN 1 END) AS 'Send_To_DVEIR',
		ISNULL(COUNT(DISTINCT R.Referral_ID),0) - ISNULL(COUNT(CASE WHEN E.SendTo_DoD_DVEIR_FLAG = 1 THEN 1 END),0) AS 'Remaining'
	FROM dbo.REFERRAL R (NOLOCK) JOIN DVEIR.ER_ENCOUNTER E
	ON R.REFERRAL_ID = E.REFERRAL_ID
	JOIN viewFacilitiesByVisn V ON R.STD_INSTITUTION_ID = V.institution_id
	JOIN dbo.DimTime dc (NOLOCK) ON DATEPART(yy,R.REFERRAL_DATE) = dc.FiscalYear
	WHERE R.STD_REFERRALSTS_ID = 14
	       --and V.VisnID = 'V01'
	GROUP BY 
	    V.VisnID,
		DATEPART(yy,R.REFERRAL_DATE)
	
END TRY
BEGIN CATCH
  RETURN
END CATCH


--   exec rpt_DVEIR_ReferalYearlyBreakdownReport 



GO


/****** Object:  StoredProcedure [dbo].[rpt_DVEIR_ReferalOverviewReport]    Script Date: 5/18/2015 2:54:20 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[rpt_DVEIR_ReferalOverviewReport]') AND type in (N'P'))
DROP PROCEDURE [dbo].[rpt_DVEIR_ReferalOverviewReport]


/****** Object:  StoredProcedure [dbo].[rpt_DVEIR_ReferalOverviewReport]    Script Date: 5/18/2015 2:54:20 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




CREATE PROC [dbo].[rpt_DVEIR_ReferalOverviewReport]
   --@VisnID varchar(50),
   @FiscalYear INT
  
  AS
  
	SELECT
		V.VisnID,
		DATEPART(yy,R.REFERRAL_DATE) AS 'Fiscal Year',
		CASE WHEN STD_REFERRALSTS_ID = 11 THEN 'New'
			 WHEN STD_REFERRALSTS_ID = 12 THEN 'In Process'
			 WHEN STD_REFERRALSTS_ID = 13 THEN 'Ready for Review'
			 WHEN STD_REFERRALSTS_ID = 14 THEN 'Ready to Send to DVEIR'
			 END AS 'Referral Status',
		MIN(R.REFERRAL_DATE) AS MinDate,
		MAX(R.REFERRAL_DATE) AS MaxDate,	 
		COUNT(DISTINCT Referral_ID)AS 'Referral Count'
	FROM dbo.REFERRAL R (NOLOCK) JOIN viewFacilitiesByVisn V
	ON R.STD_INSTITUTION_ID = V.institution_id
	JOIN dbo.DimTime d
	ON CONVERT(VARCHAR,R.REFERRAL_DATE,101)  = CONVERT(VARCHAR,d.PK_Date,101)
	--where datepart(yy,d.Full_Day) = @FiscalYear
	WHERE FiscalYear = @FiscalYear
	      -- and V.VisnID in (@VisnID)
	 
	GROUP BY 
	    V.VisnID,
		DATEPART(yy,R.REFERRAL_DATE),
		CASE WHEN STD_REFERRALSTS_ID = 11 THEN 'New'
			 WHEN STD_REFERRALSTS_ID = 12 THEN 'In Process'
			 WHEN STD_REFERRALSTS_ID = 13 THEN 'Ready for Review'
			 WHEN STD_REFERRALSTS_ID = 14 THEN 'Ready to Send to DVEIR'
			 END
	ORDER BY  3
	
	
	-- exec dbo.rpt_DVEIR_ReferalOverviewReport  2007
	
		-- exec dbo.rpt_DVEIR_ReferalOverviewReport  2010
		
		
	

GO



/****** Object:  StoredProcedure [dbo].[rpt_DVEIR_DiagnosisReport]    Script Date: 5/18/2015 3:09:55 PM ******/

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[rpt_DVEIR_DiagnosisReport]') AND type in (N'P'))
DROP PROCEDURE [dbo].[rpt_DVEIR_DiagnosisReport]
GO

/****** Object:  StoredProcedure [dbo].[rpt_DVEIR_DiagnosisReport]    Script Date: 5/18/2015 3:09:55 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROC [dbo].[rpt_DVEIR_DiagnosisReport]
     
  AS
  -- MODIFICATION HISTORY:
-- WHEN			WHO		WHY
-- --------------------------------------------------------------------------------------------------
-- 05-07-2015   Michael G   Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year
      
BEGIN TRY  
	SELECT DISTINCT
		DATEPART(yy,R.REFERRAL_DATE) AS 'Fiscal Year',
		CASE WHEN STD_REFERRALSTS_ID = 11 THEN 'New'
			 WHEN STD_REFERRALSTS_ID = 12 THEN 'In Process'
			 WHEN STD_REFERRALSTS_ID = 13 THEN 'Ready for Review'
			 WHEN STD_REFERRALSTS_ID = 14 THEN 'Ready to Send to DVEIR' ELSE 'Others'
			 END AS 'Referral Status',
		ED.CODE,
		CASE WHEN STD_REFERRALSTS_ID = 11 THEN 1
			 WHEN STD_REFERRALSTS_ID = 12 THEN 2
			 WHEN STD_REFERRALSTS_ID = 13 THEN 3
			 WHEN STD_REFERRALSTS_ID = 14 THEN 4 
			 ELSE 5
			 END AS SortOrder,
		COUNT(ee.Referral_ID)AS 'Referral Count'
	FROM dbo.REFERRAL R (NOLOCK) JOIN viewFacilitiesByVisn V
	ON R.STD_INSTITUTION_ID = V.institution_id
	JOIN dbo.DimTime dc (NOLOCK) ON DATEPART(yy,R.REFERRAL_DATE) = dc.FiscalYear
	JOIN DVEIR.ER_ENCOUNTER EE (NOLOCK) ON R.REFERRAL_ID = EE.REFERRAL_ID
	JOIN DVEIR.ER_DIAG_DTL ED (NOLOCK) ON EE.ER_ENCOUNTER_ID = ED.ER_ENCOUNTER_ID
	
	 
	GROUP BY 
	    DATEPART(yy,R.REFERRAL_DATE),
		CASE WHEN STD_REFERRALSTS_ID = 11 THEN 'New'
			 WHEN STD_REFERRALSTS_ID = 12 THEN 'In Process'
			 WHEN STD_REFERRALSTS_ID = 13 THEN 'Ready for Review'
			 WHEN STD_REFERRALSTS_ID = 14 THEN 'Ready to Send to DVEIR' ELSE 'Others'
			 END,
		ED.CODE,
		CASE WHEN STD_REFERRALSTS_ID = 11 THEN 1
			 WHEN STD_REFERRALSTS_ID = 12 THEN 2
			 WHEN STD_REFERRALSTS_ID = 13 THEN 3
			 WHEN STD_REFERRALSTS_ID = 14 THEN 4 
			 ELSE 5
			 END
	ORDER BY  4
END TRY
BEGIN CATCH
  RETURN
END CATCH	
	
	-- exec dbo.rpt_DVEIR_DiagnosisReport  
	
	

GO





/****** Object:  StoredProcedure [dbo].[prcGetReportingYears]    Script Date: 5/18/2015 3:12:43 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prcGetReportingYears]') AND type in (N'P'))
DROP PROCEDURE [dbo].[prcGetReportingYears]
GO

/****** Object:  StoredProcedure [dbo].[prcGetReportingYears]    Script Date: 5/18/2015 3:12:43 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




-- =====================================================================================
--
-- Author:		JPS
--
-- Create date: 16-Jun-2010
--
-- Description:	Get set of available years, either Fiscal or Calendar
--
-- Modification History
-- When			Who		What
-- -----------------------------------------------------------------------------------------
-- 21-Jul-2010	jps		Augment computation of calendar years so that maximum is
--                      current year + 1 in order to maintain parity with computation by 
--                      corresponding ASP.NET application method; else, an error will result
--                      when SSRS reports using parameters whose available values are
--                      supplied by this procedure HIDE these parameters in order to have the 
--                      parameter values supplied by the GUI ASP.NET presentation layer
--                      instead.
-- 05-07-2015  Michael G   Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year
                         
-- =========================================================================================
CREATE PROCEDURE [dbo].[prcGetReportingYears]
	-- Add the parameters for the stored procedure here
	@IsFisYr BIT = NULL,
	@IsCalYr BIT = NULL 
	 
AS
BEGIN TRY
	
	SET NOCOUNT ON;

    IF (@IsFisYr = 1)
		BEGIN
		SELECT 
			DISTINCT FiscalYear AS 'ReportYear'
			FROM dbo.DimTime
			WHERE --FiscalYear > 0
			      FiscalYear <= DATEPART(yyyy, GETDATE()) + 1
			ORDER BY FiscalYear DESC
		END
		
	ELSE IF (@IsCalYr = 1)
		BEGIN
		SELECT 
			DISTINCT Calendar_Year AS 'ReportYear'
			FROM dbo.DimTime
			WHERE Calendar_Year <= DATEPART(yyyy, GETDATE()) + 1
			ORDER BY Calendar_Year DESC
		END
	
END TRY

BEGIN CATCH
 RETURN
END CATCH




GO



/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralYearlyDiagnosisReport]    Script Date: 5/18/2015 2:47:28 PM ******/

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prcDVEIRReferralYearlyDiagnosisReport]') AND type in (N'P'))
DROP PROCEDURE [dbo].[prcDVEIRReferralYearlyDiagnosisReport]
GO

/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralYearlyDiagnosisReport]    Script Date: 5/18/2015 2:47:28 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROC [dbo].[prcDVEIRReferralYearlyDiagnosisReport]     

  
--
-- DESCRIPTION:
--
--		Populates the principal data set utilised by the corresponding SSRS report for the 
--      DVEIR VA Registry.
--
--		Business rules stipulate that the COMPLETED/PENDING DOD delivery STATUS of a Referral be 
--      determined by two flags in one or more ENCOUNTER(s) related to a Referral that signal whether 
--      the Referral in question is ready for dispatch to the DOD or has already been sent to the DOD.
--
-- AUTHOR(s):
--
--		jps
--
-- CREATION DATE:
--
--		01-Jul-2010
--
-- MODIFICATION HISTORY:
-- WHEN			WHO		WHY
-- --------------------------------------------------------------------------------------------------
-- 23-Jul-2010	jps		Add multi-valued parameters
--								@VisnID, 
--								@Diagnoses 
--                      specially processed by (new) user-defined function fncSplit. These parameters 
--                      replace Filters in the SSRS Report.
-- 23-Jul-2010	jps		Add WHERE clause involving parameter @VisnId to main SELECT statement.
-- 23-Jul-2010	jps		Add WHERE clauses involving parameter @Diagnoses to CASE expressions in 
--						SELECT statements that separately process Fiscal and Calendar Year data.
-- 29-Nov-2011	V.Naik  Modified to add records using union when no records exists for selected years,
--						will display zero in report.         
-- 05-07-2015   Michael G   Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year
             
-- ---------------------------------------------------------------------------------------------------

(
	-- Input Parameter(s)
	@IsFisYr BIT = 0,
	@IsCalYr BIT = 0,
	@VisnID	VARCHAR(8000) = NULL,   -- multiple, comma-separated values when not NULL 
	@Diagnoses VARCHAR(8000) = NULL	-- multiple, comma-separated values when not NULL 
)

AS

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
SET CONCAT_NULL_YIELDS_NULL OFF

BEGIN TRY

	--
	 -- Use an intermediary Table variable to store result-sets separately for fiscal and calendar years
	 -- because of the need to perform the control-breaks (i.e., GROUP BY) differently for each of them.
	 --

DECLARE @tblReferralYearlyDiagnosis TABLE
	( 
	  VId		varchar(8),	 
	  FisYr		smallint,
	  CalYr		smallint,
	  RefId		int,
	  RefStat	varchar(64),  
	  DiagCd	varchar(16)
	);

INSERT INTO @tblReferralYearlyDiagnosis
SELECT DISTINCT
	--
	v.VisnID,
	--
	dc.FiscalYear AS 'Fiscal Year',
	--
	dc.Calendar_Year AS 'Calendar Year',
	--
	r.Referral_ID,
	-- Delivery status of a Referral is with reference to one or more associated ENCOUNTERs
	CASE
		WHEN (	EXISTS
				(SELECT     REFERRAL_ID
				FROM         DVEIR.ER_ENCOUNTER
				WHERE     (SendTo_DoD_DVEIR_FLAG = 1) AND (ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
				)
			THEN 'Sent to DoD DVEIR' --'Referral Completed' --
		WHEN (	EXISTS
				(SELECT     REFERRAL_ID
				FROM         DVEIR.ER_ENCOUNTER
				WHERE     (Ready_to_Send_to_DVEIR_FLAG = 1) AND (ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
				)
			THEN 'Ready to Send to DVEIR' --'Referral Completed' --
		ELSE
			sr.NAME --'Referral Pending' --
		
	END AS 'Referral/Encounter Status',
	
	-- Delivery status of a Referral is with reference to one or more associated ENCOUNTERs 
	--CASE 
	--	WHEN e.Ready_to_Send_to_DVEIR_FLAG = 1 
	--		THEN 1 --'Referral Completed'	
	--	WHEN e.SendTo_DoD_DVEIR_FLAG = 1
	--	    THEN 1 -- 'Referral Completed'	
	--	ELSE 0	
	--  END AS 'Encounter Delivery Status',
    --
    
    ed.CODE as 'Diagnostic Code'
        
--
FROM dbo.REFERRAL r (nolock) 

	INNER JOIN DVEIR.ER_ENCOUNTER e (NOLOCK)
		ON r.REFERRAL_ID = e.REFERRAL_ID
	INNER JOIN DVEIR.ER_DIAG_DTL ed (nolock) 
		on e.ER_ENCOUNTER_ID = ed.ER_ENCOUNTER_ID
	INNER JOIN viewFacilitiesByVisn V
		ON r.STD_INSTITUTION_ID = V.institution_id
	INNER JOIN STD_REFERRALSTS sr 
		ON r.STD_REFERRALSTS_ID = sr.ID
	INNER JOIN dbo.DimTime dc (NOLOCK)
		ON CAST(CONVERT(varchar(10),r.CREATED,101) as datetime) = dc.PK_Date 
--
WHERE (v.VisnID IN (SELECT * FROM fncSplit(@VisnID, ','))
       OR @VisnID IS NULL);   

--SELECT * FROM @tblReferralYearlyDiagnosis;
	
DECLARE @Year TABLE
		(
		  EYear	SMALLINT
		  )
		  
DECLARE @VISN TABLE
		(
		  VisnID VARCHAR (20)
		  )
		  
INSERT INTO @VISN
SELECT
	DISTINCT VisnID
FROM
	viewFacilitiesByVisn

DECLARE @DiagCode TABLE
		(
		  Code VARCHAR (20)
		  )
		  
INSERT INTO @DiagCode
SELECT
	DISTINCT CODE       
FROM
	DVEIR.STD_ER_ICD9_CODE
WHERE EYE_DIAGNOSIS_FLAG = 1
      AND INACTIVE_FLAG = 0
ORDER BY CODE

-- Process report data for Fiscal Year(s)
IF (@IsFisYr = 1)
	BEGIN
		
		INSERT INTO @Year
		SELECT 
			DISTINCT FiscalYear --AS 'ReportYear'
			FROM dbo.DimTime
			WHERE FiscalYear <= DATEPART(yyyy, GETDATE()) + 1
			ORDER BY FiscalYear DESC
			
		SELECT	DISTINCT 
				--
		        vId,
		        -- 
				fisYr AS rptYr,
				--
				RefId AS 'InitiatedReferralId',
				-- Tag completion status with ReferralId to facilitate use of COUNT aggregate function
				CASE
					WHEN ((RefStat = 'Ready to Send to DVEIR' 
					       OR RefStat = 'Sent to DoD DvEIR')
					      AND (DiagCd IN ( SELECT * FROM fncSplit(@Diagnoses, ','))
					           OR @Diagnoses IS NULL))
					      THEN CAST(RefId AS VARCHAR) + ' ' + 'Referral Completed'
					ELSE NULL
				END AS 'ReferralStatus',
				--
				--COUNT(CASE
				--		WHEN refStat = 'Referral Completed' THEN 1 
				--	  END)AS 'Referrals Completed' 
				-- Count of PENDING Referrals
				--   COUNT(CASE
				--		WHEN refStat = 'Referral Pending' THEN 1 
				--	  END)AS 'Referrals Pending' 
				--	 
				DiagCd AS 'DiagnosticCd'
			--
		FROM @tblReferralYearlyDiagnosis
			--
			--ORDER BY vid, fisYr DESC
			--end
			
		UNION 
			SELECT V.VisnID,Y.EYEAR,NULL,NULL,DC.CODE
			FROM @YEAR Y, @VISN V,@DiagCode DC
			WHERE Y.EYEAR NOT IN (SELECT DISTINCT fisYr FROM @tblReferralYearlyDiagnosis)     
			ORDER BY fisYr DESC
		
	END -- @IsFisYr = 1)
		
-- Process report data for Calendar Year(s)
IF (@IsCalYr = 1)
	BEGIN
		
		INSERT INTO @Year
		SELECT 
		DISTINCT CAST(YEAR AS INT) --AS 'ReportYear'
		FROM dbo.DimTime
		WHERE CAST(YEAR AS INT) <= DATEPART(yyyy, GETDATE()) + 1
		ORDER BY CAST(YEAR AS INT) DESC
		
		SELECT	DISTINCT 
				--
		        vId,
		        -- 
				calYr AS rptYr,
				--
				RefId AS 'InitiatedReferralId',
				-- Tag completion status with ReferralId to facilitate use of COUNT aggregate function
				CASE
					WHEN ((RefStat = 'Ready to Send to DVEIR' 
					       OR RefStat = 'Sent to DoD DvEIR')
					      AND (DiagCd IN ( SELECT * FROM fncSplit(@Diagnoses, ','))
					           OR @Diagnoses IS NULL))
					      THEN CAST(RefId AS VARCHAR) + ' ' + 'Referral Completed'
					ELSE NULL
				END AS 'ReferralStatus',
				--
				--COUNT(CASE
				--		WHEN refStat = 'Referral Completed' THEN 1 
				--	  END)AS 'Referrals Completed' 
				-- Count of PENDING Referrals
				--   COUNT(CASE
				--		WHEN refStat = 'Referral Pending' THEN 1 
				--	  END)AS 'Referrals Pending' 
				-- 
				DiagCd AS 'DiagnosticCd'
			--
		FROM @tblReferralYearlyDiagnosis
			--  
			--ORDER BY vid, calYr DESC
		UNION 
			SELECT V.VisnID,Y.EYEAR,NULL,NULL,DC.CODE
			FROM @YEAR Y, @VISN V, @DiagCode DC
			WHERE Y.EYEAR NOT IN (SELECT DISTINCT calYr FROM @tblReferralYearlyDiagnosis)     
			ORDER BY calYr DESC
		
	END -- @IsCalYr = 1)		
	
END TRY

BEGIN CATCH

	RETURN

END CATCH	


GO

/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralYearlyBreakdownReport]    Script Date: 5/18/2015 2:23:06 PM ******/


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prcDVEIRReferralYearlyBreakdownReport]') AND type in (N'P'))
DROP PROCEDURE [dbo].[prcDVEIRReferralYearlyBreakdownReport]


/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralYearlyBreakdownReport]    Script Date: 5/18/2015 2:23:06 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROC [dbo].[prcDVEIRReferralYearlyBreakdownReport]

-- DESCRIPTION:
--
--		Populates the principal data set utilised by the corresponding SSRS report for the 
--      DVEIR VA Registry.
--
--		Business rules stipulate that the COMPLETED/PENDING DOD delivery STATUS of a Referral be 
--      determined by two flags in one or more ENCOUNTER(s) related to a Referral that signal whether 
--      the Referral in question is ready for dispatch to the DOD or has already been sent to the DOD.
--
-- AUTHOR(s):
--
--		jps
--
-- CREATION DATE:
--
--		21-Jun-2010
--
-- MODIFICATION HISTORY
-- WHO		WHEN			WHAT
-- --------------------------------------------------------------------------------------------------------
-- jh		02-Jul-2010		Alter Join between dimCalendar and Referral Tables because previous
--                          Join did not observe correct date semantics.
-- jps		08-Jul-2010     Alter Join statements involving ER_ENCOUNTER Table to prefix new 
--                          DVEIR Schema instead of previous dbo Schema.
-- V.Naik	29-Nov-2011     Modified to add records using union when no records exists for selected years,
--							will display zero in report.
-- Michael G 05-07-2015     Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year

------------------------------------------------------------------------------------------------------------
(
	-- Input Parameter(s)
	@IsFisYr BIT = 0,
	@IsCalYr BIT = 0
)
  
AS

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
SET CONCAT_NULL_YIELDS_NULL OFF

BEGIN TRY
	
-- Use an intermediary Table variable to store result-sets separately for fiscal and calendar years
-- because of the need to perform the control-breaks (i.e., GROUP BY) differently for each of them.
--
DECLARE @tblReferralYearlyBreakdown TABLE
	( 
	  vId varchar(8),
	  refId int,
	  fisYr	smallint,
	  calYr smallint,
	  refStat varchar(64)	  
	);

INSERT INTO @tblReferralYearlyBreakdown
SELECT DISTINCT
	--
	v.VisnID,
	--
	r.Referral_ID,
	--
	dc.FiscalYear AS 'Fiscal_Year',
	--
	dc.Calendar_Year AS 'Calendar Year',
	
-- Referral/Encounter STATUS business rule stipulates that Delivery status 
-- of a Referral is with reference to one or more associated ENCOUNTERs 
	CASE
		WHEN (	EXISTS
				(SELECT     REFERRAL_ID
				FROM         DVEIR.ER_ENCOUNTER
				WHERE     (SendTo_DoD_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
				)
			THEN 'Referral Completed'
		WHEN (	EXISTS
				(SELECT     REFERRAL_ID
				FROM         DVEIR.ER_ENCOUNTER
				WHERE     (Ready_to_Send_to_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
				)
			THEN 'Referral Completed'
		ELSE
			'Referral Pending'			
	END AS 'Referral Status' 
	-- Delivery status of a Referral is with reference to one or more associated ENCOUNTERs 
	--CASE 
	--	WHEN (e.Ready_to_Send_to_DVEIR_FLAG = 1 
	--	      OR e.SendTo_DoD_DVEIR_FLAG = 1)
	--		THEN 'Referral Completed'
	--	WHEN ( ISNULL(e.Ready_to_Send_to_DVEIR_FLAG, 0) = 0
	--	       OR ISNULL(e.SendTo_DoD_DVEIR_FLAG, 0) = 0)
	--		THEN 'Referral Pending'
	--END AS 'Referral Status'   

FROM dbo.REFERRAL r (nolock) 
    --
    INNER JOIN DVEIR.ER_ENCOUNTER e
		ON r.REFERRAL_ID = e.REFERRAL_ID
	--
	INNER JOIN viewFacilitiesByVisn v 
		ON ((r.STD_INSTITUTION_ID = v.institution_id))
		    -- AND r.STD_INSTITUTION_ID IS NOT NULL)
		    --OR r.STD_INSTITUTION_ID is null)
	--	    
	INNER JOIN dbo.DimTime dc (nolock) 
	    --ON r.CREATED = dc.Full_Day
	    ON CAST(CONVERT(varchar(10),r.CREATED,101) as datetime) = dc.PK_Date
	    
-- Enable line below only when DEBUGGING:
-- SELECT * FROM @tblReferralYearlyBreakdown;
		  
DECLARE @VISN TABLE
	(
	  VisnID VARCHAR (20)
	  )
INSERT INTO @VISN
SELECT
	DISTINCT VisnID
FROM
	viewFacilitiesByVisn

DECLARE @Year TABLE
	(
	  EYear	SMALLINT
	  )

-- If FISCAL year

IF (@IsFisYr = 1)
	BEGIN
		INSERT INTO @Year
		SELECT 
			DISTINCT FiscalYear -- AS 'ReportYear'
			FROM dbo.DimTime
			WHERE FiscalYear <= DATEPART(yyyy, GETDATE()) + 1
			ORDER BY FiscalYear DESC
		
		SELECT	vId, 
				fisYr AS rptYr,
				-- Count of ALL Referrals
				COUNT(refId) as 'Referral_Count',
				-- Count of COMPLETED Referrals
				COUNT(CASE
						WHEN refStat = 'Referral Completed' THEN 1 
					  END)AS 'Referrals_Completed', 
				-- Count of PENDING Referrals
			    COUNT(CASE
						WHEN refStat = 'Referral Pending' THEN 1 
					  END)AS 'Referrals_Pending' 
		--
		FROM @tblReferralYearlyBreakdown tryb
		--
		GROUP BY vId,
				 fisYr
			-- 
		UNION 
			SELECT V.VisnID,Y.EYEAR,0,0,0
			FROM @YEAR Y, @VISN V
			WHERE Y.EYEAR NOT IN (SELECT DISTINCT fisYr FROM @tblReferralYearlyBreakdown)     
			ORDER BY fisYr DESC
		
	END -- @IsFisYr = 1)
	--		
-- If CALENDAR year	
--			 
ELSE IF (@IsCalYr = 1)
	BEGIN
		INSERT INTO @Year
		SELECT 
		DISTINCT CAST(YEAR AS INT) --AS 'ReportYear'
		FROM dbo.DimTime
		WHERE CAST(YEAR AS INT) <= DATEPART(yyyy, GETDATE()) + 1
		ORDER BY CAST(YEAR AS INT) DESC
		
		SELECT	vId, 
				calYr AS rptYr,
				-- Count of ALL Referrals
				COUNT(refId) AS 'Referral_Count',
				-- Count of COMPLETED Referrals
				COUNT(CASE
						WHEN refStat = 'Referral Completed' THEN 1 
					  END)AS 'Referrals_Completed', 
				-- Count of PENDING Referrals
				COUNT(CASE
						WHEN refStat = 'Referral Pending' THEN 1 
					  END)AS 'Referrals_Pending' 
		--
		FROM @tblReferralYearlyBreakdown tryb
		--
		GROUP BY vId,
				 calYr
				-- 
		UNION 
			SELECT V.VisnID,Y.EYEAR,0,0,0
			FROM @YEAR Y, @VISN V
			WHERE Y.EYEAR NOT IN (SELECT DISTINCT calYr FROM @tblReferralYearlyBreakdown)     
			ORDER BY calYr DESC
		  
	END -- Else If (@IsCalYr = 1)
	
END TRY

BEGIN CATCH
  
	RETURN;

END CATCH



GO


/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralProceduresReport]    Script Date: 5/18/2015 2:15:55 PM ******/
DROP PROCEDURE [dbo].[prcDVEIRReferralProceduresReport]
GO

/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralProceduresReport]    Script Date: 5/18/2015 2:15:55 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROC [dbo].[prcDVEIRReferralProceduresReport]     

--
-- DESCRIPTION:
--
--		Populates the principal data set utilised by the corresponding SSRS report for the 
--      DVEIR VA Registry.
--
--		Business rules stipulate that the COMPLETED/PENDING DOD delivery STATUS of a Referral be 
--      determined by two flags in one or more ENCOUNTER(s) related to a Referral that signal whether 
--      the Referral in question is ready for dispatch to the DOD or has already been sent to the DOD.
--
-- AUTHOR(s):
--
--		jps
--
-- CREATION DATE:
--
--		12-Jul-2010
--
-- MODIFICATION HISTORY:
-- WHEN		WHO		WHY
-- ----------------------------------------------------------------------------------------------------
-- 23-Jul-2010	jps		Add multi-valued parameters
--								@VisnID, 
--								@Diagnoses 
--                      specially processed by (new) user-defined function fncSplit. These parameters 
--                      replace Filters in the SSRS Report.
-- 23-Jul-2010	jps		Add WHERE clause involving parameter @VisnId to main SELECT statement.
-- 23-Jul-2010	jps		Add WHERE clauses involving parameter @Diagnoses to CASE expressions in 
--						SELECT statements that separately process Fiscal and Calendar Year data.
-- 29-Nov-2011	V.Naik	Modified to add records using union when no records exists for selected years,
--						will display zero in report.      
-- 05-07-2015  Michael G    Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year
                 
-- ---------------------------------------------------------------------------------------------------

(
	-- Input Parameter(s)
	@IsFisYr BIT = 0,
	@IsCalYr BIT = 0,
	@VisnID	VARCHAR(8000) = NULL,   -- multiple, comma-separated values when not NULL 
	@Diagnoses VARCHAR(8000) = NULL	-- multiple, comma-separated values when not NULL 
)

AS

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
SET CONCAT_NULL_YIELDS_NULL OFF

BEGIN TRY

	--
	 -- Use an intermediary Table variable to store result-sets separately for fiscal and calendar years
	 -- because of the need to perform the control-breaks (i.e., GROUP BY) differently for each of them.
	 --
DECLARE @tblReferralProcedure TABLE
	( 
	  VId			varchar(8),	 
	  FisYr			smallint,
	  CalYr			smallint,
	  RefId			int,
	  RefStat		varchar(64),  
	  DiagCd		varchar(16),
	  ProcCd		varchar(128)
	);

INSERT INTO @tblReferralProcedure
SELECT DISTINCT
	--
	v.VisnID,
	--
	dc.FiscalYear AS 'Fiscal Year',
	--
	dc.Calendar_Year AS 'Calendar Year',
	--
	r.Referral_ID,
	-- Business Rule: Delivery status of a Referral is with reference to one or more associated ENCOUNTERs
	CASE
		WHEN (	EXISTS
				(SELECT     REFERRAL_ID
				FROM         DVEIR.ER_ENCOUNTER
				WHERE     (SendTo_DoD_DVEIR_FLAG = 1) AND (ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
				)
			THEN 'Sent to DoD DVEIR' --'Referral Completed' --
		WHEN (	EXISTS
				(SELECT     REFERRAL_ID
				FROM         DVEIR.ER_ENCOUNTER
				WHERE     (Ready_to_Send_to_DVEIR_FLAG = 1) AND (ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
				)
			THEN 'Ready to Send to DVEIR' --'Referral Completed' --
		ELSE
			sr.NAME --'Referral Pending' --
		
	END AS 'Referral/Encounter Status',
	--
	-- NOTE: To  be examined if the above set of sub-queries is necessary when the
	--       Case expression below yiels the same results
	--CASE 
		--WHEN e.Ready_to_Send_to_DVEIR_FLAG = 1 
		--	THEN 'Ready to Send to DVEIR' --'Referral Completed'	
		--WHEN e.SendTo_DoD_DVEIR_FLAG = 1
		--    THEN 'Sent to DoD DVEIR' -- 'Referral Completed'	
		--ELSE sr.NAME	
	--END AS 'Referral/Encounter Status',
    --
    ed.CODE as 'DiagnosticCode',
    --
    ep.CODE as 'ProceduralCode'        
--
FROM dbo.REFERRAL r (nolock) 
	--
	INNER JOIN dveir.ER_ENCOUNTER e (NOLOCK)
		ON r.REFERRAL_ID = e.REFERRAL_ID
	--
	INNER JOIN DVEIR.ER_DIAG_DTL ed (nolock) 
		on e.ER_ENCOUNTER_ID = ed.ER_ENCOUNTER_ID
	--
	INNER JOIN DVEIR.ER_PROCEDURE_DTL ep (nolock) 
		on e.ER_ENCOUNTER_ID = ep.ER_ENCOUNTER_ID
	--
	INNER JOIN viewFacilitiesByVisn V
		ON r.STD_INSTITUTION_ID = V.institution_id
	--
	INNER JOIN STD_REFERRALSTS sr 
		ON r.STD_REFERRALSTS_ID = sr.ID
	--
	INNER JOIN dbo.DimTime dc (NOLOCK)
		ON CAST(CONVERT(varchar(10),r.CREATED,101) as datetime) = dc.PK_Date  
--
WHERE (v.VisnID IN (SELECT * FROM fncSplit(@VisnID, ','))
       OR @VisnID IS NULL);     
		    
	-- Enable for DEBUGGING
	--SELECT * FROM @tblReferralProcedure;
	
DECLARE @Year TABLE
	(
	  EYear	SMALLINT
	  )
		  
DECLARE @VISN TABLE
		(
		  VisnID VARCHAR (20)
		  )
		  
INSERT INTO @VISN
SELECT
	DISTINCT VisnID
FROM
	viewFacilitiesByVisn

DECLARE @DiagCode TABLE
		(
		  Code VARCHAR (20)
		  )
		  
INSERT INTO @DiagCode
SELECT
	DISTINCT CODE       
FROM
	DVEIR.STD_ER_ICD9_CODE
WHERE EYE_DIAGNOSIS_FLAG = 1
      AND INACTIVE_FLAG = 0
ORDER BY CODE

-- Process report data for Fiscal Year(s)
IF (@IsFisYr = 1)
	BEGIN
	INSERT INTO @Year
	SELECT 
		DISTINCT FiscalYear --AS 'ReportYear'
		FROM dimCalendar
		WHERE FiscalYear <= DATEPART(yyyy, GETDATE()) + 1
		ORDER BY FiscalYear DESC
		
		SELECT	DISTINCT
				--
		        vId,
		        -- 
				fisYr AS rptYr,
				--
				RefId AS 'InitiatedReferralId',
				-- Tag completion status with ReferralId to facilitate use of COUNT aggregate function
				CASE
					WHEN ((RefStat = 'Ready to Send to DVEIR' 
					       OR RefStat = 'Sent to DoD DvEIR')
					      AND (DiagCd IN ( SELECT * FROM fncSplit(@Diagnoses, ','))
					           OR @Diagnoses IS NULL))
					      THEN CAST(RefId AS VARCHAR) + ' ' + 'Referral Completed'
					ELSE NULL
				END AS 'ReferralStatus',
				--
				DiagCd AS 'DiagnosticCd',
				--	
				CASE
					WHEN ((RefStat = 'Ready to Send to DVEIR' 
					       OR RefStat = 'Sent to DoD DvEIR')
					      AND (DiagCd IN ( SELECT * FROM fncSplit(@Diagnoses, ','))
					           OR @Diagnoses IS NULL))
					THEN 'Procedure ' + ProcCd + ' performed for Diagnosis ' + DiagCd + ' on Completed Referral ' + CAST(RefId AS VARCHAR)
					ELSE NULL
				END AS 'ProceduralCd'
		--
		FROM @tblReferralProcedure 
		--
		--ORDER BY vid, fisYr DESC
		
		UNION 
		SELECT V.VisnID,Y.EYEAR,NULL,NULL,DC.CODE,NULL
		FROM @YEAR Y, @VISN V,@DiagCode DC
		WHERE Y.EYEAR NOT IN (SELECT DISTINCT fisYr FROM @tblReferralProcedure)     
		ORDER BY fisYr DESC
	
	END -- @IsFisYr = 1)
		
-- Process report data for Calendar Year(s)
IF (@IsCalYr = 1)
	BEGIN
	
	INSERT INTO @Year
	SELECT 
		DISTINCT FiscalYear --AS 'ReportYear'
		FROM dimCalendar
		WHERE FiscalYear <= DATEPART(yyyy, GETDATE()) + 1
		ORDER BY FiscalYear DESC
		
		SELECT	DISTINCT 
				--
		        vId,
		        -- 
				calYr AS rptYr,
				--
				RefId AS 'InitiatedReferralId',
				-- Tag completion status with ReferralId to facilitate use of COUNT aggregate function
				CASE
					WHEN (RefStat = 'Ready to Send to DVEIR' 
					      OR RefStat = 'Sent to DoD DvEIR')
					     AND (DiagCd IN ( SELECT * FROM fncSplit(@Diagnoses, ','))
					           OR @Diagnoses IS NULL) 
				    THEN CAST(RefId AS VARCHAR) + ' ' + 'Referral Completed'				
					ELSE NULL
				END AS 'ReferralStatus',
				--
				DiagCd AS 'DiagnosticCd',	 
				--
				CASE
					WHEN ((RefStat = 'Ready to Send to DVEIR' 
					       OR RefStat = 'Sent to DoD DvEIR')
					      AND (DiagCd IN ( SELECT * FROM fncSplit(@Diagnoses, ','))
					           OR @Diagnoses IS NULL))
					THEN 'Procedure ' + ProcCd + ' performed for Diagnosis ' + DiagCd + ' on Completed Referral ' + CAST(RefId AS VARCHAR)
					ELSE NULL
				END AS 'ProceduralCd'
		--
		FROM @tblReferralProcedure
		--      
		--ORDER BY vid, calYr DESC
		
		UNION 
		SELECT V.VisnID,Y.EYEAR,NULL,NULL,DC.CODE,NULL
		FROM @YEAR Y, @VISN V, @DiagCode DC
		WHERE Y.EYEAR NOT IN (SELECT DISTINCT calYr FROM @tblReferralProcedure)     
		ORDER BY calYr DESC
	
	END -- @IsCalYr = 1)		
	
END TRY

BEGIN CATCH

	RETURN

END CATCH	


GO

/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralOverviewRpt_JH]    Script Date: 5/18/2015 3:27:36 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prcDVEIRReferralOverviewRpt_JH]') AND type in (N'P'))
DROP PROCEDURE [dbo].[prcDVEIRReferralOverviewRpt_JH]
GO

/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralOverviewRpt_JH]    Script Date: 5/18/2015 3:27:36 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



-- WHO		WHEN			WHAT
-- ------------------------------------------------------------------------------------------------------
-- Michael G 05-07-2015     Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year



CREATE PROC [dbo].[prcDVEIRReferralOverviewRpt_JH]
 (
	-- Input Parameters
	@IsFisYr BIT = NULL,
	@IsCalYr BIT = NULL,
	@RptYrSel SMALLINT = NULL
 )
  
 AS
 
 --
 -- Use an intermediary Table variable to store result-sets separately for fiscal and calendar years
 -- because of the need to perform the control-breaks (i.e., GROUP BY) differently for each of them.
 --
 DECLARE @tblReferralOverview TABLE
	( 
	  vId varchar(8),
	  refId int,
	  fisYr	smallint,
	  calYr smallint,
	  refStat varchar(64),
	  refCd	varchar(64),
	  sortOrder smallint 
	);
	
INSERT INTO @tblReferralOverview 	
SELECT	DISTINCT
		--
		V.VisnID,
		--
		r.Referral_ID,
		--
		dc.FiscalYear,
		--
		CalendarYear = datepart(yyyy,R.REFERRAL_DATE),		--CAST(dc.Year AS smallint), --,
		--	
		CASE
			WHEN (	EXISTS
					(SELECT     REFERRAL_ID
					FROM         DVEIR.ER_ENCOUNTER
					WHERE     (SendTo_DoD_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
					)
				THEN 'Sent to DVEIR'
			WHEN (	EXISTS
					(SELECT     REFERRAL_ID
					FROM         DVEIR.ER_ENCOUNTER
					WHERE     (Ready_to_Send_to_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
					)
				THEN 'Ready to Send to DVEIR'
			ELSE
				sr.NAME
			
			--WHEN sr.CODE IN ('DVEIR_NEW', 
			--				 'DVEIR_IN_PROCESS', 
			--				 'DVEIR_READY_FOR_REVIEW',
			--				 'DVEIR_Returned')
			--	THEN sr.NAME
			--WHEN (e.Ready_to_Send_to_DVEIR_FLAG = 1
			--      AND (ISNULL(e.SendTo_DoD_DVEIR_FLAG, 0) = 0))
			--	THEN 'Ready to Send to DVEIR'
			--WHEN (e.SendTo_DoD_DVEIR_FLAG = 1)
			--	THEN 'Sent to DVEIR'	
			
		END AS 'Referral/Encounter Status',
		--
		--sr.NAME AS 'Referral Status',
		--
		sr.CODE AS 'Referral Code',
		--
		--CASE 
	 --			     WHEN 'Referral/Encounter Status' = 'New' THEN 1
	 --			     WHEN 'Referral/Encounter Status' = 'In Process' THEN 2
	 --			     WHEN 'Referral/Encounter Status' = 'Returned' THEN 3
	 --			     WHEN 'Referral/Encounter Status' = 'Ready for Review' THEN 4
	 --			     WHEN 'Referral/Encounter Status'= 'Ready to Send to DVEIR' THEN 5
	 --			     WHEN 'Referral/Encounter Status' = 'Sent to DVEIR' THEN 6
	 			     
	 --	END AS 'Sort Order'
	    --
		sr.SORT_ORDER
		--
FROM dbo.REFERRAL R (nolock) 
		INNER JOIN DVEIR.ER_ENCOUNTER e (NOLOCK)
			ON r.REFERRAL_ID = e.REFERRAL_ID
		INNER JOIN viewFacilitiesByVisn V
			ON R.STD_INSTITUTION_ID = V.institution_id
		INNER JOIN STD_REFERRALSTS sr 
			ON R.STD_REFERRALSTS_ID = sr.ID
		INNER JOIN dbo.DimTime dc (NOLOCK)
--		      ON dc.Full_Day = R.CREATED
		      ON dc.PK_Date
		     		      = 
		      CAST(CONVERT(varchar(10),R.CREATED,101) as datetime) 
		      
			--ON dc.Full_Day = R.REFERRAL_DATE

			
WHERE  -- Report YEAR selection
	   ( -- Fiscal Year
	     (@IsFisYr = 1
          AND (@IsCalYr IS NULL OR @IsCalYr =0)
          AND dc.FiscalYear = @RptYrSel)
         OR -- Calendar Year
            (@IsCalYr = 1
             AND (@IsFisYr IS NULL OR @IsFisYr = 0)
             AND dc.Calendar_Year = CAST(@RptYrSel AS VARCHAR)))
       -- Referral/Encounter STATUS business rule
       --AND 
   --    ((sr.CODE IN ('DVEIR_NEW', 
			--			 'DVEIR_IN_PROCESS', 
			--			 'DVEIR_READY_FOR_REVIEW'))
			--OR (e.Ready_to_Send_to_DVEIR_FLAG = 1
			--    OR e.SendTo_DoD_DVEIR_FLAG = 1))			
						
--ORDER BY SORT_ORDER

--Enable line below only for DEBUGGING         
--SELECT * from @tblReferralOverview

 -- If fiscal year
 IF (@IsFisYr = 1)
    BEGIN
		SELECT	vId, 
		        refId,
		        fisYr AS rptYr,
	 			refStat,
	 			-- Override sort order of status field in Table var to conform to report requirement
	 			CASE 
	 			     WHEN refStat = 'New' THEN 1
	 			     WHEN refStat = 'In Process' THEN 2
	 			     WHEN refStat = 'Returned' THEN 3
	 			     WHEN refStat = 'Ready for Review' THEN 4
	 			     WHEN refStat = 'Ready to Send to DVEIR' THEN 5
	 			     WHEN refStat = 'Sent to DVEIR' THEN 6     
	 			END AS sortOrder,
	 			--   
	 			--sortOrder,
	 			--
				refCd 
		--
		FROM @tblReferralOverview tro
		
		--GROUP BY vId,
		--         fisYr ,
		--         refStat,
		--         refCd,
		--         sortOrder
		         
		ORDER BY --vId,
		         --fisYr ,
		         sortOrder
		         --refStat,
		         --refCd
		         	
	END
 -- else if calendar year
 ELSE IF (@IsCalYr = 1)
 
        BEGIN
			SELECT	vId,
			        refId, 
					calYr AS rptYr,
	 				refStat ,
	 				-- Override sort order of status field in Table var to conform to report requirement
	 				CASE 
	 					 WHEN refStat = 'New' THEN 1
	 					 WHEN refStat = 'In Process' THEN 2
	 					 WHEN refStat = 'Returned' THEN 3
	 					 WHEN refStat = 'Ready for Review' THEN 4
	 					 WHEN refStat = 'Ready to Send to DVEIR' THEN 5
	 					 WHEN refStat = 'Sent to DVEIR' THEN 6     
	 				END AS sortOrder,
	 				--
					refCd
					--COUNT(DISTINCT refId) as 'Referral Count'  
			--		
			FROM @tblReferralOverview
			--
			--GROUP BY vId,
			--		 calYr,
			--		 sortOrder,
			--		 refStat,
			--		 refCd				 
			--
			ORDER BY sortOrder
		END
	 



GO
/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralOverviewReport_alt1]    Script Date: 5/18/2015 3:30:15 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prcDVEIRReferralOverviewReport_alt1]') AND type in (N'P'))
DROP PROCEDURE [dbo].[prcDVEIRReferralOverviewReport_alt1]
GO

/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralOverviewReport_alt1]    Script Date: 5/18/2015 3:30:15 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO








CREATE PROC [dbo].[prcDVEIRReferralOverviewReport_alt1]
--
-- DESCRIPTION:
--
--		Populates the principal data set utilised by the corresponding SSRS report for the 
--      DVEIR VA Registry.
--
--		Business rules stipulate that the COMPLETED/PENDING DOD delivery STATUS of a Referral be 
--      determined by two flags in one or more ENCOUNTER(s) related to a Referral that signal whether 
--      the Referral in question is ready for dispatch to the DOD or has already been sent to the DOD.
--
-- AUTHOR(s):
--
--		jps
--
-- CREATION DATE:
--
--		14-Jun-2010
--
-- MODIFICATION HISTORY
-- WHO		WHEN			WHAT
-- ------------------------------------------------------------------------------------------------------
-- jh		02-Jul-2010		Alter Join between dimCalendar and Referral Tables because previous Join
--                          did not observe proper date semantics.
-- jps		08-Jul-2010     Alter Join statements involving ER_ENCOUNTER Table to prefix new DVEIR Schema 
--                          instead of previous dbo Schema.
-- jps		09-Jul-2010		Disable third (@RptYrSel) parameter until mechanism for receiving/processing
--							multi-valued report parameters is determined and finalised.
--                          NOTE: The corresponding SSRS Report continues to accept a multi-valued 
--                                parameter representing a YEAR; it is used as a dataset filter but it is 
--                                not passed to this stored procedure.
-- Michael G 05-07-2015     Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year.
----------------------------------------------------------------------------------------------------------

 (
	-- Input Parameters
	@IsFisYr BIT = NULL,
	@IsCalYr BIT = NULL
	-- 3rd parameter temporarily disabled --> @RptYrSel AS dbo.ReportYear = NULL
 )
  
 AS
 
 --
 -- Use an intermediary Table variable to store result-sets separately for fiscal and calendar years
 -- because of the need to perform the control-breaks (i.e., GROUP BY) differently for each of them.
 --	
 DECLARE @tblReferralOverview TABLE
( 
  vId varchar(8),
  refId int,
  fisYr	smallint,
  calYr smallint,
  refStat varchar(64),
  refCd	varchar(64),
  sortOrder smallint 
);
	
INSERT INTO @tblReferralOverview 	
SELECT	DISTINCT
		--
		V.VisnID,
		--
		r.Referral_ID,
		--
		dc.FiscalYear,
		--
		CalendarYear = datepart(yyyy,R.REFERRAL_DATE),		--CAST(dc.Year AS smallint), --,
		-- Referral/Encounter STATUS business rule
		CASE
			WHEN (	EXISTS
					(SELECT     REFERRAL_ID
					FROM         DVEIR.ER_ENCOUNTER
					WHERE     (SendTo_DoD_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
					)
				THEN 'Sent to DVEIR'
			WHEN (	EXISTS
					(SELECT     REFERRAL_ID
					FROM         DVEIR.ER_ENCOUNTER
					WHERE     (Ready_to_Send_to_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
					)
				THEN 'Ready to Send to DVEIR'
			ELSE
				sr.NAME
			
			--WHEN sr.CODE IN ('DVEIR_NEW', 
			--				 'DVEIR_IN_PROCESS', 
			--				 'DVEIR_READY_FOR_REVIEW',
			--				 'DVEIR_Returned')
			--	THEN sr.NAME
			--WHEN (e.Ready_to_Send_to_DVEIR_FLAG = 1
			--      AND (ISNULL(e.SendTo_DoD_DVEIR_FLAG, 0) = 0))
			--	THEN 'Ready to Send to DVEIR'
			--WHEN (e.SendTo_DoD_DVEIR_FLAG = 1)
			--	THEN 'Sent to DVEIR'	
			
		END AS 'Referral/Encounter Status',
		--
		sr.CODE AS 'Referral Code',
	    --
		sr.SORT_ORDER
		--
FROM dbo.REFERRAL R (nolock) 
		INNER JOIN DVEIR.ER_ENCOUNTER e (NOLOCK)
			ON r.REFERRAL_ID = e.REFERRAL_ID
		INNER JOIN viewFacilitiesByVisn V
			ON R.STD_INSTITUTION_ID = V.institution_id
		INNER JOIN STD_REFERRALSTS sr 
			ON R.STD_REFERRALSTS_ID = sr.ID
		INNER JOIN dbo.DimTime dc (NOLOCK)
--		      ON dc.Full_Day = R.CREATED
		      ON dc.PK_Date
		     		      = 
		      CAST(CONVERT(varchar(10),R.CREATED,101) as datetime) 
--
-- WHERE clause is dependent on 3rd parameter (@RptYrSel) which is temporarily disabled.
--	
--WHERE  -- Report YEAR selection
--       @RptYrSel IS NOT NULL
--       AND 
--		   ( -- Fiscal Year
--		     (@IsFisYr = 1
--	          AND (@IsCalYr IS NULL OR @IsCalYr =0)
--	          AND CAST(dc.FiscalYear AS VARCHAR) IN @RptYrSel)
--	         OR -- Calendar Year
--	            (@IsCalYr = 1
--	             AND (@IsFisYr IS NULL OR @IsFisYr = 0)
--	             AND dc.Year = CAST(@RptYrSel AS VARCHAR)))
       
   --AND 
   --    ((sr.CODE IN ('DVEIR_NEW', 
			--			 'DVEIR_IN_PROCESS', 
			--			 'DVEIR_READY_FOR_REVIEW'))
			--OR (e.Ready_to_Send_to_DVEIR_FLAG = 1
			--    OR e.SendTo_DoD_DVEIR_FLAG = 1))			
						
--ORDER BY SORT_ORDER

--Enable line below only for DEBUGGING         
--SELECT * from @tblReferralOverview
	
 -- If fiscal year
 IF (@IsFisYr = 1)
    BEGIN
		SELECT	--vId, 
		        --refId,
		        --fisYr AS rptYr,
	 			refStat,
	 			-- Override sort order of status field in Table var to conform to report requirement
	 			CASE 
	 			     WHEN refStat = 'New' THEN 1
	 			     WHEN refStat = 'In Process' THEN 2
	 			     WHEN refStat = 'Returned' THEN 3
	 			     WHEN refStat = 'Ready for Review' THEN 4
	 			     WHEN refStat = 'Ready to Send to DVEIR' THEN 5
	 			     WHEN refStat = 'Sent to DVEIR' THEN 6     
	 			END AS sortOrder,
	 			--
	 			COUNT(DISTINCT refId) AS 'RefCnt' 
	 			--
				--refCd
		--
		FROM @tblReferralOverview tro
		
		GROUP BY --vId,
		        --fisYr ,
		        refStat,
		        --refCd,
		        sortOrder
		         
		ORDER BY --vId,
		         --fisYr ,
		         sortOrder
		         --refStat,
		         --refCd
		         	
	END
 -- else if calendar year
 ELSE IF (@IsCalYr = 1)
 
        BEGIN
			SELECT	vId,
			        refId, 
					calYr AS rptYr,
	 				refStat ,
	 				-- Override sort order of status field in Table var to conform to report requirement
	 				CASE 
	 					 WHEN refStat = 'New' THEN 1
	 					 WHEN refStat = 'In Process' THEN 2
	 					 WHEN refStat = 'Returned' THEN 3
	 					 WHEN refStat = 'Ready for Review' THEN 4
	 					 WHEN refStat = 'Ready to Send to DVEIR' THEN 5
	 					 WHEN refStat = 'Sent to DVEIR' THEN 6     
	 				END AS sortOrder,
	 				--
					refCd
					--COUNT(DISTINCT refId) as 'Referral Count'  
			--		
			FROM @tblReferralOverview
			--
			--GROUP BY vId,
			--		 calYr,
			--		 sortOrder,
			--		 refStat,
			--		 refCd				 
			--
			ORDER BY sortOrder
		END
	 




GO


/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralOverviewReport_alt]    Script Date: 5/18/2015 3:32:29 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prcDVEIRReferralOverviewReport_alt]') AND type in (N'P'))
DROP PROCEDURE [dbo].[prcDVEIRReferralOverviewReport_alt]
GO

/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralOverviewReport_alt]    Script Date: 5/18/2015 3:32:29 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- MODIFICATION HISTORY
-- WHO		WHEN			WHAT
-- ------------------------------------------------------------------------------------------------------
-- Michael G 05-07-2015     Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year.
----------------------------------------------------------------------------------------------------------


CREATE PROC [dbo].[prcDVEIRReferralOverviewReport_alt]
 
 (
	-- Input Parameters
	@IsFisYr BIT = NULL,
	@IsCalYr BIT = NULL,
	@RptYrSel SMALLINT = NULL
 )
  
 AS
 
 --
 -- Use an intermediary Table variable to store result-sets separately for fiscal and calendar years
 -- because of the need to perform the control-breaks (i.e., GROUP BY) differently for each of them.
 --	
 DECLARE @tblReferralOverview TABLE
( 
  vId varchar(8),
  --refId int,
  --fisYr	smallint,
  --calYr smallint,
  rptYr varchar(4),
  refStat varchar(64),
  --refCd	varchar(64),
  --sortOrder smallint,
  refCnt	int
);
	
INSERT INTO @tblReferralOverview 	
SELECT	DISTINCT
		--
		v.VisnID AS 'VId',
		--
		--r.Referral_ID AS 'RefId',
		--
		--dc.FiscalYear,
		--
		CASE
			WHEN @IsFisYr = 1 THEN dc.FiscalYear
			WHEN @IsCalYr = 1 THEN datepart(yyyy,R.REFERRAL_DATE)
		END As 'RptYr',
		
		--CalendarYear = datepart(yyyy,R.REFERRAL_DATE),
		--	
		CASE
			WHEN (	EXISTS
					(SELECT     REFERRAL_ID
					FROM         DVEIR.ER_ENCOUNTER
					WHERE     (SendTo_DoD_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
					)
				THEN 'Sent to DVEIR'
			WHEN (	EXISTS
					(SELECT     REFERRAL_ID
					FROM         DVEIR.ER_ENCOUNTER
					WHERE     (Ready_to_Send_to_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
					)
				THEN 'Ready to Send to DVEIR'
			ELSE
				sr.NAME
			
			--WHEN sr.CODE IN ('DVEIR_NEW', 
			--				 'DVEIR_IN_PROCESS', 
			--				 'DVEIR_READY_FOR_REVIEW',
			--				 'DVEIR_Returned')
			--	THEN sr.NAME
			--WHEN (e.Ready_to_Send_to_DVEIR_FLAG = 1
			--      AND (ISNULL(e.SendTo_DoD_DVEIR_FLAG, 0) = 0))
			--	THEN 'Ready to Send to DVEIR'
			--WHEN (e.SendTo_DoD_DVEIR_FLAG = 1)
			--	THEN 'Sent to DVEIR'	
			
		END AS 'RefStat',
		--
		--sr.CODE AS 'RefCd',
	    --
		--sr.SORT_ORDER AS 'SrtOrd',
		--
		COUNT(DISTINCT R.REFERRAL_ID)
		--
FROM dbo.REFERRAL R (nolock) 
		INNER JOIN DVEIR.ER_ENCOUNTER e (NOLOCK)
			ON r.REFERRAL_ID = e.REFERRAL_ID
		INNER JOIN viewFacilitiesByVisn V
			ON R.STD_INSTITUTION_ID = V.institution_id
		INNER JOIN STD_REFERRALSTS sr 
			ON R.STD_REFERRALSTS_ID = sr.ID
		INNER JOIN dbo.DimTime dc (NOLOCK)
		    ON CAST(CONVERT(varchar(10),R.CREATED,101) as datetime) = dc.PK_Date
			
WHERE  -- Report YEAR selection
	   ( -- Fiscal Year
	     (@IsFisYr = 1
          AND (@IsCalYr IS NULL OR @IsCalYr =0)
          AND dc.FiscalYear = @RptYrSel)
         OR -- Calendar Year
            (@IsCalYr = 1
             AND (@IsFisYr IS NULL OR @IsFisYr = 0)
             AND dc.Calendar_Year = CAST(@RptYrSel AS VARCHAR)))
             
       -- Referral/Encounter STATUS business rule
       --AND 
   --    ((sr.CODE IN ('DVEIR_NEW', 
			--			 'DVEIR_IN_PROCESS', 
			--			 'DVEIR_READY_FOR_REVIEW'))
			--OR (e.Ready_to_Send_to_DVEIR_FLAG = 1
			--    OR e.SendTo_DoD_DVEIR_FLAG = 1))			

GROUP BY	v.VisnID , --Vid,
			r.Referral_ID, --RefId,
			dc.FiscalYear, --RptYr,
			datepart(yyyy,R.REFERRAL_DATE),
			sr.NAME
			--sr.CODE,
			--sr.SORT_ORDER
			
			--RefStat,
			--RefCd,
			--SrtOrd
			
--ORDER BY SORT_ORDER

--Enable line below only for DEBUGGING         
SELECT * FROM @tblReferralOverview

--DECLARE @tblReferralStatus TABLE
--(
--	statName	varchar(64)
--);

----
----
----
--INSERT INTO @tblReferralStatus
--SELECT DISTINCT name FROM STD_REFERRALSTS;

--SELECT * FROM @tblReferralOverview tro
--right outer join @tblReferralStatus trs 
--	on tro.refStat = trs.statName;
	
 -- If fiscal year
 --IF (@IsFisYr = 1)
 --   BEGIN
	--	SELECT	vId, 
	--	        refId,
	--	        fisYr AS rptYr,
	-- 			refStat,
	-- 			-- Override sort order of status field in Table var to conform to report requirement
	-- 			CASE 
	-- 			     WHEN refStat = 'New' THEN 1
	-- 			     WHEN refStat = 'In Process' THEN 2
	-- 			     WHEN refStat = 'Returned' THEN 3
	-- 			     WHEN refStat = 'Ready for Review' THEN 4
	-- 			     WHEN refStat = 'Ready to Send to DVEIR' THEN 5
	-- 			     WHEN refStat = 'Sent to DVEIR' THEN 6     
	-- 			END AS sortOrder,
	-- 			--   
	-- 			--sortOrder,
	-- 			--
	--			refCd 
	--	--
	--	FROM @tblReferralOverview tro
		
	--	--GROUP BY vId,
	--	--         fisYr ,
	--	--         refStat,
	--	--         refCd,
	--	--         sortOrder
		         
	--	ORDER BY --vId,
	--	         --fisYr ,
	--	         sortOrder
	--	         --refStat,
	--	         --refCd
		         	
	--END
 ---- else if calendar year
 --ELSE IF (@IsCalYr = 1)
 
 --       BEGIN
	--		SELECT	vId,
	--		        refId, 
	--				calYr as rptYr,
	-- 				refStat ,
	-- 				-- Override sort order of status field in Table var to conform to report requirement
	-- 				CASE 
	-- 					 WHEN refStat = 'New' THEN 1
	-- 					 WHEN refStat = 'In Process' THEN 2
	-- 					 WHEN refStat = 'Returned' THEN 3
	-- 					 WHEN refStat = 'Ready for Review' THEN 4
	-- 					 WHEN refStat = 'Ready to Send to DVEIR' THEN 5
	-- 					 WHEN refStat = 'Sent to DVEIR' THEN 6     
	-- 				END AS sortOrder,
	-- 				--
	--				refCd
	--				--COUNT(DISTINCT refId) as 'Referral Count'  
	--		--		
	--		FROM @tblReferralOverview
	--		--
	--		--GROUP BY vId,
	--		--		 calYr,
	--		--		 sortOrder,
	--		--		 refStat,
	--		--		 refCd				 
	--		--
	--		ORDER BY sortOrder
	--	END
	 



GO
/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralOverviewReport]    Script Date: 5/18/2015 3:36:40 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prcDVEIRReferralOverviewReport]') AND type in (N'P'))
DROP PROCEDURE [dbo].[prcDVEIRReferralOverviewReport]
GO

/****** Object:  StoredProcedure [dbo].[prcDVEIRReferralOverviewReport]    Script Date: 5/18/2015 3:36:40 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




CREATE PROC [dbo].[prcDVEIRReferralOverviewReport]
--
-- DESCRIPTION:
--
--		Populates the principal data set utilised by the corresponding SSRS report for the 
--      DVEIR VA Registry.
--
--		Business rules stipulate that the COMPLETED/PENDING DOD delivery STATUS of a Referral be 
--      determined by two flags in one or more ENCOUNTER(s) related to a Referral that signal whether 
--      the Referral in question is ready for dispatch to the DOD or has already been sent to the DOD.
--
-- AUTHOR(s):
--
--		jps
--
-- CREATION DATE:
--
--		14-Jun-2010
--
-- MODIFICATION HISTORY
-- WHO		WHEN			WHAT
-- ------------------------------------------------------------------------------------------------------
-- jh		02-Jul-2010		Alter Join between dimCalendar and Referral Tables because previous Join
--                          did not observe proper date semantics.
-- jps		08-Jul-2010     Alter Join statements involving ER_ENCOUNTER Table to prefix new DVEIR Schema 
--                          instead of previous dbo Schema.
-- jps		09-Jul-2010		Disable third (@RptYrSel) parameter until mechanism for receiving/processing
--							multi-valued report parameters is determined and finalised.
--                          NOTE: The corresponding SSRS Report continues to accept a multi-valued 
--                                parameter representing a YEAR; it is used as a dataset filter but it is 
--                                not passed to this stored procedure.
-- jps		22-Jul-2010     Alter string "Sent to DVEIR" to "Sent to DoD DVEIR" in SELECT statement 
--                          attribute representing Status of a Referral in order to conform to 
--                          corresponding change in STD_REFERRALSTS Table. 
--
-- Michael G 05-07-2015     Replaced dimCalendar with dimTime:- dimCalendar.FiscalYaer/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year

----------------------------------------------------------------------------------------------------------

 (
	-- Input Parameters
	@IsFisYr BIT = NULL,
	@IsCalYr BIT = NULL
	-- 3rd parameter temporarily disabled --> @RptYrSel AS dbo.ReportYear = NULL
 )
  
 AS
 
 --
 -- Use an intermediary Table variable to store result-sets separately for fiscal and calendar years
 -- because of the need to perform the control-breaks (i.e., GROUP BY) differently for each of them.
 --	
 DECLARE @tblReferralOverview TABLE
( 
  vId varchar(8),
  refId int,
  fisYr	smallint,
  calYr smallint,
  refStat varchar(64),
  refCd	varchar(64),
  sortOrder smallint 
);
	
INSERT INTO @tblReferralOverview 	
SELECT	DISTINCT
		--
		V.VisnID,
		--
		r.Referral_ID,
		--
		dc.FiscalYear,
		--
		CalendarYear = datepart(yyyy,R.REFERRAL_DATE),		--CAST(dc.Year AS smallint), --,
		-- Referral/Encounter STATUS business rule
		CASE
			WHEN (	EXISTS
					(SELECT     REFERRAL_ID
					FROM         DVEIR.ER_ENCOUNTER
					WHERE     (SendTo_DoD_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
					)
				THEN 'Sent to DoD DVEIR'
			WHEN (	EXISTS
					(SELECT     REFERRAL_ID
					FROM         DVEIR.ER_ENCOUNTER
					WHERE     (Ready_to_Send_to_DVEIR_FLAG = 1) AND (DVEIR.ER_ENCOUNTER.REFERRAL_ID = R.REFERRAL_ID))
					)
				THEN 'Ready to Send to DVEIR'
			ELSE
				sr.NAME
			
			--WHEN sr.CODE IN ('DVEIR_NEW', 
			--				 'DVEIR_IN_PROCESS', 
			--				 'DVEIR_READY_FOR_REVIEW',
			--				 'DVEIR_Returned')
			--	THEN sr.NAME
			--WHEN (e.Ready_to_Send_to_DVEIR_FLAG = 1
			--      AND (ISNULL(e.SendTo_DoD_DVEIR_FLAG, 0) = 0))
			--	THEN 'Ready to Send to DVEIR'
			--WHEN (e.SendTo_DoD_DVEIR_FLAG = 1)
			--	THEN 'Sent to DVEIR'	
			
		END AS 'Referral/Encounter Status',
		--
		sr.CODE AS 'Referral Code',
	    --
		sr.SORT_ORDER
		--
FROM dbo.REFERRAL R (nolock) 
		INNER JOIN DVEIR.ER_ENCOUNTER e (NOLOCK)
			ON r.REFERRAL_ID = e.REFERRAL_ID
		INNER JOIN viewFacilitiesByVisn V
			ON R.STD_INSTITUTION_ID = V.institution_id
		INNER JOIN STD_REFERRALSTS sr 
			ON R.STD_REFERRALSTS_ID = sr.ID
		INNER JOIN dbo.DimTime dc (NOLOCK)
		    ON CAST(CONVERT(varchar(10),R.CREATED,101) as datetime) = dc.PK_Date
--
-- WHERE clause is dependent on 3rd parameter (@RptYrSel) which is temporarily disabled.
--	
--WHERE  -- Report YEAR selection
--       @RptYrSel IS NOT NULL
--       AND 
--		   ( -- Fiscal Year
--		     (@IsFisYr = 1
--	          AND (@IsCalYr IS NULL OR @IsCalYr =0)
--	          AND CAST(dc.FiscalYear AS VARCHAR) IN @RptYrSel)
--	         OR -- Calendar Year
--	            (@IsCalYr = 1
--	             AND (@IsFisYr IS NULL OR @IsFisYr = 0)
--	             AND dc.Year = CAST(@RptYrSel AS VARCHAR)))
       
   --AND 
   --    ((sr.CODE IN ('DVEIR_NEW', 
			--			 'DVEIR_IN_PROCESS', 
			--			 'DVEIR_READY_FOR_REVIEW'))
			--OR (e.Ready_to_Send_to_DVEIR_FLAG = 1
			--    OR e.SendTo_DoD_DVEIR_FLAG = 1))			
						
--ORDER BY SORT_ORDER

--Enable line below only for DEBUGGING         
--SELECT * from @tblReferralOverview
	
 -- If fiscal year
 IF (@IsFisYr = 1)
    BEGIN
		SELECT	vId, 
		        refId,
		        fisYr AS rptYr,
	 			refStat,
	 			-- Override sort order of status field in Table var to conform to report requirement
	 			CASE 
	 			     WHEN refStat = 'New' THEN 1
	 			     WHEN refStat = 'In Process' THEN 2
	 			     WHEN refStat = 'Returned' THEN 3
	 			     WHEN refStat = 'Ready for Review' THEN 4
	 			     WHEN refStat = 'Ready to Send to DVEIR' THEN 5
	 			     WHEN refStat = 'Sent to DoD DVEIR' THEN 6     
	 			END AS sortOrder,
	 			--   
	 			--sortOrder,
	 			--
				refCd 
		--
		FROM @tblReferralOverview tro
		
		--GROUP BY vId,
		--         fisYr ,
		--         refStat,
		--         refCd,
		--         sortOrder
		         
		ORDER BY --vId,
		         --fisYr ,
		         sortOrder
		         --refStat,
		         --refCd
		         	
	END
 -- else if calendar year
 ELSE IF (@IsCalYr = 1)
 
        BEGIN
			SELECT	vId,
			        refId, 
					calYr AS rptYr,
	 				refStat ,
	 				-- Override sort order of status field in Table var to conform to report requirement
	 				CASE 
	 					 WHEN refStat = 'New' THEN 1
	 					 WHEN refStat = 'In Process' THEN 2
	 					 WHEN refStat = 'Returned' THEN 3
	 					 WHEN refStat = 'Ready for Review' THEN 4
	 					 WHEN refStat = 'Ready to Send to DVEIR' THEN 5
	 					 WHEN refStat = 'Sent to DoD DVEIR' THEN 6     
	 				END AS sortOrder,
	 				--
					refCd
					--COUNT(DISTINCT refId) as 'Referral Count'  
			--		
			FROM @tblReferralOverview
			--
			--GROUP BY vId,
			--		 calYr,
			--		 sortOrder,
			--		 refStat,
			--		 refCd				 
			--
			ORDER BY sortOrder
		END
	 







GO


/****** Object:  StoredProcedure [dbo].[OLD_prcDVEIRReferralOverviewRpt]    Script Date: 5/18/2015 3:22:32 PM ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OLD_prcDVEIRReferralOverviewRpt]') AND type in (N'P'))
DROP PROCEDURE [dbo].[OLD_prcDVEIRReferralOverviewRpt]
GO

/****** Object:  StoredProcedure [dbo].[OLD_prcDVEIRReferralOverviewRpt]    Script Date: 5/18/2015 3:22:32 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


 -- WHO		WHEN			WHAT
-- ------------------------------------------------------------------------------------------------------
-- Michael G 05-07-2015     Replaced dimCalendar with dimTime:- dimCalendar.FiscalYear/dimTime.FiscalYear, 
--							dimCalendar.Full_Day/dimTime.PK_Date, dimCalendar.Year/dimTime.Calendar_Year




CREATE PROC [dbo].[OLD_prcDVEIRReferralOverviewRpt]
 (
	-- Input Parameters
	@IsFisYr BIT = NULL,
	@IsCalYr BIT = NULL,
	@RptYrSel SMALLINT = NULL
 )
  
 AS
 
 --SET @RptYrSel = 2010; -- for demo purposes

    -- Local variables
    DECLARE	@RptFisYrFooter varchar(128) = '';
    
    -- Report Footer (if needed)
    IF ((SELECT MIN(DATEPART(yyyy, Referral_Date))
         FROM REFERRAL) >= @RptYrSel)     
		BEGIN
			SET @RptFisYrFooter = 'NOTE; Earliest data available is from ' 
		                           + CAST((SELECT MIN(REFERRAL_DATE) FROM Referral) AS VARCHAR);
		END;
	
	-- Result Set   
	SELECT
		--
		V.VisnID,
		--
		'Reporting Year' =
			CASE 
				WHEN @IsFisYr = 1 THEN 'Fiscal ' + CAST(dc.FiscalYear AS VARCHAR(4))
				WHEN @IsCalYr = 1 THEN 'Calendar ' + CAST(DATEPART(yyyy,R.REFERRAL_DATE) AS VARCHAR(4))
			END,
		--datepart(yy,R.REFERRAL_DATE) as 'FiYear',
		--
		dc.Calendar_Year AS 'Calendar Year',
		--
		--'Referral Status' = 
		--	case STD_REFERRALSTS_ID
		--		when 11 then 'New'
		--		when 12 then 'In Process'
		--		when 13 then 'Ready for Review'
		--		when 14 then 'Ready to Send to DVEIR'
		--		when 15 then 'Send to DVEIR'
		--		when 17 then 'No Action Required'
		--		when 21 then 'Returned'
		--		ELSE ''
		--	end,
		--
		sr.NAME AS 'Referral Status',
		--
		sr.CODE AS 'Referral Code',
		--
		COUNT(DISTINCT Referral_ID) AS 'Referral Count'
		--COUNT(DISTINCT 'Referral Status') AS 'Referral Count',
		--COUNT(DISTINCT sr.NAME) AS 'Referral Count'
		--COUNT('Referral Status') OVER(PARTITION BY Referral_ID) as 'Referral Count'
		
	FROM dbo.REFERRAL R (NOLOCK) 
	    INNER JOIN viewFacilitiesByVisn V
			ON R.STD_INSTITUTION_ID = V.institution_id
		INNER JOIN STD_REFERRALSTS sr 
			ON sr.ID = R.STD_REFERRALSTS_ID
		INNER JOIN dbo.DimTime dc
		    --on dc.Full_Day = DATEPART(YYYY, R.REFERRAL_DATE)
		    ON dc.Calendar_Year = DATEPART(YYYY, R.REFERRAL_DATE)
		    
	WHERE (@IsFisYr = 1
	        AND (@IsCalYr IS NULL OR @IsCalYr =0)
	        --AND datepart(yyyy,R.REFERRAL_DATE) = @RptYrSel)
	        AND dc.FiscalYear = @RptYrSel)
	       OR (@IsCalYr = 1
	           AND (@IsFisYr IS NULL OR @IsFisYr = 0)
	           AND dc.Calendar_Year = CAST(@RptYrSel AS VARCHAR))
	           --AND (DATEPART(YYYY, R.REFERRAL_DATE) = dc.FiscalYear
	           --     OR DATEPART(YYYY, R.REFERRAL_DATE) = dc.FiscalYear - 1))
	      

	      -- and V.VisnID in (@VisnID)
	 
	GROUP BY 
	    V.VisnID,
	    dc.FiscalYear,
		DATEPART(yyyy,R.REFERRAL_DATE),
		dc.Calendar_Year,
		sr.Name,
		sr.CODE
		--case STD_REFERRALSTS_ID
		--	when 11 then 'New'
		--	when 12 then 'In Process'
		--	when 13 then 'Ready for Review'
		--	when 14 then 'Ready to Send to DVEIR'
		--	when 15 then 'Send to DVEIR'
		--	when 17 then 'No Action Required'
		--	when 21 then 'Returned'
		--	ELSE ''
		--end
	ORDER BY  1
	
	
	-- exec dbo.rpt_DVEIR_ReferalOverviewReport 'v01', 2010
	
		-- exec dbo.rpt_DVEIR_ReferalOverviewReport  2010





GO

















