

--Alter dbo.DimTime table add new columns

ALTER TABLE dbo.DimTime ADD [FiscalYear] [INT] NULL,
	[Calendar_Year] [INT] NULL,
	[Month_Short_Name] [CHAR](3) NULL,
	[Month_ID] [INT] NULL,
	[FiscalQuarterID] [INT] NULL,
	[FYQuarter] [CHAR](6) NULL,
	[EPRPQuarter] [CHAR](6) NULL;
GO

--Update dbo.DimTime table and populate new data columns
UPDATE [dbo].[DimTime]
   SET 	
    FiscalYear =  DATEPART(YEAR, DATEADD(MONTH, 3, pk_date)),
	Calendar_Year = DATEPART(YEAR, pk_date),
	Month_Short_Name = SUBSTRING(DATENAME(m, pk_date), 1, 3),
	Month_ID =  CONVERT(INT, CONVERT(CHAR(4), DATEPART(YEAR, pk_date)) + RIGHT('0' + CONVERT(VARCHAR(2), DATEPART(m, pk_date)), 2)),
	FiscalQuarterID = CONVERT(INT, CONVERT(CHAR(4), DATEPART(YEAR, DATEADD(MONTH, 3, pk_date))) + CONVERT(CHAR(1), Fiscal_Quarter_Of_Year)), 
	FYQuarter =  'FY' + RIGHT(CONVERT(CHAR(4), DATEPART(YEAR, DATEADD(MONTH, 3, pk_date))), 2) + 'Q' + CONVERT(CHAR(1), Fiscal_Quarter_Of_Year),
	EPRPQuarter = 'FY' + RIGHT(CONVERT(CHAR(4), DATEPART(YEAR, DATEADD(MONTH, 4, pk_date))), 2) + 'Q' + CONVERT(CHAR(1), DATEPART(QUARTER, DATEADD(MONTH, 4, pk_date))) 
 
GO

