-------------------------------------
--
-- Remove PolyTrauma Entry Type code BOTH 
-- David Lorek - 3/26/2015
--
-------------------------------------

--use registry
if exists (select 1 from tbi.tbi_polytrauma where entry_type_id = 3)
BEGIN
  print 'Error! Unable to remove BOTH Entry Type code because it is currently in use.'
  print 'To upate all BOTH codes to PRC see the ResetCode3To1.sql script.'
  print 'To upate all BOTH codes to PTRP see the ResetCode3To2.sql script.'
  print 'Re-run this script once all records with the BOTH Entry Type have been removed.'
  RETURN
END


if exists (select 1 from TBI.STD_POLYTRAUMA_ENTRY_TYPE NOLOCK where id = 3)
BEGIN
  print 'The BOTH Entry Type code exists and will be removed.'

  BEGIN TRY
    delete from TBI.STD_POLYTRAUMA_ENTRY_TYPE where id = 3
	print 'The BOTH Entry Type was successfully removed.'
  END TRY
  BEGIN CATCH
    print 'Error! The BOTH Entry Type code was not successfully removed.'
	print ERROR_MESSAGE()
  END CATCH

END
ELSE
BEGIN
    print 'The BOTH Entry Type code cannot be found in the database. No removal attempt will be made.'
END




