-------------------------------------
--
-- Add PolyTrauma Entry Type code BOTH for records
-- where both PRC and PTRP tracking are required
-- David Lorek - 3/26/2015
--
-------------------------------------


--use registry

if exists (select 1 from TBI.STD_POLYTRAUMA_ENTRY_TYPE NOLOCK where id = 3)
BEGIN
  print 'The BOTH Entry Type code already exists'
END
ELSE
BEGIN
  BEGIN TRY
    DECLARE @user varchar(255)
	SELECT @user = stuff(suser_sname(), 1, charindex('\', suser_sname()), '')

    SET IDENTITY_INSERT TBI.STD_POLYTRAUMA_ENTRY_TYPE ON
    INSERT INTO TBI.STD_POLYTRAUMA_ENTRY_TYPE (ID, CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, INACTIVE_FLAG, INACTIVE_DATE, CREATEDBY, CREATED, UPDATEDBY, UPDATED)
      VALUES (3, 'BOTH', 'BOTH', 'Both PRC and PTRP', 3, 0, NULL, @user, GETDATE(), @user, GETDATE())
    SET IDENTITY_INSERT TBI.STD_POLYTRAUMA_ENTRY_TYPE OFF
    print 'The BOTH Entry Type code was successfully added to the database'
  END TRY
  BEGIN CATCH
    SET IDENTITY_INSERT TBI.STD_POLYTRAUMA_ENTRY_TYPE OFF
    print 'Error! The BOTH Entry Type code was not successfully added to the database'
	print ERROR_MESSAGE()
  END CATCH
END






