
	/****** Object:  Table [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED]    Script Date: 01/21/2015 12:08:18 ******/
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED]') AND type in (N'U'))
	DROP TABLE [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED]
	GO
	
	
-------------------------------------
--
-- Rollback NumberOfDosesTaken 
-- columns
--
-------------------------------------
			
	IF EXISTS(
		SELECT dc.Name
		FROM sys.tables t
		INNER JOIN sys.default_constraints dc ON t.object_id = dc.parent_object_id
		INNER JOIN sys.columns c ON dc.parent_object_id = c.object_id AND c.column_id = dc.parent_column_id
		where t.Name = 'MSSR_MEDICATION'
		and c.Name = 'ShowNumDosesTaken')	
		
			ALTER TABLE [MSSR].MSSR_MEDICATION
			DROP CONSTRAINT ShowNumDosesTakenDefault
	GO	
			
	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_MEDICATION'
		AND COLUMN_NAME = 'ShowNumDosesTaken')
				
			ALTER TABLE [MSSR].[MSSR_MEDICATION]
			DROP COLUMN ShowNumDosesTaken 
	GO
		
	IF EXISTS(
	SELECT dc.Name
	FROM sys.tables t
	INNER JOIN sys.default_constraints dc ON t.object_id = dc.parent_object_id
	INNER JOIN sys.columns c ON dc.parent_object_id = c.object_id AND c.column_id = dc.parent_column_id
	where t.Name = 'MSSR_MEDICATION_REASON_STOPPED'
	and c.Name = 'Extention_Parent_ID')	
	
		ALTER TABLE [MSSR].MSSR_MEDICATION_REASON_STOPPED
		DROP CONSTRAINT ExtentionParentIdDefault
	GO			
	
	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_MEDICATION_REASON_STOPPED'
		AND COLUMN_NAME = 'Extention_Parent_ID')	
				
			ALTER TABLE [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			DROP COLUMN [Extention_Parent_ID] 
	GO	
			
	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'CurrentNumberOfDosesTaken')
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			DROP COLUMN [CurrentNumberOfDosesTaken] 
	GO	
		
	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'PastNumberOfDosesTaken')
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			DROP COLUMN [PastNumberOfDosesTaken] 
	GO	

	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'ADVERSE_EVENTS')	
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			DROP COLUMN [ADVERSE_EVENTS] 
	GO

	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'ADVERSE_EVENTS_DESCRIPTION')	
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			DROP COLUMN [ADVERSE_EVENTS_DESCRIPTION] 
	GO	
		
	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'ADVERSE_EVENT')
		BEGIN 	
			ALTER TABLE [MSSR].MSSR_PATIENT_MEDICATION
			DROP CONSTRAINT FK_MSSR_PATIENT_MEDICATION_MSSR_MEDICATION_REASON_STOPPED_ADVERSE_EVENT		
			
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			DROP COLUMN [ADVERSE_EVENT]
		END
	GO	
		
	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'OTHER_DMT_NAME') 		
		
		ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
		DROP COLUMN [OTHER_DMT_NAME]
	GO	
		
	IF EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'SigEventOther') 		
		
		ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
		DROP COLUMN [SigEventOther]
	GO	

-------------------------------------
--
-- Update medicine display names
--
-------------------------------------	

	UPDATE [MSSR].[MSSR_MEDICATION]
	SET MEDICATION = 'Dimethyl Fumerate'
	WHERE HEALTH_FACTOR = 'DIMETHYL FUMERATE'

	UPDATE [MSSR].[MSSR_MEDICATION]
	SET MEDICATION = 'Methotrexate (Trexall)'
	WHERE HEALTH_FACTOR = 'METHOTREXATE'	
	
-------------------------------------
--
-- Contract Reason Stopped column
--
-------------------------------------

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_MEDICATION_REASON_STOPPED'
		AND COLUMN_NAME = 'REASON_STOPPED'
		AND CHARACTER_MAXIMUM_LENGTH = 50)	
		BEGIN
			
			Delete [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			Where REASON_STOPPED like '(e.g.%' or
			REASON_STOPPED = 'Other significant adverse event'
			
			ALTER TABLE [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			ALTER COLUMN REASON_STOPPED nvarchar(50)	
			
		END
	GO

-------------------------------------
--
-- Create Other DMT's medicine
--
-------------------------------------
		
	delete [MSSR].[MSSR_MEDICATION]
	where MEDICATION = 'Other DMTs'					
	GO
	
-------------------------------------
--
-- delete additional reasons stopped
-- and extensions
-------------------------------------

	Delete [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
	WHERE REASON_STOPPED in 
	( '(e.g. leukopenia, allergic reaction, nausea/vomiting)'
	 ,'(e.g. cystitis, leukopenia, nausea/vomiting)'
	 ,'(e.g. nausea, flushing, infection)'
	 ,'(e.g. cardiac toxicity, infection, macular edema)'
	 ,'(e.g. injection site reaction, chest pain, rash)'
	 ,'(e.g. Injection site reaction, flu-like symptoms, depression)'
	 ,'(e.g. stomatitis, leukopenia, nausea)'
	 ,'(e.g. diminished cardiac ejection fraction, infection, nausea)'
	 ,'(e.g. leukopenia, peripheral edema, hematuria)'
	 ,'(e.g. allergic reaction, infection, abnormal liver enzymes)'
	 ,'(e.g. infusion reaction, infection, leukopenia)'
	 ,'Other significant adverse event')
	 
	GO
