UPDATE [TBI].[TBI_POLYTRAUMA] SET UPDATEDBY = '' WHERE STD_TBIDISCHARGETO_ID IN (1,2,5);
UPDATE [TBI].[TBI_POLYTRAUMA] SET UPDATEDBY = '' WHERE STD_TBIDSCHRGSTS_ID IN (1,3,4,5);
UPDATE [TBI].[TBI_POLYTRAUMA] SET UPDATEDBY = '' WHERE STD_TBIFACILITYSRC_ID IN (1,2);
GO

UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIDISCHARGETO_ID = (SELECT ID FROM [TBI].[STD_TBIDISCHARGETO] WHERE CODE = 'Private'),  UPDATEDBY = (UPDATEDBY + ' S17-1'), UPDATED = GETDATE() WHERE STD_TBIDISCHARGETO_ID = 1;
UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIDISCHARGETO_ID = (SELECT ID FROM [TBI].[STD_TBIDISCHARGETO] WHERE CODE = 'MTF'), UPDATEDBY = (UPDATEDBY + ' S17-1'), UPDATED = GETDATE() WHERE STD_TBIDISCHARGETO_ID = 2;
UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIDISCHARGETO_ID = (SELECT ID FROM [TBI].[STD_TBIDISCHARGETO] WHERE CODE = 'PTRP'), UPDATEDBY = (UPDATEDBY + ' S17-1'), UPDATED = GETDATE() WHERE STD_TBIDISCHARGETO_ID = 5;
GO

UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIDSCHRGSTS_ID = (SELECT ID FROM [TBI].[STD_TBIDSCHRGSTS] WHERE CODE = 'ACTIVE_DUTY'), UPDATEDBY = (UPDATEDBY + ' S17-2'), UPDATED = GETDATE() WHERE STD_TBIDSCHRGSTS_ID = 1;
UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIDSCHRGSTS_ID = (SELECT ID FROM [TBI].[STD_TBIDSCHRGSTS] WHERE CODE = 'MEB'), UPDATEDBY = (UPDATEDBY + ' S17-2'), UPDATED = GETDATE() WHERE STD_TBIDSCHRGSTS_ID = 3;
UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIDSCHRGSTS_ID = (SELECT ID FROM [TBI].[STD_TBIDSCHRGSTS] WHERE CODE = 'VETERAN'), UPDATEDBY = (UPDATEDBY + ' S17-2'), UPDATED = GETDATE() WHERE STD_TBIDSCHRGSTS_ID = 4;
UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIDSCHRGSTS_ID = null, UPDATEDBY = (UPDATEDBY + ' S17-2'), UPDATED = GETDATE() WHERE STD_TBIDSCHRGSTS_ID = 5;
GO

UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIFACILITYSRC_ID = (SELECT ID FROM [TBI].[STD_TBIFACILITYSRC] WHERE CODE = 'WRNNMC'), UPDATEDBY = (UPDATEDBY + ' S17-3.1'), UPDATED = GETDATE() WHERE STD_TBIFACILITYSRC_ID = 1;
UPDATE [TBI].[TBI_POLYTRAUMA] SET STD_TBIFACILITYSRC_ID = (SELECT ID FROM [TBI].[STD_TBIFACILITYSRC] WHERE CODE = 'WRNNMC'), UPDATEDBY = (UPDATEDBY + ' S17-3.2'), UPDATED = GETDATE() WHERE STD_TBIFACILITYSRC_ID = 2;
GO

IF NOT EXISTS(select * from sys.schemas s inner join sys.tables t on t.schema_id=s.schema_id inner join sys.columns c on c.object_id=t.object_id where s.name='tbi' and t.name='tbi_polytrauma' and c.name='PRC_FOLLOWUP_DATE')
BEGIN
	ALTER TABLE [TBI].[TBI_Polytrauma] ADD [PRC_FOLLOWUP_DATE] DATETIME NULL;
END
GO

IF NOT EXISTS(select * from sys.schemas s inner join sys.tables t on t.schema_id=s.schema_id inner join sys.columns c on c.object_id=t.object_id where s.name='tbi' and t.name='tbi_polytrauma' and c.name='PTRP_FOLLOWUP_DATE')
BEGIN
	ALTER TABLE [TBI].[TBI_Polytrauma] ADD [PTRP_FOLLOWUP_DATE] DATETIME NULL;
END
GO

IF NOT EXISTS(select * from sys.schemas s inner join sys.tables t on t.schema_id=s.schema_id inner join sys.columns c on c.object_id=t.object_id where s.name='tbi' and t.name='tbi_polytrauma' and c.name='INACTIVE_FLAG')
BEGIN
	ALTER TABLE [TBI].[TBI_Polytrauma] ADD [INACTIVE_FLAG] [bit] NOT NULL CONSTRAINT [DF_TBI_TBI_Polytrauma_INACTIVE_FLAG] DEFAULT 0;
END
GO

IF NOT EXISTS(select * from sys.schemas s inner join sys.tables t on t.schema_id=s.schema_id inner join sys.columns c on c.object_id=t.object_id where s.name='tbi' and t.name='tbi_polytrauma' and c.name='INACTIVE_DATE')
BEGIN
	ALTER TABLE [TBI].[TBI_Polytrauma] ADD [INACTIVE_DATE] [datetime] NULL;
END
GO

/****** Object:  StoredProcedure [TBI].[usp_Get_VISNs]    Script Date: 01/15/2015 09:39:01 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[usp_Get_VISNs]') AND type in (N'P', N'PC'))
DROP PROCEDURE [TBI].[usp_Get_VISNs]
GO

/****** Object:  StoredProcedure [TBI].[usp_Get_VISNs]    Script Date: 01/15/2015 09:39:01 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




CREATE PROCEDURE [TBI].[usp_Get_VISNs]
AS
	SELECT 
		ID AS visnId
		,NAME AS visnText
	FROM 
		dbo.STD_INSTITUTION
	WHERE
		LEFT(NAME, 4) = 'VISN'
	ORDER BY CONVERT(int, REPLACE(NAME, 'VISN ', ''))




GO


/****** Object:  StoredProcedure [dbo].[usp_GetTBIWarningErrorDetails]    Script Date: 01/15/2015 09:39:28 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_GetTBIWarningErrorDetails]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_GetTBIWarningErrorDetails]
GO

/****** Object:  StoredProcedure [dbo].[usp_GetTBIWarningErrorDetails]    Script Date: 01/15/2015 09:39:28 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





CREATE PROCEDURE [dbo].[usp_GetTBIWarningErrorDetails] (@userid varchar(1000))
AS
	SELECT TOP 1 ISNULL(RETURNED_DATA, '') AS 'ERROR_XML'
	FROM dbo.MDWS_LOG
	WHERE
		[service_name] LIKE ('%cprsLaunch%') and
		--sent > getdate() and 
		updatedby = @userid and
		std_registry_id = 2 and
		error_level = 1 
		/*error_level=1 means returned data was written but there was an error*/
	ORDER BY CREATED DESC
	 
	




GO


/****** Object:  StoredProcedure [TBI].[usp_Get_Facs]    Script Date: 01/15/2015 09:39:45 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[usp_Get_Facs]') AND type in (N'P', N'PC'))
DROP PROCEDURE [TBI].[usp_Get_Facs]
GO

/****** Object:  StoredProcedure [TBI].[usp_Get_Facs]    Script Date: 01/15/2015 09:39:45 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


--exec [TBI].[usp_Get_Facs] 
CREATE PROCEDURE [TBI].[usp_Get_Facs] 

AS
	SELECT 
		si.ID AS facId
		,'(' + dbo.GetVISNNumberByVisnID(si.VISN_ID) + ') (' + si.STATIONNUMBER + ') ' + si.NAME AS facText
		,si.VISN_ID visn_fk
		,si.STATIONNUMBER AS stationnumber
	FROM 
		dbo.STD_INSTITUTION si 
	WHERE
		LEN(si.STATIONNUMBER) = 3 AND 
		si.VISN_ID IS NOT NULL
	ORDER BY si.VISN_ID




GO


/****** Object:  StoredProcedure [TBI].[usp_GetCalendarFiscalYears]    Script Date: 01/15/2015 09:39:59 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[usp_GetCalendarFiscalYears]') AND type in (N'P', N'PC'))
DROP PROCEDURE [TBI].[usp_GetCalendarFiscalYears]
GO

/****** Object:  StoredProcedure [TBI].[usp_GetCalendarFiscalYears]    Script Date: 01/15/2015 09:39:59 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE proc [TBI].[usp_GetCalendarFiscalYears]
as
Begin try

	select distinct Fiscal_Year_Name
	from DataMart_Registries.dbo.dimtime
	where ([pk_date] < convert(nvarchar(20),dateadd(day,5,getdate()),101))
	order by Fiscal_Year_Name desc

End try
Begin catch
 Return
End Catch


GO


/****** Object:  StoredProcedure [TBI].[usp_GetPatientSSNByDFNid]    Script Date: 01/15/2015 09:40:21 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[usp_GetPatientSSNByDFNid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [TBI].[usp_GetPatientSSNByDFNid]
GO

/****** Object:  StoredProcedure [TBI].[usp_GetPatientSSNByDFNid]    Script Date: 01/15/2015 09:40:21 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [TBI].[usp_GetPatientSSNByDFNid]
	(
	@dfnId int
	)
AS
	SET NOCOUNT ON 
	SELECT     SSN
	FROM       SURVEY_PATIENT 
	WHERE     (DFN = @dfnId)
	RETURN @dfnId

GO
