
-------------------------------------------
--
-- Correct Lab Report Date
--
-------------------------------------------

Update EFR.SPECIMEN_ANALYSIS
set LAB_REPORT_DATE = '2014-06-19'
where  (SPECIMEN_ANALYSIS_ID = 774 and LAB_REPORT_DATE < '2000-1-1')

-------------------------------------------
--
-- Add EFR setting
--
-------------------------------------------

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EFRShowDefaultLandingPage'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EFRShowDefaultLandingPage'  
		   ,'true'            
		   ,'true or false' 
		   ,'if true, shows default page with statistics' 
		   ,GETDATE()                        
		   ,'awhiteleather')  		   

GO

/****** Object:  UserDefinedFunction [dbo].[GetNumNewEfrPatients]    Script Date: 02/10/2015 16:51:52 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNumNewEfrPatients]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GetNumNewEfrPatients]
GO


/****** Object:  UserDefinedFunction [dbo].[GetNumNewEfrPatients]    Script Date: 02/10/2015 16:51:52 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[GetNumNewEfrPatients](@Days int) 
RETURNS int
AS
BEGIN
	declare @i int
	select @i =
	(
	SELECT 
	Count (b.Patient_id) AS PatientCount  
	FROM 
	( 
		SELECT Distinct p.patient_id, 
		COUNT(r.referral_id) AS NumReferrals 
		FROM referral r 
		JOIN patient p ON r.PATIENT_ID = p.patient_id 
		join std_registry sr on r.std_registry_id = sr.id 
		where sr.CODE = 'efr' 
		and p.PATIENT_ID in(select p.patient_id 
							from REFERRAL r join std_registry sr on r.std_registry_id = sr.id 
							join patient p on p.PATIENT_ID = r.PATIENT_ID 
							where sr.CODE = 'efr' and r.CREATED > (select GETDATE() - @Days) 
							) 
		GROUP BY p.patient_id 
		having COUNT(referral_id) = 1 
	) b
	)
	
	return @i
END
GO


/****** Object:  StoredProcedure [dbo].[GetEfrCountStatistics]    Script Date: 02/10/2015 14:42:55 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEfrCountStatistics]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetEfrCountStatistics]
GO

/****** Object:  StoredProcedure [dbo].[GetEfrCountStatistics]    Script Date: 02/10/2015 14:42:55 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[GetEfrCountStatistics]
AS
BEGIN

	IF OBJECT_ID('tempdb..#results') IS NOT NULL DROP TABLE #Results
	create table #results
	(
	    label nvarchar(200)
		,value nvarchar (50)
	)

	-----------------------------------------------------------------
	--
	--  Referral records - shows the 'SSIS_HealthFactor_Packages_Daily
	--  is running
	--
	-----------------------------------------------------------------
	insert into #results values
	(
		'Number of referrals from the Extract Process in the past 24 hours: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY = 'ETL Process'
			and r.CREATED > (select GETDATE() - 1)
		 )
	)
	insert into #results values
	(
		'Number of referrals from the Extract Process in the past 7 days: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY = 'ETL Process'
			and r.CREATED > (select GETDATE() - 7)
		 )
	)
	insert into #results values
	(
		'Number of referrals from the Extract Process in the past 30 days: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY = 'ETL Process'
			and r.CREATED > (select GETDATE() - 30)
		 )
	)
	insert into #results values
	(
		'Number of manually created referrals in the past 7 days: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY != 'ETL Process'
			and r.CREATED > (select GETDATE() - 7)
		 )
	)
	insert into #results values
	(
		'Number of manually created referrals in the past 30 days: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY != 'ETL Process'
			and r.CREATED > (select GETDATE() - 30)
		 )
	)	
	
	insert into #results values
	(
		'* Number of new patients in the past 7 days: '
		,(select dbo.GetNumNewEfrPatients(7))
	)	
	
	insert into #results values
	(
		'* Number of new patients in the past 30 days: '
		,(select dbo.GetNumNewEfrPatients(30))
	)
	
	-----------------------------------------------------------------
	--
	--  Specimen Analysis records (shows the MDWS_Lab ETL is running
	--
	-----------------------------------------------------------------

	insert into #results values
	(
		'Number of Lab Result records from the Extract Process in the past 24 hours: '
		,(
			select COUNT(sa.specimen_analysis_id)
			from efr.SPECIMEN_ANALYSIS sa		
			where sa.CREATEDBY = 'ETL Process'
			and sa.CREATED > (select GETDATE() -1)
		 )
	)
	insert into #results values
	(
		'Number of Lab Result records from the Extract Process in the past week: '
		,(
			select COUNT(sa.specimen_analysis_id)
			from efr.SPECIMEN_ANALYSIS sa		
			where sa.CREATEDBY = 'ETL Process'
			and sa.CREATED > (select GETDATE() -7)
		 )
	)
	insert into #results values
	(
		'Number of Lab Result records from the Extract Process in the past 30 days: '
		,(
			select COUNT(sa.specimen_analysis_id)
			from efr.SPECIMEN_ANALYSIS sa		
			where sa.CREATEDBY = 'ETL Process'
			and sa.CREATED > (select GETDATE() - 30)
		 )
	)

	-----------------------------------------------------------------
	--
	--  DoD Fragment Files
	--
	-----------------------------------------------------------------

	insert into #results values
	(
		'Number of DoD Fragment Files received in the past 30 days: '
		,(
			select COUNT(efr.DOD_FRAGMENT_RAW_DATA.DOD_FRAGMENT_RAW_DATA_id)
			from efr.DOD_FRAGMENT_RAW_DATA		
			where DOD_FRAGMENT_RAW_DATA.CREATED > (select GETDATE() - 30)
		 )
	)	
	
	insert into #results values
	(
		'Number of DoD Fragment Files received in the past six months: '
		,(
			select COUNT(efr.DOD_FRAGMENT_RAW_DATA.DOD_FRAGMENT_RAW_DATA_id)
			from efr.DOD_FRAGMENT_RAW_DATA		
			where DOD_FRAGMENT_RAW_DATA.CREATED > (select GETDATE() - 180)
		 )
	)		
	
	insert into #results values
	(
		'* New patients are patients that have a total of one referral that was received during the specified interval '
		,''		 
	)

	-- return the result set
	select * from #results
	
END

GO



/****** Object:  StoredProcedure [dbo].[GetEfrCountStatistics]    Script Date: 02/10/2015 14:42:55 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEfrDateStatistics]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetEfrDateStatistics]
GO

/****** Object:  StoredProcedure [dbo].[GetEfrDateStatistics]    Script Date: 02/10/2015 14:42:55 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[GetEfrDateStatistics]
AS
BEGIN

	IF OBJECT_ID('tempdb..#results') IS NOT NULL DROP TABLE #Results
	create table #results
	(
	    label nvarchar(200)
		,value nvarchar (50)
	)
	
	-----------------------------------------------------------------
	--
	--  Referral records - shows the 'SSIS_HealthFactor_Packages_Daily
	--  is running
	--
	-----------------------------------------------------------------
	insert into #results values
	(
		'Number of new referrals from the Extract Process in the past 24 hours: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY = 'ETL Process'
			and r.CREATED > (select GETDATE() - 1)
		 )
	)
	insert into #results values
	(
		'Number of new referrals from the Extract Process in the past week: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY = 'ETL Process'
			--and r.CREATED > (select cast(GETDATE()-1 as DATE))
			and r.CREATED > (select GETDATE() - 7)
		 )
	)
	insert into #results values
	(
		'Number of new manually created referrals in the past 24 hours: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY != 'ETL Process'
			and r.CREATED > (select GETDATE() - 1)
		 )
	)
	insert into #results values
	(
		'Number of new manually created referrals in the past week: '
		,(
			select COUNT(r.REFERRAL_ID)
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			where sr.CODE = 'efr'
			and r.CREATEDBY != 'ETL Process'
			and r.CREATED > (select GETDATE() - 7)
		 )
	)	
	
	insert into #results values
	(
		'Number of new patients in the past day: '
		,(select dbo.GetNumNewEfrPatients(1))
	)	
	
	insert into #results values
	(
		'Number of new patients in the past week: '
		,(select dbo.GetNumNewEfrPatients(7))
	)

	-- # new patients for the new referrals
	/*
		SELECT distinct p.patient_id, COUNT(r.referral_id) AS NumReferrals FROM referral r
		JOIN patient p ON r.PATIENT_ID = p.patient_id
		join std_registry sr on r.std_registry_id = sr.id
		where sr.CODE = 'efr' 
		and p.PATIENT_ID in 
			(
			select distinct p.patient_id
			from REFERRAL r
			join std_registry sr on r.std_registry_id = sr.id
			join patient p on p.PATIENT_ID = r.PATIENT_ID
			where sr.CODE = 'efr' 
			and r.CREATED > (select GETDATE() - 7)
			)
		GROUP BY p.patient_id
		having COUNT(referral_id) = 1
	*/
	-----------------------------------------------------------------
	--
	--  Specimen Analysis records (shows the MDWS_Lab ETL is running
	--
	-----------------------------------------------------------------

	insert into #results values
	(
		'Number of new Lab Result records from the Extract Process in the past 24 hours: '
		,(
			select COUNT(sa.specimen_analysis_id)
			from efr.SPECIMEN_ANALYSIS sa		
			where sa.CREATEDBY = 'ETL Process'
			and sa.CREATED > (select GETDATE() -1)
		 )
	)
	insert into #results values
	(
		'Number of new Lab Result records from the Extract Process in the past week: '
		,(
			select COUNT(sa.specimen_analysis_id)
			from efr.SPECIMEN_ANALYSIS sa		
			where sa.CREATEDBY = 'ETL Process'
			and sa.CREATED > (select GETDATE() -7)
		 )
	)
	insert into #results values
	(
		'Number of new manually created Lab Result records in the past 24 hours: '
		,(
			select COUNT(sa.specimen_analysis_id)
			from efr.SPECIMEN_ANALYSIS sa		
			where sa.CREATEDBY <> 'ETL Process'
			and sa.CREATED > (select GETDATE() -1)
		 )
	)

	insert into #results values
	(
		'Number of new manually created Lab Result records in the past week: '
		,(
			select COUNT(sa.specimen_analysis_id)
			from efr.SPECIMEN_ANALYSIS sa		
			where sa.CREATEDBY <> 'ETL Process'
			and sa.CREATED > (select GETDATE() -7)
		 )
	)

	-----------------------------------------------------------------
	--
	--  DoD Fragment Files
	--
	-----------------------------------------------------------------

	insert into #results values
	(
		'Number of new DoD Fragment Files received in the past week: '
		,(
			select COUNT(efr.DOD_FRAGMENT_RAW_DATA.DOD_FRAGMENT_RAW_DATA_id)
			from efr.DOD_FRAGMENT_RAW_DATA		
			where DOD_FRAGMENT_RAW_DATA.CREATED > (select GETDATE() -1)
		 )
	)

	-- return the result set
	select * from #results
	
END

GO