
-------------------------------------------
--
-- Update survey choice
--
-------------------------------------------

Update STD_QUESTION_CHOICE 
set CHOICE_TEXT = 'Medications Only'
where STD_QUESTION_CHOICE_ID = 
(
	select sqc.STD_QUESTION_CHOICE_ID 
	from STD_SURVEY_TYPE st
	join STD_QUESTION sq on sq.STD_SURVEY_TYPE_ID = st.id
	join STD_QUESTION_CHOICE sqc on sqc.std_question_id = sq.id
	where st.code = 'msat'
	and sq.QUESTION_NUMBER = 'at'
	and sqc.CHOICE_TEXT = 'Ad Hoc'
)
GO

Update STD_QUESTION
set QUESTION_TEXT = 'Positive Date:'
where QUESTION_NUMBER = 'SJCP'
GO

Update STD_QUESTION
set QUESTION_TEXT = 'Date of most recent cardiac MUGA or Echocardiogram:'
where QUESTION_NUMBER = 'CardioToxYes'
GO

Update STD_QUESTION
set QUESTION_TEXT = 'Negative Date:'
where QUESTION_NUMBER = 'SJCN'
GO

-------------------------------------------
--
-- Move MDWS vs VIA to a DB Setting
--
-------------------------------------------

declare @mssrId int
set @mssrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'MSSR'
)

delete from CRS_SETTINGS
where [NAME] = 'MSSRServiceToUse'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MSSRServiceToUse'  
		   ,'VIA'            
		   ,'MDWS or VIA are valid choices, MDWS is default' 
		   ,'Determines which source to connect to' 
		   ,GETDATE()                        
		   ,'awhiteleather')  		   
		   
delete from CRS_SETTINGS
where [NAME] = 'MSSRLogSelectionsBeforeSave'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MSSRLogSelectionsBeforeSave'  
		   ,'yes'            
		   ,'yes or no ' 
		   ,'yes - write out note string and hf string before saving' 
		   ,GETDATE()                        
		   ,'awhiteleather')  
		   
delete from CRS_SETTINGS
where [NAME] = 'MSSRLogTime'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MSSRLogTime'  
		   ,'true'            
		   ,'true to log out times from the app, false not to' 
		   ,'Aid to assist if some functions begin to take longer than expected' 
		   ,GETDATE()                        
		   ,'awhiteleather') 
		   		   
delete from CRS_SETTINGS
where [NAME] = 'MSSRMonthYearFormat'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@mssrId                              
		   ,'MSSRMonthYearFormat'  
		   ,'alpha'            
		   ,'numeric or alpha' 
		   ,'Determines if months are displayed as January or as 01' 
		   ,GETDATE()                        
		   ,'awhiteleather')
		                    
GO

-------------------------------------------
--
-- Set up question for CardioToxDateUnknown
--
-------------------------------------------

declare @msat_surveyId int
declare @questionId int

set @msat_surveyId =
(
	select id
	from STD_SURVEY_TYPE 
	where STD_SURVEY_TYPE.code = 'MSAT'
)

IF NOT EXISTS(
	SELECT  [QUESTION_NUMBER]
	FROM   [STD_QUESTION]
	WHERE [QUESTION_NUMBER] = 'CardioToxDateUnknown')	
	
		INSERT INTO [STD_QUESTION]
				   ([STD_SURVEY_TYPE_ID]
				   ,[QUESTION_NUMBER]
				   ,[QUESTION_TEXT]
				   ,[SORT_ORDER]
				   ,[CREATEDBY]
				   ,[CREATED]
				   ,[UPDATEDBY]
				   ,[UPDATED]
				   ,[INACTIVE_FLAG]
				   ,[INACTIVE_DATE])
			 VALUES
				   (@msat_surveyId
				   ,'CardioToxDateUnknown'
				   ,'Date of last cardiac MUGA or Echocardiogram unknown'
				   ,265
				   ,'vaaitcwhitea'
				   ,GETDATE()
				   ,'vaaitcwhitea'
				   ,GETDATE()
				   ,0
				   ,null)

set @questionId =
(
	select ID
	from STD_QUESTION
	where STD_SURVEY_TYPE_ID = 30 AND
		QUESTION_NUMBER = 'CardioToxDateUnknown'
)	

IF NOT EXISTS(
	SELECT  [STD_QUESTION_CHOICE_ID]
	FROM   [STD_QUESTION_CHOICE]
	WHERE [STD_QUESTION_ID] = @questionId AND
		[CHOICE_NAME] = '1')
		INSERT INTO STD_QUESTION_CHOICE
           ([STD_QUESTION_CHOICE_ID]
           ,[STD_QUESTION_ID]
           ,[CHOICE_NAME]
           ,[CHOICE_TEXT]
           ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG]
           ,[INACTIVE_DATE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           ((select max([std_question_choice_id])+1 from STD_QUESTION_CHOICE)
           ,@questionId
           ,'1'
           ,'true'
           ,1
           ,0
           ,null
           ,'vaaitcwhitea'
           ,'vaaitcwhitea'
           ,GETDATE()
           ,GETDATE())

IF NOT EXISTS(
	SELECT  [STD_QUESTION_CHOICE_ID]
	FROM   [STD_QUESTION_CHOICE]
	WHERE [STD_QUESTION_ID] = @questionId AND
		[CHOICE_NAME] = '2')
		INSERT INTO STD_QUESTION_CHOICE
           ([STD_QUESTION_CHOICE_ID]
           ,[STD_QUESTION_ID]
           ,[CHOICE_NAME]
           ,[CHOICE_TEXT]
           ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG]
           ,[INACTIVE_DATE]
           ,[CREATEDBY]
           ,[UPDATEDBY]
           ,[CREATED]
           ,[UPDATED])
     VALUES
           ((select max([std_question_choice_id])+1 from STD_QUESTION_CHOICE)
           ,@questionId
           ,'2'
           ,'false'
           ,1
           ,0
           ,null
           ,'vaaitcwhitea'
           ,'vaaitcwhitea'
           ,GETDATE()
           ,GETDATE())
GO
-------------------------------------
--
-- Expand MSSR_Current_Status 
-- LastAssessType column
--
-------------------------------------

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_CURRENT_STATUS'
		AND COLUMN_NAME = 'LASTASSESSTYPE'
		AND CHARACTER_MAXIMUM_LENGTH = 25)	
		
			ALTER TABLE [MSSR].[MSSR_CURRENT_STATUS]
			ALTER COLUMN LASTASSESSTYPE varchar(25)	
	GO
	
-------------------------------------
--
-- Expand MSSR_HF_Condensed 
-- LastAssessType column
--
-------------------------------------

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_HF_Condensed'
		AND COLUMN_NAME = 'AssessmentType'
		AND CHARACTER_MAXIMUM_LENGTH = 25)	
		
			ALTER TABLE [MSSR].[MSSR_HF_Condensed]
			ALTER COLUMN AssessmentType varchar(25)	
	GO
	
-------------------------------------
--
-- Update existing values
--
-------------------------------------	
		
	Update  MSSR.MSSR_HF_Condensed
	set AssessmentType = 'MEDICATIONS ONLY'
	where AssessmentType = 'AD HOC'


	Update  MSSR.MSSR_CURRENT_STATUS
	set LastAssessType = 'MEDICATIONS ONLY'
	where LastAssessType = 'AD HOC'
