-------------------------------------------
--
-- Create mapping table between medicines
-- and reasons stopped
--
-------------------------------------------
	/****** Object:  Table [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED]    Script Date: 01/21/2015 12:08:18 ******/
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED]') AND type in (N'U'))
	DROP TABLE [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED]
	GO

	/****** Object:  Table [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED]    Script Date: 01/21/2015 12:08:21 ******/
	SET ANSI_NULLS ON
	GO

	SET QUOTED_IDENTIFIER ON
	GO

	CREATE TABLE [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED](
		[ID] [int] IDENTITY(1,1) NOT NULL,
		[MSSR_MEDICATION_ID] [int] NOT NULL,
		[MSSR_MEDICATION_REASON_STOPPED_ID] [int] NOT NULL,
		[SortOrder] [int] NOT NULL
		
	CONSTRAINT [ID_PK] PRIMARY KEY CLUSTERED 
	(
		[ID] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]

	GO

	ALTER TABLE [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] WITH CHECK ADD  CONSTRAINT [FK_MSSR_MEDICATION_TO_REASON_STOPPED_MSSR_MEDICATION] FOREIGN KEY([MSSR_MEDICATION_ID])
	REFERENCES [MSSR].[MSSR_MEDICATION] ([ID])
	GO

	ALTER TABLE [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] CHECK CONSTRAINT [FK_MSSR_MEDICATION_TO_REASON_STOPPED_MSSR_MEDICATION]
	GO


	ALTER TABLE [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] WITH CHECK ADD  CONSTRAINT [FK_MSSR_MEDICATION_TO_REASON_STOPPED_MSSR_MEDICATION_REASON_STOPPED] FOREIGN KEY([MSSR_MEDICATION_REASON_STOPPED_ID])
	REFERENCES [MSSR].[MSSR_MEDICATION_REASON_STOPPED] ([ID])
	GO

	ALTER TABLE [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] CHECK CONSTRAINT [FK_MSSR_MEDICATION_TO_REASON_STOPPED_MSSR_MEDICATION_REASON_STOPPED]
	GO

-------------------------------------
--
-- Create flag for NumDosesTaken
-- in Medication and update
--
-------------------------------------

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_MEDICATION'
		AND COLUMN_NAME = 'ShowNumDosesTaken')	
				
			ALTER TABLE [MSSR].[MSSR_MEDICATION]
			ADD [ShowNumDosesTaken] bit
			CONSTRAINT ShowNumDosesTakenDefault DEFAULT (0) NOT NULL
	GO
	
	Update [MSSR].[MSSR_MEDICATION]
	Set [ShowNumDosesTaken] = 0
	
	Update [MSSR].[MSSR_MEDICATION]
	Set [ShowNumDosesTaken] = 1
	Where Medication in (
		'Mitoxantrone (Novantrone)',
		'Natalizumab (Tysabri)')
	
	GO
-------------------------------------
--
-- Create Extentions for Reasons 
-- Stopped column
--
-------------------------------------

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_MEDICATION_REASON_STOPPED'
		AND COLUMN_NAME = 'Extention_Parent_ID')	
				
			ALTER TABLE [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			ADD [Extention_Parent_ID] INT
			CONSTRAINT ExtentionParentIdDefault DEFAULT (0) NOT NULL
	GO
	
-------------------------------------
--
-- Create Number of Doses Taken
-- in Patient Medication table
--
-------------------------------------

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'CurrentNumberOfDosesTaken')	
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			ADD [CurrentNumberOfDosesTaken] varchar(50)
	GO

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'PastNumberOfDosesTaken')	
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			ADD [PastNumberOfDosesTaken] varchar(50)
	GO

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'ADVERSE_EVENTS')	
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			ADD [ADVERSE_EVENTS] bit
	GO

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'ADVERSE_EVENTS_DESCRIPTION')	
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			ADD [ADVERSE_EVENTS_DESCRIPTION] varchar(75)
	GO
	
	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'ADVERSE_EVENT')	
		Begin	
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			ADD [ADVERSE_EVENT] int	
		
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]  WITH CHECK ADD  CONSTRAINT 
				[FK_MSSR_PATIENT_MEDICATION_MSSR_MEDICATION_REASON_STOPPED_ADVERSE_EVENT] FOREIGN KEY([ADVERSE_EVENT])
			REFERENCES [MSSR].[MSSR_MEDICATION_REASON_STOPPED] ([ID])
		End
	GO	

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'OTHER_DMT_NAME')	
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			ADD [OTHER_DMT_NAME] varchar(50)
	GO
	
-------------------------------------------
--
-- Add Significant Events Other storage
--
-------------------------------------------

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_PATIENT_MEDICATION'
		AND COLUMN_NAME = 'SigEventOther')	
				
			ALTER TABLE [MSSR].[MSSR_PATIENT_MEDICATION]
			ADD [SigEventOther] varchar(75)
	GO

-------------------------------------
--
-- Update medicine display names
--
-------------------------------------	

	UPDATE [MSSR].[MSSR_MEDICATION]
	SET MEDICATION = 'Dimethyl Fumerate (Tecfidera)'
	WHERE HEALTH_FACTOR = 'DIMETHYL FUMERATE'

	UPDATE [MSSR].[MSSR_MEDICATION]
	SET MEDICATION = 'Methotrexate (Trexall/Rheumatrex)'
	WHERE HEALTH_FACTOR = 'METHOTREXATE'	
	
	
-------------------------------------
--
-- Expand Reason Stopped column
--
-------------------------------------

	IF NOT EXISTS(
		SELECT  *
		FROM   INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_SCHEMA = 'MSSR' 
		AND  TABLE_NAME = 'MSSR_MEDICATION_REASON_STOPPED'
		AND COLUMN_NAME = 'REASON_STOPPED'
		AND CHARACTER_MAXIMUM_LENGTH = 100)	
		
			ALTER TABLE [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			ALTER COLUMN REASON_STOPPED varchar(100)	
	GO

-------------------------------------
--
-- Create Other DMT's medicine
--
-------------------------------------

	IF NOT EXISTS(
		SELECT MEDICATION 
		FROM [MSSR].[MSSR_MEDICATION]
		WHERE MEDICATION = 'Other DMTs'
		)				
			insert into [MSSR].[MSSR_MEDICATION]
			values (
				'Other DMTs',
				'UNKNOWN',
				0,
				0	 
			)
	GO
	
-------------------------------------
--
-- Create additional reasons stopped
-- and extensions
-------------------------------------

	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. leukopenia, allergic reaction, nausea/vomiting)'
		)				
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. leukopenia, allergic reaction, nausea/vomiting)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. cystitis, leukopenia, nausea/vomiting)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. cystitis, leukopenia, nausea/vomiting)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO	
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. nausea, flushing, infection)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. nausea, flushing, infection)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO		
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. cardiac toxicity, infection, macular edema)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. cardiac toxicity, infection, macular edema)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO		
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. injection site reaction, chest pain, rash)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. injection site reaction, chest pain, rash)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO	
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. Injection site reaction, flu-like symptoms, depression)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. Injection site reaction, flu-like symptoms, depression)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. stomatitis, leukopenia, nausea)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. stomatitis, leukopenia, nausea)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. diminished cardiac ejection fraction, infection, nausea)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. diminished cardiac ejection fraction, infection, nausea)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. leukopenia, peripheral edema, hematuria)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. leukopenia, peripheral edema, hematuria)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. allergic reaction, infection, abnormal liver enzymes)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. allergic reaction, infection, abnormal liver enzymes)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = '(e.g. infusion reaction, infection, leukopenia)'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'(e.g. infusion reaction, infection, leukopenia)',
				0,
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication')		 
			)
	GO
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = 'Other significant adverse event'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'Other significant adverse event',
				(select ID from [MSSR].[MSSR_MEDICATION_REASON_STOPPED] 
				 where REASON_STOPPED = 'Intolerance to medication'),
				 0		 
			)
	GO
	
	IF NOT EXISTS(
		SELECT REASON_STOPPED 
		FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
		WHERE REASON_STOPPED = 'Other reason stopped'
		)		
			insert into [MSSR].[MSSR_MEDICATION_REASON_STOPPED]
			values (
				'Other reason stopped',
				0,
				0		 
			)
	GO

-------------------------------------
--
-- Create current mappings
--
-------------------------------------

	Delete [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED]
	GO

-- Azathioprine (Imuran)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Azathioprine (Imuran)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Azathioprine (Imuran)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Azathioprine (Imuran)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. leukopenia, allergic reaction, nausea/vomiting)'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Azathioprine (Imuran)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Azathioprine (Imuran)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2 
	)
	GO

-- Cyclophosphamide (Cytoxan)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Cyclophosphamide (Cytoxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Cyclophosphamide (Cytoxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Cyclophosphamide (Cytoxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. cystitis, leukopenia, nausea/vomiting)'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Cyclophosphamide (Cytoxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Cyclophosphamide (Cytoxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO
	
-- Daclizumab (Zenapax) 

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1 
	)
	GO	
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. cystitis, leukopenia, nausea/vomiting)'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Blood count abnormal'),
		2 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Rash/Allergic reaction'),
		3 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Immunosupression-related complication'),
		4 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other significant adverse event'),
		5 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Daclizumab (Zenapax)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		6
	)
	GO
		
-- Dimethyl Fumerate (Tecfidera) 

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Dimethyl Fumerate (Tecfidera)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Dimethyl Fumerate (Tecfidera)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Dimethyl Fumerate (Tecfidera)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. nausea, flushing, infection)'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Dimethyl Fumerate (Tecfidera)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Dimethyl Fumerate (Tecfidera)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Fingolimod (Gilenya)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Fingolimod (Gilenya)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Fingolimod (Gilenya)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Fingolimod (Gilenya)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. cardiac toxicity, infection, macular edema)'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Fingolimod (Gilenya)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Fingolimod (Gilenya)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Glatiramer (Copaxone)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Glatiramer (Copaxone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Glatiramer (Copaxone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Glatiramer (Copaxone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. injection site reaction, chest pain, rash)'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Glatiramer (Copaxone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Glatiramer (Copaxone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Interferon beta-1a (Avonex)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Avonex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Avonex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Avonex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. Injection site reaction, flu-like symptoms, depression)'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Avonex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Avonex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Interferon beta-1a (Rebif)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Rebif)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Rebif)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Rebif)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. Injection site reaction, flu-like symptoms, depression)'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Rebif)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1a (Rebif)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Interferon beta-1b (Betaseron)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Betaseron)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Betaseron)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Betaseron)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. Injection site reaction, flu-like symptoms, depression)'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Betaseron)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Betaseron)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Interferon beta-1b (Extavia)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Extavia)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Extavia)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Extavia)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. Injection site reaction, flu-like symptoms, depression)'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Extavia)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Interferon beta-1b (Extavia)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Methotrexate (Trexall/Rheumatrex)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Methotrexate (Trexall/Rheumatrex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Methotrexate (Trexall/Rheumatrex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Methotrexate (Trexall/Rheumatrex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. stomatitis, leukopenia, nausea)'),
		0
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Methotrexate (Trexall/Rheumatrex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Methotrexate (Trexall/Rheumatrex)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Mitoxantrone (Novantrone)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mitoxantrone (Novantrone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Maximum dose reached'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mitoxantrone (Novantrone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mitoxantrone (Novantrone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		2 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mitoxantrone (Novantrone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. diminished cardiac ejection fraction, infection, nausea)'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mitoxantrone (Novantrone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		3
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mitoxantrone (Novantrone)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Mycophenolate Mofetil (Cellcept)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mycophenolate Mofetil (Cellcept)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mycophenolate Mofetil (Cellcept)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mycophenolate Mofetil (Cellcept)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. leukopenia, peripheral edema, hematuria)'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mycophenolate Mofetil (Cellcept)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Mycophenolate Mofetil (Cellcept)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		3
	)
	GO

-- Natalizumab (Tysabri)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Natalizumab (Tysabri)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Natalizumab (Tysabri)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		1
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Natalizumab (Tysabri)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. allergic reaction, infection, abnormal liver enzymes)'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Natalizumab (Tysabri)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Serum JC antibody positive'),
		2 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Natalizumab (Tysabri)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		3 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Natalizumab (Tysabri)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		4
	)
	GO

-- Rituximab (Rituxan)

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Treatment cycle completed'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = '(e.g. infusion reaction, infection, leukopenia)'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		3 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		4
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Blood count abnormal'),
		3 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Rash/Allergic reaction'),
		4 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Immunosupression-related complication'),
		5 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Rituximab (Rituxan)'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other significant adverse event'),
		6 
	)
	GO
	
-- 'Other DMTs'

	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Other DMTs'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Maximum dose reached'),
		0 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Other DMTs'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Ineffective'),
		1 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Other DMTs'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Intolerance to medication'),
		2
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Other DMTs'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Significant adverse event'),
		3 
	)
	GO
	insert into [MSSR].[MSSR_MEDICATION_TO_REASON_STOPPED] values 
	(
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION] where MEDICATION = 'Other DMTs'), 
		(SELECT ID FROM [MSSR].[MSSR_MEDICATION_REASON_STOPPED] where REASON_STOPPED = 'Other reason stopped'),
		4
	)
	GO