/****** Object:  View [DVEIR].[uvw_Providers]    Script Date: 01/07/2015 14:53:07 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[DVEIR].[uvw_Providers]'))
DROP VIEW [DVEIR].[uvw_Providers]
GO

/****** Object:  View [DVEIR].[uvw_Providers]    Script Date: 01/07/2015 14:53:09 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [DVEIR].[uvw_Providers]
AS
select x.provider_id, x.first_name, x.last_name
from (
	Select p.provider_id, p.first_name, p.last_name
	from [dbo].[Provider] P
		join [dbo].[Primary_Care_Physician] pcp on p.[provider_id] = pcp.[provider_Id]
		join [dbo].[referral] r on pcp.[patient_id] = r.[patient_id]
		join [dbo].[std_registry] sr on r.[std_registry_id] = sr.[id] 
	where (sr.[code] = 'DVEIR') and (p.[last_name] is not null)
	Union
	Select p.provider_id, p.first_name, p.last_name
	from dbo.referral ref 
			join dbo.std_registry stdReg on ref.std_registry_id = stdReg.[id] 
			join DVEIR.er_encounter e on ref.referral_id = e.referral_id 
			join dbo.provider p on e.provider_id = p.[Provider_id] 
	where (stdreg.[code] = 'DVEIR') and (p.[last_name] is not null)
) X 

GO