-- Settings
--declare @efrId int
--set @efrId = 
--(
--	Select ID
--	From STD_REGISTRY
--	Where Code = 'EFR'
--)

--delete from CRS_SETTINGS
--where [NAME] = 'EfrDoDFragTestMode'

--INSERT INTO [CRS_SETTINGS]
--		   ([STD_REGISTRY_ID]
--		   ,[NAME]
--		   ,[VALUE]
--		   ,[DESCRIPTION]
--		   ,[COMMENTS]
--		   ,[CREATED]
--		   ,[CREATEDBY])
--	 VALUES
--		   (@efrId                              
--		   ,'EfrDoDFragTestMode'  
--		   ,'true'            
--		   ,'Set to true for testing, false for real ops' 
--		   ,'Used by DoD Frag ETL' 
--		   ,GETDATE()                        
--		   ,'awhiteleather')                   
--GO


declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragLogAllTransactions'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragLogAllTransactions'  
		   ,'true'            
		   ,'Set to true for logging all runs, false for only logging on error' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO


declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragCrsMviEtlName'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragCrsMviEtlName'  
		   ,'\\CRS\\CRS_MVI_GetPatientIdentity'            
		   ,'Name of the CRSMVI ETL used to validate EDIPIs' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragEdipiColumnName'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragEdipiColumnName'  
		   ,'edipi'            
		   ,'Name of the EDIPI column in the input spreadsheet' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragLabReportColumnName'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragLabReportColumnName'  
		   ,'Lab Report Date'            
		   ,'Name of the Lab Report column in the input spreadsheet, this is only used if the spreadsheet doesnt match the naming convention or if the column is not found' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragSsnColumnName'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragSsnColumnName'  
		   ,'ssn'            
		   ,'Name of the SSN column in the input spreadsheet' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragArchiveFolder'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragArchiveFolder'  
		   --,'\\vaauscrssql70\\Archive\\EFR\\DoDFragment_import\\Archive'  
		   ,'\\vacrssql40\\nds_etl2$\\PreProduction\\DoDFragment_Import\\Archive'          
		   ,'location of archive folder on the server' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragJpcKeyField'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragJpcKeyField'  
		   ,'Lab code'            
		   ,'Unique field in the JPC frag files' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragUsafKeyField'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragUsafKeyField'  
		   ,'DLS Sample Number'            
		   ,'Unique field in the USAF frag files' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragEmfKeyField'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragEmfKeyField'  
		   ,'DLS Sample Number'            
		   ,'unique field in the EMF files' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragJpcLabDateField'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragJpcLabDateField'  
		   ,'Report'            
		   ,'Lab Report Date field in the JPC files' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragUsafLabDateField'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragUsafLabDateField'  
		   ,'Report Date'            
		   ,'Lab Report Date field in the USAF files' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

declare @efrId int
set @efrId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'EFR'
)

delete from CRS_SETTINGS
where [NAME] = 'EfrDoDFragEmfLabDateField'

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@efrId                              
		   ,'EfrDoDFragEmfLabDateField'  
		   ,'Lab Report Date'            
		   ,'Lab Report Date field in the EMF files' 
		   ,'Used by DoD Frag ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO
-- Add ICN column

if not exists(select * from sys.columns 
				where Name = N'PATIENT_ICN' 
				and Object_ID = Object_ID(N'EFR.DoD_FRAGMENT_DATA_RECEIVELOG'))
begin
	alter table EFR.DoD_FRAGMENT_DATA_RECEIVELOG
	add PATIENT_ICN varchar(50) null
end
go

-- Update ICN

update EFR.DoD_FRAGMENT_DATA_RECEIVELOG 
set PATIENT_ICN = dbo.PATIENT.PATIENT_ICN 
From dbo.patient 
Where EFR.DoD_FRAGMENT_DATA_RECEIVELOG.PATIENTSSN = dbo.patient.SSN 
Go

--
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('15'
           ,'00'
           ,'001'
           ,0
           ,'DoD Frag Update'
		   ,'SQL updates for DoD Fragment ETL update'
           ,'CRS'
           ,GETDATE())

GO