-- Settings
declare @crsId int
set @crsId = 
(
	Select ID
	From STD_REGISTRY
	Where Code = 'CRS'
)

delete from CRS_SETTINGS
where [NAME] in 
	('CrsMviProcessingCode',
	 'CrsMviSoapXml')

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@crsId                              
		   ,'CrsMviProcessingCode'  
		   ,'T'           
		   ,'Set to T for testing, P for real ops' 
		   ,'Used by Used by CRS_MVI_GetPatientIdentity ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   

INSERT INTO [CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (@crsId                              
		   ,'CrsMviSoapXml'  
		   ,'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Header/><soapenv:Body><vaww:PRPA_IN201309UV02 xmlns="urn:hl7-org:v3" xmlns:vaww="http://URL         .va.gov" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 ../../schema/HL7V3/NE2008/multicacheschemas/PRPA_IN201309UV02.xsd" ITSVersion="XML_1.0"><id root="2.16.840.1.113883.4.349" extension="EEEEEEEEEE"/><creationTime value="20070810140900"/>VCVCVCVCVC<interactionId root="2.16.840.1.113883.1.6"/><processingCode code="PCPCPCPCPC"/><processingModeCode code="T"/><acceptAckCode code="AL"/><receiver typeCode="RCV"><device classCode="DEV" determinerCode="INSTANCE"><id root="2.16.840.1.113883.4.349"/></device></receiver><sender typeCode="SND"><device classCode="DEV" determinerCode="INSTANCE"><id extension="200CRS" root="2.16.840.1.113883.4.349"/></device></sender><controlActProcess classCode="CACT" moodCode="EVN"><code code="PRPA_TE201309UV02" codeSystem="2.16.840.1.113883.1.6"/><queryByParameter><queryId root="2.16.840.1.113883.4.349" extension="UIDUIDUIDUID"/><statusCode code="new"/><responsePriorityCode code="I"/><parameterList><patientIdentifier><!--edipi--><value root="2.16.840.1.113883.3.42.10001.100001.12" extension="EDIPIEDIPIEDIPI"/><semanticsText>Patient.Id</semanticsText></patientIdentifier></parameterList></queryByParameter></controlActProcess></vaww:PRPA_IN201309UV02></soapenv:Body></soapenv:Envelope>'  
		   ,'Segments of Soap XML for connecting to VAAFI/MVI' 
		   ,'Used by Used by CRS_MVI_GetPatientIdentity ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')  

GO

INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('13'
           ,'00'
           ,'001'
           ,0
           ,'CRS Update'
		   ,'Script will set the CrsMviSoapXml setting'
           ,'CRS'
           ,GETDATE())

GO