--CRS - RTC 109272
--V.Naik --08/11/2014
--Create table STD_CRS_MVI_QueryResponseCode_1310
--CRS_Sprint13.00.001.109272_2.sql
--The script will create table STD_CRS_MVI_QueryResponseCode_1310 in RegistryQA database.

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[STD_CRS_MVI_QueryResponseCode_1310]') AND type in (N'U'))
DROP TABLE [dbo].[STD_CRS_MVI_QueryResponseCode_1310]
GO
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[STD_CRS_MVI_QueryResponseCode_1310](
	[Response_ID] [int] IDENTITY(1,1) NOT NULL,
	[Acknowledgment_TypeCode_CodeAttribute] [varchar](20) NULL,
	[QueryAck_QueryResponseCode_CodeAttribute] [varchar](20) NULL,
	[DESCRIPTION_TEXT] [varchar](100) NULL,
	[CREATED] [datetime] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATED] [datetime] NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
 CONSTRAINT [PK_STD_CRS_MVI_QueryResponseCode_1310] PRIMARY KEY CLUSTERED 
(
	[Response_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


Insert into [dbo].[STD_CRS_MVI_QueryResponseCode_1310]
([Acknowledgment_TypeCode_CodeAttribute]
      ,[QueryAck_QueryResponseCode_CodeAttribute]
      ,[DESCRIPTION_TEXT]
      ,[CREATED]
      ,[CREATEDBY]
      ,[UPDATED]
      ,[UPDATEDBY])
  
VALUES ('AA'
      ,'OK'
      ,'App Ack/Results returned (happy path)'
      ,GETDATE()
      ,'INITIAL LOAD'
       ,GETDATE()
      ,'INITIAL LOAD')
GO

Insert into [dbo].[STD_CRS_MVI_QueryResponseCode_1310]
([Acknowledgment_TypeCode_CodeAttribute]
      ,[QueryAck_QueryResponseCode_CodeAttribute]
      ,[DESCRIPTION_TEXT]
      ,[CREATED]
      ,[CREATEDBY]
      ,[UPDATED]
      ,[UPDATEDBY])
  
VALUES ('AA'
      ,'NF'
      ,'App Ack/Not Found (0 results)'
      ,GETDATE()
	  ,'INITIAL LOAD'
      ,GETDATE()
      ,'INITIAL LOAD')
GO
      
Insert into [dbo].[STD_CRS_MVI_QueryResponseCode_1310]
([Acknowledgment_TypeCode_CodeAttribute]
      ,[QueryAck_QueryResponseCode_CodeAttribute]
      ,[DESCRIPTION_TEXT]
      ,[CREATED]
      ,[CREATEDBY]
      ,[UPDATED]
      ,[UPDATEDBY])

VALUES ('AE'
      ,'AE'
      ,'Application Error'
      ,GETDATE()
	  ,'INITIAL LOAD'
      ,GETDATE()
      ,'INITIAL LOAD')
GO

-------------------------
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('13'
           ,'00'
           ,'001'
           ,0
           ,'Create table STD_CRS_MVI_QueryResponseCode_1310 in RegistryQA database.'
		   ,'The script will create table STD_CRS_MVI_QueryResponseCode_1310 in RegistryQA database.'
           ,'CRS'
           ,GETDATE())

GO

--
-- Create CRS Registry entry if it doesn't exist
--
if (select count([CODE]) 
    from STD_REGISTRY
    where code = 'CRS') = 0
begin
	INSERT INTO [dbo].[STD_REGISTRY]
			   ([CODE]
			   ,[NAME]
			   ,[DESCRIPTION_TEXT]
			   ,[SORT_ORDER]
			   ,[INACTIVE_FLAG]
			   ,[INACTIVE_DATE]
			   ,[CREATEDBY]
			   ,[CREATED]
			   ,[UPDATEDBY]
			   ,[UPDATED])
		 VALUES
			   ('CRS'
			   ,'Converged Registries Solution'
			   ,'Converged Registries Solution'
			   ,8
			   ,0
			   ,null
			   ,'awhiteleather'
			   ,GETDATE()
			   ,'awhiteleather'
			   ,GETDATE()
			   )
End
GO

-- Settings

delete from CRS_SETTINGS
where [NAME] = 'CrsMviCertificateIssuerFriendlyName'

INSERT INTO [dbo].[CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (8                              
		   ,'CrsMviCertificateIssuerFriendlyName'  
		   ,'CRS_MVI_VAAFI_DEV'            
		   ,'Friendly name of certificate' 
		   ,'Used by CRS_MVI_GetPatientIdentity ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO


delete from CRS_SETTINGS
where [NAME] = 'CrsMviCertificateIssuerName'

INSERT INTO [dbo].[CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (8                             
		   ,'CrsMviCertificateIssuerName'  
		   ,'VA Internal Subordinate CA 1'            
		   ,'Name of certificate' 
		   ,'Used by CRS_MVI_GetPatientIdentity ETL' 
		   ,GETDATE()                       
		   ,'awhiteleather')                   
GO

delete CRS_SETTINGS
where [NAME] = 'CrsMviCertificateUrl'

INSERT INTO [dbo].[CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (8                              
		   ,'CrsMviCertificateUrl'  
		   --,'https://URL:PORT/psim_webservice/dev/IdMWebService' -- Ssl Dev
		   --,'http://URL:PORT/psim_webservice/IdMWebService' -- Open Dev
		   ,'https://URL:PORT/psim_webservice/stage1a/IdMWebService' -- SQA (Sql 40)
		   ,'Endpoint for web service call' 
		   ,'Used by CRS_MVI_GetPatientIdentity ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   

GO


delete from CRS_SETTINGS
where [NAME] = 'CrsMviVersionCode'

INSERT INTO [dbo].[CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (8                              
		   ,'CrsMviVersionCode'  
		   ,'3.0'                     
		   ,'Endpoint for web service call' 
		   ,'Used by CRS_MVI_GetPatientIdentity ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO

delete from CRS_SETTINGS
where [NAME] = 'CrsMviLogAllTransactions'

INSERT INTO [dbo].[CRS_SETTINGS]
		   ([STD_REGISTRY_ID]
		   ,[NAME]
		   ,[VALUE]
		   ,[DESCRIPTION]
		   ,[COMMENTS]
		   ,[CREATED]
		   ,[CREATEDBY])
	 VALUES
		   (8                              
		   ,'CrsMviLogAllTransactions'  
		   ,'true'          -- set to 'true' or 'false'           
		   ,'Turn on detailed logging' 
		   ,'Used by CRS_MVI_GetPatientIdentity ETL' 
		   ,GETDATE()                        
		   ,'awhiteleather')                   
GO


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('13'
           ,'00'
           ,'001'
           ,0
           ,'CrsMvi'
		   ,'Script will create the settings for the CrsMvi ETL'
           ,'CRS'
           ,GETDATE())
Go