--TBI CTBIE Form 27
BEGIN
	DECLARE @std_survey_type_id int;
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI EVAL';

	UPDATE dbo.STD_QUESTION SET QUESTION_TEXT='Are the history of the injury and course of clinical symptoms consistent with a diagnosis of TBI sustained during OEF/OIF deployment?',UPDATEDBY='PII',UPDATED=CURRENT_TIMESTAMP
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '27'
END
GO

--TBI CTBIE Form 21C
IF EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI EVAL' AND q.QUESTION_NUMBER = '21-C')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI EVAL';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '21-B';
	SELECT @std_question_id = [ID] FROM [dbo].[STD_QUESTION] WHERE [STD_SURVEY_TYPE_ID] = @std_survey_type_id AND [QUESTION_NUMBER] = '21-C';
	
	DELETE FROM [dbo].[STD_QUESTION_CHOICE] WHERE [STD_QUESTION_ID] = @std_question_id;
	DELETE FROM [dbo].[STD_QUESTION] WHERE [ID] = @std_question_id;
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER - 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
END
GO

--TBI CTBIE Form 21B
IF EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI EVAL' AND q.QUESTION_NUMBER = '21-B')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI EVAL';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '21-A';
	SELECT @std_question_id = [ID] FROM [dbo].[STD_QUESTION] WHERE [STD_SURVEY_TYPE_ID] = @std_survey_type_id AND [QUESTION_NUMBER] = '21-B';
	
	DELETE FROM [dbo].[STD_QUESTION_CHOICE] WHERE [STD_QUESTION_ID] = @std_question_id;
	DELETE FROM [dbo].[STD_QUESTION] WHERE [ID] = @std_question_id;
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER - 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
END
GO

--TBI CTBIE Form 21A
IF EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI EVAL' AND q.QUESTION_NUMBER = '21-A')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI EVAL';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '21';
	SELECT @std_question_id = [ID] FROM [dbo].[STD_QUESTION] WHERE [STD_SURVEY_TYPE_ID] = @std_survey_type_id AND [QUESTION_NUMBER] = '21-A';
	
	DELETE FROM [dbo].[STD_QUESTION_CHOICE] WHERE [STD_QUESTION_ID] = @std_question_id;
	DELETE FROM [dbo].[STD_QUESTION] WHERE [ID] = @std_question_id;
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER - 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
END
GO

--TBI Follow Up Form 19
BEGIN
	DECLARE @std_survey_type_id int;
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI FOLLOW-UP';

	UPDATE dbo.STD_QUESTION SET QUESTION_TEXT='Has the patient experienced a new TBI since their last diagnosis?',UPDATEDBY='PII',UPDATED=CURRENT_TIMESTAMP
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '19'
END
GO

--TBI Follow Up Form 16C
IF EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI FOLLOW-UP' AND q.QUESTION_NUMBER = '16-C')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI FOLLOW-UP';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '16-B';
	SELECT @std_question_id = [ID] FROM [dbo].[STD_QUESTION] WHERE [STD_SURVEY_TYPE_ID] = @std_survey_type_id AND [QUESTION_NUMBER] = '16-C';
	
	DELETE FROM [dbo].[STD_QUESTION_CHOICE] WHERE [STD_QUESTION_ID] = @std_question_id;
	DELETE FROM [dbo].[STD_QUESTION] WHERE [ID] = @std_question_id;
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER - 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
END
GO

--TBI Follow Up Form 16B
IF EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI FOLLOW-UP' AND q.QUESTION_NUMBER = '16-B')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI FOLLOW-UP';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '16-A';
	SELECT @std_question_id = [ID] FROM [dbo].[STD_QUESTION] WHERE [STD_SURVEY_TYPE_ID] = @std_survey_type_id AND [QUESTION_NUMBER] = '16-B';
	
	DELETE FROM [dbo].[STD_QUESTION_CHOICE] WHERE [STD_QUESTION_ID] = @std_question_id;
	DELETE FROM [dbo].[STD_QUESTION] WHERE [ID] = @std_question_id;
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER - 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
END
GO

--TBI Follow Up Form 16A
IF EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI FOLLOW-UP' AND q.QUESTION_NUMBER = '16-A')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI FOLLOW-UP';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '16';
	SELECT @std_question_id = [ID] FROM [dbo].[STD_QUESTION] WHERE [STD_SURVEY_TYPE_ID] = @std_survey_type_id AND [QUESTION_NUMBER] = '16-A';
	
	DELETE FROM [dbo].[STD_QUESTION_CHOICE] WHERE [STD_QUESTION_ID] = @std_question_id;
	DELETE FROM [dbo].[STD_QUESTION] WHERE [ID] = @std_question_id;
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER - 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
END
GO

/* 
-- TBI:109772 : Rollback 
*/

Declare 
@StdRegId int

--- set Registry
Select @StdRegId = [id] from [dbo].[std_registry] where ([CODE] = 'TBI')

Delete from [dbo].[CRS_SETTINGS] 
where ([STD_REGISTRY_ID] in (@stdRegId) and [NAME] in ('Cube Last Update','Cube Excel Instructions','Report Builder URL'))

GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[GET_CUBE_SETTINGS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [TBI].[GET_CUBE_SETTINGS]

