--TBI Follow Up Form 16A
IF NOT EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI FOLLOW-UP' AND q.QUESTION_NUMBER = '16-A')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @max_choice_id int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI FOLLOW-UP';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '16';
	SELECT @max_choice_id = MAX(STD_QUESTION_CHOICE_ID) FROM [dbo].[STD_QUESTION_CHOICE];
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER + 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
	
	INSERT INTO [dbo].[STD_QUESTION] ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
	VALUES (@std_survey_type_id,'16-A','Was a medication reconciliation performed?',(@sort_order + 1),'PII',CURRENT_TIMESTAMP,'PII',CURRENT_TIMESTAMP,0,NULL);
	
	SELECT @std_question_id = @@IDENTITY;

	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 1),@std_question_id,'Not asked (due to responses to other questions)','Not asked (due to responses to other questions)',NULL,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);

	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 2),@std_question_id,'Yes','Yes',1,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
	
	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 3),@std_question_id,'No','No medication changes made during this clinic visit',2,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
END
GO

--TBI Follow Up Form 16B
IF NOT EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI FOLLOW-UP' AND q.QUESTION_NUMBER = '16-B')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @max_choice_id int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI FOLLOW-UP';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '16-A';
	SELECT @max_choice_id = MAX(STD_QUESTION_CHOICE_ID) FROM [dbo].[STD_QUESTION_CHOICE];
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER + 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
	
	INSERT INTO [dbo].[STD_QUESTION] ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
	VALUES (@std_survey_type_id,'16-B','Was a printed medication list given to the patient?',(@sort_order + 1),'PII',CURRENT_TIMESTAMP,'PII',CURRENT_TIMESTAMP,0,NULL);
	
	SELECT @std_question_id = @@IDENTITY;

	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 1),@std_question_id,'Not asked (due to responses to other questions)','Not asked (due to responses to other questions)',NULL,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);

	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 2),@std_question_id,'Yes','Yes',1,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
	
	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 3),@std_question_id,'No','No',2,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
END
GO

--TBI Follow Up Form 16C
IF NOT EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI FOLLOW-UP' AND q.QUESTION_NUMBER = '16-C')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @max_choice_id int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI FOLLOW-UP';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '16-B';
	SELECT @max_choice_id = MAX(STD_QUESTION_CHOICE_ID) FROM [dbo].[STD_QUESTION_CHOICE];
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER + 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
	
	INSERT INTO [dbo].[STD_QUESTION] ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
	VALUES (@std_survey_type_id,'16-C','Please explain in free text box below:',(@sort_order + 1),'PII',CURRENT_TIMESTAMP,'PII',CURRENT_TIMESTAMP,0,NULL);
	
	SELECT @std_question_id = @@IDENTITY;
	
	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 1),@std_question_id,'Not asked (due to responses to other questions)','Not asked (due to responses to other questions)',NULL,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);

	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 2),@std_question_id,'Explanation Input:','Explanation Input:',1,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
END
GO

--TBI Follow Up Form 19
BEGIN
	DECLARE @std_survey_type_id int;
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI FOLLOW-UP';

	UPDATE dbo.STD_QUESTION SET QUESTION_TEXT='Based on the history of the injury and the course of clinical symptoms, has the Veteran experienced a new TBI since their last diagnosis?',UPDATEDBY='PII',UPDATED=CURRENT_TIMESTAMP
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '19'
END
GO

--TBI CTBIE Form 21A
IF NOT EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI EVAL' AND q.QUESTION_NUMBER = '21-A')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @max_choice_id int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI EVAL';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '21';
	SELECT @max_choice_id = MAX(STD_QUESTION_CHOICE_ID) FROM [dbo].[STD_QUESTION_CHOICE];
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER + 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
	
	INSERT INTO [dbo].[STD_QUESTION] ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
	VALUES (@std_survey_type_id,'21-A','Was a medication reconciliation performed?',(@sort_order + 1),'PII',CURRENT_TIMESTAMP,'PII',CURRENT_TIMESTAMP,0,NULL);
	
	SELECT @std_question_id = @@IDENTITY;

	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 1),@std_question_id,'Not asked (due to responses to other questions)','Not asked (due to responses to other questions)',NULL,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
	
	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 2),@std_question_id,'Yes','Yes',1,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
	
	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 3),@std_question_id,'No','No medication changes made during this clinic visit',2,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
END
GO

--TBI CTBIE Form 21B
IF NOT EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI EVAL' AND q.QUESTION_NUMBER = '21-B')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @max_choice_id int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI EVAL';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '21-A';
	SELECT @max_choice_id = MAX(STD_QUESTION_CHOICE_ID) FROM [dbo].[STD_QUESTION_CHOICE];
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER + 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
	
	INSERT INTO [dbo].[STD_QUESTION] ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
	VALUES (@std_survey_type_id,'21-B','Was a printed medication list given to the patient?',(@sort_order + 1),'PII',CURRENT_TIMESTAMP,'PII',CURRENT_TIMESTAMP,0,NULL);
	
	SELECT @std_question_id = @@IDENTITY;
	
	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 1),@std_question_id,'Not asked (due to responses to other questions)','Not asked (due to responses to other questions)',NULL,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);

	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 2),@std_question_id,'Yes','Yes',1,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
	
	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 3),@std_question_id,'No','No',2,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
END
GO

--TBI CTBIE Form 21C
IF NOT EXISTS (SELECT * FROM dbo.STD_QUESTION q INNER JOIN dbo.STD_SURVEY_TYPE t ON t.ID = q.STD_SURVEY_TYPE_ID WHERE t.CODE = 'COMP TBI EVAL' AND q.QUESTION_NUMBER = '21-C')
BEGIN
	DECLARE @std_survey_type_id int;
	DECLARE @sort_order int;
	DECLARE @max_choice_id int;
	DECLARE @std_question_id int;
	
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI EVAL';
	SELECT @sort_order = SORT_ORDER FROM dbo.STD_QUESTION WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '21-B';
	SELECT @max_choice_id = MAX(STD_QUESTION_CHOICE_ID) FROM [dbo].[STD_QUESTION_CHOICE];
	
	UPDATE dbo.STD_QUESTION SET SORT_ORDER = (SORT_ORDER + 1)
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND SORT_ORDER > @sort_order;
	
	INSERT INTO [dbo].[STD_QUESTION] ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
	VALUES (@std_survey_type_id,'21-C','Please explain in free text box below:',(@sort_order + 1),'PII',CURRENT_TIMESTAMP,'PII',CURRENT_TIMESTAMP,0,NULL);
	
	SELECT @std_question_id = @@IDENTITY;
	
	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 1),@std_question_id,'Not asked (due to responses to other questions)','Not asked (due to responses to other questions)',NULL,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);

	INSERT INTO [dbo].[STD_QUESTION_CHOICE] ([STD_QUESTION_CHOICE_ID],[STD_QUESTION_ID],[CHOICE_NAME],[CHOICE_TEXT],[CHOICE_SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
	VALUES ((@max_choice_id + 2),@std_question_id,'Explanation Input:','Explanation Input:',1,0,NULL,'PII','PII',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP);
END
GO

--TBI CTBIE Form 27
BEGIN
	DECLARE @std_survey_type_id int;
	SELECT @std_survey_type_id = ID FROM dbo.STD_SURVEY_TYPE WHERE CODE = 'COMP TBI EVAL';

	UPDATE dbo.STD_QUESTION SET QUESTION_TEXT='Based on the history of the injury and the course of clinical symptoms, did the Veteran sustain a TBI during OEF/OIF deployment?',UPDATEDBY='PII',UPDATED=CURRENT_TIMESTAMP
	WHERE STD_SURVEY_TYPE_ID = @std_survey_type_id AND QUESTION_NUMBER = '27'
END
GO

/* 
-- Create script for db objects & references - TBI:109772 

	1. creates new crs setting record for the report builder URL
	2. creates new procedure to return data required for the Cube details screen.
		- Last Update Date


-- Testing
	Exec [TBI].[GET_CUBE_SETTINGS]

*/

Declare 
@StdRegId int,
@RBurl varchar(1000),
@ExcelInstructions varchar(1000)

--- set Registry
Select @StdRegId = [id] from [dbo].[std_registry] where ([CODE] = 'TBI')
set @ExcelInstructions = '\\PII\CRS Team Share\Instructions\TBI\TBI_Cube_wExcel.docx'

--- set URLs
if (ServerProperty('Servername') = 'DNS')
Begin
	set @RBurl = 'http://URL:PORT/reportserver/reportbuilder/reportbuilder.application'
End	
else if (ServerProperty('Servername') = 'DNS')
Begin
	set @RBurl = 'http://URL/reportserver/reportbuilder/reportbuilder.application'
End
else if (ServerProperty('Servername') = 'DNS')
begin
	set @RBurl = 'http://URL/reportserver/reportbuilder/reportbuilder.application'
End

-- Create new CRS Setting record
if not exists (select 1 from [dbo].[CRS_SETTINGS] where ([name] = 'Report Builder URL') and ([std_registry_id] = @stdRegId))
Begin
	Insert into [dbo].[CRS_SETTINGS]
	([STD_REGISTRY_ID], [Name], [Value], [Description], [comments], [created], [createdby])
	Select @StdRegId, 'Report Builder URL', @RBurl, 'The URL for the report builder in the appopiate environment', Null, getdate(), 'vaaitcrollim'
End

if not exists (select 1 from [dbo].[CRS_SETTINGS] where ([name] = 'Cube Excel Instructions') and ([std_registry_id] = @stdRegId))
Begin
	Insert into [dbo].[CRS_SETTINGS]
	([STD_REGISTRY_ID], [Name], [Value], [Description], [comments], [created], [createdby])
	Select @StdRegId, 'Cube Excel Instructions', @ExcelInstructions, 'These instructions can be used to setup a MS Excel link to one of the three Analysis Services TBI Cube databases', Null, getdate(), 'vaaitcrollim'
End

if not exists (select 1 from [dbo].[CRS_SETTINGS] where ([name] = 'Cube Last Update') and ([std_registry_id] = @stdRegId))
Begin
	Insert into [dbo].[CRS_SETTINGS]
	([STD_REGISTRY_ID], [Name], [Value], [Description], [comments], [created], [createdby])
	Select @StdRegId, 'Cube Last Update', 'Mar 14 2014 10:26AM', 'The date the cube was last processed', Null, getdate(), 'vaaitcrollim'
End



GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TBI].[GET_CUBE_SETTINGS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [TBI].[GET_CUBE_SETTINGS]
GO
CREATE PROCEDURE [TBI].[GET_CUBE_SETTINGS]
AS
Begin
	Declare 
	@StdRegId int
	
	Declare @result table ([name] varchar(100), [value] varchar(1000))

	--- set Registry
	Select @StdRegId = [id] from [dbo].[std_registry] where ([CODE] = 'TBI')
	
	Insert into @result 
	([Name], [Value])
	Select [name], [VALUE]
	from [dbo].[CRS_SETTINGS]
	where [STD_REGISTRY_ID] = @StdRegId 

	-- return result
	Select [Name], [value] from @Result order by [name]
End

GO

