
update efr.std_analytetype 
set BIOMONITORING_FLAG = 1 
where code = 'molybdenum'
GO

if not exists 
	(select id 
     from EFR.STD_ANALYTE_TEST_REFERENCE_RANGE
     where STD_ANALYTE_TYPE_ID = 32 and STD_TEST_NAME_ID = 4)
     BEGIN
		insert into  EFR.STD_ANALYTE_TEST_REFERENCE_RANGE (
		 STD_ANALYTE_TYPE_ID, 
		 STD_TEST_NAME_ID, 
		 REFERENCE_RANGE, 
		 STD_UNITS_ID, 
		 CREATED, 
		 UPDATED, 
		 CREATEDBY, 
		 UPDATEDBY)
		 values (32, 4, '0-127', 5, GETDATE(), GETDATE(), '7Delta', '7Delta')
	END
	
if not exists 
	(select id 
     from EFR.STD_ANALYTE_TEST_REFERENCE_RANGE
     where STD_ANALYTE_TYPE_ID = 32 and STD_TEST_NAME_ID = 6)
     BEGIN
		insert into  EFR.STD_ANALYTE_TEST_REFERENCE_RANGE (
		 STD_ANALYTE_TYPE_ID, 
		 STD_TEST_NAME_ID, 
		 REFERENCE_RANGE, 
		 STD_UNITS_ID, 
		 CREATED, 
		 UPDATED, 
		 CREATEDBY, 
		 UPDATEDBY)
		 values (32, 6, '0-144', 2, GETDATE(), GETDATE(), '7Delta', '7Delta')
	END
Go

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_ANALYTES]    Script Date: 07/02/2013 09:22:13 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LABORDER_ANALYTES]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LABORDER_ANALYTES]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_LABORDER_ANALYTES]    Script Date: 07/02/2013 09:22:13 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Jim Hagerty
-- Create date: 08/20/2010
-- Description:	Proc for Lab Order SSR
----Revision: 01/16/2012 Added ARCHIVED_FLAG = 0 reference bug tracker #1539.
----Revision: 07/02/2013: Added Molybdenum - 20750
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LABORDER_ANALYTES]
	@activityId int
AS
BEGIN
	
          SELECT     (SELECT     COUNT(EFR.STD_ANALYTETYPE.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY INNER JOIN
          EFR.LAB_ORDER ON WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = EFR.LAB_ORDER.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL ON EFR.LAB_ORDER.LAB_ORDER_ID = EFR.LAB_ORDER_DETAIL.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE ON EFR.LAB_ORDER_DETAIL.STD_ANALYTETYPE_ID = EFR.STD_ANALYTETYPE.ID
          WHERE      (WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = @activityId) AND (EFR.STD_ANALYTETYPE.ID = 3) AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0)) AS Aluminum,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 1) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Arsenic,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 2) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Cadmium,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 6) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Chromium,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 5) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Cobalt,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 10) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Copper,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 4) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Iron,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 8) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Manganese,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 32) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Molybdenum,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 7) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Nickel,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 9) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Lead,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 10) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Uranium,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 13) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Uranium235,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 11) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Tungsten,
          (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 14) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Zinc,
		   (SELECT     COUNT(STD_ANALYTETYPE_1.ID) AS Expr1
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 15) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS Other,
          (SELECT Top 1  OTHER_ANALYTE_NAME 
          FROM          WKF_CASE_ACTIVITY AS WKF_CASE_ACTIVITY_1 INNER JOIN
          EFR.LAB_ORDER AS LAB_ORDER_1 ON
          WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = LAB_ORDER_1.WKF_CASE_ACTIVITY_ID INNER JOIN
          EFR.LAB_ORDER_DETAIL AS LAB_ORDER_DETAIL_1 ON
          LAB_ORDER_1.LAB_ORDER_ID = LAB_ORDER_DETAIL_1.LAB_ORDER_ID INNER JOIN
          EFR.STD_ANALYTETYPE AS STD_ANALYTETYPE_1 ON
          LAB_ORDER_DETAIL_1.STD_ANALYTETYPE_ID = STD_ANALYTETYPE_1.ID
          WHERE      (WKF_CASE_ACTIVITY_1.WKF_CASE_ACTIVITY_ID = @activityId) AND (STD_ANALYTETYPE_1.ID = 15) AND (WKF_CASE_ACTIVITY_1.ARCHIVED_FLAG = 0)) AS OtherName
		
	END

GO


begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('06'
           ,'04'
           ,'001'
           ,0
           ,'20750: Add Molybdenum to Panel of Metals'
		   ,'Add Molybdenum to Panel of Metals'
           ,'EFR'
           ,GETDATE())
end
GO
