-- Fix the issue with user defined function HL7ChangeFromASCII
ALTER FUNCTION [dbo].[HL7ChangeFromASCII] (@dataString AS varchar(max))
Returns
varchar(max)
with encryption
AS
BEGIN
      DECLARE     @workarea AS nvarchar(max),
                  @loopCNT  AS int,
                  @query nvarchar(100),     
                  @parameters nvarchar(50),
                  @intVal int; 
                  

      Set @loopCNT=0;
      Set @workarea='';
      while(@loopCNT < LEN(@dataString))
      BEGIN
         Set @loopCNT = @loopCNT+1;
         IF(SUBSTRING(@dataString,@loopCNT,2) = '\X')
         BEGIN
                Set @loopCNT = @loopCNT + 2;
                  select     @query = 'select @intVal = convert(int,' + '0x' + SUBSTRING(@dataString,@loopCNT,2) + ')',     
                                    @parameters = '@intVal int output'  
              exec master.dbo.Sp_executesql @query, @parameters, @intVal output 
                Set @workarea = @workarea + CHAR(@intVal);
                Set @loopCNT = @loopCNT + 2;
         END
         ELSE
                  Set @workarea = @workarea + SUBSTRING(@dataString,@loopCNT,1);
         
      END

      return @workarea;
END

GO


begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('06'
           ,'00'
           ,'002'
           ,0
           ,'Fix the formatting issue with user defined function HL7ChangeFromASCII'
		   ,'DVEIR-DVEIVR interface: Fix the formatting issue with user defined function HL7ChangeFromASCII'
           ,'DVEIR'
           ,GETDATE())
end
GO
