if exists(Select * from sys.columns where name='DOMAIN' and object_id=object_id('USERS'))
BEGIN
	alter table users
	drop column Domain 

	alter table users_h
	drop column Domain

END
GO	

alter table users
add Domain VARCHAR(63) NULL
go
alter table users_h
Add Domain VARCHAR(63) NULL
go


/****** Object:  Trigger [TRG_USERS_DEL_H]    Script Date: 12/20/2012 09:45:42 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_USERS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_USERS_DEL_H]
GO



/****** Object:  Trigger [dbo].[TRG_USERS_DEL_H]    Script Date: 12/20/2012 09:45:45 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER  [dbo].[TRG_USERS_DEL_H]
on  [dbo].[USERS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[USERS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_ID]
, [USERNAME]
, [FULL_NAME]
, [PASSWORD]
, [PASSWORD_CREATE_DATE]
, [PASSWORD_CHANGE_DATE]
, [PASSWORD_EXPIRE_DATE]
, [ACCOUNT_EXPIRE_DATE]
, [ACCOUNT_LOCK_DATE]
, [INITIAL_LOGIN_DATE]
, [NUMBER_OF_LOGIN_ATTEMPTS]
, [AGREEMENT_SIGNATURE_CODE]
, [SIGNATURE_VERIFIED_IND]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [MAIDEN_NAME]
, [EMPLOYEE_NUMBER]
, [JOB_TITLE]
, [EMAIL_ADDRESS]
, [TELEPHONE_NUMBER]
, [FAX_NUMBER]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [Domain]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [USER_ID]
, [USERNAME]
, [FULL_NAME]
, [PASSWORD]
, [PASSWORD_CREATE_DATE]
, [PASSWORD_CHANGE_DATE]
, [PASSWORD_EXPIRE_DATE]
, [ACCOUNT_EXPIRE_DATE]
, [ACCOUNT_LOCK_DATE]
, [INITIAL_LOGIN_DATE]
, [NUMBER_OF_LOGIN_ATTEMPTS]
, [AGREEMENT_SIGNATURE_CODE]
, [SIGNATURE_VERIFIED_IND]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [MAIDEN_NAME]
, [EMPLOYEE_NUMBER]
, [JOB_TITLE]
, [EMAIL_ADDRESS]
, [TELEPHONE_NUMBER]
, [FAX_NUMBER]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [Domain]
From Deleted
End

GO


/****** Object:  Trigger [TRG_USERS_H]    Script Date: 12/20/2012 09:46:59 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_USERS_H]'))
DROP TRIGGER [dbo].[TRG_USERS_H]
GO


/****** Object:  Trigger [dbo].[TRG_USERS_H]    Script Date: 12/20/2012 09:47:05 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

Create trigger [dbo].[TRG_USERS_H] on [dbo].[USERS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[USERS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [USER_ID]
, [USERNAME]
, [FULL_NAME]
, [PASSWORD]
, [PASSWORD_CREATE_DATE]
, [PASSWORD_CHANGE_DATE]
, [PASSWORD_EXPIRE_DATE]
, [ACCOUNT_EXPIRE_DATE]
, [ACCOUNT_LOCK_DATE]
, [INITIAL_LOGIN_DATE]
, [NUMBER_OF_LOGIN_ATTEMPTS]
, [AGREEMENT_SIGNATURE_CODE]
, [SIGNATURE_VERIFIED_IND]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [MAIDEN_NAME]
, [EMPLOYEE_NUMBER]
, [JOB_TITLE]
, [EMAIL_ADDRESS]
, [TELEPHONE_NUMBER]
, [FAX_NUMBER]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [Domain]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [USER_ID]
, [USERNAME]
, [FULL_NAME]
, [PASSWORD]
, [PASSWORD_CREATE_DATE]
, [PASSWORD_CHANGE_DATE]
, [PASSWORD_EXPIRE_DATE]
, [ACCOUNT_EXPIRE_DATE]
, [ACCOUNT_LOCK_DATE]
, [INITIAL_LOGIN_DATE]
, [NUMBER_OF_LOGIN_ATTEMPTS]
, [AGREEMENT_SIGNATURE_CODE]
, [SIGNATURE_VERIFIED_IND]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [MAIDEN_NAME]
, [EMPLOYEE_NUMBER]
, [JOB_TITLE]
, [EMAIL_ADDRESS]
, [TELEPHONE_NUMBER]
, [FAX_NUMBER]
, [INACTIVE_FLAG]
, [INACTIVE_DATE]
, [CREATEDBY]
, [CREATED]
, [UPDATEDBY]
, [UPDATED]
, [Domain]
FROM INSERTED
End

GO


begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'079'
           ,0
           ,'Add a new column - Domain to USERS table'
		   ,'Alter table dbo.USERS to add a new column'
           ,'BCR'
           ,GETDATE())
end
GO