/*
    Sherry Wang 11/20/2012
	TBI Instruments #1754: Add ProviderID and SiteID to each Survey 
		- Alter table dbo.SURVEYS to remove some unused columns and add some new columns
*/


IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SURVEYS_AUTHOR]') AND parent_object_id = OBJECT_ID(N'[dbo].[SURVEYS]'))
ALTER TABLE [dbo].[SURVEYS] DROP CONSTRAINT [FK_SURVEYS_AUTHOR]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SURVEYS_PROVIDER]') AND parent_object_id = OBJECT_ID(N'[dbo].[SURVEYS]'))
ALTER TABLE [dbo].[SURVEYS] DROP CONSTRAINT [FK_SURVEYS_PROVIDER]
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_SURVEYS_STD_INSTITUTION]') AND parent_object_id = OBJECT_ID(N'[dbo].[SURVEYS]'))
ALTER TABLE [dbo].[SURVEYS] DROP CONSTRAINT [FK_SURVEYS_STD_INSTITUTION]
GO

if exists(Select * from sys.columns where name='PROVIDER_FIRST_NAME' and object_id=object_id('SURVEYS'))
BEGIN
	Alter table dbo.SURVEYS
	DROP column PROVIDER_ID, PROVIDER_FIRST_NAME, PROVIDER_MIDDLE_NAME,
				PROVIDER_LAST_NAME, AUTHOR_ID, AUTHOR_FIRST_NAME, 
				AUTHOR_MIDDLE_NAME, AUTHOR_LAST_NAME
END
GO	

if exists(Select * from sys.columns where name='AUTHOR_DUZ' and object_id=object_id('SURVEYS'))
BEGIN
	Alter table dbo.SURVEYS
	DROP column STD_INSTITUTION_ID, PROVIDER_ID, AUTHOR_ID, 
				PROVIDER_DUZ, AUTHOR_DUZ	
END
GO	

ALTER TABLE dbo.SURVEYS
	ADD STD_INSTITUTION_ID INT NULL,
		PROVIDER_ID INT NULL,
		PROVIDER_DUZ VARCHAR(20),
		AUTHOR_ID INT NULL,
		AUTHOR_DUZ VARCHAR(20)
GO

ALTER TABLE [dbo].[SURVEYS]  WITH CHECK ADD  CONSTRAINT [FK_SURVEYS_PROVIDER] FOREIGN KEY([PROVIDER_ID])
REFERENCES [dbo].[PROVIDER] ([PROVIDER_ID])
GO

		
ALTER TABLE [dbo].[SURVEYS]  WITH CHECK ADD  CONSTRAINT [FK_SURVEYS_AUTHOR] FOREIGN KEY([AUTHOR_ID])
REFERENCES [dbo].[PROVIDER] ([PROVIDER_ID])
GO

ALTER TABLE [dbo].[SURVEYS]  WITH CHECK ADD  CONSTRAINT [FK_SURVEYS_STD_INSTITUTION] FOREIGN KEY([STD_INSTITUTION_ID])
REFERENCES [dbo].[STD_INSTITUTION] ([ID])
GO


	
if exists(Select * from sys.columns where name='PROVIDER_FIRST_NAME' and object_id=object_id('SURVEYS_H'))
BEGIN
	Alter table dbo.SURVEYS_H
	DROP column PROVIDER_ID, PROVIDER_FIRST_NAME, PROVIDER_MIDDLE_NAME,
				PROVIDER_LAST_NAME, AUTHOR_ID, AUTHOR_FIRST_NAME, 
				AUTHOR_MIDDLE_NAME, AUTHOR_LAST_NAME	
END

if exists(Select * from sys.columns where name='AUTHOR_DUZ' and object_id=object_id('SURVEYS_H'))
BEGIN
	Alter table dbo.SURVEYS_H
	DROP column STD_INSTITUTION_ID, PROVIDER_ID, AUTHOR_ID, 
				PROVIDER_DUZ, AUTHOR_DUZ	
END

ALTER TABLE dbo.SURVEYS_H
	ADD STD_INSTITUTION_ID INT NULL,
		PROVIDER_ID INT NULL,
		PROVIDER_DUZ VARCHAR(20),
		AUTHOR_ID INT NULL,
		AUTHOR_DUZ VARCHAR(20)
GO
	
IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_SURVEYS_H]'))
DROP TRIGGER [dbo].[TRG_SURVEYS_H]
GO
Create trigger [dbo].[TRG_SURVEYS_H] on [dbo].[SURVEYS]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [dbo].[SURVEYS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [patient_ICN]
, [STD_INSTITUTION_ID]
, [PROVIDER_ID]
, [PROVIDER_DUZ]
, [AUTHOR_ID]
, [AUTHOR_DUZ]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [patient_ICN]
, [STD_INSTITUTION_ID]
, [PROVIDER_ID]
, [PROVIDER_DUZ]
, [AUTHOR_ID]
, [AUTHOR_DUZ]

FROM INSERTED
End
GO
IF EXISTS(SELECT * FROM sys.triggers WHERE object_id=OBJECT_ID(N'[dbo].[TRG_SURVEYS_DEL_H]'))
DROP TRIGGER [dbo].[TRG_SURVEYS_DEL_H]
go
CREATE TRIGGER  [dbo].[TRG_SURVEYS_DEL_H]
on  [dbo].[SURVEYS] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [dbo].[SURVEYS_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [patient_ICN]
, [STD_INSTITUTION_ID]
, [PROVIDER_ID]
, [PROVIDER_DUZ]
, [AUTHOR_ID]
, [AUTHOR_DUZ]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [SURVEYS_ID]
, [SURVEY_DATE]
, [SURVEY_STATUS]
, [STD_SURVEY_TYPE_ID]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [patient_ICN]
, [STD_INSTITUTION_ID]
, [PROVIDER_ID]
, [PROVIDER_DUZ]
, [AUTHOR_ID]
, [AUTHOR_DUZ]

From Deleted
End
go


begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'078'
           ,0
           ,'TBI Instruments #1754: Add ProviderID and SiteID to each Survey'
		   ,'Alter table dbo.SURVEYS to removed some unused columns and add some new columns'
           ,'TBI Instruments'
           ,GETDATE())
end
GO