/*
    Sherry Wang 11/14/2012
	dbo.MDWS_LOG is missing in PATRIOT-REGDEV database.  Recreate the table.

*/

IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDWS_LOG]') AND type in (N'U'))
BEGIN

	IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[MDWSLOG_STDREG_FK]') AND parent_object_id = OBJECT_ID(N'[dbo].[MDWS_LOG]'))
	ALTER TABLE [dbo].[MDWS_LOG] DROP CONSTRAINT [MDWSLOG_STDREG_FK]

	CREATE TABLE [dbo].[MDWS_LOG](
				[CALL_ID] [int] IDENTITY(1,1) NOT NULL,
				[STD_REGISTRY_ID] [int] NOT NULL,
				[SERVICE_NAME] [varchar](50) NOT NULL,
				[SENT] [datetime] NOT NULL,
				[PARAMETERS] [varchar](max) NULL,
				[RETURNED_DATA] [varchar](max) NULL,
				[ERROR_LEVEL] [int] NULL,
				[CREATED] [datetime] NOT NULL,
				[UPDATED] [datetime] NOT NULL,
				[CREATEDBY] [varchar](30) NOT NULL,
				[UPDATEDBY] [varchar](30) NOT NULL,
				[ROW_VERSION] [timestamp] NOT NULL,
	CONSTRAINT [MDWSLOG_PK] PRIMARY KEY NONCLUSTERED 
	(
				[CALL_ID] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]


	SET ANSI_PADDING OFF

	ALTER TABLE [dbo].[MDWS_LOG]  WITH CHECK ADD  CONSTRAINT [MDWSLOG_STDREG_FK] FOREIGN KEY([STD_REGISTRY_ID])
	REFERENCES [dbo].[STD_REGISTRY] ([ID])

	ALTER TABLE [dbo].[MDWS_LOG] CHECK CONSTRAINT [MDWSLOG_STDREG_FK]
END
GO


begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'077'
           ,0
           ,'Create table dbo.MDWS_LOG'
		   ,'dbo.MDWS_LOG is missing in PATRIOT-REGDEV database.  Recreate the table.'
           ,'TBI Instrument'
           ,GETDATE())
end
GO