/*
    Sherry Wang 11/5/2012
	EFR #1730: Create new Risk Category 
		- Update function [dbo].[CalcRiskCategory] for the new risk category
*/


/****** Object:  UserDefinedFunction [dbo].[CalcRiskCategory]    Script Date: 11/5/2012 11:59:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CalcRiskCategory]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[CalcRiskCategory]
GO

CREATE FUNCTION [dbo].[CalcRiskCategory](
 @BlastExplosionInjury int, -- (3)
 @BulletInjury int, -- (4) 
 @FragmentsInBody int, -- (9) 
 @FragmentsOnRadiograph int, -- (12) 
 @FragmentsRemovedInSurgery int, -- (13)
 @Referral_ID int
)
RETURNS int
AS
BEGIN

  DECLARE @Return int
  DECLARE @UnScreen int
  DECLARE @HltFac int
  DECLARE @HealthFactorCount int
  DECLARE @CreatedBy varchar(30)
  SET @Return = NULL
  
  SELECT @CreatedBy = CREATEDBY 
  FROM REFERRAL 
  WHERE REFERRAL_ID = @Referral_ID
  
 
  if @CreatedBy = 'ETL Process' 
	set @HealthFactorCount = 1
  else   -- Manual Referral
	  select @HealthFactorCount = count(*)
	  from dbo.REFERRAL_DETAIL
	  where referral_id = @Referral_ID
		AND STD_HEALTHFACTOR_ID in (3, 4, 20, 21)
  
  if (@HealthFactorCount = 0)
	SET @Return = 14  -- No health factor present (14)
  else
	begin
  
	  if @BlastExplosionInjury is NULL SET @BlastExplosionInjury = 0 
	  if @BulletInjury is NULL SET @BulletInjury = 0
	  if @FragmentsInBody is NULL SET @FragmentsInBody = 0
	  if @FragmentsOnRadiograph is NULL SET @FragmentsOnRadiograph = 0
	  if @FragmentsRemovedInSurgery is NULL SET @FragmentsRemovedInSurgery = 0
	  

	  select  @UnScreen = v.HF_REFUSED_SCREENING_TOOL + V.HF_UNABLE_TO_SCREEN_DUE_TO_ACUTE_ILLNESS + V.HF_SEVERE_CHRONIC_COGNITIVE_IMPAIRMENT
	  from vwEFRHealthFactorsByReferral_Helper v where v.referral_id = @Referral_ID
	  
	  select @HltFac = (v.HF_BULLET_INJURY + v.HF_NO_BULLET_INJURY + v.HF_BLAST_EXPLOSION_INJURY + v.HF_NO_BLAST_OR_EXPLOSION_INJURY + v.HF_IN_VEHICLE +
			 v.HF_NOT_IN_VEHICLE + v.HF_IED + v.HF_RPG + v.HF_GRENADE + v.HF_LAND_MINE + v.HF_ENEMY_FIRE + v.HF_FRIENDLY_FIRE + v.HF_BLAST_SOURCE_OTHER +
			 v.HF_BLAST_SOURCE_UNKNOWN + v.HF_FRAGMENTS_NOT_REMOVED_IN_SURGERY + v.HF_FRAGMENTS_REMOVED_IN_SURGERY + v.HF_UNKNOWN_IF_REMOVED_IN_SURGERY +
			 v.HF_FRAGMENTS_NOT_SENT_TO_LAB + v.HF_FRAGMENTS_SENT_TO_LAB + v.HF_UNKNOWN_IF_SENT_TO_LAB + v.HF_FRAGMENTS_IN_BODY + v.HF_NO_FRAGMENTS_IN_BODY +
			 v.HF_UNKNOWN_IF_FRAGMENTS_IN_BODY + v.HF_FRAGMENTS_ON_RADIOGRAPH + v.HF_NO_FRAGMENTS_ON_RADIOGRAPH + v.HF_UNKNOWN_IF_FRAGMENTS_ON_RADIOGRAPH  ) 
	  from vwEFRHealthFactorsByReferral_Helper v where v.referral_id = @Referral_ID


	  if (@BlastExplosionInjury = 1 OR @BulletInjury = 1) AND ((@FragmentsInBody = 1 AND @FragmentsOnRadiograph = 1) OR @FragmentsRemovedInSurgery = 1) 
		SET @Return = 2 -- Likely
	  else if (@BlastExplosionInjury = 1 OR @BulletInjury = 1) AND (@FragmentsInBody = 1) AND (@FragmentsOnRadiograph = 0) AND (@FragmentsRemovedInSurgery = 0) 
		SET @Return = 7 -- Highly Likely
	  else if (@BlastExplosionInjury = 1 OR @BulletInjury = 1) AND (@FragmentsInBody = 0) AND (@FragmentsRemovedInSurgery = 0) 
		SET @Return = 9 -- Not Likely
	  else if (@UnScreen > 0) and (@HltFac = 0)
		SET @Return = 13 --Unable to Screen
	  else 
		SET @Return = 12 -- Documented
  end

RETURN @Return

END



GO



begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'076'
           ,0
           ,'EFR #1730: Create new Risk Category'
		   ,'Update function [dbo].[CalcRiskCategory] for the new risk category.'
           ,'EFR'
           ,GETDATE())
end
GO