/****** Object:  StoredProcedure [dbo].[EFRDataExportReferral]    Script Date: 09/19/2012 14:53:57 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EFRDataExportReferral]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[EFRDataExportReferral]
GO

/****** Object:  StoredProcedure [dbo].[EFRDataExportReferral]    Script Date: 09/19/2012 14:53:57 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
    Sherry Wang 5/23/2012
	EFR Tracker #1587: The "Created By" column is not avaialble in "Referrals" export      
		- Add a new column [Created By] to stored procedure EFRDataExportReferral
    
    Sherry Wang 5/22/2012
	EFR Tracker #1583: Add DoD Fragment Data indicator to Referral export    
		- Add a new column [Has DoD Frag Data] to stored procedure EFRDataExportReferral
*/

CREATE PROCEDURE [dbo].[EFRDataExportReferral]
AS
BEGIN

    SELECT r.REFERRAL_ID, stat.NAME AS REFERRAL_STATUS, r.COMMENT_TEXT AS INELIGIBILITY_REASON, 
    wkf.WKF_CASE_ID AS WORKFLOW_ID, casetype.Name AS WORKFLOW_TYPE, p.SSN, p.PATIENT_ICN, p.LAST_NAME, 
    p.FIRST_NAME, p.MIDDLE_NAME, CONVERT(varchar, p.BIRTH_DATE, 101) AS BIRTH_DATE, 
    CONVERT(varchar, r.REFERRAL_DATE, 101) AS REFERRAL_DATE, CONVERT(varchar, r.CREATED, 101) AS DATE_SENT_TO_TEFSC, 
    CONVERT(varchar, r.REVIEW_DATE, 101) AS REVIEW_DATE, r.REVIEW_BY, 
    rem.CODE AS RISK_CATEGORY_CODE, rem.DESCRIPTION_TEXT AS RISK_CATEGORY_DESCRIPTION,
    inst.NAME AS REFERRAL_VAMC_NAME, inst.STATIONNUMBER AS REFERRAL_VAMC_NUMBER, r.ADDRESS_LINE1, 
    r.ADDRESS_LINE2, r.ADDRESS_LINE3, r.CITY, r.STATE, substring(ISNULL(r.POSTAL_CODE,'     '), 1, 5) as POSTAL_CODE,
    ZIP_PLUS_4 =
      CASE CHARINDEX('-',ISNULL(r.POSTAL_CODE,'     '))
         WHEN 0 THEN ''
         ELSE SUBSTRING(ISNULL(r.POSTAL_CODE,'     '), CHARINDEX('-',ISNULL(r.POSTAL_CODE,'     ')) +1, 4)
      END,                      
    r.COUNTRY, r.VAMC_CONTACT_NAME, 
    r.VAMC_CONTACT_EMAIL, r.VAMC_CONTACT_PHONE, r.VAMC_CONTACT_FAX, 
    vw.HF_BLAST_SOURCE_OTHER, vw.HF_BLAST_SOURCE_OTHER_COMMENT, 
    vw.HF_BLAST_SOURCE_UNKNOWN, vw.HF_BLAST_EXPLOSION_INJURY, 
    vw.HF_BULLET_INJURY, 
    vw.HF_ENEMY_FIRE, vw.HF_FRAGMENTS_IN_BODY, 
    vw.HF_FRAGMENTS_NOT_REMOVED_IN_SURGERY AS HF_FRAGMENTS_NOT_REMOVED_IN_SURG, 
    vw.HF_FRAGMENTS_NOT_SENT_TO_LAB, vw.HF_FRAGMENTS_ON_RADIOGRAPH, 
    vw.HF_FRAGMENTS_REMOVED_IN_SURGERY, vw.HF_FRAGMENTS_SENT_TO_LAB, 
    vw.HF_FRIENDLY_FIRE, vw.HF_GRENADE, vw.HF_IED, 
    vw.HF_IN_VEHICLE, vw.HF_LAND_MINE, 
    vw.HF_NO_BLAST_OR_EXPLOSION_INJURY, vw.HF_NO_BULLET_INJURY, 
    vw.HF_NO_FRAGMENTS_IN_BODY, vw.HF_NO_FRAGMENTS_ON_RADIOGRAPH, 
    vw.HF_NOT_IN_VEHICLE, vw.HF_REFUSED_SCREENING_TOOL, 
    vw.HF_RPG, vw.HF_UNKNOWN_IF_FRAGMENTS_IN_BODY, 
    vw.HF_UNKNOWN_IF_FRAGMENTS_ON_RADIOGRAPH AS HF_UNKNOW_IF_FRAGS_ON_RADIOGRAPH, 
    vw.HF_UNKNOWN_IF_REMOVED_IN_SURGERY, vw.HF_UNKNOWN_IF_SENT_TO_LAB, 
    vw.HF_EMBEDDED_FRAGMENTS_PRESENT, 
    vw.HF_EMBEDDED_FRAGMENTS_PRESENT_COMMENT AS HF_EMBEDDED_FRAGS_PRESNT_COMMENT, 
    vw.HF_NO_EMBEDDED_FRAGMENTS, 
    vw.HF_UNABLE_TO_SCREEN_DUE_TO_ACUTE_ILLNESS AS HF_UNABLE_TO_SCRN_ACUTE_ILL, 
    vw.HF_UNABLE_TO_SCREEN_DUE_TO_ACUTE_ILLNESS_COMMENT AS HF_UNABLE_TO_SCRN_ACUTE_ILL_COMM, 
    vw.HF_SEVERE_CHRONIC_COGNITIVE_IMPAIRMENT AS HF_SEVERE_CHRON_COG_IMPAIR, 
    vw.HF_SEVERE_CHRONIC_COGNITIVE_IMPAIRMENT_COMMENT AS HF_SEVERE_CHRON_COG_IMPAIR_COMM,
    CASE ISNULL(DF.PATIENTSSN, '0')
    WHEN '0' THEN 0 ELSE 1
    END as [Has DoD Frag Data],
    r.CREATEDBY as [Created By]
FROM REFERRAL r LEFT JOIN WKF_CASE wkf ON r.Referral_ID = wkf.Referral_ID
    LEFT JOIN STD_WKFCASETYPE casetype ON wkf.STD_WKFCASETYPE_ID = casetype.ID 
    INNER JOIN STD_REFERRALSTS stat ON r.STD_REFERRALSTS_ID = stat.ID 
    INNER JOIN STD_REGISTRY reg ON r.STD_REGISTRY_ID = reg.ID 
    INNER JOIN PATIENT p ON r.PATIENT_ID = p.PATIENT_ID
    LEFT OUTER JOIN (select patientssn=REPLACE(PATIENTSSN, '-', '') from EFR.DoD_FRAGMENT_DATA_RECEIVELOG group by REPLACE(PATIENTSSN, '-', '') ) as DF ON REPLACE(P.SSN, '-', '') = REPLACE(DF.PATIENTSSN, '-', '')  
    LEFT OUTER JOIN vwEFRHealthFactorsByReferral vw ON r.REFERRAL_ID = vw.Referral_ID 
    LEFT OUTER JOIN STD_REMINDERCLASS rem ON 
     dbo.CalcRiskCategory(vw.HF_BLAST_EXPLOSION_INJURY, vw.HF_BULLET_INJURY, vw.HF_FRAGMENTS_IN_BODY, vw.HF_FRAGMENTS_ON_RADIOGRAPH, 
      vw.HF_FRAGMENTS_REMOVED_IN_SURGERY, VW.Referral_ID) = rem.ID
    LEFT OUTER JOIN STD_INSTITUTION inst ON r.STD_INSTITUTION_ID = inst.ID
  WHERE reg.ID = 1 

END

GO

begin

  Insert into [dbo].[DatabaseChangeLog]
      ([MajorReleaseNumber]
       , [MinorReleaseNumber]
       , [PointReleaseNumber]
       , [Hotfix]
       , [ScriptName]
       , [ScriptDescription]
       , [TargetRegistry]
       , [DateApplied])
  Values
      ('05'
       ,'00'
       ,'073'
       ,0
       ,'EFR Tracker #1737: '
       ,'Change Left outer JOIN '
       ,'EFR'
      ,GETDATE())

End



GO


