
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_LABORDER]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_LABORDER]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



-- =============================================
-- Author:        Jim Hagerty
-- Create date: 08/20/2010
-- Description:   Proc for Lab Order SSRS
-- =============================================
CREATE PROCEDURE [dbo].[usp_EFR_LABORDER]
      @activityId int
AS
BEGIN
          
          
          SELECT
          WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID,
          EFR.LAB_ORDER.LAB_ORDER_ID,
          PATIENT.PATIENT_ID,
          WKF_CASE.WKF_CASE_ID,
          PATIENT.STD_SERVICEBRANCH_ID,
          PATIENT.SERVICE_STATUS,
          STD_SERVICEBRANCH.NAME,
          PATIENT.FIRST_NAME,
          PATIENT.MIDDLE_NAME,
          PATIENT.LAST_NAME,
          PATIENT.SSN,
          EFR.LAB_ORDER.SAMPLE_DESC,
          EFR.LAB_ORDER.SPECIAL_INSTRUCTION,
          EFR.LAB_ORDER.BSO_NUMBER
          FROM WKF_CASE_ACTIVITY
          INNER JOIN
          EFR.LAB_ORDER ON WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = EFR.LAB_ORDER.WKF_CASE_ACTIVITY_ID
          INNER JOIN
          WKF_CASE ON WKF_CASE_ACTIVITY.WKF_CASE_ID = WKF_CASE.WKF_CASE_ID
          INNER JOIN
          PATIENT ON WKF_CASE.PATIENT_ID = PATIENT.PATIENT_ID
          Left JOIN
          STD_SERVICEBRANCH ON PATIENT.STD_SERVICEBRANCH_ID = STD_SERVICEBRANCH.ID
          WHERE     (WKF_CASE_ACTIVITY.WKF_CASE_ACTIVITY_ID = @activityId)
                              AND (WKF_CASE_ACTIVITY.ARCHIVED_FLAG = 0) --Added per bug tracker #1539
        
        
        
      END





GO
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'070'
           ,0
           ,'usp_Lab_order'
		   ,'Corrects a situation where no rows would be returned if there is no Service branch'
           ,'EFR'
           ,GETDATE())
end