/*
    Sherry Wang 7/11/2012
	VITAS Tracker #1677: User Messaging and Web Application Control - VITAS         
		- Add role and apppages / role permissions for System Availability page
*/

DECLARE @systemPageId int, @VITASAdminRoleId int

if Not exists(select * from STD_APPPAGE where Code = 'VITAS_SYSTEM_AVAILABILITY')
begin
  INSERT INTO STD_APPPAGE([CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED])
  VALUES ('VITAS_SYSTEM_AVAILABILITY', 'VITAS System Availability', 'VITAS System Availability', 1, 0, NULL, 'Increment 5', getdate(), 'Increment 5', getdate())
  SELECT @systemPageId = @@IDENTITY
end
else
begin
  SELECT @systemPageId = ID FROM STD_APPPAGE WHERE Code = 'VITAS_SYSTEM_AVAILABILITY'
end

SELECT @VITASAdminRoleId = ID FROM STD_ROLE WHERE CODE = 'VITAS_Admin'

if Not exists(select * from ROLE_PERMISSIONS where STD_ROLE_ID = @VITASAdminRoleId AND STD_APPPAGE_ID = @systemPageId)
	INSERT INTO ROLE_PERMISSIONS([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
	VALUES(@VITASAdminRoleId, @systemPageId, 'Increment 5', 'Increment 5', getdate(), getdate(), 1, 1, 1)

go

begin
INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('05'
           ,'00'
           ,'066'
           ,0
           ,'VITAS Tracker #1677: User Messaging and Web Application Control - VITAS '
		   ,'Add role and apppages / role permissions for System Availability page'
           ,'VITAS'
           ,GETDATE())
end
GO